package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.BaseTaskList;
import odata.msgraph.client.beta.entity.request.BaseTaskListRequest;
import odata.msgraph.client.beta.entity.request.BaseTaskRequest;
import odata.msgraph.client.beta.entity.request.ExtensionRequest;

public class BaseTaskListCollectionRequest extends CollectionPageEntityRequest<BaseTaskList, BaseTaskListRequest>{

    protected ContextPath contextPath;

    public BaseTaskListCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, BaseTaskList.class, cp -> new BaseTaskListRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ExtensionRequest extensions(String id) {
        return new ExtensionRequest(contextPath.addSegment("extensions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ExtensionCollectionRequest extensions() {
        return new ExtensionCollectionRequest(contextPath.addSegment("extensions"), Optional.empty());
    }

    public BaseTaskRequest tasks(String id) {
        return new BaseTaskRequest(contextPath.addSegment("tasks").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public BaseTaskCollectionRequest tasks() {
        return new BaseTaskCollectionRequest(contextPath.addSegment("tasks"), Optional.empty());
    }

    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<BaseTaskList> delta() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), BaseTaskList.class, _parameters);
    }

}
