package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.BaseTask;
import odata.msgraph.client.beta.entity.request.BaseTaskRequest;
import odata.msgraph.client.beta.entity.request.ChecklistItemRequest;
import odata.msgraph.client.beta.entity.request.ExtensionRequest;
import odata.msgraph.client.beta.entity.request.LinkedResource_v2Request;

public class BaseTaskCollectionRequest extends CollectionPageEntityRequest<BaseTask, BaseTaskRequest>{

    protected ContextPath contextPath;

    public BaseTaskCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, BaseTask.class, cp -> new BaseTaskRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ChecklistItemRequest checklistItems(String id) {
        return new ChecklistItemRequest(contextPath.addSegment("checklistItems").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ChecklistItemCollectionRequest checklistItems() {
        return new ChecklistItemCollectionRequest(contextPath.addSegment("checklistItems"), Optional.empty());
    }

    public ExtensionRequest extensions(String id) {
        return new ExtensionRequest(contextPath.addSegment("extensions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ExtensionCollectionRequest extensions() {
        return new ExtensionCollectionRequest(contextPath.addSegment("extensions"), Optional.empty());
    }

    public LinkedResource_v2Request linkedResources(String id) {
        return new LinkedResource_v2Request(contextPath.addSegment("linkedResources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public LinkedResource_v2CollectionRequest linkedResources() {
        return new LinkedResource_v2CollectionRequest(contextPath.addSegment("linkedResources"), Optional.empty());
    }

    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<BaseTask> delta() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), BaseTask.class, _parameters);
    }

}
