package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.B2xIdentityUserFlow;
import odata.msgraph.client.beta.entity.request.B2xIdentityUserFlowRequest;
import odata.msgraph.client.beta.entity.request.IdentityProviderBaseRequest;
import odata.msgraph.client.beta.entity.request.IdentityProviderRequest;
import odata.msgraph.client.beta.entity.request.IdentityUserFlowAttributeAssignmentRequest;
import odata.msgraph.client.beta.entity.request.UserFlowLanguageConfigurationRequest;

public class B2xIdentityUserFlowCollectionRequest extends CollectionPageEntityRequest<B2xIdentityUserFlow, B2xIdentityUserFlowRequest>{

    protected ContextPath contextPath;

    public B2xIdentityUserFlowCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, B2xIdentityUserFlow.class, cp -> new B2xIdentityUserFlowRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public IdentityProviderRequest identityProviders(String id) {
        return new IdentityProviderRequest(contextPath.addSegment("identityProviders").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public IdentityProviderCollectionRequest identityProviders() {
        return new IdentityProviderCollectionRequest(contextPath.addSegment("identityProviders"), Optional.empty());
    }

    public UserFlowLanguageConfigurationRequest languages(String id) {
        return new UserFlowLanguageConfigurationRequest(contextPath.addSegment("languages").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserFlowLanguageConfigurationCollectionRequest languages() {
        return new UserFlowLanguageConfigurationCollectionRequest(contextPath.addSegment("languages"), Optional.empty());
    }

    public IdentityUserFlowAttributeAssignmentRequest userAttributeAssignments(String id) {
        return new IdentityUserFlowAttributeAssignmentRequest(contextPath.addSegment("userAttributeAssignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public IdentityUserFlowAttributeAssignmentCollectionRequest userAttributeAssignments() {
        return new IdentityUserFlowAttributeAssignmentCollectionRequest(contextPath.addSegment("userAttributeAssignments"), Optional.empty());
    }

    public IdentityProviderBaseRequest userFlowIdentityProviders(String id) {
        return new IdentityProviderBaseRequest(contextPath.addSegment("userFlowIdentityProviders").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public IdentityProviderBaseCollectionRequest userFlowIdentityProviders() {
        return new IdentityProviderBaseCollectionRequest(contextPath.addSegment("userFlowIdentityProviders"), Optional.empty());
    }

}
