package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AuditEvent;
import odata.msgraph.client.beta.entity.request.AuditEventRequest;

public class AuditEventCollectionRequest extends CollectionPageEntityRequest<AuditEvent, AuditEventRequest>{

    protected ContextPath contextPath;

    public AuditEventCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, AuditEvent.class, cp -> new AuditEventRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Function(name = "getAuditActivityTypes")
    @JsonIgnore
    public CollectionPageNonEntityRequest<String> getAuditActivityTypes(String category) {
        Preconditions.checkNotNull(category, "category cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("category", "Edm.String", Checks.checkIsAscii(category))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getAuditActivityTypes"), String.class, _parameters);
    }

    @Function(name = "getAuditCategories")
    @JsonIgnore
    public CollectionPageNonEntityRequest<String> getAuditCategories() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getAuditCategories"), String.class, _parameters);
    }

}
