package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ApprovalWorkflowProvider;
import odata.msgraph.client.beta.entity.request.ApprovalWorkflowProviderRequest;
import odata.msgraph.client.beta.entity.request.BusinessFlowRequest;
import odata.msgraph.client.beta.entity.request.GovernancePolicyTemplateRequest;

public class ApprovalWorkflowProviderCollectionRequest extends CollectionPageEntityRequest<ApprovalWorkflowProvider, ApprovalWorkflowProviderRequest>{

    protected ContextPath contextPath;

    public ApprovalWorkflowProviderCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ApprovalWorkflowProvider.class, cp -> new ApprovalWorkflowProviderRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public BusinessFlowRequest businessFlows(String id) {
        return new BusinessFlowRequest(contextPath.addSegment("businessFlows").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public BusinessFlowCollectionRequest businessFlows() {
        return new BusinessFlowCollectionRequest(contextPath.addSegment("businessFlows"), Optional.empty());
    }

    public BusinessFlowRequest businessFlowsWithRequestsAwaitingMyDecision(String id) {
        return new BusinessFlowRequest(contextPath.addSegment("businessFlowsWithRequestsAwaitingMyDecision").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public BusinessFlowCollectionRequest businessFlowsWithRequestsAwaitingMyDecision() {
        return new BusinessFlowCollectionRequest(contextPath.addSegment("businessFlowsWithRequestsAwaitingMyDecision"), Optional.empty());
    }

    public GovernancePolicyTemplateRequest policyTemplates(String id) {
        return new GovernancePolicyTemplateRequest(contextPath.addSegment("policyTemplates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GovernancePolicyTemplateCollectionRequest policyTemplates() {
        return new GovernancePolicyTemplateCollectionRequest(contextPath.addSegment("policyTemplates"), Optional.empty());
    }

}
