package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Application;
import odata.msgraph.client.beta.entity.request.AppManagementPolicyRequest;
import odata.msgraph.client.beta.entity.request.ApplicationRequest;
import odata.msgraph.client.beta.entity.request.DirectoryObjectRequest;
import odata.msgraph.client.beta.entity.request.ExtensionPropertyRequest;
import odata.msgraph.client.beta.entity.request.FederatedIdentityCredentialRequest;
import odata.msgraph.client.beta.entity.request.HomeRealmDiscoveryPolicyRequest;
import odata.msgraph.client.beta.entity.request.TokenIssuancePolicyRequest;
import odata.msgraph.client.beta.entity.request.TokenLifetimePolicyRequest;

public class ApplicationCollectionRequest extends CollectionPageEntityRequest<Application, ApplicationRequest>{

    protected ContextPath contextPath;

    public ApplicationCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Application.class, cp -> new ApplicationRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AppManagementPolicyRequest appManagementPolicies(String id) {
        return new AppManagementPolicyRequest(contextPath.addSegment("appManagementPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AppManagementPolicyCollectionRequest appManagementPolicies() {
        return new AppManagementPolicyCollectionRequest(contextPath.addSegment("appManagementPolicies"), Optional.empty());
    }

    public ExtensionPropertyRequest extensionProperties(String id) {
        return new ExtensionPropertyRequest(contextPath.addSegment("extensionProperties").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ExtensionPropertyCollectionRequest extensionProperties() {
        return new ExtensionPropertyCollectionRequest(contextPath.addSegment("extensionProperties"), Optional.empty());
    }

    public FederatedIdentityCredentialRequest federatedIdentityCredentials(String id) {
        return new FederatedIdentityCredentialRequest(contextPath.addSegment("federatedIdentityCredentials").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public FederatedIdentityCredentialCollectionRequest federatedIdentityCredentials() {
        return new FederatedIdentityCredentialCollectionRequest(contextPath.addSegment("federatedIdentityCredentials"), Optional.empty());
    }

    public HomeRealmDiscoveryPolicyRequest homeRealmDiscoveryPolicies(String id) {
        return new HomeRealmDiscoveryPolicyRequest(contextPath.addSegment("homeRealmDiscoveryPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public HomeRealmDiscoveryPolicyCollectionRequest homeRealmDiscoveryPolicies() {
        return new HomeRealmDiscoveryPolicyCollectionRequest(contextPath.addSegment("homeRealmDiscoveryPolicies"), Optional.empty());
    }

    public DirectoryObjectRequest owners(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("owners").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest owners() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("owners"), Optional.empty());
    }

    public TokenIssuancePolicyRequest tokenIssuancePolicies(String id) {
        return new TokenIssuancePolicyRequest(contextPath.addSegment("tokenIssuancePolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TokenIssuancePolicyCollectionRequest tokenIssuancePolicies() {
        return new TokenIssuancePolicyCollectionRequest(contextPath.addSegment("tokenIssuancePolicies"), Optional.empty());
    }

    public TokenLifetimePolicyRequest tokenLifetimePolicies(String id) {
        return new TokenLifetimePolicyRequest(contextPath.addSegment("tokenLifetimePolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TokenLifetimePolicyCollectionRequest tokenLifetimePolicies() {
        return new TokenLifetimePolicyCollectionRequest(contextPath.addSegment("tokenLifetimePolicies"), Optional.empty());
    }

    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Application> delta() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), Application.class, _parameters);
    }

}
