package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AppManagementPolicy;
import odata.msgraph.client.beta.entity.request.AppManagementPolicyRequest;
import odata.msgraph.client.beta.entity.request.DirectoryObjectRequest;

public class AppManagementPolicyCollectionRequest extends CollectionPageEntityRequest<AppManagementPolicy, AppManagementPolicyRequest>{

    protected ContextPath contextPath;

    public AppManagementPolicyCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, AppManagementPolicy.class, cp -> new AppManagementPolicyRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DirectoryObjectRequest appliesTo(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("appliesTo").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest appliesTo() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("appliesTo"), Optional.empty());
    }

}
