package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.HasPayloadLinkResultItem;
import odata.msgraph.client.beta.entity.AndroidManagedAppProtection;
import odata.msgraph.client.beta.entity.request.AndroidManagedAppProtectionRequest;
import odata.msgraph.client.beta.entity.request.ManagedMobileAppRequest;

public class AndroidManagedAppProtectionCollectionRequest extends CollectionPageEntityRequest<AndroidManagedAppProtection, AndroidManagedAppProtectionRequest>{

    protected ContextPath contextPath;

    public AndroidManagedAppProtectionCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, AndroidManagedAppProtection.class, cp -> new AndroidManagedAppProtectionRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ManagedMobileAppRequest apps(String id) {
        return new ManagedMobileAppRequest(contextPath.addSegment("apps").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedMobileAppCollectionRequest apps() {
        return new ManagedMobileAppCollectionRequest(contextPath.addSegment("apps"), Optional.empty());
    }

    @Action(name = "hasPayloadLinks")
    @JsonIgnore
    public CollectionPageNonEntityRequest<HasPayloadLinkResultItem> hasPayloadLinks(List<String> payloadIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("payloadIds", "Collection(Edm.String)", Checks.checkIsAscii(payloadIds))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.hasPayloadLinks"), HasPayloadLinkResultItem.class, _parameters);
    }

}
