package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AgreementFileLocalization;
import odata.msgraph.client.beta.entity.request.AgreementFileLocalizationRequest;
import odata.msgraph.client.beta.entity.request.AgreementFileVersionRequest;

public class AgreementFileLocalizationCollectionRequest extends CollectionPageEntityRequest<AgreementFileLocalization, AgreementFileLocalizationRequest>{

    protected ContextPath contextPath;

    public AgreementFileLocalizationCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, AgreementFileLocalization.class, cp -> new AgreementFileLocalizationRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AgreementFileVersionRequest versions(String id) {
        return new AgreementFileVersionRequest(contextPath.addSegment("versions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AgreementFileVersionCollectionRequest versions() {
        return new AgreementFileVersionCollectionRequest(contextPath.addSegment("versions"), Optional.empty());
    }

}
