package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Agreement;
import odata.msgraph.client.beta.entity.request.AgreementAcceptanceRequest;
import odata.msgraph.client.beta.entity.request.AgreementFileLocalizationRequest;
import odata.msgraph.client.beta.entity.request.AgreementRequest;

public class AgreementCollectionRequest extends CollectionPageEntityRequest<Agreement, AgreementRequest>{

    protected ContextPath contextPath;

    public AgreementCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Agreement.class, cp -> new AgreementRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AgreementAcceptanceRequest acceptances(String id) {
        return new AgreementAcceptanceRequest(contextPath.addSegment("acceptances").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AgreementAcceptanceCollectionRequest acceptances() {
        return new AgreementAcceptanceCollectionRequest(contextPath.addSegment("acceptances"), Optional.empty());
    }

    public AgreementFileLocalizationRequest files(String id) {
        return new AgreementFileLocalizationRequest(contextPath.addSegment("files").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AgreementFileLocalizationCollectionRequest files() {
        return new AgreementFileLocalizationCollectionRequest(contextPath.addSegment("files"), Optional.empty());
    }

}
