package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AdministrativeUnit;
import odata.msgraph.client.beta.entity.request.AdministrativeUnitRequest;
import odata.msgraph.client.beta.entity.request.DirectoryObjectRequest;
import odata.msgraph.client.beta.entity.request.ExtensionRequest;
import odata.msgraph.client.beta.entity.request.ScopedRoleMembershipRequest;

public class AdministrativeUnitCollectionRequest extends CollectionPageEntityRequest<AdministrativeUnit, AdministrativeUnitRequest>{

    protected ContextPath contextPath;

    public AdministrativeUnitCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, AdministrativeUnit.class, cp -> new AdministrativeUnitRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DirectoryObjectRequest members(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("members").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest members() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("members"), Optional.empty());
    }

    public ScopedRoleMembershipRequest scopedRoleMembers(String id) {
        return new ScopedRoleMembershipRequest(contextPath.addSegment("scopedRoleMembers").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ScopedRoleMembershipCollectionRequest scopedRoleMembers() {
        return new ScopedRoleMembershipCollectionRequest(contextPath.addSegment("scopedRoleMembers"), Optional.empty());
    }

    public ExtensionRequest extensions(String id) {
        return new ExtensionRequest(contextPath.addSegment("extensions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ExtensionCollectionRequest extensions() {
        return new ExtensionCollectionRequest(contextPath.addSegment("extensions"), Optional.empty());
    }

    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AdministrativeUnit> delta() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), AdministrativeUnit.class, _parameters);
    }

}
