package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AccessReviewInstance;
import odata.msgraph.client.beta.entity.request.AccessReviewInstanceDecisionItemRequest;
import odata.msgraph.client.beta.entity.request.AccessReviewInstanceRequest;
import odata.msgraph.client.beta.entity.request.AccessReviewReviewerRequest;
import odata.msgraph.client.beta.entity.request.AccessReviewStageRequest;
import odata.msgraph.client.beta.enums.AccessReviewInstanceFilterByCurrentUserOptions;

public class AccessReviewInstanceCollectionRequest extends CollectionPageEntityRequest<AccessReviewInstance, AccessReviewInstanceRequest>{

    protected ContextPath contextPath;

    public AccessReviewInstanceCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, AccessReviewInstance.class, cp -> new AccessReviewInstanceRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AccessReviewReviewerRequest contactedReviewers(String id) {
        return new AccessReviewReviewerRequest(contextPath.addSegment("contactedReviewers").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessReviewReviewerCollectionRequest contactedReviewers() {
        return new AccessReviewReviewerCollectionRequest(contextPath.addSegment("contactedReviewers"), Optional.empty());
    }

    public AccessReviewInstanceDecisionItemRequest decisions(String id) {
        return new AccessReviewInstanceDecisionItemRequest(contextPath.addSegment("decisions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessReviewInstanceDecisionItemCollectionRequest decisions() {
        return new AccessReviewInstanceDecisionItemCollectionRequest(contextPath.addSegment("decisions"), Optional.empty());
    }

    public AccessReviewStageRequest stages(String id) {
        return new AccessReviewStageRequest(contextPath.addSegment("stages").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessReviewStageCollectionRequest stages() {
        return new AccessReviewStageCollectionRequest(contextPath.addSegment("stages"), Optional.empty());
    }

    @Function(name = "filterByCurrentUser")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AccessReviewInstance> filterByCurrentUser(AccessReviewInstanceFilterByCurrentUserOptions on) {
        Preconditions.checkNotNull(on, "on cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("on", "microsoft.graph.accessReviewInstanceFilterByCurrentUserOptions", on)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.filterByCurrentUser"), AccessReviewInstance.class, _parameters);
    }

}
