package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AccessReview;
import odata.msgraph.client.beta.entity.request.AccessReviewDecisionRequest;
import odata.msgraph.client.beta.entity.request.AccessReviewRequest;
import odata.msgraph.client.beta.entity.request.AccessReviewReviewerRequest;

public class AccessReviewCollectionRequest extends CollectionPageEntityRequest<AccessReview, AccessReviewRequest>{

    protected ContextPath contextPath;

    public AccessReviewCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, AccessReview.class, cp -> new AccessReviewRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AccessReviewDecisionRequest decisions(String id) {
        return new AccessReviewDecisionRequest(contextPath.addSegment("decisions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessReviewDecisionCollectionRequest decisions() {
        return new AccessReviewDecisionCollectionRequest(contextPath.addSegment("decisions"), Optional.empty());
    }

    public AccessReviewRequest instances(String id) {
        return new AccessReviewRequest(contextPath.addSegment("instances").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessReviewCollectionRequest instances() {
        return new AccessReviewCollectionRequest(contextPath.addSegment("instances"), Optional.empty());
    }

    public AccessReviewDecisionRequest myDecisions(String id) {
        return new AccessReviewDecisionRequest(contextPath.addSegment("myDecisions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessReviewDecisionCollectionRequest myDecisions() {
        return new AccessReviewDecisionCollectionRequest(contextPath.addSegment("myDecisions"), Optional.empty());
    }

    public AccessReviewReviewerRequest reviewers(String id) {
        return new AccessReviewReviewerRequest(contextPath.addSegment("reviewers").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessReviewReviewerCollectionRequest reviewers() {
        return new AccessReviewReviewerCollectionRequest(contextPath.addSegment("reviewers"), Optional.empty());
    }

}
