package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AccessPackageResourceEnvironment;
import odata.msgraph.client.beta.entity.request.AccessPackageResourceEnvironmentRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageResourceRequest;

public class AccessPackageResourceEnvironmentCollectionRequest extends CollectionPageEntityRequest<AccessPackageResourceEnvironment, AccessPackageResourceEnvironmentRequest>{

    protected ContextPath contextPath;

    public AccessPackageResourceEnvironmentCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, AccessPackageResourceEnvironment.class, cp -> new AccessPackageResourceEnvironmentRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AccessPackageResourceRequest accessPackageResources(String id) {
        return new AccessPackageResourceRequest(contextPath.addSegment("accessPackageResources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageResourceCollectionRequest accessPackageResources() {
        return new AccessPackageResourceCollectionRequest(contextPath.addSegment("accessPackageResources"), Optional.empty());
    }

}
