package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AccessPackageResource;
import odata.msgraph.client.beta.entity.request.AccessPackageResourceRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageResourceRoleRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageResourceScopeRequest;

public class AccessPackageResourceCollectionRequest extends CollectionPageEntityRequest<AccessPackageResource, AccessPackageResourceRequest>{

    protected ContextPath contextPath;

    public AccessPackageResourceCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, AccessPackageResource.class, cp -> new AccessPackageResourceRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AccessPackageResourceRoleRequest accessPackageResourceRoles(String id) {
        return new AccessPackageResourceRoleRequest(contextPath.addSegment("accessPackageResourceRoles").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageResourceRoleCollectionRequest accessPackageResourceRoles() {
        return new AccessPackageResourceRoleCollectionRequest(contextPath.addSegment("accessPackageResourceRoles"), Optional.empty());
    }

    public AccessPackageResourceScopeRequest accessPackageResourceScopes(String id) {
        return new AccessPackageResourceScopeRequest(contextPath.addSegment("accessPackageResourceScopes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageResourceScopeCollectionRequest accessPackageResourceScopes() {
        return new AccessPackageResourceScopeCollectionRequest(contextPath.addSegment("accessPackageResourceScopes"), Optional.empty());
    }

}
