package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AccessPackageAssignmentRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageAssignmentRequestRequest;
import odata.msgraph.client.beta.enums.AccessPackageAssignmentRequestFilterByCurrentUserOptions;

public class AccessPackageAssignmentRequestCollectionRequest extends CollectionPageEntityRequest<AccessPackageAssignmentRequest, AccessPackageAssignmentRequestRequest>{

    protected ContextPath contextPath;

    public AccessPackageAssignmentRequestCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, AccessPackageAssignmentRequest.class, cp -> new AccessPackageAssignmentRequestRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Function(name = "filterByCurrentUser")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AccessPackageAssignmentRequest> filterByCurrentUser(AccessPackageAssignmentRequestFilterByCurrentUserOptions on) {
        Preconditions.checkNotNull(on, "on cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("on", "microsoft.graph.accessPackageAssignmentRequestFilterByCurrentUserOptions", on)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.filterByCurrentUser"), AccessPackageAssignmentRequest.class, _parameters);
    }

}
