package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AccessPackageAssignment;
import odata.msgraph.client.beta.entity.request.AccessPackageAssignmentRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageAssignmentRequestRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageAssignmentResourceRoleRequest;
import odata.msgraph.client.beta.enums.AccessPackageAssignmentFilterByCurrentUserOptions;

public class AccessPackageAssignmentCollectionRequest extends CollectionPageEntityRequest<AccessPackageAssignment, AccessPackageAssignmentRequest>{

    protected ContextPath contextPath;

    public AccessPackageAssignmentCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, AccessPackageAssignment.class, cp -> new AccessPackageAssignmentRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AccessPackageAssignmentRequestRequest accessPackageAssignmentRequests(String id) {
        return new AccessPackageAssignmentRequestRequest(contextPath.addSegment("accessPackageAssignmentRequests").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageAssignmentRequestCollectionRequest accessPackageAssignmentRequests() {
        return new AccessPackageAssignmentRequestCollectionRequest(contextPath.addSegment("accessPackageAssignmentRequests"), Optional.empty());
    }

    public AccessPackageAssignmentResourceRoleRequest accessPackageAssignmentResourceRoles(String id) {
        return new AccessPackageAssignmentResourceRoleRequest(contextPath.addSegment("accessPackageAssignmentResourceRoles").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageAssignmentResourceRoleCollectionRequest accessPackageAssignmentResourceRoles() {
        return new AccessPackageAssignmentResourceRoleCollectionRequest(contextPath.addSegment("accessPackageAssignmentResourceRoles"), Optional.empty());
    }

    @Function(name = "filterByCurrentUser")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AccessPackageAssignment> filterByCurrentUser(AccessPackageAssignmentFilterByCurrentUserOptions on) {
        Preconditions.checkNotNull(on, "on cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("on", "microsoft.graph.accessPackageAssignmentFilterByCurrentUserOptions", on)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.filterByCurrentUser"), AccessPackageAssignment.class, _parameters);
    }

}
