package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.WorkbookTableColumnCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WorkbookTableRowCollectionRequest;
import odata.msgraph.client.beta.entity.request.WorkbookTableSortRequest;
import odata.msgraph.client.beta.entity.request.WorkbookWorksheetRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "highlightFirstColumn", 
    "highlightLastColumn", 
    "legacyId", 
    "name", 
    "showBandedColumns", 
    "showBandedRows", 
    "showFilterButton", 
    "showHeaders", 
    "showTotals", 
    "style", 
    "columns", 
    "rows", 
    "sort", 
    "worksheet"})
@JsonInclude(Include.NON_NULL)
public class WorkbookTable extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbookTable";
    }

    @JsonProperty("highlightFirstColumn")
    protected Boolean highlightFirstColumn;

    @JsonProperty("highlightLastColumn")
    protected Boolean highlightLastColumn;

    @JsonProperty("legacyId")
    protected String legacyId;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("showBandedColumns")
    protected Boolean showBandedColumns;

    @JsonProperty("showBandedRows")
    protected Boolean showBandedRows;

    @JsonProperty("showFilterButton")
    protected Boolean showFilterButton;

    @JsonProperty("showHeaders")
    protected Boolean showHeaders;

    @JsonProperty("showTotals")
    protected Boolean showTotals;

    @JsonProperty("style")
    protected String style;

    @JsonProperty("columns")
    protected List<WorkbookTableColumn> columns;

    @JsonProperty("rows")
    protected List<WorkbookTableRow> rows;

    @JsonProperty("sort")
    protected WorkbookTableSort sort;

    @JsonProperty("worksheet")
    protected WorkbookWorksheet worksheet;

    protected WorkbookTable() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWorkbookTable() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean highlightFirstColumn;
        private Boolean highlightLastColumn;
        private String legacyId;
        private String name;
        private Boolean showBandedColumns;
        private Boolean showBandedRows;
        private Boolean showFilterButton;
        private Boolean showHeaders;
        private Boolean showTotals;
        private String style;
        private List<WorkbookTableColumn> columns;
        private List<WorkbookTableRow> rows;
        private WorkbookTableSort sort;
        private WorkbookWorksheet worksheet;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder highlightFirstColumn(Boolean highlightFirstColumn) {
            this.highlightFirstColumn = highlightFirstColumn;
            this.changedFields = changedFields.add("highlightFirstColumn");
            return this;
        }

        public Builder highlightLastColumn(Boolean highlightLastColumn) {
            this.highlightLastColumn = highlightLastColumn;
            this.changedFields = changedFields.add("highlightLastColumn");
            return this;
        }

        public Builder legacyId(String legacyId) {
            this.legacyId = legacyId;
            this.changedFields = changedFields.add("legacyId");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder showBandedColumns(Boolean showBandedColumns) {
            this.showBandedColumns = showBandedColumns;
            this.changedFields = changedFields.add("showBandedColumns");
            return this;
        }

        public Builder showBandedRows(Boolean showBandedRows) {
            this.showBandedRows = showBandedRows;
            this.changedFields = changedFields.add("showBandedRows");
            return this;
        }

        public Builder showFilterButton(Boolean showFilterButton) {
            this.showFilterButton = showFilterButton;
            this.changedFields = changedFields.add("showFilterButton");
            return this;
        }

        public Builder showHeaders(Boolean showHeaders) {
            this.showHeaders = showHeaders;
            this.changedFields = changedFields.add("showHeaders");
            return this;
        }

        public Builder showTotals(Boolean showTotals) {
            this.showTotals = showTotals;
            this.changedFields = changedFields.add("showTotals");
            return this;
        }

        public Builder style(String style) {
            this.style = style;
            this.changedFields = changedFields.add("style");
            return this;
        }

        public Builder columns(List<WorkbookTableColumn> columns) {
            this.columns = columns;
            this.changedFields = changedFields.add("columns");
            return this;
        }

        public Builder columns(WorkbookTableColumn... columns) {
            return columns(Arrays.asList(columns));
        }

        public Builder rows(List<WorkbookTableRow> rows) {
            this.rows = rows;
            this.changedFields = changedFields.add("rows");
            return this;
        }

        public Builder rows(WorkbookTableRow... rows) {
            return rows(Arrays.asList(rows));
        }

        public Builder sort(WorkbookTableSort sort) {
            this.sort = sort;
            this.changedFields = changedFields.add("sort");
            return this;
        }

        public Builder worksheet(WorkbookWorksheet worksheet) {
            this.worksheet = worksheet;
            this.changedFields = changedFields.add("worksheet");
            return this;
        }

        public WorkbookTable build() {
            WorkbookTable _x = new WorkbookTable();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.workbookTable";
            _x.id = id;
            _x.highlightFirstColumn = highlightFirstColumn;
            _x.highlightLastColumn = highlightLastColumn;
            _x.legacyId = legacyId;
            _x.name = name;
            _x.showBandedColumns = showBandedColumns;
            _x.showBandedRows = showBandedRows;
            _x.showFilterButton = showFilterButton;
            _x.showHeaders = showHeaders;
            _x.showTotals = showTotals;
            _x.style = style;
            _x.columns = columns;
            _x.rows = rows;
            _x.sort = sort;
            _x.worksheet = worksheet;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="highlightFirstColumn")
    @JsonIgnore
    public Optional<Boolean> getHighlightFirstColumn() {
        return Optional.ofNullable(highlightFirstColumn);
    }

    public WorkbookTable withHighlightFirstColumn(Boolean highlightFirstColumn) {
        WorkbookTable _x = _copy();
        _x.changedFields = changedFields.add("highlightFirstColumn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookTable");
        _x.highlightFirstColumn = highlightFirstColumn;
        return _x;
    }

    @Property(name="highlightLastColumn")
    @JsonIgnore
    public Optional<Boolean> getHighlightLastColumn() {
        return Optional.ofNullable(highlightLastColumn);
    }

    public WorkbookTable withHighlightLastColumn(Boolean highlightLastColumn) {
        WorkbookTable _x = _copy();
        _x.changedFields = changedFields.add("highlightLastColumn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookTable");
        _x.highlightLastColumn = highlightLastColumn;
        return _x;
    }

    @Property(name="legacyId")
    @JsonIgnore
    public Optional<String> getLegacyId() {
        return Optional.ofNullable(legacyId);
    }

    public WorkbookTable withLegacyId(String legacyId) {
        WorkbookTable _x = _copy();
        _x.changedFields = changedFields.add("legacyId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookTable");
        _x.legacyId = legacyId;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public WorkbookTable withName(String name) {
        WorkbookTable _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookTable");
        _x.name = name;
        return _x;
    }

    @Property(name="showBandedColumns")
    @JsonIgnore
    public Optional<Boolean> getShowBandedColumns() {
        return Optional.ofNullable(showBandedColumns);
    }

    public WorkbookTable withShowBandedColumns(Boolean showBandedColumns) {
        WorkbookTable _x = _copy();
        _x.changedFields = changedFields.add("showBandedColumns");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookTable");
        _x.showBandedColumns = showBandedColumns;
        return _x;
    }

    @Property(name="showBandedRows")
    @JsonIgnore
    public Optional<Boolean> getShowBandedRows() {
        return Optional.ofNullable(showBandedRows);
    }

    public WorkbookTable withShowBandedRows(Boolean showBandedRows) {
        WorkbookTable _x = _copy();
        _x.changedFields = changedFields.add("showBandedRows");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookTable");
        _x.showBandedRows = showBandedRows;
        return _x;
    }

    @Property(name="showFilterButton")
    @JsonIgnore
    public Optional<Boolean> getShowFilterButton() {
        return Optional.ofNullable(showFilterButton);
    }

    public WorkbookTable withShowFilterButton(Boolean showFilterButton) {
        WorkbookTable _x = _copy();
        _x.changedFields = changedFields.add("showFilterButton");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookTable");
        _x.showFilterButton = showFilterButton;
        return _x;
    }

    @Property(name="showHeaders")
    @JsonIgnore
    public Optional<Boolean> getShowHeaders() {
        return Optional.ofNullable(showHeaders);
    }

    public WorkbookTable withShowHeaders(Boolean showHeaders) {
        WorkbookTable _x = _copy();
        _x.changedFields = changedFields.add("showHeaders");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookTable");
        _x.showHeaders = showHeaders;
        return _x;
    }

    @Property(name="showTotals")
    @JsonIgnore
    public Optional<Boolean> getShowTotals() {
        return Optional.ofNullable(showTotals);
    }

    public WorkbookTable withShowTotals(Boolean showTotals) {
        WorkbookTable _x = _copy();
        _x.changedFields = changedFields.add("showTotals");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookTable");
        _x.showTotals = showTotals;
        return _x;
    }

    @Property(name="style")
    @JsonIgnore
    public Optional<String> getStyle() {
        return Optional.ofNullable(style);
    }

    public WorkbookTable withStyle(String style) {
        WorkbookTable _x = _copy();
        _x.changedFields = changedFields.add("style");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookTable");
        _x.style = style;
        return _x;
    }

    public WorkbookTable withUnmappedField(String name, Object value) {
        WorkbookTable _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="columns")
    @JsonIgnore
    public WorkbookTableColumnCollectionRequest getColumns() {
        return new WorkbookTableColumnCollectionRequest(
                        contextPath.addSegment("columns"), Optional.ofNullable(columns));
    }

    @NavigationProperty(name="rows")
    @JsonIgnore
    public WorkbookTableRowCollectionRequest getRows() {
        return new WorkbookTableRowCollectionRequest(
                        contextPath.addSegment("rows"), Optional.ofNullable(rows));
    }

    @NavigationProperty(name="sort")
    @JsonIgnore
    public WorkbookTableSortRequest getSort() {
        return new WorkbookTableSortRequest(contextPath.addSegment("sort"), Optional.ofNullable(sort));
    }

    @NavigationProperty(name="worksheet")
    @JsonIgnore
    public WorkbookWorksheetRequest getWorksheet() {
        return new WorkbookWorksheetRequest(contextPath.addSegment("worksheet"), Optional.ofNullable(worksheet));
    }

    public WorkbookTable withColumns(List<WorkbookTableColumn> columns) {
        WorkbookTable _x = _copy();
        _x.changedFields = changedFields.add("columns");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookTable");
        _x.columns = columns;
        return _x;
    }

    public WorkbookTable withRows(List<WorkbookTableRow> rows) {
        WorkbookTable _x = _copy();
        _x.changedFields = changedFields.add("rows");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookTable");
        _x.rows = rows;
        return _x;
    }

    public WorkbookTable withSort(WorkbookTableSort sort) {
        WorkbookTable _x = _copy();
        _x.changedFields = changedFields.add("sort");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookTable");
        _x.sort = sort;
        return _x;
    }

    public WorkbookTable withWorksheet(WorkbookWorksheet worksheet) {
        WorkbookTable _x = _copy();
        _x.changedFields = changedFields.add("worksheet");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookTable");
        _x.worksheet = worksheet;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookTable patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WorkbookTable _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookTable put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WorkbookTable _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WorkbookTable _copy() {
        WorkbookTable _x = new WorkbookTable();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.highlightFirstColumn = highlightFirstColumn;
        _x.highlightLastColumn = highlightLastColumn;
        _x.legacyId = legacyId;
        _x.name = name;
        _x.showBandedColumns = showBandedColumns;
        _x.showBandedRows = showBandedRows;
        _x.showFilterButton = showFilterButton;
        _x.showHeaders = showHeaders;
        _x.showTotals = showTotals;
        _x.style = style;
        _x.columns = columns;
        _x.rows = rows;
        _x.sort = sort;
        _x.worksheet = worksheet;
        return _x;
    }

    @Action(name = "clearFilters")
    @JsonIgnore
    public ActionRequestNoReturn clearFilters() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.clearFilters"), _parameters);
    }

    @Action(name = "convertToRange")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookRange> convertToRange() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.convertToRange"), WorkbookRange.class, _parameters);
    }

    @Action(name = "reapplyFilters")
    @JsonIgnore
    public ActionRequestNoReturn reapplyFilters() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reapplyFilters"), _parameters);
    }

    @Function(name = "dataBodyRange")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> dataBodyRange() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.dataBodyRange"), WorkbookRange.class, _parameters);
    }

    @Function(name = "headerRowRange")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> headerRowRange() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.headerRowRange"), WorkbookRange.class, _parameters);
    }

    @Function(name = "range")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> range() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.range"), WorkbookRange.class, _parameters);
    }

    @Function(name = "totalRowRange")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange> totalRowRange() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRange>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.totalRowRange"), WorkbookRange.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkbookTable[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("highlightFirstColumn=");
        b.append(this.highlightFirstColumn);
        b.append(", ");
        b.append("highlightLastColumn=");
        b.append(this.highlightLastColumn);
        b.append(", ");
        b.append("legacyId=");
        b.append(this.legacyId);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("showBandedColumns=");
        b.append(this.showBandedColumns);
        b.append(", ");
        b.append("showBandedRows=");
        b.append(this.showBandedRows);
        b.append(", ");
        b.append("showFilterButton=");
        b.append(this.showFilterButton);
        b.append(", ");
        b.append("showHeaders=");
        b.append(this.showHeaders);
        b.append(", ");
        b.append("showTotals=");
        b.append(this.showTotals);
        b.append(", ");
        b.append("style=");
        b.append(this.style);
        b.append(", ");
        b.append("columns=");
        b.append(this.columns);
        b.append(", ");
        b.append("rows=");
        b.append(this.rows);
        b.append(", ");
        b.append("sort=");
        b.append(this.sort);
        b.append(", ");
        b.append("worksheet=");
        b.append(this.worksheet);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
