package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "formulaHidden", 
    "locked"})
@JsonInclude(Include.NON_NULL)
public class WorkbookFormatProtection extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbookFormatProtection";
    }

    @JsonProperty("formulaHidden")
    protected Boolean formulaHidden;

    @JsonProperty("locked")
    protected Boolean locked;

    protected WorkbookFormatProtection() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWorkbookFormatProtection() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean formulaHidden;
        private Boolean locked;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder formulaHidden(Boolean formulaHidden) {
            this.formulaHidden = formulaHidden;
            this.changedFields = changedFields.add("formulaHidden");
            return this;
        }

        public Builder locked(Boolean locked) {
            this.locked = locked;
            this.changedFields = changedFields.add("locked");
            return this;
        }

        public WorkbookFormatProtection build() {
            WorkbookFormatProtection _x = new WorkbookFormatProtection();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.workbookFormatProtection";
            _x.id = id;
            _x.formulaHidden = formulaHidden;
            _x.locked = locked;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="formulaHidden")
    @JsonIgnore
    public Optional<Boolean> getFormulaHidden() {
        return Optional.ofNullable(formulaHidden);
    }

    public WorkbookFormatProtection withFormulaHidden(Boolean formulaHidden) {
        WorkbookFormatProtection _x = _copy();
        _x.changedFields = changedFields.add("formulaHidden");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookFormatProtection");
        _x.formulaHidden = formulaHidden;
        return _x;
    }

    @Property(name="locked")
    @JsonIgnore
    public Optional<Boolean> getLocked() {
        return Optional.ofNullable(locked);
    }

    public WorkbookFormatProtection withLocked(Boolean locked) {
        WorkbookFormatProtection _x = _copy();
        _x.changedFields = changedFields.add("locked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookFormatProtection");
        _x.locked = locked;
        return _x;
    }

    public WorkbookFormatProtection withUnmappedField(String name, Object value) {
        WorkbookFormatProtection _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookFormatProtection patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WorkbookFormatProtection _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookFormatProtection put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WorkbookFormatProtection _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WorkbookFormatProtection _copy() {
        WorkbookFormatProtection _x = new WorkbookFormatProtection();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.formulaHidden = formulaHidden;
        _x.locked = locked;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkbookFormatProtection[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("formulaHidden=");
        b.append(this.formulaHidden);
        b.append(", ");
        b.append("locked=");
        b.append(this.locked);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
