package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.WorkbookChartFillRequest;
import odata.msgraph.client.beta.entity.request.WorkbookChartLineFormatRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "fill", 
    "line"})
@JsonInclude(Include.NON_NULL)
public class WorkbookChartSeriesFormat extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbookChartSeriesFormat";
    }

    @JsonProperty("fill")
    protected WorkbookChartFill fill;

    @JsonProperty("line")
    protected WorkbookChartLineFormat line;

    protected WorkbookChartSeriesFormat() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWorkbookChartSeriesFormat() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private WorkbookChartFill fill;
        private WorkbookChartLineFormat line;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder fill(WorkbookChartFill fill) {
            this.fill = fill;
            this.changedFields = changedFields.add("fill");
            return this;
        }

        public Builder line(WorkbookChartLineFormat line) {
            this.line = line;
            this.changedFields = changedFields.add("line");
            return this;
        }

        public WorkbookChartSeriesFormat build() {
            WorkbookChartSeriesFormat _x = new WorkbookChartSeriesFormat();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.workbookChartSeriesFormat";
            _x.id = id;
            _x.fill = fill;
            _x.line = line;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public WorkbookChartSeriesFormat withUnmappedField(String name, Object value) {
        WorkbookChartSeriesFormat _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="fill")
    @JsonIgnore
    public WorkbookChartFillRequest getFill() {
        return new WorkbookChartFillRequest(contextPath.addSegment("fill"), Optional.ofNullable(fill));
    }

    @NavigationProperty(name="line")
    @JsonIgnore
    public WorkbookChartLineFormatRequest getLine() {
        return new WorkbookChartLineFormatRequest(contextPath.addSegment("line"), Optional.ofNullable(line));
    }

    public WorkbookChartSeriesFormat withFill(WorkbookChartFill fill) {
        WorkbookChartSeriesFormat _x = _copy();
        _x.changedFields = changedFields.add("fill");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartSeriesFormat");
        _x.fill = fill;
        return _x;
    }

    public WorkbookChartSeriesFormat withLine(WorkbookChartLineFormat line) {
        WorkbookChartSeriesFormat _x = _copy();
        _x.changedFields = changedFields.add("line");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartSeriesFormat");
        _x.line = line;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookChartSeriesFormat patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WorkbookChartSeriesFormat _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookChartSeriesFormat put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WorkbookChartSeriesFormat _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WorkbookChartSeriesFormat _copy() {
        WorkbookChartSeriesFormat _x = new WorkbookChartSeriesFormat();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.fill = fill;
        _x.line = line;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkbookChartSeriesFormat[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("fill=");
        b.append(this.fill);
        b.append(", ");
        b.append("line=");
        b.append(this.line);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
