package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.WorkbookChartAxisRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "categoryAxis", 
    "seriesAxis", 
    "valueAxis"})
@JsonInclude(Include.NON_NULL)
public class WorkbookChartAxes extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbookChartAxes";
    }

    @JsonProperty("categoryAxis")
    protected WorkbookChartAxis categoryAxis;

    @JsonProperty("seriesAxis")
    protected WorkbookChartAxis seriesAxis;

    @JsonProperty("valueAxis")
    protected WorkbookChartAxis valueAxis;

    protected WorkbookChartAxes() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWorkbookChartAxes() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private WorkbookChartAxis categoryAxis;
        private WorkbookChartAxis seriesAxis;
        private WorkbookChartAxis valueAxis;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder categoryAxis(WorkbookChartAxis categoryAxis) {
            this.categoryAxis = categoryAxis;
            this.changedFields = changedFields.add("categoryAxis");
            return this;
        }

        public Builder seriesAxis(WorkbookChartAxis seriesAxis) {
            this.seriesAxis = seriesAxis;
            this.changedFields = changedFields.add("seriesAxis");
            return this;
        }

        public Builder valueAxis(WorkbookChartAxis valueAxis) {
            this.valueAxis = valueAxis;
            this.changedFields = changedFields.add("valueAxis");
            return this;
        }

        public WorkbookChartAxes build() {
            WorkbookChartAxes _x = new WorkbookChartAxes();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.workbookChartAxes";
            _x.id = id;
            _x.categoryAxis = categoryAxis;
            _x.seriesAxis = seriesAxis;
            _x.valueAxis = valueAxis;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public WorkbookChartAxes withUnmappedField(String name, Object value) {
        WorkbookChartAxes _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="categoryAxis")
    @JsonIgnore
    public WorkbookChartAxisRequest getCategoryAxis() {
        return new WorkbookChartAxisRequest(contextPath.addSegment("categoryAxis"), Optional.ofNullable(categoryAxis));
    }

    @NavigationProperty(name="seriesAxis")
    @JsonIgnore
    public WorkbookChartAxisRequest getSeriesAxis() {
        return new WorkbookChartAxisRequest(contextPath.addSegment("seriesAxis"), Optional.ofNullable(seriesAxis));
    }

    @NavigationProperty(name="valueAxis")
    @JsonIgnore
    public WorkbookChartAxisRequest getValueAxis() {
        return new WorkbookChartAxisRequest(contextPath.addSegment("valueAxis"), Optional.ofNullable(valueAxis));
    }

    public WorkbookChartAxes withCategoryAxis(WorkbookChartAxis categoryAxis) {
        WorkbookChartAxes _x = _copy();
        _x.changedFields = changedFields.add("categoryAxis");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartAxes");
        _x.categoryAxis = categoryAxis;
        return _x;
    }

    public WorkbookChartAxes withSeriesAxis(WorkbookChartAxis seriesAxis) {
        WorkbookChartAxes _x = _copy();
        _x.changedFields = changedFields.add("seriesAxis");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartAxes");
        _x.seriesAxis = seriesAxis;
        return _x;
    }

    public WorkbookChartAxes withValueAxis(WorkbookChartAxis valueAxis) {
        WorkbookChartAxes _x = _copy();
        _x.changedFields = changedFields.add("valueAxis");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChartAxes");
        _x.valueAxis = valueAxis;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookChartAxes patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WorkbookChartAxes _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookChartAxes put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WorkbookChartAxes _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WorkbookChartAxes _copy() {
        WorkbookChartAxes _x = new WorkbookChartAxes();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.categoryAxis = categoryAxis;
        _x.seriesAxis = seriesAxis;
        _x.valueAxis = valueAxis;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkbookChartAxes[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("categoryAxis=");
        b.append(this.categoryAxis);
        b.append(", ");
        b.append("seriesAxis=");
        b.append(this.seriesAxis);
        b.append(", ");
        b.append("valueAxis=");
        b.append(this.valueAxis);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
