package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Double;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.Json;
import odata.msgraph.client.beta.entity.collection.request.WorkbookChartSeriesCollectionRequest;
import odata.msgraph.client.beta.entity.request.WorkbookChartAreaFormatRequest;
import odata.msgraph.client.beta.entity.request.WorkbookChartAxesRequest;
import odata.msgraph.client.beta.entity.request.WorkbookChartDataLabelsRequest;
import odata.msgraph.client.beta.entity.request.WorkbookChartLegendRequest;
import odata.msgraph.client.beta.entity.request.WorkbookChartTitleRequest;
import odata.msgraph.client.beta.entity.request.WorkbookWorksheetRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "height", 
    "left", 
    "name", 
    "top", 
    "width", 
    "axes", 
    "dataLabels", 
    "format", 
    "legend", 
    "series", 
    "title", 
    "worksheet"})
@JsonInclude(Include.NON_NULL)
public class WorkbookChart extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbookChart";
    }

    @JsonProperty("height")
    protected Double height;

    @JsonProperty("left")
    protected Double left;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("top")
    protected Double top;

    @JsonProperty("width")
    protected Double width;

    @JsonProperty("axes")
    protected WorkbookChartAxes axes;

    @JsonProperty("dataLabels")
    protected WorkbookChartDataLabels dataLabels;

    @JsonProperty("format")
    protected WorkbookChartAreaFormat format;

    @JsonProperty("legend")
    protected WorkbookChartLegend legend;

    @JsonProperty("series")
    protected List<WorkbookChartSeries> series;

    @JsonProperty("title")
    protected WorkbookChartTitle title;

    @JsonProperty("worksheet")
    protected WorkbookWorksheet worksheet;

    protected WorkbookChart() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWorkbookChart() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Double height;
        private Double left;
        private String name;
        private Double top;
        private Double width;
        private WorkbookChartAxes axes;
        private WorkbookChartDataLabels dataLabels;
        private WorkbookChartAreaFormat format;
        private WorkbookChartLegend legend;
        private List<WorkbookChartSeries> series;
        private WorkbookChartTitle title;
        private WorkbookWorksheet worksheet;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder height(Double height) {
            this.height = height;
            this.changedFields = changedFields.add("height");
            return this;
        }

        public Builder left(Double left) {
            this.left = left;
            this.changedFields = changedFields.add("left");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder top(Double top) {
            this.top = top;
            this.changedFields = changedFields.add("top");
            return this;
        }

        public Builder width(Double width) {
            this.width = width;
            this.changedFields = changedFields.add("width");
            return this;
        }

        public Builder axes(WorkbookChartAxes axes) {
            this.axes = axes;
            this.changedFields = changedFields.add("axes");
            return this;
        }

        public Builder dataLabels(WorkbookChartDataLabels dataLabels) {
            this.dataLabels = dataLabels;
            this.changedFields = changedFields.add("dataLabels");
            return this;
        }

        public Builder format(WorkbookChartAreaFormat format) {
            this.format = format;
            this.changedFields = changedFields.add("format");
            return this;
        }

        public Builder legend(WorkbookChartLegend legend) {
            this.legend = legend;
            this.changedFields = changedFields.add("legend");
            return this;
        }

        public Builder series(List<WorkbookChartSeries> series) {
            this.series = series;
            this.changedFields = changedFields.add("series");
            return this;
        }

        public Builder series(WorkbookChartSeries... series) {
            return series(Arrays.asList(series));
        }

        public Builder title(WorkbookChartTitle title) {
            this.title = title;
            this.changedFields = changedFields.add("title");
            return this;
        }

        public Builder worksheet(WorkbookWorksheet worksheet) {
            this.worksheet = worksheet;
            this.changedFields = changedFields.add("worksheet");
            return this;
        }

        public WorkbookChart build() {
            WorkbookChart _x = new WorkbookChart();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.workbookChart";
            _x.id = id;
            _x.height = height;
            _x.left = left;
            _x.name = name;
            _x.top = top;
            _x.width = width;
            _x.axes = axes;
            _x.dataLabels = dataLabels;
            _x.format = format;
            _x.legend = legend;
            _x.series = series;
            _x.title = title;
            _x.worksheet = worksheet;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="height")
    @JsonIgnore
    public Optional<Double> getHeight() {
        return Optional.ofNullable(height);
    }

    public WorkbookChart withHeight(Double height) {
        WorkbookChart _x = _copy();
        _x.changedFields = changedFields.add("height");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChart");
        _x.height = height;
        return _x;
    }

    @Property(name="left")
    @JsonIgnore
    public Optional<Double> getLeft() {
        return Optional.ofNullable(left);
    }

    public WorkbookChart withLeft(Double left) {
        WorkbookChart _x = _copy();
        _x.changedFields = changedFields.add("left");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChart");
        _x.left = left;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public WorkbookChart withName(String name) {
        WorkbookChart _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChart");
        _x.name = name;
        return _x;
    }

    @Property(name="top")
    @JsonIgnore
    public Optional<Double> getTop() {
        return Optional.ofNullable(top);
    }

    public WorkbookChart withTop(Double top) {
        WorkbookChart _x = _copy();
        _x.changedFields = changedFields.add("top");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChart");
        _x.top = top;
        return _x;
    }

    @Property(name="width")
    @JsonIgnore
    public Optional<Double> getWidth() {
        return Optional.ofNullable(width);
    }

    public WorkbookChart withWidth(Double width) {
        WorkbookChart _x = _copy();
        _x.changedFields = changedFields.add("width");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChart");
        _x.width = width;
        return _x;
    }

    public WorkbookChart withUnmappedField(String name, Object value) {
        WorkbookChart _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="axes")
    @JsonIgnore
    public WorkbookChartAxesRequest getAxes() {
        return new WorkbookChartAxesRequest(contextPath.addSegment("axes"), Optional.ofNullable(axes));
    }

    @NavigationProperty(name="dataLabels")
    @JsonIgnore
    public WorkbookChartDataLabelsRequest getDataLabels() {
        return new WorkbookChartDataLabelsRequest(contextPath.addSegment("dataLabels"), Optional.ofNullable(dataLabels));
    }

    @NavigationProperty(name="format")
    @JsonIgnore
    public WorkbookChartAreaFormatRequest getFormat() {
        return new WorkbookChartAreaFormatRequest(contextPath.addSegment("format"), Optional.ofNullable(format));
    }

    @NavigationProperty(name="legend")
    @JsonIgnore
    public WorkbookChartLegendRequest getLegend() {
        return new WorkbookChartLegendRequest(contextPath.addSegment("legend"), Optional.ofNullable(legend));
    }

    @NavigationProperty(name="series")
    @JsonIgnore
    public WorkbookChartSeriesCollectionRequest getSeries() {
        return new WorkbookChartSeriesCollectionRequest(
                        contextPath.addSegment("series"), Optional.ofNullable(series));
    }

    @NavigationProperty(name="title")
    @JsonIgnore
    public WorkbookChartTitleRequest getTitle() {
        return new WorkbookChartTitleRequest(contextPath.addSegment("title"), Optional.ofNullable(title));
    }

    @NavigationProperty(name="worksheet")
    @JsonIgnore
    public WorkbookWorksheetRequest getWorksheet() {
        return new WorkbookWorksheetRequest(contextPath.addSegment("worksheet"), Optional.ofNullable(worksheet));
    }

    public WorkbookChart withAxes(WorkbookChartAxes axes) {
        WorkbookChart _x = _copy();
        _x.changedFields = changedFields.add("axes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChart");
        _x.axes = axes;
        return _x;
    }

    public WorkbookChart withDataLabels(WorkbookChartDataLabels dataLabels) {
        WorkbookChart _x = _copy();
        _x.changedFields = changedFields.add("dataLabels");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChart");
        _x.dataLabels = dataLabels;
        return _x;
    }

    public WorkbookChart withFormat(WorkbookChartAreaFormat format) {
        WorkbookChart _x = _copy();
        _x.changedFields = changedFields.add("format");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChart");
        _x.format = format;
        return _x;
    }

    public WorkbookChart withLegend(WorkbookChartLegend legend) {
        WorkbookChart _x = _copy();
        _x.changedFields = changedFields.add("legend");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChart");
        _x.legend = legend;
        return _x;
    }

    public WorkbookChart withSeries(List<WorkbookChartSeries> series) {
        WorkbookChart _x = _copy();
        _x.changedFields = changedFields.add("series");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChart");
        _x.series = series;
        return _x;
    }

    public WorkbookChart withTitle(WorkbookChartTitle title) {
        WorkbookChart _x = _copy();
        _x.changedFields = changedFields.add("title");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChart");
        _x.title = title;
        return _x;
    }

    public WorkbookChart withWorksheet(WorkbookWorksheet worksheet) {
        WorkbookChart _x = _copy();
        _x.changedFields = changedFields.add("worksheet");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbookChart");
        _x.worksheet = worksheet;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookChart patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WorkbookChart _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkbookChart put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WorkbookChart _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WorkbookChart _copy() {
        WorkbookChart _x = new WorkbookChart();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.height = height;
        _x.left = left;
        _x.name = name;
        _x.top = top;
        _x.width = width;
        _x.axes = axes;
        _x.dataLabels = dataLabels;
        _x.format = format;
        _x.legend = legend;
        _x.series = series;
        _x.title = title;
        _x.worksheet = worksheet;
        return _x;
    }

    @Action(name = "setData")
    @JsonIgnore
    public ActionRequestNoReturn setData(Json sourceData, String seriesBy) {
        Preconditions.checkNotNull(seriesBy, "seriesBy cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("sourceData", "microsoft.graph.Json", sourceData)
            .put("seriesBy", "Edm.String", Checks.checkIsAscii(seriesBy))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.setData"), _parameters);
    }

    @Action(name = "setPosition")
    @JsonIgnore
    public ActionRequestNoReturn setPosition(Json startCell, Json endCell) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("startCell", "microsoft.graph.Json", startCell)
            .put("endCell", "microsoft.graph.Json", endCell)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.setPosition"), _parameters);
    }

    @Function(name = "image")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<String> image() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.image"), String.class, _parameters);
    }

    @Function(name = "image")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<String> image_Function(Integer width) {
        Preconditions.checkNotNull(width, "width cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("width", "Edm.Int32", width)
            .build();
        return new FunctionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.image"), String.class, _parameters);
    }

    @Function(name = "image")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<String> image_Function_(Integer width, Integer height) {
        Preconditions.checkNotNull(width, "width cannot be null");
        Preconditions.checkNotNull(height, "height cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("width", "Edm.Int32", width)
            .put("height", "Edm.Int32", height)
            .build();
        return new FunctionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.image"), String.class, _parameters);
    }

    @Function(name = "image")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<String> image_Function__(Integer width, Integer height, String fittingMode) {
        Preconditions.checkNotNull(width, "width cannot be null");
        Preconditions.checkNotNull(height, "height cannot be null");
        Preconditions.checkNotNull(fittingMode, "fittingMode cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("width", "Edm.Int32", width)
            .put("height", "Edm.Int32", height)
            .put("fittingMode", "Edm.String", Checks.checkIsAscii(fittingMode))
            .build();
        return new FunctionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.image"), String.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkbookChart[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("height=");
        b.append(this.height);
        b.append(", ");
        b.append("left=");
        b.append(this.left);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("top=");
        b.append(this.top);
        b.append(", ");
        b.append("width=");
        b.append(this.width);
        b.append(", ");
        b.append("axes=");
        b.append(this.axes);
        b.append(", ");
        b.append("dataLabels=");
        b.append(this.dataLabels);
        b.append(", ");
        b.append("format=");
        b.append(this.format);
        b.append(", ");
        b.append("legend=");
        b.append(this.legend);
        b.append(", ");
        b.append("series=");
        b.append(this.series);
        b.append(", ");
        b.append("title=");
        b.append(this.title);
        b.append(", ");
        b.append("worksheet=");
        b.append(this.worksheet);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
