package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.WorkbookSessionInfo;
import odata.msgraph.client.beta.entity.collection.request.WorkbookCommentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WorkbookNamedItemCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WorkbookOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WorkbookTableCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WorkbookWorksheetCollectionRequest;
import odata.msgraph.client.beta.entity.request.WorkbookApplicationRequest;
import odata.msgraph.client.beta.entity.request.WorkbookFunctionsRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "application", 
    "comments", 
    "functions", 
    "names", 
    "operations", 
    "tables", 
    "worksheets"})
@JsonInclude(Include.NON_NULL)
public class Workbook extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workbook";
    }

    @JsonProperty("application")
    protected WorkbookApplication application;

    @JsonProperty("comments")
    protected List<WorkbookComment> comments;

    @JsonProperty("functions")
    protected WorkbookFunctions functions;

    @JsonProperty("names")
    protected List<WorkbookNamedItem> names;

    @JsonProperty("operations")
    protected List<WorkbookOperation> operations;

    @JsonProperty("tables")
    protected List<WorkbookTable> tables;

    @JsonProperty("worksheets")
    protected List<WorkbookWorksheet> worksheets;

    protected Workbook() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWorkbook() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private WorkbookApplication application;
        private List<WorkbookComment> comments;
        private WorkbookFunctions functions;
        private List<WorkbookNamedItem> names;
        private List<WorkbookOperation> operations;
        private List<WorkbookTable> tables;
        private List<WorkbookWorksheet> worksheets;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder application(WorkbookApplication application) {
            this.application = application;
            this.changedFields = changedFields.add("application");
            return this;
        }

        public Builder comments(List<WorkbookComment> comments) {
            this.comments = comments;
            this.changedFields = changedFields.add("comments");
            return this;
        }

        public Builder comments(WorkbookComment... comments) {
            return comments(Arrays.asList(comments));
        }

        public Builder functions(WorkbookFunctions functions) {
            this.functions = functions;
            this.changedFields = changedFields.add("functions");
            return this;
        }

        public Builder names(List<WorkbookNamedItem> names) {
            this.names = names;
            this.changedFields = changedFields.add("names");
            return this;
        }

        public Builder names(WorkbookNamedItem... names) {
            return names(Arrays.asList(names));
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
         * <p>
         * Countable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
         * <p>
         * Filterable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SkipSupported</b>
         * <p>
         * false
         * <p>
         * <b>Org.OData.Capabilities.V1.TopSupported</b>
         * <p>
         * false
         * 
         * @param operations
         *            value of {@code operations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder operations(List<WorkbookOperation> operations) {
            this.operations = operations;
            this.changedFields = changedFields.add("operations");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
         * <p>
         * Countable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
         * <p>
         * Filterable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SkipSupported</b>
         * <p>
         * false
         * <p>
         * <b>Org.OData.Capabilities.V1.TopSupported</b>
         * <p>
         * false
         * 
         * @param operations
         *            value of {@code operations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder operations(WorkbookOperation... operations) {
            return operations(Arrays.asList(operations));
        }

        public Builder tables(List<WorkbookTable> tables) {
            this.tables = tables;
            this.changedFields = changedFields.add("tables");
            return this;
        }

        public Builder tables(WorkbookTable... tables) {
            return tables(Arrays.asList(tables));
        }

        public Builder worksheets(List<WorkbookWorksheet> worksheets) {
            this.worksheets = worksheets;
            this.changedFields = changedFields.add("worksheets");
            return this;
        }

        public Builder worksheets(WorkbookWorksheet... worksheets) {
            return worksheets(Arrays.asList(worksheets));
        }

        public Workbook build() {
            Workbook _x = new Workbook();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.workbook";
            _x.id = id;
            _x.application = application;
            _x.comments = comments;
            _x.functions = functions;
            _x.names = names;
            _x.operations = operations;
            _x.tables = tables;
            _x.worksheets = worksheets;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public Workbook withUnmappedField(String name, Object value) {
        Workbook _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="application")
    @JsonIgnore
    public WorkbookApplicationRequest getApplication() {
        return new WorkbookApplicationRequest(contextPath.addSegment("application"), Optional.ofNullable(application));
    }

    @NavigationProperty(name="comments")
    @JsonIgnore
    public WorkbookCommentCollectionRequest getComments() {
        return new WorkbookCommentCollectionRequest(
                        contextPath.addSegment("comments"), Optional.ofNullable(comments));
    }

    @NavigationProperty(name="functions")
    @JsonIgnore
    public WorkbookFunctionsRequest getFunctions() {
        return new WorkbookFunctionsRequest(contextPath.addSegment("functions"), Optional.ofNullable(functions));
    }

    @NavigationProperty(name="names")
    @JsonIgnore
    public WorkbookNamedItemCollectionRequest getNames() {
        return new WorkbookNamedItemCollectionRequest(
                        contextPath.addSegment("names"), Optional.ofNullable(names));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
     * <p>
     * Countable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
     * <p>
     * Filterable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SkipSupported</b>
     * <p>
     * false
     * <p>
     * <b>Org.OData.Capabilities.V1.TopSupported</b>
     * <p>
     * false
     * 
     * @return navigational property operations
     */
    @NavigationProperty(name="operations")
    @JsonIgnore
    public WorkbookOperationCollectionRequest getOperations() {
        return new WorkbookOperationCollectionRequest(
                        contextPath.addSegment("operations"), Optional.ofNullable(operations));
    }

    @NavigationProperty(name="tables")
    @JsonIgnore
    public WorkbookTableCollectionRequest getTables() {
        return new WorkbookTableCollectionRequest(
                        contextPath.addSegment("tables"), Optional.ofNullable(tables));
    }

    @NavigationProperty(name="worksheets")
    @JsonIgnore
    public WorkbookWorksheetCollectionRequest getWorksheets() {
        return new WorkbookWorksheetCollectionRequest(
                        contextPath.addSegment("worksheets"), Optional.ofNullable(worksheets));
    }

    public Workbook withApplication(WorkbookApplication application) {
        Workbook _x = _copy();
        _x.changedFields = changedFields.add("application");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbook");
        _x.application = application;
        return _x;
    }

    public Workbook withComments(List<WorkbookComment> comments) {
        Workbook _x = _copy();
        _x.changedFields = changedFields.add("comments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbook");
        _x.comments = comments;
        return _x;
    }

    public Workbook withFunctions(WorkbookFunctions functions) {
        Workbook _x = _copy();
        _x.changedFields = changedFields.add("functions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbook");
        _x.functions = functions;
        return _x;
    }

    public Workbook withNames(List<WorkbookNamedItem> names) {
        Workbook _x = _copy();
        _x.changedFields = changedFields.add("names");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbook");
        _x.names = names;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code operations} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
     * <p>
     * Countable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
     * <p>
     * Filterable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SkipSupported</b>
     * <p>
     * false
     * <p>
     * <b>Org.OData.Capabilities.V1.TopSupported</b>
     * <p>
     * false
     * 
     * @param operations
     *            new value of {@code operations} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code operations} field changed
     */
    public Workbook withOperations(List<WorkbookOperation> operations) {
        Workbook _x = _copy();
        _x.changedFields = changedFields.add("operations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbook");
        _x.operations = operations;
        return _x;
    }

    public Workbook withTables(List<WorkbookTable> tables) {
        Workbook _x = _copy();
        _x.changedFields = changedFields.add("tables");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbook");
        _x.tables = tables;
        return _x;
    }

    public Workbook withWorksheets(List<WorkbookWorksheet> worksheets) {
        Workbook _x = _copy();
        _x.changedFields = changedFields.add("worksheets");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workbook");
        _x.worksheets = worksheets;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Workbook patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Workbook _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Workbook put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Workbook _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Workbook _copy() {
        Workbook _x = new Workbook();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.application = application;
        _x.comments = comments;
        _x.functions = functions;
        _x.names = names;
        _x.operations = operations;
        _x.tables = tables;
        _x.worksheets = worksheets;
        return _x;
    }

    @Action(name = "closeSession")
    @JsonIgnore
    public ActionRequestNoReturn closeSession() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.closeSession"), _parameters);
    }

    @Action(name = "createSession")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookSessionInfo> createSession(Boolean persistChanges) {
        Preconditions.checkNotNull(persistChanges, "persistChanges cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("persistChanges", "Edm.Boolean", persistChanges)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookSessionInfo>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createSession"), WorkbookSessionInfo.class, _parameters);
    }

    @Action(name = "refreshSession")
    @JsonIgnore
    public ActionRequestNoReturn refreshSession() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.refreshSession"), _parameters);
    }

    @Function(name = "sessionInfoResource")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookSessionInfo> sessionInfoResource(String key) {
        Preconditions.checkNotNull(key, "key cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("key", "Edm.String", Checks.checkIsAscii(key))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookSessionInfo>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sessionInfoResource"), WorkbookSessionInfo.class, _parameters);
    }

    @Function(name = "tableRowOperationResult")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookTableRow> tableRowOperationResult(String key) {
        Preconditions.checkNotNull(key, "key cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("key", "Edm.String", Checks.checkIsAscii(key))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookTableRow>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.tableRowOperationResult"), WorkbookTableRow.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Workbook[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("application=");
        b.append(this.application);
        b.append(", ");
        b.append("comments=");
        b.append(this.comments);
        b.append(", ");
        b.append("functions=");
        b.append(this.functions);
        b.append(", ");
        b.append("names=");
        b.append(this.names);
        b.append(", ");
        b.append("operations=");
        b.append(this.operations);
        b.append(", ");
        b.append("tables=");
        b.append(this.tables);
        b.append(", ");
        b.append("worksheets=");
        b.append(this.worksheets);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
