package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.InferenceData;
import odata.msgraph.client.beta.complex.PersonDataSources;
import odata.msgraph.client.beta.complex.PositionDetail;
import odata.msgraph.client.beta.complex.RelatedPerson;
import odata.msgraph.client.beta.enums.AllowedAudiences;

@JsonPropertyOrder({
    "@odata.type", 
    "categories", 
    "colleagues", 
    "detail", 
    "isCurrent", 
    "manager"})
@JsonInclude(Include.NON_NULL)
public class WorkPosition extends ItemFacet implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.workPosition";
    }

    @JsonProperty("categories")
    protected List<String> categories;

    @JsonProperty("categories@nextLink")
    protected String categoriesNextLink;

    @JsonProperty("colleagues")
    protected List<RelatedPerson> colleagues;

    @JsonProperty("colleagues@nextLink")
    protected String colleaguesNextLink;

    @JsonProperty("detail")
    protected PositionDetail detail;

    @JsonProperty("isCurrent")
    protected Boolean isCurrent;

    @JsonProperty("manager")
    protected RelatedPerson manager;

    protected WorkPosition() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWorkPosition() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private AllowedAudiences allowedAudiences;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private InferenceData inference;
        private Boolean isSearchable;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private PersonDataSources source;
        private List<String> categories;
        private String categoriesNextLink;
        private List<RelatedPerson> colleagues;
        private String colleaguesNextLink;
        private PositionDetail detail;
        private Boolean isCurrent;
        private RelatedPerson manager;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder allowedAudiences(AllowedAudiences allowedAudiences) {
            this.allowedAudiences = allowedAudiences;
            this.changedFields = changedFields.add("allowedAudiences");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder inference(InferenceData inference) {
            this.inference = inference;
            this.changedFields = changedFields.add("inference");
            return this;
        }

        public Builder isSearchable(Boolean isSearchable) {
            this.isSearchable = isSearchable;
            this.changedFields = changedFields.add("isSearchable");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder source(PersonDataSources source) {
            this.source = source;
            this.changedFields = changedFields.add("source");
            return this;
        }

        public Builder categories(List<String> categories) {
            this.categories = categories;
            this.changedFields = changedFields.add("categories");
            return this;
        }

        public Builder categories(String... categories) {
            return categories(Arrays.asList(categories));
        }

        public Builder categoriesNextLink(String categoriesNextLink) {
            this.categoriesNextLink = categoriesNextLink;
            this.changedFields = changedFields.add("categories");
            return this;
        }

        public Builder colleagues(List<RelatedPerson> colleagues) {
            this.colleagues = colleagues;
            this.changedFields = changedFields.add("colleagues");
            return this;
        }

        public Builder colleagues(RelatedPerson... colleagues) {
            return colleagues(Arrays.asList(colleagues));
        }

        public Builder colleaguesNextLink(String colleaguesNextLink) {
            this.colleaguesNextLink = colleaguesNextLink;
            this.changedFields = changedFields.add("colleagues");
            return this;
        }

        public Builder detail(PositionDetail detail) {
            this.detail = detail;
            this.changedFields = changedFields.add("detail");
            return this;
        }

        public Builder isCurrent(Boolean isCurrent) {
            this.isCurrent = isCurrent;
            this.changedFields = changedFields.add("isCurrent");
            return this;
        }

        public Builder manager(RelatedPerson manager) {
            this.manager = manager;
            this.changedFields = changedFields.add("manager");
            return this;
        }

        public WorkPosition build() {
            WorkPosition _x = new WorkPosition();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.workPosition";
            _x.id = id;
            _x.allowedAudiences = allowedAudiences;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.inference = inference;
            _x.isSearchable = isSearchable;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.source = source;
            _x.categories = categories;
            _x.categoriesNextLink = categoriesNextLink;
            _x.colleagues = colleagues;
            _x.colleaguesNextLink = colleaguesNextLink;
            _x.detail = detail;
            _x.isCurrent = isCurrent;
            _x.manager = manager;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="categories")
    @JsonIgnore
    public CollectionPage<String> getCategories() {
        return new CollectionPage<String>(contextPath, String.class, this.categories, Optional.ofNullable(categoriesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public WorkPosition withCategories(List<String> categories) {
        WorkPosition _x = _copy();
        _x.changedFields = changedFields.add("categories");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workPosition");
        _x.categories = categories;
        return _x;
    }

    @Property(name="categories")
    @JsonIgnore
    public CollectionPage<String> getCategories(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.categories, Optional.ofNullable(categoriesNextLink), Collections.emptyList(), options);
    }

    @Property(name="colleagues")
    @JsonIgnore
    public CollectionPage<RelatedPerson> getColleagues() {
        return new CollectionPage<RelatedPerson>(contextPath, RelatedPerson.class, this.colleagues, Optional.ofNullable(colleaguesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public WorkPosition withColleagues(List<RelatedPerson> colleagues) {
        WorkPosition _x = _copy();
        _x.changedFields = changedFields.add("colleagues");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workPosition");
        _x.colleagues = colleagues;
        return _x;
    }

    @Property(name="colleagues")
    @JsonIgnore
    public CollectionPage<RelatedPerson> getColleagues(HttpRequestOptions options) {
        return new CollectionPage<RelatedPerson>(contextPath, RelatedPerson.class, this.colleagues, Optional.ofNullable(colleaguesNextLink), Collections.emptyList(), options);
    }

    @Property(name="detail")
    @JsonIgnore
    public Optional<PositionDetail> getDetail() {
        return Optional.ofNullable(detail);
    }

    public WorkPosition withDetail(PositionDetail detail) {
        WorkPosition _x = _copy();
        _x.changedFields = changedFields.add("detail");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workPosition");
        _x.detail = detail;
        return _x;
    }

    @Property(name="isCurrent")
    @JsonIgnore
    public Optional<Boolean> getIsCurrent() {
        return Optional.ofNullable(isCurrent);
    }

    public WorkPosition withIsCurrent(Boolean isCurrent) {
        WorkPosition _x = _copy();
        _x.changedFields = changedFields.add("isCurrent");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workPosition");
        _x.isCurrent = isCurrent;
        return _x;
    }

    @Property(name="manager")
    @JsonIgnore
    public Optional<RelatedPerson> getManager() {
        return Optional.ofNullable(manager);
    }

    public WorkPosition withManager(RelatedPerson manager) {
        WorkPosition _x = _copy();
        _x.changedFields = changedFields.add("manager");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.workPosition");
        _x.manager = manager;
        return _x;
    }

    public WorkPosition withUnmappedField(String name, Object value) {
        WorkPosition _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkPosition patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WorkPosition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkPosition put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WorkPosition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WorkPosition _copy() {
        WorkPosition _x = new WorkPosition();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.allowedAudiences = allowedAudiences;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.inference = inference;
        _x.isSearchable = isSearchable;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.source = source;
        _x.categories = categories;
        _x.colleagues = colleagues;
        _x.detail = detail;
        _x.isCurrent = isCurrent;
        _x.manager = manager;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkPosition[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("allowedAudiences=");
        b.append(this.allowedAudiences);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("inference=");
        b.append(this.inference);
        b.append(", ");
        b.append("isSearchable=");
        b.append(this.isSearchable);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("source=");
        b.append(this.source);
        b.append(", ");
        b.append("categories=");
        b.append(this.categories);
        b.append(", ");
        b.append("colleagues=");
        b.append(this.colleagues);
        b.append(", ");
        b.append("detail=");
        b.append(this.detail);
        b.append(", ");
        b.append("isCurrent=");
        b.append(this.isCurrent);
        b.append(", ");
        b.append("manager=");
        b.append(this.manager);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
