package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.entity.collection.request.Windows81TrustedRootCertificateCollectionRequest;
import odata.msgraph.client.beta.entity.request.Windows81TrustedRootCertificateRequest;
import odata.msgraph.client.beta.entity.request.WindowsCertificateProfileBaseRequest;
import odata.msgraph.client.beta.enums.EapType;
import odata.msgraph.client.beta.enums.MeteredConnectionLimitType;
import odata.msgraph.client.beta.enums.NetworkSingleSignOnType;
import odata.msgraph.client.beta.enums.NonEapAuthenticationMethodForEapTtlsType;
import odata.msgraph.client.beta.enums.WiFiAuthenticationMethod;
import odata.msgraph.client.beta.enums.WiFiProxySetting;
import odata.msgraph.client.beta.enums.WiFiSecurityType;
import odata.msgraph.client.beta.enums.WifiAuthenticationType;


/**
 * <i>“This entity provides descriptions of the declared methods, properties and
 * relationships exposed by the Wifi CSP.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "authenticationMethod", 
    "authenticationPeriodInSeconds", 
    "authenticationRetryDelayPeriodInSeconds", 
    "authenticationType", 
    "cacheCredentials", 
    "disableUserPromptForServerValidation", 
    "eapolStartPeriodInSeconds", 
    "eapType", 
    "enablePairwiseMasterKeyCaching", 
    "enablePreAuthentication", 
    "innerAuthenticationProtocolForEAPTTLS", 
    "maximumAuthenticationFailures", 
    "maximumAuthenticationTimeoutInSeconds", 
    "maximumEAPOLStartMessages", 
    "maximumNumberOfPairwiseMasterKeysInCache", 
    "maximumPairwiseMasterKeyCacheTimeInMinutes", 
    "maximumPreAuthenticationAttempts", 
    "networkSingleSignOn", 
    "outerIdentityPrivacyTemporaryValue", 
    "performServerValidation", 
    "promptForAdditionalAuthenticationCredentials", 
    "requireCryptographicBinding", 
    "trustedServerCertificateNames", 
    "userBasedVirtualLan"})
@JsonInclude(Include.NON_NULL)
public class WindowsWifiEnterpriseEAPConfiguration extends WindowsWifiConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsWifiEnterpriseEAPConfiguration";
    }

    @JsonProperty("authenticationMethod")
    protected WiFiAuthenticationMethod authenticationMethod;

    @JsonProperty("authenticationPeriodInSeconds")
    protected Integer authenticationPeriodInSeconds;

    @JsonProperty("authenticationRetryDelayPeriodInSeconds")
    protected Integer authenticationRetryDelayPeriodInSeconds;

    @JsonProperty("authenticationType")
    protected WifiAuthenticationType authenticationType;

    @JsonProperty("cacheCredentials")
    protected Boolean cacheCredentials;

    @JsonProperty("disableUserPromptForServerValidation")
    protected Boolean disableUserPromptForServerValidation;

    @JsonProperty("eapolStartPeriodInSeconds")
    protected Integer eapolStartPeriodInSeconds;

    @JsonProperty("eapType")
    protected EapType eapType;

    @JsonProperty("enablePairwiseMasterKeyCaching")
    protected Boolean enablePairwiseMasterKeyCaching;

    @JsonProperty("enablePreAuthentication")
    protected Boolean enablePreAuthentication;

    @JsonProperty("innerAuthenticationProtocolForEAPTTLS")
    protected NonEapAuthenticationMethodForEapTtlsType innerAuthenticationProtocolForEAPTTLS;

    @JsonProperty("maximumAuthenticationFailures")
    protected Integer maximumAuthenticationFailures;

    @JsonProperty("maximumAuthenticationTimeoutInSeconds")
    protected Integer maximumAuthenticationTimeoutInSeconds;

    @JsonProperty("maximumEAPOLStartMessages")
    protected Integer maximumEAPOLStartMessages;

    @JsonProperty("maximumNumberOfPairwiseMasterKeysInCache")
    protected Integer maximumNumberOfPairwiseMasterKeysInCache;

    @JsonProperty("maximumPairwiseMasterKeyCacheTimeInMinutes")
    protected Integer maximumPairwiseMasterKeyCacheTimeInMinutes;

    @JsonProperty("maximumPreAuthenticationAttempts")
    protected Integer maximumPreAuthenticationAttempts;

    @JsonProperty("networkSingleSignOn")
    protected NetworkSingleSignOnType networkSingleSignOn;

    @JsonProperty("outerIdentityPrivacyTemporaryValue")
    protected String outerIdentityPrivacyTemporaryValue;

    @JsonProperty("performServerValidation")
    protected Boolean performServerValidation;

    @JsonProperty("promptForAdditionalAuthenticationCredentials")
    protected Boolean promptForAdditionalAuthenticationCredentials;

    @JsonProperty("requireCryptographicBinding")
    protected Boolean requireCryptographicBinding;

    @JsonProperty("trustedServerCertificateNames")
    protected List<String> trustedServerCertificateNames;

    @JsonProperty("trustedServerCertificateNames@nextLink")
    protected String trustedServerCertificateNamesNextLink;

    @JsonProperty("userBasedVirtualLan")
    protected Boolean userBasedVirtualLan;

    protected WindowsWifiEnterpriseEAPConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsWifiEnterpriseEAPConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private Integer version;
        private List<DeviceConfigurationAssignment> assignments;
        private List<SettingStateDeviceSummary> deviceSettingStateSummaries;
        private List<DeviceConfigurationDeviceStatus> deviceStatuses;
        private DeviceConfigurationDeviceOverview deviceStatusOverview;
        private List<DeviceConfigurationGroupAssignment> groupAssignments;
        private List<DeviceConfigurationUserStatus> userStatuses;
        private DeviceConfigurationUserOverview userStatusOverview;
        private Boolean connectAutomatically;
        private Boolean connectToPreferredNetwork;
        private Boolean connectWhenNetworkNameIsHidden;
        private Boolean forceFIPSCompliance;
        private MeteredConnectionLimitType meteredConnectionLimit;
        private String networkName;
        private String preSharedKey;
        private String proxyAutomaticConfigurationUrl;
        private String proxyManualAddress;
        private Integer proxyManualPort;
        private WiFiProxySetting proxySetting;
        private String ssid;
        private WiFiSecurityType wifiSecurityType;
        private WiFiAuthenticationMethod authenticationMethod;
        private Integer authenticationPeriodInSeconds;
        private Integer authenticationRetryDelayPeriodInSeconds;
        private WifiAuthenticationType authenticationType;
        private Boolean cacheCredentials;
        private Boolean disableUserPromptForServerValidation;
        private Integer eapolStartPeriodInSeconds;
        private EapType eapType;
        private Boolean enablePairwiseMasterKeyCaching;
        private Boolean enablePreAuthentication;
        private NonEapAuthenticationMethodForEapTtlsType innerAuthenticationProtocolForEAPTTLS;
        private Integer maximumAuthenticationFailures;
        private Integer maximumAuthenticationTimeoutInSeconds;
        private Integer maximumEAPOLStartMessages;
        private Integer maximumNumberOfPairwiseMasterKeysInCache;
        private Integer maximumPairwiseMasterKeyCacheTimeInMinutes;
        private Integer maximumPreAuthenticationAttempts;
        private NetworkSingleSignOnType networkSingleSignOn;
        private String outerIdentityPrivacyTemporaryValue;
        private Boolean performServerValidation;
        private Boolean promptForAdditionalAuthenticationCredentials;
        private Boolean requireCryptographicBinding;
        private List<String> trustedServerCertificateNames;
        private String trustedServerCertificateNamesNextLink;
        private Boolean userBasedVirtualLan;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder assignments(List<DeviceConfigurationAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(DeviceConfigurationAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder deviceSettingStateSummaries(List<SettingStateDeviceSummary> deviceSettingStateSummaries) {
            this.deviceSettingStateSummaries = deviceSettingStateSummaries;
            this.changedFields = changedFields.add("deviceSettingStateSummaries");
            return this;
        }

        public Builder deviceSettingStateSummaries(SettingStateDeviceSummary... deviceSettingStateSummaries) {
            return deviceSettingStateSummaries(Arrays.asList(deviceSettingStateSummaries));
        }

        public Builder deviceStatuses(List<DeviceConfigurationDeviceStatus> deviceStatuses) {
            this.deviceStatuses = deviceStatuses;
            this.changedFields = changedFields.add("deviceStatuses");
            return this;
        }

        public Builder deviceStatuses(DeviceConfigurationDeviceStatus... deviceStatuses) {
            return deviceStatuses(Arrays.asList(deviceStatuses));
        }

        public Builder deviceStatusOverview(DeviceConfigurationDeviceOverview deviceStatusOverview) {
            this.deviceStatusOverview = deviceStatusOverview;
            this.changedFields = changedFields.add("deviceStatusOverview");
            return this;
        }

        public Builder groupAssignments(List<DeviceConfigurationGroupAssignment> groupAssignments) {
            this.groupAssignments = groupAssignments;
            this.changedFields = changedFields.add("groupAssignments");
            return this;
        }

        public Builder groupAssignments(DeviceConfigurationGroupAssignment... groupAssignments) {
            return groupAssignments(Arrays.asList(groupAssignments));
        }

        public Builder userStatuses(List<DeviceConfigurationUserStatus> userStatuses) {
            this.userStatuses = userStatuses;
            this.changedFields = changedFields.add("userStatuses");
            return this;
        }

        public Builder userStatuses(DeviceConfigurationUserStatus... userStatuses) {
            return userStatuses(Arrays.asList(userStatuses));
        }

        public Builder userStatusOverview(DeviceConfigurationUserOverview userStatusOverview) {
            this.userStatusOverview = userStatusOverview;
            this.changedFields = changedFields.add("userStatusOverview");
            return this;
        }

        public Builder connectAutomatically(Boolean connectAutomatically) {
            this.connectAutomatically = connectAutomatically;
            this.changedFields = changedFields.add("connectAutomatically");
            return this;
        }

        public Builder connectToPreferredNetwork(Boolean connectToPreferredNetwork) {
            this.connectToPreferredNetwork = connectToPreferredNetwork;
            this.changedFields = changedFields.add("connectToPreferredNetwork");
            return this;
        }

        public Builder connectWhenNetworkNameIsHidden(Boolean connectWhenNetworkNameIsHidden) {
            this.connectWhenNetworkNameIsHidden = connectWhenNetworkNameIsHidden;
            this.changedFields = changedFields.add("connectWhenNetworkNameIsHidden");
            return this;
        }

        public Builder forceFIPSCompliance(Boolean forceFIPSCompliance) {
            this.forceFIPSCompliance = forceFIPSCompliance;
            this.changedFields = changedFields.add("forceFIPSCompliance");
            return this;
        }

        public Builder meteredConnectionLimit(MeteredConnectionLimitType meteredConnectionLimit) {
            this.meteredConnectionLimit = meteredConnectionLimit;
            this.changedFields = changedFields.add("meteredConnectionLimit");
            return this;
        }

        public Builder networkName(String networkName) {
            this.networkName = networkName;
            this.changedFields = changedFields.add("networkName");
            return this;
        }

        public Builder preSharedKey(String preSharedKey) {
            this.preSharedKey = preSharedKey;
            this.changedFields = changedFields.add("preSharedKey");
            return this;
        }

        public Builder proxyAutomaticConfigurationUrl(String proxyAutomaticConfigurationUrl) {
            this.proxyAutomaticConfigurationUrl = proxyAutomaticConfigurationUrl;
            this.changedFields = changedFields.add("proxyAutomaticConfigurationUrl");
            return this;
        }

        public Builder proxyManualAddress(String proxyManualAddress) {
            this.proxyManualAddress = proxyManualAddress;
            this.changedFields = changedFields.add("proxyManualAddress");
            return this;
        }

        public Builder proxyManualPort(Integer proxyManualPort) {
            this.proxyManualPort = proxyManualPort;
            this.changedFields = changedFields.add("proxyManualPort");
            return this;
        }

        public Builder proxySetting(WiFiProxySetting proxySetting) {
            this.proxySetting = proxySetting;
            this.changedFields = changedFields.add("proxySetting");
            return this;
        }

        public Builder ssid(String ssid) {
            this.ssid = ssid;
            this.changedFields = changedFields.add("ssid");
            return this;
        }

        public Builder wifiSecurityType(WiFiSecurityType wifiSecurityType) {
            this.wifiSecurityType = wifiSecurityType;
            this.changedFields = changedFields.add("wifiSecurityType");
            return this;
        }

        /**
         * <i>“Specify the authentication method.”</i>
         * 
         * @param authenticationMethod
         *            value of {@code authenticationMethod} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder authenticationMethod(WiFiAuthenticationMethod authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            this.changedFields = changedFields.add("authenticationMethod");
            return this;
        }

        /**
         * <i>“Specify the number of seconds for the client to wait after an authentication
         * attempt before failing. Valid range 1-3600.”</i>
         * 
         * @param authenticationPeriodInSeconds
         *            value of {@code authenticationPeriodInSeconds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder authenticationPeriodInSeconds(Integer authenticationPeriodInSeconds) {
            this.authenticationPeriodInSeconds = authenticationPeriodInSeconds;
            this.changedFields = changedFields.add("authenticationPeriodInSeconds");
            return this;
        }

        /**
         * <i>“Specify the number of seconds between a failed authentication and the next
         * authentication attempt. Valid range 1-3600.”</i>
         * 
         * @param authenticationRetryDelayPeriodInSeconds
         *            value of {@code authenticationRetryDelayPeriodInSeconds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder authenticationRetryDelayPeriodInSeconds(Integer authenticationRetryDelayPeriodInSeconds) {
            this.authenticationRetryDelayPeriodInSeconds = authenticationRetryDelayPeriodInSeconds;
            this.changedFields = changedFields.add("authenticationRetryDelayPeriodInSeconds");
            return this;
        }

        /**
         * <i>“Specify whether to authenticate the user, the device, either, or to use guest
         * authentication (none). If you’re using certificate authentication, make sure the
         * certificate type matches the authentication type.”</i>
         * 
         * @param authenticationType
         *            value of {@code authenticationType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder authenticationType(WifiAuthenticationType authenticationType) {
            this.authenticationType = authenticationType;
            this.changedFields = changedFields.add("authenticationType");
            return this;
        }

        /**
         * <i>“Specify whether to cache user credentials on the device so that users don’t need
         * to keep entering them each time they connect.”</i>
         * 
         * @param cacheCredentials
         *            value of {@code cacheCredentials} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cacheCredentials(Boolean cacheCredentials) {
            this.cacheCredentials = cacheCredentials;
            this.changedFields = changedFields.add("cacheCredentials");
            return this;
        }

        /**
         * <i>“Specify whether to prevent the user from being prompted to authorize new servers
         * for trusted certification authorities when EAP type is selected as PEAP.”</i>
         * 
         * @param disableUserPromptForServerValidation
         *            value of {@code disableUserPromptForServerValidation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder disableUserPromptForServerValidation(Boolean disableUserPromptForServerValidation) {
            this.disableUserPromptForServerValidation = disableUserPromptForServerValidation;
            this.changedFields = changedFields.add("disableUserPromptForServerValidation");
            return this;
        }

        /**
         * <i>“Specify the number of seconds to wait before sending an EAPOL (Extensible
         * Authentication Protocol over LAN) Start message. Valid range 1-3600.”</i>
         * 
         * @param eapolStartPeriodInSeconds
         *            value of {@code eapolStartPeriodInSeconds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder eapolStartPeriodInSeconds(Integer eapolStartPeriodInSeconds) {
            this.eapolStartPeriodInSeconds = eapolStartPeriodInSeconds;
            this.changedFields = changedFields.add("eapolStartPeriodInSeconds");
            return this;
        }

        /**
         * <i>“Extensible Authentication Protocol (EAP). Indicates the type of EAP protocol set
         * on the Wi-Fi endpoint (router).”</i>
         * 
         * @param eapType
         *            value of {@code eapType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder eapType(EapType eapType) {
            this.eapType = eapType;
            this.changedFields = changedFields.add("eapType");
            return this;
        }

        /**
         * <i>“Specify whether the wifi connection should enable pairwise master key caching.”</i>
         * 
         * @param enablePairwiseMasterKeyCaching
         *            value of {@code enablePairwiseMasterKeyCaching} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enablePairwiseMasterKeyCaching(Boolean enablePairwiseMasterKeyCaching) {
            this.enablePairwiseMasterKeyCaching = enablePairwiseMasterKeyCaching;
            this.changedFields = changedFields.add("enablePairwiseMasterKeyCaching");
            return this;
        }

        /**
         * <i>“Specify whether pre-authentication should be enabled.”</i>
         * 
         * @param enablePreAuthentication
         *            value of {@code enablePreAuthentication} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enablePreAuthentication(Boolean enablePreAuthentication) {
            this.enablePreAuthentication = enablePreAuthentication;
            this.changedFields = changedFields.add("enablePreAuthentication");
            return this;
        }

        /**
         * <i>“Specify inner authentication protocol for EAP TTLS.”</i>
         * 
         * @param innerAuthenticationProtocolForEAPTTLS
         *            value of {@code innerAuthenticationProtocolForEAPTTLS} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder innerAuthenticationProtocolForEAPTTLS(NonEapAuthenticationMethodForEapTtlsType innerAuthenticationProtocolForEAPTTLS) {
            this.innerAuthenticationProtocolForEAPTTLS = innerAuthenticationProtocolForEAPTTLS;
            this.changedFields = changedFields.add("innerAuthenticationProtocolForEAPTTLS");
            return this;
        }

        /**
         * <i>“Specify the maximum authentication failures allowed for a set of credentials.
         * Valid range 1-100.”</i>
         * 
         * @param maximumAuthenticationFailures
         *            value of {@code maximumAuthenticationFailures} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder maximumAuthenticationFailures(Integer maximumAuthenticationFailures) {
            this.maximumAuthenticationFailures = maximumAuthenticationFailures;
            this.changedFields = changedFields.add("maximumAuthenticationFailures");
            return this;
        }

        /**
         * <i>“Specify maximum authentication timeout (in seconds).  Valid range: 1-120”</i>
         * 
         * @param maximumAuthenticationTimeoutInSeconds
         *            value of {@code maximumAuthenticationTimeoutInSeconds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder maximumAuthenticationTimeoutInSeconds(Integer maximumAuthenticationTimeoutInSeconds) {
            this.maximumAuthenticationTimeoutInSeconds = maximumAuthenticationTimeoutInSeconds;
            this.changedFields = changedFields.add("maximumAuthenticationTimeoutInSeconds");
            return this;
        }

        /**
         * <i>“Specifiy the maximum number of EAPOL (Extensible Authentication Protocol over
         * LAN) Start messages to be sent before returning failure. Valid range 1-100.”</i>
         * 
         * @param maximumEAPOLStartMessages
         *            value of {@code maximumEAPOLStartMessages} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder maximumEAPOLStartMessages(Integer maximumEAPOLStartMessages) {
            this.maximumEAPOLStartMessages = maximumEAPOLStartMessages;
            this.changedFields = changedFields.add("maximumEAPOLStartMessages");
            return this;
        }

        /**
         * <i>“Specify maximum number of pairwise master keys in cache.  Valid range: 1-255”</i>
         * 
         * @param maximumNumberOfPairwiseMasterKeysInCache
         *            value of {@code maximumNumberOfPairwiseMasterKeysInCache} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder maximumNumberOfPairwiseMasterKeysInCache(Integer maximumNumberOfPairwiseMasterKeysInCache) {
            this.maximumNumberOfPairwiseMasterKeysInCache = maximumNumberOfPairwiseMasterKeysInCache;
            this.changedFields = changedFields.add("maximumNumberOfPairwiseMasterKeysInCache");
            return this;
        }

        /**
         * <i>“Specify maximum pairwise master key cache time (in minutes).  Valid range: 5-
         * 1440”</i>
         * 
         * @param maximumPairwiseMasterKeyCacheTimeInMinutes
         *            value of {@code maximumPairwiseMasterKeyCacheTimeInMinutes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder maximumPairwiseMasterKeyCacheTimeInMinutes(Integer maximumPairwiseMasterKeyCacheTimeInMinutes) {
            this.maximumPairwiseMasterKeyCacheTimeInMinutes = maximumPairwiseMasterKeyCacheTimeInMinutes;
            this.changedFields = changedFields.add("maximumPairwiseMasterKeyCacheTimeInMinutes");
            return this;
        }

        /**
         * <i>“Specify maximum pre-authentication attempts.  Valid range: 1-16”</i>
         * 
         * @param maximumPreAuthenticationAttempts
         *            value of {@code maximumPreAuthenticationAttempts} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder maximumPreAuthenticationAttempts(Integer maximumPreAuthenticationAttempts) {
            this.maximumPreAuthenticationAttempts = maximumPreAuthenticationAttempts;
            this.changedFields = changedFields.add("maximumPreAuthenticationAttempts");
            return this;
        }

        /**
         * <i>“Specify the network single sign on type.”</i>
         * 
         * @param networkSingleSignOn
         *            value of {@code networkSingleSignOn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder networkSingleSignOn(NetworkSingleSignOnType networkSingleSignOn) {
            this.networkSingleSignOn = networkSingleSignOn;
            this.changedFields = changedFields.add("networkSingleSignOn");
            return this;
        }

        /**
         * <i>“Specify the string to replace usernames for privacy when using EAP TTLS or PEAP.”</i>
         * 
         * @param outerIdentityPrivacyTemporaryValue
         *            value of {@code outerIdentityPrivacyTemporaryValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder outerIdentityPrivacyTemporaryValue(String outerIdentityPrivacyTemporaryValue) {
            this.outerIdentityPrivacyTemporaryValue = outerIdentityPrivacyTemporaryValue;
            this.changedFields = changedFields.add("outerIdentityPrivacyTemporaryValue");
            return this;
        }

        /**
         * <i>“Specify whether to enable verification of server's identity by validating the
         * certificate when EAP type is selected as PEAP.”</i>
         * 
         * @param performServerValidation
         *            value of {@code performServerValidation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder performServerValidation(Boolean performServerValidation) {
            this.performServerValidation = performServerValidation;
            this.changedFields = changedFields.add("performServerValidation");
            return this;
        }

        /**
         * <i>“Specify whether the wifi connection should prompt for additional authentication
         * credentials.”</i>
         * 
         * @param promptForAdditionalAuthenticationCredentials
         *            value of {@code promptForAdditionalAuthenticationCredentials} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder promptForAdditionalAuthenticationCredentials(Boolean promptForAdditionalAuthenticationCredentials) {
            this.promptForAdditionalAuthenticationCredentials = promptForAdditionalAuthenticationCredentials;
            this.changedFields = changedFields.add("promptForAdditionalAuthenticationCredentials");
            return this;
        }

        /**
         * <i>“Specify whether to enable cryptographic binding when EAP type is selected as
         * PEAP.”</i>
         * 
         * @param requireCryptographicBinding
         *            value of {@code requireCryptographicBinding} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requireCryptographicBinding(Boolean requireCryptographicBinding) {
            this.requireCryptographicBinding = requireCryptographicBinding;
            this.changedFields = changedFields.add("requireCryptographicBinding");
            return this;
        }

        /**
         * <i>“Specify trusted server certificate names.”</i>
         * 
         * @param trustedServerCertificateNames
         *            value of {@code trustedServerCertificateNames} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder trustedServerCertificateNames(List<String> trustedServerCertificateNames) {
            this.trustedServerCertificateNames = trustedServerCertificateNames;
            this.changedFields = changedFields.add("trustedServerCertificateNames");
            return this;
        }

        /**
         * <i>“Specify trusted server certificate names.”</i>
         * 
         * @param trustedServerCertificateNames
         *            value of {@code trustedServerCertificateNames} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder trustedServerCertificateNames(String... trustedServerCertificateNames) {
            return trustedServerCertificateNames(Arrays.asList(trustedServerCertificateNames));
        }

        /**
         * <i>“Specify trusted server certificate names.”</i>
         * 
         * @param trustedServerCertificateNamesNextLink
         *            value of {@code trustedServerCertificateNames@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder trustedServerCertificateNamesNextLink(String trustedServerCertificateNamesNextLink) {
            this.trustedServerCertificateNamesNextLink = trustedServerCertificateNamesNextLink;
            this.changedFields = changedFields.add("trustedServerCertificateNames");
            return this;
        }

        /**
         * <i>“Specifiy whether to change the virtual LAN used by the device based on the user
         * ’s credentials. Cannot be used when NetworkSingleSignOnType is set to ​Disabled.”</i>
         * 
         * @param userBasedVirtualLan
         *            value of {@code userBasedVirtualLan} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userBasedVirtualLan(Boolean userBasedVirtualLan) {
            this.userBasedVirtualLan = userBasedVirtualLan;
            this.changedFields = changedFields.add("userBasedVirtualLan");
            return this;
        }

        public WindowsWifiEnterpriseEAPConfiguration build() {
            WindowsWifiEnterpriseEAPConfiguration _x = new WindowsWifiEnterpriseEAPConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsWifiEnterpriseEAPConfiguration";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.version = version;
            _x.assignments = assignments;
            _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
            _x.deviceStatuses = deviceStatuses;
            _x.deviceStatusOverview = deviceStatusOverview;
            _x.groupAssignments = groupAssignments;
            _x.userStatuses = userStatuses;
            _x.userStatusOverview = userStatusOverview;
            _x.connectAutomatically = connectAutomatically;
            _x.connectToPreferredNetwork = connectToPreferredNetwork;
            _x.connectWhenNetworkNameIsHidden = connectWhenNetworkNameIsHidden;
            _x.forceFIPSCompliance = forceFIPSCompliance;
            _x.meteredConnectionLimit = meteredConnectionLimit;
            _x.networkName = networkName;
            _x.preSharedKey = preSharedKey;
            _x.proxyAutomaticConfigurationUrl = proxyAutomaticConfigurationUrl;
            _x.proxyManualAddress = proxyManualAddress;
            _x.proxyManualPort = proxyManualPort;
            _x.proxySetting = proxySetting;
            _x.ssid = ssid;
            _x.wifiSecurityType = wifiSecurityType;
            _x.authenticationMethod = authenticationMethod;
            _x.authenticationPeriodInSeconds = authenticationPeriodInSeconds;
            _x.authenticationRetryDelayPeriodInSeconds = authenticationRetryDelayPeriodInSeconds;
            _x.authenticationType = authenticationType;
            _x.cacheCredentials = cacheCredentials;
            _x.disableUserPromptForServerValidation = disableUserPromptForServerValidation;
            _x.eapolStartPeriodInSeconds = eapolStartPeriodInSeconds;
            _x.eapType = eapType;
            _x.enablePairwiseMasterKeyCaching = enablePairwiseMasterKeyCaching;
            _x.enablePreAuthentication = enablePreAuthentication;
            _x.innerAuthenticationProtocolForEAPTTLS = innerAuthenticationProtocolForEAPTTLS;
            _x.maximumAuthenticationFailures = maximumAuthenticationFailures;
            _x.maximumAuthenticationTimeoutInSeconds = maximumAuthenticationTimeoutInSeconds;
            _x.maximumEAPOLStartMessages = maximumEAPOLStartMessages;
            _x.maximumNumberOfPairwiseMasterKeysInCache = maximumNumberOfPairwiseMasterKeysInCache;
            _x.maximumPairwiseMasterKeyCacheTimeInMinutes = maximumPairwiseMasterKeyCacheTimeInMinutes;
            _x.maximumPreAuthenticationAttempts = maximumPreAuthenticationAttempts;
            _x.networkSingleSignOn = networkSingleSignOn;
            _x.outerIdentityPrivacyTemporaryValue = outerIdentityPrivacyTemporaryValue;
            _x.performServerValidation = performServerValidation;
            _x.promptForAdditionalAuthenticationCredentials = promptForAdditionalAuthenticationCredentials;
            _x.requireCryptographicBinding = requireCryptographicBinding;
            _x.trustedServerCertificateNames = trustedServerCertificateNames;
            _x.trustedServerCertificateNamesNextLink = trustedServerCertificateNamesNextLink;
            _x.userBasedVirtualLan = userBasedVirtualLan;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Specify the authentication method.”</i>
     * 
     * @return property authenticationMethod
     */
    @Property(name="authenticationMethod")
    @JsonIgnore
    public Optional<WiFiAuthenticationMethod> getAuthenticationMethod() {
        return Optional.ofNullable(authenticationMethod);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * authenticationMethod} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Specify the authentication method.”</i>
     * 
     * @param authenticationMethod
     *            new value of {@code authenticationMethod} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code authenticationMethod} field changed
     */
    public WindowsWifiEnterpriseEAPConfiguration withAuthenticationMethod(WiFiAuthenticationMethod authenticationMethod) {
        WindowsWifiEnterpriseEAPConfiguration _x = _copy();
        _x.changedFields = changedFields.add("authenticationMethod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiEnterpriseEAPConfiguration");
        _x.authenticationMethod = authenticationMethod;
        return _x;
    }

    /**
     * <i>“Specify the number of seconds for the client to wait after an authentication
     * attempt before failing. Valid range 1-3600.”</i>
     * 
     * @return property authenticationPeriodInSeconds
     */
    @Property(name="authenticationPeriodInSeconds")
    @JsonIgnore
    public Optional<Integer> getAuthenticationPeriodInSeconds() {
        return Optional.ofNullable(authenticationPeriodInSeconds);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * authenticationPeriodInSeconds} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Specify the number of seconds for the client to wait after an authentication
     * attempt before failing. Valid range 1-3600.”</i>
     * 
     * @param authenticationPeriodInSeconds
     *            new value of {@code authenticationPeriodInSeconds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code authenticationPeriodInSeconds} field changed
     */
    public WindowsWifiEnterpriseEAPConfiguration withAuthenticationPeriodInSeconds(Integer authenticationPeriodInSeconds) {
        WindowsWifiEnterpriseEAPConfiguration _x = _copy();
        _x.changedFields = changedFields.add("authenticationPeriodInSeconds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiEnterpriseEAPConfiguration");
        _x.authenticationPeriodInSeconds = authenticationPeriodInSeconds;
        return _x;
    }

    /**
     * <i>“Specify the number of seconds between a failed authentication and the next
     * authentication attempt. Valid range 1-3600.”</i>
     * 
     * @return property authenticationRetryDelayPeriodInSeconds
     */
    @Property(name="authenticationRetryDelayPeriodInSeconds")
    @JsonIgnore
    public Optional<Integer> getAuthenticationRetryDelayPeriodInSeconds() {
        return Optional.ofNullable(authenticationRetryDelayPeriodInSeconds);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * authenticationRetryDelayPeriodInSeconds} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Specify the number of seconds between a failed authentication and the next
     * authentication attempt. Valid range 1-3600.”</i>
     * 
     * @param authenticationRetryDelayPeriodInSeconds
     *            new value of {@code authenticationRetryDelayPeriodInSeconds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code authenticationRetryDelayPeriodInSeconds} field changed
     */
    public WindowsWifiEnterpriseEAPConfiguration withAuthenticationRetryDelayPeriodInSeconds(Integer authenticationRetryDelayPeriodInSeconds) {
        WindowsWifiEnterpriseEAPConfiguration _x = _copy();
        _x.changedFields = changedFields.add("authenticationRetryDelayPeriodInSeconds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiEnterpriseEAPConfiguration");
        _x.authenticationRetryDelayPeriodInSeconds = authenticationRetryDelayPeriodInSeconds;
        return _x;
    }

    /**
     * <i>“Specify whether to authenticate the user, the device, either, or to use guest
     * authentication (none). If you’re using certificate authentication, make sure the
     * certificate type matches the authentication type.”</i>
     * 
     * @return property authenticationType
     */
    @Property(name="authenticationType")
    @JsonIgnore
    public Optional<WifiAuthenticationType> getAuthenticationType() {
        return Optional.ofNullable(authenticationType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * authenticationType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Specify whether to authenticate the user, the device, either, or to use guest
     * authentication (none). If you’re using certificate authentication, make sure the
     * certificate type matches the authentication type.”</i>
     * 
     * @param authenticationType
     *            new value of {@code authenticationType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code authenticationType} field changed
     */
    public WindowsWifiEnterpriseEAPConfiguration withAuthenticationType(WifiAuthenticationType authenticationType) {
        WindowsWifiEnterpriseEAPConfiguration _x = _copy();
        _x.changedFields = changedFields.add("authenticationType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiEnterpriseEAPConfiguration");
        _x.authenticationType = authenticationType;
        return _x;
    }

    /**
     * <i>“Specify whether to cache user credentials on the device so that users don’t need
     * to keep entering them each time they connect.”</i>
     * 
     * @return property cacheCredentials
     */
    @Property(name="cacheCredentials")
    @JsonIgnore
    public Optional<Boolean> getCacheCredentials() {
        return Optional.ofNullable(cacheCredentials);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code cacheCredentials}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Specify whether to cache user credentials on the device so that users don’t need
     * to keep entering them each time they connect.”</i>
     * 
     * @param cacheCredentials
     *            new value of {@code cacheCredentials} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cacheCredentials} field changed
     */
    public WindowsWifiEnterpriseEAPConfiguration withCacheCredentials(Boolean cacheCredentials) {
        WindowsWifiEnterpriseEAPConfiguration _x = _copy();
        _x.changedFields = changedFields.add("cacheCredentials");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiEnterpriseEAPConfiguration");
        _x.cacheCredentials = cacheCredentials;
        return _x;
    }

    /**
     * <i>“Specify whether to prevent the user from being prompted to authorize new servers
     * for trusted certification authorities when EAP type is selected as PEAP.”</i>
     * 
     * @return property disableUserPromptForServerValidation
     */
    @Property(name="disableUserPromptForServerValidation")
    @JsonIgnore
    public Optional<Boolean> getDisableUserPromptForServerValidation() {
        return Optional.ofNullable(disableUserPromptForServerValidation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * disableUserPromptForServerValidation} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Specify whether to prevent the user from being prompted to authorize new servers
     * for trusted certification authorities when EAP type is selected as PEAP.”</i>
     * 
     * @param disableUserPromptForServerValidation
     *            new value of {@code disableUserPromptForServerValidation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code disableUserPromptForServerValidation} field changed
     */
    public WindowsWifiEnterpriseEAPConfiguration withDisableUserPromptForServerValidation(Boolean disableUserPromptForServerValidation) {
        WindowsWifiEnterpriseEAPConfiguration _x = _copy();
        _x.changedFields = changedFields.add("disableUserPromptForServerValidation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiEnterpriseEAPConfiguration");
        _x.disableUserPromptForServerValidation = disableUserPromptForServerValidation;
        return _x;
    }

    /**
     * <i>“Specify the number of seconds to wait before sending an EAPOL (Extensible
     * Authentication Protocol over LAN) Start message. Valid range 1-3600.”</i>
     * 
     * @return property eapolStartPeriodInSeconds
     */
    @Property(name="eapolStartPeriodInSeconds")
    @JsonIgnore
    public Optional<Integer> getEapolStartPeriodInSeconds() {
        return Optional.ofNullable(eapolStartPeriodInSeconds);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * eapolStartPeriodInSeconds} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Specify the number of seconds to wait before sending an EAPOL (Extensible
     * Authentication Protocol over LAN) Start message. Valid range 1-3600.”</i>
     * 
     * @param eapolStartPeriodInSeconds
     *            new value of {@code eapolStartPeriodInSeconds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code eapolStartPeriodInSeconds} field changed
     */
    public WindowsWifiEnterpriseEAPConfiguration withEapolStartPeriodInSeconds(Integer eapolStartPeriodInSeconds) {
        WindowsWifiEnterpriseEAPConfiguration _x = _copy();
        _x.changedFields = changedFields.add("eapolStartPeriodInSeconds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiEnterpriseEAPConfiguration");
        _x.eapolStartPeriodInSeconds = eapolStartPeriodInSeconds;
        return _x;
    }

    /**
     * <i>“Extensible Authentication Protocol (EAP). Indicates the type of EAP protocol set
     * on the Wi-Fi endpoint (router).”</i>
     * 
     * @return property eapType
     */
    @Property(name="eapType")
    @JsonIgnore
    public Optional<EapType> getEapType() {
        return Optional.ofNullable(eapType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code eapType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Extensible Authentication Protocol (EAP). Indicates the type of EAP protocol set
     * on the Wi-Fi endpoint (router).”</i>
     * 
     * @param eapType
     *            new value of {@code eapType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code eapType} field changed
     */
    public WindowsWifiEnterpriseEAPConfiguration withEapType(EapType eapType) {
        WindowsWifiEnterpriseEAPConfiguration _x = _copy();
        _x.changedFields = changedFields.add("eapType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiEnterpriseEAPConfiguration");
        _x.eapType = eapType;
        return _x;
    }

    /**
     * <i>“Specify whether the wifi connection should enable pairwise master key caching.”</i>
     * 
     * @return property enablePairwiseMasterKeyCaching
     */
    @Property(name="enablePairwiseMasterKeyCaching")
    @JsonIgnore
    public Optional<Boolean> getEnablePairwiseMasterKeyCaching() {
        return Optional.ofNullable(enablePairwiseMasterKeyCaching);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enablePairwiseMasterKeyCaching} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Specify whether the wifi connection should enable pairwise master key caching.”</i>
     * 
     * @param enablePairwiseMasterKeyCaching
     *            new value of {@code enablePairwiseMasterKeyCaching} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enablePairwiseMasterKeyCaching} field changed
     */
    public WindowsWifiEnterpriseEAPConfiguration withEnablePairwiseMasterKeyCaching(Boolean enablePairwiseMasterKeyCaching) {
        WindowsWifiEnterpriseEAPConfiguration _x = _copy();
        _x.changedFields = changedFields.add("enablePairwiseMasterKeyCaching");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiEnterpriseEAPConfiguration");
        _x.enablePairwiseMasterKeyCaching = enablePairwiseMasterKeyCaching;
        return _x;
    }

    /**
     * <i>“Specify whether pre-authentication should be enabled.”</i>
     * 
     * @return property enablePreAuthentication
     */
    @Property(name="enablePreAuthentication")
    @JsonIgnore
    public Optional<Boolean> getEnablePreAuthentication() {
        return Optional.ofNullable(enablePreAuthentication);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enablePreAuthentication} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Specify whether pre-authentication should be enabled.”</i>
     * 
     * @param enablePreAuthentication
     *            new value of {@code enablePreAuthentication} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enablePreAuthentication} field changed
     */
    public WindowsWifiEnterpriseEAPConfiguration withEnablePreAuthentication(Boolean enablePreAuthentication) {
        WindowsWifiEnterpriseEAPConfiguration _x = _copy();
        _x.changedFields = changedFields.add("enablePreAuthentication");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiEnterpriseEAPConfiguration");
        _x.enablePreAuthentication = enablePreAuthentication;
        return _x;
    }

    /**
     * <i>“Specify inner authentication protocol for EAP TTLS.”</i>
     * 
     * @return property innerAuthenticationProtocolForEAPTTLS
     */
    @Property(name="innerAuthenticationProtocolForEAPTTLS")
    @JsonIgnore
    public Optional<NonEapAuthenticationMethodForEapTtlsType> getInnerAuthenticationProtocolForEAPTTLS() {
        return Optional.ofNullable(innerAuthenticationProtocolForEAPTTLS);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * innerAuthenticationProtocolForEAPTTLS} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Specify inner authentication protocol for EAP TTLS.”</i>
     * 
     * @param innerAuthenticationProtocolForEAPTTLS
     *            new value of {@code innerAuthenticationProtocolForEAPTTLS} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code innerAuthenticationProtocolForEAPTTLS} field changed
     */
    public WindowsWifiEnterpriseEAPConfiguration withInnerAuthenticationProtocolForEAPTTLS(NonEapAuthenticationMethodForEapTtlsType innerAuthenticationProtocolForEAPTTLS) {
        WindowsWifiEnterpriseEAPConfiguration _x = _copy();
        _x.changedFields = changedFields.add("innerAuthenticationProtocolForEAPTTLS");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiEnterpriseEAPConfiguration");
        _x.innerAuthenticationProtocolForEAPTTLS = innerAuthenticationProtocolForEAPTTLS;
        return _x;
    }

    /**
     * <i>“Specify the maximum authentication failures allowed for a set of credentials.
     * Valid range 1-100.”</i>
     * 
     * @return property maximumAuthenticationFailures
     */
    @Property(name="maximumAuthenticationFailures")
    @JsonIgnore
    public Optional<Integer> getMaximumAuthenticationFailures() {
        return Optional.ofNullable(maximumAuthenticationFailures);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * maximumAuthenticationFailures} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Specify the maximum authentication failures allowed for a set of credentials.
     * Valid range 1-100.”</i>
     * 
     * @param maximumAuthenticationFailures
     *            new value of {@code maximumAuthenticationFailures} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code maximumAuthenticationFailures} field changed
     */
    public WindowsWifiEnterpriseEAPConfiguration withMaximumAuthenticationFailures(Integer maximumAuthenticationFailures) {
        WindowsWifiEnterpriseEAPConfiguration _x = _copy();
        _x.changedFields = changedFields.add("maximumAuthenticationFailures");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiEnterpriseEAPConfiguration");
        _x.maximumAuthenticationFailures = maximumAuthenticationFailures;
        return _x;
    }

    /**
     * <i>“Specify maximum authentication timeout (in seconds).  Valid range: 1-120”</i>
     * 
     * @return property maximumAuthenticationTimeoutInSeconds
     */
    @Property(name="maximumAuthenticationTimeoutInSeconds")
    @JsonIgnore
    public Optional<Integer> getMaximumAuthenticationTimeoutInSeconds() {
        return Optional.ofNullable(maximumAuthenticationTimeoutInSeconds);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * maximumAuthenticationTimeoutInSeconds} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Specify maximum authentication timeout (in seconds).  Valid range: 1-120”</i>
     * 
     * @param maximumAuthenticationTimeoutInSeconds
     *            new value of {@code maximumAuthenticationTimeoutInSeconds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code maximumAuthenticationTimeoutInSeconds} field changed
     */
    public WindowsWifiEnterpriseEAPConfiguration withMaximumAuthenticationTimeoutInSeconds(Integer maximumAuthenticationTimeoutInSeconds) {
        WindowsWifiEnterpriseEAPConfiguration _x = _copy();
        _x.changedFields = changedFields.add("maximumAuthenticationTimeoutInSeconds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiEnterpriseEAPConfiguration");
        _x.maximumAuthenticationTimeoutInSeconds = maximumAuthenticationTimeoutInSeconds;
        return _x;
    }

    /**
     * <i>“Specifiy the maximum number of EAPOL (Extensible Authentication Protocol over
     * LAN) Start messages to be sent before returning failure. Valid range 1-100.”</i>
     * 
     * @return property maximumEAPOLStartMessages
     */
    @Property(name="maximumEAPOLStartMessages")
    @JsonIgnore
    public Optional<Integer> getMaximumEAPOLStartMessages() {
        return Optional.ofNullable(maximumEAPOLStartMessages);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * maximumEAPOLStartMessages} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Specifiy the maximum number of EAPOL (Extensible Authentication Protocol over
     * LAN) Start messages to be sent before returning failure. Valid range 1-100.”</i>
     * 
     * @param maximumEAPOLStartMessages
     *            new value of {@code maximumEAPOLStartMessages} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code maximumEAPOLStartMessages} field changed
     */
    public WindowsWifiEnterpriseEAPConfiguration withMaximumEAPOLStartMessages(Integer maximumEAPOLStartMessages) {
        WindowsWifiEnterpriseEAPConfiguration _x = _copy();
        _x.changedFields = changedFields.add("maximumEAPOLStartMessages");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiEnterpriseEAPConfiguration");
        _x.maximumEAPOLStartMessages = maximumEAPOLStartMessages;
        return _x;
    }

    /**
     * <i>“Specify maximum number of pairwise master keys in cache.  Valid range: 1-255”</i>
     * 
     * @return property maximumNumberOfPairwiseMasterKeysInCache
     */
    @Property(name="maximumNumberOfPairwiseMasterKeysInCache")
    @JsonIgnore
    public Optional<Integer> getMaximumNumberOfPairwiseMasterKeysInCache() {
        return Optional.ofNullable(maximumNumberOfPairwiseMasterKeysInCache);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * maximumNumberOfPairwiseMasterKeysInCache} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Specify maximum number of pairwise master keys in cache.  Valid range: 1-255”</i>
     * 
     * @param maximumNumberOfPairwiseMasterKeysInCache
     *            new value of {@code maximumNumberOfPairwiseMasterKeysInCache} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code maximumNumberOfPairwiseMasterKeysInCache} field changed
     */
    public WindowsWifiEnterpriseEAPConfiguration withMaximumNumberOfPairwiseMasterKeysInCache(Integer maximumNumberOfPairwiseMasterKeysInCache) {
        WindowsWifiEnterpriseEAPConfiguration _x = _copy();
        _x.changedFields = changedFields.add("maximumNumberOfPairwiseMasterKeysInCache");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiEnterpriseEAPConfiguration");
        _x.maximumNumberOfPairwiseMasterKeysInCache = maximumNumberOfPairwiseMasterKeysInCache;
        return _x;
    }

    /**
     * <i>“Specify maximum pairwise master key cache time (in minutes).  Valid range: 5-
     * 1440”</i>
     * 
     * @return property maximumPairwiseMasterKeyCacheTimeInMinutes
     */
    @Property(name="maximumPairwiseMasterKeyCacheTimeInMinutes")
    @JsonIgnore
    public Optional<Integer> getMaximumPairwiseMasterKeyCacheTimeInMinutes() {
        return Optional.ofNullable(maximumPairwiseMasterKeyCacheTimeInMinutes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * maximumPairwiseMasterKeyCacheTimeInMinutes} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Specify maximum pairwise master key cache time (in minutes).  Valid range: 5-
     * 1440”</i>
     * 
     * @param maximumPairwiseMasterKeyCacheTimeInMinutes
     *            new value of {@code maximumPairwiseMasterKeyCacheTimeInMinutes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code maximumPairwiseMasterKeyCacheTimeInMinutes} field changed
     */
    public WindowsWifiEnterpriseEAPConfiguration withMaximumPairwiseMasterKeyCacheTimeInMinutes(Integer maximumPairwiseMasterKeyCacheTimeInMinutes) {
        WindowsWifiEnterpriseEAPConfiguration _x = _copy();
        _x.changedFields = changedFields.add("maximumPairwiseMasterKeyCacheTimeInMinutes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiEnterpriseEAPConfiguration");
        _x.maximumPairwiseMasterKeyCacheTimeInMinutes = maximumPairwiseMasterKeyCacheTimeInMinutes;
        return _x;
    }

    /**
     * <i>“Specify maximum pre-authentication attempts.  Valid range: 1-16”</i>
     * 
     * @return property maximumPreAuthenticationAttempts
     */
    @Property(name="maximumPreAuthenticationAttempts")
    @JsonIgnore
    public Optional<Integer> getMaximumPreAuthenticationAttempts() {
        return Optional.ofNullable(maximumPreAuthenticationAttempts);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * maximumPreAuthenticationAttempts} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Specify maximum pre-authentication attempts.  Valid range: 1-16”</i>
     * 
     * @param maximumPreAuthenticationAttempts
     *            new value of {@code maximumPreAuthenticationAttempts} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code maximumPreAuthenticationAttempts} field changed
     */
    public WindowsWifiEnterpriseEAPConfiguration withMaximumPreAuthenticationAttempts(Integer maximumPreAuthenticationAttempts) {
        WindowsWifiEnterpriseEAPConfiguration _x = _copy();
        _x.changedFields = changedFields.add("maximumPreAuthenticationAttempts");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiEnterpriseEAPConfiguration");
        _x.maximumPreAuthenticationAttempts = maximumPreAuthenticationAttempts;
        return _x;
    }

    /**
     * <i>“Specify the network single sign on type.”</i>
     * 
     * @return property networkSingleSignOn
     */
    @Property(name="networkSingleSignOn")
    @JsonIgnore
    public Optional<NetworkSingleSignOnType> getNetworkSingleSignOn() {
        return Optional.ofNullable(networkSingleSignOn);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * networkSingleSignOn} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Specify the network single sign on type.”</i>
     * 
     * @param networkSingleSignOn
     *            new value of {@code networkSingleSignOn} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code networkSingleSignOn} field changed
     */
    public WindowsWifiEnterpriseEAPConfiguration withNetworkSingleSignOn(NetworkSingleSignOnType networkSingleSignOn) {
        WindowsWifiEnterpriseEAPConfiguration _x = _copy();
        _x.changedFields = changedFields.add("networkSingleSignOn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiEnterpriseEAPConfiguration");
        _x.networkSingleSignOn = networkSingleSignOn;
        return _x;
    }

    /**
     * <i>“Specify the string to replace usernames for privacy when using EAP TTLS or PEAP.”</i>
     * 
     * @return property outerIdentityPrivacyTemporaryValue
     */
    @Property(name="outerIdentityPrivacyTemporaryValue")
    @JsonIgnore
    public Optional<String> getOuterIdentityPrivacyTemporaryValue() {
        return Optional.ofNullable(outerIdentityPrivacyTemporaryValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * outerIdentityPrivacyTemporaryValue} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Specify the string to replace usernames for privacy when using EAP TTLS or PEAP.”</i>
     * 
     * @param outerIdentityPrivacyTemporaryValue
     *            new value of {@code outerIdentityPrivacyTemporaryValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code outerIdentityPrivacyTemporaryValue} field changed
     */
    public WindowsWifiEnterpriseEAPConfiguration withOuterIdentityPrivacyTemporaryValue(String outerIdentityPrivacyTemporaryValue) {
        WindowsWifiEnterpriseEAPConfiguration _x = _copy();
        _x.changedFields = changedFields.add("outerIdentityPrivacyTemporaryValue");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiEnterpriseEAPConfiguration");
        _x.outerIdentityPrivacyTemporaryValue = outerIdentityPrivacyTemporaryValue;
        return _x;
    }

    /**
     * <i>“Specify whether to enable verification of server's identity by validating the
     * certificate when EAP type is selected as PEAP.”</i>
     * 
     * @return property performServerValidation
     */
    @Property(name="performServerValidation")
    @JsonIgnore
    public Optional<Boolean> getPerformServerValidation() {
        return Optional.ofNullable(performServerValidation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * performServerValidation} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Specify whether to enable verification of server's identity by validating the
     * certificate when EAP type is selected as PEAP.”</i>
     * 
     * @param performServerValidation
     *            new value of {@code performServerValidation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code performServerValidation} field changed
     */
    public WindowsWifiEnterpriseEAPConfiguration withPerformServerValidation(Boolean performServerValidation) {
        WindowsWifiEnterpriseEAPConfiguration _x = _copy();
        _x.changedFields = changedFields.add("performServerValidation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiEnterpriseEAPConfiguration");
        _x.performServerValidation = performServerValidation;
        return _x;
    }

    /**
     * <i>“Specify whether the wifi connection should prompt for additional authentication
     * credentials.”</i>
     * 
     * @return property promptForAdditionalAuthenticationCredentials
     */
    @Property(name="promptForAdditionalAuthenticationCredentials")
    @JsonIgnore
    public Optional<Boolean> getPromptForAdditionalAuthenticationCredentials() {
        return Optional.ofNullable(promptForAdditionalAuthenticationCredentials);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * promptForAdditionalAuthenticationCredentials} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Specify whether the wifi connection should prompt for additional authentication
     * credentials.”</i>
     * 
     * @param promptForAdditionalAuthenticationCredentials
     *            new value of {@code promptForAdditionalAuthenticationCredentials} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code promptForAdditionalAuthenticationCredentials} field changed
     */
    public WindowsWifiEnterpriseEAPConfiguration withPromptForAdditionalAuthenticationCredentials(Boolean promptForAdditionalAuthenticationCredentials) {
        WindowsWifiEnterpriseEAPConfiguration _x = _copy();
        _x.changedFields = changedFields.add("promptForAdditionalAuthenticationCredentials");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiEnterpriseEAPConfiguration");
        _x.promptForAdditionalAuthenticationCredentials = promptForAdditionalAuthenticationCredentials;
        return _x;
    }

    /**
     * <i>“Specify whether to enable cryptographic binding when EAP type is selected as
     * PEAP.”</i>
     * 
     * @return property requireCryptographicBinding
     */
    @Property(name="requireCryptographicBinding")
    @JsonIgnore
    public Optional<Boolean> getRequireCryptographicBinding() {
        return Optional.ofNullable(requireCryptographicBinding);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * requireCryptographicBinding} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Specify whether to enable cryptographic binding when EAP type is selected as
     * PEAP.”</i>
     * 
     * @param requireCryptographicBinding
     *            new value of {@code requireCryptographicBinding} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requireCryptographicBinding} field changed
     */
    public WindowsWifiEnterpriseEAPConfiguration withRequireCryptographicBinding(Boolean requireCryptographicBinding) {
        WindowsWifiEnterpriseEAPConfiguration _x = _copy();
        _x.changedFields = changedFields.add("requireCryptographicBinding");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiEnterpriseEAPConfiguration");
        _x.requireCryptographicBinding = requireCryptographicBinding;
        return _x;
    }

    /**
     * <i>“Specify trusted server certificate names.”</i>
     * 
     * @return property trustedServerCertificateNames
     */
    @Property(name="trustedServerCertificateNames")
    @JsonIgnore
    public CollectionPage<String> getTrustedServerCertificateNames() {
        return new CollectionPage<String>(contextPath, String.class, this.trustedServerCertificateNames, Optional.ofNullable(trustedServerCertificateNamesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * trustedServerCertificateNames} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Specify trusted server certificate names.”</i>
     * 
     * @param trustedServerCertificateNames
     *            new value of {@code trustedServerCertificateNames} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code trustedServerCertificateNames} field changed
     */
    public WindowsWifiEnterpriseEAPConfiguration withTrustedServerCertificateNames(List<String> trustedServerCertificateNames) {
        WindowsWifiEnterpriseEAPConfiguration _x = _copy();
        _x.changedFields = changedFields.add("trustedServerCertificateNames");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiEnterpriseEAPConfiguration");
        _x.trustedServerCertificateNames = trustedServerCertificateNames;
        return _x;
    }

    /**
     * <i>“Specify trusted server certificate names.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property trustedServerCertificateNames
     */
    @Property(name="trustedServerCertificateNames")
    @JsonIgnore
    public CollectionPage<String> getTrustedServerCertificateNames(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.trustedServerCertificateNames, Optional.ofNullable(trustedServerCertificateNamesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Specifiy whether to change the virtual LAN used by the device based on the user
     * ’s credentials. Cannot be used when NetworkSingleSignOnType is set to ​Disabled.”</i>
     * 
     * @return property userBasedVirtualLan
     */
    @Property(name="userBasedVirtualLan")
    @JsonIgnore
    public Optional<Boolean> getUserBasedVirtualLan() {
        return Optional.ofNullable(userBasedVirtualLan);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userBasedVirtualLan} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Specifiy whether to change the virtual LAN used by the device based on the user
     * ’s credentials. Cannot be used when NetworkSingleSignOnType is set to ​Disabled.”</i>
     * 
     * @param userBasedVirtualLan
     *            new value of {@code userBasedVirtualLan} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userBasedVirtualLan} field changed
     */
    public WindowsWifiEnterpriseEAPConfiguration withUserBasedVirtualLan(Boolean userBasedVirtualLan) {
        WindowsWifiEnterpriseEAPConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userBasedVirtualLan");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsWifiEnterpriseEAPConfiguration");
        _x.userBasedVirtualLan = userBasedVirtualLan;
        return _x;
    }

    public WindowsWifiEnterpriseEAPConfiguration withUnmappedField(String name, Object value) {
        WindowsWifiEnterpriseEAPConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“Specify identity certificate for client authentication.”</i>
     * 
     * @return navigational property identityCertificateForClientAuthentication
     */
    @NavigationProperty(name="identityCertificateForClientAuthentication")
    @JsonIgnore
    public WindowsCertificateProfileBaseRequest getIdentityCertificateForClientAuthentication() {
        return new WindowsCertificateProfileBaseRequest(contextPath.addSegment("identityCertificateForClientAuthentication"), RequestHelper.getValue(unmappedFields, "identityCertificateForClientAuthentication"));
    }

    /**
     * <i>“Specify root certificate for client validation.”</i>
     * 
     * @return navigational property rootCertificateForClientValidation
     */
    @NavigationProperty(name="rootCertificateForClientValidation")
    @JsonIgnore
    public Windows81TrustedRootCertificateRequest getRootCertificateForClientValidation() {
        return new Windows81TrustedRootCertificateRequest(contextPath.addSegment("rootCertificateForClientValidation"), RequestHelper.getValue(unmappedFields, "rootCertificateForClientValidation"));
    }

    /**
     * <i>“Specify root certificate for server validation. This collection can contain a
     * maximum of 500 elements.”</i>
     * 
     * @return navigational property rootCertificatesForServerValidation
     */
    @NavigationProperty(name="rootCertificatesForServerValidation")
    @JsonIgnore
    public Windows81TrustedRootCertificateCollectionRequest getRootCertificatesForServerValidation() {
        return new Windows81TrustedRootCertificateCollectionRequest(
                        contextPath.addSegment("rootCertificatesForServerValidation"), RequestHelper.getValue(unmappedFields, "rootCertificatesForServerValidation"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsWifiEnterpriseEAPConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsWifiEnterpriseEAPConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsWifiEnterpriseEAPConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsWifiEnterpriseEAPConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsWifiEnterpriseEAPConfiguration _copy() {
        WindowsWifiEnterpriseEAPConfiguration _x = new WindowsWifiEnterpriseEAPConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.version = version;
        _x.assignments = assignments;
        _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
        _x.deviceStatuses = deviceStatuses;
        _x.deviceStatusOverview = deviceStatusOverview;
        _x.groupAssignments = groupAssignments;
        _x.userStatuses = userStatuses;
        _x.userStatusOverview = userStatusOverview;
        _x.connectAutomatically = connectAutomatically;
        _x.connectToPreferredNetwork = connectToPreferredNetwork;
        _x.connectWhenNetworkNameIsHidden = connectWhenNetworkNameIsHidden;
        _x.forceFIPSCompliance = forceFIPSCompliance;
        _x.meteredConnectionLimit = meteredConnectionLimit;
        _x.networkName = networkName;
        _x.preSharedKey = preSharedKey;
        _x.proxyAutomaticConfigurationUrl = proxyAutomaticConfigurationUrl;
        _x.proxyManualAddress = proxyManualAddress;
        _x.proxyManualPort = proxyManualPort;
        _x.proxySetting = proxySetting;
        _x.ssid = ssid;
        _x.wifiSecurityType = wifiSecurityType;
        _x.authenticationMethod = authenticationMethod;
        _x.authenticationPeriodInSeconds = authenticationPeriodInSeconds;
        _x.authenticationRetryDelayPeriodInSeconds = authenticationRetryDelayPeriodInSeconds;
        _x.authenticationType = authenticationType;
        _x.cacheCredentials = cacheCredentials;
        _x.disableUserPromptForServerValidation = disableUserPromptForServerValidation;
        _x.eapolStartPeriodInSeconds = eapolStartPeriodInSeconds;
        _x.eapType = eapType;
        _x.enablePairwiseMasterKeyCaching = enablePairwiseMasterKeyCaching;
        _x.enablePreAuthentication = enablePreAuthentication;
        _x.innerAuthenticationProtocolForEAPTTLS = innerAuthenticationProtocolForEAPTTLS;
        _x.maximumAuthenticationFailures = maximumAuthenticationFailures;
        _x.maximumAuthenticationTimeoutInSeconds = maximumAuthenticationTimeoutInSeconds;
        _x.maximumEAPOLStartMessages = maximumEAPOLStartMessages;
        _x.maximumNumberOfPairwiseMasterKeysInCache = maximumNumberOfPairwiseMasterKeysInCache;
        _x.maximumPairwiseMasterKeyCacheTimeInMinutes = maximumPairwiseMasterKeyCacheTimeInMinutes;
        _x.maximumPreAuthenticationAttempts = maximumPreAuthenticationAttempts;
        _x.networkSingleSignOn = networkSingleSignOn;
        _x.outerIdentityPrivacyTemporaryValue = outerIdentityPrivacyTemporaryValue;
        _x.performServerValidation = performServerValidation;
        _x.promptForAdditionalAuthenticationCredentials = promptForAdditionalAuthenticationCredentials;
        _x.requireCryptographicBinding = requireCryptographicBinding;
        _x.trustedServerCertificateNames = trustedServerCertificateNames;
        _x.userBasedVirtualLan = userBasedVirtualLan;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsWifiEnterpriseEAPConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceSettingStateSummaries=");
        b.append(this.deviceSettingStateSummaries);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("deviceStatusOverview=");
        b.append(this.deviceStatusOverview);
        b.append(", ");
        b.append("groupAssignments=");
        b.append(this.groupAssignments);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("userStatusOverview=");
        b.append(this.userStatusOverview);
        b.append(", ");
        b.append("connectAutomatically=");
        b.append(this.connectAutomatically);
        b.append(", ");
        b.append("connectToPreferredNetwork=");
        b.append(this.connectToPreferredNetwork);
        b.append(", ");
        b.append("connectWhenNetworkNameIsHidden=");
        b.append(this.connectWhenNetworkNameIsHidden);
        b.append(", ");
        b.append("forceFIPSCompliance=");
        b.append(this.forceFIPSCompliance);
        b.append(", ");
        b.append("meteredConnectionLimit=");
        b.append(this.meteredConnectionLimit);
        b.append(", ");
        b.append("networkName=");
        b.append(this.networkName);
        b.append(", ");
        b.append("preSharedKey=");
        b.append(this.preSharedKey);
        b.append(", ");
        b.append("proxyAutomaticConfigurationUrl=");
        b.append(this.proxyAutomaticConfigurationUrl);
        b.append(", ");
        b.append("proxyManualAddress=");
        b.append(this.proxyManualAddress);
        b.append(", ");
        b.append("proxyManualPort=");
        b.append(this.proxyManualPort);
        b.append(", ");
        b.append("proxySetting=");
        b.append(this.proxySetting);
        b.append(", ");
        b.append("ssid=");
        b.append(this.ssid);
        b.append(", ");
        b.append("wifiSecurityType=");
        b.append(this.wifiSecurityType);
        b.append(", ");
        b.append("authenticationMethod=");
        b.append(this.authenticationMethod);
        b.append(", ");
        b.append("authenticationPeriodInSeconds=");
        b.append(this.authenticationPeriodInSeconds);
        b.append(", ");
        b.append("authenticationRetryDelayPeriodInSeconds=");
        b.append(this.authenticationRetryDelayPeriodInSeconds);
        b.append(", ");
        b.append("authenticationType=");
        b.append(this.authenticationType);
        b.append(", ");
        b.append("cacheCredentials=");
        b.append(this.cacheCredentials);
        b.append(", ");
        b.append("disableUserPromptForServerValidation=");
        b.append(this.disableUserPromptForServerValidation);
        b.append(", ");
        b.append("eapolStartPeriodInSeconds=");
        b.append(this.eapolStartPeriodInSeconds);
        b.append(", ");
        b.append("eapType=");
        b.append(this.eapType);
        b.append(", ");
        b.append("enablePairwiseMasterKeyCaching=");
        b.append(this.enablePairwiseMasterKeyCaching);
        b.append(", ");
        b.append("enablePreAuthentication=");
        b.append(this.enablePreAuthentication);
        b.append(", ");
        b.append("innerAuthenticationProtocolForEAPTTLS=");
        b.append(this.innerAuthenticationProtocolForEAPTTLS);
        b.append(", ");
        b.append("maximumAuthenticationFailures=");
        b.append(this.maximumAuthenticationFailures);
        b.append(", ");
        b.append("maximumAuthenticationTimeoutInSeconds=");
        b.append(this.maximumAuthenticationTimeoutInSeconds);
        b.append(", ");
        b.append("maximumEAPOLStartMessages=");
        b.append(this.maximumEAPOLStartMessages);
        b.append(", ");
        b.append("maximumNumberOfPairwiseMasterKeysInCache=");
        b.append(this.maximumNumberOfPairwiseMasterKeysInCache);
        b.append(", ");
        b.append("maximumPairwiseMasterKeyCacheTimeInMinutes=");
        b.append(this.maximumPairwiseMasterKeyCacheTimeInMinutes);
        b.append(", ");
        b.append("maximumPreAuthenticationAttempts=");
        b.append(this.maximumPreAuthenticationAttempts);
        b.append(", ");
        b.append("networkSingleSignOn=");
        b.append(this.networkSingleSignOn);
        b.append(", ");
        b.append("outerIdentityPrivacyTemporaryValue=");
        b.append(this.outerIdentityPrivacyTemporaryValue);
        b.append(", ");
        b.append("performServerValidation=");
        b.append(this.performServerValidation);
        b.append(", ");
        b.append("promptForAdditionalAuthenticationCredentials=");
        b.append(this.promptForAdditionalAuthenticationCredentials);
        b.append(", ");
        b.append("requireCryptographicBinding=");
        b.append(this.requireCryptographicBinding);
        b.append(", ");
        b.append("trustedServerCertificateNames=");
        b.append(this.trustedServerCertificateNames);
        b.append(", ");
        b.append("userBasedVirtualLan=");
        b.append(this.userBasedVirtualLan);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
