package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.WindowsPrivacyDataAccessLevel;
import odata.msgraph.client.beta.enums.WindowsPrivacyDataCategory;


/**
 * <i>“Specify access control level per privacy data category”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "accessLevel", 
    "appDisplayName", 
    "appPackageFamilyName", 
    "dataCategory"})
@JsonInclude(Include.NON_NULL)
public class WindowsPrivacyDataAccessControlItem extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsPrivacyDataAccessControlItem";
    }

    @JsonProperty("accessLevel")
    protected WindowsPrivacyDataAccessLevel accessLevel;

    @JsonProperty("appDisplayName")
    protected String appDisplayName;

    @JsonProperty("appPackageFamilyName")
    protected String appPackageFamilyName;

    @JsonProperty("dataCategory")
    protected WindowsPrivacyDataCategory dataCategory;

    protected WindowsPrivacyDataAccessControlItem() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsPrivacyDataAccessControlItem() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private WindowsPrivacyDataAccessLevel accessLevel;
        private String appDisplayName;
        private String appPackageFamilyName;
        private WindowsPrivacyDataCategory dataCategory;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“This indicates an access level for the privacy data category to which the
         * specified application will be given to.”</i>
         * 
         * @param accessLevel
         *            value of {@code accessLevel} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder accessLevel(WindowsPrivacyDataAccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            this.changedFields = changedFields.add("accessLevel");
            return this;
        }

        /**
         * <i>“The Package Family Name of a Windows app. When set, the access level applies to
         * the specified application.”</i>
         * 
         * @param appDisplayName
         *            value of {@code appDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appDisplayName(String appDisplayName) {
            this.appDisplayName = appDisplayName;
            this.changedFields = changedFields.add("appDisplayName");
            return this;
        }

        /**
         * <i>“The Package Family Name of a Windows app. When set, the access level applies to
         * the specified application.”</i>
         * 
         * @param appPackageFamilyName
         *            value of {@code appPackageFamilyName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appPackageFamilyName(String appPackageFamilyName) {
            this.appPackageFamilyName = appPackageFamilyName;
            this.changedFields = changedFields.add("appPackageFamilyName");
            return this;
        }

        /**
         * <i>“This indicates a privacy data category to which the specific access control will
         * apply.”</i>
         * 
         * @param dataCategory
         *            value of {@code dataCategory} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dataCategory(WindowsPrivacyDataCategory dataCategory) {
            this.dataCategory = dataCategory;
            this.changedFields = changedFields.add("dataCategory");
            return this;
        }

        public WindowsPrivacyDataAccessControlItem build() {
            WindowsPrivacyDataAccessControlItem _x = new WindowsPrivacyDataAccessControlItem();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsPrivacyDataAccessControlItem";
            _x.id = id;
            _x.accessLevel = accessLevel;
            _x.appDisplayName = appDisplayName;
            _x.appPackageFamilyName = appPackageFamilyName;
            _x.dataCategory = dataCategory;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“This indicates an access level for the privacy data category to which the
     * specified application will be given to.”</i>
     * 
     * @return property accessLevel
     */
    @Property(name="accessLevel")
    @JsonIgnore
    public Optional<WindowsPrivacyDataAccessLevel> getAccessLevel() {
        return Optional.ofNullable(accessLevel);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code accessLevel}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“This indicates an access level for the privacy data category to which the
     * specified application will be given to.”</i>
     * 
     * @param accessLevel
     *            new value of {@code accessLevel} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code accessLevel} field changed
     */
    public WindowsPrivacyDataAccessControlItem withAccessLevel(WindowsPrivacyDataAccessLevel accessLevel) {
        WindowsPrivacyDataAccessControlItem _x = _copy();
        _x.changedFields = changedFields.add("accessLevel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPrivacyDataAccessControlItem");
        _x.accessLevel = accessLevel;
        return _x;
    }

    /**
     * <i>“The Package Family Name of a Windows app. When set, the access level applies to
     * the specified application.”</i>
     * 
     * @return property appDisplayName
     */
    @Property(name="appDisplayName")
    @JsonIgnore
    public Optional<String> getAppDisplayName() {
        return Optional.ofNullable(appDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appDisplayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The Package Family Name of a Windows app. When set, the access level applies to
     * the specified application.”</i>
     * 
     * @param appDisplayName
     *            new value of {@code appDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appDisplayName} field changed
     */
    public WindowsPrivacyDataAccessControlItem withAppDisplayName(String appDisplayName) {
        WindowsPrivacyDataAccessControlItem _x = _copy();
        _x.changedFields = changedFields.add("appDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPrivacyDataAccessControlItem");
        _x.appDisplayName = appDisplayName;
        return _x;
    }

    /**
     * <i>“The Package Family Name of a Windows app. When set, the access level applies to
     * the specified application.”</i>
     * 
     * @return property appPackageFamilyName
     */
    @Property(name="appPackageFamilyName")
    @JsonIgnore
    public Optional<String> getAppPackageFamilyName() {
        return Optional.ofNullable(appPackageFamilyName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appPackageFamilyName} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The Package Family Name of a Windows app. When set, the access level applies to
     * the specified application.”</i>
     * 
     * @param appPackageFamilyName
     *            new value of {@code appPackageFamilyName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appPackageFamilyName} field changed
     */
    public WindowsPrivacyDataAccessControlItem withAppPackageFamilyName(String appPackageFamilyName) {
        WindowsPrivacyDataAccessControlItem _x = _copy();
        _x.changedFields = changedFields.add("appPackageFamilyName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPrivacyDataAccessControlItem");
        _x.appPackageFamilyName = appPackageFamilyName;
        return _x;
    }

    /**
     * <i>“This indicates a privacy data category to which the specific access control will
     * apply.”</i>
     * 
     * @return property dataCategory
     */
    @Property(name="dataCategory")
    @JsonIgnore
    public Optional<WindowsPrivacyDataCategory> getDataCategory() {
        return Optional.ofNullable(dataCategory);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code dataCategory}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“This indicates a privacy data category to which the specific access control will
     * apply.”</i>
     * 
     * @param dataCategory
     *            new value of {@code dataCategory} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code dataCategory} field changed
     */
    public WindowsPrivacyDataAccessControlItem withDataCategory(WindowsPrivacyDataCategory dataCategory) {
        WindowsPrivacyDataAccessControlItem _x = _copy();
        _x.changedFields = changedFields.add("dataCategory");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPrivacyDataAccessControlItem");
        _x.dataCategory = dataCategory;
        return _x;
    }

    public WindowsPrivacyDataAccessControlItem withUnmappedField(String name, Object value) {
        WindowsPrivacyDataAccessControlItem _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsPrivacyDataAccessControlItem patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsPrivacyDataAccessControlItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsPrivacyDataAccessControlItem put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsPrivacyDataAccessControlItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsPrivacyDataAccessControlItem _copy() {
        WindowsPrivacyDataAccessControlItem _x = new WindowsPrivacyDataAccessControlItem();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.accessLevel = accessLevel;
        _x.appDisplayName = appDisplayName;
        _x.appPackageFamilyName = appPackageFamilyName;
        _x.dataCategory = dataCategory;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsPrivacyDataAccessControlItem[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("accessLevel=");
        b.append(this.accessLevel);
        b.append(", ");
        b.append("appDisplayName=");
        b.append(this.appDisplayName);
        b.append(", ");
        b.append("appPackageFamilyName=");
        b.append(this.appPackageFamilyName);
        b.append(", ");
        b.append("dataCategory=");
        b.append(this.dataCategory);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
