package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.MimeContent;
import odata.msgraph.client.beta.complex.WindowsMinimumOperatingSystem;
import odata.msgraph.client.beta.complex.WindowsPackageInformation;
import odata.msgraph.client.beta.enums.MobileAppPublishingState;
import odata.msgraph.client.beta.enums.WindowsArchitecture;


/**
 * <i>“Contains properties and inherited properties for Windows Phone 8.1 AppX Bundle
 * Line Of Business apps.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "appXPackageInformationList"})
@JsonInclude(Include.NON_NULL)
public class WindowsPhone81AppXBundle extends WindowsPhone81AppX implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsPhone81AppXBundle";
    }

    @JsonProperty("appXPackageInformationList")
    protected List<WindowsPackageInformation> appXPackageInformationList;

    @JsonProperty("appXPackageInformationList@nextLink")
    protected String appXPackageInformationListNextLink;

    protected WindowsPhone81AppXBundle() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsPhone81AppXBundle() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private Integer dependentAppCount;
        private String description;
        private String developer;
        private String displayName;
        private String informationUrl;
        private Boolean isAssigned;
        private Boolean isFeatured;
        private MimeContent largeIcon;
        private OffsetDateTime lastModifiedDateTime;
        private String notes;
        private String owner;
        private String privacyInformationUrl;
        private String publisher;
        private MobileAppPublishingState publishingState;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Integer supersededAppCount;
        private Integer supersedingAppCount;
        private Integer uploadState;
        private List<MobileAppAssignment> assignments;
        private List<MobileAppInstallStatus> deviceStatuses;
        private MobileAppInstallSummary installSummary;
        private List<MobileAppRelationship> relationships;
        private List<UserAppInstallStatus> userStatuses;
        private String committedContentVersion;
        private String fileName;
        private Long size;
        private List<MobileAppContent> contentVersions;
        private WindowsArchitecture applicableArchitectures;
        private String identityName;
        private String identityPublisherHash;
        private String identityResourceIdentifier;
        private String identityVersion;
        private WindowsMinimumOperatingSystem minimumSupportedOperatingSystem;
        private String phoneProductIdentifier;
        private String phonePublisherId;
        private List<WindowsPackageInformation> appXPackageInformationList;
        private String appXPackageInformationListNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder dependentAppCount(Integer dependentAppCount) {
            this.dependentAppCount = dependentAppCount;
            this.changedFields = changedFields.add("dependentAppCount");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder developer(String developer) {
            this.developer = developer;
            this.changedFields = changedFields.add("developer");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder informationUrl(String informationUrl) {
            this.informationUrl = informationUrl;
            this.changedFields = changedFields.add("informationUrl");
            return this;
        }

        public Builder isAssigned(Boolean isAssigned) {
            this.isAssigned = isAssigned;
            this.changedFields = changedFields.add("isAssigned");
            return this;
        }

        public Builder isFeatured(Boolean isFeatured) {
            this.isFeatured = isFeatured;
            this.changedFields = changedFields.add("isFeatured");
            return this;
        }

        public Builder largeIcon(MimeContent largeIcon) {
            this.largeIcon = largeIcon;
            this.changedFields = changedFields.add("largeIcon");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder notes(String notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("notes");
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            this.changedFields = changedFields.add("owner");
            return this;
        }

        public Builder privacyInformationUrl(String privacyInformationUrl) {
            this.privacyInformationUrl = privacyInformationUrl;
            this.changedFields = changedFields.add("privacyInformationUrl");
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            this.changedFields = changedFields.add("publisher");
            return this;
        }

        public Builder publishingState(MobileAppPublishingState publishingState) {
            this.publishingState = publishingState;
            this.changedFields = changedFields.add("publishingState");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supersededAppCount(Integer supersededAppCount) {
            this.supersededAppCount = supersededAppCount;
            this.changedFields = changedFields.add("supersededAppCount");
            return this;
        }

        public Builder supersedingAppCount(Integer supersedingAppCount) {
            this.supersedingAppCount = supersedingAppCount;
            this.changedFields = changedFields.add("supersedingAppCount");
            return this;
        }

        public Builder uploadState(Integer uploadState) {
            this.uploadState = uploadState;
            this.changedFields = changedFields.add("uploadState");
            return this;
        }

        public Builder assignments(List<MobileAppAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(MobileAppAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder deviceStatuses(List<MobileAppInstallStatus> deviceStatuses) {
            this.deviceStatuses = deviceStatuses;
            this.changedFields = changedFields.add("deviceStatuses");
            return this;
        }

        public Builder deviceStatuses(MobileAppInstallStatus... deviceStatuses) {
            return deviceStatuses(Arrays.asList(deviceStatuses));
        }

        public Builder installSummary(MobileAppInstallSummary installSummary) {
            this.installSummary = installSummary;
            this.changedFields = changedFields.add("installSummary");
            return this;
        }

        public Builder relationships(List<MobileAppRelationship> relationships) {
            this.relationships = relationships;
            this.changedFields = changedFields.add("relationships");
            return this;
        }

        public Builder relationships(MobileAppRelationship... relationships) {
            return relationships(Arrays.asList(relationships));
        }

        public Builder userStatuses(List<UserAppInstallStatus> userStatuses) {
            this.userStatuses = userStatuses;
            this.changedFields = changedFields.add("userStatuses");
            return this;
        }

        public Builder userStatuses(UserAppInstallStatus... userStatuses) {
            return userStatuses(Arrays.asList(userStatuses));
        }

        public Builder committedContentVersion(String committedContentVersion) {
            this.committedContentVersion = committedContentVersion;
            this.changedFields = changedFields.add("committedContentVersion");
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            this.changedFields = changedFields.add("fileName");
            return this;
        }

        public Builder size(Long size) {
            this.size = size;
            this.changedFields = changedFields.add("size");
            return this;
        }

        public Builder contentVersions(List<MobileAppContent> contentVersions) {
            this.contentVersions = contentVersions;
            this.changedFields = changedFields.add("contentVersions");
            return this;
        }

        public Builder contentVersions(MobileAppContent... contentVersions) {
            return contentVersions(Arrays.asList(contentVersions));
        }

        public Builder applicableArchitectures(WindowsArchitecture applicableArchitectures) {
            this.applicableArchitectures = applicableArchitectures;
            this.changedFields = changedFields.add("applicableArchitectures");
            return this;
        }

        public Builder identityName(String identityName) {
            this.identityName = identityName;
            this.changedFields = changedFields.add("identityName");
            return this;
        }

        public Builder identityPublisherHash(String identityPublisherHash) {
            this.identityPublisherHash = identityPublisherHash;
            this.changedFields = changedFields.add("identityPublisherHash");
            return this;
        }

        public Builder identityResourceIdentifier(String identityResourceIdentifier) {
            this.identityResourceIdentifier = identityResourceIdentifier;
            this.changedFields = changedFields.add("identityResourceIdentifier");
            return this;
        }

        public Builder identityVersion(String identityVersion) {
            this.identityVersion = identityVersion;
            this.changedFields = changedFields.add("identityVersion");
            return this;
        }

        public Builder minimumSupportedOperatingSystem(WindowsMinimumOperatingSystem minimumSupportedOperatingSystem) {
            this.minimumSupportedOperatingSystem = minimumSupportedOperatingSystem;
            this.changedFields = changedFields.add("minimumSupportedOperatingSystem");
            return this;
        }

        public Builder phoneProductIdentifier(String phoneProductIdentifier) {
            this.phoneProductIdentifier = phoneProductIdentifier;
            this.changedFields = changedFields.add("phoneProductIdentifier");
            return this;
        }

        public Builder phonePublisherId(String phonePublisherId) {
            this.phonePublisherId = phonePublisherId;
            this.changedFields = changedFields.add("phonePublisherId");
            return this;
        }

        /**
         * <i>“The list of AppX Package Information.”</i>
         * 
         * @param appXPackageInformationList
         *            value of {@code appXPackageInformationList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appXPackageInformationList(List<WindowsPackageInformation> appXPackageInformationList) {
            this.appXPackageInformationList = appXPackageInformationList;
            this.changedFields = changedFields.add("appXPackageInformationList");
            return this;
        }

        /**
         * <i>“The list of AppX Package Information.”</i>
         * 
         * @param appXPackageInformationList
         *            value of {@code appXPackageInformationList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appXPackageInformationList(WindowsPackageInformation... appXPackageInformationList) {
            return appXPackageInformationList(Arrays.asList(appXPackageInformationList));
        }

        /**
         * <i>“The list of AppX Package Information.”</i>
         * 
         * @param appXPackageInformationListNextLink
         *            value of {@code appXPackageInformationList@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appXPackageInformationListNextLink(String appXPackageInformationListNextLink) {
            this.appXPackageInformationListNextLink = appXPackageInformationListNextLink;
            this.changedFields = changedFields.add("appXPackageInformationList");
            return this;
        }

        public WindowsPhone81AppXBundle build() {
            WindowsPhone81AppXBundle _x = new WindowsPhone81AppXBundle();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsPhone81AppXBundle";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.dependentAppCount = dependentAppCount;
            _x.description = description;
            _x.developer = developer;
            _x.displayName = displayName;
            _x.informationUrl = informationUrl;
            _x.isAssigned = isAssigned;
            _x.isFeatured = isFeatured;
            _x.largeIcon = largeIcon;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.notes = notes;
            _x.owner = owner;
            _x.privacyInformationUrl = privacyInformationUrl;
            _x.publisher = publisher;
            _x.publishingState = publishingState;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supersededAppCount = supersededAppCount;
            _x.supersedingAppCount = supersedingAppCount;
            _x.uploadState = uploadState;
            _x.assignments = assignments;
            _x.deviceStatuses = deviceStatuses;
            _x.installSummary = installSummary;
            _x.relationships = relationships;
            _x.userStatuses = userStatuses;
            _x.committedContentVersion = committedContentVersion;
            _x.fileName = fileName;
            _x.size = size;
            _x.contentVersions = contentVersions;
            _x.applicableArchitectures = applicableArchitectures;
            _x.identityName = identityName;
            _x.identityPublisherHash = identityPublisherHash;
            _x.identityResourceIdentifier = identityResourceIdentifier;
            _x.identityVersion = identityVersion;
            _x.minimumSupportedOperatingSystem = minimumSupportedOperatingSystem;
            _x.phoneProductIdentifier = phoneProductIdentifier;
            _x.phonePublisherId = phonePublisherId;
            _x.appXPackageInformationList = appXPackageInformationList;
            _x.appXPackageInformationListNextLink = appXPackageInformationListNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The list of AppX Package Information.”</i>
     * 
     * @return property appXPackageInformationList
     */
    @Property(name="appXPackageInformationList")
    @JsonIgnore
    public CollectionPage<WindowsPackageInformation> getAppXPackageInformationList() {
        return new CollectionPage<WindowsPackageInformation>(contextPath, WindowsPackageInformation.class, this.appXPackageInformationList, Optional.ofNullable(appXPackageInformationListNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appXPackageInformationList} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The list of AppX Package Information.”</i>
     * 
     * @param appXPackageInformationList
     *            new value of {@code appXPackageInformationList} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appXPackageInformationList} field changed
     */
    public WindowsPhone81AppXBundle withAppXPackageInformationList(List<WindowsPackageInformation> appXPackageInformationList) {
        WindowsPhone81AppXBundle _x = _copy();
        _x.changedFields = changedFields.add("appXPackageInformationList");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsPhone81AppXBundle");
        _x.appXPackageInformationList = appXPackageInformationList;
        return _x;
    }

    /**
     * <i>“The list of AppX Package Information.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property appXPackageInformationList
     */
    @Property(name="appXPackageInformationList")
    @JsonIgnore
    public CollectionPage<WindowsPackageInformation> getAppXPackageInformationList(HttpRequestOptions options) {
        return new CollectionPage<WindowsPackageInformation>(contextPath, WindowsPackageInformation.class, this.appXPackageInformationList, Optional.ofNullable(appXPackageInformationListNextLink), Collections.emptyList(), options);
    }

    public WindowsPhone81AppXBundle withUnmappedField(String name, Object value) {
        WindowsPhone81AppXBundle _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsPhone81AppXBundle patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsPhone81AppXBundle _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsPhone81AppXBundle put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsPhone81AppXBundle _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsPhone81AppXBundle _copy() {
        WindowsPhone81AppXBundle _x = new WindowsPhone81AppXBundle();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.dependentAppCount = dependentAppCount;
        _x.description = description;
        _x.developer = developer;
        _x.displayName = displayName;
        _x.informationUrl = informationUrl;
        _x.isAssigned = isAssigned;
        _x.isFeatured = isFeatured;
        _x.largeIcon = largeIcon;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.notes = notes;
        _x.owner = owner;
        _x.privacyInformationUrl = privacyInformationUrl;
        _x.publisher = publisher;
        _x.publishingState = publishingState;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supersededAppCount = supersededAppCount;
        _x.supersedingAppCount = supersedingAppCount;
        _x.uploadState = uploadState;
        _x.assignments = assignments;
        _x.deviceStatuses = deviceStatuses;
        _x.installSummary = installSummary;
        _x.relationships = relationships;
        _x.userStatuses = userStatuses;
        _x.committedContentVersion = committedContentVersion;
        _x.fileName = fileName;
        _x.size = size;
        _x.contentVersions = contentVersions;
        _x.applicableArchitectures = applicableArchitectures;
        _x.identityName = identityName;
        _x.identityPublisherHash = identityPublisherHash;
        _x.identityResourceIdentifier = identityResourceIdentifier;
        _x.identityVersion = identityVersion;
        _x.minimumSupportedOperatingSystem = minimumSupportedOperatingSystem;
        _x.phoneProductIdentifier = phoneProductIdentifier;
        _x.phonePublisherId = phonePublisherId;
        _x.appXPackageInformationList = appXPackageInformationList;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsPhone81AppXBundle[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("dependentAppCount=");
        b.append(this.dependentAppCount);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("developer=");
        b.append(this.developer);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("informationUrl=");
        b.append(this.informationUrl);
        b.append(", ");
        b.append("isAssigned=");
        b.append(this.isAssigned);
        b.append(", ");
        b.append("isFeatured=");
        b.append(this.isFeatured);
        b.append(", ");
        b.append("largeIcon=");
        b.append(this.largeIcon);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("notes=");
        b.append(this.notes);
        b.append(", ");
        b.append("owner=");
        b.append(this.owner);
        b.append(", ");
        b.append("privacyInformationUrl=");
        b.append(this.privacyInformationUrl);
        b.append(", ");
        b.append("publisher=");
        b.append(this.publisher);
        b.append(", ");
        b.append("publishingState=");
        b.append(this.publishingState);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supersededAppCount=");
        b.append(this.supersededAppCount);
        b.append(", ");
        b.append("supersedingAppCount=");
        b.append(this.supersedingAppCount);
        b.append(", ");
        b.append("uploadState=");
        b.append(this.uploadState);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("installSummary=");
        b.append(this.installSummary);
        b.append(", ");
        b.append("relationships=");
        b.append(this.relationships);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("committedContentVersion=");
        b.append(this.committedContentVersion);
        b.append(", ");
        b.append("fileName=");
        b.append(this.fileName);
        b.append(", ");
        b.append("size=");
        b.append(this.size);
        b.append(", ");
        b.append("contentVersions=");
        b.append(this.contentVersions);
        b.append(", ");
        b.append("applicableArchitectures=");
        b.append(this.applicableArchitectures);
        b.append(", ");
        b.append("identityName=");
        b.append(this.identityName);
        b.append(", ");
        b.append("identityPublisherHash=");
        b.append(this.identityPublisherHash);
        b.append(", ");
        b.append("identityResourceIdentifier=");
        b.append(this.identityResourceIdentifier);
        b.append(", ");
        b.append("identityVersion=");
        b.append(this.identityVersion);
        b.append(", ");
        b.append("minimumSupportedOperatingSystem=");
        b.append(this.minimumSupportedOperatingSystem);
        b.append(", ");
        b.append("phoneProductIdentifier=");
        b.append(this.phoneProductIdentifier);
        b.append(", ");
        b.append("phonePublisherId=");
        b.append(this.phonePublisherId);
        b.append(", ");
        b.append("appXPackageInformationList=");
        b.append(this.appXPackageInformationList);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
