package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Contains properties for the health summary of the Windows management app.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "healthyDeviceCount", 
    "unhealthyDeviceCount", 
    "unknownDeviceCount"})
@JsonInclude(Include.NON_NULL)
public class WindowsManagementAppHealthSummary extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsManagementAppHealthSummary";
    }

    @JsonProperty("healthyDeviceCount")
    protected Integer healthyDeviceCount;

    @JsonProperty("unhealthyDeviceCount")
    protected Integer unhealthyDeviceCount;

    @JsonProperty("unknownDeviceCount")
    protected Integer unknownDeviceCount;

    protected WindowsManagementAppHealthSummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsManagementAppHealthSummary() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer healthyDeviceCount;
        private Integer unhealthyDeviceCount;
        private Integer unknownDeviceCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Healthy device count.”</i>
         * 
         * @param healthyDeviceCount
         *            value of {@code healthyDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder healthyDeviceCount(Integer healthyDeviceCount) {
            this.healthyDeviceCount = healthyDeviceCount;
            this.changedFields = changedFields.add("healthyDeviceCount");
            return this;
        }

        /**
         * <i>“Unhealthy device count.”</i>
         * 
         * @param unhealthyDeviceCount
         *            value of {@code unhealthyDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder unhealthyDeviceCount(Integer unhealthyDeviceCount) {
            this.unhealthyDeviceCount = unhealthyDeviceCount;
            this.changedFields = changedFields.add("unhealthyDeviceCount");
            return this;
        }

        /**
         * <i>“Unknown device count.”</i>
         * 
         * @param unknownDeviceCount
         *            value of {@code unknownDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder unknownDeviceCount(Integer unknownDeviceCount) {
            this.unknownDeviceCount = unknownDeviceCount;
            this.changedFields = changedFields.add("unknownDeviceCount");
            return this;
        }

        public WindowsManagementAppHealthSummary build() {
            WindowsManagementAppHealthSummary _x = new WindowsManagementAppHealthSummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsManagementAppHealthSummary";
            _x.id = id;
            _x.healthyDeviceCount = healthyDeviceCount;
            _x.unhealthyDeviceCount = unhealthyDeviceCount;
            _x.unknownDeviceCount = unknownDeviceCount;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Healthy device count.”</i>
     * 
     * @return property healthyDeviceCount
     */
    @Property(name="healthyDeviceCount")
    @JsonIgnore
    public Optional<Integer> getHealthyDeviceCount() {
        return Optional.ofNullable(healthyDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * healthyDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Healthy device count.”</i>
     * 
     * @param healthyDeviceCount
     *            new value of {@code healthyDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code healthyDeviceCount} field changed
     */
    public WindowsManagementAppHealthSummary withHealthyDeviceCount(Integer healthyDeviceCount) {
        WindowsManagementAppHealthSummary _x = _copy();
        _x.changedFields = changedFields.add("healthyDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsManagementAppHealthSummary");
        _x.healthyDeviceCount = healthyDeviceCount;
        return _x;
    }

    /**
     * <i>“Unhealthy device count.”</i>
     * 
     * @return property unhealthyDeviceCount
     */
    @Property(name="unhealthyDeviceCount")
    @JsonIgnore
    public Optional<Integer> getUnhealthyDeviceCount() {
        return Optional.ofNullable(unhealthyDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * unhealthyDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Unhealthy device count.”</i>
     * 
     * @param unhealthyDeviceCount
     *            new value of {@code unhealthyDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code unhealthyDeviceCount} field changed
     */
    public WindowsManagementAppHealthSummary withUnhealthyDeviceCount(Integer unhealthyDeviceCount) {
        WindowsManagementAppHealthSummary _x = _copy();
        _x.changedFields = changedFields.add("unhealthyDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsManagementAppHealthSummary");
        _x.unhealthyDeviceCount = unhealthyDeviceCount;
        return _x;
    }

    /**
     * <i>“Unknown device count.”</i>
     * 
     * @return property unknownDeviceCount
     */
    @Property(name="unknownDeviceCount")
    @JsonIgnore
    public Optional<Integer> getUnknownDeviceCount() {
        return Optional.ofNullable(unknownDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * unknownDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Unknown device count.”</i>
     * 
     * @param unknownDeviceCount
     *            new value of {@code unknownDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code unknownDeviceCount} field changed
     */
    public WindowsManagementAppHealthSummary withUnknownDeviceCount(Integer unknownDeviceCount) {
        WindowsManagementAppHealthSummary _x = _copy();
        _x.changedFields = changedFields.add("unknownDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsManagementAppHealthSummary");
        _x.unknownDeviceCount = unknownDeviceCount;
        return _x;
    }

    public WindowsManagementAppHealthSummary withUnmappedField(String name, Object value) {
        WindowsManagementAppHealthSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsManagementAppHealthSummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsManagementAppHealthSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsManagementAppHealthSummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsManagementAppHealthSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsManagementAppHealthSummary _copy() {
        WindowsManagementAppHealthSummary _x = new WindowsManagementAppHealthSummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.healthyDeviceCount = healthyDeviceCount;
        _x.unhealthyDeviceCount = unhealthyDeviceCount;
        _x.unknownDeviceCount = unknownDeviceCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsManagementAppHealthSummary[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("healthyDeviceCount=");
        b.append(this.healthyDeviceCount);
        b.append(", ");
        b.append("unhealthyDeviceCount=");
        b.append(this.unhealthyDeviceCount);
        b.append(", ");
        b.append("unknownDeviceCount=");
        b.append(this.unknownDeviceCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
