package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.WindowsManagementAppHealthStateCollectionRequest;
import odata.msgraph.client.beta.enums.ManagedInstallerStatus;


/**
 * <i>“Windows management app entity.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "availableVersion", 
    "managedInstaller", 
    "managedInstallerConfiguredDateTime", 
    "healthStates"})
@JsonInclude(Include.NON_NULL)
public class WindowsManagementApp extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsManagementApp";
    }

    @JsonProperty("availableVersion")
    protected String availableVersion;

    @JsonProperty("managedInstaller")
    protected ManagedInstallerStatus managedInstaller;

    @JsonProperty("managedInstallerConfiguredDateTime")
    protected String managedInstallerConfiguredDateTime;

    @JsonProperty("healthStates")
    protected List<WindowsManagementAppHealthState> healthStates;

    protected WindowsManagementApp() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsManagementApp() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String availableVersion;
        private ManagedInstallerStatus managedInstaller;
        private String managedInstallerConfiguredDateTime;
        private List<WindowsManagementAppHealthState> healthStates;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Windows management app available version.”</i>
         * 
         * @param availableVersion
         *            value of {@code availableVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder availableVersion(String availableVersion) {
            this.availableVersion = availableVersion;
            this.changedFields = changedFields.add("availableVersion");
            return this;
        }

        /**
         * <i>“Managed Installer Status”</i>
         * 
         * @param managedInstaller
         *            value of {@code managedInstaller} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedInstaller(ManagedInstallerStatus managedInstaller) {
            this.managedInstaller = managedInstaller;
            this.changedFields = changedFields.add("managedInstaller");
            return this;
        }

        /**
         * <i>“Managed Installer Configured Date Time”</i>
         * 
         * @param managedInstallerConfiguredDateTime
         *            value of {@code managedInstallerConfiguredDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedInstallerConfiguredDateTime(String managedInstallerConfiguredDateTime) {
            this.managedInstallerConfiguredDateTime = managedInstallerConfiguredDateTime;
            this.changedFields = changedFields.add("managedInstallerConfiguredDateTime");
            return this;
        }

        /**
         * <i>“The list of health states for installed Windows management app.”</i>
         * 
         * @param healthStates
         *            value of {@code healthStates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder healthStates(List<WindowsManagementAppHealthState> healthStates) {
            this.healthStates = healthStates;
            this.changedFields = changedFields.add("healthStates");
            return this;
        }

        /**
         * <i>“The list of health states for installed Windows management app.”</i>
         * 
         * @param healthStates
         *            value of {@code healthStates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder healthStates(WindowsManagementAppHealthState... healthStates) {
            return healthStates(Arrays.asList(healthStates));
        }

        public WindowsManagementApp build() {
            WindowsManagementApp _x = new WindowsManagementApp();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsManagementApp";
            _x.id = id;
            _x.availableVersion = availableVersion;
            _x.managedInstaller = managedInstaller;
            _x.managedInstallerConfiguredDateTime = managedInstallerConfiguredDateTime;
            _x.healthStates = healthStates;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Windows management app available version.”</i>
     * 
     * @return property availableVersion
     */
    @Property(name="availableVersion")
    @JsonIgnore
    public Optional<String> getAvailableVersion() {
        return Optional.ofNullable(availableVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code availableVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Windows management app available version.”</i>
     * 
     * @param availableVersion
     *            new value of {@code availableVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code availableVersion} field changed
     */
    public WindowsManagementApp withAvailableVersion(String availableVersion) {
        WindowsManagementApp _x = _copy();
        _x.changedFields = changedFields.add("availableVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsManagementApp");
        _x.availableVersion = availableVersion;
        return _x;
    }

    /**
     * <i>“Managed Installer Status”</i>
     * 
     * @return property managedInstaller
     */
    @Property(name="managedInstaller")
    @JsonIgnore
    public Optional<ManagedInstallerStatus> getManagedInstaller() {
        return Optional.ofNullable(managedInstaller);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code managedInstaller}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Managed Installer Status”</i>
     * 
     * @param managedInstaller
     *            new value of {@code managedInstaller} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedInstaller} field changed
     */
    public WindowsManagementApp withManagedInstaller(ManagedInstallerStatus managedInstaller) {
        WindowsManagementApp _x = _copy();
        _x.changedFields = changedFields.add("managedInstaller");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsManagementApp");
        _x.managedInstaller = managedInstaller;
        return _x;
    }

    /**
     * <i>“Managed Installer Configured Date Time”</i>
     * 
     * @return property managedInstallerConfiguredDateTime
     */
    @Property(name="managedInstallerConfiguredDateTime")
    @JsonIgnore
    public Optional<String> getManagedInstallerConfiguredDateTime() {
        return Optional.ofNullable(managedInstallerConfiguredDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * managedInstallerConfiguredDateTime} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Managed Installer Configured Date Time”</i>
     * 
     * @param managedInstallerConfiguredDateTime
     *            new value of {@code managedInstallerConfiguredDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedInstallerConfiguredDateTime} field changed
     */
    public WindowsManagementApp withManagedInstallerConfiguredDateTime(String managedInstallerConfiguredDateTime) {
        WindowsManagementApp _x = _copy();
        _x.changedFields = changedFields.add("managedInstallerConfiguredDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsManagementApp");
        _x.managedInstallerConfiguredDateTime = managedInstallerConfiguredDateTime;
        return _x;
    }

    public WindowsManagementApp withUnmappedField(String name, Object value) {
        WindowsManagementApp _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The list of health states for installed Windows management app.”</i>
     * 
     * @return navigational property healthStates
     */
    @NavigationProperty(name="healthStates")
    @JsonIgnore
    public WindowsManagementAppHealthStateCollectionRequest getHealthStates() {
        return new WindowsManagementAppHealthStateCollectionRequest(
                        contextPath.addSegment("healthStates"), Optional.ofNullable(healthStates));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code healthStates}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The list of health states for installed Windows management app.”</i>
     * 
     * @param healthStates
     *            new value of {@code healthStates} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code healthStates} field changed
     */
    public WindowsManagementApp withHealthStates(List<WindowsManagementAppHealthState> healthStates) {
        WindowsManagementApp _x = _copy();
        _x.changedFields = changedFields.add("healthStates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsManagementApp");
        _x.healthStates = healthStates;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsManagementApp patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsManagementApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsManagementApp put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsManagementApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsManagementApp _copy() {
        WindowsManagementApp _x = new WindowsManagementApp();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.availableVersion = availableVersion;
        _x.managedInstaller = managedInstaller;
        _x.managedInstallerConfiguredDateTime = managedInstallerConfiguredDateTime;
        _x.healthStates = healthStates;
        return _x;
    }

    @Action(name = "setAsManagedInstaller")
    @JsonIgnore
    public ActionRequestNoReturn setAsManagedInstaller() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.setAsManagedInstaller"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsManagementApp[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("availableVersion=");
        b.append(this.availableVersion);
        b.append(", ");
        b.append("managedInstaller=");
        b.append(this.managedInstaller);
        b.append(", ");
        b.append("managedInstallerConfiguredDateTime=");
        b.append(this.managedInstallerConfiguredDateTime);
        b.append(", ");
        b.append("healthStates=");
        b.append(this.healthStates);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
