package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;

import odata.msgraph.client.beta.complex.ChromeOSDeviceProperty;
import odata.msgraph.client.beta.complex.CloudPcRemoteActionResult;
import odata.msgraph.client.beta.complex.ConfigurationManagerClientEnabledFeatures;
import odata.msgraph.client.beta.complex.ConfigurationManagerClientHealthState;
import odata.msgraph.client.beta.complex.ConfigurationManagerClientInformation;
import odata.msgraph.client.beta.complex.DeviceActionResult;
import odata.msgraph.client.beta.complex.DeviceHealthAttestationState;
import odata.msgraph.client.beta.complex.HardwareInformation;
import odata.msgraph.client.beta.complex.LoggedOnUser;
import odata.msgraph.client.beta.enums.ChassisType;
import odata.msgraph.client.beta.enums.ComplianceState;
import odata.msgraph.client.beta.enums.DeviceEnrollmentType;
import odata.msgraph.client.beta.enums.DeviceManagementExchangeAccessState;
import odata.msgraph.client.beta.enums.DeviceManagementExchangeAccessStateReason;
import odata.msgraph.client.beta.enums.DeviceRegistrationState;
import odata.msgraph.client.beta.enums.DeviceType;
import odata.msgraph.client.beta.enums.JoinType;
import odata.msgraph.client.beta.enums.LostModeState;
import odata.msgraph.client.beta.enums.ManagedDeviceArchitecture;
import odata.msgraph.client.beta.enums.ManagedDeviceManagementFeatures;
import odata.msgraph.client.beta.enums.ManagedDeviceOwnerType;
import odata.msgraph.client.beta.enums.ManagedDevicePartnerReportedHealthState;
import odata.msgraph.client.beta.enums.ManagementAgentType;
import odata.msgraph.client.beta.enums.ManagementState;
import odata.msgraph.client.beta.enums.OwnerType;


/**
 * <i>“Windows devices that are managed or pre-enrolled through Intune”</i>
 */@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class WindowsManagedDevice extends ManagedDevice implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsManagedDevice";
    }

    protected WindowsManagedDevice() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsManagedDevice() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<CloudPcRemoteActionResult> cloudPcRemoteActionResults;
        private String cloudPcRemoteActionResultsNextLink;
        private Boolean aadRegistered;
        private String activationLockBypassCode;
        private String androidSecurityPatchLevel;
        private Boolean autopilotEnrolled;
        private String azureActiveDirectoryDeviceId;
        private String azureADDeviceId;
        private Boolean azureADRegistered;
        private ChassisType chassisType;
        private List<ChromeOSDeviceProperty> chromeOSDeviceInfo;
        private String chromeOSDeviceInfoNextLink;
        private OffsetDateTime complianceGracePeriodExpirationDateTime;
        private ComplianceState complianceState;
        private ConfigurationManagerClientEnabledFeatures configurationManagerClientEnabledFeatures;
        private ConfigurationManagerClientHealthState configurationManagerClientHealthState;
        private ConfigurationManagerClientInformation configurationManagerClientInformation;
        private List<DeviceActionResult> deviceActionResults;
        private String deviceActionResultsNextLink;
        private String deviceCategoryDisplayName;
        private DeviceEnrollmentType deviceEnrollmentType;
        private DeviceHealthAttestationState deviceHealthAttestationState;
        private String deviceName;
        private DeviceRegistrationState deviceRegistrationState;
        private DeviceType deviceType;
        private Boolean easActivated;
        private OffsetDateTime easActivationDateTime;
        private String easDeviceId;
        private String emailAddress;
        private OffsetDateTime enrolledDateTime;
        private String enrollmentProfileName;
        private String ethernetMacAddress;
        private DeviceManagementExchangeAccessState exchangeAccessState;
        private DeviceManagementExchangeAccessStateReason exchangeAccessStateReason;
        private OffsetDateTime exchangeLastSuccessfulSyncDateTime;
        private Long freeStorageSpaceInBytes;
        private HardwareInformation hardwareInformation;
        private String iccid;
        private String imei;
        private Boolean isEncrypted;
        private Boolean isSupervised;
        private String jailBroken;
        private JoinType joinType;
        private OffsetDateTime lastSyncDateTime;
        private LostModeState lostModeState;
        private String managedDeviceName;
        private ManagedDeviceOwnerType managedDeviceOwnerType;
        private ManagementAgentType managementAgent;
        private OffsetDateTime managementCertificateExpirationDate;
        private ManagedDeviceManagementFeatures managementFeatures;
        private ManagementState managementState;
        private String manufacturer;
        private String meid;
        private String model;
        private String notes;
        private String operatingSystem;
        private String osVersion;
        private OwnerType ownerType;
        private ManagedDevicePartnerReportedHealthState partnerReportedThreatState;
        private String phoneNumber;
        private Long physicalMemoryInBytes;
        private OffsetDateTime preferMdmOverGroupPolicyAppliedDateTime;
        private ManagedDeviceArchitecture processorArchitecture;
        private String remoteAssistanceSessionErrorDetails;
        private String remoteAssistanceSessionUrl;
        private Boolean requireUserEnrollmentApproval;
        private OffsetDateTime retireAfterDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private String serialNumber;
        private String skuFamily;
        private Integer skuNumber;
        private String specificationVersion;
        private String subscriberCarrier;
        private Long totalStorageSpaceInBytes;
        private String udid;
        private String userDisplayName;
        private String userId;
        private String userPrincipalName;
        private List<LoggedOnUser> usersLoggedOn;
        private String usersLoggedOnNextLink;
        private String wiFiMacAddress;
        private Integer windowsActiveMalwareCount;
        private Integer windowsRemediatedMalwareCount;
        private List<AssignmentFilterEvaluationStatusDetails> assignmentFilterEvaluationStatusDetails;
        private List<DeviceCompliancePolicyState> deviceCompliancePolicyStates;
        private List<DeviceConfigurationState> deviceConfigurationStates;
        private List<ManagedDeviceMobileAppConfigurationState> managedDeviceMobileAppConfigurationStates;
        private List<SecurityBaselineState> securityBaselineStates;
        private DeviceCategory deviceCategory;
        private List<DeviceLogCollectionResponse> logCollectionRequests;
        private WindowsProtectionState windowsProtectionState;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder cloudPcRemoteActionResults(List<CloudPcRemoteActionResult> cloudPcRemoteActionResults) {
            this.cloudPcRemoteActionResults = cloudPcRemoteActionResults;
            this.changedFields = changedFields.add("cloudPcRemoteActionResults");
            return this;
        }

        public Builder cloudPcRemoteActionResults(CloudPcRemoteActionResult... cloudPcRemoteActionResults) {
            return cloudPcRemoteActionResults(Arrays.asList(cloudPcRemoteActionResults));
        }

        public Builder cloudPcRemoteActionResultsNextLink(String cloudPcRemoteActionResultsNextLink) {
            this.cloudPcRemoteActionResultsNextLink = cloudPcRemoteActionResultsNextLink;
            this.changedFields = changedFields.add("cloudPcRemoteActionResults");
            return this;
        }

        public Builder aadRegistered(Boolean aadRegistered) {
            this.aadRegistered = aadRegistered;
            this.changedFields = changedFields.add("aadRegistered");
            return this;
        }

        public Builder activationLockBypassCode(String activationLockBypassCode) {
            this.activationLockBypassCode = activationLockBypassCode;
            this.changedFields = changedFields.add("activationLockBypassCode");
            return this;
        }

        public Builder androidSecurityPatchLevel(String androidSecurityPatchLevel) {
            this.androidSecurityPatchLevel = androidSecurityPatchLevel;
            this.changedFields = changedFields.add("androidSecurityPatchLevel");
            return this;
        }

        public Builder autopilotEnrolled(Boolean autopilotEnrolled) {
            this.autopilotEnrolled = autopilotEnrolled;
            this.changedFields = changedFields.add("autopilotEnrolled");
            return this;
        }

        public Builder azureActiveDirectoryDeviceId(String azureActiveDirectoryDeviceId) {
            this.azureActiveDirectoryDeviceId = azureActiveDirectoryDeviceId;
            this.changedFields = changedFields.add("azureActiveDirectoryDeviceId");
            return this;
        }

        public Builder azureADDeviceId(String azureADDeviceId) {
            this.azureADDeviceId = azureADDeviceId;
            this.changedFields = changedFields.add("azureADDeviceId");
            return this;
        }

        public Builder azureADRegistered(Boolean azureADRegistered) {
            this.azureADRegistered = azureADRegistered;
            this.changedFields = changedFields.add("azureADRegistered");
            return this;
        }

        public Builder chassisType(ChassisType chassisType) {
            this.chassisType = chassisType;
            this.changedFields = changedFields.add("chassisType");
            return this;
        }

        public Builder chromeOSDeviceInfo(List<ChromeOSDeviceProperty> chromeOSDeviceInfo) {
            this.chromeOSDeviceInfo = chromeOSDeviceInfo;
            this.changedFields = changedFields.add("chromeOSDeviceInfo");
            return this;
        }

        public Builder chromeOSDeviceInfo(ChromeOSDeviceProperty... chromeOSDeviceInfo) {
            return chromeOSDeviceInfo(Arrays.asList(chromeOSDeviceInfo));
        }

        public Builder chromeOSDeviceInfoNextLink(String chromeOSDeviceInfoNextLink) {
            this.chromeOSDeviceInfoNextLink = chromeOSDeviceInfoNextLink;
            this.changedFields = changedFields.add("chromeOSDeviceInfo");
            return this;
        }

        public Builder complianceGracePeriodExpirationDateTime(OffsetDateTime complianceGracePeriodExpirationDateTime) {
            this.complianceGracePeriodExpirationDateTime = complianceGracePeriodExpirationDateTime;
            this.changedFields = changedFields.add("complianceGracePeriodExpirationDateTime");
            return this;
        }

        public Builder complianceState(ComplianceState complianceState) {
            this.complianceState = complianceState;
            this.changedFields = changedFields.add("complianceState");
            return this;
        }

        public Builder configurationManagerClientEnabledFeatures(ConfigurationManagerClientEnabledFeatures configurationManagerClientEnabledFeatures) {
            this.configurationManagerClientEnabledFeatures = configurationManagerClientEnabledFeatures;
            this.changedFields = changedFields.add("configurationManagerClientEnabledFeatures");
            return this;
        }

        public Builder configurationManagerClientHealthState(ConfigurationManagerClientHealthState configurationManagerClientHealthState) {
            this.configurationManagerClientHealthState = configurationManagerClientHealthState;
            this.changedFields = changedFields.add("configurationManagerClientHealthState");
            return this;
        }

        public Builder configurationManagerClientInformation(ConfigurationManagerClientInformation configurationManagerClientInformation) {
            this.configurationManagerClientInformation = configurationManagerClientInformation;
            this.changedFields = changedFields.add("configurationManagerClientInformation");
            return this;
        }

        public Builder deviceActionResults(List<DeviceActionResult> deviceActionResults) {
            this.deviceActionResults = deviceActionResults;
            this.changedFields = changedFields.add("deviceActionResults");
            return this;
        }

        public Builder deviceActionResults(DeviceActionResult... deviceActionResults) {
            return deviceActionResults(Arrays.asList(deviceActionResults));
        }

        public Builder deviceActionResultsNextLink(String deviceActionResultsNextLink) {
            this.deviceActionResultsNextLink = deviceActionResultsNextLink;
            this.changedFields = changedFields.add("deviceActionResults");
            return this;
        }

        public Builder deviceCategoryDisplayName(String deviceCategoryDisplayName) {
            this.deviceCategoryDisplayName = deviceCategoryDisplayName;
            this.changedFields = changedFields.add("deviceCategoryDisplayName");
            return this;
        }

        public Builder deviceEnrollmentType(DeviceEnrollmentType deviceEnrollmentType) {
            this.deviceEnrollmentType = deviceEnrollmentType;
            this.changedFields = changedFields.add("deviceEnrollmentType");
            return this;
        }

        public Builder deviceHealthAttestationState(DeviceHealthAttestationState deviceHealthAttestationState) {
            this.deviceHealthAttestationState = deviceHealthAttestationState;
            this.changedFields = changedFields.add("deviceHealthAttestationState");
            return this;
        }

        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            this.changedFields = changedFields.add("deviceName");
            return this;
        }

        public Builder deviceRegistrationState(DeviceRegistrationState deviceRegistrationState) {
            this.deviceRegistrationState = deviceRegistrationState;
            this.changedFields = changedFields.add("deviceRegistrationState");
            return this;
        }

        public Builder deviceType(DeviceType deviceType) {
            this.deviceType = deviceType;
            this.changedFields = changedFields.add("deviceType");
            return this;
        }

        public Builder easActivated(Boolean easActivated) {
            this.easActivated = easActivated;
            this.changedFields = changedFields.add("easActivated");
            return this;
        }

        public Builder easActivationDateTime(OffsetDateTime easActivationDateTime) {
            this.easActivationDateTime = easActivationDateTime;
            this.changedFields = changedFields.add("easActivationDateTime");
            return this;
        }

        public Builder easDeviceId(String easDeviceId) {
            this.easDeviceId = easDeviceId;
            this.changedFields = changedFields.add("easDeviceId");
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            this.changedFields = changedFields.add("emailAddress");
            return this;
        }

        public Builder enrolledDateTime(OffsetDateTime enrolledDateTime) {
            this.enrolledDateTime = enrolledDateTime;
            this.changedFields = changedFields.add("enrolledDateTime");
            return this;
        }

        public Builder enrollmentProfileName(String enrollmentProfileName) {
            this.enrollmentProfileName = enrollmentProfileName;
            this.changedFields = changedFields.add("enrollmentProfileName");
            return this;
        }

        public Builder ethernetMacAddress(String ethernetMacAddress) {
            this.ethernetMacAddress = ethernetMacAddress;
            this.changedFields = changedFields.add("ethernetMacAddress");
            return this;
        }

        public Builder exchangeAccessState(DeviceManagementExchangeAccessState exchangeAccessState) {
            this.exchangeAccessState = exchangeAccessState;
            this.changedFields = changedFields.add("exchangeAccessState");
            return this;
        }

        public Builder exchangeAccessStateReason(DeviceManagementExchangeAccessStateReason exchangeAccessStateReason) {
            this.exchangeAccessStateReason = exchangeAccessStateReason;
            this.changedFields = changedFields.add("exchangeAccessStateReason");
            return this;
        }

        public Builder exchangeLastSuccessfulSyncDateTime(OffsetDateTime exchangeLastSuccessfulSyncDateTime) {
            this.exchangeLastSuccessfulSyncDateTime = exchangeLastSuccessfulSyncDateTime;
            this.changedFields = changedFields.add("exchangeLastSuccessfulSyncDateTime");
            return this;
        }

        public Builder freeStorageSpaceInBytes(Long freeStorageSpaceInBytes) {
            this.freeStorageSpaceInBytes = freeStorageSpaceInBytes;
            this.changedFields = changedFields.add("freeStorageSpaceInBytes");
            return this;
        }

        public Builder hardwareInformation(HardwareInformation hardwareInformation) {
            this.hardwareInformation = hardwareInformation;
            this.changedFields = changedFields.add("hardwareInformation");
            return this;
        }

        public Builder iccid(String iccid) {
            this.iccid = iccid;
            this.changedFields = changedFields.add("iccid");
            return this;
        }

        public Builder imei(String imei) {
            this.imei = imei;
            this.changedFields = changedFields.add("imei");
            return this;
        }

        public Builder isEncrypted(Boolean isEncrypted) {
            this.isEncrypted = isEncrypted;
            this.changedFields = changedFields.add("isEncrypted");
            return this;
        }

        public Builder isSupervised(Boolean isSupervised) {
            this.isSupervised = isSupervised;
            this.changedFields = changedFields.add("isSupervised");
            return this;
        }

        public Builder jailBroken(String jailBroken) {
            this.jailBroken = jailBroken;
            this.changedFields = changedFields.add("jailBroken");
            return this;
        }

        public Builder joinType(JoinType joinType) {
            this.joinType = joinType;
            this.changedFields = changedFields.add("joinType");
            return this;
        }

        public Builder lastSyncDateTime(OffsetDateTime lastSyncDateTime) {
            this.lastSyncDateTime = lastSyncDateTime;
            this.changedFields = changedFields.add("lastSyncDateTime");
            return this;
        }

        public Builder lostModeState(LostModeState lostModeState) {
            this.lostModeState = lostModeState;
            this.changedFields = changedFields.add("lostModeState");
            return this;
        }

        public Builder managedDeviceName(String managedDeviceName) {
            this.managedDeviceName = managedDeviceName;
            this.changedFields = changedFields.add("managedDeviceName");
            return this;
        }

        public Builder managedDeviceOwnerType(ManagedDeviceOwnerType managedDeviceOwnerType) {
            this.managedDeviceOwnerType = managedDeviceOwnerType;
            this.changedFields = changedFields.add("managedDeviceOwnerType");
            return this;
        }

        public Builder managementAgent(ManagementAgentType managementAgent) {
            this.managementAgent = managementAgent;
            this.changedFields = changedFields.add("managementAgent");
            return this;
        }

        public Builder managementCertificateExpirationDate(OffsetDateTime managementCertificateExpirationDate) {
            this.managementCertificateExpirationDate = managementCertificateExpirationDate;
            this.changedFields = changedFields.add("managementCertificateExpirationDate");
            return this;
        }

        public Builder managementFeatures(ManagedDeviceManagementFeatures managementFeatures) {
            this.managementFeatures = managementFeatures;
            this.changedFields = changedFields.add("managementFeatures");
            return this;
        }

        public Builder managementState(ManagementState managementState) {
            this.managementState = managementState;
            this.changedFields = changedFields.add("managementState");
            return this;
        }

        public Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            this.changedFields = changedFields.add("manufacturer");
            return this;
        }

        public Builder meid(String meid) {
            this.meid = meid;
            this.changedFields = changedFields.add("meid");
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            this.changedFields = changedFields.add("model");
            return this;
        }

        public Builder notes(String notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("notes");
            return this;
        }

        public Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            this.changedFields = changedFields.add("operatingSystem");
            return this;
        }

        public Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            this.changedFields = changedFields.add("osVersion");
            return this;
        }

        public Builder ownerType(OwnerType ownerType) {
            this.ownerType = ownerType;
            this.changedFields = changedFields.add("ownerType");
            return this;
        }

        public Builder partnerReportedThreatState(ManagedDevicePartnerReportedHealthState partnerReportedThreatState) {
            this.partnerReportedThreatState = partnerReportedThreatState;
            this.changedFields = changedFields.add("partnerReportedThreatState");
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            this.changedFields = changedFields.add("phoneNumber");
            return this;
        }

        public Builder physicalMemoryInBytes(Long physicalMemoryInBytes) {
            this.physicalMemoryInBytes = physicalMemoryInBytes;
            this.changedFields = changedFields.add("physicalMemoryInBytes");
            return this;
        }

        public Builder preferMdmOverGroupPolicyAppliedDateTime(OffsetDateTime preferMdmOverGroupPolicyAppliedDateTime) {
            this.preferMdmOverGroupPolicyAppliedDateTime = preferMdmOverGroupPolicyAppliedDateTime;
            this.changedFields = changedFields.add("preferMdmOverGroupPolicyAppliedDateTime");
            return this;
        }

        public Builder processorArchitecture(ManagedDeviceArchitecture processorArchitecture) {
            this.processorArchitecture = processorArchitecture;
            this.changedFields = changedFields.add("processorArchitecture");
            return this;
        }

        public Builder remoteAssistanceSessionErrorDetails(String remoteAssistanceSessionErrorDetails) {
            this.remoteAssistanceSessionErrorDetails = remoteAssistanceSessionErrorDetails;
            this.changedFields = changedFields.add("remoteAssistanceSessionErrorDetails");
            return this;
        }

        public Builder remoteAssistanceSessionUrl(String remoteAssistanceSessionUrl) {
            this.remoteAssistanceSessionUrl = remoteAssistanceSessionUrl;
            this.changedFields = changedFields.add("remoteAssistanceSessionUrl");
            return this;
        }

        public Builder requireUserEnrollmentApproval(Boolean requireUserEnrollmentApproval) {
            this.requireUserEnrollmentApproval = requireUserEnrollmentApproval;
            this.changedFields = changedFields.add("requireUserEnrollmentApproval");
            return this;
        }

        public Builder retireAfterDateTime(OffsetDateTime retireAfterDateTime) {
            this.retireAfterDateTime = retireAfterDateTime;
            this.changedFields = changedFields.add("retireAfterDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            this.changedFields = changedFields.add("serialNumber");
            return this;
        }

        public Builder skuFamily(String skuFamily) {
            this.skuFamily = skuFamily;
            this.changedFields = changedFields.add("skuFamily");
            return this;
        }

        public Builder skuNumber(Integer skuNumber) {
            this.skuNumber = skuNumber;
            this.changedFields = changedFields.add("skuNumber");
            return this;
        }

        public Builder specificationVersion(String specificationVersion) {
            this.specificationVersion = specificationVersion;
            this.changedFields = changedFields.add("specificationVersion");
            return this;
        }

        public Builder subscriberCarrier(String subscriberCarrier) {
            this.subscriberCarrier = subscriberCarrier;
            this.changedFields = changedFields.add("subscriberCarrier");
            return this;
        }

        public Builder totalStorageSpaceInBytes(Long totalStorageSpaceInBytes) {
            this.totalStorageSpaceInBytes = totalStorageSpaceInBytes;
            this.changedFields = changedFields.add("totalStorageSpaceInBytes");
            return this;
        }

        public Builder udid(String udid) {
            this.udid = udid;
            this.changedFields = changedFields.add("udid");
            return this;
        }

        public Builder userDisplayName(String userDisplayName) {
            this.userDisplayName = userDisplayName;
            this.changedFields = changedFields.add("userDisplayName");
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public Builder usersLoggedOn(List<LoggedOnUser> usersLoggedOn) {
            this.usersLoggedOn = usersLoggedOn;
            this.changedFields = changedFields.add("usersLoggedOn");
            return this;
        }

        public Builder usersLoggedOn(LoggedOnUser... usersLoggedOn) {
            return usersLoggedOn(Arrays.asList(usersLoggedOn));
        }

        public Builder usersLoggedOnNextLink(String usersLoggedOnNextLink) {
            this.usersLoggedOnNextLink = usersLoggedOnNextLink;
            this.changedFields = changedFields.add("usersLoggedOn");
            return this;
        }

        public Builder wiFiMacAddress(String wiFiMacAddress) {
            this.wiFiMacAddress = wiFiMacAddress;
            this.changedFields = changedFields.add("wiFiMacAddress");
            return this;
        }

        public Builder windowsActiveMalwareCount(Integer windowsActiveMalwareCount) {
            this.windowsActiveMalwareCount = windowsActiveMalwareCount;
            this.changedFields = changedFields.add("windowsActiveMalwareCount");
            return this;
        }

        public Builder windowsRemediatedMalwareCount(Integer windowsRemediatedMalwareCount) {
            this.windowsRemediatedMalwareCount = windowsRemediatedMalwareCount;
            this.changedFields = changedFields.add("windowsRemediatedMalwareCount");
            return this;
        }

        public Builder assignmentFilterEvaluationStatusDetails(List<AssignmentFilterEvaluationStatusDetails> assignmentFilterEvaluationStatusDetails) {
            this.assignmentFilterEvaluationStatusDetails = assignmentFilterEvaluationStatusDetails;
            this.changedFields = changedFields.add("assignmentFilterEvaluationStatusDetails");
            return this;
        }

        public Builder assignmentFilterEvaluationStatusDetails(AssignmentFilterEvaluationStatusDetails... assignmentFilterEvaluationStatusDetails) {
            return assignmentFilterEvaluationStatusDetails(Arrays.asList(assignmentFilterEvaluationStatusDetails));
        }

        public Builder deviceCompliancePolicyStates(List<DeviceCompliancePolicyState> deviceCompliancePolicyStates) {
            this.deviceCompliancePolicyStates = deviceCompliancePolicyStates;
            this.changedFields = changedFields.add("deviceCompliancePolicyStates");
            return this;
        }

        public Builder deviceCompliancePolicyStates(DeviceCompliancePolicyState... deviceCompliancePolicyStates) {
            return deviceCompliancePolicyStates(Arrays.asList(deviceCompliancePolicyStates));
        }

        public Builder deviceConfigurationStates(List<DeviceConfigurationState> deviceConfigurationStates) {
            this.deviceConfigurationStates = deviceConfigurationStates;
            this.changedFields = changedFields.add("deviceConfigurationStates");
            return this;
        }

        public Builder deviceConfigurationStates(DeviceConfigurationState... deviceConfigurationStates) {
            return deviceConfigurationStates(Arrays.asList(deviceConfigurationStates));
        }

        public Builder managedDeviceMobileAppConfigurationStates(List<ManagedDeviceMobileAppConfigurationState> managedDeviceMobileAppConfigurationStates) {
            this.managedDeviceMobileAppConfigurationStates = managedDeviceMobileAppConfigurationStates;
            this.changedFields = changedFields.add("managedDeviceMobileAppConfigurationStates");
            return this;
        }

        public Builder managedDeviceMobileAppConfigurationStates(ManagedDeviceMobileAppConfigurationState... managedDeviceMobileAppConfigurationStates) {
            return managedDeviceMobileAppConfigurationStates(Arrays.asList(managedDeviceMobileAppConfigurationStates));
        }

        public Builder securityBaselineStates(List<SecurityBaselineState> securityBaselineStates) {
            this.securityBaselineStates = securityBaselineStates;
            this.changedFields = changedFields.add("securityBaselineStates");
            return this;
        }

        public Builder securityBaselineStates(SecurityBaselineState... securityBaselineStates) {
            return securityBaselineStates(Arrays.asList(securityBaselineStates));
        }

        public Builder deviceCategory(DeviceCategory deviceCategory) {
            this.deviceCategory = deviceCategory;
            this.changedFields = changedFields.add("deviceCategory");
            return this;
        }

        public Builder logCollectionRequests(List<DeviceLogCollectionResponse> logCollectionRequests) {
            this.logCollectionRequests = logCollectionRequests;
            this.changedFields = changedFields.add("logCollectionRequests");
            return this;
        }

        public Builder logCollectionRequests(DeviceLogCollectionResponse... logCollectionRequests) {
            return logCollectionRequests(Arrays.asList(logCollectionRequests));
        }

        public Builder windowsProtectionState(WindowsProtectionState windowsProtectionState) {
            this.windowsProtectionState = windowsProtectionState;
            this.changedFields = changedFields.add("windowsProtectionState");
            return this;
        }

        public WindowsManagedDevice build() {
            WindowsManagedDevice _x = new WindowsManagedDevice();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsManagedDevice";
            _x.id = id;
            _x.cloudPcRemoteActionResults = cloudPcRemoteActionResults;
            _x.cloudPcRemoteActionResultsNextLink = cloudPcRemoteActionResultsNextLink;
            _x.aadRegistered = aadRegistered;
            _x.activationLockBypassCode = activationLockBypassCode;
            _x.androidSecurityPatchLevel = androidSecurityPatchLevel;
            _x.autopilotEnrolled = autopilotEnrolled;
            _x.azureActiveDirectoryDeviceId = azureActiveDirectoryDeviceId;
            _x.azureADDeviceId = azureADDeviceId;
            _x.azureADRegistered = azureADRegistered;
            _x.chassisType = chassisType;
            _x.chromeOSDeviceInfo = chromeOSDeviceInfo;
            _x.chromeOSDeviceInfoNextLink = chromeOSDeviceInfoNextLink;
            _x.complianceGracePeriodExpirationDateTime = complianceGracePeriodExpirationDateTime;
            _x.complianceState = complianceState;
            _x.configurationManagerClientEnabledFeatures = configurationManagerClientEnabledFeatures;
            _x.configurationManagerClientHealthState = configurationManagerClientHealthState;
            _x.configurationManagerClientInformation = configurationManagerClientInformation;
            _x.deviceActionResults = deviceActionResults;
            _x.deviceActionResultsNextLink = deviceActionResultsNextLink;
            _x.deviceCategoryDisplayName = deviceCategoryDisplayName;
            _x.deviceEnrollmentType = deviceEnrollmentType;
            _x.deviceHealthAttestationState = deviceHealthAttestationState;
            _x.deviceName = deviceName;
            _x.deviceRegistrationState = deviceRegistrationState;
            _x.deviceType = deviceType;
            _x.easActivated = easActivated;
            _x.easActivationDateTime = easActivationDateTime;
            _x.easDeviceId = easDeviceId;
            _x.emailAddress = emailAddress;
            _x.enrolledDateTime = enrolledDateTime;
            _x.enrollmentProfileName = enrollmentProfileName;
            _x.ethernetMacAddress = ethernetMacAddress;
            _x.exchangeAccessState = exchangeAccessState;
            _x.exchangeAccessStateReason = exchangeAccessStateReason;
            _x.exchangeLastSuccessfulSyncDateTime = exchangeLastSuccessfulSyncDateTime;
            _x.freeStorageSpaceInBytes = freeStorageSpaceInBytes;
            _x.hardwareInformation = hardwareInformation;
            _x.iccid = iccid;
            _x.imei = imei;
            _x.isEncrypted = isEncrypted;
            _x.isSupervised = isSupervised;
            _x.jailBroken = jailBroken;
            _x.joinType = joinType;
            _x.lastSyncDateTime = lastSyncDateTime;
            _x.lostModeState = lostModeState;
            _x.managedDeviceName = managedDeviceName;
            _x.managedDeviceOwnerType = managedDeviceOwnerType;
            _x.managementAgent = managementAgent;
            _x.managementCertificateExpirationDate = managementCertificateExpirationDate;
            _x.managementFeatures = managementFeatures;
            _x.managementState = managementState;
            _x.manufacturer = manufacturer;
            _x.meid = meid;
            _x.model = model;
            _x.notes = notes;
            _x.operatingSystem = operatingSystem;
            _x.osVersion = osVersion;
            _x.ownerType = ownerType;
            _x.partnerReportedThreatState = partnerReportedThreatState;
            _x.phoneNumber = phoneNumber;
            _x.physicalMemoryInBytes = physicalMemoryInBytes;
            _x.preferMdmOverGroupPolicyAppliedDateTime = preferMdmOverGroupPolicyAppliedDateTime;
            _x.processorArchitecture = processorArchitecture;
            _x.remoteAssistanceSessionErrorDetails = remoteAssistanceSessionErrorDetails;
            _x.remoteAssistanceSessionUrl = remoteAssistanceSessionUrl;
            _x.requireUserEnrollmentApproval = requireUserEnrollmentApproval;
            _x.retireAfterDateTime = retireAfterDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.serialNumber = serialNumber;
            _x.skuFamily = skuFamily;
            _x.skuNumber = skuNumber;
            _x.specificationVersion = specificationVersion;
            _x.subscriberCarrier = subscriberCarrier;
            _x.totalStorageSpaceInBytes = totalStorageSpaceInBytes;
            _x.udid = udid;
            _x.userDisplayName = userDisplayName;
            _x.userId = userId;
            _x.userPrincipalName = userPrincipalName;
            _x.usersLoggedOn = usersLoggedOn;
            _x.usersLoggedOnNextLink = usersLoggedOnNextLink;
            _x.wiFiMacAddress = wiFiMacAddress;
            _x.windowsActiveMalwareCount = windowsActiveMalwareCount;
            _x.windowsRemediatedMalwareCount = windowsRemediatedMalwareCount;
            _x.assignmentFilterEvaluationStatusDetails = assignmentFilterEvaluationStatusDetails;
            _x.deviceCompliancePolicyStates = deviceCompliancePolicyStates;
            _x.deviceConfigurationStates = deviceConfigurationStates;
            _x.managedDeviceMobileAppConfigurationStates = managedDeviceMobileAppConfigurationStates;
            _x.securityBaselineStates = securityBaselineStates;
            _x.deviceCategory = deviceCategory;
            _x.logCollectionRequests = logCollectionRequests;
            _x.windowsProtectionState = windowsProtectionState;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public WindowsManagedDevice withUnmappedField(String name, Object value) {
        WindowsManagedDevice _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsManagedDevice patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsManagedDevice _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsManagedDevice put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsManagedDevice _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsManagedDevice _copy() {
        WindowsManagedDevice _x = new WindowsManagedDevice();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.cloudPcRemoteActionResults = cloudPcRemoteActionResults;
        _x.aadRegistered = aadRegistered;
        _x.activationLockBypassCode = activationLockBypassCode;
        _x.androidSecurityPatchLevel = androidSecurityPatchLevel;
        _x.autopilotEnrolled = autopilotEnrolled;
        _x.azureActiveDirectoryDeviceId = azureActiveDirectoryDeviceId;
        _x.azureADDeviceId = azureADDeviceId;
        _x.azureADRegistered = azureADRegistered;
        _x.chassisType = chassisType;
        _x.chromeOSDeviceInfo = chromeOSDeviceInfo;
        _x.complianceGracePeriodExpirationDateTime = complianceGracePeriodExpirationDateTime;
        _x.complianceState = complianceState;
        _x.configurationManagerClientEnabledFeatures = configurationManagerClientEnabledFeatures;
        _x.configurationManagerClientHealthState = configurationManagerClientHealthState;
        _x.configurationManagerClientInformation = configurationManagerClientInformation;
        _x.deviceActionResults = deviceActionResults;
        _x.deviceCategoryDisplayName = deviceCategoryDisplayName;
        _x.deviceEnrollmentType = deviceEnrollmentType;
        _x.deviceHealthAttestationState = deviceHealthAttestationState;
        _x.deviceName = deviceName;
        _x.deviceRegistrationState = deviceRegistrationState;
        _x.deviceType = deviceType;
        _x.easActivated = easActivated;
        _x.easActivationDateTime = easActivationDateTime;
        _x.easDeviceId = easDeviceId;
        _x.emailAddress = emailAddress;
        _x.enrolledDateTime = enrolledDateTime;
        _x.enrollmentProfileName = enrollmentProfileName;
        _x.ethernetMacAddress = ethernetMacAddress;
        _x.exchangeAccessState = exchangeAccessState;
        _x.exchangeAccessStateReason = exchangeAccessStateReason;
        _x.exchangeLastSuccessfulSyncDateTime = exchangeLastSuccessfulSyncDateTime;
        _x.freeStorageSpaceInBytes = freeStorageSpaceInBytes;
        _x.hardwareInformation = hardwareInformation;
        _x.iccid = iccid;
        _x.imei = imei;
        _x.isEncrypted = isEncrypted;
        _x.isSupervised = isSupervised;
        _x.jailBroken = jailBroken;
        _x.joinType = joinType;
        _x.lastSyncDateTime = lastSyncDateTime;
        _x.lostModeState = lostModeState;
        _x.managedDeviceName = managedDeviceName;
        _x.managedDeviceOwnerType = managedDeviceOwnerType;
        _x.managementAgent = managementAgent;
        _x.managementCertificateExpirationDate = managementCertificateExpirationDate;
        _x.managementFeatures = managementFeatures;
        _x.managementState = managementState;
        _x.manufacturer = manufacturer;
        _x.meid = meid;
        _x.model = model;
        _x.notes = notes;
        _x.operatingSystem = operatingSystem;
        _x.osVersion = osVersion;
        _x.ownerType = ownerType;
        _x.partnerReportedThreatState = partnerReportedThreatState;
        _x.phoneNumber = phoneNumber;
        _x.physicalMemoryInBytes = physicalMemoryInBytes;
        _x.preferMdmOverGroupPolicyAppliedDateTime = preferMdmOverGroupPolicyAppliedDateTime;
        _x.processorArchitecture = processorArchitecture;
        _x.remoteAssistanceSessionErrorDetails = remoteAssistanceSessionErrorDetails;
        _x.remoteAssistanceSessionUrl = remoteAssistanceSessionUrl;
        _x.requireUserEnrollmentApproval = requireUserEnrollmentApproval;
        _x.retireAfterDateTime = retireAfterDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.serialNumber = serialNumber;
        _x.skuFamily = skuFamily;
        _x.skuNumber = skuNumber;
        _x.specificationVersion = specificationVersion;
        _x.subscriberCarrier = subscriberCarrier;
        _x.totalStorageSpaceInBytes = totalStorageSpaceInBytes;
        _x.udid = udid;
        _x.userDisplayName = userDisplayName;
        _x.userId = userId;
        _x.userPrincipalName = userPrincipalName;
        _x.usersLoggedOn = usersLoggedOn;
        _x.wiFiMacAddress = wiFiMacAddress;
        _x.windowsActiveMalwareCount = windowsActiveMalwareCount;
        _x.windowsRemediatedMalwareCount = windowsRemediatedMalwareCount;
        _x.assignmentFilterEvaluationStatusDetails = assignmentFilterEvaluationStatusDetails;
        _x.deviceCompliancePolicyStates = deviceCompliancePolicyStates;
        _x.deviceConfigurationStates = deviceConfigurationStates;
        _x.managedDeviceMobileAppConfigurationStates = managedDeviceMobileAppConfigurationStates;
        _x.securityBaselineStates = securityBaselineStates;
        _x.deviceCategory = deviceCategory;
        _x.logCollectionRequests = logCollectionRequests;
        _x.windowsProtectionState = windowsProtectionState;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsManagedDevice[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("cloudPcRemoteActionResults=");
        b.append(this.cloudPcRemoteActionResults);
        b.append(", ");
        b.append("aadRegistered=");
        b.append(this.aadRegistered);
        b.append(", ");
        b.append("activationLockBypassCode=");
        b.append(this.activationLockBypassCode);
        b.append(", ");
        b.append("androidSecurityPatchLevel=");
        b.append(this.androidSecurityPatchLevel);
        b.append(", ");
        b.append("autopilotEnrolled=");
        b.append(this.autopilotEnrolled);
        b.append(", ");
        b.append("azureActiveDirectoryDeviceId=");
        b.append(this.azureActiveDirectoryDeviceId);
        b.append(", ");
        b.append("azureADDeviceId=");
        b.append(this.azureADDeviceId);
        b.append(", ");
        b.append("azureADRegistered=");
        b.append(this.azureADRegistered);
        b.append(", ");
        b.append("chassisType=");
        b.append(this.chassisType);
        b.append(", ");
        b.append("chromeOSDeviceInfo=");
        b.append(this.chromeOSDeviceInfo);
        b.append(", ");
        b.append("complianceGracePeriodExpirationDateTime=");
        b.append(this.complianceGracePeriodExpirationDateTime);
        b.append(", ");
        b.append("complianceState=");
        b.append(this.complianceState);
        b.append(", ");
        b.append("configurationManagerClientEnabledFeatures=");
        b.append(this.configurationManagerClientEnabledFeatures);
        b.append(", ");
        b.append("configurationManagerClientHealthState=");
        b.append(this.configurationManagerClientHealthState);
        b.append(", ");
        b.append("configurationManagerClientInformation=");
        b.append(this.configurationManagerClientInformation);
        b.append(", ");
        b.append("deviceActionResults=");
        b.append(this.deviceActionResults);
        b.append(", ");
        b.append("deviceCategoryDisplayName=");
        b.append(this.deviceCategoryDisplayName);
        b.append(", ");
        b.append("deviceEnrollmentType=");
        b.append(this.deviceEnrollmentType);
        b.append(", ");
        b.append("deviceHealthAttestationState=");
        b.append(this.deviceHealthAttestationState);
        b.append(", ");
        b.append("deviceName=");
        b.append(this.deviceName);
        b.append(", ");
        b.append("deviceRegistrationState=");
        b.append(this.deviceRegistrationState);
        b.append(", ");
        b.append("deviceType=");
        b.append(this.deviceType);
        b.append(", ");
        b.append("easActivated=");
        b.append(this.easActivated);
        b.append(", ");
        b.append("easActivationDateTime=");
        b.append(this.easActivationDateTime);
        b.append(", ");
        b.append("easDeviceId=");
        b.append(this.easDeviceId);
        b.append(", ");
        b.append("emailAddress=");
        b.append(this.emailAddress);
        b.append(", ");
        b.append("enrolledDateTime=");
        b.append(this.enrolledDateTime);
        b.append(", ");
        b.append("enrollmentProfileName=");
        b.append(this.enrollmentProfileName);
        b.append(", ");
        b.append("ethernetMacAddress=");
        b.append(this.ethernetMacAddress);
        b.append(", ");
        b.append("exchangeAccessState=");
        b.append(this.exchangeAccessState);
        b.append(", ");
        b.append("exchangeAccessStateReason=");
        b.append(this.exchangeAccessStateReason);
        b.append(", ");
        b.append("exchangeLastSuccessfulSyncDateTime=");
        b.append(this.exchangeLastSuccessfulSyncDateTime);
        b.append(", ");
        b.append("freeStorageSpaceInBytes=");
        b.append(this.freeStorageSpaceInBytes);
        b.append(", ");
        b.append("hardwareInformation=");
        b.append(this.hardwareInformation);
        b.append(", ");
        b.append("iccid=");
        b.append(this.iccid);
        b.append(", ");
        b.append("imei=");
        b.append(this.imei);
        b.append(", ");
        b.append("isEncrypted=");
        b.append(this.isEncrypted);
        b.append(", ");
        b.append("isSupervised=");
        b.append(this.isSupervised);
        b.append(", ");
        b.append("jailBroken=");
        b.append(this.jailBroken);
        b.append(", ");
        b.append("joinType=");
        b.append(this.joinType);
        b.append(", ");
        b.append("lastSyncDateTime=");
        b.append(this.lastSyncDateTime);
        b.append(", ");
        b.append("lostModeState=");
        b.append(this.lostModeState);
        b.append(", ");
        b.append("managedDeviceName=");
        b.append(this.managedDeviceName);
        b.append(", ");
        b.append("managedDeviceOwnerType=");
        b.append(this.managedDeviceOwnerType);
        b.append(", ");
        b.append("managementAgent=");
        b.append(this.managementAgent);
        b.append(", ");
        b.append("managementCertificateExpirationDate=");
        b.append(this.managementCertificateExpirationDate);
        b.append(", ");
        b.append("managementFeatures=");
        b.append(this.managementFeatures);
        b.append(", ");
        b.append("managementState=");
        b.append(this.managementState);
        b.append(", ");
        b.append("manufacturer=");
        b.append(this.manufacturer);
        b.append(", ");
        b.append("meid=");
        b.append(this.meid);
        b.append(", ");
        b.append("model=");
        b.append(this.model);
        b.append(", ");
        b.append("notes=");
        b.append(this.notes);
        b.append(", ");
        b.append("operatingSystem=");
        b.append(this.operatingSystem);
        b.append(", ");
        b.append("osVersion=");
        b.append(this.osVersion);
        b.append(", ");
        b.append("ownerType=");
        b.append(this.ownerType);
        b.append(", ");
        b.append("partnerReportedThreatState=");
        b.append(this.partnerReportedThreatState);
        b.append(", ");
        b.append("phoneNumber=");
        b.append(this.phoneNumber);
        b.append(", ");
        b.append("physicalMemoryInBytes=");
        b.append(this.physicalMemoryInBytes);
        b.append(", ");
        b.append("preferMdmOverGroupPolicyAppliedDateTime=");
        b.append(this.preferMdmOverGroupPolicyAppliedDateTime);
        b.append(", ");
        b.append("processorArchitecture=");
        b.append(this.processorArchitecture);
        b.append(", ");
        b.append("remoteAssistanceSessionErrorDetails=");
        b.append(this.remoteAssistanceSessionErrorDetails);
        b.append(", ");
        b.append("remoteAssistanceSessionUrl=");
        b.append(this.remoteAssistanceSessionUrl);
        b.append(", ");
        b.append("requireUserEnrollmentApproval=");
        b.append(this.requireUserEnrollmentApproval);
        b.append(", ");
        b.append("retireAfterDateTime=");
        b.append(this.retireAfterDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("serialNumber=");
        b.append(this.serialNumber);
        b.append(", ");
        b.append("skuFamily=");
        b.append(this.skuFamily);
        b.append(", ");
        b.append("skuNumber=");
        b.append(this.skuNumber);
        b.append(", ");
        b.append("specificationVersion=");
        b.append(this.specificationVersion);
        b.append(", ");
        b.append("subscriberCarrier=");
        b.append(this.subscriberCarrier);
        b.append(", ");
        b.append("totalStorageSpaceInBytes=");
        b.append(this.totalStorageSpaceInBytes);
        b.append(", ");
        b.append("udid=");
        b.append(this.udid);
        b.append(", ");
        b.append("userDisplayName=");
        b.append(this.userDisplayName);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("usersLoggedOn=");
        b.append(this.usersLoggedOn);
        b.append(", ");
        b.append("wiFiMacAddress=");
        b.append(this.wiFiMacAddress);
        b.append(", ");
        b.append("windowsActiveMalwareCount=");
        b.append(this.windowsActiveMalwareCount);
        b.append(", ");
        b.append("windowsRemediatedMalwareCount=");
        b.append(this.windowsRemediatedMalwareCount);
        b.append(", ");
        b.append("assignmentFilterEvaluationStatusDetails=");
        b.append(this.assignmentFilterEvaluationStatusDetails);
        b.append(", ");
        b.append("deviceCompliancePolicyStates=");
        b.append(this.deviceCompliancePolicyStates);
        b.append(", ");
        b.append("deviceConfigurationStates=");
        b.append(this.deviceConfigurationStates);
        b.append(", ");
        b.append("managedDeviceMobileAppConfigurationStates=");
        b.append(this.managedDeviceMobileAppConfigurationStates);
        b.append(", ");
        b.append("securityBaselineStates=");
        b.append(this.securityBaselineStates);
        b.append(", ");
        b.append("deviceCategory=");
        b.append(this.deviceCategory);
        b.append(", ");
        b.append("logCollectionRequests=");
        b.append(this.logCollectionRequests);
        b.append(", ");
        b.append("windowsProtectionState=");
        b.append(this.windowsProtectionState);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
