package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ActionState;


/**
 * <i>“Represents wipe requests issued by tenant admin for Bring-Your-Own-Device(BYOD)
 * Windows devices.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "lastCheckInDateTime", 
    "status", 
    "targetedDeviceMacAddress", 
    "targetedDeviceName", 
    "targetedDeviceRegistrationId", 
    "targetedUserId"})
@JsonInclude(Include.NON_NULL)
public class WindowsInformationProtectionWipeAction extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsInformationProtectionWipeAction";
    }

    @JsonProperty("lastCheckInDateTime")
    protected OffsetDateTime lastCheckInDateTime;

    @JsonProperty("status")
    protected ActionState status;

    @JsonProperty("targetedDeviceMacAddress")
    protected String targetedDeviceMacAddress;

    @JsonProperty("targetedDeviceName")
    protected String targetedDeviceName;

    @JsonProperty("targetedDeviceRegistrationId")
    protected String targetedDeviceRegistrationId;

    @JsonProperty("targetedUserId")
    protected String targetedUserId;

    protected WindowsInformationProtectionWipeAction() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsInformationProtectionWipeAction() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastCheckInDateTime;
        private ActionState status;
        private String targetedDeviceMacAddress;
        private String targetedDeviceName;
        private String targetedDeviceRegistrationId;
        private String targetedUserId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Last checkin time of the device that was targeted by this wipe action.”</i>
         * 
         * @param lastCheckInDateTime
         *            value of {@code lastCheckInDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastCheckInDateTime(OffsetDateTime lastCheckInDateTime) {
            this.lastCheckInDateTime = lastCheckInDateTime;
            this.changedFields = changedFields.add("lastCheckInDateTime");
            return this;
        }

        /**
         * <i>“Wipe action status.”</i>
         * 
         * @param status
         *            value of {@code status} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder status(ActionState status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        /**
         * <i>“Targeted device Mac address.”</i>
         * 
         * @param targetedDeviceMacAddress
         *            value of {@code targetedDeviceMacAddress} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetedDeviceMacAddress(String targetedDeviceMacAddress) {
            this.targetedDeviceMacAddress = targetedDeviceMacAddress;
            this.changedFields = changedFields.add("targetedDeviceMacAddress");
            return this;
        }

        /**
         * <i>“Targeted device name.”</i>
         * 
         * @param targetedDeviceName
         *            value of {@code targetedDeviceName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetedDeviceName(String targetedDeviceName) {
            this.targetedDeviceName = targetedDeviceName;
            this.changedFields = changedFields.add("targetedDeviceName");
            return this;
        }

        /**
         * <i>“The DeviceRegistrationId being targeted by this wipe action.”</i>
         * 
         * @param targetedDeviceRegistrationId
         *            value of {@code targetedDeviceRegistrationId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetedDeviceRegistrationId(String targetedDeviceRegistrationId) {
            this.targetedDeviceRegistrationId = targetedDeviceRegistrationId;
            this.changedFields = changedFields.add("targetedDeviceRegistrationId");
            return this;
        }

        /**
         * <i>“The UserId being targeted by this wipe action.”</i>
         * 
         * @param targetedUserId
         *            value of {@code targetedUserId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetedUserId(String targetedUserId) {
            this.targetedUserId = targetedUserId;
            this.changedFields = changedFields.add("targetedUserId");
            return this;
        }

        public WindowsInformationProtectionWipeAction build() {
            WindowsInformationProtectionWipeAction _x = new WindowsInformationProtectionWipeAction();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsInformationProtectionWipeAction";
            _x.id = id;
            _x.lastCheckInDateTime = lastCheckInDateTime;
            _x.status = status;
            _x.targetedDeviceMacAddress = targetedDeviceMacAddress;
            _x.targetedDeviceName = targetedDeviceName;
            _x.targetedDeviceRegistrationId = targetedDeviceRegistrationId;
            _x.targetedUserId = targetedUserId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Last checkin time of the device that was targeted by this wipe action.”</i>
     * 
     * @return property lastCheckInDateTime
     */
    @Property(name="lastCheckInDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastCheckInDateTime() {
        return Optional.ofNullable(lastCheckInDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastCheckInDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Last checkin time of the device that was targeted by this wipe action.”</i>
     * 
     * @param lastCheckInDateTime
     *            new value of {@code lastCheckInDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastCheckInDateTime} field changed
     */
    public WindowsInformationProtectionWipeAction withLastCheckInDateTime(OffsetDateTime lastCheckInDateTime) {
        WindowsInformationProtectionWipeAction _x = _copy();
        _x.changedFields = changedFields.add("lastCheckInDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionWipeAction");
        _x.lastCheckInDateTime = lastCheckInDateTime;
        return _x;
    }

    /**
     * <i>“Wipe action status.”</i>
     * 
     * @return property status
     */
    @Property(name="status")
    @JsonIgnore
    public Optional<ActionState> getStatus() {
        return Optional.ofNullable(status);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code status} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Wipe action status.”</i>
     * 
     * @param status
     *            new value of {@code status} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code status} field changed
     */
    public WindowsInformationProtectionWipeAction withStatus(ActionState status) {
        WindowsInformationProtectionWipeAction _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionWipeAction");
        _x.status = status;
        return _x;
    }

    /**
     * <i>“Targeted device Mac address.”</i>
     * 
     * @return property targetedDeviceMacAddress
     */
    @Property(name="targetedDeviceMacAddress")
    @JsonIgnore
    public Optional<String> getTargetedDeviceMacAddress() {
        return Optional.ofNullable(targetedDeviceMacAddress);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * targetedDeviceMacAddress} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Targeted device Mac address.”</i>
     * 
     * @param targetedDeviceMacAddress
     *            new value of {@code targetedDeviceMacAddress} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code targetedDeviceMacAddress} field changed
     */
    public WindowsInformationProtectionWipeAction withTargetedDeviceMacAddress(String targetedDeviceMacAddress) {
        WindowsInformationProtectionWipeAction _x = _copy();
        _x.changedFields = changedFields.add("targetedDeviceMacAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionWipeAction");
        _x.targetedDeviceMacAddress = targetedDeviceMacAddress;
        return _x;
    }

    /**
     * <i>“Targeted device name.”</i>
     * 
     * @return property targetedDeviceName
     */
    @Property(name="targetedDeviceName")
    @JsonIgnore
    public Optional<String> getTargetedDeviceName() {
        return Optional.ofNullable(targetedDeviceName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * targetedDeviceName} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Targeted device name.”</i>
     * 
     * @param targetedDeviceName
     *            new value of {@code targetedDeviceName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code targetedDeviceName} field changed
     */
    public WindowsInformationProtectionWipeAction withTargetedDeviceName(String targetedDeviceName) {
        WindowsInformationProtectionWipeAction _x = _copy();
        _x.changedFields = changedFields.add("targetedDeviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionWipeAction");
        _x.targetedDeviceName = targetedDeviceName;
        return _x;
    }

    /**
     * <i>“The DeviceRegistrationId being targeted by this wipe action.”</i>
     * 
     * @return property targetedDeviceRegistrationId
     */
    @Property(name="targetedDeviceRegistrationId")
    @JsonIgnore
    public Optional<String> getTargetedDeviceRegistrationId() {
        return Optional.ofNullable(targetedDeviceRegistrationId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * targetedDeviceRegistrationId} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The DeviceRegistrationId being targeted by this wipe action.”</i>
     * 
     * @param targetedDeviceRegistrationId
     *            new value of {@code targetedDeviceRegistrationId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code targetedDeviceRegistrationId} field changed
     */
    public WindowsInformationProtectionWipeAction withTargetedDeviceRegistrationId(String targetedDeviceRegistrationId) {
        WindowsInformationProtectionWipeAction _x = _copy();
        _x.changedFields = changedFields.add("targetedDeviceRegistrationId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionWipeAction");
        _x.targetedDeviceRegistrationId = targetedDeviceRegistrationId;
        return _x;
    }

    /**
     * <i>“The UserId being targeted by this wipe action.”</i>
     * 
     * @return property targetedUserId
     */
    @Property(name="targetedUserId")
    @JsonIgnore
    public Optional<String> getTargetedUserId() {
        return Optional.ofNullable(targetedUserId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code targetedUserId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The UserId being targeted by this wipe action.”</i>
     * 
     * @param targetedUserId
     *            new value of {@code targetedUserId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code targetedUserId} field changed
     */
    public WindowsInformationProtectionWipeAction withTargetedUserId(String targetedUserId) {
        WindowsInformationProtectionWipeAction _x = _copy();
        _x.changedFields = changedFields.add("targetedUserId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionWipeAction");
        _x.targetedUserId = targetedUserId;
        return _x;
    }

    public WindowsInformationProtectionWipeAction withUnmappedField(String name, Object value) {
        WindowsInformationProtectionWipeAction _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsInformationProtectionWipeAction patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsInformationProtectionWipeAction _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsInformationProtectionWipeAction put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsInformationProtectionWipeAction _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsInformationProtectionWipeAction _copy() {
        WindowsInformationProtectionWipeAction _x = new WindowsInformationProtectionWipeAction();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.lastCheckInDateTime = lastCheckInDateTime;
        _x.status = status;
        _x.targetedDeviceMacAddress = targetedDeviceMacAddress;
        _x.targetedDeviceName = targetedDeviceName;
        _x.targetedDeviceRegistrationId = targetedDeviceRegistrationId;
        _x.targetedUserId = targetedUserId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsInformationProtectionWipeAction[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastCheckInDateTime=");
        b.append(this.lastCheckInDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("targetedDeviceMacAddress=");
        b.append(this.targetedDeviceMacAddress);
        b.append(", ");
        b.append("targetedDeviceName=");
        b.append(this.targetedDeviceName);
        b.append(", ");
        b.append("targetedDeviceRegistrationId=");
        b.append(this.targetedDeviceRegistrationId);
        b.append(", ");
        b.append("targetedUserId=");
        b.append(this.targetedUserId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
