package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

import odata.msgraph.client.beta.complex.WindowsInformationProtectionApp;
import odata.msgraph.client.beta.complex.WindowsInformationProtectionDataRecoveryCertificate;
import odata.msgraph.client.beta.complex.WindowsInformationProtectionIPRangeCollection;
import odata.msgraph.client.beta.complex.WindowsInformationProtectionProxiedDomainCollection;
import odata.msgraph.client.beta.complex.WindowsInformationProtectionResourceCollection;
import odata.msgraph.client.beta.enums.WindowsInformationProtectionEnforcementLevel;
import odata.msgraph.client.beta.enums.WindowsInformationProtectionPinCharacterRequirements;


/**
 * <i>“Policy for Windows information protection without MDM”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "daysWithoutContactBeforeUnenroll", 
    "mdmEnrollmentUrl", 
    "minutesOfInactivityBeforeDeviceLock", 
    "numberOfPastPinsRemembered", 
    "passwordMaximumAttemptCount", 
    "pinExpirationDays", 
    "pinLowercaseLetters", 
    "pinMinimumLength", 
    "pinSpecialCharacters", 
    "pinUppercaseLetters", 
    "revokeOnMdmHandoffDisabled", 
    "windowsHelloForBusinessBlocked"})
@JsonInclude(Include.NON_NULL)
public class WindowsInformationProtectionPolicy extends WindowsInformationProtection implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsInformationProtectionPolicy";
    }

    @JsonProperty("daysWithoutContactBeforeUnenroll")
    protected Integer daysWithoutContactBeforeUnenroll;

    @JsonProperty("mdmEnrollmentUrl")
    protected String mdmEnrollmentUrl;

    @JsonProperty("minutesOfInactivityBeforeDeviceLock")
    protected Integer minutesOfInactivityBeforeDeviceLock;

    @JsonProperty("numberOfPastPinsRemembered")
    protected Integer numberOfPastPinsRemembered;

    @JsonProperty("passwordMaximumAttemptCount")
    protected Integer passwordMaximumAttemptCount;

    @JsonProperty("pinExpirationDays")
    protected Integer pinExpirationDays;

    @JsonProperty("pinLowercaseLetters")
    protected WindowsInformationProtectionPinCharacterRequirements pinLowercaseLetters;

    @JsonProperty("pinMinimumLength")
    protected Integer pinMinimumLength;

    @JsonProperty("pinSpecialCharacters")
    protected WindowsInformationProtectionPinCharacterRequirements pinSpecialCharacters;

    @JsonProperty("pinUppercaseLetters")
    protected WindowsInformationProtectionPinCharacterRequirements pinUppercaseLetters;

    @JsonProperty("revokeOnMdmHandoffDisabled")
    protected Boolean revokeOnMdmHandoffDisabled;

    @JsonProperty("windowsHelloForBusinessBlocked")
    protected Boolean windowsHelloForBusinessBlocked;

    protected WindowsInformationProtectionPolicy() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsInformationProtectionPolicy() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private String version;
        private Boolean azureRightsManagementServicesAllowed;
        private WindowsInformationProtectionDataRecoveryCertificate dataRecoveryCertificate;
        private WindowsInformationProtectionEnforcementLevel enforcementLevel;
        private String enterpriseDomain;
        private List<WindowsInformationProtectionResourceCollection> enterpriseInternalProxyServers;
        private String enterpriseInternalProxyServersNextLink;
        private List<WindowsInformationProtectionIPRangeCollection> enterpriseIPRanges;
        private String enterpriseIPRangesNextLink;
        private Boolean enterpriseIPRangesAreAuthoritative;
        private List<WindowsInformationProtectionResourceCollection> enterpriseNetworkDomainNames;
        private String enterpriseNetworkDomainNamesNextLink;
        private List<WindowsInformationProtectionResourceCollection> enterpriseProtectedDomainNames;
        private String enterpriseProtectedDomainNamesNextLink;
        private List<WindowsInformationProtectionProxiedDomainCollection> enterpriseProxiedDomains;
        private String enterpriseProxiedDomainsNextLink;
        private List<WindowsInformationProtectionResourceCollection> enterpriseProxyServers;
        private String enterpriseProxyServersNextLink;
        private Boolean enterpriseProxyServersAreAuthoritative;
        private List<WindowsInformationProtectionApp> exemptApps;
        private String exemptAppsNextLink;
        private Boolean iconsVisible;
        private Boolean indexingEncryptedStoresOrItemsBlocked;
        private Boolean isAssigned;
        private List<WindowsInformationProtectionResourceCollection> neutralDomainResources;
        private String neutralDomainResourcesNextLink;
        private List<WindowsInformationProtectionApp> protectedApps;
        private String protectedAppsNextLink;
        private Boolean protectionUnderLockConfigRequired;
        private Boolean revokeOnUnenrollDisabled;
        private UUID rightsManagementServicesTemplateId;
        private List<WindowsInformationProtectionResourceCollection> smbAutoEncryptedFileExtensions;
        private String smbAutoEncryptedFileExtensionsNextLink;
        private List<TargetedManagedAppPolicyAssignment> assignments;
        private List<WindowsInformationProtectionAppLockerFile> exemptAppLockerFiles;
        private List<WindowsInformationProtectionAppLockerFile> protectedAppLockerFiles;
        private Integer daysWithoutContactBeforeUnenroll;
        private String mdmEnrollmentUrl;
        private Integer minutesOfInactivityBeforeDeviceLock;
        private Integer numberOfPastPinsRemembered;
        private Integer passwordMaximumAttemptCount;
        private Integer pinExpirationDays;
        private WindowsInformationProtectionPinCharacterRequirements pinLowercaseLetters;
        private Integer pinMinimumLength;
        private WindowsInformationProtectionPinCharacterRequirements pinSpecialCharacters;
        private WindowsInformationProtectionPinCharacterRequirements pinUppercaseLetters;
        private Boolean revokeOnMdmHandoffDisabled;
        private Boolean windowsHelloForBusinessBlocked;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder azureRightsManagementServicesAllowed(Boolean azureRightsManagementServicesAllowed) {
            this.azureRightsManagementServicesAllowed = azureRightsManagementServicesAllowed;
            this.changedFields = changedFields.add("azureRightsManagementServicesAllowed");
            return this;
        }

        public Builder dataRecoveryCertificate(WindowsInformationProtectionDataRecoveryCertificate dataRecoveryCertificate) {
            this.dataRecoveryCertificate = dataRecoveryCertificate;
            this.changedFields = changedFields.add("dataRecoveryCertificate");
            return this;
        }

        public Builder enforcementLevel(WindowsInformationProtectionEnforcementLevel enforcementLevel) {
            this.enforcementLevel = enforcementLevel;
            this.changedFields = changedFields.add("enforcementLevel");
            return this;
        }

        public Builder enterpriseDomain(String enterpriseDomain) {
            this.enterpriseDomain = enterpriseDomain;
            this.changedFields = changedFields.add("enterpriseDomain");
            return this;
        }

        public Builder enterpriseInternalProxyServers(List<WindowsInformationProtectionResourceCollection> enterpriseInternalProxyServers) {
            this.enterpriseInternalProxyServers = enterpriseInternalProxyServers;
            this.changedFields = changedFields.add("enterpriseInternalProxyServers");
            return this;
        }

        public Builder enterpriseInternalProxyServers(WindowsInformationProtectionResourceCollection... enterpriseInternalProxyServers) {
            return enterpriseInternalProxyServers(Arrays.asList(enterpriseInternalProxyServers));
        }

        public Builder enterpriseInternalProxyServersNextLink(String enterpriseInternalProxyServersNextLink) {
            this.enterpriseInternalProxyServersNextLink = enterpriseInternalProxyServersNextLink;
            this.changedFields = changedFields.add("enterpriseInternalProxyServers");
            return this;
        }

        public Builder enterpriseIPRanges(List<WindowsInformationProtectionIPRangeCollection> enterpriseIPRanges) {
            this.enterpriseIPRanges = enterpriseIPRanges;
            this.changedFields = changedFields.add("enterpriseIPRanges");
            return this;
        }

        public Builder enterpriseIPRanges(WindowsInformationProtectionIPRangeCollection... enterpriseIPRanges) {
            return enterpriseIPRanges(Arrays.asList(enterpriseIPRanges));
        }

        public Builder enterpriseIPRangesNextLink(String enterpriseIPRangesNextLink) {
            this.enterpriseIPRangesNextLink = enterpriseIPRangesNextLink;
            this.changedFields = changedFields.add("enterpriseIPRanges");
            return this;
        }

        public Builder enterpriseIPRangesAreAuthoritative(Boolean enterpriseIPRangesAreAuthoritative) {
            this.enterpriseIPRangesAreAuthoritative = enterpriseIPRangesAreAuthoritative;
            this.changedFields = changedFields.add("enterpriseIPRangesAreAuthoritative");
            return this;
        }

        public Builder enterpriseNetworkDomainNames(List<WindowsInformationProtectionResourceCollection> enterpriseNetworkDomainNames) {
            this.enterpriseNetworkDomainNames = enterpriseNetworkDomainNames;
            this.changedFields = changedFields.add("enterpriseNetworkDomainNames");
            return this;
        }

        public Builder enterpriseNetworkDomainNames(WindowsInformationProtectionResourceCollection... enterpriseNetworkDomainNames) {
            return enterpriseNetworkDomainNames(Arrays.asList(enterpriseNetworkDomainNames));
        }

        public Builder enterpriseNetworkDomainNamesNextLink(String enterpriseNetworkDomainNamesNextLink) {
            this.enterpriseNetworkDomainNamesNextLink = enterpriseNetworkDomainNamesNextLink;
            this.changedFields = changedFields.add("enterpriseNetworkDomainNames");
            return this;
        }

        public Builder enterpriseProtectedDomainNames(List<WindowsInformationProtectionResourceCollection> enterpriseProtectedDomainNames) {
            this.enterpriseProtectedDomainNames = enterpriseProtectedDomainNames;
            this.changedFields = changedFields.add("enterpriseProtectedDomainNames");
            return this;
        }

        public Builder enterpriseProtectedDomainNames(WindowsInformationProtectionResourceCollection... enterpriseProtectedDomainNames) {
            return enterpriseProtectedDomainNames(Arrays.asList(enterpriseProtectedDomainNames));
        }

        public Builder enterpriseProtectedDomainNamesNextLink(String enterpriseProtectedDomainNamesNextLink) {
            this.enterpriseProtectedDomainNamesNextLink = enterpriseProtectedDomainNamesNextLink;
            this.changedFields = changedFields.add("enterpriseProtectedDomainNames");
            return this;
        }

        public Builder enterpriseProxiedDomains(List<WindowsInformationProtectionProxiedDomainCollection> enterpriseProxiedDomains) {
            this.enterpriseProxiedDomains = enterpriseProxiedDomains;
            this.changedFields = changedFields.add("enterpriseProxiedDomains");
            return this;
        }

        public Builder enterpriseProxiedDomains(WindowsInformationProtectionProxiedDomainCollection... enterpriseProxiedDomains) {
            return enterpriseProxiedDomains(Arrays.asList(enterpriseProxiedDomains));
        }

        public Builder enterpriseProxiedDomainsNextLink(String enterpriseProxiedDomainsNextLink) {
            this.enterpriseProxiedDomainsNextLink = enterpriseProxiedDomainsNextLink;
            this.changedFields = changedFields.add("enterpriseProxiedDomains");
            return this;
        }

        public Builder enterpriseProxyServers(List<WindowsInformationProtectionResourceCollection> enterpriseProxyServers) {
            this.enterpriseProxyServers = enterpriseProxyServers;
            this.changedFields = changedFields.add("enterpriseProxyServers");
            return this;
        }

        public Builder enterpriseProxyServers(WindowsInformationProtectionResourceCollection... enterpriseProxyServers) {
            return enterpriseProxyServers(Arrays.asList(enterpriseProxyServers));
        }

        public Builder enterpriseProxyServersNextLink(String enterpriseProxyServersNextLink) {
            this.enterpriseProxyServersNextLink = enterpriseProxyServersNextLink;
            this.changedFields = changedFields.add("enterpriseProxyServers");
            return this;
        }

        public Builder enterpriseProxyServersAreAuthoritative(Boolean enterpriseProxyServersAreAuthoritative) {
            this.enterpriseProxyServersAreAuthoritative = enterpriseProxyServersAreAuthoritative;
            this.changedFields = changedFields.add("enterpriseProxyServersAreAuthoritative");
            return this;
        }

        public Builder exemptApps(List<WindowsInformationProtectionApp> exemptApps) {
            this.exemptApps = exemptApps;
            this.changedFields = changedFields.add("exemptApps");
            return this;
        }

        public Builder exemptApps(WindowsInformationProtectionApp... exemptApps) {
            return exemptApps(Arrays.asList(exemptApps));
        }

        public Builder exemptAppsNextLink(String exemptAppsNextLink) {
            this.exemptAppsNextLink = exemptAppsNextLink;
            this.changedFields = changedFields.add("exemptApps");
            return this;
        }

        public Builder iconsVisible(Boolean iconsVisible) {
            this.iconsVisible = iconsVisible;
            this.changedFields = changedFields.add("iconsVisible");
            return this;
        }

        public Builder indexingEncryptedStoresOrItemsBlocked(Boolean indexingEncryptedStoresOrItemsBlocked) {
            this.indexingEncryptedStoresOrItemsBlocked = indexingEncryptedStoresOrItemsBlocked;
            this.changedFields = changedFields.add("indexingEncryptedStoresOrItemsBlocked");
            return this;
        }

        public Builder isAssigned(Boolean isAssigned) {
            this.isAssigned = isAssigned;
            this.changedFields = changedFields.add("isAssigned");
            return this;
        }

        public Builder neutralDomainResources(List<WindowsInformationProtectionResourceCollection> neutralDomainResources) {
            this.neutralDomainResources = neutralDomainResources;
            this.changedFields = changedFields.add("neutralDomainResources");
            return this;
        }

        public Builder neutralDomainResources(WindowsInformationProtectionResourceCollection... neutralDomainResources) {
            return neutralDomainResources(Arrays.asList(neutralDomainResources));
        }

        public Builder neutralDomainResourcesNextLink(String neutralDomainResourcesNextLink) {
            this.neutralDomainResourcesNextLink = neutralDomainResourcesNextLink;
            this.changedFields = changedFields.add("neutralDomainResources");
            return this;
        }

        public Builder protectedApps(List<WindowsInformationProtectionApp> protectedApps) {
            this.protectedApps = protectedApps;
            this.changedFields = changedFields.add("protectedApps");
            return this;
        }

        public Builder protectedApps(WindowsInformationProtectionApp... protectedApps) {
            return protectedApps(Arrays.asList(protectedApps));
        }

        public Builder protectedAppsNextLink(String protectedAppsNextLink) {
            this.protectedAppsNextLink = protectedAppsNextLink;
            this.changedFields = changedFields.add("protectedApps");
            return this;
        }

        public Builder protectionUnderLockConfigRequired(Boolean protectionUnderLockConfigRequired) {
            this.protectionUnderLockConfigRequired = protectionUnderLockConfigRequired;
            this.changedFields = changedFields.add("protectionUnderLockConfigRequired");
            return this;
        }

        public Builder revokeOnUnenrollDisabled(Boolean revokeOnUnenrollDisabled) {
            this.revokeOnUnenrollDisabled = revokeOnUnenrollDisabled;
            this.changedFields = changedFields.add("revokeOnUnenrollDisabled");
            return this;
        }

        public Builder rightsManagementServicesTemplateId(UUID rightsManagementServicesTemplateId) {
            this.rightsManagementServicesTemplateId = rightsManagementServicesTemplateId;
            this.changedFields = changedFields.add("rightsManagementServicesTemplateId");
            return this;
        }

        public Builder smbAutoEncryptedFileExtensions(List<WindowsInformationProtectionResourceCollection> smbAutoEncryptedFileExtensions) {
            this.smbAutoEncryptedFileExtensions = smbAutoEncryptedFileExtensions;
            this.changedFields = changedFields.add("smbAutoEncryptedFileExtensions");
            return this;
        }

        public Builder smbAutoEncryptedFileExtensions(WindowsInformationProtectionResourceCollection... smbAutoEncryptedFileExtensions) {
            return smbAutoEncryptedFileExtensions(Arrays.asList(smbAutoEncryptedFileExtensions));
        }

        public Builder smbAutoEncryptedFileExtensionsNextLink(String smbAutoEncryptedFileExtensionsNextLink) {
            this.smbAutoEncryptedFileExtensionsNextLink = smbAutoEncryptedFileExtensionsNextLink;
            this.changedFields = changedFields.add("smbAutoEncryptedFileExtensions");
            return this;
        }

        public Builder assignments(List<TargetedManagedAppPolicyAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(TargetedManagedAppPolicyAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder exemptAppLockerFiles(List<WindowsInformationProtectionAppLockerFile> exemptAppLockerFiles) {
            this.exemptAppLockerFiles = exemptAppLockerFiles;
            this.changedFields = changedFields.add("exemptAppLockerFiles");
            return this;
        }

        public Builder exemptAppLockerFiles(WindowsInformationProtectionAppLockerFile... exemptAppLockerFiles) {
            return exemptAppLockerFiles(Arrays.asList(exemptAppLockerFiles));
        }

        public Builder protectedAppLockerFiles(List<WindowsInformationProtectionAppLockerFile> protectedAppLockerFiles) {
            this.protectedAppLockerFiles = protectedAppLockerFiles;
            this.changedFields = changedFields.add("protectedAppLockerFiles");
            return this;
        }

        public Builder protectedAppLockerFiles(WindowsInformationProtectionAppLockerFile... protectedAppLockerFiles) {
            return protectedAppLockerFiles(Arrays.asList(protectedAppLockerFiles));
        }

        /**
         * <i>“Offline interval before app data is wiped (days)”</i>
         * 
         * @param daysWithoutContactBeforeUnenroll
         *            value of {@code daysWithoutContactBeforeUnenroll} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder daysWithoutContactBeforeUnenroll(Integer daysWithoutContactBeforeUnenroll) {
            this.daysWithoutContactBeforeUnenroll = daysWithoutContactBeforeUnenroll;
            this.changedFields = changedFields.add("daysWithoutContactBeforeUnenroll");
            return this;
        }

        /**
         * <i>“Enrollment url for the MDM”</i>
         * 
         * @param mdmEnrollmentUrl
         *            value of {@code mdmEnrollmentUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mdmEnrollmentUrl(String mdmEnrollmentUrl) {
            this.mdmEnrollmentUrl = mdmEnrollmentUrl;
            this.changedFields = changedFields.add("mdmEnrollmentUrl");
            return this;
        }

        /**
         * <i>“Specifies the maximum amount of time (in minutes) allowed after the device is
         * idle that will cause the device to become PIN or password locked.   Range is an
         * integer X where 0 &amp;lt;= X &amp;lt;= 999.”</i>
         * 
         * @param minutesOfInactivityBeforeDeviceLock
         *            value of {@code minutesOfInactivityBeforeDeviceLock} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minutesOfInactivityBeforeDeviceLock(Integer minutesOfInactivityBeforeDeviceLock) {
            this.minutesOfInactivityBeforeDeviceLock = minutesOfInactivityBeforeDeviceLock;
            this.changedFields = changedFields.add("minutesOfInactivityBeforeDeviceLock");
            return this;
        }

        /**
         * <i>“Integer value that specifies the number of past PINs that can be associated to a
         * user account that can't be reused. The largest number you can configure for this
         * policy setting is 50. The lowest number you can configure for this policy
         * setting is 0. If this policy is set to 0, then storage of previous PINs is not
         * required. This node was added in Windows 10, version 1511. Default is 0.”</i>
         * 
         * @param numberOfPastPinsRemembered
         *            value of {@code numberOfPastPinsRemembered} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder numberOfPastPinsRemembered(Integer numberOfPastPinsRemembered) {
            this.numberOfPastPinsRemembered = numberOfPastPinsRemembered;
            this.changedFields = changedFields.add("numberOfPastPinsRemembered");
            return this;
        }

        /**
         * <i>“The number of authentication failures allowed before the device will be wiped. A
         * value of 0 disables device wipe functionality. Range is an integer X where 4 &amp;lt;=
         * X &amp;lt;= 16 for desktop and 0 &amp;lt;= X &amp;lt;= 999 for mobile devices.”</i>
         * 
         * @param passwordMaximumAttemptCount
         *            value of {@code passwordMaximumAttemptCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMaximumAttemptCount(Integer passwordMaximumAttemptCount) {
            this.passwordMaximumAttemptCount = passwordMaximumAttemptCount;
            this.changedFields = changedFields.add("passwordMaximumAttemptCount");
            return this;
        }

        /**
         * <i>“Integer value specifies the period of time (in days) that a PIN can be used
         * before the system requires the user to change it. The largest number you can
         * configure for this policy setting is 730. The lowest number you can configure
         * for this policy setting is 0. If this policy is set to 0, then the user's PIN
         * will never expire. This node was added in Windows 10, version 1511. Default is 0
         * .”</i>
         * 
         * @param pinExpirationDays
         *            value of {@code pinExpirationDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder pinExpirationDays(Integer pinExpirationDays) {
            this.pinExpirationDays = pinExpirationDays;
            this.changedFields = changedFields.add("pinExpirationDays");
            return this;
        }

        /**
         * <i>“Integer value that configures the use of lowercase letters in the Windows Hello
         * for Business PIN. Default is NotAllow.”</i>
         * 
         * @param pinLowercaseLetters
         *            value of {@code pinLowercaseLetters} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder pinLowercaseLetters(WindowsInformationProtectionPinCharacterRequirements pinLowercaseLetters) {
            this.pinLowercaseLetters = pinLowercaseLetters;
            this.changedFields = changedFields.add("pinLowercaseLetters");
            return this;
        }

        /**
         * <i>“Integer value that sets the minimum number of characters required for the PIN.
         * Default value is 4. The lowest number you can configure for this policy setting
         * is 4. The largest number you can configure must be less than the number
         * configured in the Maximum PIN length policy setting or the number 127, whichever
         * is the lowest.”</i>
         * 
         * @param pinMinimumLength
         *            value of {@code pinMinimumLength} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder pinMinimumLength(Integer pinMinimumLength) {
            this.pinMinimumLength = pinMinimumLength;
            this.changedFields = changedFields.add("pinMinimumLength");
            return this;
        }

        /**
         * <i>“Integer value that configures the use of special characters in the Windows Hello
         * for Business PIN. Valid special characters for Windows Hello for Business PIN
         * gestures include: ! " # $ % &amp; ' ( ) * + , - . / : ; &amp;lt; = &amp;gt; ? &amp;#064; [ {@literal \} ] ^ _ ` { | }
         * ~. Default is NotAllow.”</i>
         * 
         * @param pinSpecialCharacters
         *            value of {@code pinSpecialCharacters} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder pinSpecialCharacters(WindowsInformationProtectionPinCharacterRequirements pinSpecialCharacters) {
            this.pinSpecialCharacters = pinSpecialCharacters;
            this.changedFields = changedFields.add("pinSpecialCharacters");
            return this;
        }

        /**
         * <i>“Integer value that configures the use of uppercase letters in the Windows Hello
         * for Business PIN. Default is NotAllow.”</i>
         * 
         * @param pinUppercaseLetters
         *            value of {@code pinUppercaseLetters} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder pinUppercaseLetters(WindowsInformationProtectionPinCharacterRequirements pinUppercaseLetters) {
            this.pinUppercaseLetters = pinUppercaseLetters;
            this.changedFields = changedFields.add("pinUppercaseLetters");
            return this;
        }

        /**
         * <i>“New property in RS2, pending documentation”</i>
         * 
         * @param revokeOnMdmHandoffDisabled
         *            value of {@code revokeOnMdmHandoffDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder revokeOnMdmHandoffDisabled(Boolean revokeOnMdmHandoffDisabled) {
            this.revokeOnMdmHandoffDisabled = revokeOnMdmHandoffDisabled;
            this.changedFields = changedFields.add("revokeOnMdmHandoffDisabled");
            return this;
        }

        /**
         * <i>“Boolean value that sets Windows Hello for Business as a method for signing into
         * Windows.”</i>
         * 
         * @param windowsHelloForBusinessBlocked
         *            value of {@code windowsHelloForBusinessBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsHelloForBusinessBlocked(Boolean windowsHelloForBusinessBlocked) {
            this.windowsHelloForBusinessBlocked = windowsHelloForBusinessBlocked;
            this.changedFields = changedFields.add("windowsHelloForBusinessBlocked");
            return this;
        }

        public WindowsInformationProtectionPolicy build() {
            WindowsInformationProtectionPolicy _x = new WindowsInformationProtectionPolicy();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsInformationProtectionPolicy";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.version = version;
            _x.azureRightsManagementServicesAllowed = azureRightsManagementServicesAllowed;
            _x.dataRecoveryCertificate = dataRecoveryCertificate;
            _x.enforcementLevel = enforcementLevel;
            _x.enterpriseDomain = enterpriseDomain;
            _x.enterpriseInternalProxyServers = enterpriseInternalProxyServers;
            _x.enterpriseInternalProxyServersNextLink = enterpriseInternalProxyServersNextLink;
            _x.enterpriseIPRanges = enterpriseIPRanges;
            _x.enterpriseIPRangesNextLink = enterpriseIPRangesNextLink;
            _x.enterpriseIPRangesAreAuthoritative = enterpriseIPRangesAreAuthoritative;
            _x.enterpriseNetworkDomainNames = enterpriseNetworkDomainNames;
            _x.enterpriseNetworkDomainNamesNextLink = enterpriseNetworkDomainNamesNextLink;
            _x.enterpriseProtectedDomainNames = enterpriseProtectedDomainNames;
            _x.enterpriseProtectedDomainNamesNextLink = enterpriseProtectedDomainNamesNextLink;
            _x.enterpriseProxiedDomains = enterpriseProxiedDomains;
            _x.enterpriseProxiedDomainsNextLink = enterpriseProxiedDomainsNextLink;
            _x.enterpriseProxyServers = enterpriseProxyServers;
            _x.enterpriseProxyServersNextLink = enterpriseProxyServersNextLink;
            _x.enterpriseProxyServersAreAuthoritative = enterpriseProxyServersAreAuthoritative;
            _x.exemptApps = exemptApps;
            _x.exemptAppsNextLink = exemptAppsNextLink;
            _x.iconsVisible = iconsVisible;
            _x.indexingEncryptedStoresOrItemsBlocked = indexingEncryptedStoresOrItemsBlocked;
            _x.isAssigned = isAssigned;
            _x.neutralDomainResources = neutralDomainResources;
            _x.neutralDomainResourcesNextLink = neutralDomainResourcesNextLink;
            _x.protectedApps = protectedApps;
            _x.protectedAppsNextLink = protectedAppsNextLink;
            _x.protectionUnderLockConfigRequired = protectionUnderLockConfigRequired;
            _x.revokeOnUnenrollDisabled = revokeOnUnenrollDisabled;
            _x.rightsManagementServicesTemplateId = rightsManagementServicesTemplateId;
            _x.smbAutoEncryptedFileExtensions = smbAutoEncryptedFileExtensions;
            _x.smbAutoEncryptedFileExtensionsNextLink = smbAutoEncryptedFileExtensionsNextLink;
            _x.assignments = assignments;
            _x.exemptAppLockerFiles = exemptAppLockerFiles;
            _x.protectedAppLockerFiles = protectedAppLockerFiles;
            _x.daysWithoutContactBeforeUnenroll = daysWithoutContactBeforeUnenroll;
            _x.mdmEnrollmentUrl = mdmEnrollmentUrl;
            _x.minutesOfInactivityBeforeDeviceLock = minutesOfInactivityBeforeDeviceLock;
            _x.numberOfPastPinsRemembered = numberOfPastPinsRemembered;
            _x.passwordMaximumAttemptCount = passwordMaximumAttemptCount;
            _x.pinExpirationDays = pinExpirationDays;
            _x.pinLowercaseLetters = pinLowercaseLetters;
            _x.pinMinimumLength = pinMinimumLength;
            _x.pinSpecialCharacters = pinSpecialCharacters;
            _x.pinUppercaseLetters = pinUppercaseLetters;
            _x.revokeOnMdmHandoffDisabled = revokeOnMdmHandoffDisabled;
            _x.windowsHelloForBusinessBlocked = windowsHelloForBusinessBlocked;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Offline interval before app data is wiped (days)”</i>
     * 
     * @return property daysWithoutContactBeforeUnenroll
     */
    @Property(name="daysWithoutContactBeforeUnenroll")
    @JsonIgnore
    public Optional<Integer> getDaysWithoutContactBeforeUnenroll() {
        return Optional.ofNullable(daysWithoutContactBeforeUnenroll);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * daysWithoutContactBeforeUnenroll} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Offline interval before app data is wiped (days)”</i>
     * 
     * @param daysWithoutContactBeforeUnenroll
     *            new value of {@code daysWithoutContactBeforeUnenroll} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code daysWithoutContactBeforeUnenroll} field changed
     */
    public WindowsInformationProtectionPolicy withDaysWithoutContactBeforeUnenroll(Integer daysWithoutContactBeforeUnenroll) {
        WindowsInformationProtectionPolicy _x = _copy();
        _x.changedFields = changedFields.add("daysWithoutContactBeforeUnenroll");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionPolicy");
        _x.daysWithoutContactBeforeUnenroll = daysWithoutContactBeforeUnenroll;
        return _x;
    }

    /**
     * <i>“Enrollment url for the MDM”</i>
     * 
     * @return property mdmEnrollmentUrl
     */
    @Property(name="mdmEnrollmentUrl")
    @JsonIgnore
    public Optional<String> getMdmEnrollmentUrl() {
        return Optional.ofNullable(mdmEnrollmentUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code mdmEnrollmentUrl}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Enrollment url for the MDM”</i>
     * 
     * @param mdmEnrollmentUrl
     *            new value of {@code mdmEnrollmentUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mdmEnrollmentUrl} field changed
     */
    public WindowsInformationProtectionPolicy withMdmEnrollmentUrl(String mdmEnrollmentUrl) {
        WindowsInformationProtectionPolicy _x = _copy();
        _x.changedFields = changedFields.add("mdmEnrollmentUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionPolicy");
        _x.mdmEnrollmentUrl = mdmEnrollmentUrl;
        return _x;
    }

    /**
     * <i>“Specifies the maximum amount of time (in minutes) allowed after the device is
     * idle that will cause the device to become PIN or password locked.   Range is an
     * integer X where 0 &amp;lt;= X &amp;lt;= 999.”</i>
     * 
     * @return property minutesOfInactivityBeforeDeviceLock
     */
    @Property(name="minutesOfInactivityBeforeDeviceLock")
    @JsonIgnore
    public Optional<Integer> getMinutesOfInactivityBeforeDeviceLock() {
        return Optional.ofNullable(minutesOfInactivityBeforeDeviceLock);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minutesOfInactivityBeforeDeviceLock} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Specifies the maximum amount of time (in minutes) allowed after the device is
     * idle that will cause the device to become PIN or password locked.   Range is an
     * integer X where 0 &amp;lt;= X &amp;lt;= 999.”</i>
     * 
     * @param minutesOfInactivityBeforeDeviceLock
     *            new value of {@code minutesOfInactivityBeforeDeviceLock} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minutesOfInactivityBeforeDeviceLock} field changed
     */
    public WindowsInformationProtectionPolicy withMinutesOfInactivityBeforeDeviceLock(Integer minutesOfInactivityBeforeDeviceLock) {
        WindowsInformationProtectionPolicy _x = _copy();
        _x.changedFields = changedFields.add("minutesOfInactivityBeforeDeviceLock");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionPolicy");
        _x.minutesOfInactivityBeforeDeviceLock = minutesOfInactivityBeforeDeviceLock;
        return _x;
    }

    /**
     * <i>“Integer value that specifies the number of past PINs that can be associated to a
     * user account that can't be reused. The largest number you can configure for this
     * policy setting is 50. The lowest number you can configure for this policy
     * setting is 0. If this policy is set to 0, then storage of previous PINs is not
     * required. This node was added in Windows 10, version 1511. Default is 0.”</i>
     * 
     * @return property numberOfPastPinsRemembered
     */
    @Property(name="numberOfPastPinsRemembered")
    @JsonIgnore
    public Optional<Integer> getNumberOfPastPinsRemembered() {
        return Optional.ofNullable(numberOfPastPinsRemembered);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * numberOfPastPinsRemembered} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Integer value that specifies the number of past PINs that can be associated to a
     * user account that can't be reused. The largest number you can configure for this
     * policy setting is 50. The lowest number you can configure for this policy
     * setting is 0. If this policy is set to 0, then storage of previous PINs is not
     * required. This node was added in Windows 10, version 1511. Default is 0.”</i>
     * 
     * @param numberOfPastPinsRemembered
     *            new value of {@code numberOfPastPinsRemembered} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code numberOfPastPinsRemembered} field changed
     */
    public WindowsInformationProtectionPolicy withNumberOfPastPinsRemembered(Integer numberOfPastPinsRemembered) {
        WindowsInformationProtectionPolicy _x = _copy();
        _x.changedFields = changedFields.add("numberOfPastPinsRemembered");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionPolicy");
        _x.numberOfPastPinsRemembered = numberOfPastPinsRemembered;
        return _x;
    }

    /**
     * <i>“The number of authentication failures allowed before the device will be wiped. A
     * value of 0 disables device wipe functionality. Range is an integer X where 4 &amp;lt;=
     * X &amp;lt;= 16 for desktop and 0 &amp;lt;= X &amp;lt;= 999 for mobile devices.”</i>
     * 
     * @return property passwordMaximumAttemptCount
     */
    @Property(name="passwordMaximumAttemptCount")
    @JsonIgnore
    public Optional<Integer> getPasswordMaximumAttemptCount() {
        return Optional.ofNullable(passwordMaximumAttemptCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMaximumAttemptCount} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The number of authentication failures allowed before the device will be wiped. A
     * value of 0 disables device wipe functionality. Range is an integer X where 4 &amp;lt;=
     * X &amp;lt;= 16 for desktop and 0 &amp;lt;= X &amp;lt;= 999 for mobile devices.”</i>
     * 
     * @param passwordMaximumAttemptCount
     *            new value of {@code passwordMaximumAttemptCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMaximumAttemptCount} field changed
     */
    public WindowsInformationProtectionPolicy withPasswordMaximumAttemptCount(Integer passwordMaximumAttemptCount) {
        WindowsInformationProtectionPolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordMaximumAttemptCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionPolicy");
        _x.passwordMaximumAttemptCount = passwordMaximumAttemptCount;
        return _x;
    }

    /**
     * <i>“Integer value specifies the period of time (in days) that a PIN can be used
     * before the system requires the user to change it. The largest number you can
     * configure for this policy setting is 730. The lowest number you can configure
     * for this policy setting is 0. If this policy is set to 0, then the user's PIN
     * will never expire. This node was added in Windows 10, version 1511. Default is 0
     * .”</i>
     * 
     * @return property pinExpirationDays
     */
    @Property(name="pinExpirationDays")
    @JsonIgnore
    public Optional<Integer> getPinExpirationDays() {
        return Optional.ofNullable(pinExpirationDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code pinExpirationDays
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Integer value specifies the period of time (in days) that a PIN can be used
     * before the system requires the user to change it. The largest number you can
     * configure for this policy setting is 730. The lowest number you can configure
     * for this policy setting is 0. If this policy is set to 0, then the user's PIN
     * will never expire. This node was added in Windows 10, version 1511. Default is 0
     * .”</i>
     * 
     * @param pinExpirationDays
     *            new value of {@code pinExpirationDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code pinExpirationDays} field changed
     */
    public WindowsInformationProtectionPolicy withPinExpirationDays(Integer pinExpirationDays) {
        WindowsInformationProtectionPolicy _x = _copy();
        _x.changedFields = changedFields.add("pinExpirationDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionPolicy");
        _x.pinExpirationDays = pinExpirationDays;
        return _x;
    }

    /**
     * <i>“Integer value that configures the use of lowercase letters in the Windows Hello
     * for Business PIN. Default is NotAllow.”</i>
     * 
     * @return property pinLowercaseLetters
     */
    @Property(name="pinLowercaseLetters")
    @JsonIgnore
    public Optional<WindowsInformationProtectionPinCharacterRequirements> getPinLowercaseLetters() {
        return Optional.ofNullable(pinLowercaseLetters);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * pinLowercaseLetters} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Integer value that configures the use of lowercase letters in the Windows Hello
     * for Business PIN. Default is NotAllow.”</i>
     * 
     * @param pinLowercaseLetters
     *            new value of {@code pinLowercaseLetters} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code pinLowercaseLetters} field changed
     */
    public WindowsInformationProtectionPolicy withPinLowercaseLetters(WindowsInformationProtectionPinCharacterRequirements pinLowercaseLetters) {
        WindowsInformationProtectionPolicy _x = _copy();
        _x.changedFields = changedFields.add("pinLowercaseLetters");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionPolicy");
        _x.pinLowercaseLetters = pinLowercaseLetters;
        return _x;
    }

    /**
     * <i>“Integer value that sets the minimum number of characters required for the PIN.
     * Default value is 4. The lowest number you can configure for this policy setting
     * is 4. The largest number you can configure must be less than the number
     * configured in the Maximum PIN length policy setting or the number 127, whichever
     * is the lowest.”</i>
     * 
     * @return property pinMinimumLength
     */
    @Property(name="pinMinimumLength")
    @JsonIgnore
    public Optional<Integer> getPinMinimumLength() {
        return Optional.ofNullable(pinMinimumLength);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code pinMinimumLength}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Integer value that sets the minimum number of characters required for the PIN.
     * Default value is 4. The lowest number you can configure for this policy setting
     * is 4. The largest number you can configure must be less than the number
     * configured in the Maximum PIN length policy setting or the number 127, whichever
     * is the lowest.”</i>
     * 
     * @param pinMinimumLength
     *            new value of {@code pinMinimumLength} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code pinMinimumLength} field changed
     */
    public WindowsInformationProtectionPolicy withPinMinimumLength(Integer pinMinimumLength) {
        WindowsInformationProtectionPolicy _x = _copy();
        _x.changedFields = changedFields.add("pinMinimumLength");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionPolicy");
        _x.pinMinimumLength = pinMinimumLength;
        return _x;
    }

    /**
     * <i>“Integer value that configures the use of special characters in the Windows Hello
     * for Business PIN. Valid special characters for Windows Hello for Business PIN
     * gestures include: ! " # $ % &amp; ' ( ) * + , - . / : ; &amp;lt; = &amp;gt; ? &amp;#064; [ {@literal \} ] ^ _ ` { | }
     * ~. Default is NotAllow.”</i>
     * 
     * @return property pinSpecialCharacters
     */
    @Property(name="pinSpecialCharacters")
    @JsonIgnore
    public Optional<WindowsInformationProtectionPinCharacterRequirements> getPinSpecialCharacters() {
        return Optional.ofNullable(pinSpecialCharacters);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * pinSpecialCharacters} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Integer value that configures the use of special characters in the Windows Hello
     * for Business PIN. Valid special characters for Windows Hello for Business PIN
     * gestures include: ! " # $ % &amp; ' ( ) * + , - . / : ; &amp;lt; = &amp;gt; ? &amp;#064; [ {@literal \} ] ^ _ ` { | }
     * ~. Default is NotAllow.”</i>
     * 
     * @param pinSpecialCharacters
     *            new value of {@code pinSpecialCharacters} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code pinSpecialCharacters} field changed
     */
    public WindowsInformationProtectionPolicy withPinSpecialCharacters(WindowsInformationProtectionPinCharacterRequirements pinSpecialCharacters) {
        WindowsInformationProtectionPolicy _x = _copy();
        _x.changedFields = changedFields.add("pinSpecialCharacters");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionPolicy");
        _x.pinSpecialCharacters = pinSpecialCharacters;
        return _x;
    }

    /**
     * <i>“Integer value that configures the use of uppercase letters in the Windows Hello
     * for Business PIN. Default is NotAllow.”</i>
     * 
     * @return property pinUppercaseLetters
     */
    @Property(name="pinUppercaseLetters")
    @JsonIgnore
    public Optional<WindowsInformationProtectionPinCharacterRequirements> getPinUppercaseLetters() {
        return Optional.ofNullable(pinUppercaseLetters);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * pinUppercaseLetters} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Integer value that configures the use of uppercase letters in the Windows Hello
     * for Business PIN. Default is NotAllow.”</i>
     * 
     * @param pinUppercaseLetters
     *            new value of {@code pinUppercaseLetters} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code pinUppercaseLetters} field changed
     */
    public WindowsInformationProtectionPolicy withPinUppercaseLetters(WindowsInformationProtectionPinCharacterRequirements pinUppercaseLetters) {
        WindowsInformationProtectionPolicy _x = _copy();
        _x.changedFields = changedFields.add("pinUppercaseLetters");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionPolicy");
        _x.pinUppercaseLetters = pinUppercaseLetters;
        return _x;
    }

    /**
     * <i>“New property in RS2, pending documentation”</i>
     * 
     * @return property revokeOnMdmHandoffDisabled
     */
    @Property(name="revokeOnMdmHandoffDisabled")
    @JsonIgnore
    public Optional<Boolean> getRevokeOnMdmHandoffDisabled() {
        return Optional.ofNullable(revokeOnMdmHandoffDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * revokeOnMdmHandoffDisabled} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“New property in RS2, pending documentation”</i>
     * 
     * @param revokeOnMdmHandoffDisabled
     *            new value of {@code revokeOnMdmHandoffDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code revokeOnMdmHandoffDisabled} field changed
     */
    public WindowsInformationProtectionPolicy withRevokeOnMdmHandoffDisabled(Boolean revokeOnMdmHandoffDisabled) {
        WindowsInformationProtectionPolicy _x = _copy();
        _x.changedFields = changedFields.add("revokeOnMdmHandoffDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionPolicy");
        _x.revokeOnMdmHandoffDisabled = revokeOnMdmHandoffDisabled;
        return _x;
    }

    /**
     * <i>“Boolean value that sets Windows Hello for Business as a method for signing into
     * Windows.”</i>
     * 
     * @return property windowsHelloForBusinessBlocked
     */
    @Property(name="windowsHelloForBusinessBlocked")
    @JsonIgnore
    public Optional<Boolean> getWindowsHelloForBusinessBlocked() {
        return Optional.ofNullable(windowsHelloForBusinessBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsHelloForBusinessBlocked} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Boolean value that sets Windows Hello for Business as a method for signing into
     * Windows.”</i>
     * 
     * @param windowsHelloForBusinessBlocked
     *            new value of {@code windowsHelloForBusinessBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsHelloForBusinessBlocked} field changed
     */
    public WindowsInformationProtectionPolicy withWindowsHelloForBusinessBlocked(Boolean windowsHelloForBusinessBlocked) {
        WindowsInformationProtectionPolicy _x = _copy();
        _x.changedFields = changedFields.add("windowsHelloForBusinessBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionPolicy");
        _x.windowsHelloForBusinessBlocked = windowsHelloForBusinessBlocked;
        return _x;
    }

    public WindowsInformationProtectionPolicy withUnmappedField(String name, Object value) {
        WindowsInformationProtectionPolicy _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsInformationProtectionPolicy patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsInformationProtectionPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsInformationProtectionPolicy put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsInformationProtectionPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsInformationProtectionPolicy _copy() {
        WindowsInformationProtectionPolicy _x = new WindowsInformationProtectionPolicy();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.version = version;
        _x.azureRightsManagementServicesAllowed = azureRightsManagementServicesAllowed;
        _x.dataRecoveryCertificate = dataRecoveryCertificate;
        _x.enforcementLevel = enforcementLevel;
        _x.enterpriseDomain = enterpriseDomain;
        _x.enterpriseInternalProxyServers = enterpriseInternalProxyServers;
        _x.enterpriseIPRanges = enterpriseIPRanges;
        _x.enterpriseIPRangesAreAuthoritative = enterpriseIPRangesAreAuthoritative;
        _x.enterpriseNetworkDomainNames = enterpriseNetworkDomainNames;
        _x.enterpriseProtectedDomainNames = enterpriseProtectedDomainNames;
        _x.enterpriseProxiedDomains = enterpriseProxiedDomains;
        _x.enterpriseProxyServers = enterpriseProxyServers;
        _x.enterpriseProxyServersAreAuthoritative = enterpriseProxyServersAreAuthoritative;
        _x.exemptApps = exemptApps;
        _x.iconsVisible = iconsVisible;
        _x.indexingEncryptedStoresOrItemsBlocked = indexingEncryptedStoresOrItemsBlocked;
        _x.isAssigned = isAssigned;
        _x.neutralDomainResources = neutralDomainResources;
        _x.protectedApps = protectedApps;
        _x.protectionUnderLockConfigRequired = protectionUnderLockConfigRequired;
        _x.revokeOnUnenrollDisabled = revokeOnUnenrollDisabled;
        _x.rightsManagementServicesTemplateId = rightsManagementServicesTemplateId;
        _x.smbAutoEncryptedFileExtensions = smbAutoEncryptedFileExtensions;
        _x.assignments = assignments;
        _x.exemptAppLockerFiles = exemptAppLockerFiles;
        _x.protectedAppLockerFiles = protectedAppLockerFiles;
        _x.daysWithoutContactBeforeUnenroll = daysWithoutContactBeforeUnenroll;
        _x.mdmEnrollmentUrl = mdmEnrollmentUrl;
        _x.minutesOfInactivityBeforeDeviceLock = minutesOfInactivityBeforeDeviceLock;
        _x.numberOfPastPinsRemembered = numberOfPastPinsRemembered;
        _x.passwordMaximumAttemptCount = passwordMaximumAttemptCount;
        _x.pinExpirationDays = pinExpirationDays;
        _x.pinLowercaseLetters = pinLowercaseLetters;
        _x.pinMinimumLength = pinMinimumLength;
        _x.pinSpecialCharacters = pinSpecialCharacters;
        _x.pinUppercaseLetters = pinUppercaseLetters;
        _x.revokeOnMdmHandoffDisabled = revokeOnMdmHandoffDisabled;
        _x.windowsHelloForBusinessBlocked = windowsHelloForBusinessBlocked;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsInformationProtectionPolicy[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("azureRightsManagementServicesAllowed=");
        b.append(this.azureRightsManagementServicesAllowed);
        b.append(", ");
        b.append("dataRecoveryCertificate=");
        b.append(this.dataRecoveryCertificate);
        b.append(", ");
        b.append("enforcementLevel=");
        b.append(this.enforcementLevel);
        b.append(", ");
        b.append("enterpriseDomain=");
        b.append(this.enterpriseDomain);
        b.append(", ");
        b.append("enterpriseInternalProxyServers=");
        b.append(this.enterpriseInternalProxyServers);
        b.append(", ");
        b.append("enterpriseIPRanges=");
        b.append(this.enterpriseIPRanges);
        b.append(", ");
        b.append("enterpriseIPRangesAreAuthoritative=");
        b.append(this.enterpriseIPRangesAreAuthoritative);
        b.append(", ");
        b.append("enterpriseNetworkDomainNames=");
        b.append(this.enterpriseNetworkDomainNames);
        b.append(", ");
        b.append("enterpriseProtectedDomainNames=");
        b.append(this.enterpriseProtectedDomainNames);
        b.append(", ");
        b.append("enterpriseProxiedDomains=");
        b.append(this.enterpriseProxiedDomains);
        b.append(", ");
        b.append("enterpriseProxyServers=");
        b.append(this.enterpriseProxyServers);
        b.append(", ");
        b.append("enterpriseProxyServersAreAuthoritative=");
        b.append(this.enterpriseProxyServersAreAuthoritative);
        b.append(", ");
        b.append("exemptApps=");
        b.append(this.exemptApps);
        b.append(", ");
        b.append("iconsVisible=");
        b.append(this.iconsVisible);
        b.append(", ");
        b.append("indexingEncryptedStoresOrItemsBlocked=");
        b.append(this.indexingEncryptedStoresOrItemsBlocked);
        b.append(", ");
        b.append("isAssigned=");
        b.append(this.isAssigned);
        b.append(", ");
        b.append("neutralDomainResources=");
        b.append(this.neutralDomainResources);
        b.append(", ");
        b.append("protectedApps=");
        b.append(this.protectedApps);
        b.append(", ");
        b.append("protectionUnderLockConfigRequired=");
        b.append(this.protectionUnderLockConfigRequired);
        b.append(", ");
        b.append("revokeOnUnenrollDisabled=");
        b.append(this.revokeOnUnenrollDisabled);
        b.append(", ");
        b.append("rightsManagementServicesTemplateId=");
        b.append(this.rightsManagementServicesTemplateId);
        b.append(", ");
        b.append("smbAutoEncryptedFileExtensions=");
        b.append(this.smbAutoEncryptedFileExtensions);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("exemptAppLockerFiles=");
        b.append(this.exemptAppLockerFiles);
        b.append(", ");
        b.append("protectedAppLockerFiles=");
        b.append(this.protectedAppLockerFiles);
        b.append(", ");
        b.append("daysWithoutContactBeforeUnenroll=");
        b.append(this.daysWithoutContactBeforeUnenroll);
        b.append(", ");
        b.append("mdmEnrollmentUrl=");
        b.append(this.mdmEnrollmentUrl);
        b.append(", ");
        b.append("minutesOfInactivityBeforeDeviceLock=");
        b.append(this.minutesOfInactivityBeforeDeviceLock);
        b.append(", ");
        b.append("numberOfPastPinsRemembered=");
        b.append(this.numberOfPastPinsRemembered);
        b.append(", ");
        b.append("passwordMaximumAttemptCount=");
        b.append(this.passwordMaximumAttemptCount);
        b.append(", ");
        b.append("pinExpirationDays=");
        b.append(this.pinExpirationDays);
        b.append(", ");
        b.append("pinLowercaseLetters=");
        b.append(this.pinLowercaseLetters);
        b.append(", ");
        b.append("pinMinimumLength=");
        b.append(this.pinMinimumLength);
        b.append(", ");
        b.append("pinSpecialCharacters=");
        b.append(this.pinSpecialCharacters);
        b.append(", ");
        b.append("pinUppercaseLetters=");
        b.append(this.pinUppercaseLetters);
        b.append(", ");
        b.append("revokeOnMdmHandoffDisabled=");
        b.append(this.revokeOnMdmHandoffDisabled);
        b.append(", ");
        b.append("windowsHelloForBusinessBlocked=");
        b.append(this.windowsHelloForBusinessBlocked);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
