package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Windows Information Protection Network learning Summary entity.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "deviceCount", 
    "url"})
@JsonInclude(Include.NON_NULL)
public class WindowsInformationProtectionNetworkLearningSummary extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsInformationProtectionNetworkLearningSummary";
    }

    @JsonProperty("deviceCount")
    protected Integer deviceCount;

    @JsonProperty("url")
    protected String url;

    protected WindowsInformationProtectionNetworkLearningSummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsInformationProtectionNetworkLearningSummary() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer deviceCount;
        private String url;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Device Count”</i>
         * 
         * @param deviceCount
         *            value of {@code deviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceCount(Integer deviceCount) {
            this.deviceCount = deviceCount;
            this.changedFields = changedFields.add("deviceCount");
            return this;
        }

        /**
         * <i>“Website url”</i>
         * 
         * @param url
         *            value of {@code url} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder url(String url) {
            this.url = url;
            this.changedFields = changedFields.add("url");
            return this;
        }

        public WindowsInformationProtectionNetworkLearningSummary build() {
            WindowsInformationProtectionNetworkLearningSummary _x = new WindowsInformationProtectionNetworkLearningSummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsInformationProtectionNetworkLearningSummary";
            _x.id = id;
            _x.deviceCount = deviceCount;
            _x.url = url;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Device Count”</i>
     * 
     * @return property deviceCount
     */
    @Property(name="deviceCount")
    @JsonIgnore
    public Optional<Integer> getDeviceCount() {
        return Optional.ofNullable(deviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Device Count”</i>
     * 
     * @param deviceCount
     *            new value of {@code deviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceCount} field changed
     */
    public WindowsInformationProtectionNetworkLearningSummary withDeviceCount(Integer deviceCount) {
        WindowsInformationProtectionNetworkLearningSummary _x = _copy();
        _x.changedFields = changedFields.add("deviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionNetworkLearningSummary");
        _x.deviceCount = deviceCount;
        return _x;
    }

    /**
     * <i>“Website url”</i>
     * 
     * @return property url
     */
    @Property(name="url")
    @JsonIgnore
    public Optional<String> getUrl() {
        return Optional.ofNullable(url);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code url} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Website url”</i>
     * 
     * @param url
     *            new value of {@code url} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code url} field changed
     */
    public WindowsInformationProtectionNetworkLearningSummary withUrl(String url) {
        WindowsInformationProtectionNetworkLearningSummary _x = _copy();
        _x.changedFields = changedFields.add("url");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsInformationProtectionNetworkLearningSummary");
        _x.url = url;
        return _x;
    }

    public WindowsInformationProtectionNetworkLearningSummary withUnmappedField(String name, Object value) {
        WindowsInformationProtectionNetworkLearningSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsInformationProtectionNetworkLearningSummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsInformationProtectionNetworkLearningSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsInformationProtectionNetworkLearningSummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsInformationProtectionNetworkLearningSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsInformationProtectionNetworkLearningSummary _copy() {
        WindowsInformationProtectionNetworkLearningSummary _x = new WindowsInformationProtectionNetworkLearningSummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.deviceCount = deviceCount;
        _x.url = url;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsInformationProtectionNetworkLearningSummary[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deviceCount=");
        b.append(this.deviceCount);
        b.append(", ");
        b.append("url=");
        b.append(this.url);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
