package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.DeviceRequest;
import odata.msgraph.client.beta.enums.AuthenticationMethodKeyStrength;

@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "displayName", 
    "keyStrength", 
    "device"})
@JsonInclude(Include.NON_NULL)
public class WindowsHelloForBusinessAuthenticationMethod extends AuthenticationMethod implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsHelloForBusinessAuthenticationMethod";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("keyStrength")
    protected AuthenticationMethodKeyStrength keyStrength;

    @JsonProperty("device")
    protected Device device;

    protected WindowsHelloForBusinessAuthenticationMethod() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsHelloForBusinessAuthenticationMethod() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String displayName;
        private AuthenticationMethodKeyStrength keyStrength;
        private Device device;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder keyStrength(AuthenticationMethodKeyStrength keyStrength) {
            this.keyStrength = keyStrength;
            this.changedFields = changedFields.add("keyStrength");
            return this;
        }

        public Builder device(Device device) {
            this.device = device;
            this.changedFields = changedFields.add("device");
            return this;
        }

        public WindowsHelloForBusinessAuthenticationMethod build() {
            WindowsHelloForBusinessAuthenticationMethod _x = new WindowsHelloForBusinessAuthenticationMethod();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsHelloForBusinessAuthenticationMethod";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.displayName = displayName;
            _x.keyStrength = keyStrength;
            _x.device = device;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public WindowsHelloForBusinessAuthenticationMethod withCreatedDateTime(OffsetDateTime createdDateTime) {
        WindowsHelloForBusinessAuthenticationMethod _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsHelloForBusinessAuthenticationMethod");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public WindowsHelloForBusinessAuthenticationMethod withDisplayName(String displayName) {
        WindowsHelloForBusinessAuthenticationMethod _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsHelloForBusinessAuthenticationMethod");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="keyStrength")
    @JsonIgnore
    public Optional<AuthenticationMethodKeyStrength> getKeyStrength() {
        return Optional.ofNullable(keyStrength);
    }

    public WindowsHelloForBusinessAuthenticationMethod withKeyStrength(AuthenticationMethodKeyStrength keyStrength) {
        WindowsHelloForBusinessAuthenticationMethod _x = _copy();
        _x.changedFields = changedFields.add("keyStrength");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsHelloForBusinessAuthenticationMethod");
        _x.keyStrength = keyStrength;
        return _x;
    }

    public WindowsHelloForBusinessAuthenticationMethod withUnmappedField(String name, Object value) {
        WindowsHelloForBusinessAuthenticationMethod _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="device")
    @JsonIgnore
    public DeviceRequest getDevice() {
        return new DeviceRequest(contextPath.addSegment("device"), Optional.ofNullable(device));
    }

    public WindowsHelloForBusinessAuthenticationMethod withDevice(Device device) {
        WindowsHelloForBusinessAuthenticationMethod _x = _copy();
        _x.changedFields = changedFields.add("device");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsHelloForBusinessAuthenticationMethod");
        _x.device = device;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsHelloForBusinessAuthenticationMethod patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsHelloForBusinessAuthenticationMethod _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsHelloForBusinessAuthenticationMethod put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsHelloForBusinessAuthenticationMethod _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsHelloForBusinessAuthenticationMethod _copy() {
        WindowsHelloForBusinessAuthenticationMethod _x = new WindowsHelloForBusinessAuthenticationMethod();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.displayName = displayName;
        _x.keyStrength = keyStrength;
        _x.device = device;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsHelloForBusinessAuthenticationMethod[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("keyStrength=");
        b.append(this.keyStrength);
        b.append(", ");
        b.append("device=");
        b.append(this.device);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
