package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeliveryOptimizationBandwidth;
import odata.msgraph.client.beta.complex.DeliveryOptimizationGroupIdSource;
import odata.msgraph.client.beta.complex.DeliveryOptimizationMaxCacheSize;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.enums.DeliveryOptimizationRestrictPeerSelectionByOptions;
import odata.msgraph.client.beta.enums.Enablement;
import odata.msgraph.client.beta.enums.WindowsDeliveryOptimizationMode;


/**
 * <i>“Windows Delivery Optimization configuration”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "backgroundDownloadFromHttpDelayInSeconds", 
    "bandwidthMode", 
    "cacheServerBackgroundDownloadFallbackToHttpDelayInSeconds", 
    "cacheServerForegroundDownloadFallbackToHttpDelayInSeconds", 
    "cacheServerHostNames", 
    "deliveryOptimizationMode", 
    "foregroundDownloadFromHttpDelayInSeconds", 
    "groupIdSource", 
    "maximumCacheAgeInDays", 
    "maximumCacheSize", 
    "minimumBatteryPercentageAllowedToUpload", 
    "minimumDiskSizeAllowedToPeerInGigabytes", 
    "minimumFileSizeToCacheInMegabytes", 
    "minimumRamAllowedToPeerInGigabytes", 
    "modifyCacheLocation", 
    "restrictPeerSelectionBy", 
    "vpnPeerCaching"})
@JsonInclude(Include.NON_NULL)
public class WindowsDeliveryOptimizationConfiguration extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsDeliveryOptimizationConfiguration";
    }

    @JsonProperty("backgroundDownloadFromHttpDelayInSeconds")
    protected Long backgroundDownloadFromHttpDelayInSeconds;

    @JsonProperty("bandwidthMode")
    protected DeliveryOptimizationBandwidth bandwidthMode;

    @JsonProperty("cacheServerBackgroundDownloadFallbackToHttpDelayInSeconds")
    protected Integer cacheServerBackgroundDownloadFallbackToHttpDelayInSeconds;

    @JsonProperty("cacheServerForegroundDownloadFallbackToHttpDelayInSeconds")
    protected Integer cacheServerForegroundDownloadFallbackToHttpDelayInSeconds;

    @JsonProperty("cacheServerHostNames")
    protected List<String> cacheServerHostNames;

    @JsonProperty("cacheServerHostNames@nextLink")
    protected String cacheServerHostNamesNextLink;

    @JsonProperty("deliveryOptimizationMode")
    protected WindowsDeliveryOptimizationMode deliveryOptimizationMode;

    @JsonProperty("foregroundDownloadFromHttpDelayInSeconds")
    protected Long foregroundDownloadFromHttpDelayInSeconds;

    @JsonProperty("groupIdSource")
    protected DeliveryOptimizationGroupIdSource groupIdSource;

    @JsonProperty("maximumCacheAgeInDays")
    protected Integer maximumCacheAgeInDays;

    @JsonProperty("maximumCacheSize")
    protected DeliveryOptimizationMaxCacheSize maximumCacheSize;

    @JsonProperty("minimumBatteryPercentageAllowedToUpload")
    protected Integer minimumBatteryPercentageAllowedToUpload;

    @JsonProperty("minimumDiskSizeAllowedToPeerInGigabytes")
    protected Integer minimumDiskSizeAllowedToPeerInGigabytes;

    @JsonProperty("minimumFileSizeToCacheInMegabytes")
    protected Integer minimumFileSizeToCacheInMegabytes;

    @JsonProperty("minimumRamAllowedToPeerInGigabytes")
    protected Integer minimumRamAllowedToPeerInGigabytes;

    @JsonProperty("modifyCacheLocation")
    protected String modifyCacheLocation;

    @JsonProperty("restrictPeerSelectionBy")
    protected DeliveryOptimizationRestrictPeerSelectionByOptions restrictPeerSelectionBy;

    @JsonProperty("vpnPeerCaching")
    protected Enablement vpnPeerCaching;

    protected WindowsDeliveryOptimizationConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsDeliveryOptimizationConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private Integer version;
        private List<DeviceConfigurationAssignment> assignments;
        private List<SettingStateDeviceSummary> deviceSettingStateSummaries;
        private List<DeviceConfigurationDeviceStatus> deviceStatuses;
        private DeviceConfigurationDeviceOverview deviceStatusOverview;
        private List<DeviceConfigurationGroupAssignment> groupAssignments;
        private List<DeviceConfigurationUserStatus> userStatuses;
        private DeviceConfigurationUserOverview userStatusOverview;
        private Long backgroundDownloadFromHttpDelayInSeconds;
        private DeliveryOptimizationBandwidth bandwidthMode;
        private Integer cacheServerBackgroundDownloadFallbackToHttpDelayInSeconds;
        private Integer cacheServerForegroundDownloadFallbackToHttpDelayInSeconds;
        private List<String> cacheServerHostNames;
        private String cacheServerHostNamesNextLink;
        private WindowsDeliveryOptimizationMode deliveryOptimizationMode;
        private Long foregroundDownloadFromHttpDelayInSeconds;
        private DeliveryOptimizationGroupIdSource groupIdSource;
        private Integer maximumCacheAgeInDays;
        private DeliveryOptimizationMaxCacheSize maximumCacheSize;
        private Integer minimumBatteryPercentageAllowedToUpload;
        private Integer minimumDiskSizeAllowedToPeerInGigabytes;
        private Integer minimumFileSizeToCacheInMegabytes;
        private Integer minimumRamAllowedToPeerInGigabytes;
        private String modifyCacheLocation;
        private DeliveryOptimizationRestrictPeerSelectionByOptions restrictPeerSelectionBy;
        private Enablement vpnPeerCaching;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder assignments(List<DeviceConfigurationAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(DeviceConfigurationAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder deviceSettingStateSummaries(List<SettingStateDeviceSummary> deviceSettingStateSummaries) {
            this.deviceSettingStateSummaries = deviceSettingStateSummaries;
            this.changedFields = changedFields.add("deviceSettingStateSummaries");
            return this;
        }

        public Builder deviceSettingStateSummaries(SettingStateDeviceSummary... deviceSettingStateSummaries) {
            return deviceSettingStateSummaries(Arrays.asList(deviceSettingStateSummaries));
        }

        public Builder deviceStatuses(List<DeviceConfigurationDeviceStatus> deviceStatuses) {
            this.deviceStatuses = deviceStatuses;
            this.changedFields = changedFields.add("deviceStatuses");
            return this;
        }

        public Builder deviceStatuses(DeviceConfigurationDeviceStatus... deviceStatuses) {
            return deviceStatuses(Arrays.asList(deviceStatuses));
        }

        public Builder deviceStatusOverview(DeviceConfigurationDeviceOverview deviceStatusOverview) {
            this.deviceStatusOverview = deviceStatusOverview;
            this.changedFields = changedFields.add("deviceStatusOverview");
            return this;
        }

        public Builder groupAssignments(List<DeviceConfigurationGroupAssignment> groupAssignments) {
            this.groupAssignments = groupAssignments;
            this.changedFields = changedFields.add("groupAssignments");
            return this;
        }

        public Builder groupAssignments(DeviceConfigurationGroupAssignment... groupAssignments) {
            return groupAssignments(Arrays.asList(groupAssignments));
        }

        public Builder userStatuses(List<DeviceConfigurationUserStatus> userStatuses) {
            this.userStatuses = userStatuses;
            this.changedFields = changedFields.add("userStatuses");
            return this;
        }

        public Builder userStatuses(DeviceConfigurationUserStatus... userStatuses) {
            return userStatuses(Arrays.asList(userStatuses));
        }

        public Builder userStatusOverview(DeviceConfigurationUserOverview userStatusOverview) {
            this.userStatusOverview = userStatusOverview;
            this.changedFields = changedFields.add("userStatusOverview");
            return this;
        }

        /**
         * <i>“Specifies number of seconds to delay an HTTP source in a background download
         * that is allowed to use peer-to-peer. Valid values 0 to 4294967295”</i>
         * 
         * @param backgroundDownloadFromHttpDelayInSeconds
         *            value of {@code backgroundDownloadFromHttpDelayInSeconds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder backgroundDownloadFromHttpDelayInSeconds(Long backgroundDownloadFromHttpDelayInSeconds) {
            this.backgroundDownloadFromHttpDelayInSeconds = backgroundDownloadFromHttpDelayInSeconds;
            this.changedFields = changedFields.add("backgroundDownloadFromHttpDelayInSeconds");
            return this;
        }

        /**
         * <i>“Specifies foreground and background bandwidth usage using percentages, absolutes
         * , or hours.”</i>
         * 
         * @param bandwidthMode
         *            value of {@code bandwidthMode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bandwidthMode(DeliveryOptimizationBandwidth bandwidthMode) {
            this.bandwidthMode = bandwidthMode;
            this.changedFields = changedFields.add("bandwidthMode");
            return this;
        }

        /**
         * <i>“Specifies number of seconds to delay a fall back from cache servers to an HTTP
         * source for a background download. Valid values 0 to 2592000.”</i>
         * 
         * @param cacheServerBackgroundDownloadFallbackToHttpDelayInSeconds
         *            value of {@code cacheServerBackgroundDownloadFallbackToHttpDelayInSeconds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cacheServerBackgroundDownloadFallbackToHttpDelayInSeconds(Integer cacheServerBackgroundDownloadFallbackToHttpDelayInSeconds) {
            this.cacheServerBackgroundDownloadFallbackToHttpDelayInSeconds = cacheServerBackgroundDownloadFallbackToHttpDelayInSeconds;
            this.changedFields = changedFields.add("cacheServerBackgroundDownloadFallbackToHttpDelayInSeconds");
            return this;
        }

        /**
         * <i>“Specifies number of seconds to delay a fall back from cache servers to an HTTP
         * source for a foreground download. Valid values 0 to 2592000.​”</i>
         * 
         * @param cacheServerForegroundDownloadFallbackToHttpDelayInSeconds
         *            value of {@code cacheServerForegroundDownloadFallbackToHttpDelayInSeconds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cacheServerForegroundDownloadFallbackToHttpDelayInSeconds(Integer cacheServerForegroundDownloadFallbackToHttpDelayInSeconds) {
            this.cacheServerForegroundDownloadFallbackToHttpDelayInSeconds = cacheServerForegroundDownloadFallbackToHttpDelayInSeconds;
            this.changedFields = changedFields.add("cacheServerForegroundDownloadFallbackToHttpDelayInSeconds");
            return this;
        }

        /**
         * <i>“Specifies cache servers host names.”</i>
         * 
         * @param cacheServerHostNames
         *            value of {@code cacheServerHostNames} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cacheServerHostNames(List<String> cacheServerHostNames) {
            this.cacheServerHostNames = cacheServerHostNames;
            this.changedFields = changedFields.add("cacheServerHostNames");
            return this;
        }

        /**
         * <i>“Specifies cache servers host names.”</i>
         * 
         * @param cacheServerHostNames
         *            value of {@code cacheServerHostNames} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cacheServerHostNames(String... cacheServerHostNames) {
            return cacheServerHostNames(Arrays.asList(cacheServerHostNames));
        }

        /**
         * <i>“Specifies cache servers host names.”</i>
         * 
         * @param cacheServerHostNamesNextLink
         *            value of {@code cacheServerHostNames@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cacheServerHostNamesNextLink(String cacheServerHostNamesNextLink) {
            this.cacheServerHostNamesNextLink = cacheServerHostNamesNextLink;
            this.changedFields = changedFields.add("cacheServerHostNames");
            return this;
        }

        /**
         * <i>“Specifies the download method that delivery optimization can use to manage
         * network bandwidth consumption for large content distribution scenarios.”</i>
         * 
         * @param deliveryOptimizationMode
         *            value of {@code deliveryOptimizationMode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deliveryOptimizationMode(WindowsDeliveryOptimizationMode deliveryOptimizationMode) {
            this.deliveryOptimizationMode = deliveryOptimizationMode;
            this.changedFields = changedFields.add("deliveryOptimizationMode");
            return this;
        }

        /**
         * <i>“Specifying 0 sets Delivery Optimization to manage this setting using the cloud
         * service. Valid values 0 to 86400”</i>
         * 
         * @param foregroundDownloadFromHttpDelayInSeconds
         *            value of {@code foregroundDownloadFromHttpDelayInSeconds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder foregroundDownloadFromHttpDelayInSeconds(Long foregroundDownloadFromHttpDelayInSeconds) {
            this.foregroundDownloadFromHttpDelayInSeconds = foregroundDownloadFromHttpDelayInSeconds;
            this.changedFields = changedFields.add("foregroundDownloadFromHttpDelayInSeconds");
            return this;
        }

        /**
         * <i>“The options set in this policy only apply to Delivery Optimization mode Group (2
         * ) download mode. If Group (2) isn't set as Download mode, this policy will be
         * ignored. For option 3 - DHCP Option ID, the client will query DHCP Option ID 234
         * and use the returned GUID value as the Group ID.”</i>
         * 
         * @param groupIdSource
         *            value of {@code groupIdSource} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupIdSource(DeliveryOptimizationGroupIdSource groupIdSource) {
            this.groupIdSource = groupIdSource;
            this.changedFields = changedFields.add("groupIdSource");
            return this;
        }

        /**
         * <i>“Specifies the maximum time in days that each file is held in the Delivery
         * Optimization cache after downloading successfully (0-3650). Valid values 0 to
         * 3650”</i>
         * 
         * @param maximumCacheAgeInDays
         *            value of {@code maximumCacheAgeInDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder maximumCacheAgeInDays(Integer maximumCacheAgeInDays) {
            this.maximumCacheAgeInDays = maximumCacheAgeInDays;
            this.changedFields = changedFields.add("maximumCacheAgeInDays");
            return this;
        }

        /**
         * <i>“Specifies the maximum cache size that Delivery Optimization either as a
         * percentage or in GB.”</i>
         * 
         * @param maximumCacheSize
         *            value of {@code maximumCacheSize} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder maximumCacheSize(DeliveryOptimizationMaxCacheSize maximumCacheSize) {
            this.maximumCacheSize = maximumCacheSize;
            this.changedFields = changedFields.add("maximumCacheSize");
            return this;
        }

        /**
         * <i>“The default value is 0. The value 0 (zero) means "not limited" and the cloud
         * service default value will be used. Valid values 0 to 100”</i>
         * 
         * @param minimumBatteryPercentageAllowedToUpload
         *            value of {@code minimumBatteryPercentageAllowedToUpload} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumBatteryPercentageAllowedToUpload(Integer minimumBatteryPercentageAllowedToUpload) {
            this.minimumBatteryPercentageAllowedToUpload = minimumBatteryPercentageAllowedToUpload;
            this.changedFields = changedFields.add("minimumBatteryPercentageAllowedToUpload");
            return this;
        }

        /**
         * <i>“Recommended values: 64 GB to 256 GB. Valid values 1 to 100000”</i>
         * 
         * @param minimumDiskSizeAllowedToPeerInGigabytes
         *            value of {@code minimumDiskSizeAllowedToPeerInGigabytes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumDiskSizeAllowedToPeerInGigabytes(Integer minimumDiskSizeAllowedToPeerInGigabytes) {
            this.minimumDiskSizeAllowedToPeerInGigabytes = minimumDiskSizeAllowedToPeerInGigabytes;
            this.changedFields = changedFields.add("minimumDiskSizeAllowedToPeerInGigabytes");
            return this;
        }

        /**
         * <i>“Recommended values: 1 MB to 100,000 MB. Valid values 1 to 100000”</i>
         * 
         * @param minimumFileSizeToCacheInMegabytes
         *            value of {@code minimumFileSizeToCacheInMegabytes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumFileSizeToCacheInMegabytes(Integer minimumFileSizeToCacheInMegabytes) {
            this.minimumFileSizeToCacheInMegabytes = minimumFileSizeToCacheInMegabytes;
            this.changedFields = changedFields.add("minimumFileSizeToCacheInMegabytes");
            return this;
        }

        /**
         * <i>“Specifies the minimum RAM size in GB to use Peer Caching (1-100000). Valid
         * values 1 to 100000”</i>
         * 
         * @param minimumRamAllowedToPeerInGigabytes
         *            value of {@code minimumRamAllowedToPeerInGigabytes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumRamAllowedToPeerInGigabytes(Integer minimumRamAllowedToPeerInGigabytes) {
            this.minimumRamAllowedToPeerInGigabytes = minimumRamAllowedToPeerInGigabytes;
            this.changedFields = changedFields.add("minimumRamAllowedToPeerInGigabytes");
            return this;
        }

        /**
         * <i>“Specifies the drive that Delivery Optimization should use for its cache.”</i>
         * 
         * @param modifyCacheLocation
         *            value of {@code modifyCacheLocation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder modifyCacheLocation(String modifyCacheLocation) {
            this.modifyCacheLocation = modifyCacheLocation;
            this.changedFields = changedFields.add("modifyCacheLocation");
            return this;
        }

        /**
         * <i>“Option 1 (Subnet mask) only applies to Delivery Optimization modes Download Mode
         * LAN (1) and Group (2).”</i>
         * 
         * @param restrictPeerSelectionBy
         *            value of {@code restrictPeerSelectionBy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder restrictPeerSelectionBy(DeliveryOptimizationRestrictPeerSelectionByOptions restrictPeerSelectionBy) {
            this.restrictPeerSelectionBy = restrictPeerSelectionBy;
            this.changedFields = changedFields.add("restrictPeerSelectionBy");
            return this;
        }

        /**
         * <i>“Specifies whether the device is allowed to participate in Peer Caching while
         * connected via VPN to the domain network.”</i>
         * 
         * @param vpnPeerCaching
         *            value of {@code vpnPeerCaching} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder vpnPeerCaching(Enablement vpnPeerCaching) {
            this.vpnPeerCaching = vpnPeerCaching;
            this.changedFields = changedFields.add("vpnPeerCaching");
            return this;
        }

        public WindowsDeliveryOptimizationConfiguration build() {
            WindowsDeliveryOptimizationConfiguration _x = new WindowsDeliveryOptimizationConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsDeliveryOptimizationConfiguration";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.version = version;
            _x.assignments = assignments;
            _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
            _x.deviceStatuses = deviceStatuses;
            _x.deviceStatusOverview = deviceStatusOverview;
            _x.groupAssignments = groupAssignments;
            _x.userStatuses = userStatuses;
            _x.userStatusOverview = userStatusOverview;
            _x.backgroundDownloadFromHttpDelayInSeconds = backgroundDownloadFromHttpDelayInSeconds;
            _x.bandwidthMode = bandwidthMode;
            _x.cacheServerBackgroundDownloadFallbackToHttpDelayInSeconds = cacheServerBackgroundDownloadFallbackToHttpDelayInSeconds;
            _x.cacheServerForegroundDownloadFallbackToHttpDelayInSeconds = cacheServerForegroundDownloadFallbackToHttpDelayInSeconds;
            _x.cacheServerHostNames = cacheServerHostNames;
            _x.cacheServerHostNamesNextLink = cacheServerHostNamesNextLink;
            _x.deliveryOptimizationMode = deliveryOptimizationMode;
            _x.foregroundDownloadFromHttpDelayInSeconds = foregroundDownloadFromHttpDelayInSeconds;
            _x.groupIdSource = groupIdSource;
            _x.maximumCacheAgeInDays = maximumCacheAgeInDays;
            _x.maximumCacheSize = maximumCacheSize;
            _x.minimumBatteryPercentageAllowedToUpload = minimumBatteryPercentageAllowedToUpload;
            _x.minimumDiskSizeAllowedToPeerInGigabytes = minimumDiskSizeAllowedToPeerInGigabytes;
            _x.minimumFileSizeToCacheInMegabytes = minimumFileSizeToCacheInMegabytes;
            _x.minimumRamAllowedToPeerInGigabytes = minimumRamAllowedToPeerInGigabytes;
            _x.modifyCacheLocation = modifyCacheLocation;
            _x.restrictPeerSelectionBy = restrictPeerSelectionBy;
            _x.vpnPeerCaching = vpnPeerCaching;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Specifies number of seconds to delay an HTTP source in a background download
     * that is allowed to use peer-to-peer. Valid values 0 to 4294967295”</i>
     * 
     * @return property backgroundDownloadFromHttpDelayInSeconds
     */
    @Property(name="backgroundDownloadFromHttpDelayInSeconds")
    @JsonIgnore
    public Optional<Long> getBackgroundDownloadFromHttpDelayInSeconds() {
        return Optional.ofNullable(backgroundDownloadFromHttpDelayInSeconds);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * backgroundDownloadFromHttpDelayInSeconds} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Specifies number of seconds to delay an HTTP source in a background download
     * that is allowed to use peer-to-peer. Valid values 0 to 4294967295”</i>
     * 
     * @param backgroundDownloadFromHttpDelayInSeconds
     *            new value of {@code backgroundDownloadFromHttpDelayInSeconds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code backgroundDownloadFromHttpDelayInSeconds} field changed
     */
    public WindowsDeliveryOptimizationConfiguration withBackgroundDownloadFromHttpDelayInSeconds(Long backgroundDownloadFromHttpDelayInSeconds) {
        WindowsDeliveryOptimizationConfiguration _x = _copy();
        _x.changedFields = changedFields.add("backgroundDownloadFromHttpDelayInSeconds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDeliveryOptimizationConfiguration");
        _x.backgroundDownloadFromHttpDelayInSeconds = backgroundDownloadFromHttpDelayInSeconds;
        return _x;
    }

    /**
     * <i>“Specifies foreground and background bandwidth usage using percentages, absolutes
     * , or hours.”</i>
     * 
     * @return property bandwidthMode
     */
    @Property(name="bandwidthMode")
    @JsonIgnore
    public Optional<DeliveryOptimizationBandwidth> getBandwidthMode() {
        return Optional.ofNullable(bandwidthMode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code bandwidthMode}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Specifies foreground and background bandwidth usage using percentages, absolutes
     * , or hours.”</i>
     * 
     * @param bandwidthMode
     *            new value of {@code bandwidthMode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bandwidthMode} field changed
     */
    public WindowsDeliveryOptimizationConfiguration withBandwidthMode(DeliveryOptimizationBandwidth bandwidthMode) {
        WindowsDeliveryOptimizationConfiguration _x = _copy();
        _x.changedFields = changedFields.add("bandwidthMode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDeliveryOptimizationConfiguration");
        _x.bandwidthMode = bandwidthMode;
        return _x;
    }

    /**
     * <i>“Specifies number of seconds to delay a fall back from cache servers to an HTTP
     * source for a background download. Valid values 0 to 2592000.”</i>
     * 
     * @return property cacheServerBackgroundDownloadFallbackToHttpDelayInSeconds
     */
    @Property(name="cacheServerBackgroundDownloadFallbackToHttpDelayInSeconds")
    @JsonIgnore
    public Optional<Integer> getCacheServerBackgroundDownloadFallbackToHttpDelayInSeconds() {
        return Optional.ofNullable(cacheServerBackgroundDownloadFallbackToHttpDelayInSeconds);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cacheServerBackgroundDownloadFallbackToHttpDelayInSeconds} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Specifies number of seconds to delay a fall back from cache servers to an HTTP
     * source for a background download. Valid values 0 to 2592000.”</i>
     * 
     * @param cacheServerBackgroundDownloadFallbackToHttpDelayInSeconds
     *            new value of {@code cacheServerBackgroundDownloadFallbackToHttpDelayInSeconds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cacheServerBackgroundDownloadFallbackToHttpDelayInSeconds} field changed
     */
    public WindowsDeliveryOptimizationConfiguration withCacheServerBackgroundDownloadFallbackToHttpDelayInSeconds(Integer cacheServerBackgroundDownloadFallbackToHttpDelayInSeconds) {
        WindowsDeliveryOptimizationConfiguration _x = _copy();
        _x.changedFields = changedFields.add("cacheServerBackgroundDownloadFallbackToHttpDelayInSeconds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDeliveryOptimizationConfiguration");
        _x.cacheServerBackgroundDownloadFallbackToHttpDelayInSeconds = cacheServerBackgroundDownloadFallbackToHttpDelayInSeconds;
        return _x;
    }

    /**
     * <i>“Specifies number of seconds to delay a fall back from cache servers to an HTTP
     * source for a foreground download. Valid values 0 to 2592000.​”</i>
     * 
     * @return property cacheServerForegroundDownloadFallbackToHttpDelayInSeconds
     */
    @Property(name="cacheServerForegroundDownloadFallbackToHttpDelayInSeconds")
    @JsonIgnore
    public Optional<Integer> getCacheServerForegroundDownloadFallbackToHttpDelayInSeconds() {
        return Optional.ofNullable(cacheServerForegroundDownloadFallbackToHttpDelayInSeconds);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cacheServerForegroundDownloadFallbackToHttpDelayInSeconds} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Specifies number of seconds to delay a fall back from cache servers to an HTTP
     * source for a foreground download. Valid values 0 to 2592000.​”</i>
     * 
     * @param cacheServerForegroundDownloadFallbackToHttpDelayInSeconds
     *            new value of {@code cacheServerForegroundDownloadFallbackToHttpDelayInSeconds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cacheServerForegroundDownloadFallbackToHttpDelayInSeconds} field changed
     */
    public WindowsDeliveryOptimizationConfiguration withCacheServerForegroundDownloadFallbackToHttpDelayInSeconds(Integer cacheServerForegroundDownloadFallbackToHttpDelayInSeconds) {
        WindowsDeliveryOptimizationConfiguration _x = _copy();
        _x.changedFields = changedFields.add("cacheServerForegroundDownloadFallbackToHttpDelayInSeconds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDeliveryOptimizationConfiguration");
        _x.cacheServerForegroundDownloadFallbackToHttpDelayInSeconds = cacheServerForegroundDownloadFallbackToHttpDelayInSeconds;
        return _x;
    }

    /**
     * <i>“Specifies cache servers host names.”</i>
     * 
     * @return property cacheServerHostNames
     */
    @Property(name="cacheServerHostNames")
    @JsonIgnore
    public CollectionPage<String> getCacheServerHostNames() {
        return new CollectionPage<String>(contextPath, String.class, this.cacheServerHostNames, Optional.ofNullable(cacheServerHostNamesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cacheServerHostNames} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Specifies cache servers host names.”</i>
     * 
     * @param cacheServerHostNames
     *            new value of {@code cacheServerHostNames} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cacheServerHostNames} field changed
     */
    public WindowsDeliveryOptimizationConfiguration withCacheServerHostNames(List<String> cacheServerHostNames) {
        WindowsDeliveryOptimizationConfiguration _x = _copy();
        _x.changedFields = changedFields.add("cacheServerHostNames");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDeliveryOptimizationConfiguration");
        _x.cacheServerHostNames = cacheServerHostNames;
        return _x;
    }

    /**
     * <i>“Specifies cache servers host names.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property cacheServerHostNames
     */
    @Property(name="cacheServerHostNames")
    @JsonIgnore
    public CollectionPage<String> getCacheServerHostNames(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.cacheServerHostNames, Optional.ofNullable(cacheServerHostNamesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Specifies the download method that delivery optimization can use to manage
     * network bandwidth consumption for large content distribution scenarios.”</i>
     * 
     * @return property deliveryOptimizationMode
     */
    @Property(name="deliveryOptimizationMode")
    @JsonIgnore
    public Optional<WindowsDeliveryOptimizationMode> getDeliveryOptimizationMode() {
        return Optional.ofNullable(deliveryOptimizationMode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deliveryOptimizationMode} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Specifies the download method that delivery optimization can use to manage
     * network bandwidth consumption for large content distribution scenarios.”</i>
     * 
     * @param deliveryOptimizationMode
     *            new value of {@code deliveryOptimizationMode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deliveryOptimizationMode} field changed
     */
    public WindowsDeliveryOptimizationConfiguration withDeliveryOptimizationMode(WindowsDeliveryOptimizationMode deliveryOptimizationMode) {
        WindowsDeliveryOptimizationConfiguration _x = _copy();
        _x.changedFields = changedFields.add("deliveryOptimizationMode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDeliveryOptimizationConfiguration");
        _x.deliveryOptimizationMode = deliveryOptimizationMode;
        return _x;
    }

    /**
     * <i>“Specifying 0 sets Delivery Optimization to manage this setting using the cloud
     * service. Valid values 0 to 86400”</i>
     * 
     * @return property foregroundDownloadFromHttpDelayInSeconds
     */
    @Property(name="foregroundDownloadFromHttpDelayInSeconds")
    @JsonIgnore
    public Optional<Long> getForegroundDownloadFromHttpDelayInSeconds() {
        return Optional.ofNullable(foregroundDownloadFromHttpDelayInSeconds);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * foregroundDownloadFromHttpDelayInSeconds} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Specifying 0 sets Delivery Optimization to manage this setting using the cloud
     * service. Valid values 0 to 86400”</i>
     * 
     * @param foregroundDownloadFromHttpDelayInSeconds
     *            new value of {@code foregroundDownloadFromHttpDelayInSeconds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code foregroundDownloadFromHttpDelayInSeconds} field changed
     */
    public WindowsDeliveryOptimizationConfiguration withForegroundDownloadFromHttpDelayInSeconds(Long foregroundDownloadFromHttpDelayInSeconds) {
        WindowsDeliveryOptimizationConfiguration _x = _copy();
        _x.changedFields = changedFields.add("foregroundDownloadFromHttpDelayInSeconds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDeliveryOptimizationConfiguration");
        _x.foregroundDownloadFromHttpDelayInSeconds = foregroundDownloadFromHttpDelayInSeconds;
        return _x;
    }

    /**
     * <i>“The options set in this policy only apply to Delivery Optimization mode Group (2
     * ) download mode. If Group (2) isn't set as Download mode, this policy will be
     * ignored. For option 3 - DHCP Option ID, the client will query DHCP Option ID 234
     * and use the returned GUID value as the Group ID.”</i>
     * 
     * @return property groupIdSource
     */
    @Property(name="groupIdSource")
    @JsonIgnore
    public Optional<DeliveryOptimizationGroupIdSource> getGroupIdSource() {
        return Optional.ofNullable(groupIdSource);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code groupIdSource}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The options set in this policy only apply to Delivery Optimization mode Group (2
     * ) download mode. If Group (2) isn't set as Download mode, this policy will be
     * ignored. For option 3 - DHCP Option ID, the client will query DHCP Option ID 234
     * and use the returned GUID value as the Group ID.”</i>
     * 
     * @param groupIdSource
     *            new value of {@code groupIdSource} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code groupIdSource} field changed
     */
    public WindowsDeliveryOptimizationConfiguration withGroupIdSource(DeliveryOptimizationGroupIdSource groupIdSource) {
        WindowsDeliveryOptimizationConfiguration _x = _copy();
        _x.changedFields = changedFields.add("groupIdSource");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDeliveryOptimizationConfiguration");
        _x.groupIdSource = groupIdSource;
        return _x;
    }

    /**
     * <i>“Specifies the maximum time in days that each file is held in the Delivery
     * Optimization cache after downloading successfully (0-3650). Valid values 0 to
     * 3650”</i>
     * 
     * @return property maximumCacheAgeInDays
     */
    @Property(name="maximumCacheAgeInDays")
    @JsonIgnore
    public Optional<Integer> getMaximumCacheAgeInDays() {
        return Optional.ofNullable(maximumCacheAgeInDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * maximumCacheAgeInDays} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Specifies the maximum time in days that each file is held in the Delivery
     * Optimization cache after downloading successfully (0-3650). Valid values 0 to
     * 3650”</i>
     * 
     * @param maximumCacheAgeInDays
     *            new value of {@code maximumCacheAgeInDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code maximumCacheAgeInDays} field changed
     */
    public WindowsDeliveryOptimizationConfiguration withMaximumCacheAgeInDays(Integer maximumCacheAgeInDays) {
        WindowsDeliveryOptimizationConfiguration _x = _copy();
        _x.changedFields = changedFields.add("maximumCacheAgeInDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDeliveryOptimizationConfiguration");
        _x.maximumCacheAgeInDays = maximumCacheAgeInDays;
        return _x;
    }

    /**
     * <i>“Specifies the maximum cache size that Delivery Optimization either as a
     * percentage or in GB.”</i>
     * 
     * @return property maximumCacheSize
     */
    @Property(name="maximumCacheSize")
    @JsonIgnore
    public Optional<DeliveryOptimizationMaxCacheSize> getMaximumCacheSize() {
        return Optional.ofNullable(maximumCacheSize);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code maximumCacheSize}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Specifies the maximum cache size that Delivery Optimization either as a
     * percentage or in GB.”</i>
     * 
     * @param maximumCacheSize
     *            new value of {@code maximumCacheSize} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code maximumCacheSize} field changed
     */
    public WindowsDeliveryOptimizationConfiguration withMaximumCacheSize(DeliveryOptimizationMaxCacheSize maximumCacheSize) {
        WindowsDeliveryOptimizationConfiguration _x = _copy();
        _x.changedFields = changedFields.add("maximumCacheSize");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDeliveryOptimizationConfiguration");
        _x.maximumCacheSize = maximumCacheSize;
        return _x;
    }

    /**
     * <i>“The default value is 0. The value 0 (zero) means "not limited" and the cloud
     * service default value will be used. Valid values 0 to 100”</i>
     * 
     * @return property minimumBatteryPercentageAllowedToUpload
     */
    @Property(name="minimumBatteryPercentageAllowedToUpload")
    @JsonIgnore
    public Optional<Integer> getMinimumBatteryPercentageAllowedToUpload() {
        return Optional.ofNullable(minimumBatteryPercentageAllowedToUpload);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumBatteryPercentageAllowedToUpload} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The default value is 0. The value 0 (zero) means "not limited" and the cloud
     * service default value will be used. Valid values 0 to 100”</i>
     * 
     * @param minimumBatteryPercentageAllowedToUpload
     *            new value of {@code minimumBatteryPercentageAllowedToUpload} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumBatteryPercentageAllowedToUpload} field changed
     */
    public WindowsDeliveryOptimizationConfiguration withMinimumBatteryPercentageAllowedToUpload(Integer minimumBatteryPercentageAllowedToUpload) {
        WindowsDeliveryOptimizationConfiguration _x = _copy();
        _x.changedFields = changedFields.add("minimumBatteryPercentageAllowedToUpload");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDeliveryOptimizationConfiguration");
        _x.minimumBatteryPercentageAllowedToUpload = minimumBatteryPercentageAllowedToUpload;
        return _x;
    }

    /**
     * <i>“Recommended values: 64 GB to 256 GB. Valid values 1 to 100000”</i>
     * 
     * @return property minimumDiskSizeAllowedToPeerInGigabytes
     */
    @Property(name="minimumDiskSizeAllowedToPeerInGigabytes")
    @JsonIgnore
    public Optional<Integer> getMinimumDiskSizeAllowedToPeerInGigabytes() {
        return Optional.ofNullable(minimumDiskSizeAllowedToPeerInGigabytes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumDiskSizeAllowedToPeerInGigabytes} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Recommended values: 64 GB to 256 GB. Valid values 1 to 100000”</i>
     * 
     * @param minimumDiskSizeAllowedToPeerInGigabytes
     *            new value of {@code minimumDiskSizeAllowedToPeerInGigabytes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumDiskSizeAllowedToPeerInGigabytes} field changed
     */
    public WindowsDeliveryOptimizationConfiguration withMinimumDiskSizeAllowedToPeerInGigabytes(Integer minimumDiskSizeAllowedToPeerInGigabytes) {
        WindowsDeliveryOptimizationConfiguration _x = _copy();
        _x.changedFields = changedFields.add("minimumDiskSizeAllowedToPeerInGigabytes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDeliveryOptimizationConfiguration");
        _x.minimumDiskSizeAllowedToPeerInGigabytes = minimumDiskSizeAllowedToPeerInGigabytes;
        return _x;
    }

    /**
     * <i>“Recommended values: 1 MB to 100,000 MB. Valid values 1 to 100000”</i>
     * 
     * @return property minimumFileSizeToCacheInMegabytes
     */
    @Property(name="minimumFileSizeToCacheInMegabytes")
    @JsonIgnore
    public Optional<Integer> getMinimumFileSizeToCacheInMegabytes() {
        return Optional.ofNullable(minimumFileSizeToCacheInMegabytes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumFileSizeToCacheInMegabytes} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Recommended values: 1 MB to 100,000 MB. Valid values 1 to 100000”</i>
     * 
     * @param minimumFileSizeToCacheInMegabytes
     *            new value of {@code minimumFileSizeToCacheInMegabytes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumFileSizeToCacheInMegabytes} field changed
     */
    public WindowsDeliveryOptimizationConfiguration withMinimumFileSizeToCacheInMegabytes(Integer minimumFileSizeToCacheInMegabytes) {
        WindowsDeliveryOptimizationConfiguration _x = _copy();
        _x.changedFields = changedFields.add("minimumFileSizeToCacheInMegabytes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDeliveryOptimizationConfiguration");
        _x.minimumFileSizeToCacheInMegabytes = minimumFileSizeToCacheInMegabytes;
        return _x;
    }

    /**
     * <i>“Specifies the minimum RAM size in GB to use Peer Caching (1-100000). Valid
     * values 1 to 100000”</i>
     * 
     * @return property minimumRamAllowedToPeerInGigabytes
     */
    @Property(name="minimumRamAllowedToPeerInGigabytes")
    @JsonIgnore
    public Optional<Integer> getMinimumRamAllowedToPeerInGigabytes() {
        return Optional.ofNullable(minimumRamAllowedToPeerInGigabytes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumRamAllowedToPeerInGigabytes} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Specifies the minimum RAM size in GB to use Peer Caching (1-100000). Valid
     * values 1 to 100000”</i>
     * 
     * @param minimumRamAllowedToPeerInGigabytes
     *            new value of {@code minimumRamAllowedToPeerInGigabytes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumRamAllowedToPeerInGigabytes} field changed
     */
    public WindowsDeliveryOptimizationConfiguration withMinimumRamAllowedToPeerInGigabytes(Integer minimumRamAllowedToPeerInGigabytes) {
        WindowsDeliveryOptimizationConfiguration _x = _copy();
        _x.changedFields = changedFields.add("minimumRamAllowedToPeerInGigabytes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDeliveryOptimizationConfiguration");
        _x.minimumRamAllowedToPeerInGigabytes = minimumRamAllowedToPeerInGigabytes;
        return _x;
    }

    /**
     * <i>“Specifies the drive that Delivery Optimization should use for its cache.”</i>
     * 
     * @return property modifyCacheLocation
     */
    @Property(name="modifyCacheLocation")
    @JsonIgnore
    public Optional<String> getModifyCacheLocation() {
        return Optional.ofNullable(modifyCacheLocation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * modifyCacheLocation} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Specifies the drive that Delivery Optimization should use for its cache.”</i>
     * 
     * @param modifyCacheLocation
     *            new value of {@code modifyCacheLocation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code modifyCacheLocation} field changed
     */
    public WindowsDeliveryOptimizationConfiguration withModifyCacheLocation(String modifyCacheLocation) {
        WindowsDeliveryOptimizationConfiguration _x = _copy();
        _x.changedFields = changedFields.add("modifyCacheLocation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDeliveryOptimizationConfiguration");
        _x.modifyCacheLocation = modifyCacheLocation;
        return _x;
    }

    /**
     * <i>“Option 1 (Subnet mask) only applies to Delivery Optimization modes Download Mode
     * LAN (1) and Group (2).”</i>
     * 
     * @return property restrictPeerSelectionBy
     */
    @Property(name="restrictPeerSelectionBy")
    @JsonIgnore
    public Optional<DeliveryOptimizationRestrictPeerSelectionByOptions> getRestrictPeerSelectionBy() {
        return Optional.ofNullable(restrictPeerSelectionBy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * restrictPeerSelectionBy} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Option 1 (Subnet mask) only applies to Delivery Optimization modes Download Mode
     * LAN (1) and Group (2).”</i>
     * 
     * @param restrictPeerSelectionBy
     *            new value of {@code restrictPeerSelectionBy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code restrictPeerSelectionBy} field changed
     */
    public WindowsDeliveryOptimizationConfiguration withRestrictPeerSelectionBy(DeliveryOptimizationRestrictPeerSelectionByOptions restrictPeerSelectionBy) {
        WindowsDeliveryOptimizationConfiguration _x = _copy();
        _x.changedFields = changedFields.add("restrictPeerSelectionBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDeliveryOptimizationConfiguration");
        _x.restrictPeerSelectionBy = restrictPeerSelectionBy;
        return _x;
    }

    /**
     * <i>“Specifies whether the device is allowed to participate in Peer Caching while
     * connected via VPN to the domain network.”</i>
     * 
     * @return property vpnPeerCaching
     */
    @Property(name="vpnPeerCaching")
    @JsonIgnore
    public Optional<Enablement> getVpnPeerCaching() {
        return Optional.ofNullable(vpnPeerCaching);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code vpnPeerCaching}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Specifies whether the device is allowed to participate in Peer Caching while
     * connected via VPN to the domain network.”</i>
     * 
     * @param vpnPeerCaching
     *            new value of {@code vpnPeerCaching} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code vpnPeerCaching} field changed
     */
    public WindowsDeliveryOptimizationConfiguration withVpnPeerCaching(Enablement vpnPeerCaching) {
        WindowsDeliveryOptimizationConfiguration _x = _copy();
        _x.changedFields = changedFields.add("vpnPeerCaching");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsDeliveryOptimizationConfiguration");
        _x.vpnPeerCaching = vpnPeerCaching;
        return _x;
    }

    public WindowsDeliveryOptimizationConfiguration withUnmappedField(String name, Object value) {
        WindowsDeliveryOptimizationConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsDeliveryOptimizationConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsDeliveryOptimizationConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsDeliveryOptimizationConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsDeliveryOptimizationConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsDeliveryOptimizationConfiguration _copy() {
        WindowsDeliveryOptimizationConfiguration _x = new WindowsDeliveryOptimizationConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.version = version;
        _x.assignments = assignments;
        _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
        _x.deviceStatuses = deviceStatuses;
        _x.deviceStatusOverview = deviceStatusOverview;
        _x.groupAssignments = groupAssignments;
        _x.userStatuses = userStatuses;
        _x.userStatusOverview = userStatusOverview;
        _x.backgroundDownloadFromHttpDelayInSeconds = backgroundDownloadFromHttpDelayInSeconds;
        _x.bandwidthMode = bandwidthMode;
        _x.cacheServerBackgroundDownloadFallbackToHttpDelayInSeconds = cacheServerBackgroundDownloadFallbackToHttpDelayInSeconds;
        _x.cacheServerForegroundDownloadFallbackToHttpDelayInSeconds = cacheServerForegroundDownloadFallbackToHttpDelayInSeconds;
        _x.cacheServerHostNames = cacheServerHostNames;
        _x.deliveryOptimizationMode = deliveryOptimizationMode;
        _x.foregroundDownloadFromHttpDelayInSeconds = foregroundDownloadFromHttpDelayInSeconds;
        _x.groupIdSource = groupIdSource;
        _x.maximumCacheAgeInDays = maximumCacheAgeInDays;
        _x.maximumCacheSize = maximumCacheSize;
        _x.minimumBatteryPercentageAllowedToUpload = minimumBatteryPercentageAllowedToUpload;
        _x.minimumDiskSizeAllowedToPeerInGigabytes = minimumDiskSizeAllowedToPeerInGigabytes;
        _x.minimumFileSizeToCacheInMegabytes = minimumFileSizeToCacheInMegabytes;
        _x.minimumRamAllowedToPeerInGigabytes = minimumRamAllowedToPeerInGigabytes;
        _x.modifyCacheLocation = modifyCacheLocation;
        _x.restrictPeerSelectionBy = restrictPeerSelectionBy;
        _x.vpnPeerCaching = vpnPeerCaching;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsDeliveryOptimizationConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceSettingStateSummaries=");
        b.append(this.deviceSettingStateSummaries);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("deviceStatusOverview=");
        b.append(this.deviceStatusOverview);
        b.append(", ");
        b.append("groupAssignments=");
        b.append(this.groupAssignments);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("userStatusOverview=");
        b.append(this.userStatusOverview);
        b.append(", ");
        b.append("backgroundDownloadFromHttpDelayInSeconds=");
        b.append(this.backgroundDownloadFromHttpDelayInSeconds);
        b.append(", ");
        b.append("bandwidthMode=");
        b.append(this.bandwidthMode);
        b.append(", ");
        b.append("cacheServerBackgroundDownloadFallbackToHttpDelayInSeconds=");
        b.append(this.cacheServerBackgroundDownloadFallbackToHttpDelayInSeconds);
        b.append(", ");
        b.append("cacheServerForegroundDownloadFallbackToHttpDelayInSeconds=");
        b.append(this.cacheServerForegroundDownloadFallbackToHttpDelayInSeconds);
        b.append(", ");
        b.append("cacheServerHostNames=");
        b.append(this.cacheServerHostNames);
        b.append(", ");
        b.append("deliveryOptimizationMode=");
        b.append(this.deliveryOptimizationMode);
        b.append(", ");
        b.append("foregroundDownloadFromHttpDelayInSeconds=");
        b.append(this.foregroundDownloadFromHttpDelayInSeconds);
        b.append(", ");
        b.append("groupIdSource=");
        b.append(this.groupIdSource);
        b.append(", ");
        b.append("maximumCacheAgeInDays=");
        b.append(this.maximumCacheAgeInDays);
        b.append(", ");
        b.append("maximumCacheSize=");
        b.append(this.maximumCacheSize);
        b.append(", ");
        b.append("minimumBatteryPercentageAllowedToUpload=");
        b.append(this.minimumBatteryPercentageAllowedToUpload);
        b.append(", ");
        b.append("minimumDiskSizeAllowedToPeerInGigabytes=");
        b.append(this.minimumDiskSizeAllowedToPeerInGigabytes);
        b.append(", ");
        b.append("minimumFileSizeToCacheInMegabytes=");
        b.append(this.minimumFileSizeToCacheInMegabytes);
        b.append(", ");
        b.append("minimumRamAllowedToPeerInGigabytes=");
        b.append(this.minimumRamAllowedToPeerInGigabytes);
        b.append(", ");
        b.append("modifyCacheLocation=");
        b.append(this.modifyCacheLocation);
        b.append(", ");
        b.append("restrictPeerSelectionBy=");
        b.append(this.restrictPeerSelectionBy);
        b.append(", ");
        b.append("vpnPeerCaching=");
        b.append(this.vpnPeerCaching);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
