package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.WindowsAutopilotDeploymentProfileRequest;
import odata.msgraph.client.beta.enums.EnrollmentState;
import odata.msgraph.client.beta.enums.WindowsAutopilotProfileAssignmentDetailedStatus;
import odata.msgraph.client.beta.enums.WindowsAutopilotProfileAssignmentStatus;


/**
 * <i>“The windowsAutopilotDeviceIdentity resource represents a Windows Autopilot
 * Device.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "addressableUserName", 
    "azureActiveDirectoryDeviceId", 
    "azureAdDeviceId", 
    "deploymentProfileAssignedDateTime", 
    "deploymentProfileAssignmentDetailedStatus", 
    "deploymentProfileAssignmentStatus", 
    "displayName", 
    "enrollmentState", 
    "groupTag", 
    "lastContactedDateTime", 
    "managedDeviceId", 
    "manufacturer", 
    "model", 
    "productKey", 
    "purchaseOrderIdentifier", 
    "resourceName", 
    "serialNumber", 
    "skuNumber", 
    "systemFamily", 
    "userPrincipalName"})
@JsonInclude(Include.NON_NULL)
public class WindowsAutopilotDeviceIdentity extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsAutopilotDeviceIdentity";
    }

    @JsonProperty("addressableUserName")
    protected String addressableUserName;

    @JsonProperty("azureActiveDirectoryDeviceId")
    protected String azureActiveDirectoryDeviceId;

    @JsonProperty("azureAdDeviceId")
    protected String azureAdDeviceId;

    @JsonProperty("deploymentProfileAssignedDateTime")
    protected OffsetDateTime deploymentProfileAssignedDateTime;

    @JsonProperty("deploymentProfileAssignmentDetailedStatus")
    protected WindowsAutopilotProfileAssignmentDetailedStatus deploymentProfileAssignmentDetailedStatus;

    @JsonProperty("deploymentProfileAssignmentStatus")
    protected WindowsAutopilotProfileAssignmentStatus deploymentProfileAssignmentStatus;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("enrollmentState")
    protected EnrollmentState enrollmentState;

    @JsonProperty("groupTag")
    protected String groupTag;

    @JsonProperty("lastContactedDateTime")
    protected OffsetDateTime lastContactedDateTime;

    @JsonProperty("managedDeviceId")
    protected String managedDeviceId;

    @JsonProperty("manufacturer")
    protected String manufacturer;

    @JsonProperty("model")
    protected String model;

    @JsonProperty("productKey")
    protected String productKey;

    @JsonProperty("purchaseOrderIdentifier")
    protected String purchaseOrderIdentifier;

    @JsonProperty("resourceName")
    protected String resourceName;

    @JsonProperty("serialNumber")
    protected String serialNumber;

    @JsonProperty("skuNumber")
    protected String skuNumber;

    @JsonProperty("systemFamily")
    protected String systemFamily;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    protected WindowsAutopilotDeviceIdentity() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsAutopilotDeviceIdentity() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String addressableUserName;
        private String azureActiveDirectoryDeviceId;
        private String azureAdDeviceId;
        private OffsetDateTime deploymentProfileAssignedDateTime;
        private WindowsAutopilotProfileAssignmentDetailedStatus deploymentProfileAssignmentDetailedStatus;
        private WindowsAutopilotProfileAssignmentStatus deploymentProfileAssignmentStatus;
        private String displayName;
        private EnrollmentState enrollmentState;
        private String groupTag;
        private OffsetDateTime lastContactedDateTime;
        private String managedDeviceId;
        private String manufacturer;
        private String model;
        private String productKey;
        private String purchaseOrderIdentifier;
        private String resourceName;
        private String serialNumber;
        private String skuNumber;
        private String systemFamily;
        private String userPrincipalName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Addressable user name.”</i>
         * 
         * @param addressableUserName
         *            value of {@code addressableUserName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder addressableUserName(String addressableUserName) {
            this.addressableUserName = addressableUserName;
            this.changedFields = changedFields.add("addressableUserName");
            return this;
        }

        /**
         * <i>“AAD Device ID - to be deprecated”</i>
         * 
         * @param azureActiveDirectoryDeviceId
         *            value of {@code azureActiveDirectoryDeviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder azureActiveDirectoryDeviceId(String azureActiveDirectoryDeviceId) {
            this.azureActiveDirectoryDeviceId = azureActiveDirectoryDeviceId;
            this.changedFields = changedFields.add("azureActiveDirectoryDeviceId");
            return this;
        }

        /**
         * <i>“AAD Device ID”</i>
         * 
         * @param azureAdDeviceId
         *            value of {@code azureAdDeviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder azureAdDeviceId(String azureAdDeviceId) {
            this.azureAdDeviceId = azureAdDeviceId;
            this.changedFields = changedFields.add("azureAdDeviceId");
            return this;
        }

        /**
         * <i>“Profile set time of the Windows autopilot device.”</i>
         * 
         * @param deploymentProfileAssignedDateTime
         *            value of {@code deploymentProfileAssignedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deploymentProfileAssignedDateTime(OffsetDateTime deploymentProfileAssignedDateTime) {
            this.deploymentProfileAssignedDateTime = deploymentProfileAssignedDateTime;
            this.changedFields = changedFields.add("deploymentProfileAssignedDateTime");
            return this;
        }

        /**
         * <i>“Profile assignment detailed status of the Windows autopilot device.”</i>
         * 
         * @param deploymentProfileAssignmentDetailedStatus
         *            value of {@code deploymentProfileAssignmentDetailedStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deploymentProfileAssignmentDetailedStatus(WindowsAutopilotProfileAssignmentDetailedStatus deploymentProfileAssignmentDetailedStatus) {
            this.deploymentProfileAssignmentDetailedStatus = deploymentProfileAssignmentDetailedStatus;
            this.changedFields = changedFields.add("deploymentProfileAssignmentDetailedStatus");
            return this;
        }

        /**
         * <i>“Profile assignment status of the Windows autopilot device.”</i>
         * 
         * @param deploymentProfileAssignmentStatus
         *            value of {@code deploymentProfileAssignmentStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deploymentProfileAssignmentStatus(WindowsAutopilotProfileAssignmentStatus deploymentProfileAssignmentStatus) {
            this.deploymentProfileAssignmentStatus = deploymentProfileAssignmentStatus;
            this.changedFields = changedFields.add("deploymentProfileAssignmentStatus");
            return this;
        }

        /**
         * <i>“Display Name”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Intune enrollment state of the Windows autopilot device.”</i>
         * 
         * @param enrollmentState
         *            value of {@code enrollmentState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enrollmentState(EnrollmentState enrollmentState) {
            this.enrollmentState = enrollmentState;
            this.changedFields = changedFields.add("enrollmentState");
            return this;
        }

        /**
         * <i>“Group Tag of the Windows autopilot device.”</i>
         * 
         * @param groupTag
         *            value of {@code groupTag} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupTag(String groupTag) {
            this.groupTag = groupTag;
            this.changedFields = changedFields.add("groupTag");
            return this;
        }

        /**
         * <i>“Intune Last Contacted Date Time of the Windows autopilot device.”</i>
         * 
         * @param lastContactedDateTime
         *            value of {@code lastContactedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastContactedDateTime(OffsetDateTime lastContactedDateTime) {
            this.lastContactedDateTime = lastContactedDateTime;
            this.changedFields = changedFields.add("lastContactedDateTime");
            return this;
        }

        /**
         * <i>“Managed Device ID”</i>
         * 
         * @param managedDeviceId
         *            value of {@code managedDeviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedDeviceId(String managedDeviceId) {
            this.managedDeviceId = managedDeviceId;
            this.changedFields = changedFields.add("managedDeviceId");
            return this;
        }

        /**
         * <i>“Oem manufacturer of the Windows autopilot device.”</i>
         * 
         * @param manufacturer
         *            value of {@code manufacturer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            this.changedFields = changedFields.add("manufacturer");
            return this;
        }

        /**
         * <i>“Model name of the Windows autopilot device.”</i>
         * 
         * @param model
         *            value of {@code model} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder model(String model) {
            this.model = model;
            this.changedFields = changedFields.add("model");
            return this;
        }

        /**
         * <i>“Product Key of the Windows autopilot device.”</i>
         * 
         * @param productKey
         *            value of {@code productKey} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder productKey(String productKey) {
            this.productKey = productKey;
            this.changedFields = changedFields.add("productKey");
            return this;
        }

        /**
         * <i>“Purchase Order Identifier of the Windows autopilot device.”</i>
         * 
         * @param purchaseOrderIdentifier
         *            value of {@code purchaseOrderIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder purchaseOrderIdentifier(String purchaseOrderIdentifier) {
            this.purchaseOrderIdentifier = purchaseOrderIdentifier;
            this.changedFields = changedFields.add("purchaseOrderIdentifier");
            return this;
        }

        /**
         * <i>“Resource Name.”</i>
         * 
         * @param resourceName
         *            value of {@code resourceName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            this.changedFields = changedFields.add("resourceName");
            return this;
        }

        /**
         * <i>“Serial number of the Windows autopilot device.”</i>
         * 
         * @param serialNumber
         *            value of {@code serialNumber} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            this.changedFields = changedFields.add("serialNumber");
            return this;
        }

        /**
         * <i>“SKU Number”</i>
         * 
         * @param skuNumber
         *            value of {@code skuNumber} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder skuNumber(String skuNumber) {
            this.skuNumber = skuNumber;
            this.changedFields = changedFields.add("skuNumber");
            return this;
        }

        /**
         * <i>“System Family”</i>
         * 
         * @param systemFamily
         *            value of {@code systemFamily} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder systemFamily(String systemFamily) {
            this.systemFamily = systemFamily;
            this.changedFields = changedFields.add("systemFamily");
            return this;
        }

        /**
         * <i>“User Principal Name.”</i>
         * 
         * @param userPrincipalName
         *            value of {@code userPrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public WindowsAutopilotDeviceIdentity build() {
            WindowsAutopilotDeviceIdentity _x = new WindowsAutopilotDeviceIdentity();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsAutopilotDeviceIdentity";
            _x.id = id;
            _x.addressableUserName = addressableUserName;
            _x.azureActiveDirectoryDeviceId = azureActiveDirectoryDeviceId;
            _x.azureAdDeviceId = azureAdDeviceId;
            _x.deploymentProfileAssignedDateTime = deploymentProfileAssignedDateTime;
            _x.deploymentProfileAssignmentDetailedStatus = deploymentProfileAssignmentDetailedStatus;
            _x.deploymentProfileAssignmentStatus = deploymentProfileAssignmentStatus;
            _x.displayName = displayName;
            _x.enrollmentState = enrollmentState;
            _x.groupTag = groupTag;
            _x.lastContactedDateTime = lastContactedDateTime;
            _x.managedDeviceId = managedDeviceId;
            _x.manufacturer = manufacturer;
            _x.model = model;
            _x.productKey = productKey;
            _x.purchaseOrderIdentifier = purchaseOrderIdentifier;
            _x.resourceName = resourceName;
            _x.serialNumber = serialNumber;
            _x.skuNumber = skuNumber;
            _x.systemFamily = systemFamily;
            _x.userPrincipalName = userPrincipalName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Addressable user name.”</i>
     * 
     * @return property addressableUserName
     */
    @Property(name="addressableUserName")
    @JsonIgnore
    public Optional<String> getAddressableUserName() {
        return Optional.ofNullable(addressableUserName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * addressableUserName} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Addressable user name.”</i>
     * 
     * @param addressableUserName
     *            new value of {@code addressableUserName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code addressableUserName} field changed
     */
    public WindowsAutopilotDeviceIdentity withAddressableUserName(String addressableUserName) {
        WindowsAutopilotDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("addressableUserName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeviceIdentity");
        _x.addressableUserName = addressableUserName;
        return _x;
    }

    /**
     * <i>“AAD Device ID - to be deprecated”</i>
     * 
     * @return property azureActiveDirectoryDeviceId
     */
    @Property(name="azureActiveDirectoryDeviceId")
    @JsonIgnore
    public Optional<String> getAzureActiveDirectoryDeviceId() {
        return Optional.ofNullable(azureActiveDirectoryDeviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * azureActiveDirectoryDeviceId} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“AAD Device ID - to be deprecated”</i>
     * 
     * @param azureActiveDirectoryDeviceId
     *            new value of {@code azureActiveDirectoryDeviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code azureActiveDirectoryDeviceId} field changed
     */
    public WindowsAutopilotDeviceIdentity withAzureActiveDirectoryDeviceId(String azureActiveDirectoryDeviceId) {
        WindowsAutopilotDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("azureActiveDirectoryDeviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeviceIdentity");
        _x.azureActiveDirectoryDeviceId = azureActiveDirectoryDeviceId;
        return _x;
    }

    /**
     * <i>“AAD Device ID”</i>
     * 
     * @return property azureAdDeviceId
     */
    @Property(name="azureAdDeviceId")
    @JsonIgnore
    public Optional<String> getAzureAdDeviceId() {
        return Optional.ofNullable(azureAdDeviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code azureAdDeviceId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“AAD Device ID”</i>
     * 
     * @param azureAdDeviceId
     *            new value of {@code azureAdDeviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code azureAdDeviceId} field changed
     */
    public WindowsAutopilotDeviceIdentity withAzureAdDeviceId(String azureAdDeviceId) {
        WindowsAutopilotDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("azureAdDeviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeviceIdentity");
        _x.azureAdDeviceId = azureAdDeviceId;
        return _x;
    }

    /**
     * <i>“Profile set time of the Windows autopilot device.”</i>
     * 
     * @return property deploymentProfileAssignedDateTime
     */
    @Property(name="deploymentProfileAssignedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getDeploymentProfileAssignedDateTime() {
        return Optional.ofNullable(deploymentProfileAssignedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deploymentProfileAssignedDateTime} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Profile set time of the Windows autopilot device.”</i>
     * 
     * @param deploymentProfileAssignedDateTime
     *            new value of {@code deploymentProfileAssignedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deploymentProfileAssignedDateTime} field changed
     */
    public WindowsAutopilotDeviceIdentity withDeploymentProfileAssignedDateTime(OffsetDateTime deploymentProfileAssignedDateTime) {
        WindowsAutopilotDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("deploymentProfileAssignedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeviceIdentity");
        _x.deploymentProfileAssignedDateTime = deploymentProfileAssignedDateTime;
        return _x;
    }

    /**
     * <i>“Profile assignment detailed status of the Windows autopilot device.”</i>
     * 
     * @return property deploymentProfileAssignmentDetailedStatus
     */
    @Property(name="deploymentProfileAssignmentDetailedStatus")
    @JsonIgnore
    public Optional<WindowsAutopilotProfileAssignmentDetailedStatus> getDeploymentProfileAssignmentDetailedStatus() {
        return Optional.ofNullable(deploymentProfileAssignmentDetailedStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deploymentProfileAssignmentDetailedStatus} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Profile assignment detailed status of the Windows autopilot device.”</i>
     * 
     * @param deploymentProfileAssignmentDetailedStatus
     *            new value of {@code deploymentProfileAssignmentDetailedStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deploymentProfileAssignmentDetailedStatus} field changed
     */
    public WindowsAutopilotDeviceIdentity withDeploymentProfileAssignmentDetailedStatus(WindowsAutopilotProfileAssignmentDetailedStatus deploymentProfileAssignmentDetailedStatus) {
        WindowsAutopilotDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("deploymentProfileAssignmentDetailedStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeviceIdentity");
        _x.deploymentProfileAssignmentDetailedStatus = deploymentProfileAssignmentDetailedStatus;
        return _x;
    }

    /**
     * <i>“Profile assignment status of the Windows autopilot device.”</i>
     * 
     * @return property deploymentProfileAssignmentStatus
     */
    @Property(name="deploymentProfileAssignmentStatus")
    @JsonIgnore
    public Optional<WindowsAutopilotProfileAssignmentStatus> getDeploymentProfileAssignmentStatus() {
        return Optional.ofNullable(deploymentProfileAssignmentStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deploymentProfileAssignmentStatus} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Profile assignment status of the Windows autopilot device.”</i>
     * 
     * @param deploymentProfileAssignmentStatus
     *            new value of {@code deploymentProfileAssignmentStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deploymentProfileAssignmentStatus} field changed
     */
    public WindowsAutopilotDeviceIdentity withDeploymentProfileAssignmentStatus(WindowsAutopilotProfileAssignmentStatus deploymentProfileAssignmentStatus) {
        WindowsAutopilotDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("deploymentProfileAssignmentStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeviceIdentity");
        _x.deploymentProfileAssignmentStatus = deploymentProfileAssignmentStatus;
        return _x;
    }

    /**
     * <i>“Display Name”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Display Name”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public WindowsAutopilotDeviceIdentity withDisplayName(String displayName) {
        WindowsAutopilotDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeviceIdentity");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Intune enrollment state of the Windows autopilot device.”</i>
     * 
     * @return property enrollmentState
     */
    @Property(name="enrollmentState")
    @JsonIgnore
    public Optional<EnrollmentState> getEnrollmentState() {
        return Optional.ofNullable(enrollmentState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code enrollmentState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Intune enrollment state of the Windows autopilot device.”</i>
     * 
     * @param enrollmentState
     *            new value of {@code enrollmentState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enrollmentState} field changed
     */
    public WindowsAutopilotDeviceIdentity withEnrollmentState(EnrollmentState enrollmentState) {
        WindowsAutopilotDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("enrollmentState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeviceIdentity");
        _x.enrollmentState = enrollmentState;
        return _x;
    }

    /**
     * <i>“Group Tag of the Windows autopilot device.”</i>
     * 
     * @return property groupTag
     */
    @Property(name="groupTag")
    @JsonIgnore
    public Optional<String> getGroupTag() {
        return Optional.ofNullable(groupTag);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code groupTag} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Group Tag of the Windows autopilot device.”</i>
     * 
     * @param groupTag
     *            new value of {@code groupTag} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code groupTag} field changed
     */
    public WindowsAutopilotDeviceIdentity withGroupTag(String groupTag) {
        WindowsAutopilotDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("groupTag");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeviceIdentity");
        _x.groupTag = groupTag;
        return _x;
    }

    /**
     * <i>“Intune Last Contacted Date Time of the Windows autopilot device.”</i>
     * 
     * @return property lastContactedDateTime
     */
    @Property(name="lastContactedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastContactedDateTime() {
        return Optional.ofNullable(lastContactedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastContactedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Intune Last Contacted Date Time of the Windows autopilot device.”</i>
     * 
     * @param lastContactedDateTime
     *            new value of {@code lastContactedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastContactedDateTime} field changed
     */
    public WindowsAutopilotDeviceIdentity withLastContactedDateTime(OffsetDateTime lastContactedDateTime) {
        WindowsAutopilotDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("lastContactedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeviceIdentity");
        _x.lastContactedDateTime = lastContactedDateTime;
        return _x;
    }

    /**
     * <i>“Managed Device ID”</i>
     * 
     * @return property managedDeviceId
     */
    @Property(name="managedDeviceId")
    @JsonIgnore
    public Optional<String> getManagedDeviceId() {
        return Optional.ofNullable(managedDeviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code managedDeviceId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Managed Device ID”</i>
     * 
     * @param managedDeviceId
     *            new value of {@code managedDeviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedDeviceId} field changed
     */
    public WindowsAutopilotDeviceIdentity withManagedDeviceId(String managedDeviceId) {
        WindowsAutopilotDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("managedDeviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeviceIdentity");
        _x.managedDeviceId = managedDeviceId;
        return _x;
    }

    /**
     * <i>“Oem manufacturer of the Windows autopilot device.”</i>
     * 
     * @return property manufacturer
     */
    @Property(name="manufacturer")
    @JsonIgnore
    public Optional<String> getManufacturer() {
        return Optional.ofNullable(manufacturer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code manufacturer}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Oem manufacturer of the Windows autopilot device.”</i>
     * 
     * @param manufacturer
     *            new value of {@code manufacturer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code manufacturer} field changed
     */
    public WindowsAutopilotDeviceIdentity withManufacturer(String manufacturer) {
        WindowsAutopilotDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("manufacturer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeviceIdentity");
        _x.manufacturer = manufacturer;
        return _x;
    }

    /**
     * <i>“Model name of the Windows autopilot device.”</i>
     * 
     * @return property model
     */
    @Property(name="model")
    @JsonIgnore
    public Optional<String> getModel() {
        return Optional.ofNullable(model);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code model} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Model name of the Windows autopilot device.”</i>
     * 
     * @param model
     *            new value of {@code model} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code model} field changed
     */
    public WindowsAutopilotDeviceIdentity withModel(String model) {
        WindowsAutopilotDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("model");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeviceIdentity");
        _x.model = model;
        return _x;
    }

    /**
     * <i>“Product Key of the Windows autopilot device.”</i>
     * 
     * @return property productKey
     */
    @Property(name="productKey")
    @JsonIgnore
    public Optional<String> getProductKey() {
        return Optional.ofNullable(productKey);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code productKey} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Product Key of the Windows autopilot device.”</i>
     * 
     * @param productKey
     *            new value of {@code productKey} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code productKey} field changed
     */
    public WindowsAutopilotDeviceIdentity withProductKey(String productKey) {
        WindowsAutopilotDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("productKey");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeviceIdentity");
        _x.productKey = productKey;
        return _x;
    }

    /**
     * <i>“Purchase Order Identifier of the Windows autopilot device.”</i>
     * 
     * @return property purchaseOrderIdentifier
     */
    @Property(name="purchaseOrderIdentifier")
    @JsonIgnore
    public Optional<String> getPurchaseOrderIdentifier() {
        return Optional.ofNullable(purchaseOrderIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * purchaseOrderIdentifier} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Purchase Order Identifier of the Windows autopilot device.”</i>
     * 
     * @param purchaseOrderIdentifier
     *            new value of {@code purchaseOrderIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code purchaseOrderIdentifier} field changed
     */
    public WindowsAutopilotDeviceIdentity withPurchaseOrderIdentifier(String purchaseOrderIdentifier) {
        WindowsAutopilotDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("purchaseOrderIdentifier");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeviceIdentity");
        _x.purchaseOrderIdentifier = purchaseOrderIdentifier;
        return _x;
    }

    /**
     * <i>“Resource Name.”</i>
     * 
     * @return property resourceName
     */
    @Property(name="resourceName")
    @JsonIgnore
    public Optional<String> getResourceName() {
        return Optional.ofNullable(resourceName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code resourceName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Resource Name.”</i>
     * 
     * @param resourceName
     *            new value of {@code resourceName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code resourceName} field changed
     */
    public WindowsAutopilotDeviceIdentity withResourceName(String resourceName) {
        WindowsAutopilotDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("resourceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeviceIdentity");
        _x.resourceName = resourceName;
        return _x;
    }

    /**
     * <i>“Serial number of the Windows autopilot device.”</i>
     * 
     * @return property serialNumber
     */
    @Property(name="serialNumber")
    @JsonIgnore
    public Optional<String> getSerialNumber() {
        return Optional.ofNullable(serialNumber);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code serialNumber}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Serial number of the Windows autopilot device.”</i>
     * 
     * @param serialNumber
     *            new value of {@code serialNumber} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code serialNumber} field changed
     */
    public WindowsAutopilotDeviceIdentity withSerialNumber(String serialNumber) {
        WindowsAutopilotDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("serialNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeviceIdentity");
        _x.serialNumber = serialNumber;
        return _x;
    }

    /**
     * <i>“SKU Number”</i>
     * 
     * @return property skuNumber
     */
    @Property(name="skuNumber")
    @JsonIgnore
    public Optional<String> getSkuNumber() {
        return Optional.ofNullable(skuNumber);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code skuNumber} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“SKU Number”</i>
     * 
     * @param skuNumber
     *            new value of {@code skuNumber} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code skuNumber} field changed
     */
    public WindowsAutopilotDeviceIdentity withSkuNumber(String skuNumber) {
        WindowsAutopilotDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("skuNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeviceIdentity");
        _x.skuNumber = skuNumber;
        return _x;
    }

    /**
     * <i>“System Family”</i>
     * 
     * @return property systemFamily
     */
    @Property(name="systemFamily")
    @JsonIgnore
    public Optional<String> getSystemFamily() {
        return Optional.ofNullable(systemFamily);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code systemFamily}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“System Family”</i>
     * 
     * @param systemFamily
     *            new value of {@code systemFamily} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code systemFamily} field changed
     */
    public WindowsAutopilotDeviceIdentity withSystemFamily(String systemFamily) {
        WindowsAutopilotDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("systemFamily");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeviceIdentity");
        _x.systemFamily = systemFamily;
        return _x;
    }

    /**
     * <i>“User Principal Name.”</i>
     * 
     * @return property userPrincipalName
     */
    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userPrincipalName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“User Principal Name.”</i>
     * 
     * @param userPrincipalName
     *            new value of {@code userPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userPrincipalName} field changed
     */
    public WindowsAutopilotDeviceIdentity withUserPrincipalName(String userPrincipalName) {
        WindowsAutopilotDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAutopilotDeviceIdentity");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    public WindowsAutopilotDeviceIdentity withUnmappedField(String name, Object value) {
        WindowsAutopilotDeviceIdentity _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“Deployment profile currently assigned to the Windows autopilot device.”</i>
     * 
     * @return navigational property deploymentProfile
     */
    @NavigationProperty(name="deploymentProfile")
    @JsonIgnore
    public WindowsAutopilotDeploymentProfileRequest getDeploymentProfile() {
        return new WindowsAutopilotDeploymentProfileRequest(contextPath.addSegment("deploymentProfile"), RequestHelper.getValue(unmappedFields, "deploymentProfile"));
    }

    /**
     * <i>“Deployment profile intended to be assigned to the Windows autopilot device.”</i>
     * 
     * @return navigational property intendedDeploymentProfile
     */
    @NavigationProperty(name="intendedDeploymentProfile")
    @JsonIgnore
    public WindowsAutopilotDeploymentProfileRequest getIntendedDeploymentProfile() {
        return new WindowsAutopilotDeploymentProfileRequest(contextPath.addSegment("intendedDeploymentProfile"), RequestHelper.getValue(unmappedFields, "intendedDeploymentProfile"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsAutopilotDeviceIdentity patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsAutopilotDeviceIdentity _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsAutopilotDeviceIdentity put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsAutopilotDeviceIdentity _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsAutopilotDeviceIdentity _copy() {
        WindowsAutopilotDeviceIdentity _x = new WindowsAutopilotDeviceIdentity();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.addressableUserName = addressableUserName;
        _x.azureActiveDirectoryDeviceId = azureActiveDirectoryDeviceId;
        _x.azureAdDeviceId = azureAdDeviceId;
        _x.deploymentProfileAssignedDateTime = deploymentProfileAssignedDateTime;
        _x.deploymentProfileAssignmentDetailedStatus = deploymentProfileAssignmentDetailedStatus;
        _x.deploymentProfileAssignmentStatus = deploymentProfileAssignmentStatus;
        _x.displayName = displayName;
        _x.enrollmentState = enrollmentState;
        _x.groupTag = groupTag;
        _x.lastContactedDateTime = lastContactedDateTime;
        _x.managedDeviceId = managedDeviceId;
        _x.manufacturer = manufacturer;
        _x.model = model;
        _x.productKey = productKey;
        _x.purchaseOrderIdentifier = purchaseOrderIdentifier;
        _x.resourceName = resourceName;
        _x.serialNumber = serialNumber;
        _x.skuNumber = skuNumber;
        _x.systemFamily = systemFamily;
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Action(name = "assignResourceAccountToDevice")
    @JsonIgnore
    public ActionRequestNoReturn assignResourceAccountToDevice(String userPrincipalName, String addressableUserName, String resourceAccountName) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("userPrincipalName", "Edm.String", Checks.checkIsAscii(userPrincipalName))
            .put("addressableUserName", "Edm.String", Checks.checkIsAscii(addressableUserName))
            .put("resourceAccountName", "Edm.String", Checks.checkIsAscii(resourceAccountName))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assignResourceAccountToDevice"), _parameters);
    }

    @Action(name = "assignUserToDevice")
    @JsonIgnore
    public ActionRequestNoReturn assignUserToDevice(String userPrincipalName, String addressableUserName) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("userPrincipalName", "Edm.String", Checks.checkIsAscii(userPrincipalName))
            .put("addressableUserName", "Edm.String", Checks.checkIsAscii(addressableUserName))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assignUserToDevice"), _parameters);
    }

    @Action(name = "unassignResourceAccountFromDevice")
    @JsonIgnore
    public ActionRequestNoReturn unassignResourceAccountFromDevice() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unassignResourceAccountFromDevice"), _parameters);
    }

    @Action(name = "unassignUserFromDevice")
    @JsonIgnore
    public ActionRequestNoReturn unassignUserFromDevice() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unassignUserFromDevice"), _parameters);
    }

    @Action(name = "updateDeviceProperties")
    @JsonIgnore
    public ActionRequestNoReturn updateDeviceProperties(String userPrincipalName, String addressableUserName, String groupTag, String displayName) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("userPrincipalName", "Edm.String", Checks.checkIsAscii(userPrincipalName))
            .put("addressableUserName", "Edm.String", Checks.checkIsAscii(addressableUserName))
            .put("groupTag", "Edm.String", Checks.checkIsAscii(groupTag))
            .put("displayName", "Edm.String", Checks.checkIsAscii(displayName))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.updateDeviceProperties"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsAutopilotDeviceIdentity[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("addressableUserName=");
        b.append(this.addressableUserName);
        b.append(", ");
        b.append("azureActiveDirectoryDeviceId=");
        b.append(this.azureActiveDirectoryDeviceId);
        b.append(", ");
        b.append("azureAdDeviceId=");
        b.append(this.azureAdDeviceId);
        b.append(", ");
        b.append("deploymentProfileAssignedDateTime=");
        b.append(this.deploymentProfileAssignedDateTime);
        b.append(", ");
        b.append("deploymentProfileAssignmentDetailedStatus=");
        b.append(this.deploymentProfileAssignmentDetailedStatus);
        b.append(", ");
        b.append("deploymentProfileAssignmentStatus=");
        b.append(this.deploymentProfileAssignmentStatus);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("enrollmentState=");
        b.append(this.enrollmentState);
        b.append(", ");
        b.append("groupTag=");
        b.append(this.groupTag);
        b.append(", ");
        b.append("lastContactedDateTime=");
        b.append(this.lastContactedDateTime);
        b.append(", ");
        b.append("managedDeviceId=");
        b.append(this.managedDeviceId);
        b.append(", ");
        b.append("manufacturer=");
        b.append(this.manufacturer);
        b.append(", ");
        b.append("model=");
        b.append(this.model);
        b.append(", ");
        b.append("productKey=");
        b.append(this.productKey);
        b.append(", ");
        b.append("purchaseOrderIdentifier=");
        b.append(this.purchaseOrderIdentifier);
        b.append(", ");
        b.append("resourceName=");
        b.append(this.resourceName);
        b.append(", ");
        b.append("serialNumber=");
        b.append(this.serialNumber);
        b.append(", ");
        b.append("skuNumber=");
        b.append(this.skuNumber);
        b.append(", ");
        b.append("systemFamily=");
        b.append(this.systemFamily);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
