package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Assigned Access profile for Windows.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "appUserModelIds", 
    "desktopAppPaths", 
    "profileName", 
    "showTaskBar", 
    "startMenuLayoutXml", 
    "userAccounts"})
@JsonInclude(Include.NON_NULL)
public class WindowsAssignedAccessProfile extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsAssignedAccessProfile";
    }

    @JsonProperty("appUserModelIds")
    protected List<String> appUserModelIds;

    @JsonProperty("appUserModelIds@nextLink")
    protected String appUserModelIdsNextLink;

    @JsonProperty("desktopAppPaths")
    protected List<String> desktopAppPaths;

    @JsonProperty("desktopAppPaths@nextLink")
    protected String desktopAppPathsNextLink;

    @JsonProperty("profileName")
    protected String profileName;

    @JsonProperty("showTaskBar")
    protected Boolean showTaskBar;

    @JsonProperty("startMenuLayoutXml")
    protected byte[] startMenuLayoutXml;

    @JsonProperty("userAccounts")
    protected List<String> userAccounts;

    @JsonProperty("userAccounts@nextLink")
    protected String userAccountsNextLink;

    protected WindowsAssignedAccessProfile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindowsAssignedAccessProfile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<String> appUserModelIds;
        private String appUserModelIdsNextLink;
        private List<String> desktopAppPaths;
        private String desktopAppPathsNextLink;
        private String profileName;
        private Boolean showTaskBar;
        private byte[] startMenuLayoutXml;
        private List<String> userAccounts;
        private String userAccountsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“These are the only Windows Store Apps that will be available to launch from the
         * Start menu.”</i>
         * 
         * @param appUserModelIds
         *            value of {@code appUserModelIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appUserModelIds(List<String> appUserModelIds) {
            this.appUserModelIds = appUserModelIds;
            this.changedFields = changedFields.add("appUserModelIds");
            return this;
        }

        /**
         * <i>“These are the only Windows Store Apps that will be available to launch from the
         * Start menu.”</i>
         * 
         * @param appUserModelIds
         *            value of {@code appUserModelIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appUserModelIds(String... appUserModelIds) {
            return appUserModelIds(Arrays.asList(appUserModelIds));
        }

        /**
         * <i>“These are the only Windows Store Apps that will be available to launch from the
         * Start menu.”</i>
         * 
         * @param appUserModelIdsNextLink
         *            value of {@code appUserModelIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appUserModelIdsNextLink(String appUserModelIdsNextLink) {
            this.appUserModelIdsNextLink = appUserModelIdsNextLink;
            this.changedFields = changedFields.add("appUserModelIds");
            return this;
        }

        /**
         * <i>“These are the paths of the Desktop Apps that will be available on the Start menu
         * and the only apps the user will be able to launch.”</i>
         * 
         * @param desktopAppPaths
         *            value of {@code desktopAppPaths} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder desktopAppPaths(List<String> desktopAppPaths) {
            this.desktopAppPaths = desktopAppPaths;
            this.changedFields = changedFields.add("desktopAppPaths");
            return this;
        }

        /**
         * <i>“These are the paths of the Desktop Apps that will be available on the Start menu
         * and the only apps the user will be able to launch.”</i>
         * 
         * @param desktopAppPaths
         *            value of {@code desktopAppPaths} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder desktopAppPaths(String... desktopAppPaths) {
            return desktopAppPaths(Arrays.asList(desktopAppPaths));
        }

        /**
         * <i>“These are the paths of the Desktop Apps that will be available on the Start menu
         * and the only apps the user will be able to launch.”</i>
         * 
         * @param desktopAppPathsNextLink
         *            value of {@code desktopAppPaths@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder desktopAppPathsNextLink(String desktopAppPathsNextLink) {
            this.desktopAppPathsNextLink = desktopAppPathsNextLink;
            this.changedFields = changedFields.add("desktopAppPaths");
            return this;
        }

        /**
         * <i>“This is a friendly name used to identify a group of applications, the layout of
         * these apps on the start menu and the users to whom this kiosk configuration is
         * assigned.”</i>
         * 
         * @param profileName
         *            value of {@code profileName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder profileName(String profileName) {
            this.profileName = profileName;
            this.changedFields = changedFields.add("profileName");
            return this;
        }

        /**
         * <i>“This setting allows the admin to specify whether the Task Bar is shown or not.”</i>
         * 
         * @param showTaskBar
         *            value of {@code showTaskBar} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder showTaskBar(Boolean showTaskBar) {
            this.showTaskBar = showTaskBar;
            this.changedFields = changedFields.add("showTaskBar");
            return this;
        }

        /**
         * <i>“Allows admins to override the default Start layout and prevents the user from
         * changing it. The layout is modified by specifying an XML file based on a layout
         * modification schema. XML needs to be in Binary format.”</i>
         * 
         * @param startMenuLayoutXml
         *            value of {@code startMenuLayoutXml} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startMenuLayoutXml(byte[] startMenuLayoutXml) {
            this.startMenuLayoutXml = startMenuLayoutXml;
            this.changedFields = changedFields.add("startMenuLayoutXml");
            return this;
        }

        /**
         * <i>“The user accounts that will be locked to this kiosk configuration.”</i>
         * 
         * @param userAccounts
         *            value of {@code userAccounts} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userAccounts(List<String> userAccounts) {
            this.userAccounts = userAccounts;
            this.changedFields = changedFields.add("userAccounts");
            return this;
        }

        /**
         * <i>“The user accounts that will be locked to this kiosk configuration.”</i>
         * 
         * @param userAccounts
         *            value of {@code userAccounts} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userAccounts(String... userAccounts) {
            return userAccounts(Arrays.asList(userAccounts));
        }

        /**
         * <i>“The user accounts that will be locked to this kiosk configuration.”</i>
         * 
         * @param userAccountsNextLink
         *            value of {@code userAccounts@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userAccountsNextLink(String userAccountsNextLink) {
            this.userAccountsNextLink = userAccountsNextLink;
            this.changedFields = changedFields.add("userAccounts");
            return this;
        }

        public WindowsAssignedAccessProfile build() {
            WindowsAssignedAccessProfile _x = new WindowsAssignedAccessProfile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsAssignedAccessProfile";
            _x.id = id;
            _x.appUserModelIds = appUserModelIds;
            _x.appUserModelIdsNextLink = appUserModelIdsNextLink;
            _x.desktopAppPaths = desktopAppPaths;
            _x.desktopAppPathsNextLink = desktopAppPathsNextLink;
            _x.profileName = profileName;
            _x.showTaskBar = showTaskBar;
            _x.startMenuLayoutXml = startMenuLayoutXml;
            _x.userAccounts = userAccounts;
            _x.userAccountsNextLink = userAccountsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“These are the only Windows Store Apps that will be available to launch from the
     * Start menu.”</i>
     * 
     * @return property appUserModelIds
     */
    @Property(name="appUserModelIds")
    @JsonIgnore
    public CollectionPage<String> getAppUserModelIds() {
        return new CollectionPage<String>(contextPath, String.class, this.appUserModelIds, Optional.ofNullable(appUserModelIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appUserModelIds}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“These are the only Windows Store Apps that will be available to launch from the
     * Start menu.”</i>
     * 
     * @param appUserModelIds
     *            new value of {@code appUserModelIds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appUserModelIds} field changed
     */
    public WindowsAssignedAccessProfile withAppUserModelIds(List<String> appUserModelIds) {
        WindowsAssignedAccessProfile _x = _copy();
        _x.changedFields = changedFields.add("appUserModelIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAssignedAccessProfile");
        _x.appUserModelIds = appUserModelIds;
        return _x;
    }

    /**
     * <i>“These are the only Windows Store Apps that will be available to launch from the
     * Start menu.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property appUserModelIds
     */
    @Property(name="appUserModelIds")
    @JsonIgnore
    public CollectionPage<String> getAppUserModelIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.appUserModelIds, Optional.ofNullable(appUserModelIdsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“These are the paths of the Desktop Apps that will be available on the Start menu
     * and the only apps the user will be able to launch.”</i>
     * 
     * @return property desktopAppPaths
     */
    @Property(name="desktopAppPaths")
    @JsonIgnore
    public CollectionPage<String> getDesktopAppPaths() {
        return new CollectionPage<String>(contextPath, String.class, this.desktopAppPaths, Optional.ofNullable(desktopAppPathsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code desktopAppPaths}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“These are the paths of the Desktop Apps that will be available on the Start menu
     * and the only apps the user will be able to launch.”</i>
     * 
     * @param desktopAppPaths
     *            new value of {@code desktopAppPaths} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code desktopAppPaths} field changed
     */
    public WindowsAssignedAccessProfile withDesktopAppPaths(List<String> desktopAppPaths) {
        WindowsAssignedAccessProfile _x = _copy();
        _x.changedFields = changedFields.add("desktopAppPaths");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAssignedAccessProfile");
        _x.desktopAppPaths = desktopAppPaths;
        return _x;
    }

    /**
     * <i>“These are the paths of the Desktop Apps that will be available on the Start menu
     * and the only apps the user will be able to launch.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property desktopAppPaths
     */
    @Property(name="desktopAppPaths")
    @JsonIgnore
    public CollectionPage<String> getDesktopAppPaths(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.desktopAppPaths, Optional.ofNullable(desktopAppPathsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“This is a friendly name used to identify a group of applications, the layout of
     * these apps on the start menu and the users to whom this kiosk configuration is
     * assigned.”</i>
     * 
     * @return property profileName
     */
    @Property(name="profileName")
    @JsonIgnore
    public Optional<String> getProfileName() {
        return Optional.ofNullable(profileName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code profileName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“This is a friendly name used to identify a group of applications, the layout of
     * these apps on the start menu and the users to whom this kiosk configuration is
     * assigned.”</i>
     * 
     * @param profileName
     *            new value of {@code profileName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code profileName} field changed
     */
    public WindowsAssignedAccessProfile withProfileName(String profileName) {
        WindowsAssignedAccessProfile _x = _copy();
        _x.changedFields = changedFields.add("profileName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAssignedAccessProfile");
        _x.profileName = profileName;
        return _x;
    }

    /**
     * <i>“This setting allows the admin to specify whether the Task Bar is shown or not.”</i>
     * 
     * @return property showTaskBar
     */
    @Property(name="showTaskBar")
    @JsonIgnore
    public Optional<Boolean> getShowTaskBar() {
        return Optional.ofNullable(showTaskBar);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code showTaskBar}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“This setting allows the admin to specify whether the Task Bar is shown or not.”</i>
     * 
     * @param showTaskBar
     *            new value of {@code showTaskBar} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code showTaskBar} field changed
     */
    public WindowsAssignedAccessProfile withShowTaskBar(Boolean showTaskBar) {
        WindowsAssignedAccessProfile _x = _copy();
        _x.changedFields = changedFields.add("showTaskBar");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAssignedAccessProfile");
        _x.showTaskBar = showTaskBar;
        return _x;
    }

    /**
     * <i>“Allows admins to override the default Start layout and prevents the user from
     * changing it. The layout is modified by specifying an XML file based on a layout
     * modification schema. XML needs to be in Binary format.”</i>
     * 
     * @return property startMenuLayoutXml
     */
    @Property(name="startMenuLayoutXml")
    @JsonIgnore
    public Optional<byte[]> getStartMenuLayoutXml() {
        return Optional.ofNullable(startMenuLayoutXml);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startMenuLayoutXml} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Allows admins to override the default Start layout and prevents the user from
     * changing it. The layout is modified by specifying an XML file based on a layout
     * modification schema. XML needs to be in Binary format.”</i>
     * 
     * @param startMenuLayoutXml
     *            new value of {@code startMenuLayoutXml} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startMenuLayoutXml} field changed
     */
    public WindowsAssignedAccessProfile withStartMenuLayoutXml(byte[] startMenuLayoutXml) {
        WindowsAssignedAccessProfile _x = _copy();
        _x.changedFields = changedFields.add("startMenuLayoutXml");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAssignedAccessProfile");
        _x.startMenuLayoutXml = startMenuLayoutXml;
        return _x;
    }

    /**
     * <i>“The user accounts that will be locked to this kiosk configuration.”</i>
     * 
     * @return property userAccounts
     */
    @Property(name="userAccounts")
    @JsonIgnore
    public CollectionPage<String> getUserAccounts() {
        return new CollectionPage<String>(contextPath, String.class, this.userAccounts, Optional.ofNullable(userAccountsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userAccounts}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user accounts that will be locked to this kiosk configuration.”</i>
     * 
     * @param userAccounts
     *            new value of {@code userAccounts} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userAccounts} field changed
     */
    public WindowsAssignedAccessProfile withUserAccounts(List<String> userAccounts) {
        WindowsAssignedAccessProfile _x = _copy();
        _x.changedFields = changedFields.add("userAccounts");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsAssignedAccessProfile");
        _x.userAccounts = userAccounts;
        return _x;
    }

    /**
     * <i>“The user accounts that will be locked to this kiosk configuration.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property userAccounts
     */
    @Property(name="userAccounts")
    @JsonIgnore
    public CollectionPage<String> getUserAccounts(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.userAccounts, Optional.ofNullable(userAccountsNextLink), Collections.emptyList(), options);
    }

    public WindowsAssignedAccessProfile withUnmappedField(String name, Object value) {
        WindowsAssignedAccessProfile _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsAssignedAccessProfile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WindowsAssignedAccessProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WindowsAssignedAccessProfile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WindowsAssignedAccessProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WindowsAssignedAccessProfile _copy() {
        WindowsAssignedAccessProfile _x = new WindowsAssignedAccessProfile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.appUserModelIds = appUserModelIds;
        _x.desktopAppPaths = desktopAppPaths;
        _x.profileName = profileName;
        _x.showTaskBar = showTaskBar;
        _x.startMenuLayoutXml = startMenuLayoutXml;
        _x.userAccounts = userAccounts;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WindowsAssignedAccessProfile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("appUserModelIds=");
        b.append(this.appUserModelIds);
        b.append(", ");
        b.append("desktopAppPaths=");
        b.append(this.desktopAppPaths);
        b.append(", ");
        b.append("profileName=");
        b.append(this.profileName);
        b.append(", ");
        b.append("showTaskBar=");
        b.append(this.showTaskBar);
        b.append(", ");
        b.append("startMenuLayoutXml=");
        b.append(this.startMenuLayoutXml);
        b.append(", ");
        b.append("userAccounts=");
        b.append(this.userAccounts);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
