package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.CustomSubjectAlternativeName;
import odata.msgraph.client.beta.complex.ExtendedKeyUsage;


/**
 * <i>“Device Configuration.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "customSubjectAlternativeNames", 
    "extendedKeyUsages"})
@JsonInclude(Include.NON_NULL)
public class Windows81CertificateProfileBase extends WindowsCertificateProfileBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windows81CertificateProfileBase";
    }

    @JsonProperty("customSubjectAlternativeNames")
    protected List<CustomSubjectAlternativeName> customSubjectAlternativeNames;

    @JsonProperty("customSubjectAlternativeNames@nextLink")
    protected String customSubjectAlternativeNamesNextLink;

    @JsonProperty("extendedKeyUsages")
    protected List<ExtendedKeyUsage> extendedKeyUsages;

    @JsonProperty("extendedKeyUsages@nextLink")
    protected String extendedKeyUsagesNextLink;

    protected Windows81CertificateProfileBase() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Custom Subject Alternative Name Settings. This collection can contain a maximum
     * of 500 elements.”</i>
     * 
     * @return property customSubjectAlternativeNames
     */
    @Property(name="customSubjectAlternativeNames")
    @JsonIgnore
    public CollectionPage<CustomSubjectAlternativeName> getCustomSubjectAlternativeNames() {
        return new CollectionPage<CustomSubjectAlternativeName>(contextPath, CustomSubjectAlternativeName.class, this.customSubjectAlternativeNames, Optional.ofNullable(customSubjectAlternativeNamesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * customSubjectAlternativeNames} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Custom Subject Alternative Name Settings. This collection can contain a maximum
     * of 500 elements.”</i>
     * 
     * @param customSubjectAlternativeNames
     *            new value of {@code customSubjectAlternativeNames} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code customSubjectAlternativeNames} field changed
     */
    public Windows81CertificateProfileBase withCustomSubjectAlternativeNames(List<CustomSubjectAlternativeName> customSubjectAlternativeNames) {
        Windows81CertificateProfileBase _x = _copy();
        _x.changedFields = changedFields.add("customSubjectAlternativeNames");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81CertificateProfileBase");
        _x.customSubjectAlternativeNames = customSubjectAlternativeNames;
        return _x;
    }

    /**
     * <i>“Custom Subject Alternative Name Settings. This collection can contain a maximum
     * of 500 elements.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property customSubjectAlternativeNames
     */
    @Property(name="customSubjectAlternativeNames")
    @JsonIgnore
    public CollectionPage<CustomSubjectAlternativeName> getCustomSubjectAlternativeNames(HttpRequestOptions options) {
        return new CollectionPage<CustomSubjectAlternativeName>(contextPath, CustomSubjectAlternativeName.class, this.customSubjectAlternativeNames, Optional.ofNullable(customSubjectAlternativeNamesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Extended Key Usage (EKU) settings. This collection can contain a maximum of 500
     * elements.”</i>
     * 
     * @return property extendedKeyUsages
     */
    @Property(name="extendedKeyUsages")
    @JsonIgnore
    public CollectionPage<ExtendedKeyUsage> getExtendedKeyUsages() {
        return new CollectionPage<ExtendedKeyUsage>(contextPath, ExtendedKeyUsage.class, this.extendedKeyUsages, Optional.ofNullable(extendedKeyUsagesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code extendedKeyUsages
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Extended Key Usage (EKU) settings. This collection can contain a maximum of 500
     * elements.”</i>
     * 
     * @param extendedKeyUsages
     *            new value of {@code extendedKeyUsages} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code extendedKeyUsages} field changed
     */
    public Windows81CertificateProfileBase withExtendedKeyUsages(List<ExtendedKeyUsage> extendedKeyUsages) {
        Windows81CertificateProfileBase _x = _copy();
        _x.changedFields = changedFields.add("extendedKeyUsages");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows81CertificateProfileBase");
        _x.extendedKeyUsages = extendedKeyUsages;
        return _x;
    }

    /**
     * <i>“Extended Key Usage (EKU) settings. This collection can contain a maximum of 500
     * elements.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property extendedKeyUsages
     */
    @Property(name="extendedKeyUsages")
    @JsonIgnore
    public CollectionPage<ExtendedKeyUsage> getExtendedKeyUsages(HttpRequestOptions options) {
        return new CollectionPage<ExtendedKeyUsage>(contextPath, ExtendedKeyUsage.class, this.extendedKeyUsages, Optional.ofNullable(extendedKeyUsagesNextLink), Collections.emptyList(), options);
    }

    public Windows81CertificateProfileBase withUnmappedField(String name, Object value) {
        Windows81CertificateProfileBase _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows81CertificateProfileBase patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Windows81CertificateProfileBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows81CertificateProfileBase put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Windows81CertificateProfileBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Windows81CertificateProfileBase _copy() {
        Windows81CertificateProfileBase _x = new Windows81CertificateProfileBase();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.version = version;
        _x.assignments = assignments;
        _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
        _x.deviceStatuses = deviceStatuses;
        _x.deviceStatusOverview = deviceStatusOverview;
        _x.groupAssignments = groupAssignments;
        _x.userStatuses = userStatuses;
        _x.userStatusOverview = userStatusOverview;
        _x.certificateValidityPeriodScale = certificateValidityPeriodScale;
        _x.certificateValidityPeriodValue = certificateValidityPeriodValue;
        _x.keyStorageProvider = keyStorageProvider;
        _x.renewalThresholdPercentage = renewalThresholdPercentage;
        _x.subjectAlternativeNameType = subjectAlternativeNameType;
        _x.subjectNameFormat = subjectNameFormat;
        _x.customSubjectAlternativeNames = customSubjectAlternativeNames;
        _x.extendedKeyUsages = extendedKeyUsages;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Windows81CertificateProfileBase[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceSettingStateSummaries=");
        b.append(this.deviceSettingStateSummaries);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("deviceStatusOverview=");
        b.append(this.deviceStatusOverview);
        b.append(", ");
        b.append("groupAssignments=");
        b.append(this.groupAssignments);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("userStatusOverview=");
        b.append(this.userStatusOverview);
        b.append(", ");
        b.append("certificateValidityPeriodScale=");
        b.append(this.certificateValidityPeriodScale);
        b.append(", ");
        b.append("certificateValidityPeriodValue=");
        b.append(this.certificateValidityPeriodValue);
        b.append(", ");
        b.append("keyStorageProvider=");
        b.append(this.keyStorageProvider);
        b.append(", ");
        b.append("renewalThresholdPercentage=");
        b.append(this.renewalThresholdPercentage);
        b.append(", ");
        b.append("subjectAlternativeNameType=");
        b.append(this.subjectAlternativeNameType);
        b.append(", ");
        b.append("subjectNameFormat=");
        b.append(this.subjectNameFormat);
        b.append(", ");
        b.append("customSubjectAlternativeNames=");
        b.append(this.customSubjectAlternativeNames);
        b.append(", ");
        b.append("extendedKeyUsages=");
        b.append(this.extendedKeyUsages);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
