package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.CertificateDestinationStore;


/**
 * <i>“Windows X Trusted Root Certificate configuration profile”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "certFileName", 
    "destinationStore", 
    "trustedRootCertificate"})
@JsonInclude(Include.NON_NULL)
public class Windows10XTrustedRootCertificate extends DeviceManagementResourceAccessProfileBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windows10XTrustedRootCertificate";
    }

    @JsonProperty("certFileName")
    protected String certFileName;

    @JsonProperty("destinationStore")
    protected CertificateDestinationStore destinationStore;

    @JsonProperty("trustedRootCertificate")
    protected byte[] trustedRootCertificate;

    protected Windows10XTrustedRootCertificate() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindows10XTrustedRootCertificate() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime creationDateTime;
        private String description;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Integer version;
        private List<DeviceManagementResourceAccessProfileAssignment> assignments;
        private String certFileName;
        private CertificateDestinationStore destinationStore;
        private byte[] trustedRootCertificate;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder creationDateTime(OffsetDateTime creationDateTime) {
            this.creationDateTime = creationDateTime;
            this.changedFields = changedFields.add("creationDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder assignments(List<DeviceManagementResourceAccessProfileAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(DeviceManagementResourceAccessProfileAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        /**
         * <i>“File name to display in UI.”</i>
         * 
         * @param certFileName
         *            value of {@code certFileName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certFileName(String certFileName) {
            this.certFileName = certFileName;
            this.changedFields = changedFields.add("certFileName");
            return this;
        }

        /**
         * <i>“Destination store location for the Trusted Root Certificate.”</i>
         * 
         * @param destinationStore
         *            value of {@code destinationStore} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder destinationStore(CertificateDestinationStore destinationStore) {
            this.destinationStore = destinationStore;
            this.changedFields = changedFields.add("destinationStore");
            return this;
        }

        /**
         * <i>“Trusted Root Certificate”</i>
         * 
         * @param trustedRootCertificate
         *            value of {@code trustedRootCertificate} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder trustedRootCertificate(byte[] trustedRootCertificate) {
            this.trustedRootCertificate = trustedRootCertificate;
            this.changedFields = changedFields.add("trustedRootCertificate");
            return this;
        }

        public Windows10XTrustedRootCertificate build() {
            Windows10XTrustedRootCertificate _x = new Windows10XTrustedRootCertificate();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windows10XTrustedRootCertificate";
            _x.id = id;
            _x.creationDateTime = creationDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.version = version;
            _x.assignments = assignments;
            _x.certFileName = certFileName;
            _x.destinationStore = destinationStore;
            _x.trustedRootCertificate = trustedRootCertificate;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“File name to display in UI.”</i>
     * 
     * @return property certFileName
     */
    @Property(name="certFileName")
    @JsonIgnore
    public Optional<String> getCertFileName() {
        return Optional.ofNullable(certFileName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code certFileName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“File name to display in UI.”</i>
     * 
     * @param certFileName
     *            new value of {@code certFileName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certFileName} field changed
     */
    public Windows10XTrustedRootCertificate withCertFileName(String certFileName) {
        Windows10XTrustedRootCertificate _x = _copy();
        _x.changedFields = changedFields.add("certFileName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10XTrustedRootCertificate");
        _x.certFileName = certFileName;
        return _x;
    }

    /**
     * <i>“Destination store location for the Trusted Root Certificate.”</i>
     * 
     * @return property destinationStore
     */
    @Property(name="destinationStore")
    @JsonIgnore
    public Optional<CertificateDestinationStore> getDestinationStore() {
        return Optional.ofNullable(destinationStore);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code destinationStore}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Destination store location for the Trusted Root Certificate.”</i>
     * 
     * @param destinationStore
     *            new value of {@code destinationStore} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code destinationStore} field changed
     */
    public Windows10XTrustedRootCertificate withDestinationStore(CertificateDestinationStore destinationStore) {
        Windows10XTrustedRootCertificate _x = _copy();
        _x.changedFields = changedFields.add("destinationStore");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10XTrustedRootCertificate");
        _x.destinationStore = destinationStore;
        return _x;
    }

    /**
     * <i>“Trusted Root Certificate”</i>
     * 
     * @return property trustedRootCertificate
     */
    @Property(name="trustedRootCertificate")
    @JsonIgnore
    public Optional<byte[]> getTrustedRootCertificate() {
        return Optional.ofNullable(trustedRootCertificate);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * trustedRootCertificate} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Trusted Root Certificate”</i>
     * 
     * @param trustedRootCertificate
     *            new value of {@code trustedRootCertificate} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code trustedRootCertificate} field changed
     */
    public Windows10XTrustedRootCertificate withTrustedRootCertificate(byte[] trustedRootCertificate) {
        Windows10XTrustedRootCertificate _x = _copy();
        _x.changedFields = changedFields.add("trustedRootCertificate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10XTrustedRootCertificate");
        _x.trustedRootCertificate = trustedRootCertificate;
        return _x;
    }

    public Windows10XTrustedRootCertificate withUnmappedField(String name, Object value) {
        Windows10XTrustedRootCertificate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows10XTrustedRootCertificate patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Windows10XTrustedRootCertificate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows10XTrustedRootCertificate put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Windows10XTrustedRootCertificate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Windows10XTrustedRootCertificate _copy() {
        Windows10XTrustedRootCertificate _x = new Windows10XTrustedRootCertificate();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.creationDateTime = creationDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.version = version;
        _x.assignments = assignments;
        _x.certFileName = certFileName;
        _x.destinationStore = destinationStore;
        _x.trustedRootCertificate = trustedRootCertificate;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Windows10XTrustedRootCertificate[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("creationDateTime=");
        b.append(this.creationDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("certFileName=");
        b.append(this.certFileName);
        b.append(", ");
        b.append("destinationStore=");
        b.append(this.destinationStore);
        b.append(", ");
        b.append("trustedRootCertificate=");
        b.append(this.trustedRootCertificate);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
