package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

import odata.msgraph.client.beta.complex.ExtendedKeyUsage;
import odata.msgraph.client.beta.complex.Windows10XCustomSubjectAlternativeName;
import odata.msgraph.client.beta.enums.CertificateStore;
import odata.msgraph.client.beta.enums.CertificateValidityPeriodScale;
import odata.msgraph.client.beta.enums.HashAlgorithms;
import odata.msgraph.client.beta.enums.KeySize;
import odata.msgraph.client.beta.enums.KeyStorageProviderOption;
import odata.msgraph.client.beta.enums.KeyUsages;


/**
 * <i>“Windows X SCEP Certificate configuration profile”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "certificateStore", 
    "certificateValidityPeriodScale", 
    "certificateValidityPeriodValue", 
    "extendedKeyUsages", 
    "hashAlgorithm", 
    "keySize", 
    "keyStorageProvider", 
    "keyUsage", 
    "renewalThresholdPercentage", 
    "rootCertificateId", 
    "scepServerUrls", 
    "subjectAlternativeNameFormats", 
    "subjectNameFormatString"})
@JsonInclude(Include.NON_NULL)
public class Windows10XSCEPCertificateProfile extends Windows10XCertificateProfile implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windows10XSCEPCertificateProfile";
    }

    @JsonProperty("certificateStore")
    protected CertificateStore certificateStore;

    @JsonProperty("certificateValidityPeriodScale")
    protected CertificateValidityPeriodScale certificateValidityPeriodScale;

    @JsonProperty("certificateValidityPeriodValue")
    protected Integer certificateValidityPeriodValue;

    @JsonProperty("extendedKeyUsages")
    protected List<ExtendedKeyUsage> extendedKeyUsages;

    @JsonProperty("extendedKeyUsages@nextLink")
    protected String extendedKeyUsagesNextLink;

    @JsonProperty("hashAlgorithm")
    protected List<HashAlgorithms> hashAlgorithm;

    @JsonProperty("hashAlgorithm@nextLink")
    protected String hashAlgorithmNextLink;

    @JsonProperty("keySize")
    protected KeySize keySize;

    @JsonProperty("keyStorageProvider")
    protected KeyStorageProviderOption keyStorageProvider;

    @JsonProperty("keyUsage")
    protected KeyUsages keyUsage;

    @JsonProperty("renewalThresholdPercentage")
    protected Integer renewalThresholdPercentage;

    @JsonProperty("rootCertificateId")
    protected UUID rootCertificateId;

    @JsonProperty("scepServerUrls")
    protected List<String> scepServerUrls;

    @JsonProperty("scepServerUrls@nextLink")
    protected String scepServerUrlsNextLink;

    @JsonProperty("subjectAlternativeNameFormats")
    protected List<Windows10XCustomSubjectAlternativeName> subjectAlternativeNameFormats;

    @JsonProperty("subjectAlternativeNameFormats@nextLink")
    protected String subjectAlternativeNameFormatsNextLink;

    @JsonProperty("subjectNameFormatString")
    protected String subjectNameFormatString;

    protected Windows10XSCEPCertificateProfile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindows10XSCEPCertificateProfile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime creationDateTime;
        private String description;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Integer version;
        private List<DeviceManagementResourceAccessProfileAssignment> assignments;
        private CertificateStore certificateStore;
        private CertificateValidityPeriodScale certificateValidityPeriodScale;
        private Integer certificateValidityPeriodValue;
        private List<ExtendedKeyUsage> extendedKeyUsages;
        private String extendedKeyUsagesNextLink;
        private List<HashAlgorithms> hashAlgorithm;
        private String hashAlgorithmNextLink;
        private KeySize keySize;
        private KeyStorageProviderOption keyStorageProvider;
        private KeyUsages keyUsage;
        private Integer renewalThresholdPercentage;
        private UUID rootCertificateId;
        private List<String> scepServerUrls;
        private String scepServerUrlsNextLink;
        private List<Windows10XCustomSubjectAlternativeName> subjectAlternativeNameFormats;
        private String subjectAlternativeNameFormatsNextLink;
        private String subjectNameFormatString;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder creationDateTime(OffsetDateTime creationDateTime) {
            this.creationDateTime = creationDateTime;
            this.changedFields = changedFields.add("creationDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder assignments(List<DeviceManagementResourceAccessProfileAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(DeviceManagementResourceAccessProfileAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        /**
         * <i>“Target store certificate”</i>
         * 
         * @param certificateStore
         *            value of {@code certificateStore} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateStore(CertificateStore certificateStore) {
            this.certificateStore = certificateStore;
            this.changedFields = changedFields.add("certificateStore");
            return this;
        }

        /**
         * <i>“Scale for the Certificate Validity Period”</i>
         * 
         * @param certificateValidityPeriodScale
         *            value of {@code certificateValidityPeriodScale} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateValidityPeriodScale(CertificateValidityPeriodScale certificateValidityPeriodScale) {
            this.certificateValidityPeriodScale = certificateValidityPeriodScale;
            this.changedFields = changedFields.add("certificateValidityPeriodScale");
            return this;
        }

        /**
         * <i>“Value for the Certificate Validity Period”</i>
         * 
         * @param certificateValidityPeriodValue
         *            value of {@code certificateValidityPeriodValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateValidityPeriodValue(Integer certificateValidityPeriodValue) {
            this.certificateValidityPeriodValue = certificateValidityPeriodValue;
            this.changedFields = changedFields.add("certificateValidityPeriodValue");
            return this;
        }

        /**
         * <i>“Extended Key Usage (EKU) settings.”</i>
         * 
         * @param extendedKeyUsages
         *            value of {@code extendedKeyUsages} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder extendedKeyUsages(List<ExtendedKeyUsage> extendedKeyUsages) {
            this.extendedKeyUsages = extendedKeyUsages;
            this.changedFields = changedFields.add("extendedKeyUsages");
            return this;
        }

        /**
         * <i>“Extended Key Usage (EKU) settings.”</i>
         * 
         * @param extendedKeyUsages
         *            value of {@code extendedKeyUsages} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder extendedKeyUsages(ExtendedKeyUsage... extendedKeyUsages) {
            return extendedKeyUsages(Arrays.asList(extendedKeyUsages));
        }

        /**
         * <i>“Extended Key Usage (EKU) settings.”</i>
         * 
         * @param extendedKeyUsagesNextLink
         *            value of {@code extendedKeyUsages@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder extendedKeyUsagesNextLink(String extendedKeyUsagesNextLink) {
            this.extendedKeyUsagesNextLink = extendedKeyUsagesNextLink;
            this.changedFields = changedFields.add("extendedKeyUsages");
            return this;
        }

        /**
         * <i>“SCEP Hash Algorithm.”</i>
         * 
         * @param hashAlgorithm
         *            value of {@code hashAlgorithm} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder hashAlgorithm(List<HashAlgorithms> hashAlgorithm) {
            this.hashAlgorithm = hashAlgorithm;
            this.changedFields = changedFields.add("hashAlgorithm");
            return this;
        }

        /**
         * <i>“SCEP Hash Algorithm.”</i>
         * 
         * @param hashAlgorithm
         *            value of {@code hashAlgorithm} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder hashAlgorithm(HashAlgorithms... hashAlgorithm) {
            return hashAlgorithm(Arrays.asList(hashAlgorithm));
        }

        /**
         * <i>“SCEP Hash Algorithm.”</i>
         * 
         * @param hashAlgorithmNextLink
         *            value of {@code hashAlgorithm@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder hashAlgorithmNextLink(String hashAlgorithmNextLink) {
            this.hashAlgorithmNextLink = hashAlgorithmNextLink;
            this.changedFields = changedFields.add("hashAlgorithm");
            return this;
        }

        /**
         * <i>“SCEP Key Size.”</i>
         * 
         * @param keySize
         *            value of {@code keySize} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder keySize(KeySize keySize) {
            this.keySize = keySize;
            this.changedFields = changedFields.add("keySize");
            return this;
        }

        /**
         * <i>“Key Storage Provider (KSP)”</i>
         * 
         * @param keyStorageProvider
         *            value of {@code keyStorageProvider} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder keyStorageProvider(KeyStorageProviderOption keyStorageProvider) {
            this.keyStorageProvider = keyStorageProvider;
            this.changedFields = changedFields.add("keyStorageProvider");
            return this;
        }

        /**
         * <i>“SCEP Key Usage.”</i>
         * 
         * @param keyUsage
         *            value of {@code keyUsage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder keyUsage(KeyUsages keyUsage) {
            this.keyUsage = keyUsage;
            this.changedFields = changedFields.add("keyUsage");
            return this;
        }

        /**
         * <i>“Certificate renewal threshold percentage”</i>
         * 
         * @param renewalThresholdPercentage
         *            value of {@code renewalThresholdPercentage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder renewalThresholdPercentage(Integer renewalThresholdPercentage) {
            this.renewalThresholdPercentage = renewalThresholdPercentage;
            this.changedFields = changedFields.add("renewalThresholdPercentage");
            return this;
        }

        /**
         * <i>“Trusted Root Certificate ID”</i>
         * 
         * @param rootCertificateId
         *            value of {@code rootCertificateId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder rootCertificateId(UUID rootCertificateId) {
            this.rootCertificateId = rootCertificateId;
            this.changedFields = changedFields.add("rootCertificateId");
            return this;
        }

        /**
         * <i>“SCEP Server Url(s).”</i>
         * 
         * @param scepServerUrls
         *            value of {@code scepServerUrls} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder scepServerUrls(List<String> scepServerUrls) {
            this.scepServerUrls = scepServerUrls;
            this.changedFields = changedFields.add("scepServerUrls");
            return this;
        }

        /**
         * <i>“SCEP Server Url(s).”</i>
         * 
         * @param scepServerUrls
         *            value of {@code scepServerUrls} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder scepServerUrls(String... scepServerUrls) {
            return scepServerUrls(Arrays.asList(scepServerUrls));
        }

        /**
         * <i>“SCEP Server Url(s).”</i>
         * 
         * @param scepServerUrlsNextLink
         *            value of {@code scepServerUrls@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder scepServerUrlsNextLink(String scepServerUrlsNextLink) {
            this.scepServerUrlsNextLink = scepServerUrlsNextLink;
            this.changedFields = changedFields.add("scepServerUrls");
            return this;
        }

        /**
         * <i>“Custom AAD Attributes.”</i>
         * 
         * @param subjectAlternativeNameFormats
         *            value of {@code subjectAlternativeNameFormats} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder subjectAlternativeNameFormats(List<Windows10XCustomSubjectAlternativeName> subjectAlternativeNameFormats) {
            this.subjectAlternativeNameFormats = subjectAlternativeNameFormats;
            this.changedFields = changedFields.add("subjectAlternativeNameFormats");
            return this;
        }

        /**
         * <i>“Custom AAD Attributes.”</i>
         * 
         * @param subjectAlternativeNameFormats
         *            value of {@code subjectAlternativeNameFormats} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder subjectAlternativeNameFormats(Windows10XCustomSubjectAlternativeName... subjectAlternativeNameFormats) {
            return subjectAlternativeNameFormats(Arrays.asList(subjectAlternativeNameFormats));
        }

        /**
         * <i>“Custom AAD Attributes.”</i>
         * 
         * @param subjectAlternativeNameFormatsNextLink
         *            value of {@code subjectAlternativeNameFormats@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder subjectAlternativeNameFormatsNextLink(String subjectAlternativeNameFormatsNextLink) {
            this.subjectAlternativeNameFormatsNextLink = subjectAlternativeNameFormatsNextLink;
            this.changedFields = changedFields.add("subjectAlternativeNameFormats");
            return this;
        }

        /**
         * <i>“Custom format to use with SubjectNameFormat = Custom. Example: CN={{EmailAddress
         * }},E={{EmailAddress}},OU=Enterprise Users,O=Contoso Corporation,L=Redmond,ST=WA,
         * C=US”</i>
         * 
         * @param subjectNameFormatString
         *            value of {@code subjectNameFormatString} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder subjectNameFormatString(String subjectNameFormatString) {
            this.subjectNameFormatString = subjectNameFormatString;
            this.changedFields = changedFields.add("subjectNameFormatString");
            return this;
        }

        public Windows10XSCEPCertificateProfile build() {
            Windows10XSCEPCertificateProfile _x = new Windows10XSCEPCertificateProfile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windows10XSCEPCertificateProfile";
            _x.id = id;
            _x.creationDateTime = creationDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.version = version;
            _x.assignments = assignments;
            _x.certificateStore = certificateStore;
            _x.certificateValidityPeriodScale = certificateValidityPeriodScale;
            _x.certificateValidityPeriodValue = certificateValidityPeriodValue;
            _x.extendedKeyUsages = extendedKeyUsages;
            _x.extendedKeyUsagesNextLink = extendedKeyUsagesNextLink;
            _x.hashAlgorithm = hashAlgorithm;
            _x.hashAlgorithmNextLink = hashAlgorithmNextLink;
            _x.keySize = keySize;
            _x.keyStorageProvider = keyStorageProvider;
            _x.keyUsage = keyUsage;
            _x.renewalThresholdPercentage = renewalThresholdPercentage;
            _x.rootCertificateId = rootCertificateId;
            _x.scepServerUrls = scepServerUrls;
            _x.scepServerUrlsNextLink = scepServerUrlsNextLink;
            _x.subjectAlternativeNameFormats = subjectAlternativeNameFormats;
            _x.subjectAlternativeNameFormatsNextLink = subjectAlternativeNameFormatsNextLink;
            _x.subjectNameFormatString = subjectNameFormatString;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Target store certificate”</i>
     * 
     * @return property certificateStore
     */
    @Property(name="certificateStore")
    @JsonIgnore
    public Optional<CertificateStore> getCertificateStore() {
        return Optional.ofNullable(certificateStore);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code certificateStore}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Target store certificate”</i>
     * 
     * @param certificateStore
     *            new value of {@code certificateStore} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateStore} field changed
     */
    public Windows10XSCEPCertificateProfile withCertificateStore(CertificateStore certificateStore) {
        Windows10XSCEPCertificateProfile _x = _copy();
        _x.changedFields = changedFields.add("certificateStore");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10XSCEPCertificateProfile");
        _x.certificateStore = certificateStore;
        return _x;
    }

    /**
     * <i>“Scale for the Certificate Validity Period”</i>
     * 
     * @return property certificateValidityPeriodScale
     */
    @Property(name="certificateValidityPeriodScale")
    @JsonIgnore
    public Optional<CertificateValidityPeriodScale> getCertificateValidityPeriodScale() {
        return Optional.ofNullable(certificateValidityPeriodScale);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateValidityPeriodScale} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Scale for the Certificate Validity Period”</i>
     * 
     * @param certificateValidityPeriodScale
     *            new value of {@code certificateValidityPeriodScale} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateValidityPeriodScale} field changed
     */
    public Windows10XSCEPCertificateProfile withCertificateValidityPeriodScale(CertificateValidityPeriodScale certificateValidityPeriodScale) {
        Windows10XSCEPCertificateProfile _x = _copy();
        _x.changedFields = changedFields.add("certificateValidityPeriodScale");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10XSCEPCertificateProfile");
        _x.certificateValidityPeriodScale = certificateValidityPeriodScale;
        return _x;
    }

    /**
     * <i>“Value for the Certificate Validity Period”</i>
     * 
     * @return property certificateValidityPeriodValue
     */
    @Property(name="certificateValidityPeriodValue")
    @JsonIgnore
    public Optional<Integer> getCertificateValidityPeriodValue() {
        return Optional.ofNullable(certificateValidityPeriodValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateValidityPeriodValue} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Value for the Certificate Validity Period”</i>
     * 
     * @param certificateValidityPeriodValue
     *            new value of {@code certificateValidityPeriodValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateValidityPeriodValue} field changed
     */
    public Windows10XSCEPCertificateProfile withCertificateValidityPeriodValue(Integer certificateValidityPeriodValue) {
        Windows10XSCEPCertificateProfile _x = _copy();
        _x.changedFields = changedFields.add("certificateValidityPeriodValue");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10XSCEPCertificateProfile");
        _x.certificateValidityPeriodValue = certificateValidityPeriodValue;
        return _x;
    }

    /**
     * <i>“Extended Key Usage (EKU) settings.”</i>
     * 
     * @return property extendedKeyUsages
     */
    @Property(name="extendedKeyUsages")
    @JsonIgnore
    public CollectionPage<ExtendedKeyUsage> getExtendedKeyUsages() {
        return new CollectionPage<ExtendedKeyUsage>(contextPath, ExtendedKeyUsage.class, this.extendedKeyUsages, Optional.ofNullable(extendedKeyUsagesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code extendedKeyUsages
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Extended Key Usage (EKU) settings.”</i>
     * 
     * @param extendedKeyUsages
     *            new value of {@code extendedKeyUsages} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code extendedKeyUsages} field changed
     */
    public Windows10XSCEPCertificateProfile withExtendedKeyUsages(List<ExtendedKeyUsage> extendedKeyUsages) {
        Windows10XSCEPCertificateProfile _x = _copy();
        _x.changedFields = changedFields.add("extendedKeyUsages");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10XSCEPCertificateProfile");
        _x.extendedKeyUsages = extendedKeyUsages;
        return _x;
    }

    /**
     * <i>“Extended Key Usage (EKU) settings.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property extendedKeyUsages
     */
    @Property(name="extendedKeyUsages")
    @JsonIgnore
    public CollectionPage<ExtendedKeyUsage> getExtendedKeyUsages(HttpRequestOptions options) {
        return new CollectionPage<ExtendedKeyUsage>(contextPath, ExtendedKeyUsage.class, this.extendedKeyUsages, Optional.ofNullable(extendedKeyUsagesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“SCEP Hash Algorithm.”</i>
     * 
     * @return property hashAlgorithm
     */
    @Property(name="hashAlgorithm")
    @JsonIgnore
    public CollectionPage<HashAlgorithms> getHashAlgorithm() {
        return new CollectionPage<HashAlgorithms>(contextPath, HashAlgorithms.class, this.hashAlgorithm, Optional.ofNullable(hashAlgorithmNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code hashAlgorithm}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“SCEP Hash Algorithm.”</i>
     * 
     * @param hashAlgorithm
     *            new value of {@code hashAlgorithm} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code hashAlgorithm} field changed
     */
    public Windows10XSCEPCertificateProfile withHashAlgorithm(List<HashAlgorithms> hashAlgorithm) {
        Windows10XSCEPCertificateProfile _x = _copy();
        _x.changedFields = changedFields.add("hashAlgorithm");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10XSCEPCertificateProfile");
        _x.hashAlgorithm = hashAlgorithm;
        return _x;
    }

    /**
     * <i>“SCEP Hash Algorithm.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property hashAlgorithm
     */
    @Property(name="hashAlgorithm")
    @JsonIgnore
    public CollectionPage<HashAlgorithms> getHashAlgorithm(HttpRequestOptions options) {
        return new CollectionPage<HashAlgorithms>(contextPath, HashAlgorithms.class, this.hashAlgorithm, Optional.ofNullable(hashAlgorithmNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“SCEP Key Size.”</i>
     * 
     * @return property keySize
     */
    @Property(name="keySize")
    @JsonIgnore
    public Optional<KeySize> getKeySize() {
        return Optional.ofNullable(keySize);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code keySize} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“SCEP Key Size.”</i>
     * 
     * @param keySize
     *            new value of {@code keySize} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code keySize} field changed
     */
    public Windows10XSCEPCertificateProfile withKeySize(KeySize keySize) {
        Windows10XSCEPCertificateProfile _x = _copy();
        _x.changedFields = changedFields.add("keySize");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10XSCEPCertificateProfile");
        _x.keySize = keySize;
        return _x;
    }

    /**
     * <i>“Key Storage Provider (KSP)”</i>
     * 
     * @return property keyStorageProvider
     */
    @Property(name="keyStorageProvider")
    @JsonIgnore
    public Optional<KeyStorageProviderOption> getKeyStorageProvider() {
        return Optional.ofNullable(keyStorageProvider);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * keyStorageProvider} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Key Storage Provider (KSP)”</i>
     * 
     * @param keyStorageProvider
     *            new value of {@code keyStorageProvider} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code keyStorageProvider} field changed
     */
    public Windows10XSCEPCertificateProfile withKeyStorageProvider(KeyStorageProviderOption keyStorageProvider) {
        Windows10XSCEPCertificateProfile _x = _copy();
        _x.changedFields = changedFields.add("keyStorageProvider");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10XSCEPCertificateProfile");
        _x.keyStorageProvider = keyStorageProvider;
        return _x;
    }

    /**
     * <i>“SCEP Key Usage.”</i>
     * 
     * @return property keyUsage
     */
    @Property(name="keyUsage")
    @JsonIgnore
    public Optional<KeyUsages> getKeyUsage() {
        return Optional.ofNullable(keyUsage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code keyUsage} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“SCEP Key Usage.”</i>
     * 
     * @param keyUsage
     *            new value of {@code keyUsage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code keyUsage} field changed
     */
    public Windows10XSCEPCertificateProfile withKeyUsage(KeyUsages keyUsage) {
        Windows10XSCEPCertificateProfile _x = _copy();
        _x.changedFields = changedFields.add("keyUsage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10XSCEPCertificateProfile");
        _x.keyUsage = keyUsage;
        return _x;
    }

    /**
     * <i>“Certificate renewal threshold percentage”</i>
     * 
     * @return property renewalThresholdPercentage
     */
    @Property(name="renewalThresholdPercentage")
    @JsonIgnore
    public Optional<Integer> getRenewalThresholdPercentage() {
        return Optional.ofNullable(renewalThresholdPercentage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * renewalThresholdPercentage} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Certificate renewal threshold percentage”</i>
     * 
     * @param renewalThresholdPercentage
     *            new value of {@code renewalThresholdPercentage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code renewalThresholdPercentage} field changed
     */
    public Windows10XSCEPCertificateProfile withRenewalThresholdPercentage(Integer renewalThresholdPercentage) {
        Windows10XSCEPCertificateProfile _x = _copy();
        _x.changedFields = changedFields.add("renewalThresholdPercentage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10XSCEPCertificateProfile");
        _x.renewalThresholdPercentage = renewalThresholdPercentage;
        return _x;
    }

    /**
     * <i>“Trusted Root Certificate ID”</i>
     * 
     * @return property rootCertificateId
     */
    @Property(name="rootCertificateId")
    @JsonIgnore
    public Optional<UUID> getRootCertificateId() {
        return Optional.ofNullable(rootCertificateId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code rootCertificateId
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Trusted Root Certificate ID”</i>
     * 
     * @param rootCertificateId
     *            new value of {@code rootCertificateId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code rootCertificateId} field changed
     */
    public Windows10XSCEPCertificateProfile withRootCertificateId(UUID rootCertificateId) {
        Windows10XSCEPCertificateProfile _x = _copy();
        _x.changedFields = changedFields.add("rootCertificateId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10XSCEPCertificateProfile");
        _x.rootCertificateId = rootCertificateId;
        return _x;
    }

    /**
     * <i>“SCEP Server Url(s).”</i>
     * 
     * @return property scepServerUrls
     */
    @Property(name="scepServerUrls")
    @JsonIgnore
    public CollectionPage<String> getScepServerUrls() {
        return new CollectionPage<String>(contextPath, String.class, this.scepServerUrls, Optional.ofNullable(scepServerUrlsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code scepServerUrls}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“SCEP Server Url(s).”</i>
     * 
     * @param scepServerUrls
     *            new value of {@code scepServerUrls} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code scepServerUrls} field changed
     */
    public Windows10XSCEPCertificateProfile withScepServerUrls(List<String> scepServerUrls) {
        Windows10XSCEPCertificateProfile _x = _copy();
        _x.changedFields = changedFields.add("scepServerUrls");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10XSCEPCertificateProfile");
        _x.scepServerUrls = scepServerUrls;
        return _x;
    }

    /**
     * <i>“SCEP Server Url(s).”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property scepServerUrls
     */
    @Property(name="scepServerUrls")
    @JsonIgnore
    public CollectionPage<String> getScepServerUrls(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.scepServerUrls, Optional.ofNullable(scepServerUrlsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Custom AAD Attributes.”</i>
     * 
     * @return property subjectAlternativeNameFormats
     */
    @Property(name="subjectAlternativeNameFormats")
    @JsonIgnore
    public CollectionPage<Windows10XCustomSubjectAlternativeName> getSubjectAlternativeNameFormats() {
        return new CollectionPage<Windows10XCustomSubjectAlternativeName>(contextPath, Windows10XCustomSubjectAlternativeName.class, this.subjectAlternativeNameFormats, Optional.ofNullable(subjectAlternativeNameFormatsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * subjectAlternativeNameFormats} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Custom AAD Attributes.”</i>
     * 
     * @param subjectAlternativeNameFormats
     *            new value of {@code subjectAlternativeNameFormats} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code subjectAlternativeNameFormats} field changed
     */
    public Windows10XSCEPCertificateProfile withSubjectAlternativeNameFormats(List<Windows10XCustomSubjectAlternativeName> subjectAlternativeNameFormats) {
        Windows10XSCEPCertificateProfile _x = _copy();
        _x.changedFields = changedFields.add("subjectAlternativeNameFormats");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10XSCEPCertificateProfile");
        _x.subjectAlternativeNameFormats = subjectAlternativeNameFormats;
        return _x;
    }

    /**
     * <i>“Custom AAD Attributes.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property subjectAlternativeNameFormats
     */
    @Property(name="subjectAlternativeNameFormats")
    @JsonIgnore
    public CollectionPage<Windows10XCustomSubjectAlternativeName> getSubjectAlternativeNameFormats(HttpRequestOptions options) {
        return new CollectionPage<Windows10XCustomSubjectAlternativeName>(contextPath, Windows10XCustomSubjectAlternativeName.class, this.subjectAlternativeNameFormats, Optional.ofNullable(subjectAlternativeNameFormatsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Custom format to use with SubjectNameFormat = Custom. Example: CN={{EmailAddress
     * }},E={{EmailAddress}},OU=Enterprise Users,O=Contoso Corporation,L=Redmond,ST=WA,
     * C=US”</i>
     * 
     * @return property subjectNameFormatString
     */
    @Property(name="subjectNameFormatString")
    @JsonIgnore
    public Optional<String> getSubjectNameFormatString() {
        return Optional.ofNullable(subjectNameFormatString);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * subjectNameFormatString} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Custom format to use with SubjectNameFormat = Custom. Example: CN={{EmailAddress
     * }},E={{EmailAddress}},OU=Enterprise Users,O=Contoso Corporation,L=Redmond,ST=WA,
     * C=US”</i>
     * 
     * @param subjectNameFormatString
     *            new value of {@code subjectNameFormatString} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code subjectNameFormatString} field changed
     */
    public Windows10XSCEPCertificateProfile withSubjectNameFormatString(String subjectNameFormatString) {
        Windows10XSCEPCertificateProfile _x = _copy();
        _x.changedFields = changedFields.add("subjectNameFormatString");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10XSCEPCertificateProfile");
        _x.subjectNameFormatString = subjectNameFormatString;
        return _x;
    }

    public Windows10XSCEPCertificateProfile withUnmappedField(String name, Object value) {
        Windows10XSCEPCertificateProfile _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows10XSCEPCertificateProfile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Windows10XSCEPCertificateProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows10XSCEPCertificateProfile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Windows10XSCEPCertificateProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Windows10XSCEPCertificateProfile _copy() {
        Windows10XSCEPCertificateProfile _x = new Windows10XSCEPCertificateProfile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.creationDateTime = creationDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.version = version;
        _x.assignments = assignments;
        _x.certificateStore = certificateStore;
        _x.certificateValidityPeriodScale = certificateValidityPeriodScale;
        _x.certificateValidityPeriodValue = certificateValidityPeriodValue;
        _x.extendedKeyUsages = extendedKeyUsages;
        _x.hashAlgorithm = hashAlgorithm;
        _x.keySize = keySize;
        _x.keyStorageProvider = keyStorageProvider;
        _x.keyUsage = keyUsage;
        _x.renewalThresholdPercentage = renewalThresholdPercentage;
        _x.rootCertificateId = rootCertificateId;
        _x.scepServerUrls = scepServerUrls;
        _x.subjectAlternativeNameFormats = subjectAlternativeNameFormats;
        _x.subjectNameFormatString = subjectNameFormatString;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Windows10XSCEPCertificateProfile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("creationDateTime=");
        b.append(this.creationDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("certificateStore=");
        b.append(this.certificateStore);
        b.append(", ");
        b.append("certificateValidityPeriodScale=");
        b.append(this.certificateValidityPeriodScale);
        b.append(", ");
        b.append("certificateValidityPeriodValue=");
        b.append(this.certificateValidityPeriodValue);
        b.append(", ");
        b.append("extendedKeyUsages=");
        b.append(this.extendedKeyUsages);
        b.append(", ");
        b.append("hashAlgorithm=");
        b.append(this.hashAlgorithm);
        b.append(", ");
        b.append("keySize=");
        b.append(this.keySize);
        b.append(", ");
        b.append("keyStorageProvider=");
        b.append(this.keyStorageProvider);
        b.append(", ");
        b.append("keyUsage=");
        b.append(this.keyUsage);
        b.append(", ");
        b.append("renewalThresholdPercentage=");
        b.append(this.renewalThresholdPercentage);
        b.append(", ");
        b.append("rootCertificateId=");
        b.append(this.rootCertificateId);
        b.append(", ");
        b.append("scepServerUrls=");
        b.append(this.scepServerUrls);
        b.append(", ");
        b.append("subjectAlternativeNameFormats=");
        b.append(this.subjectAlternativeNameFormats);
        b.append(", ");
        b.append("subjectNameFormatString=");
        b.append(this.subjectNameFormatString);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
