package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DefenderDetectedMalwareActions;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.complex.EdgeHomeButtonConfiguration;
import odata.msgraph.client.beta.complex.EdgeSearchEngineBase;
import odata.msgraph.client.beta.complex.Windows10AppsForceUpdateSchedule;
import odata.msgraph.client.beta.complex.Windows10NetworkProxyServer;
import odata.msgraph.client.beta.entity.collection.request.WindowsPrivacyDataAccessControlItemCollectionRequest;
import odata.msgraph.client.beta.enums.AppInstallControlType;
import odata.msgraph.client.beta.enums.BrowserSyncSetting;
import odata.msgraph.client.beta.enums.ConfigurationUsage;
import odata.msgraph.client.beta.enums.DefenderCloudBlockLevelType;
import odata.msgraph.client.beta.enums.DefenderMonitorFileActivity;
import odata.msgraph.client.beta.enums.DefenderPotentiallyUnwantedAppAction;
import odata.msgraph.client.beta.enums.DefenderPromptForSampleSubmission;
import odata.msgraph.client.beta.enums.DefenderProtectionType;
import odata.msgraph.client.beta.enums.DefenderScanType;
import odata.msgraph.client.beta.enums.DefenderSubmitSamplesConsentType;
import odata.msgraph.client.beta.enums.DiagnosticDataSubmissionMode;
import odata.msgraph.client.beta.enums.EdgeCookiePolicy;
import odata.msgraph.client.beta.enums.EdgeKioskModeRestrictionType;
import odata.msgraph.client.beta.enums.EdgeOpenOptions;
import odata.msgraph.client.beta.enums.EdgeTelemetryMode;
import odata.msgraph.client.beta.enums.Enablement;
import odata.msgraph.client.beta.enums.InkAccessSetting;
import odata.msgraph.client.beta.enums.InternetExplorerMessageSetting;
import odata.msgraph.client.beta.enums.PowerActionType;
import odata.msgraph.client.beta.enums.RequiredPasswordType;
import odata.msgraph.client.beta.enums.SafeSearchFilterType;
import odata.msgraph.client.beta.enums.SignInAssistantOptions;
import odata.msgraph.client.beta.enums.StateManagementSetting;
import odata.msgraph.client.beta.enums.VisibilitySetting;
import odata.msgraph.client.beta.enums.WeeklySchedule;
import odata.msgraph.client.beta.enums.WindowsSpotlightEnablementSettings;
import odata.msgraph.client.beta.enums.WindowsStartMenuAppListVisibilityType;
import odata.msgraph.client.beta.enums.WindowsStartMenuModeType;


/**
 * <i>“This topic provides descriptions of the declared methods, properties and
 * relationships exposed by the windows10GeneralConfiguration resource.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "accountsBlockAddingNonMicrosoftAccountEmail", 
    "activateAppsWithVoice", 
    "antiTheftModeBlocked", 
    "appManagementMSIAllowUserControlOverInstall", 
    "appManagementMSIAlwaysInstallWithElevatedPrivileges", 
    "appManagementPackageFamilyNamesToLaunchAfterLogOn", 
    "appsAllowTrustedAppsSideloading", 
    "appsBlockWindowsStoreOriginatedApps", 
    "authenticationAllowSecondaryDevice", 
    "authenticationPreferredAzureADTenantDomainName", 
    "authenticationWebSignIn", 
    "bluetoothAllowedServices", 
    "bluetoothBlockAdvertising", 
    "bluetoothBlockDiscoverableMode", 
    "bluetoothBlocked", 
    "bluetoothBlockPrePairing", 
    "bluetoothBlockPromptedProximalConnections", 
    "cameraBlocked", 
    "cellularBlockDataWhenRoaming", 
    "cellularBlockVpn", 
    "cellularBlockVpnWhenRoaming", 
    "cellularData", 
    "certificatesBlockManualRootCertificateInstallation", 
    "configureTimeZone", 
    "connectedDevicesServiceBlocked", 
    "copyPasteBlocked", 
    "cortanaBlocked", 
    "cryptographyAllowFipsAlgorithmPolicy", 
    "dataProtectionBlockDirectMemoryAccess", 
    "defenderBlockEndUserAccess", 
    "defenderBlockOnAccessProtection", 
    "defenderCloudBlockLevel", 
    "defenderCloudExtendedTimeout", 
    "defenderCloudExtendedTimeoutInSeconds", 
    "defenderDaysBeforeDeletingQuarantinedMalware", 
    "defenderDetectedMalwareActions", 
    "defenderDisableCatchupFullScan", 
    "defenderDisableCatchupQuickScan", 
    "defenderFileExtensionsToExclude", 
    "defenderFilesAndFoldersToExclude", 
    "defenderMonitorFileActivity", 
    "defenderPotentiallyUnwantedAppAction", 
    "defenderPotentiallyUnwantedAppActionSetting", 
    "defenderProcessesToExclude", 
    "defenderPromptForSampleSubmission", 
    "defenderRequireBehaviorMonitoring", 
    "defenderRequireCloudProtection", 
    "defenderRequireNetworkInspectionSystem", 
    "defenderRequireRealTimeMonitoring", 
    "defenderScanArchiveFiles", 
    "defenderScanDownloads", 
    "defenderScanIncomingMail", 
    "defenderScanMappedNetworkDrivesDuringFullScan", 
    "defenderScanMaxCpu", 
    "defenderScanNetworkFiles", 
    "defenderScanRemovableDrivesDuringFullScan", 
    "defenderScanScriptsLoadedInInternetExplorer", 
    "defenderScanType", 
    "defenderScheduledQuickScanTime", 
    "defenderScheduledScanTime", 
    "defenderScheduleScanEnableLowCpuPriority", 
    "defenderSignatureUpdateIntervalInHours", 
    "defenderSubmitSamplesConsentType", 
    "defenderSystemScanSchedule", 
    "developerUnlockSetting", 
    "deviceManagementBlockFactoryResetOnMobile", 
    "deviceManagementBlockManualUnenroll", 
    "diagnosticsDataSubmissionMode", 
    "displayAppListWithGdiDPIScalingTurnedOff", 
    "displayAppListWithGdiDPIScalingTurnedOn", 
    "edgeAllowStartPagesModification", 
    "edgeBlockAccessToAboutFlags", 
    "edgeBlockAddressBarDropdown", 
    "edgeBlockAutofill", 
    "edgeBlockCompatibilityList", 
    "edgeBlockDeveloperTools", 
    "edgeBlocked", 
    "edgeBlockEditFavorites", 
    "edgeBlockExtensions", 
    "edgeBlockFullScreenMode", 
    "edgeBlockInPrivateBrowsing", 
    "edgeBlockJavaScript", 
    "edgeBlockLiveTileDataCollection", 
    "edgeBlockPasswordManager", 
    "edgeBlockPopups", 
    "edgeBlockPrelaunch", 
    "edgeBlockPrinting", 
    "edgeBlockSavingHistory", 
    "edgeBlockSearchEngineCustomization", 
    "edgeBlockSearchSuggestions", 
    "edgeBlockSendingDoNotTrackHeader", 
    "edgeBlockSendingIntranetTrafficToInternetExplorer", 
    "edgeBlockSideloadingExtensions", 
    "edgeBlockTabPreloading", 
    "edgeBlockWebContentOnNewTabPage", 
    "edgeClearBrowsingDataOnExit", 
    "edgeCookiePolicy", 
    "edgeDisableFirstRunPage", 
    "edgeEnterpriseModeSiteListLocation", 
    "edgeFavoritesBarVisibility", 
    "edgeFavoritesListLocation", 
    "edgeFirstRunUrl", 
    "edgeHomeButtonConfiguration", 
    "edgeHomeButtonConfigurationEnabled", 
    "edgeHomepageUrls", 
    "edgeKioskModeRestriction", 
    "edgeKioskResetAfterIdleTimeInMinutes", 
    "edgeNewTabPageURL", 
    "edgeOpensWith", 
    "edgePreventCertificateErrorOverride", 
    "edgeRequiredExtensionPackageFamilyNames", 
    "edgeRequireSmartScreen", 
    "edgeSearchEngine", 
    "edgeSendIntranetTrafficToInternetExplorer", 
    "edgeShowMessageWhenOpeningInternetExplorerSites", 
    "edgeSyncFavoritesWithInternetExplorer", 
    "edgeTelemetryForMicrosoft365Analytics", 
    "enableAutomaticRedeployment", 
    "energySaverOnBatteryThresholdPercentage", 
    "energySaverPluggedInThresholdPercentage", 
    "enterpriseCloudPrintDiscoveryEndPoint", 
    "enterpriseCloudPrintDiscoveryMaxLimit", 
    "enterpriseCloudPrintMopriaDiscoveryResourceIdentifier", 
    "enterpriseCloudPrintOAuthAuthority", 
    "enterpriseCloudPrintOAuthClientIdentifier", 
    "enterpriseCloudPrintResourceIdentifier", 
    "experienceBlockDeviceDiscovery", 
    "experienceBlockErrorDialogWhenNoSIM", 
    "experienceBlockTaskSwitcher", 
    "experienceDoNotSyncBrowserSettings", 
    "findMyFiles", 
    "gameDvrBlocked", 
    "inkWorkspaceAccess", 
    "inkWorkspaceAccessState", 
    "inkWorkspaceBlockSuggestedApps", 
    "internetSharingBlocked", 
    "locationServicesBlocked", 
    "lockScreenActivateAppsWithVoice", 
    "lockScreenAllowTimeoutConfiguration", 
    "lockScreenBlockActionCenterNotifications", 
    "lockScreenBlockCortana", 
    "lockScreenBlockToastNotifications", 
    "lockScreenTimeoutInSeconds", 
    "logonBlockFastUserSwitching", 
    "messagingBlockMMS", 
    "messagingBlockRichCommunicationServices", 
    "messagingBlockSync", 
    "microsoftAccountBlocked", 
    "microsoftAccountBlockSettingsSync", 
    "microsoftAccountSignInAssistantSettings", 
    "networkProxyApplySettingsDeviceWide", 
    "networkProxyAutomaticConfigurationUrl", 
    "networkProxyDisableAutoDetect", 
    "networkProxyServer", 
    "nfcBlocked", 
    "oneDriveDisableFileSync", 
    "passwordBlockSimple", 
    "passwordExpirationDays", 
    "passwordMinimumAgeInDays", 
    "passwordMinimumCharacterSetCount", 
    "passwordMinimumLength", 
    "passwordMinutesOfInactivityBeforeScreenTimeout", 
    "passwordPreviousPasswordBlockCount", 
    "passwordRequired", 
    "passwordRequiredType", 
    "passwordRequireWhenResumeFromIdleState", 
    "passwordSignInFailureCountBeforeFactoryReset", 
    "personalizationDesktopImageUrl", 
    "personalizationLockScreenImageUrl", 
    "powerButtonActionOnBattery", 
    "powerButtonActionPluggedIn", 
    "powerHybridSleepOnBattery", 
    "powerHybridSleepPluggedIn", 
    "powerLidCloseActionOnBattery", 
    "powerLidCloseActionPluggedIn", 
    "powerSleepButtonActionOnBattery", 
    "powerSleepButtonActionPluggedIn", 
    "printerBlockAddition", 
    "printerDefaultName", 
    "printerNames", 
    "privacyAdvertisingId", 
    "privacyAutoAcceptPairingAndConsentPrompts", 
    "privacyBlockActivityFeed", 
    "privacyBlockInputPersonalization", 
    "privacyBlockPublishUserActivities", 
    "privacyDisableLaunchExperience", 
    "resetProtectionModeBlocked", 
    "safeSearchFilter", 
    "screenCaptureBlocked", 
    "searchBlockDiacritics", 
    "searchBlockWebResults", 
    "searchDisableAutoLanguageDetection", 
    "searchDisableIndexerBackoff", 
    "searchDisableIndexingEncryptedItems", 
    "searchDisableIndexingRemovableDrive", 
    "searchDisableLocation", 
    "searchDisableUseLocation", 
    "searchEnableAutomaticIndexSizeManangement", 
    "searchEnableRemoteQueries", 
    "securityBlockAzureADJoinedDevicesAutoEncryption", 
    "settingsBlockAccountsPage", 
    "settingsBlockAddProvisioningPackage", 
    "settingsBlockAppsPage", 
    "settingsBlockChangeLanguage", 
    "settingsBlockChangePowerSleep", 
    "settingsBlockChangeRegion", 
    "settingsBlockChangeSystemTime", 
    "settingsBlockDevicesPage", 
    "settingsBlockEaseOfAccessPage", 
    "settingsBlockEditDeviceName", 
    "settingsBlockGamingPage", 
    "settingsBlockNetworkInternetPage", 
    "settingsBlockPersonalizationPage", 
    "settingsBlockPrivacyPage", 
    "settingsBlockRemoveProvisioningPackage", 
    "settingsBlockSettingsApp", 
    "settingsBlockSystemPage", 
    "settingsBlockTimeLanguagePage", 
    "settingsBlockUpdateSecurityPage", 
    "sharedUserAppDataAllowed", 
    "smartScreenAppInstallControl", 
    "smartScreenBlockPromptOverride", 
    "smartScreenBlockPromptOverrideForFiles", 
    "smartScreenEnableAppInstallControl", 
    "startBlockUnpinningAppsFromTaskbar", 
    "startMenuAppListVisibility", 
    "startMenuHideChangeAccountSettings", 
    "startMenuHideFrequentlyUsedApps", 
    "startMenuHideHibernate", 
    "startMenuHideLock", 
    "startMenuHidePowerButton", 
    "startMenuHideRecentJumpLists", 
    "startMenuHideRecentlyAddedApps", 
    "startMenuHideRestartOptions", 
    "startMenuHideShutDown", 
    "startMenuHideSignOut", 
    "startMenuHideSleep", 
    "startMenuHideSwitchAccount", 
    "startMenuHideUserTile", 
    "startMenuLayoutEdgeAssetsXml", 
    "startMenuLayoutXml", 
    "startMenuMode", 
    "startMenuPinnedFolderDocuments", 
    "startMenuPinnedFolderDownloads", 
    "startMenuPinnedFolderFileExplorer", 
    "startMenuPinnedFolderHomeGroup", 
    "startMenuPinnedFolderMusic", 
    "startMenuPinnedFolderNetwork", 
    "startMenuPinnedFolderPersonalFolder", 
    "startMenuPinnedFolderPictures", 
    "startMenuPinnedFolderSettings", 
    "startMenuPinnedFolderVideos", 
    "storageBlockRemovableStorage", 
    "storageRequireMobileDeviceEncryption", 
    "storageRestrictAppDataToSystemVolume", 
    "storageRestrictAppInstallToSystemVolume", 
    "systemTelemetryProxyServer", 
    "taskManagerBlockEndTask", 
    "tenantLockdownRequireNetworkDuringOutOfBoxExperience", 
    "uninstallBuiltInApps", 
    "usbBlocked", 
    "voiceRecordingBlocked", 
    "webRtcBlockLocalhostIpAddress", 
    "wiFiBlockAutomaticConnectHotspots", 
    "wiFiBlocked", 
    "wiFiBlockManualConfiguration", 
    "wiFiScanInterval", 
    "windows10AppsForceUpdateSchedule", 
    "windowsSpotlightBlockConsumerSpecificFeatures", 
    "windowsSpotlightBlocked", 
    "windowsSpotlightBlockOnActionCenter", 
    "windowsSpotlightBlockTailoredExperiences", 
    "windowsSpotlightBlockThirdPartyNotifications", 
    "windowsSpotlightBlockWelcomeExperience", 
    "windowsSpotlightBlockWindowsTips", 
    "windowsSpotlightConfigureOnLockScreen", 
    "windowsStoreBlockAutoUpdate", 
    "windowsStoreBlocked", 
    "windowsStoreEnablePrivateStoreOnly", 
    "wirelessDisplayBlockProjectionToThisDevice", 
    "wirelessDisplayBlockUserInputFromReceiver", 
    "wirelessDisplayRequirePinForPairing", 
    "privacyAccessControls"})
@JsonInclude(Include.NON_NULL)
public class Windows10GeneralConfiguration extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windows10GeneralConfiguration";
    }

    @JsonProperty("accountsBlockAddingNonMicrosoftAccountEmail")
    protected Boolean accountsBlockAddingNonMicrosoftAccountEmail;

    @JsonProperty("activateAppsWithVoice")
    protected Enablement activateAppsWithVoice;

    @JsonProperty("antiTheftModeBlocked")
    protected Boolean antiTheftModeBlocked;

    @JsonProperty("appManagementMSIAllowUserControlOverInstall")
    protected Boolean appManagementMSIAllowUserControlOverInstall;

    @JsonProperty("appManagementMSIAlwaysInstallWithElevatedPrivileges")
    protected Boolean appManagementMSIAlwaysInstallWithElevatedPrivileges;

    @JsonProperty("appManagementPackageFamilyNamesToLaunchAfterLogOn")
    protected List<String> appManagementPackageFamilyNamesToLaunchAfterLogOn;

    @JsonProperty("appManagementPackageFamilyNamesToLaunchAfterLogOn@nextLink")
    protected String appManagementPackageFamilyNamesToLaunchAfterLogOnNextLink;

    @JsonProperty("appsAllowTrustedAppsSideloading")
    protected StateManagementSetting appsAllowTrustedAppsSideloading;

    @JsonProperty("appsBlockWindowsStoreOriginatedApps")
    protected Boolean appsBlockWindowsStoreOriginatedApps;

    @JsonProperty("authenticationAllowSecondaryDevice")
    protected Boolean authenticationAllowSecondaryDevice;

    @JsonProperty("authenticationPreferredAzureADTenantDomainName")
    protected String authenticationPreferredAzureADTenantDomainName;

    @JsonProperty("authenticationWebSignIn")
    protected Enablement authenticationWebSignIn;

    @JsonProperty("bluetoothAllowedServices")
    protected List<String> bluetoothAllowedServices;

    @JsonProperty("bluetoothAllowedServices@nextLink")
    protected String bluetoothAllowedServicesNextLink;

    @JsonProperty("bluetoothBlockAdvertising")
    protected Boolean bluetoothBlockAdvertising;

    @JsonProperty("bluetoothBlockDiscoverableMode")
    protected Boolean bluetoothBlockDiscoverableMode;

    @JsonProperty("bluetoothBlocked")
    protected Boolean bluetoothBlocked;

    @JsonProperty("bluetoothBlockPrePairing")
    protected Boolean bluetoothBlockPrePairing;

    @JsonProperty("bluetoothBlockPromptedProximalConnections")
    protected Boolean bluetoothBlockPromptedProximalConnections;

    @JsonProperty("cameraBlocked")
    protected Boolean cameraBlocked;

    @JsonProperty("cellularBlockDataWhenRoaming")
    protected Boolean cellularBlockDataWhenRoaming;

    @JsonProperty("cellularBlockVpn")
    protected Boolean cellularBlockVpn;

    @JsonProperty("cellularBlockVpnWhenRoaming")
    protected Boolean cellularBlockVpnWhenRoaming;

    @JsonProperty("cellularData")
    protected ConfigurationUsage cellularData;

    @JsonProperty("certificatesBlockManualRootCertificateInstallation")
    protected Boolean certificatesBlockManualRootCertificateInstallation;

    @JsonProperty("configureTimeZone")
    protected String configureTimeZone;

    @JsonProperty("connectedDevicesServiceBlocked")
    protected Boolean connectedDevicesServiceBlocked;

    @JsonProperty("copyPasteBlocked")
    protected Boolean copyPasteBlocked;

    @JsonProperty("cortanaBlocked")
    protected Boolean cortanaBlocked;

    @JsonProperty("cryptographyAllowFipsAlgorithmPolicy")
    protected Boolean cryptographyAllowFipsAlgorithmPolicy;

    @JsonProperty("dataProtectionBlockDirectMemoryAccess")
    protected Boolean dataProtectionBlockDirectMemoryAccess;

    @JsonProperty("defenderBlockEndUserAccess")
    protected Boolean defenderBlockEndUserAccess;

    @JsonProperty("defenderBlockOnAccessProtection")
    protected Boolean defenderBlockOnAccessProtection;

    @JsonProperty("defenderCloudBlockLevel")
    protected DefenderCloudBlockLevelType defenderCloudBlockLevel;

    @JsonProperty("defenderCloudExtendedTimeout")
    protected Integer defenderCloudExtendedTimeout;

    @JsonProperty("defenderCloudExtendedTimeoutInSeconds")
    protected Integer defenderCloudExtendedTimeoutInSeconds;

    @JsonProperty("defenderDaysBeforeDeletingQuarantinedMalware")
    protected Integer defenderDaysBeforeDeletingQuarantinedMalware;

    @JsonProperty("defenderDetectedMalwareActions")
    protected DefenderDetectedMalwareActions defenderDetectedMalwareActions;

    @JsonProperty("defenderDisableCatchupFullScan")
    protected Boolean defenderDisableCatchupFullScan;

    @JsonProperty("defenderDisableCatchupQuickScan")
    protected Boolean defenderDisableCatchupQuickScan;

    @JsonProperty("defenderFileExtensionsToExclude")
    protected List<String> defenderFileExtensionsToExclude;

    @JsonProperty("defenderFileExtensionsToExclude@nextLink")
    protected String defenderFileExtensionsToExcludeNextLink;

    @JsonProperty("defenderFilesAndFoldersToExclude")
    protected List<String> defenderFilesAndFoldersToExclude;

    @JsonProperty("defenderFilesAndFoldersToExclude@nextLink")
    protected String defenderFilesAndFoldersToExcludeNextLink;

    @JsonProperty("defenderMonitorFileActivity")
    protected DefenderMonitorFileActivity defenderMonitorFileActivity;

    @JsonProperty("defenderPotentiallyUnwantedAppAction")
    protected DefenderPotentiallyUnwantedAppAction defenderPotentiallyUnwantedAppAction;

    @JsonProperty("defenderPotentiallyUnwantedAppActionSetting")
    protected DefenderProtectionType defenderPotentiallyUnwantedAppActionSetting;

    @JsonProperty("defenderProcessesToExclude")
    protected List<String> defenderProcessesToExclude;

    @JsonProperty("defenderProcessesToExclude@nextLink")
    protected String defenderProcessesToExcludeNextLink;

    @JsonProperty("defenderPromptForSampleSubmission")
    protected DefenderPromptForSampleSubmission defenderPromptForSampleSubmission;

    @JsonProperty("defenderRequireBehaviorMonitoring")
    protected Boolean defenderRequireBehaviorMonitoring;

    @JsonProperty("defenderRequireCloudProtection")
    protected Boolean defenderRequireCloudProtection;

    @JsonProperty("defenderRequireNetworkInspectionSystem")
    protected Boolean defenderRequireNetworkInspectionSystem;

    @JsonProperty("defenderRequireRealTimeMonitoring")
    protected Boolean defenderRequireRealTimeMonitoring;

    @JsonProperty("defenderScanArchiveFiles")
    protected Boolean defenderScanArchiveFiles;

    @JsonProperty("defenderScanDownloads")
    protected Boolean defenderScanDownloads;

    @JsonProperty("defenderScanIncomingMail")
    protected Boolean defenderScanIncomingMail;

    @JsonProperty("defenderScanMappedNetworkDrivesDuringFullScan")
    protected Boolean defenderScanMappedNetworkDrivesDuringFullScan;

    @JsonProperty("defenderScanMaxCpu")
    protected Integer defenderScanMaxCpu;

    @JsonProperty("defenderScanNetworkFiles")
    protected Boolean defenderScanNetworkFiles;

    @JsonProperty("defenderScanRemovableDrivesDuringFullScan")
    protected Boolean defenderScanRemovableDrivesDuringFullScan;

    @JsonProperty("defenderScanScriptsLoadedInInternetExplorer")
    protected Boolean defenderScanScriptsLoadedInInternetExplorer;

    @JsonProperty("defenderScanType")
    protected DefenderScanType defenderScanType;

    @JsonProperty("defenderScheduledQuickScanTime")
    protected LocalTime defenderScheduledQuickScanTime;

    @JsonProperty("defenderScheduledScanTime")
    protected LocalTime defenderScheduledScanTime;

    @JsonProperty("defenderScheduleScanEnableLowCpuPriority")
    protected Boolean defenderScheduleScanEnableLowCpuPriority;

    @JsonProperty("defenderSignatureUpdateIntervalInHours")
    protected Integer defenderSignatureUpdateIntervalInHours;

    @JsonProperty("defenderSubmitSamplesConsentType")
    protected DefenderSubmitSamplesConsentType defenderSubmitSamplesConsentType;

    @JsonProperty("defenderSystemScanSchedule")
    protected WeeklySchedule defenderSystemScanSchedule;

    @JsonProperty("developerUnlockSetting")
    protected StateManagementSetting developerUnlockSetting;

    @JsonProperty("deviceManagementBlockFactoryResetOnMobile")
    protected Boolean deviceManagementBlockFactoryResetOnMobile;

    @JsonProperty("deviceManagementBlockManualUnenroll")
    protected Boolean deviceManagementBlockManualUnenroll;

    @JsonProperty("diagnosticsDataSubmissionMode")
    protected DiagnosticDataSubmissionMode diagnosticsDataSubmissionMode;

    @JsonProperty("displayAppListWithGdiDPIScalingTurnedOff")
    protected List<String> displayAppListWithGdiDPIScalingTurnedOff;

    @JsonProperty("displayAppListWithGdiDPIScalingTurnedOff@nextLink")
    protected String displayAppListWithGdiDPIScalingTurnedOffNextLink;

    @JsonProperty("displayAppListWithGdiDPIScalingTurnedOn")
    protected List<String> displayAppListWithGdiDPIScalingTurnedOn;

    @JsonProperty("displayAppListWithGdiDPIScalingTurnedOn@nextLink")
    protected String displayAppListWithGdiDPIScalingTurnedOnNextLink;

    @JsonProperty("edgeAllowStartPagesModification")
    protected Boolean edgeAllowStartPagesModification;

    @JsonProperty("edgeBlockAccessToAboutFlags")
    protected Boolean edgeBlockAccessToAboutFlags;

    @JsonProperty("edgeBlockAddressBarDropdown")
    protected Boolean edgeBlockAddressBarDropdown;

    @JsonProperty("edgeBlockAutofill")
    protected Boolean edgeBlockAutofill;

    @JsonProperty("edgeBlockCompatibilityList")
    protected Boolean edgeBlockCompatibilityList;

    @JsonProperty("edgeBlockDeveloperTools")
    protected Boolean edgeBlockDeveloperTools;

    @JsonProperty("edgeBlocked")
    protected Boolean edgeBlocked;

    @JsonProperty("edgeBlockEditFavorites")
    protected Boolean edgeBlockEditFavorites;

    @JsonProperty("edgeBlockExtensions")
    protected Boolean edgeBlockExtensions;

    @JsonProperty("edgeBlockFullScreenMode")
    protected Boolean edgeBlockFullScreenMode;

    @JsonProperty("edgeBlockInPrivateBrowsing")
    protected Boolean edgeBlockInPrivateBrowsing;

    @JsonProperty("edgeBlockJavaScript")
    protected Boolean edgeBlockJavaScript;

    @JsonProperty("edgeBlockLiveTileDataCollection")
    protected Boolean edgeBlockLiveTileDataCollection;

    @JsonProperty("edgeBlockPasswordManager")
    protected Boolean edgeBlockPasswordManager;

    @JsonProperty("edgeBlockPopups")
    protected Boolean edgeBlockPopups;

    @JsonProperty("edgeBlockPrelaunch")
    protected Boolean edgeBlockPrelaunch;

    @JsonProperty("edgeBlockPrinting")
    protected Boolean edgeBlockPrinting;

    @JsonProperty("edgeBlockSavingHistory")
    protected Boolean edgeBlockSavingHistory;

    @JsonProperty("edgeBlockSearchEngineCustomization")
    protected Boolean edgeBlockSearchEngineCustomization;

    @JsonProperty("edgeBlockSearchSuggestions")
    protected Boolean edgeBlockSearchSuggestions;

    @JsonProperty("edgeBlockSendingDoNotTrackHeader")
    protected Boolean edgeBlockSendingDoNotTrackHeader;

    @JsonProperty("edgeBlockSendingIntranetTrafficToInternetExplorer")
    protected Boolean edgeBlockSendingIntranetTrafficToInternetExplorer;

    @JsonProperty("edgeBlockSideloadingExtensions")
    protected Boolean edgeBlockSideloadingExtensions;

    @JsonProperty("edgeBlockTabPreloading")
    protected Boolean edgeBlockTabPreloading;

    @JsonProperty("edgeBlockWebContentOnNewTabPage")
    protected Boolean edgeBlockWebContentOnNewTabPage;

    @JsonProperty("edgeClearBrowsingDataOnExit")
    protected Boolean edgeClearBrowsingDataOnExit;

    @JsonProperty("edgeCookiePolicy")
    protected EdgeCookiePolicy edgeCookiePolicy;

    @JsonProperty("edgeDisableFirstRunPage")
    protected Boolean edgeDisableFirstRunPage;

    @JsonProperty("edgeEnterpriseModeSiteListLocation")
    protected String edgeEnterpriseModeSiteListLocation;

    @JsonProperty("edgeFavoritesBarVisibility")
    protected VisibilitySetting edgeFavoritesBarVisibility;

    @JsonProperty("edgeFavoritesListLocation")
    protected String edgeFavoritesListLocation;

    @JsonProperty("edgeFirstRunUrl")
    protected String edgeFirstRunUrl;

    @JsonProperty("edgeHomeButtonConfiguration")
    protected EdgeHomeButtonConfiguration edgeHomeButtonConfiguration;

    @JsonProperty("edgeHomeButtonConfigurationEnabled")
    protected Boolean edgeHomeButtonConfigurationEnabled;

    @JsonProperty("edgeHomepageUrls")
    protected List<String> edgeHomepageUrls;

    @JsonProperty("edgeHomepageUrls@nextLink")
    protected String edgeHomepageUrlsNextLink;

    @JsonProperty("edgeKioskModeRestriction")
    protected EdgeKioskModeRestrictionType edgeKioskModeRestriction;

    @JsonProperty("edgeKioskResetAfterIdleTimeInMinutes")
    protected Integer edgeKioskResetAfterIdleTimeInMinutes;

    @JsonProperty("edgeNewTabPageURL")
    protected String edgeNewTabPageURL;

    @JsonProperty("edgeOpensWith")
    protected EdgeOpenOptions edgeOpensWith;

    @JsonProperty("edgePreventCertificateErrorOverride")
    protected Boolean edgePreventCertificateErrorOverride;

    @JsonProperty("edgeRequiredExtensionPackageFamilyNames")
    protected List<String> edgeRequiredExtensionPackageFamilyNames;

    @JsonProperty("edgeRequiredExtensionPackageFamilyNames@nextLink")
    protected String edgeRequiredExtensionPackageFamilyNamesNextLink;

    @JsonProperty("edgeRequireSmartScreen")
    protected Boolean edgeRequireSmartScreen;

    @JsonProperty("edgeSearchEngine")
    protected EdgeSearchEngineBase edgeSearchEngine;

    @JsonProperty("edgeSendIntranetTrafficToInternetExplorer")
    protected Boolean edgeSendIntranetTrafficToInternetExplorer;

    @JsonProperty("edgeShowMessageWhenOpeningInternetExplorerSites")
    protected InternetExplorerMessageSetting edgeShowMessageWhenOpeningInternetExplorerSites;

    @JsonProperty("edgeSyncFavoritesWithInternetExplorer")
    protected Boolean edgeSyncFavoritesWithInternetExplorer;

    @JsonProperty("edgeTelemetryForMicrosoft365Analytics")
    protected EdgeTelemetryMode edgeTelemetryForMicrosoft365Analytics;

    @JsonProperty("enableAutomaticRedeployment")
    protected Boolean enableAutomaticRedeployment;

    @JsonProperty("energySaverOnBatteryThresholdPercentage")
    protected Integer energySaverOnBatteryThresholdPercentage;

    @JsonProperty("energySaverPluggedInThresholdPercentage")
    protected Integer energySaverPluggedInThresholdPercentage;

    @JsonProperty("enterpriseCloudPrintDiscoveryEndPoint")
    protected String enterpriseCloudPrintDiscoveryEndPoint;

    @JsonProperty("enterpriseCloudPrintDiscoveryMaxLimit")
    protected Integer enterpriseCloudPrintDiscoveryMaxLimit;

    @JsonProperty("enterpriseCloudPrintMopriaDiscoveryResourceIdentifier")
    protected String enterpriseCloudPrintMopriaDiscoveryResourceIdentifier;

    @JsonProperty("enterpriseCloudPrintOAuthAuthority")
    protected String enterpriseCloudPrintOAuthAuthority;

    @JsonProperty("enterpriseCloudPrintOAuthClientIdentifier")
    protected String enterpriseCloudPrintOAuthClientIdentifier;

    @JsonProperty("enterpriseCloudPrintResourceIdentifier")
    protected String enterpriseCloudPrintResourceIdentifier;

    @JsonProperty("experienceBlockDeviceDiscovery")
    protected Boolean experienceBlockDeviceDiscovery;

    @JsonProperty("experienceBlockErrorDialogWhenNoSIM")
    protected Boolean experienceBlockErrorDialogWhenNoSIM;

    @JsonProperty("experienceBlockTaskSwitcher")
    protected Boolean experienceBlockTaskSwitcher;

    @JsonProperty("experienceDoNotSyncBrowserSettings")
    protected BrowserSyncSetting experienceDoNotSyncBrowserSettings;

    @JsonProperty("findMyFiles")
    protected Enablement findMyFiles;

    @JsonProperty("gameDvrBlocked")
    protected Boolean gameDvrBlocked;

    @JsonProperty("inkWorkspaceAccess")
    protected InkAccessSetting inkWorkspaceAccess;

    @JsonProperty("inkWorkspaceAccessState")
    protected StateManagementSetting inkWorkspaceAccessState;

    @JsonProperty("inkWorkspaceBlockSuggestedApps")
    protected Boolean inkWorkspaceBlockSuggestedApps;

    @JsonProperty("internetSharingBlocked")
    protected Boolean internetSharingBlocked;

    @JsonProperty("locationServicesBlocked")
    protected Boolean locationServicesBlocked;

    @JsonProperty("lockScreenActivateAppsWithVoice")
    protected Enablement lockScreenActivateAppsWithVoice;

    @JsonProperty("lockScreenAllowTimeoutConfiguration")
    protected Boolean lockScreenAllowTimeoutConfiguration;

    @JsonProperty("lockScreenBlockActionCenterNotifications")
    protected Boolean lockScreenBlockActionCenterNotifications;

    @JsonProperty("lockScreenBlockCortana")
    protected Boolean lockScreenBlockCortana;

    @JsonProperty("lockScreenBlockToastNotifications")
    protected Boolean lockScreenBlockToastNotifications;

    @JsonProperty("lockScreenTimeoutInSeconds")
    protected Integer lockScreenTimeoutInSeconds;

    @JsonProperty("logonBlockFastUserSwitching")
    protected Boolean logonBlockFastUserSwitching;

    @JsonProperty("messagingBlockMMS")
    protected Boolean messagingBlockMMS;

    @JsonProperty("messagingBlockRichCommunicationServices")
    protected Boolean messagingBlockRichCommunicationServices;

    @JsonProperty("messagingBlockSync")
    protected Boolean messagingBlockSync;

    @JsonProperty("microsoftAccountBlocked")
    protected Boolean microsoftAccountBlocked;

    @JsonProperty("microsoftAccountBlockSettingsSync")
    protected Boolean microsoftAccountBlockSettingsSync;

    @JsonProperty("microsoftAccountSignInAssistantSettings")
    protected SignInAssistantOptions microsoftAccountSignInAssistantSettings;

    @JsonProperty("networkProxyApplySettingsDeviceWide")
    protected Boolean networkProxyApplySettingsDeviceWide;

    @JsonProperty("networkProxyAutomaticConfigurationUrl")
    protected String networkProxyAutomaticConfigurationUrl;

    @JsonProperty("networkProxyDisableAutoDetect")
    protected Boolean networkProxyDisableAutoDetect;

    @JsonProperty("networkProxyServer")
    protected Windows10NetworkProxyServer networkProxyServer;

    @JsonProperty("nfcBlocked")
    protected Boolean nfcBlocked;

    @JsonProperty("oneDriveDisableFileSync")
    protected Boolean oneDriveDisableFileSync;

    @JsonProperty("passwordBlockSimple")
    protected Boolean passwordBlockSimple;

    @JsonProperty("passwordExpirationDays")
    protected Integer passwordExpirationDays;

    @JsonProperty("passwordMinimumAgeInDays")
    protected Integer passwordMinimumAgeInDays;

    @JsonProperty("passwordMinimumCharacterSetCount")
    protected Integer passwordMinimumCharacterSetCount;

    @JsonProperty("passwordMinimumLength")
    protected Integer passwordMinimumLength;

    @JsonProperty("passwordMinutesOfInactivityBeforeScreenTimeout")
    protected Integer passwordMinutesOfInactivityBeforeScreenTimeout;

    @JsonProperty("passwordPreviousPasswordBlockCount")
    protected Integer passwordPreviousPasswordBlockCount;

    @JsonProperty("passwordRequired")
    protected Boolean passwordRequired;

    @JsonProperty("passwordRequiredType")
    protected RequiredPasswordType passwordRequiredType;

    @JsonProperty("passwordRequireWhenResumeFromIdleState")
    protected Boolean passwordRequireWhenResumeFromIdleState;

    @JsonProperty("passwordSignInFailureCountBeforeFactoryReset")
    protected Integer passwordSignInFailureCountBeforeFactoryReset;

    @JsonProperty("personalizationDesktopImageUrl")
    protected String personalizationDesktopImageUrl;

    @JsonProperty("personalizationLockScreenImageUrl")
    protected String personalizationLockScreenImageUrl;

    @JsonProperty("powerButtonActionOnBattery")
    protected PowerActionType powerButtonActionOnBattery;

    @JsonProperty("powerButtonActionPluggedIn")
    protected PowerActionType powerButtonActionPluggedIn;

    @JsonProperty("powerHybridSleepOnBattery")
    protected Enablement powerHybridSleepOnBattery;

    @JsonProperty("powerHybridSleepPluggedIn")
    protected Enablement powerHybridSleepPluggedIn;

    @JsonProperty("powerLidCloseActionOnBattery")
    protected PowerActionType powerLidCloseActionOnBattery;

    @JsonProperty("powerLidCloseActionPluggedIn")
    protected PowerActionType powerLidCloseActionPluggedIn;

    @JsonProperty("powerSleepButtonActionOnBattery")
    protected PowerActionType powerSleepButtonActionOnBattery;

    @JsonProperty("powerSleepButtonActionPluggedIn")
    protected PowerActionType powerSleepButtonActionPluggedIn;

    @JsonProperty("printerBlockAddition")
    protected Boolean printerBlockAddition;

    @JsonProperty("printerDefaultName")
    protected String printerDefaultName;

    @JsonProperty("printerNames")
    protected List<String> printerNames;

    @JsonProperty("printerNames@nextLink")
    protected String printerNamesNextLink;

    @JsonProperty("privacyAdvertisingId")
    protected StateManagementSetting privacyAdvertisingId;

    @JsonProperty("privacyAutoAcceptPairingAndConsentPrompts")
    protected Boolean privacyAutoAcceptPairingAndConsentPrompts;

    @JsonProperty("privacyBlockActivityFeed")
    protected Boolean privacyBlockActivityFeed;

    @JsonProperty("privacyBlockInputPersonalization")
    protected Boolean privacyBlockInputPersonalization;

    @JsonProperty("privacyBlockPublishUserActivities")
    protected Boolean privacyBlockPublishUserActivities;

    @JsonProperty("privacyDisableLaunchExperience")
    protected Boolean privacyDisableLaunchExperience;

    @JsonProperty("resetProtectionModeBlocked")
    protected Boolean resetProtectionModeBlocked;

    @JsonProperty("safeSearchFilter")
    protected SafeSearchFilterType safeSearchFilter;

    @JsonProperty("screenCaptureBlocked")
    protected Boolean screenCaptureBlocked;

    @JsonProperty("searchBlockDiacritics")
    protected Boolean searchBlockDiacritics;

    @JsonProperty("searchBlockWebResults")
    protected Boolean searchBlockWebResults;

    @JsonProperty("searchDisableAutoLanguageDetection")
    protected Boolean searchDisableAutoLanguageDetection;

    @JsonProperty("searchDisableIndexerBackoff")
    protected Boolean searchDisableIndexerBackoff;

    @JsonProperty("searchDisableIndexingEncryptedItems")
    protected Boolean searchDisableIndexingEncryptedItems;

    @JsonProperty("searchDisableIndexingRemovableDrive")
    protected Boolean searchDisableIndexingRemovableDrive;

    @JsonProperty("searchDisableLocation")
    protected Boolean searchDisableLocation;

    @JsonProperty("searchDisableUseLocation")
    protected Boolean searchDisableUseLocation;

    @JsonProperty("searchEnableAutomaticIndexSizeManangement")
    protected Boolean searchEnableAutomaticIndexSizeManangement;

    @JsonProperty("searchEnableRemoteQueries")
    protected Boolean searchEnableRemoteQueries;

    @JsonProperty("securityBlockAzureADJoinedDevicesAutoEncryption")
    protected Boolean securityBlockAzureADJoinedDevicesAutoEncryption;

    @JsonProperty("settingsBlockAccountsPage")
    protected Boolean settingsBlockAccountsPage;

    @JsonProperty("settingsBlockAddProvisioningPackage")
    protected Boolean settingsBlockAddProvisioningPackage;

    @JsonProperty("settingsBlockAppsPage")
    protected Boolean settingsBlockAppsPage;

    @JsonProperty("settingsBlockChangeLanguage")
    protected Boolean settingsBlockChangeLanguage;

    @JsonProperty("settingsBlockChangePowerSleep")
    protected Boolean settingsBlockChangePowerSleep;

    @JsonProperty("settingsBlockChangeRegion")
    protected Boolean settingsBlockChangeRegion;

    @JsonProperty("settingsBlockChangeSystemTime")
    protected Boolean settingsBlockChangeSystemTime;

    @JsonProperty("settingsBlockDevicesPage")
    protected Boolean settingsBlockDevicesPage;

    @JsonProperty("settingsBlockEaseOfAccessPage")
    protected Boolean settingsBlockEaseOfAccessPage;

    @JsonProperty("settingsBlockEditDeviceName")
    protected Boolean settingsBlockEditDeviceName;

    @JsonProperty("settingsBlockGamingPage")
    protected Boolean settingsBlockGamingPage;

    @JsonProperty("settingsBlockNetworkInternetPage")
    protected Boolean settingsBlockNetworkInternetPage;

    @JsonProperty("settingsBlockPersonalizationPage")
    protected Boolean settingsBlockPersonalizationPage;

    @JsonProperty("settingsBlockPrivacyPage")
    protected Boolean settingsBlockPrivacyPage;

    @JsonProperty("settingsBlockRemoveProvisioningPackage")
    protected Boolean settingsBlockRemoveProvisioningPackage;

    @JsonProperty("settingsBlockSettingsApp")
    protected Boolean settingsBlockSettingsApp;

    @JsonProperty("settingsBlockSystemPage")
    protected Boolean settingsBlockSystemPage;

    @JsonProperty("settingsBlockTimeLanguagePage")
    protected Boolean settingsBlockTimeLanguagePage;

    @JsonProperty("settingsBlockUpdateSecurityPage")
    protected Boolean settingsBlockUpdateSecurityPage;

    @JsonProperty("sharedUserAppDataAllowed")
    protected Boolean sharedUserAppDataAllowed;

    @JsonProperty("smartScreenAppInstallControl")
    protected AppInstallControlType smartScreenAppInstallControl;

    @JsonProperty("smartScreenBlockPromptOverride")
    protected Boolean smartScreenBlockPromptOverride;

    @JsonProperty("smartScreenBlockPromptOverrideForFiles")
    protected Boolean smartScreenBlockPromptOverrideForFiles;

    @JsonProperty("smartScreenEnableAppInstallControl")
    protected Boolean smartScreenEnableAppInstallControl;

    @JsonProperty("startBlockUnpinningAppsFromTaskbar")
    protected Boolean startBlockUnpinningAppsFromTaskbar;

    @JsonProperty("startMenuAppListVisibility")
    protected WindowsStartMenuAppListVisibilityType startMenuAppListVisibility;

    @JsonProperty("startMenuHideChangeAccountSettings")
    protected Boolean startMenuHideChangeAccountSettings;

    @JsonProperty("startMenuHideFrequentlyUsedApps")
    protected Boolean startMenuHideFrequentlyUsedApps;

    @JsonProperty("startMenuHideHibernate")
    protected Boolean startMenuHideHibernate;

    @JsonProperty("startMenuHideLock")
    protected Boolean startMenuHideLock;

    @JsonProperty("startMenuHidePowerButton")
    protected Boolean startMenuHidePowerButton;

    @JsonProperty("startMenuHideRecentJumpLists")
    protected Boolean startMenuHideRecentJumpLists;

    @JsonProperty("startMenuHideRecentlyAddedApps")
    protected Boolean startMenuHideRecentlyAddedApps;

    @JsonProperty("startMenuHideRestartOptions")
    protected Boolean startMenuHideRestartOptions;

    @JsonProperty("startMenuHideShutDown")
    protected Boolean startMenuHideShutDown;

    @JsonProperty("startMenuHideSignOut")
    protected Boolean startMenuHideSignOut;

    @JsonProperty("startMenuHideSleep")
    protected Boolean startMenuHideSleep;

    @JsonProperty("startMenuHideSwitchAccount")
    protected Boolean startMenuHideSwitchAccount;

    @JsonProperty("startMenuHideUserTile")
    protected Boolean startMenuHideUserTile;

    @JsonProperty("startMenuLayoutEdgeAssetsXml")
    protected byte[] startMenuLayoutEdgeAssetsXml;

    @JsonProperty("startMenuLayoutXml")
    protected byte[] startMenuLayoutXml;

    @JsonProperty("startMenuMode")
    protected WindowsStartMenuModeType startMenuMode;

    @JsonProperty("startMenuPinnedFolderDocuments")
    protected VisibilitySetting startMenuPinnedFolderDocuments;

    @JsonProperty("startMenuPinnedFolderDownloads")
    protected VisibilitySetting startMenuPinnedFolderDownloads;

    @JsonProperty("startMenuPinnedFolderFileExplorer")
    protected VisibilitySetting startMenuPinnedFolderFileExplorer;

    @JsonProperty("startMenuPinnedFolderHomeGroup")
    protected VisibilitySetting startMenuPinnedFolderHomeGroup;

    @JsonProperty("startMenuPinnedFolderMusic")
    protected VisibilitySetting startMenuPinnedFolderMusic;

    @JsonProperty("startMenuPinnedFolderNetwork")
    protected VisibilitySetting startMenuPinnedFolderNetwork;

    @JsonProperty("startMenuPinnedFolderPersonalFolder")
    protected VisibilitySetting startMenuPinnedFolderPersonalFolder;

    @JsonProperty("startMenuPinnedFolderPictures")
    protected VisibilitySetting startMenuPinnedFolderPictures;

    @JsonProperty("startMenuPinnedFolderSettings")
    protected VisibilitySetting startMenuPinnedFolderSettings;

    @JsonProperty("startMenuPinnedFolderVideos")
    protected VisibilitySetting startMenuPinnedFolderVideos;

    @JsonProperty("storageBlockRemovableStorage")
    protected Boolean storageBlockRemovableStorage;

    @JsonProperty("storageRequireMobileDeviceEncryption")
    protected Boolean storageRequireMobileDeviceEncryption;

    @JsonProperty("storageRestrictAppDataToSystemVolume")
    protected Boolean storageRestrictAppDataToSystemVolume;

    @JsonProperty("storageRestrictAppInstallToSystemVolume")
    protected Boolean storageRestrictAppInstallToSystemVolume;

    @JsonProperty("systemTelemetryProxyServer")
    protected String systemTelemetryProxyServer;

    @JsonProperty("taskManagerBlockEndTask")
    protected Boolean taskManagerBlockEndTask;

    @JsonProperty("tenantLockdownRequireNetworkDuringOutOfBoxExperience")
    protected Boolean tenantLockdownRequireNetworkDuringOutOfBoxExperience;

    @JsonProperty("uninstallBuiltInApps")
    protected Boolean uninstallBuiltInApps;

    @JsonProperty("usbBlocked")
    protected Boolean usbBlocked;

    @JsonProperty("voiceRecordingBlocked")
    protected Boolean voiceRecordingBlocked;

    @JsonProperty("webRtcBlockLocalhostIpAddress")
    protected Boolean webRtcBlockLocalhostIpAddress;

    @JsonProperty("wiFiBlockAutomaticConnectHotspots")
    protected Boolean wiFiBlockAutomaticConnectHotspots;

    @JsonProperty("wiFiBlocked")
    protected Boolean wiFiBlocked;

    @JsonProperty("wiFiBlockManualConfiguration")
    protected Boolean wiFiBlockManualConfiguration;

    @JsonProperty("wiFiScanInterval")
    protected Integer wiFiScanInterval;

    @JsonProperty("windows10AppsForceUpdateSchedule")
    protected Windows10AppsForceUpdateSchedule windows10AppsForceUpdateSchedule;

    @JsonProperty("windowsSpotlightBlockConsumerSpecificFeatures")
    protected Boolean windowsSpotlightBlockConsumerSpecificFeatures;

    @JsonProperty("windowsSpotlightBlocked")
    protected Boolean windowsSpotlightBlocked;

    @JsonProperty("windowsSpotlightBlockOnActionCenter")
    protected Boolean windowsSpotlightBlockOnActionCenter;

    @JsonProperty("windowsSpotlightBlockTailoredExperiences")
    protected Boolean windowsSpotlightBlockTailoredExperiences;

    @JsonProperty("windowsSpotlightBlockThirdPartyNotifications")
    protected Boolean windowsSpotlightBlockThirdPartyNotifications;

    @JsonProperty("windowsSpotlightBlockWelcomeExperience")
    protected Boolean windowsSpotlightBlockWelcomeExperience;

    @JsonProperty("windowsSpotlightBlockWindowsTips")
    protected Boolean windowsSpotlightBlockWindowsTips;

    @JsonProperty("windowsSpotlightConfigureOnLockScreen")
    protected WindowsSpotlightEnablementSettings windowsSpotlightConfigureOnLockScreen;

    @JsonProperty("windowsStoreBlockAutoUpdate")
    protected Boolean windowsStoreBlockAutoUpdate;

    @JsonProperty("windowsStoreBlocked")
    protected Boolean windowsStoreBlocked;

    @JsonProperty("windowsStoreEnablePrivateStoreOnly")
    protected Boolean windowsStoreEnablePrivateStoreOnly;

    @JsonProperty("wirelessDisplayBlockProjectionToThisDevice")
    protected Boolean wirelessDisplayBlockProjectionToThisDevice;

    @JsonProperty("wirelessDisplayBlockUserInputFromReceiver")
    protected Boolean wirelessDisplayBlockUserInputFromReceiver;

    @JsonProperty("wirelessDisplayRequirePinForPairing")
    protected Boolean wirelessDisplayRequirePinForPairing;

    @JsonProperty("privacyAccessControls")
    protected List<WindowsPrivacyDataAccessControlItem> privacyAccessControls;

    protected Windows10GeneralConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindows10GeneralConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private Integer version;
        private List<DeviceConfigurationAssignment> assignments;
        private List<SettingStateDeviceSummary> deviceSettingStateSummaries;
        private List<DeviceConfigurationDeviceStatus> deviceStatuses;
        private DeviceConfigurationDeviceOverview deviceStatusOverview;
        private List<DeviceConfigurationGroupAssignment> groupAssignments;
        private List<DeviceConfigurationUserStatus> userStatuses;
        private DeviceConfigurationUserOverview userStatusOverview;
        private Boolean accountsBlockAddingNonMicrosoftAccountEmail;
        private Enablement activateAppsWithVoice;
        private Boolean antiTheftModeBlocked;
        private Boolean appManagementMSIAllowUserControlOverInstall;
        private Boolean appManagementMSIAlwaysInstallWithElevatedPrivileges;
        private List<String> appManagementPackageFamilyNamesToLaunchAfterLogOn;
        private String appManagementPackageFamilyNamesToLaunchAfterLogOnNextLink;
        private StateManagementSetting appsAllowTrustedAppsSideloading;
        private Boolean appsBlockWindowsStoreOriginatedApps;
        private Boolean authenticationAllowSecondaryDevice;
        private String authenticationPreferredAzureADTenantDomainName;
        private Enablement authenticationWebSignIn;
        private List<String> bluetoothAllowedServices;
        private String bluetoothAllowedServicesNextLink;
        private Boolean bluetoothBlockAdvertising;
        private Boolean bluetoothBlockDiscoverableMode;
        private Boolean bluetoothBlocked;
        private Boolean bluetoothBlockPrePairing;
        private Boolean bluetoothBlockPromptedProximalConnections;
        private Boolean cameraBlocked;
        private Boolean cellularBlockDataWhenRoaming;
        private Boolean cellularBlockVpn;
        private Boolean cellularBlockVpnWhenRoaming;
        private ConfigurationUsage cellularData;
        private Boolean certificatesBlockManualRootCertificateInstallation;
        private String configureTimeZone;
        private Boolean connectedDevicesServiceBlocked;
        private Boolean copyPasteBlocked;
        private Boolean cortanaBlocked;
        private Boolean cryptographyAllowFipsAlgorithmPolicy;
        private Boolean dataProtectionBlockDirectMemoryAccess;
        private Boolean defenderBlockEndUserAccess;
        private Boolean defenderBlockOnAccessProtection;
        private DefenderCloudBlockLevelType defenderCloudBlockLevel;
        private Integer defenderCloudExtendedTimeout;
        private Integer defenderCloudExtendedTimeoutInSeconds;
        private Integer defenderDaysBeforeDeletingQuarantinedMalware;
        private DefenderDetectedMalwareActions defenderDetectedMalwareActions;
        private Boolean defenderDisableCatchupFullScan;
        private Boolean defenderDisableCatchupQuickScan;
        private List<String> defenderFileExtensionsToExclude;
        private String defenderFileExtensionsToExcludeNextLink;
        private List<String> defenderFilesAndFoldersToExclude;
        private String defenderFilesAndFoldersToExcludeNextLink;
        private DefenderMonitorFileActivity defenderMonitorFileActivity;
        private DefenderPotentiallyUnwantedAppAction defenderPotentiallyUnwantedAppAction;
        private DefenderProtectionType defenderPotentiallyUnwantedAppActionSetting;
        private List<String> defenderProcessesToExclude;
        private String defenderProcessesToExcludeNextLink;
        private DefenderPromptForSampleSubmission defenderPromptForSampleSubmission;
        private Boolean defenderRequireBehaviorMonitoring;
        private Boolean defenderRequireCloudProtection;
        private Boolean defenderRequireNetworkInspectionSystem;
        private Boolean defenderRequireRealTimeMonitoring;
        private Boolean defenderScanArchiveFiles;
        private Boolean defenderScanDownloads;
        private Boolean defenderScanIncomingMail;
        private Boolean defenderScanMappedNetworkDrivesDuringFullScan;
        private Integer defenderScanMaxCpu;
        private Boolean defenderScanNetworkFiles;
        private Boolean defenderScanRemovableDrivesDuringFullScan;
        private Boolean defenderScanScriptsLoadedInInternetExplorer;
        private DefenderScanType defenderScanType;
        private LocalTime defenderScheduledQuickScanTime;
        private LocalTime defenderScheduledScanTime;
        private Boolean defenderScheduleScanEnableLowCpuPriority;
        private Integer defenderSignatureUpdateIntervalInHours;
        private DefenderSubmitSamplesConsentType defenderSubmitSamplesConsentType;
        private WeeklySchedule defenderSystemScanSchedule;
        private StateManagementSetting developerUnlockSetting;
        private Boolean deviceManagementBlockFactoryResetOnMobile;
        private Boolean deviceManagementBlockManualUnenroll;
        private DiagnosticDataSubmissionMode diagnosticsDataSubmissionMode;
        private List<String> displayAppListWithGdiDPIScalingTurnedOff;
        private String displayAppListWithGdiDPIScalingTurnedOffNextLink;
        private List<String> displayAppListWithGdiDPIScalingTurnedOn;
        private String displayAppListWithGdiDPIScalingTurnedOnNextLink;
        private Boolean edgeAllowStartPagesModification;
        private Boolean edgeBlockAccessToAboutFlags;
        private Boolean edgeBlockAddressBarDropdown;
        private Boolean edgeBlockAutofill;
        private Boolean edgeBlockCompatibilityList;
        private Boolean edgeBlockDeveloperTools;
        private Boolean edgeBlocked;
        private Boolean edgeBlockEditFavorites;
        private Boolean edgeBlockExtensions;
        private Boolean edgeBlockFullScreenMode;
        private Boolean edgeBlockInPrivateBrowsing;
        private Boolean edgeBlockJavaScript;
        private Boolean edgeBlockLiveTileDataCollection;
        private Boolean edgeBlockPasswordManager;
        private Boolean edgeBlockPopups;
        private Boolean edgeBlockPrelaunch;
        private Boolean edgeBlockPrinting;
        private Boolean edgeBlockSavingHistory;
        private Boolean edgeBlockSearchEngineCustomization;
        private Boolean edgeBlockSearchSuggestions;
        private Boolean edgeBlockSendingDoNotTrackHeader;
        private Boolean edgeBlockSendingIntranetTrafficToInternetExplorer;
        private Boolean edgeBlockSideloadingExtensions;
        private Boolean edgeBlockTabPreloading;
        private Boolean edgeBlockWebContentOnNewTabPage;
        private Boolean edgeClearBrowsingDataOnExit;
        private EdgeCookiePolicy edgeCookiePolicy;
        private Boolean edgeDisableFirstRunPage;
        private String edgeEnterpriseModeSiteListLocation;
        private VisibilitySetting edgeFavoritesBarVisibility;
        private String edgeFavoritesListLocation;
        private String edgeFirstRunUrl;
        private EdgeHomeButtonConfiguration edgeHomeButtonConfiguration;
        private Boolean edgeHomeButtonConfigurationEnabled;
        private List<String> edgeHomepageUrls;
        private String edgeHomepageUrlsNextLink;
        private EdgeKioskModeRestrictionType edgeKioskModeRestriction;
        private Integer edgeKioskResetAfterIdleTimeInMinutes;
        private String edgeNewTabPageURL;
        private EdgeOpenOptions edgeOpensWith;
        private Boolean edgePreventCertificateErrorOverride;
        private List<String> edgeRequiredExtensionPackageFamilyNames;
        private String edgeRequiredExtensionPackageFamilyNamesNextLink;
        private Boolean edgeRequireSmartScreen;
        private EdgeSearchEngineBase edgeSearchEngine;
        private Boolean edgeSendIntranetTrafficToInternetExplorer;
        private InternetExplorerMessageSetting edgeShowMessageWhenOpeningInternetExplorerSites;
        private Boolean edgeSyncFavoritesWithInternetExplorer;
        private EdgeTelemetryMode edgeTelemetryForMicrosoft365Analytics;
        private Boolean enableAutomaticRedeployment;
        private Integer energySaverOnBatteryThresholdPercentage;
        private Integer energySaverPluggedInThresholdPercentage;
        private String enterpriseCloudPrintDiscoveryEndPoint;
        private Integer enterpriseCloudPrintDiscoveryMaxLimit;
        private String enterpriseCloudPrintMopriaDiscoveryResourceIdentifier;
        private String enterpriseCloudPrintOAuthAuthority;
        private String enterpriseCloudPrintOAuthClientIdentifier;
        private String enterpriseCloudPrintResourceIdentifier;
        private Boolean experienceBlockDeviceDiscovery;
        private Boolean experienceBlockErrorDialogWhenNoSIM;
        private Boolean experienceBlockTaskSwitcher;
        private BrowserSyncSetting experienceDoNotSyncBrowserSettings;
        private Enablement findMyFiles;
        private Boolean gameDvrBlocked;
        private InkAccessSetting inkWorkspaceAccess;
        private StateManagementSetting inkWorkspaceAccessState;
        private Boolean inkWorkspaceBlockSuggestedApps;
        private Boolean internetSharingBlocked;
        private Boolean locationServicesBlocked;
        private Enablement lockScreenActivateAppsWithVoice;
        private Boolean lockScreenAllowTimeoutConfiguration;
        private Boolean lockScreenBlockActionCenterNotifications;
        private Boolean lockScreenBlockCortana;
        private Boolean lockScreenBlockToastNotifications;
        private Integer lockScreenTimeoutInSeconds;
        private Boolean logonBlockFastUserSwitching;
        private Boolean messagingBlockMMS;
        private Boolean messagingBlockRichCommunicationServices;
        private Boolean messagingBlockSync;
        private Boolean microsoftAccountBlocked;
        private Boolean microsoftAccountBlockSettingsSync;
        private SignInAssistantOptions microsoftAccountSignInAssistantSettings;
        private Boolean networkProxyApplySettingsDeviceWide;
        private String networkProxyAutomaticConfigurationUrl;
        private Boolean networkProxyDisableAutoDetect;
        private Windows10NetworkProxyServer networkProxyServer;
        private Boolean nfcBlocked;
        private Boolean oneDriveDisableFileSync;
        private Boolean passwordBlockSimple;
        private Integer passwordExpirationDays;
        private Integer passwordMinimumAgeInDays;
        private Integer passwordMinimumCharacterSetCount;
        private Integer passwordMinimumLength;
        private Integer passwordMinutesOfInactivityBeforeScreenTimeout;
        private Integer passwordPreviousPasswordBlockCount;
        private Boolean passwordRequired;
        private RequiredPasswordType passwordRequiredType;
        private Boolean passwordRequireWhenResumeFromIdleState;
        private Integer passwordSignInFailureCountBeforeFactoryReset;
        private String personalizationDesktopImageUrl;
        private String personalizationLockScreenImageUrl;
        private PowerActionType powerButtonActionOnBattery;
        private PowerActionType powerButtonActionPluggedIn;
        private Enablement powerHybridSleepOnBattery;
        private Enablement powerHybridSleepPluggedIn;
        private PowerActionType powerLidCloseActionOnBattery;
        private PowerActionType powerLidCloseActionPluggedIn;
        private PowerActionType powerSleepButtonActionOnBattery;
        private PowerActionType powerSleepButtonActionPluggedIn;
        private Boolean printerBlockAddition;
        private String printerDefaultName;
        private List<String> printerNames;
        private String printerNamesNextLink;
        private StateManagementSetting privacyAdvertisingId;
        private Boolean privacyAutoAcceptPairingAndConsentPrompts;
        private Boolean privacyBlockActivityFeed;
        private Boolean privacyBlockInputPersonalization;
        private Boolean privacyBlockPublishUserActivities;
        private Boolean privacyDisableLaunchExperience;
        private Boolean resetProtectionModeBlocked;
        private SafeSearchFilterType safeSearchFilter;
        private Boolean screenCaptureBlocked;
        private Boolean searchBlockDiacritics;
        private Boolean searchBlockWebResults;
        private Boolean searchDisableAutoLanguageDetection;
        private Boolean searchDisableIndexerBackoff;
        private Boolean searchDisableIndexingEncryptedItems;
        private Boolean searchDisableIndexingRemovableDrive;
        private Boolean searchDisableLocation;
        private Boolean searchDisableUseLocation;
        private Boolean searchEnableAutomaticIndexSizeManangement;
        private Boolean searchEnableRemoteQueries;
        private Boolean securityBlockAzureADJoinedDevicesAutoEncryption;
        private Boolean settingsBlockAccountsPage;
        private Boolean settingsBlockAddProvisioningPackage;
        private Boolean settingsBlockAppsPage;
        private Boolean settingsBlockChangeLanguage;
        private Boolean settingsBlockChangePowerSleep;
        private Boolean settingsBlockChangeRegion;
        private Boolean settingsBlockChangeSystemTime;
        private Boolean settingsBlockDevicesPage;
        private Boolean settingsBlockEaseOfAccessPage;
        private Boolean settingsBlockEditDeviceName;
        private Boolean settingsBlockGamingPage;
        private Boolean settingsBlockNetworkInternetPage;
        private Boolean settingsBlockPersonalizationPage;
        private Boolean settingsBlockPrivacyPage;
        private Boolean settingsBlockRemoveProvisioningPackage;
        private Boolean settingsBlockSettingsApp;
        private Boolean settingsBlockSystemPage;
        private Boolean settingsBlockTimeLanguagePage;
        private Boolean settingsBlockUpdateSecurityPage;
        private Boolean sharedUserAppDataAllowed;
        private AppInstallControlType smartScreenAppInstallControl;
        private Boolean smartScreenBlockPromptOverride;
        private Boolean smartScreenBlockPromptOverrideForFiles;
        private Boolean smartScreenEnableAppInstallControl;
        private Boolean startBlockUnpinningAppsFromTaskbar;
        private WindowsStartMenuAppListVisibilityType startMenuAppListVisibility;
        private Boolean startMenuHideChangeAccountSettings;
        private Boolean startMenuHideFrequentlyUsedApps;
        private Boolean startMenuHideHibernate;
        private Boolean startMenuHideLock;
        private Boolean startMenuHidePowerButton;
        private Boolean startMenuHideRecentJumpLists;
        private Boolean startMenuHideRecentlyAddedApps;
        private Boolean startMenuHideRestartOptions;
        private Boolean startMenuHideShutDown;
        private Boolean startMenuHideSignOut;
        private Boolean startMenuHideSleep;
        private Boolean startMenuHideSwitchAccount;
        private Boolean startMenuHideUserTile;
        private byte[] startMenuLayoutEdgeAssetsXml;
        private byte[] startMenuLayoutXml;
        private WindowsStartMenuModeType startMenuMode;
        private VisibilitySetting startMenuPinnedFolderDocuments;
        private VisibilitySetting startMenuPinnedFolderDownloads;
        private VisibilitySetting startMenuPinnedFolderFileExplorer;
        private VisibilitySetting startMenuPinnedFolderHomeGroup;
        private VisibilitySetting startMenuPinnedFolderMusic;
        private VisibilitySetting startMenuPinnedFolderNetwork;
        private VisibilitySetting startMenuPinnedFolderPersonalFolder;
        private VisibilitySetting startMenuPinnedFolderPictures;
        private VisibilitySetting startMenuPinnedFolderSettings;
        private VisibilitySetting startMenuPinnedFolderVideos;
        private Boolean storageBlockRemovableStorage;
        private Boolean storageRequireMobileDeviceEncryption;
        private Boolean storageRestrictAppDataToSystemVolume;
        private Boolean storageRestrictAppInstallToSystemVolume;
        private String systemTelemetryProxyServer;
        private Boolean taskManagerBlockEndTask;
        private Boolean tenantLockdownRequireNetworkDuringOutOfBoxExperience;
        private Boolean uninstallBuiltInApps;
        private Boolean usbBlocked;
        private Boolean voiceRecordingBlocked;
        private Boolean webRtcBlockLocalhostIpAddress;
        private Boolean wiFiBlockAutomaticConnectHotspots;
        private Boolean wiFiBlocked;
        private Boolean wiFiBlockManualConfiguration;
        private Integer wiFiScanInterval;
        private Windows10AppsForceUpdateSchedule windows10AppsForceUpdateSchedule;
        private Boolean windowsSpotlightBlockConsumerSpecificFeatures;
        private Boolean windowsSpotlightBlocked;
        private Boolean windowsSpotlightBlockOnActionCenter;
        private Boolean windowsSpotlightBlockTailoredExperiences;
        private Boolean windowsSpotlightBlockThirdPartyNotifications;
        private Boolean windowsSpotlightBlockWelcomeExperience;
        private Boolean windowsSpotlightBlockWindowsTips;
        private WindowsSpotlightEnablementSettings windowsSpotlightConfigureOnLockScreen;
        private Boolean windowsStoreBlockAutoUpdate;
        private Boolean windowsStoreBlocked;
        private Boolean windowsStoreEnablePrivateStoreOnly;
        private Boolean wirelessDisplayBlockProjectionToThisDevice;
        private Boolean wirelessDisplayBlockUserInputFromReceiver;
        private Boolean wirelessDisplayRequirePinForPairing;
        private List<WindowsPrivacyDataAccessControlItem> privacyAccessControls;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder assignments(List<DeviceConfigurationAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(DeviceConfigurationAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder deviceSettingStateSummaries(List<SettingStateDeviceSummary> deviceSettingStateSummaries) {
            this.deviceSettingStateSummaries = deviceSettingStateSummaries;
            this.changedFields = changedFields.add("deviceSettingStateSummaries");
            return this;
        }

        public Builder deviceSettingStateSummaries(SettingStateDeviceSummary... deviceSettingStateSummaries) {
            return deviceSettingStateSummaries(Arrays.asList(deviceSettingStateSummaries));
        }

        public Builder deviceStatuses(List<DeviceConfigurationDeviceStatus> deviceStatuses) {
            this.deviceStatuses = deviceStatuses;
            this.changedFields = changedFields.add("deviceStatuses");
            return this;
        }

        public Builder deviceStatuses(DeviceConfigurationDeviceStatus... deviceStatuses) {
            return deviceStatuses(Arrays.asList(deviceStatuses));
        }

        public Builder deviceStatusOverview(DeviceConfigurationDeviceOverview deviceStatusOverview) {
            this.deviceStatusOverview = deviceStatusOverview;
            this.changedFields = changedFields.add("deviceStatusOverview");
            return this;
        }

        public Builder groupAssignments(List<DeviceConfigurationGroupAssignment> groupAssignments) {
            this.groupAssignments = groupAssignments;
            this.changedFields = changedFields.add("groupAssignments");
            return this;
        }

        public Builder groupAssignments(DeviceConfigurationGroupAssignment... groupAssignments) {
            return groupAssignments(Arrays.asList(groupAssignments));
        }

        public Builder userStatuses(List<DeviceConfigurationUserStatus> userStatuses) {
            this.userStatuses = userStatuses;
            this.changedFields = changedFields.add("userStatuses");
            return this;
        }

        public Builder userStatuses(DeviceConfigurationUserStatus... userStatuses) {
            return userStatuses(Arrays.asList(userStatuses));
        }

        public Builder userStatusOverview(DeviceConfigurationUserOverview userStatusOverview) {
            this.userStatusOverview = userStatusOverview;
            this.changedFields = changedFields.add("userStatusOverview");
            return this;
        }

        /**
         * <i>“Indicates whether or not to Block the user from adding email accounts to the
         * device that are not associated with a Microsoft account.”</i>
         * 
         * @param accountsBlockAddingNonMicrosoftAccountEmail
         *            value of {@code accountsBlockAddingNonMicrosoftAccountEmail} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder accountsBlockAddingNonMicrosoftAccountEmail(Boolean accountsBlockAddingNonMicrosoftAccountEmail) {
            this.accountsBlockAddingNonMicrosoftAccountEmail = accountsBlockAddingNonMicrosoftAccountEmail;
            this.changedFields = changedFields.add("accountsBlockAddingNonMicrosoftAccountEmail");
            return this;
        }

        /**
         * <i>“Specifies if Windows apps can be activated by voice.”</i>
         * 
         * @param activateAppsWithVoice
         *            value of {@code activateAppsWithVoice} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder activateAppsWithVoice(Enablement activateAppsWithVoice) {
            this.activateAppsWithVoice = activateAppsWithVoice;
            this.changedFields = changedFields.add("activateAppsWithVoice");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from selecting an AntiTheft mode
         * preference (Windows 10 Mobile only).”</i>
         * 
         * @param antiTheftModeBlocked
         *            value of {@code antiTheftModeBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder antiTheftModeBlocked(Boolean antiTheftModeBlocked) {
            this.antiTheftModeBlocked = antiTheftModeBlocked;
            this.changedFields = changedFields.add("antiTheftModeBlocked");
            return this;
        }

        /**
         * <i>“This policy setting permits users to change installation options that typically
         * are available only to system administrators.”</i>
         * 
         * @param appManagementMSIAllowUserControlOverInstall
         *            value of {@code appManagementMSIAllowUserControlOverInstall} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appManagementMSIAllowUserControlOverInstall(Boolean appManagementMSIAllowUserControlOverInstall) {
            this.appManagementMSIAllowUserControlOverInstall = appManagementMSIAllowUserControlOverInstall;
            this.changedFields = changedFields.add("appManagementMSIAllowUserControlOverInstall");
            return this;
        }

        /**
         * <i>“This policy setting directs Windows Installer to use elevated permissions when
         * it installs any program on the system.”</i>
         * 
         * @param appManagementMSIAlwaysInstallWithElevatedPrivileges
         *            value of {@code appManagementMSIAlwaysInstallWithElevatedPrivileges} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appManagementMSIAlwaysInstallWithElevatedPrivileges(Boolean appManagementMSIAlwaysInstallWithElevatedPrivileges) {
            this.appManagementMSIAlwaysInstallWithElevatedPrivileges = appManagementMSIAlwaysInstallWithElevatedPrivileges;
            this.changedFields = changedFields.add("appManagementMSIAlwaysInstallWithElevatedPrivileges");
            return this;
        }

        /**
         * <i>“List of semi-colon delimited Package Family Names of Windows apps. Listed
         * Windows apps are to be launched after logon.​”</i>
         * 
         * @param appManagementPackageFamilyNamesToLaunchAfterLogOn
         *            value of {@code appManagementPackageFamilyNamesToLaunchAfterLogOn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appManagementPackageFamilyNamesToLaunchAfterLogOn(List<String> appManagementPackageFamilyNamesToLaunchAfterLogOn) {
            this.appManagementPackageFamilyNamesToLaunchAfterLogOn = appManagementPackageFamilyNamesToLaunchAfterLogOn;
            this.changedFields = changedFields.add("appManagementPackageFamilyNamesToLaunchAfterLogOn");
            return this;
        }

        /**
         * <i>“List of semi-colon delimited Package Family Names of Windows apps. Listed
         * Windows apps are to be launched after logon.​”</i>
         * 
         * @param appManagementPackageFamilyNamesToLaunchAfterLogOn
         *            value of {@code appManagementPackageFamilyNamesToLaunchAfterLogOn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appManagementPackageFamilyNamesToLaunchAfterLogOn(String... appManagementPackageFamilyNamesToLaunchAfterLogOn) {
            return appManagementPackageFamilyNamesToLaunchAfterLogOn(Arrays.asList(appManagementPackageFamilyNamesToLaunchAfterLogOn));
        }

        /**
         * <i>“List of semi-colon delimited Package Family Names of Windows apps. Listed
         * Windows apps are to be launched after logon.​”</i>
         * 
         * @param appManagementPackageFamilyNamesToLaunchAfterLogOnNextLink
         *            value of {@code appManagementPackageFamilyNamesToLaunchAfterLogOn@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appManagementPackageFamilyNamesToLaunchAfterLogOnNextLink(String appManagementPackageFamilyNamesToLaunchAfterLogOnNextLink) {
            this.appManagementPackageFamilyNamesToLaunchAfterLogOnNextLink = appManagementPackageFamilyNamesToLaunchAfterLogOnNextLink;
            this.changedFields = changedFields.add("appManagementPackageFamilyNamesToLaunchAfterLogOn");
            return this;
        }

        /**
         * <i>“Indicates whether apps from AppX packages signed with a trusted certificate can
         * be side loaded.”</i>
         * 
         * @param appsAllowTrustedAppsSideloading
         *            value of {@code appsAllowTrustedAppsSideloading} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appsAllowTrustedAppsSideloading(StateManagementSetting appsAllowTrustedAppsSideloading) {
            this.appsAllowTrustedAppsSideloading = appsAllowTrustedAppsSideloading;
            this.changedFields = changedFields.add("appsAllowTrustedAppsSideloading");
            return this;
        }

        /**
         * <i>“Indicates whether or not to disable the launch of all apps from Windows Store
         * that came pre-installed or were downloaded.”</i>
         * 
         * @param appsBlockWindowsStoreOriginatedApps
         *            value of {@code appsBlockWindowsStoreOriginatedApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appsBlockWindowsStoreOriginatedApps(Boolean appsBlockWindowsStoreOriginatedApps) {
            this.appsBlockWindowsStoreOriginatedApps = appsBlockWindowsStoreOriginatedApps;
            this.changedFields = changedFields.add("appsBlockWindowsStoreOriginatedApps");
            return this;
        }

        /**
         * <i>“Allows secondary authentication devices to work with Windows.”</i>
         * 
         * @param authenticationAllowSecondaryDevice
         *            value of {@code authenticationAllowSecondaryDevice} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder authenticationAllowSecondaryDevice(Boolean authenticationAllowSecondaryDevice) {
            this.authenticationAllowSecondaryDevice = authenticationAllowSecondaryDevice;
            this.changedFields = changedFields.add("authenticationAllowSecondaryDevice");
            return this;
        }

        /**
         * <i>“Specifies the preferred domain among available domains in the Azure AD tenant.”</i>
         * 
         * @param authenticationPreferredAzureADTenantDomainName
         *            value of {@code authenticationPreferredAzureADTenantDomainName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder authenticationPreferredAzureADTenantDomainName(String authenticationPreferredAzureADTenantDomainName) {
            this.authenticationPreferredAzureADTenantDomainName = authenticationPreferredAzureADTenantDomainName;
            this.changedFields = changedFields.add("authenticationPreferredAzureADTenantDomainName");
            return this;
        }

        /**
         * <i>“Indicates whether or not Web Credential Provider will be enabled.”</i>
         * 
         * @param authenticationWebSignIn
         *            value of {@code authenticationWebSignIn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder authenticationWebSignIn(Enablement authenticationWebSignIn) {
            this.authenticationWebSignIn = authenticationWebSignIn;
            this.changedFields = changedFields.add("authenticationWebSignIn");
            return this;
        }

        /**
         * <i>“Specify a list of allowed Bluetooth services and profiles in hex formatted
         * strings.”</i>
         * 
         * @param bluetoothAllowedServices
         *            value of {@code bluetoothAllowedServices} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bluetoothAllowedServices(List<String> bluetoothAllowedServices) {
            this.bluetoothAllowedServices = bluetoothAllowedServices;
            this.changedFields = changedFields.add("bluetoothAllowedServices");
            return this;
        }

        /**
         * <i>“Specify a list of allowed Bluetooth services and profiles in hex formatted
         * strings.”</i>
         * 
         * @param bluetoothAllowedServices
         *            value of {@code bluetoothAllowedServices} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bluetoothAllowedServices(String... bluetoothAllowedServices) {
            return bluetoothAllowedServices(Arrays.asList(bluetoothAllowedServices));
        }

        /**
         * <i>“Specify a list of allowed Bluetooth services and profiles in hex formatted
         * strings.”</i>
         * 
         * @param bluetoothAllowedServicesNextLink
         *            value of {@code bluetoothAllowedServices@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bluetoothAllowedServicesNextLink(String bluetoothAllowedServicesNextLink) {
            this.bluetoothAllowedServicesNextLink = bluetoothAllowedServicesNextLink;
            this.changedFields = changedFields.add("bluetoothAllowedServices");
            return this;
        }

        /**
         * <i>“Whether or not to Block the user from using bluetooth advertising.”</i>
         * 
         * @param bluetoothBlockAdvertising
         *            value of {@code bluetoothBlockAdvertising} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bluetoothBlockAdvertising(Boolean bluetoothBlockAdvertising) {
            this.bluetoothBlockAdvertising = bluetoothBlockAdvertising;
            this.changedFields = changedFields.add("bluetoothBlockAdvertising");
            return this;
        }

        /**
         * <i>“Whether or not to Block the user from using bluetooth discoverable mode.”</i>
         * 
         * @param bluetoothBlockDiscoverableMode
         *            value of {@code bluetoothBlockDiscoverableMode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bluetoothBlockDiscoverableMode(Boolean bluetoothBlockDiscoverableMode) {
            this.bluetoothBlockDiscoverableMode = bluetoothBlockDiscoverableMode;
            this.changedFields = changedFields.add("bluetoothBlockDiscoverableMode");
            return this;
        }

        /**
         * <i>“Whether or not to Block the user from using bluetooth.”</i>
         * 
         * @param bluetoothBlocked
         *            value of {@code bluetoothBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bluetoothBlocked(Boolean bluetoothBlocked) {
            this.bluetoothBlocked = bluetoothBlocked;
            this.changedFields = changedFields.add("bluetoothBlocked");
            return this;
        }

        /**
         * <i>“Whether or not to block specific bundled Bluetooth peripherals to automatically
         * pair with the host device.”</i>
         * 
         * @param bluetoothBlockPrePairing
         *            value of {@code bluetoothBlockPrePairing} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bluetoothBlockPrePairing(Boolean bluetoothBlockPrePairing) {
            this.bluetoothBlockPrePairing = bluetoothBlockPrePairing;
            this.changedFields = changedFields.add("bluetoothBlockPrePairing");
            return this;
        }

        /**
         * <i>“Whether or not to block the users from using Swift Pair and other proximity
         * based scenarios.”</i>
         * 
         * @param bluetoothBlockPromptedProximalConnections
         *            value of {@code bluetoothBlockPromptedProximalConnections} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bluetoothBlockPromptedProximalConnections(Boolean bluetoothBlockPromptedProximalConnections) {
            this.bluetoothBlockPromptedProximalConnections = bluetoothBlockPromptedProximalConnections;
            this.changedFields = changedFields.add("bluetoothBlockPromptedProximalConnections");
            return this;
        }

        /**
         * <i>“Whether or not to Block the user from accessing the camera of the device.”</i>
         * 
         * @param cameraBlocked
         *            value of {@code cameraBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cameraBlocked(Boolean cameraBlocked) {
            this.cameraBlocked = cameraBlocked;
            this.changedFields = changedFields.add("cameraBlocked");
            return this;
        }

        /**
         * <i>“Whether or not to Block the user from using data over cellular while roaming.”</i>
         * 
         * @param cellularBlockDataWhenRoaming
         *            value of {@code cellularBlockDataWhenRoaming} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cellularBlockDataWhenRoaming(Boolean cellularBlockDataWhenRoaming) {
            this.cellularBlockDataWhenRoaming = cellularBlockDataWhenRoaming;
            this.changedFields = changedFields.add("cellularBlockDataWhenRoaming");
            return this;
        }

        /**
         * <i>“Whether or not to Block the user from using VPN over cellular.”</i>
         * 
         * @param cellularBlockVpn
         *            value of {@code cellularBlockVpn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cellularBlockVpn(Boolean cellularBlockVpn) {
            this.cellularBlockVpn = cellularBlockVpn;
            this.changedFields = changedFields.add("cellularBlockVpn");
            return this;
        }

        /**
         * <i>“Whether or not to Block the user from using VPN when roaming over cellular.”</i>
         * 
         * @param cellularBlockVpnWhenRoaming
         *            value of {@code cellularBlockVpnWhenRoaming} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cellularBlockVpnWhenRoaming(Boolean cellularBlockVpnWhenRoaming) {
            this.cellularBlockVpnWhenRoaming = cellularBlockVpnWhenRoaming;
            this.changedFields = changedFields.add("cellularBlockVpnWhenRoaming");
            return this;
        }

        /**
         * <i>“Whether or not to allow the cellular data channel on the device. If not
         * configured, the cellular data channel is allowed and the user can turn it off.”</i>
         * 
         * @param cellularData
         *            value of {@code cellularData} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cellularData(ConfigurationUsage cellularData) {
            this.cellularData = cellularData;
            this.changedFields = changedFields.add("cellularData");
            return this;
        }

        /**
         * <i>“Whether or not to Block the user from doing manual root certificate installation
         * .”</i>
         * 
         * @param certificatesBlockManualRootCertificateInstallation
         *            value of {@code certificatesBlockManualRootCertificateInstallation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificatesBlockManualRootCertificateInstallation(Boolean certificatesBlockManualRootCertificateInstallation) {
            this.certificatesBlockManualRootCertificateInstallation = certificatesBlockManualRootCertificateInstallation;
            this.changedFields = changedFields.add("certificatesBlockManualRootCertificateInstallation");
            return this;
        }

        /**
         * <i>“Specifies the time zone to be applied to the device. This is the standard
         * Windows name for the target time zone.”</i>
         * 
         * @param configureTimeZone
         *            value of {@code configureTimeZone} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configureTimeZone(String configureTimeZone) {
            this.configureTimeZone = configureTimeZone;
            this.changedFields = changedFields.add("configureTimeZone");
            return this;
        }

        /**
         * <i>“Whether or not to block Connected Devices Service which enables discovery and
         * connection to other devices, remote messaging, remote app sessions and other
         * cross-device experiences.”</i>
         * 
         * @param connectedDevicesServiceBlocked
         *            value of {@code connectedDevicesServiceBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder connectedDevicesServiceBlocked(Boolean connectedDevicesServiceBlocked) {
            this.connectedDevicesServiceBlocked = connectedDevicesServiceBlocked;
            this.changedFields = changedFields.add("connectedDevicesServiceBlocked");
            return this;
        }

        /**
         * <i>“Whether or not to Block the user from using copy paste.”</i>
         * 
         * @param copyPasteBlocked
         *            value of {@code copyPasteBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder copyPasteBlocked(Boolean copyPasteBlocked) {
            this.copyPasteBlocked = copyPasteBlocked;
            this.changedFields = changedFields.add("copyPasteBlocked");
            return this;
        }

        /**
         * <i>“Whether or not to Block the user from using Cortana.”</i>
         * 
         * @param cortanaBlocked
         *            value of {@code cortanaBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cortanaBlocked(Boolean cortanaBlocked) {
            this.cortanaBlocked = cortanaBlocked;
            this.changedFields = changedFields.add("cortanaBlocked");
            return this;
        }

        /**
         * <i>“Specify whether to allow or disallow the Federal Information Processing Standard
         * (FIPS) policy.”</i>
         * 
         * @param cryptographyAllowFipsAlgorithmPolicy
         *            value of {@code cryptographyAllowFipsAlgorithmPolicy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cryptographyAllowFipsAlgorithmPolicy(Boolean cryptographyAllowFipsAlgorithmPolicy) {
            this.cryptographyAllowFipsAlgorithmPolicy = cryptographyAllowFipsAlgorithmPolicy;
            this.changedFields = changedFields.add("cryptographyAllowFipsAlgorithmPolicy");
            return this;
        }

        /**
         * <i>“This policy setting allows you to block direct memory access (DMA) for all hot
         * pluggable PCI downstream ports until a user logs into Windows.”</i>
         * 
         * @param dataProtectionBlockDirectMemoryAccess
         *            value of {@code dataProtectionBlockDirectMemoryAccess} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dataProtectionBlockDirectMemoryAccess(Boolean dataProtectionBlockDirectMemoryAccess) {
            this.dataProtectionBlockDirectMemoryAccess = dataProtectionBlockDirectMemoryAccess;
            this.changedFields = changedFields.add("dataProtectionBlockDirectMemoryAccess");
            return this;
        }

        /**
         * <i>“Whether or not to block end user access to Defender.”</i>
         * 
         * @param defenderBlockEndUserAccess
         *            value of {@code defenderBlockEndUserAccess} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderBlockEndUserAccess(Boolean defenderBlockEndUserAccess) {
            this.defenderBlockEndUserAccess = defenderBlockEndUserAccess;
            this.changedFields = changedFields.add("defenderBlockEndUserAccess");
            return this;
        }

        /**
         * <i>“Allows or disallows Windows Defender On Access Protection functionality.”</i>
         * 
         * @param defenderBlockOnAccessProtection
         *            value of {@code defenderBlockOnAccessProtection} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderBlockOnAccessProtection(Boolean defenderBlockOnAccessProtection) {
            this.defenderBlockOnAccessProtection = defenderBlockOnAccessProtection;
            this.changedFields = changedFields.add("defenderBlockOnAccessProtection");
            return this;
        }

        /**
         * <i>“Specifies the level of cloud-delivered protection.”</i>
         * 
         * @param defenderCloudBlockLevel
         *            value of {@code defenderCloudBlockLevel} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderCloudBlockLevel(DefenderCloudBlockLevelType defenderCloudBlockLevel) {
            this.defenderCloudBlockLevel = defenderCloudBlockLevel;
            this.changedFields = changedFields.add("defenderCloudBlockLevel");
            return this;
        }

        /**
         * <i>“Timeout extension for file scanning by the cloud. Valid values 0 to 50”</i>
         * 
         * @param defenderCloudExtendedTimeout
         *            value of {@code defenderCloudExtendedTimeout} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderCloudExtendedTimeout(Integer defenderCloudExtendedTimeout) {
            this.defenderCloudExtendedTimeout = defenderCloudExtendedTimeout;
            this.changedFields = changedFields.add("defenderCloudExtendedTimeout");
            return this;
        }

        /**
         * <i>“Timeout extension for file scanning by the cloud. Valid values 0 to 50”</i>
         * 
         * @param defenderCloudExtendedTimeoutInSeconds
         *            value of {@code defenderCloudExtendedTimeoutInSeconds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderCloudExtendedTimeoutInSeconds(Integer defenderCloudExtendedTimeoutInSeconds) {
            this.defenderCloudExtendedTimeoutInSeconds = defenderCloudExtendedTimeoutInSeconds;
            this.changedFields = changedFields.add("defenderCloudExtendedTimeoutInSeconds");
            return this;
        }

        /**
         * <i>“Number of days before deleting quarantined malware. Valid values 0 to 90”</i>
         * 
         * @param defenderDaysBeforeDeletingQuarantinedMalware
         *            value of {@code defenderDaysBeforeDeletingQuarantinedMalware} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderDaysBeforeDeletingQuarantinedMalware(Integer defenderDaysBeforeDeletingQuarantinedMalware) {
            this.defenderDaysBeforeDeletingQuarantinedMalware = defenderDaysBeforeDeletingQuarantinedMalware;
            this.changedFields = changedFields.add("defenderDaysBeforeDeletingQuarantinedMalware");
            return this;
        }

        /**
         * <i>“Gets or sets Defender’s actions to take on detected Malware per threat level.”</i>
         * 
         * @param defenderDetectedMalwareActions
         *            value of {@code defenderDetectedMalwareActions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderDetectedMalwareActions(DefenderDetectedMalwareActions defenderDetectedMalwareActions) {
            this.defenderDetectedMalwareActions = defenderDetectedMalwareActions;
            this.changedFields = changedFields.add("defenderDetectedMalwareActions");
            return this;
        }

        /**
         * <i>“When blocked, catch-up scans for scheduled full scans will be turned off.”</i>
         * 
         * @param defenderDisableCatchupFullScan
         *            value of {@code defenderDisableCatchupFullScan} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderDisableCatchupFullScan(Boolean defenderDisableCatchupFullScan) {
            this.defenderDisableCatchupFullScan = defenderDisableCatchupFullScan;
            this.changedFields = changedFields.add("defenderDisableCatchupFullScan");
            return this;
        }

        /**
         * <i>“When blocked, catch-up scans for scheduled quick scans will be turned off.”</i>
         * 
         * @param defenderDisableCatchupQuickScan
         *            value of {@code defenderDisableCatchupQuickScan} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderDisableCatchupQuickScan(Boolean defenderDisableCatchupQuickScan) {
            this.defenderDisableCatchupQuickScan = defenderDisableCatchupQuickScan;
            this.changedFields = changedFields.add("defenderDisableCatchupQuickScan");
            return this;
        }

        /**
         * <i>“File extensions to exclude from scans and real time protection.”</i>
         * 
         * @param defenderFileExtensionsToExclude
         *            value of {@code defenderFileExtensionsToExclude} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderFileExtensionsToExclude(List<String> defenderFileExtensionsToExclude) {
            this.defenderFileExtensionsToExclude = defenderFileExtensionsToExclude;
            this.changedFields = changedFields.add("defenderFileExtensionsToExclude");
            return this;
        }

        /**
         * <i>“File extensions to exclude from scans and real time protection.”</i>
         * 
         * @param defenderFileExtensionsToExclude
         *            value of {@code defenderFileExtensionsToExclude} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderFileExtensionsToExclude(String... defenderFileExtensionsToExclude) {
            return defenderFileExtensionsToExclude(Arrays.asList(defenderFileExtensionsToExclude));
        }

        /**
         * <i>“File extensions to exclude from scans and real time protection.”</i>
         * 
         * @param defenderFileExtensionsToExcludeNextLink
         *            value of {@code defenderFileExtensionsToExclude@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderFileExtensionsToExcludeNextLink(String defenderFileExtensionsToExcludeNextLink) {
            this.defenderFileExtensionsToExcludeNextLink = defenderFileExtensionsToExcludeNextLink;
            this.changedFields = changedFields.add("defenderFileExtensionsToExclude");
            return this;
        }

        /**
         * <i>“Files and folder to exclude from scans and real time protection.”</i>
         * 
         * @param defenderFilesAndFoldersToExclude
         *            value of {@code defenderFilesAndFoldersToExclude} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderFilesAndFoldersToExclude(List<String> defenderFilesAndFoldersToExclude) {
            this.defenderFilesAndFoldersToExclude = defenderFilesAndFoldersToExclude;
            this.changedFields = changedFields.add("defenderFilesAndFoldersToExclude");
            return this;
        }

        /**
         * <i>“Files and folder to exclude from scans and real time protection.”</i>
         * 
         * @param defenderFilesAndFoldersToExclude
         *            value of {@code defenderFilesAndFoldersToExclude} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderFilesAndFoldersToExclude(String... defenderFilesAndFoldersToExclude) {
            return defenderFilesAndFoldersToExclude(Arrays.asList(defenderFilesAndFoldersToExclude));
        }

        /**
         * <i>“Files and folder to exclude from scans and real time protection.”</i>
         * 
         * @param defenderFilesAndFoldersToExcludeNextLink
         *            value of {@code defenderFilesAndFoldersToExclude@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderFilesAndFoldersToExcludeNextLink(String defenderFilesAndFoldersToExcludeNextLink) {
            this.defenderFilesAndFoldersToExcludeNextLink = defenderFilesAndFoldersToExcludeNextLink;
            this.changedFields = changedFields.add("defenderFilesAndFoldersToExclude");
            return this;
        }

        /**
         * <i>“Value for monitoring file activity.”</i>
         * 
         * @param defenderMonitorFileActivity
         *            value of {@code defenderMonitorFileActivity} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderMonitorFileActivity(DefenderMonitorFileActivity defenderMonitorFileActivity) {
            this.defenderMonitorFileActivity = defenderMonitorFileActivity;
            this.changedFields = changedFields.add("defenderMonitorFileActivity");
            return this;
        }

        /**
         * <i>“Gets or sets Defender’s action to take on Potentially Unwanted Application (PUA)
         * , which includes software with behaviors of ad-injection, software bundling,
         * persistent solicitation for payment or subscription, etc. Defender alerts user
         * when PUA is being downloaded or attempts to install itself. Added in Windows 10
         * for desktop.”</i>
         * 
         * @param defenderPotentiallyUnwantedAppAction
         *            value of {@code defenderPotentiallyUnwantedAppAction} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderPotentiallyUnwantedAppAction(DefenderPotentiallyUnwantedAppAction defenderPotentiallyUnwantedAppAction) {
            this.defenderPotentiallyUnwantedAppAction = defenderPotentiallyUnwantedAppAction;
            this.changedFields = changedFields.add("defenderPotentiallyUnwantedAppAction");
            return this;
        }

        /**
         * <i>“Gets or sets Defender’s action to take on Potentially Unwanted Application (PUA)
         * , which includes software with behaviors of ad-injection, software bundling,
         * persistent solicitation for payment or subscription, etc. Defender alerts user
         * when PUA is being downloaded or attempts to install itself. Added in Windows 10
         * for desktop.”</i>
         * 
         * @param defenderPotentiallyUnwantedAppActionSetting
         *            value of {@code defenderPotentiallyUnwantedAppActionSetting} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderPotentiallyUnwantedAppActionSetting(DefenderProtectionType defenderPotentiallyUnwantedAppActionSetting) {
            this.defenderPotentiallyUnwantedAppActionSetting = defenderPotentiallyUnwantedAppActionSetting;
            this.changedFields = changedFields.add("defenderPotentiallyUnwantedAppActionSetting");
            return this;
        }

        /**
         * <i>“Processes to exclude from scans and real time protection.”</i>
         * 
         * @param defenderProcessesToExclude
         *            value of {@code defenderProcessesToExclude} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderProcessesToExclude(List<String> defenderProcessesToExclude) {
            this.defenderProcessesToExclude = defenderProcessesToExclude;
            this.changedFields = changedFields.add("defenderProcessesToExclude");
            return this;
        }

        /**
         * <i>“Processes to exclude from scans and real time protection.”</i>
         * 
         * @param defenderProcessesToExclude
         *            value of {@code defenderProcessesToExclude} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderProcessesToExclude(String... defenderProcessesToExclude) {
            return defenderProcessesToExclude(Arrays.asList(defenderProcessesToExclude));
        }

        /**
         * <i>“Processes to exclude from scans and real time protection.”</i>
         * 
         * @param defenderProcessesToExcludeNextLink
         *            value of {@code defenderProcessesToExclude@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderProcessesToExcludeNextLink(String defenderProcessesToExcludeNextLink) {
            this.defenderProcessesToExcludeNextLink = defenderProcessesToExcludeNextLink;
            this.changedFields = changedFields.add("defenderProcessesToExclude");
            return this;
        }

        /**
         * <i>“The configuration for how to prompt user for sample submission.”</i>
         * 
         * @param defenderPromptForSampleSubmission
         *            value of {@code defenderPromptForSampleSubmission} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderPromptForSampleSubmission(DefenderPromptForSampleSubmission defenderPromptForSampleSubmission) {
            this.defenderPromptForSampleSubmission = defenderPromptForSampleSubmission;
            this.changedFields = changedFields.add("defenderPromptForSampleSubmission");
            return this;
        }

        /**
         * <i>“Indicates whether or not to require behavior monitoring.”</i>
         * 
         * @param defenderRequireBehaviorMonitoring
         *            value of {@code defenderRequireBehaviorMonitoring} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderRequireBehaviorMonitoring(Boolean defenderRequireBehaviorMonitoring) {
            this.defenderRequireBehaviorMonitoring = defenderRequireBehaviorMonitoring;
            this.changedFields = changedFields.add("defenderRequireBehaviorMonitoring");
            return this;
        }

        /**
         * <i>“Indicates whether or not to require cloud protection.”</i>
         * 
         * @param defenderRequireCloudProtection
         *            value of {@code defenderRequireCloudProtection} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderRequireCloudProtection(Boolean defenderRequireCloudProtection) {
            this.defenderRequireCloudProtection = defenderRequireCloudProtection;
            this.changedFields = changedFields.add("defenderRequireCloudProtection");
            return this;
        }

        /**
         * <i>“Indicates whether or not to require network inspection system.”</i>
         * 
         * @param defenderRequireNetworkInspectionSystem
         *            value of {@code defenderRequireNetworkInspectionSystem} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderRequireNetworkInspectionSystem(Boolean defenderRequireNetworkInspectionSystem) {
            this.defenderRequireNetworkInspectionSystem = defenderRequireNetworkInspectionSystem;
            this.changedFields = changedFields.add("defenderRequireNetworkInspectionSystem");
            return this;
        }

        /**
         * <i>“Indicates whether or not to require real time monitoring.”</i>
         * 
         * @param defenderRequireRealTimeMonitoring
         *            value of {@code defenderRequireRealTimeMonitoring} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderRequireRealTimeMonitoring(Boolean defenderRequireRealTimeMonitoring) {
            this.defenderRequireRealTimeMonitoring = defenderRequireRealTimeMonitoring;
            this.changedFields = changedFields.add("defenderRequireRealTimeMonitoring");
            return this;
        }

        /**
         * <i>“Indicates whether or not to scan archive files.”</i>
         * 
         * @param defenderScanArchiveFiles
         *            value of {@code defenderScanArchiveFiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderScanArchiveFiles(Boolean defenderScanArchiveFiles) {
            this.defenderScanArchiveFiles = defenderScanArchiveFiles;
            this.changedFields = changedFields.add("defenderScanArchiveFiles");
            return this;
        }

        /**
         * <i>“Indicates whether or not to scan downloads.”</i>
         * 
         * @param defenderScanDownloads
         *            value of {@code defenderScanDownloads} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderScanDownloads(Boolean defenderScanDownloads) {
            this.defenderScanDownloads = defenderScanDownloads;
            this.changedFields = changedFields.add("defenderScanDownloads");
            return this;
        }

        /**
         * <i>“Indicates whether or not to scan incoming mail messages.”</i>
         * 
         * @param defenderScanIncomingMail
         *            value of {@code defenderScanIncomingMail} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderScanIncomingMail(Boolean defenderScanIncomingMail) {
            this.defenderScanIncomingMail = defenderScanIncomingMail;
            this.changedFields = changedFields.add("defenderScanIncomingMail");
            return this;
        }

        /**
         * <i>“Indicates whether or not to scan mapped network drives during full scan.”</i>
         * 
         * @param defenderScanMappedNetworkDrivesDuringFullScan
         *            value of {@code defenderScanMappedNetworkDrivesDuringFullScan} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderScanMappedNetworkDrivesDuringFullScan(Boolean defenderScanMappedNetworkDrivesDuringFullScan) {
            this.defenderScanMappedNetworkDrivesDuringFullScan = defenderScanMappedNetworkDrivesDuringFullScan;
            this.changedFields = changedFields.add("defenderScanMappedNetworkDrivesDuringFullScan");
            return this;
        }

        /**
         * <i>“Max CPU usage percentage during scan. Valid values 0 to 100”</i>
         * 
         * @param defenderScanMaxCpu
         *            value of {@code defenderScanMaxCpu} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderScanMaxCpu(Integer defenderScanMaxCpu) {
            this.defenderScanMaxCpu = defenderScanMaxCpu;
            this.changedFields = changedFields.add("defenderScanMaxCpu");
            return this;
        }

        /**
         * <i>“Indicates whether or not to scan files opened from a network folder.”</i>
         * 
         * @param defenderScanNetworkFiles
         *            value of {@code defenderScanNetworkFiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderScanNetworkFiles(Boolean defenderScanNetworkFiles) {
            this.defenderScanNetworkFiles = defenderScanNetworkFiles;
            this.changedFields = changedFields.add("defenderScanNetworkFiles");
            return this;
        }

        /**
         * <i>“Indicates whether or not to scan removable drives during full scan.”</i>
         * 
         * @param defenderScanRemovableDrivesDuringFullScan
         *            value of {@code defenderScanRemovableDrivesDuringFullScan} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderScanRemovableDrivesDuringFullScan(Boolean defenderScanRemovableDrivesDuringFullScan) {
            this.defenderScanRemovableDrivesDuringFullScan = defenderScanRemovableDrivesDuringFullScan;
            this.changedFields = changedFields.add("defenderScanRemovableDrivesDuringFullScan");
            return this;
        }

        /**
         * <i>“Indicates whether or not to scan scripts loaded in Internet Explorer browser.”</i>
         * 
         * @param defenderScanScriptsLoadedInInternetExplorer
         *            value of {@code defenderScanScriptsLoadedInInternetExplorer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderScanScriptsLoadedInInternetExplorer(Boolean defenderScanScriptsLoadedInInternetExplorer) {
            this.defenderScanScriptsLoadedInInternetExplorer = defenderScanScriptsLoadedInInternetExplorer;
            this.changedFields = changedFields.add("defenderScanScriptsLoadedInInternetExplorer");
            return this;
        }

        /**
         * <i>“The defender system scan type.”</i>
         * 
         * @param defenderScanType
         *            value of {@code defenderScanType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderScanType(DefenderScanType defenderScanType) {
            this.defenderScanType = defenderScanType;
            this.changedFields = changedFields.add("defenderScanType");
            return this;
        }

        /**
         * <i>“The time to perform a daily quick scan.”</i>
         * 
         * @param defenderScheduledQuickScanTime
         *            value of {@code defenderScheduledQuickScanTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderScheduledQuickScanTime(LocalTime defenderScheduledQuickScanTime) {
            this.defenderScheduledQuickScanTime = defenderScheduledQuickScanTime;
            this.changedFields = changedFields.add("defenderScheduledQuickScanTime");
            return this;
        }

        /**
         * <i>“The defender time for the system scan.”</i>
         * 
         * @param defenderScheduledScanTime
         *            value of {@code defenderScheduledScanTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderScheduledScanTime(LocalTime defenderScheduledScanTime) {
            this.defenderScheduledScanTime = defenderScheduledScanTime;
            this.changedFields = changedFields.add("defenderScheduledScanTime");
            return this;
        }

        /**
         * <i>“When enabled, low CPU priority will be used during scheduled scans.”</i>
         * 
         * @param defenderScheduleScanEnableLowCpuPriority
         *            value of {@code defenderScheduleScanEnableLowCpuPriority} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderScheduleScanEnableLowCpuPriority(Boolean defenderScheduleScanEnableLowCpuPriority) {
            this.defenderScheduleScanEnableLowCpuPriority = defenderScheduleScanEnableLowCpuPriority;
            this.changedFields = changedFields.add("defenderScheduleScanEnableLowCpuPriority");
            return this;
        }

        /**
         * <i>“The signature update interval in hours. Specify 0 not to check. Valid values 0
         * to 24”</i>
         * 
         * @param defenderSignatureUpdateIntervalInHours
         *            value of {@code defenderSignatureUpdateIntervalInHours} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderSignatureUpdateIntervalInHours(Integer defenderSignatureUpdateIntervalInHours) {
            this.defenderSignatureUpdateIntervalInHours = defenderSignatureUpdateIntervalInHours;
            this.changedFields = changedFields.add("defenderSignatureUpdateIntervalInHours");
            return this;
        }

        /**
         * <i>“Checks for the user consent level in Windows Defender to send data.”</i>
         * 
         * @param defenderSubmitSamplesConsentType
         *            value of {@code defenderSubmitSamplesConsentType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderSubmitSamplesConsentType(DefenderSubmitSamplesConsentType defenderSubmitSamplesConsentType) {
            this.defenderSubmitSamplesConsentType = defenderSubmitSamplesConsentType;
            this.changedFields = changedFields.add("defenderSubmitSamplesConsentType");
            return this;
        }

        /**
         * <i>“Defender day of the week for the system scan.”</i>
         * 
         * @param defenderSystemScanSchedule
         *            value of {@code defenderSystemScanSchedule} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderSystemScanSchedule(WeeklySchedule defenderSystemScanSchedule) {
            this.defenderSystemScanSchedule = defenderSystemScanSchedule;
            this.changedFields = changedFields.add("defenderSystemScanSchedule");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow developer unlock.”</i>
         * 
         * @param developerUnlockSetting
         *            value of {@code developerUnlockSetting} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder developerUnlockSetting(StateManagementSetting developerUnlockSetting) {
            this.developerUnlockSetting = developerUnlockSetting;
            this.changedFields = changedFields.add("developerUnlockSetting");
            return this;
        }

        /**
         * <i>“Indicates whether or not to Block the user from resetting their phone.”</i>
         * 
         * @param deviceManagementBlockFactoryResetOnMobile
         *            value of {@code deviceManagementBlockFactoryResetOnMobile} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceManagementBlockFactoryResetOnMobile(Boolean deviceManagementBlockFactoryResetOnMobile) {
            this.deviceManagementBlockFactoryResetOnMobile = deviceManagementBlockFactoryResetOnMobile;
            this.changedFields = changedFields.add("deviceManagementBlockFactoryResetOnMobile");
            return this;
        }

        /**
         * <i>“Indicates whether or not to Block the user from doing manual un-enrollment from
         * device management.”</i>
         * 
         * @param deviceManagementBlockManualUnenroll
         *            value of {@code deviceManagementBlockManualUnenroll} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceManagementBlockManualUnenroll(Boolean deviceManagementBlockManualUnenroll) {
            this.deviceManagementBlockManualUnenroll = deviceManagementBlockManualUnenroll;
            this.changedFields = changedFields.add("deviceManagementBlockManualUnenroll");
            return this;
        }

        /**
         * <i>“Gets or sets a value allowing the device to send diagnostic and usage telemetry
         * data, such as Watson.”</i>
         * 
         * @param diagnosticsDataSubmissionMode
         *            value of {@code diagnosticsDataSubmissionMode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder diagnosticsDataSubmissionMode(DiagnosticDataSubmissionMode diagnosticsDataSubmissionMode) {
            this.diagnosticsDataSubmissionMode = diagnosticsDataSubmissionMode;
            this.changedFields = changedFields.add("diagnosticsDataSubmissionMode");
            return this;
        }

        /**
         * <i>“List of legacy applications that have GDI DPI Scaling turned off.”</i>
         * 
         * @param displayAppListWithGdiDPIScalingTurnedOff
         *            value of {@code displayAppListWithGdiDPIScalingTurnedOff} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayAppListWithGdiDPIScalingTurnedOff(List<String> displayAppListWithGdiDPIScalingTurnedOff) {
            this.displayAppListWithGdiDPIScalingTurnedOff = displayAppListWithGdiDPIScalingTurnedOff;
            this.changedFields = changedFields.add("displayAppListWithGdiDPIScalingTurnedOff");
            return this;
        }

        /**
         * <i>“List of legacy applications that have GDI DPI Scaling turned off.”</i>
         * 
         * @param displayAppListWithGdiDPIScalingTurnedOff
         *            value of {@code displayAppListWithGdiDPIScalingTurnedOff} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayAppListWithGdiDPIScalingTurnedOff(String... displayAppListWithGdiDPIScalingTurnedOff) {
            return displayAppListWithGdiDPIScalingTurnedOff(Arrays.asList(displayAppListWithGdiDPIScalingTurnedOff));
        }

        /**
         * <i>“List of legacy applications that have GDI DPI Scaling turned off.”</i>
         * 
         * @param displayAppListWithGdiDPIScalingTurnedOffNextLink
         *            value of {@code displayAppListWithGdiDPIScalingTurnedOff@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayAppListWithGdiDPIScalingTurnedOffNextLink(String displayAppListWithGdiDPIScalingTurnedOffNextLink) {
            this.displayAppListWithGdiDPIScalingTurnedOffNextLink = displayAppListWithGdiDPIScalingTurnedOffNextLink;
            this.changedFields = changedFields.add("displayAppListWithGdiDPIScalingTurnedOff");
            return this;
        }

        /**
         * <i>“List of legacy applications that have GDI DPI Scaling turned on.”</i>
         * 
         * @param displayAppListWithGdiDPIScalingTurnedOn
         *            value of {@code displayAppListWithGdiDPIScalingTurnedOn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayAppListWithGdiDPIScalingTurnedOn(List<String> displayAppListWithGdiDPIScalingTurnedOn) {
            this.displayAppListWithGdiDPIScalingTurnedOn = displayAppListWithGdiDPIScalingTurnedOn;
            this.changedFields = changedFields.add("displayAppListWithGdiDPIScalingTurnedOn");
            return this;
        }

        /**
         * <i>“List of legacy applications that have GDI DPI Scaling turned on.”</i>
         * 
         * @param displayAppListWithGdiDPIScalingTurnedOn
         *            value of {@code displayAppListWithGdiDPIScalingTurnedOn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayAppListWithGdiDPIScalingTurnedOn(String... displayAppListWithGdiDPIScalingTurnedOn) {
            return displayAppListWithGdiDPIScalingTurnedOn(Arrays.asList(displayAppListWithGdiDPIScalingTurnedOn));
        }

        /**
         * <i>“List of legacy applications that have GDI DPI Scaling turned on.”</i>
         * 
         * @param displayAppListWithGdiDPIScalingTurnedOnNextLink
         *            value of {@code displayAppListWithGdiDPIScalingTurnedOn@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayAppListWithGdiDPIScalingTurnedOnNextLink(String displayAppListWithGdiDPIScalingTurnedOnNextLink) {
            this.displayAppListWithGdiDPIScalingTurnedOnNextLink = displayAppListWithGdiDPIScalingTurnedOnNextLink;
            this.changedFields = changedFields.add("displayAppListWithGdiDPIScalingTurnedOn");
            return this;
        }

        /**
         * <i>“Allow users to change Start pages on Edge. Use the EdgeHomepageUrls to specify
         * the Start pages that the user would see by default when they open Edge.”</i>
         * 
         * @param edgeAllowStartPagesModification
         *            value of {@code edgeAllowStartPagesModification} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeAllowStartPagesModification(Boolean edgeAllowStartPagesModification) {
            this.edgeAllowStartPagesModification = edgeAllowStartPagesModification;
            this.changedFields = changedFields.add("edgeAllowStartPagesModification");
            return this;
        }

        /**
         * <i>“Indicates whether or not to prevent access to about flags on Edge browser.”</i>
         * 
         * @param edgeBlockAccessToAboutFlags
         *            value of {@code edgeBlockAccessToAboutFlags} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeBlockAccessToAboutFlags(Boolean edgeBlockAccessToAboutFlags) {
            this.edgeBlockAccessToAboutFlags = edgeBlockAccessToAboutFlags;
            this.changedFields = changedFields.add("edgeBlockAccessToAboutFlags");
            return this;
        }

        /**
         * <i>“Block the address bar dropdown functionality in Microsoft Edge. Disable this
         * settings to minimize network connections from Microsoft Edge to Microsoft
         * services.”</i>
         * 
         * @param edgeBlockAddressBarDropdown
         *            value of {@code edgeBlockAddressBarDropdown} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeBlockAddressBarDropdown(Boolean edgeBlockAddressBarDropdown) {
            this.edgeBlockAddressBarDropdown = edgeBlockAddressBarDropdown;
            this.changedFields = changedFields.add("edgeBlockAddressBarDropdown");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block auto fill.”</i>
         * 
         * @param edgeBlockAutofill
         *            value of {@code edgeBlockAutofill} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeBlockAutofill(Boolean edgeBlockAutofill) {
            this.edgeBlockAutofill = edgeBlockAutofill;
            this.changedFields = changedFields.add("edgeBlockAutofill");
            return this;
        }

        /**
         * <i>“Block Microsoft compatibility list in Microsoft Edge. This list from Microsoft
         * helps Edge properly display sites with known compatibility issues.”</i>
         * 
         * @param edgeBlockCompatibilityList
         *            value of {@code edgeBlockCompatibilityList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeBlockCompatibilityList(Boolean edgeBlockCompatibilityList) {
            this.edgeBlockCompatibilityList = edgeBlockCompatibilityList;
            this.changedFields = changedFields.add("edgeBlockCompatibilityList");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block developer tools in the Edge browser.”</i>
         * 
         * @param edgeBlockDeveloperTools
         *            value of {@code edgeBlockDeveloperTools} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeBlockDeveloperTools(Boolean edgeBlockDeveloperTools) {
            this.edgeBlockDeveloperTools = edgeBlockDeveloperTools;
            this.changedFields = changedFields.add("edgeBlockDeveloperTools");
            return this;
        }

        /**
         * <i>“Indicates whether or not to Block the user from using the Edge browser.”</i>
         * 
         * @param edgeBlocked
         *            value of {@code edgeBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeBlocked(Boolean edgeBlocked) {
            this.edgeBlocked = edgeBlocked;
            this.changedFields = changedFields.add("edgeBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to Block the user from making changes to Favorites.”</i>
         * 
         * @param edgeBlockEditFavorites
         *            value of {@code edgeBlockEditFavorites} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeBlockEditFavorites(Boolean edgeBlockEditFavorites) {
            this.edgeBlockEditFavorites = edgeBlockEditFavorites;
            this.changedFields = changedFields.add("edgeBlockEditFavorites");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block extensions in the Edge browser.”</i>
         * 
         * @param edgeBlockExtensions
         *            value of {@code edgeBlockExtensions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeBlockExtensions(Boolean edgeBlockExtensions) {
            this.edgeBlockExtensions = edgeBlockExtensions;
            this.changedFields = changedFields.add("edgeBlockExtensions");
            return this;
        }

        /**
         * <i>“Allow or prevent Edge from entering the full screen mode.”</i>
         * 
         * @param edgeBlockFullScreenMode
         *            value of {@code edgeBlockFullScreenMode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeBlockFullScreenMode(Boolean edgeBlockFullScreenMode) {
            this.edgeBlockFullScreenMode = edgeBlockFullScreenMode;
            this.changedFields = changedFields.add("edgeBlockFullScreenMode");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block InPrivate browsing on corporate networks, in
         * the Edge browser.”</i>
         * 
         * @param edgeBlockInPrivateBrowsing
         *            value of {@code edgeBlockInPrivateBrowsing} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeBlockInPrivateBrowsing(Boolean edgeBlockInPrivateBrowsing) {
            this.edgeBlockInPrivateBrowsing = edgeBlockInPrivateBrowsing;
            this.changedFields = changedFields.add("edgeBlockInPrivateBrowsing");
            return this;
        }

        /**
         * <i>“Indicates whether or not to Block the user from using JavaScript.”</i>
         * 
         * @param edgeBlockJavaScript
         *            value of {@code edgeBlockJavaScript} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeBlockJavaScript(Boolean edgeBlockJavaScript) {
            this.edgeBlockJavaScript = edgeBlockJavaScript;
            this.changedFields = changedFields.add("edgeBlockJavaScript");
            return this;
        }

        /**
         * <i>“Block the collection of information by Microsoft for live tile creation when
         * users pin a site to Start from Microsoft Edge.”</i>
         * 
         * @param edgeBlockLiveTileDataCollection
         *            value of {@code edgeBlockLiveTileDataCollection} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeBlockLiveTileDataCollection(Boolean edgeBlockLiveTileDataCollection) {
            this.edgeBlockLiveTileDataCollection = edgeBlockLiveTileDataCollection;
            this.changedFields = changedFields.add("edgeBlockLiveTileDataCollection");
            return this;
        }

        /**
         * <i>“Indicates whether or not to Block password manager.”</i>
         * 
         * @param edgeBlockPasswordManager
         *            value of {@code edgeBlockPasswordManager} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeBlockPasswordManager(Boolean edgeBlockPasswordManager) {
            this.edgeBlockPasswordManager = edgeBlockPasswordManager;
            this.changedFields = changedFields.add("edgeBlockPasswordManager");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block popups.”</i>
         * 
         * @param edgeBlockPopups
         *            value of {@code edgeBlockPopups} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeBlockPopups(Boolean edgeBlockPopups) {
            this.edgeBlockPopups = edgeBlockPopups;
            this.changedFields = changedFields.add("edgeBlockPopups");
            return this;
        }

        /**
         * <i>“Decide whether Microsoft Edge is prelaunched at Windows startup.”</i>
         * 
         * @param edgeBlockPrelaunch
         *            value of {@code edgeBlockPrelaunch} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeBlockPrelaunch(Boolean edgeBlockPrelaunch) {
            this.edgeBlockPrelaunch = edgeBlockPrelaunch;
            this.changedFields = changedFields.add("edgeBlockPrelaunch");
            return this;
        }

        /**
         * <i>“Configure Edge to allow or block printing.”</i>
         * 
         * @param edgeBlockPrinting
         *            value of {@code edgeBlockPrinting} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeBlockPrinting(Boolean edgeBlockPrinting) {
            this.edgeBlockPrinting = edgeBlockPrinting;
            this.changedFields = changedFields.add("edgeBlockPrinting");
            return this;
        }

        /**
         * <i>“Configure Edge to allow browsing history to be saved or to never save browsing
         * history.”</i>
         * 
         * @param edgeBlockSavingHistory
         *            value of {@code edgeBlockSavingHistory} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeBlockSavingHistory(Boolean edgeBlockSavingHistory) {
            this.edgeBlockSavingHistory = edgeBlockSavingHistory;
            this.changedFields = changedFields.add("edgeBlockSavingHistory");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from adding new search engine or
         * changing the default search engine.”</i>
         * 
         * @param edgeBlockSearchEngineCustomization
         *            value of {@code edgeBlockSearchEngineCustomization} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeBlockSearchEngineCustomization(Boolean edgeBlockSearchEngineCustomization) {
            this.edgeBlockSearchEngineCustomization = edgeBlockSearchEngineCustomization;
            this.changedFields = changedFields.add("edgeBlockSearchEngineCustomization");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from using the search suggestions in
         * the address bar.”</i>
         * 
         * @param edgeBlockSearchSuggestions
         *            value of {@code edgeBlockSearchSuggestions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeBlockSearchSuggestions(Boolean edgeBlockSearchSuggestions) {
            this.edgeBlockSearchSuggestions = edgeBlockSearchSuggestions;
            this.changedFields = changedFields.add("edgeBlockSearchSuggestions");
            return this;
        }

        /**
         * <i>“Indicates whether or not to Block the user from sending the do not track header.”</i>
         * 
         * @param edgeBlockSendingDoNotTrackHeader
         *            value of {@code edgeBlockSendingDoNotTrackHeader} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeBlockSendingDoNotTrackHeader(Boolean edgeBlockSendingDoNotTrackHeader) {
            this.edgeBlockSendingDoNotTrackHeader = edgeBlockSendingDoNotTrackHeader;
            this.changedFields = changedFields.add("edgeBlockSendingDoNotTrackHeader");
            return this;
        }

        /**
         * <i>“Indicates whether or not to switch the intranet traffic from Edge to Internet
         * Explorer. Note: the name of this property is misleading; the property is
         * obsolete, use EdgeSendIntranetTrafficToInternetExplorer instead.”</i>
         * 
         * @param edgeBlockSendingIntranetTrafficToInternetExplorer
         *            value of {@code edgeBlockSendingIntranetTrafficToInternetExplorer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeBlockSendingIntranetTrafficToInternetExplorer(Boolean edgeBlockSendingIntranetTrafficToInternetExplorer) {
            this.edgeBlockSendingIntranetTrafficToInternetExplorer = edgeBlockSendingIntranetTrafficToInternetExplorer;
            this.changedFields = changedFields.add("edgeBlockSendingIntranetTrafficToInternetExplorer");
            return this;
        }

        /**
         * <i>“Indicates whether the user can sideload extensions.”</i>
         * 
         * @param edgeBlockSideloadingExtensions
         *            value of {@code edgeBlockSideloadingExtensions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeBlockSideloadingExtensions(Boolean edgeBlockSideloadingExtensions) {
            this.edgeBlockSideloadingExtensions = edgeBlockSideloadingExtensions;
            this.changedFields = changedFields.add("edgeBlockSideloadingExtensions");
            return this;
        }

        /**
         * <i>“Configure whether Edge preloads the new tab page at Windows startup.”</i>
         * 
         * @param edgeBlockTabPreloading
         *            value of {@code edgeBlockTabPreloading} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeBlockTabPreloading(Boolean edgeBlockTabPreloading) {
            this.edgeBlockTabPreloading = edgeBlockTabPreloading;
            this.changedFields = changedFields.add("edgeBlockTabPreloading");
            return this;
        }

        /**
         * <i>“Configure to load a blank page in Edge instead of the default New tab page and
         * prevent users from changing it.”</i>
         * 
         * @param edgeBlockWebContentOnNewTabPage
         *            value of {@code edgeBlockWebContentOnNewTabPage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeBlockWebContentOnNewTabPage(Boolean edgeBlockWebContentOnNewTabPage) {
            this.edgeBlockWebContentOnNewTabPage = edgeBlockWebContentOnNewTabPage;
            this.changedFields = changedFields.add("edgeBlockWebContentOnNewTabPage");
            return this;
        }

        /**
         * <i>“Clear browsing data on exiting Microsoft Edge.”</i>
         * 
         * @param edgeClearBrowsingDataOnExit
         *            value of {@code edgeClearBrowsingDataOnExit} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeClearBrowsingDataOnExit(Boolean edgeClearBrowsingDataOnExit) {
            this.edgeClearBrowsingDataOnExit = edgeClearBrowsingDataOnExit;
            this.changedFields = changedFields.add("edgeClearBrowsingDataOnExit");
            return this;
        }

        /**
         * <i>“Indicates which cookies to block in the Edge browser.”</i>
         * 
         * @param edgeCookiePolicy
         *            value of {@code edgeCookiePolicy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeCookiePolicy(EdgeCookiePolicy edgeCookiePolicy) {
            this.edgeCookiePolicy = edgeCookiePolicy;
            this.changedFields = changedFields.add("edgeCookiePolicy");
            return this;
        }

        /**
         * <i>“Block the Microsoft web page that opens on the first use of Microsoft Edge. This
         * policy allows enterprises, like those enrolled in zero emissions configurations,
         * to block this page.”</i>
         * 
         * @param edgeDisableFirstRunPage
         *            value of {@code edgeDisableFirstRunPage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeDisableFirstRunPage(Boolean edgeDisableFirstRunPage) {
            this.edgeDisableFirstRunPage = edgeDisableFirstRunPage;
            this.changedFields = changedFields.add("edgeDisableFirstRunPage");
            return this;
        }

        /**
         * <i>“Indicates the enterprise mode site list location. Could be a local file, local
         * network or http location.”</i>
         * 
         * @param edgeEnterpriseModeSiteListLocation
         *            value of {@code edgeEnterpriseModeSiteListLocation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeEnterpriseModeSiteListLocation(String edgeEnterpriseModeSiteListLocation) {
            this.edgeEnterpriseModeSiteListLocation = edgeEnterpriseModeSiteListLocation;
            this.changedFields = changedFields.add("edgeEnterpriseModeSiteListLocation");
            return this;
        }

        /**
         * <i>“Get or set a value that specifies whether to set the favorites bar to always be
         * visible or hidden on any page.”</i>
         * 
         * @param edgeFavoritesBarVisibility
         *            value of {@code edgeFavoritesBarVisibility} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeFavoritesBarVisibility(VisibilitySetting edgeFavoritesBarVisibility) {
            this.edgeFavoritesBarVisibility = edgeFavoritesBarVisibility;
            this.changedFields = changedFields.add("edgeFavoritesBarVisibility");
            return this;
        }

        /**
         * <i>“The location of the favorites list to provision. Could be a local file, local
         * network or http location.”</i>
         * 
         * @param edgeFavoritesListLocation
         *            value of {@code edgeFavoritesListLocation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeFavoritesListLocation(String edgeFavoritesListLocation) {
            this.edgeFavoritesListLocation = edgeFavoritesListLocation;
            this.changedFields = changedFields.add("edgeFavoritesListLocation");
            return this;
        }

        /**
         * <i>“The first run URL for when Edge browser is opened for the first time.”</i>
         * 
         * @param edgeFirstRunUrl
         *            value of {@code edgeFirstRunUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeFirstRunUrl(String edgeFirstRunUrl) {
            this.edgeFirstRunUrl = edgeFirstRunUrl;
            this.changedFields = changedFields.add("edgeFirstRunUrl");
            return this;
        }

        /**
         * <i>“Causes the Home button to either hide, load the default Start page, load a New
         * tab page, or a custom URL”</i>
         * 
         * @param edgeHomeButtonConfiguration
         *            value of {@code edgeHomeButtonConfiguration} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeHomeButtonConfiguration(EdgeHomeButtonConfiguration edgeHomeButtonConfiguration) {
            this.edgeHomeButtonConfiguration = edgeHomeButtonConfiguration;
            this.changedFields = changedFields.add("edgeHomeButtonConfiguration");
            return this;
        }

        /**
         * <i>“Enable the Home button configuration.”</i>
         * 
         * @param edgeHomeButtonConfigurationEnabled
         *            value of {@code edgeHomeButtonConfigurationEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeHomeButtonConfigurationEnabled(Boolean edgeHomeButtonConfigurationEnabled) {
            this.edgeHomeButtonConfigurationEnabled = edgeHomeButtonConfigurationEnabled;
            this.changedFields = changedFields.add("edgeHomeButtonConfigurationEnabled");
            return this;
        }

        /**
         * <i>“The list of URLs for homepages shodwn on MDM-enrolled devices on Edge browser.”</i>
         * 
         * @param edgeHomepageUrls
         *            value of {@code edgeHomepageUrls} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeHomepageUrls(List<String> edgeHomepageUrls) {
            this.edgeHomepageUrls = edgeHomepageUrls;
            this.changedFields = changedFields.add("edgeHomepageUrls");
            return this;
        }

        /**
         * <i>“The list of URLs for homepages shodwn on MDM-enrolled devices on Edge browser.”</i>
         * 
         * @param edgeHomepageUrls
         *            value of {@code edgeHomepageUrls} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeHomepageUrls(String... edgeHomepageUrls) {
            return edgeHomepageUrls(Arrays.asList(edgeHomepageUrls));
        }

        /**
         * <i>“The list of URLs for homepages shodwn on MDM-enrolled devices on Edge browser.”</i>
         * 
         * @param edgeHomepageUrlsNextLink
         *            value of {@code edgeHomepageUrls@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeHomepageUrlsNextLink(String edgeHomepageUrlsNextLink) {
            this.edgeHomepageUrlsNextLink = edgeHomepageUrlsNextLink;
            this.changedFields = changedFields.add("edgeHomepageUrls");
            return this;
        }

        /**
         * <i>“Controls how the Microsoft Edge settings are restricted based on the configure
         * kiosk mode.”</i>
         * 
         * @param edgeKioskModeRestriction
         *            value of {@code edgeKioskModeRestriction} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeKioskModeRestriction(EdgeKioskModeRestrictionType edgeKioskModeRestriction) {
            this.edgeKioskModeRestriction = edgeKioskModeRestriction;
            this.changedFields = changedFields.add("edgeKioskModeRestriction");
            return this;
        }

        /**
         * <i>“Specifies the time in minutes from the last user activity before Microsoft Edge
         * kiosk resets.  Valid values are 0-1440. The default is 5. 0 indicates no reset.
         * Valid values 0 to 1440”</i>
         * 
         * @param edgeKioskResetAfterIdleTimeInMinutes
         *            value of {@code edgeKioskResetAfterIdleTimeInMinutes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeKioskResetAfterIdleTimeInMinutes(Integer edgeKioskResetAfterIdleTimeInMinutes) {
            this.edgeKioskResetAfterIdleTimeInMinutes = edgeKioskResetAfterIdleTimeInMinutes;
            this.changedFields = changedFields.add("edgeKioskResetAfterIdleTimeInMinutes");
            return this;
        }

        /**
         * <i>“Specify the page opened when new tabs are created.”</i>
         * 
         * @param edgeNewTabPageURL
         *            value of {@code edgeNewTabPageURL} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeNewTabPageURL(String edgeNewTabPageURL) {
            this.edgeNewTabPageURL = edgeNewTabPageURL;
            this.changedFields = changedFields.add("edgeNewTabPageURL");
            return this;
        }

        /**
         * <i>“Specify what kind of pages are open at start.”</i>
         * 
         * @param edgeOpensWith
         *            value of {@code edgeOpensWith} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeOpensWith(EdgeOpenOptions edgeOpensWith) {
            this.edgeOpensWith = edgeOpensWith;
            this.changedFields = changedFields.add("edgeOpensWith");
            return this;
        }

        /**
         * <i>“Allow or prevent users from overriding certificate errors.”</i>
         * 
         * @param edgePreventCertificateErrorOverride
         *            value of {@code edgePreventCertificateErrorOverride} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgePreventCertificateErrorOverride(Boolean edgePreventCertificateErrorOverride) {
            this.edgePreventCertificateErrorOverride = edgePreventCertificateErrorOverride;
            this.changedFields = changedFields.add("edgePreventCertificateErrorOverride");
            return this;
        }

        /**
         * <i>“Specify the list of package family names of browser extensions that are required
         * and cannot be turned off by the user.”</i>
         * 
         * @param edgeRequiredExtensionPackageFamilyNames
         *            value of {@code edgeRequiredExtensionPackageFamilyNames} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeRequiredExtensionPackageFamilyNames(List<String> edgeRequiredExtensionPackageFamilyNames) {
            this.edgeRequiredExtensionPackageFamilyNames = edgeRequiredExtensionPackageFamilyNames;
            this.changedFields = changedFields.add("edgeRequiredExtensionPackageFamilyNames");
            return this;
        }

        /**
         * <i>“Specify the list of package family names of browser extensions that are required
         * and cannot be turned off by the user.”</i>
         * 
         * @param edgeRequiredExtensionPackageFamilyNames
         *            value of {@code edgeRequiredExtensionPackageFamilyNames} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeRequiredExtensionPackageFamilyNames(String... edgeRequiredExtensionPackageFamilyNames) {
            return edgeRequiredExtensionPackageFamilyNames(Arrays.asList(edgeRequiredExtensionPackageFamilyNames));
        }

        /**
         * <i>“Specify the list of package family names of browser extensions that are required
         * and cannot be turned off by the user.”</i>
         * 
         * @param edgeRequiredExtensionPackageFamilyNamesNextLink
         *            value of {@code edgeRequiredExtensionPackageFamilyNames@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeRequiredExtensionPackageFamilyNamesNextLink(String edgeRequiredExtensionPackageFamilyNamesNextLink) {
            this.edgeRequiredExtensionPackageFamilyNamesNextLink = edgeRequiredExtensionPackageFamilyNamesNextLink;
            this.changedFields = changedFields.add("edgeRequiredExtensionPackageFamilyNames");
            return this;
        }

        /**
         * <i>“Indicates whether or not to Require the user to use the smart screen filter.”</i>
         * 
         * @param edgeRequireSmartScreen
         *            value of {@code edgeRequireSmartScreen} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeRequireSmartScreen(Boolean edgeRequireSmartScreen) {
            this.edgeRequireSmartScreen = edgeRequireSmartScreen;
            this.changedFields = changedFields.add("edgeRequireSmartScreen");
            return this;
        }

        /**
         * <i>“Allows IT admins to set a default search engine for MDM-Controlled devices.
         * Users can override this and change their default search engine provided the
         * AllowSearchEngineCustomization policy is not set.”</i>
         * 
         * @param edgeSearchEngine
         *            value of {@code edgeSearchEngine} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeSearchEngine(EdgeSearchEngineBase edgeSearchEngine) {
            this.edgeSearchEngine = edgeSearchEngine;
            this.changedFields = changedFields.add("edgeSearchEngine");
            return this;
        }

        /**
         * <i>“Indicates whether or not to switch the intranet traffic from Edge to Internet
         * Explorer.”</i>
         * 
         * @param edgeSendIntranetTrafficToInternetExplorer
         *            value of {@code edgeSendIntranetTrafficToInternetExplorer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeSendIntranetTrafficToInternetExplorer(Boolean edgeSendIntranetTrafficToInternetExplorer) {
            this.edgeSendIntranetTrafficToInternetExplorer = edgeSendIntranetTrafficToInternetExplorer;
            this.changedFields = changedFields.add("edgeSendIntranetTrafficToInternetExplorer");
            return this;
        }

        /**
         * <i>“Controls the message displayed by Edge before switching to Internet Explorer.”</i>
         * 
         * @param edgeShowMessageWhenOpeningInternetExplorerSites
         *            value of {@code edgeShowMessageWhenOpeningInternetExplorerSites} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeShowMessageWhenOpeningInternetExplorerSites(InternetExplorerMessageSetting edgeShowMessageWhenOpeningInternetExplorerSites) {
            this.edgeShowMessageWhenOpeningInternetExplorerSites = edgeShowMessageWhenOpeningInternetExplorerSites;
            this.changedFields = changedFields.add("edgeShowMessageWhenOpeningInternetExplorerSites");
            return this;
        }

        /**
         * <i>“Enable favorites sync between Internet Explorer and Microsoft Edge. Additions,
         * deletions, modifications and order changes to favorites are shared between
         * browsers.”</i>
         * 
         * @param edgeSyncFavoritesWithInternetExplorer
         *            value of {@code edgeSyncFavoritesWithInternetExplorer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeSyncFavoritesWithInternetExplorer(Boolean edgeSyncFavoritesWithInternetExplorer) {
            this.edgeSyncFavoritesWithInternetExplorer = edgeSyncFavoritesWithInternetExplorer;
            this.changedFields = changedFields.add("edgeSyncFavoritesWithInternetExplorer");
            return this;
        }

        /**
         * <i>“Specifies what type of telemetry data (none, intranet, internet, both) is sent
         * to Microsoft 365 Analytics”</i>
         * 
         * @param edgeTelemetryForMicrosoft365Analytics
         *            value of {@code edgeTelemetryForMicrosoft365Analytics} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder edgeTelemetryForMicrosoft365Analytics(EdgeTelemetryMode edgeTelemetryForMicrosoft365Analytics) {
            this.edgeTelemetryForMicrosoft365Analytics = edgeTelemetryForMicrosoft365Analytics;
            this.changedFields = changedFields.add("edgeTelemetryForMicrosoft365Analytics");
            return this;
        }

        /**
         * <i>“Allow users with administrative rights to delete all user data and settings
         * using CTRL + Win + R at the device lock screen so that the device can be
         * automatically re-configured and re-enrolled into management.”</i>
         * 
         * @param enableAutomaticRedeployment
         *            value of {@code enableAutomaticRedeployment} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enableAutomaticRedeployment(Boolean enableAutomaticRedeployment) {
            this.enableAutomaticRedeployment = enableAutomaticRedeployment;
            this.changedFields = changedFields.add("enableAutomaticRedeployment");
            return this;
        }

        /**
         * <i>“This setting allows you to specify battery charge level at which Energy Saver is
         * turned on. While on battery, Energy Saver is automatically turned on at (and
         * below) the specified battery charge level. Valid input range (0-100). Valid
         * values 0 to 100”</i>
         * 
         * @param energySaverOnBatteryThresholdPercentage
         *            value of {@code energySaverOnBatteryThresholdPercentage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder energySaverOnBatteryThresholdPercentage(Integer energySaverOnBatteryThresholdPercentage) {
            this.energySaverOnBatteryThresholdPercentage = energySaverOnBatteryThresholdPercentage;
            this.changedFields = changedFields.add("energySaverOnBatteryThresholdPercentage");
            return this;
        }

        /**
         * <i>“This setting allows you to specify battery charge level at which Energy Saver is
         * turned on. While plugged in, Energy Saver is automatically turned on at (and
         * below) the specified battery charge level. Valid input range (0-100). Valid
         * values 0 to 100”</i>
         * 
         * @param energySaverPluggedInThresholdPercentage
         *            value of {@code energySaverPluggedInThresholdPercentage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder energySaverPluggedInThresholdPercentage(Integer energySaverPluggedInThresholdPercentage) {
            this.energySaverPluggedInThresholdPercentage = energySaverPluggedInThresholdPercentage;
            this.changedFields = changedFields.add("energySaverPluggedInThresholdPercentage");
            return this;
        }

        /**
         * <i>“Endpoint for discovering cloud printers.”</i>
         * 
         * @param enterpriseCloudPrintDiscoveryEndPoint
         *            value of {@code enterpriseCloudPrintDiscoveryEndPoint} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enterpriseCloudPrintDiscoveryEndPoint(String enterpriseCloudPrintDiscoveryEndPoint) {
            this.enterpriseCloudPrintDiscoveryEndPoint = enterpriseCloudPrintDiscoveryEndPoint;
            this.changedFields = changedFields.add("enterpriseCloudPrintDiscoveryEndPoint");
            return this;
        }

        /**
         * <i>“Maximum number of printers that should be queried from a discovery endpoint.
         * This is a mobile only setting. Valid values 1 to 65535”</i>
         * 
         * @param enterpriseCloudPrintDiscoveryMaxLimit
         *            value of {@code enterpriseCloudPrintDiscoveryMaxLimit} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enterpriseCloudPrintDiscoveryMaxLimit(Integer enterpriseCloudPrintDiscoveryMaxLimit) {
            this.enterpriseCloudPrintDiscoveryMaxLimit = enterpriseCloudPrintDiscoveryMaxLimit;
            this.changedFields = changedFields.add("enterpriseCloudPrintDiscoveryMaxLimit");
            return this;
        }

        /**
         * <i>“OAuth resource URI for printer discovery service as configured in Azure portal.”</i>
         * 
         * @param enterpriseCloudPrintMopriaDiscoveryResourceIdentifier
         *            value of {@code enterpriseCloudPrintMopriaDiscoveryResourceIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enterpriseCloudPrintMopriaDiscoveryResourceIdentifier(String enterpriseCloudPrintMopriaDiscoveryResourceIdentifier) {
            this.enterpriseCloudPrintMopriaDiscoveryResourceIdentifier = enterpriseCloudPrintMopriaDiscoveryResourceIdentifier;
            this.changedFields = changedFields.add("enterpriseCloudPrintMopriaDiscoveryResourceIdentifier");
            return this;
        }

        /**
         * <i>“Authentication endpoint for acquiring OAuth tokens.”</i>
         * 
         * @param enterpriseCloudPrintOAuthAuthority
         *            value of {@code enterpriseCloudPrintOAuthAuthority} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enterpriseCloudPrintOAuthAuthority(String enterpriseCloudPrintOAuthAuthority) {
            this.enterpriseCloudPrintOAuthAuthority = enterpriseCloudPrintOAuthAuthority;
            this.changedFields = changedFields.add("enterpriseCloudPrintOAuthAuthority");
            return this;
        }

        /**
         * <i>“GUID of a client application authorized to retrieve OAuth tokens from the OAuth
         * Authority.”</i>
         * 
         * @param enterpriseCloudPrintOAuthClientIdentifier
         *            value of {@code enterpriseCloudPrintOAuthClientIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enterpriseCloudPrintOAuthClientIdentifier(String enterpriseCloudPrintOAuthClientIdentifier) {
            this.enterpriseCloudPrintOAuthClientIdentifier = enterpriseCloudPrintOAuthClientIdentifier;
            this.changedFields = changedFields.add("enterpriseCloudPrintOAuthClientIdentifier");
            return this;
        }

        /**
         * <i>“OAuth resource URI for print service as configured in the Azure portal.”</i>
         * 
         * @param enterpriseCloudPrintResourceIdentifier
         *            value of {@code enterpriseCloudPrintResourceIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enterpriseCloudPrintResourceIdentifier(String enterpriseCloudPrintResourceIdentifier) {
            this.enterpriseCloudPrintResourceIdentifier = enterpriseCloudPrintResourceIdentifier;
            this.changedFields = changedFields.add("enterpriseCloudPrintResourceIdentifier");
            return this;
        }

        /**
         * <i>“Indicates whether or not to enable device discovery UX.”</i>
         * 
         * @param experienceBlockDeviceDiscovery
         *            value of {@code experienceBlockDeviceDiscovery} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder experienceBlockDeviceDiscovery(Boolean experienceBlockDeviceDiscovery) {
            this.experienceBlockDeviceDiscovery = experienceBlockDeviceDiscovery;
            this.changedFields = changedFields.add("experienceBlockDeviceDiscovery");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow the error dialog from displaying if no SIM
         * card is detected.”</i>
         * 
         * @param experienceBlockErrorDialogWhenNoSIM
         *            value of {@code experienceBlockErrorDialogWhenNoSIM} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder experienceBlockErrorDialogWhenNoSIM(Boolean experienceBlockErrorDialogWhenNoSIM) {
            this.experienceBlockErrorDialogWhenNoSIM = experienceBlockErrorDialogWhenNoSIM;
            this.changedFields = changedFields.add("experienceBlockErrorDialogWhenNoSIM");
            return this;
        }

        /**
         * <i>“Indicates whether or not to enable task switching on the device.”</i>
         * 
         * @param experienceBlockTaskSwitcher
         *            value of {@code experienceBlockTaskSwitcher} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder experienceBlockTaskSwitcher(Boolean experienceBlockTaskSwitcher) {
            this.experienceBlockTaskSwitcher = experienceBlockTaskSwitcher;
            this.changedFields = changedFields.add("experienceBlockTaskSwitcher");
            return this;
        }

        /**
         * <i>“Allow or prevent the syncing of Microsoft Edge Browser settings. Option for IT
         * admins to prevent syncing across devices, but allow user override.”</i>
         * 
         * @param experienceDoNotSyncBrowserSettings
         *            value of {@code experienceDoNotSyncBrowserSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder experienceDoNotSyncBrowserSettings(BrowserSyncSetting experienceDoNotSyncBrowserSettings) {
            this.experienceDoNotSyncBrowserSettings = experienceDoNotSyncBrowserSettings;
            this.changedFields = changedFields.add("experienceDoNotSyncBrowserSettings");
            return this;
        }

        /**
         * <i>“Controls if the user can configure search to Find My Files mode, which searches
         * files in secondary hard drives and also outside of the user profile. Find My
         * Files does not allow users to search files or locations to which they do not
         * have access.”</i>
         * 
         * @param findMyFiles
         *            value of {@code findMyFiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder findMyFiles(Enablement findMyFiles) {
            this.findMyFiles = findMyFiles;
            this.changedFields = changedFields.add("findMyFiles");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block DVR and broadcasting.”</i>
         * 
         * @param gameDvrBlocked
         *            value of {@code gameDvrBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder gameDvrBlocked(Boolean gameDvrBlocked) {
            this.gameDvrBlocked = gameDvrBlocked;
            this.changedFields = changedFields.add("gameDvrBlocked");
            return this;
        }

        /**
         * <i>“Controls the user access to the ink workspace, from the desktop and from above
         * the lock screen.”</i>
         * 
         * @param inkWorkspaceAccess
         *            value of {@code inkWorkspaceAccess} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder inkWorkspaceAccess(InkAccessSetting inkWorkspaceAccess) {
            this.inkWorkspaceAccess = inkWorkspaceAccess;
            this.changedFields = changedFields.add("inkWorkspaceAccess");
            return this;
        }

        /**
         * <i>“Controls the user access to the ink workspace, from the desktop and from above
         * the lock screen.”</i>
         * 
         * @param inkWorkspaceAccessState
         *            value of {@code inkWorkspaceAccessState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder inkWorkspaceAccessState(StateManagementSetting inkWorkspaceAccessState) {
            this.inkWorkspaceAccessState = inkWorkspaceAccessState;
            this.changedFields = changedFields.add("inkWorkspaceAccessState");
            return this;
        }

        /**
         * <i>“Specify whether to show recommended app suggestions in the ink workspace.”</i>
         * 
         * @param inkWorkspaceBlockSuggestedApps
         *            value of {@code inkWorkspaceBlockSuggestedApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder inkWorkspaceBlockSuggestedApps(Boolean inkWorkspaceBlockSuggestedApps) {
            this.inkWorkspaceBlockSuggestedApps = inkWorkspaceBlockSuggestedApps;
            this.changedFields = changedFields.add("inkWorkspaceBlockSuggestedApps");
            return this;
        }

        /**
         * <i>“Indicates whether or not to Block the user from using internet sharing.”</i>
         * 
         * @param internetSharingBlocked
         *            value of {@code internetSharingBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder internetSharingBlocked(Boolean internetSharingBlocked) {
            this.internetSharingBlocked = internetSharingBlocked;
            this.changedFields = changedFields.add("internetSharingBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to Block the user from location services.”</i>
         * 
         * @param locationServicesBlocked
         *            value of {@code locationServicesBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder locationServicesBlocked(Boolean locationServicesBlocked) {
            this.locationServicesBlocked = locationServicesBlocked;
            this.changedFields = changedFields.add("locationServicesBlocked");
            return this;
        }

        /**
         * <i>“This policy setting specifies whether Windows apps can be activated by voice
         * while the system is locked.”</i>
         * 
         * @param lockScreenActivateAppsWithVoice
         *            value of {@code lockScreenActivateAppsWithVoice} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lockScreenActivateAppsWithVoice(Enablement lockScreenActivateAppsWithVoice) {
            this.lockScreenActivateAppsWithVoice = lockScreenActivateAppsWithVoice;
            this.changedFields = changedFields.add("lockScreenActivateAppsWithVoice");
            return this;
        }

        /**
         * <i>“Specify whether to show a user-configurable setting to control the screen
         * timeout while on the lock screen of Windows 10 Mobile devices. If this policy is
         * set to Allow, the value set by lockScreenTimeoutInSeconds is ignored.”</i>
         * 
         * @param lockScreenAllowTimeoutConfiguration
         *            value of {@code lockScreenAllowTimeoutConfiguration} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lockScreenAllowTimeoutConfiguration(Boolean lockScreenAllowTimeoutConfiguration) {
            this.lockScreenAllowTimeoutConfiguration = lockScreenAllowTimeoutConfiguration;
            this.changedFields = changedFields.add("lockScreenAllowTimeoutConfiguration");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block action center notifications over lock screen.”</i>
         * 
         * @param lockScreenBlockActionCenterNotifications
         *            value of {@code lockScreenBlockActionCenterNotifications} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lockScreenBlockActionCenterNotifications(Boolean lockScreenBlockActionCenterNotifications) {
            this.lockScreenBlockActionCenterNotifications = lockScreenBlockActionCenterNotifications;
            this.changedFields = changedFields.add("lockScreenBlockActionCenterNotifications");
            return this;
        }

        /**
         * <i>“Indicates whether or not the user can interact with Cortana using speech while
         * the system is locked.”</i>
         * 
         * @param lockScreenBlockCortana
         *            value of {@code lockScreenBlockCortana} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lockScreenBlockCortana(Boolean lockScreenBlockCortana) {
            this.lockScreenBlockCortana = lockScreenBlockCortana;
            this.changedFields = changedFields.add("lockScreenBlockCortana");
            return this;
        }

        /**
         * <i>“Indicates whether to allow toast notifications above the device lock screen.”</i>
         * 
         * @param lockScreenBlockToastNotifications
         *            value of {@code lockScreenBlockToastNotifications} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lockScreenBlockToastNotifications(Boolean lockScreenBlockToastNotifications) {
            this.lockScreenBlockToastNotifications = lockScreenBlockToastNotifications;
            this.changedFields = changedFields.add("lockScreenBlockToastNotifications");
            return this;
        }

        /**
         * <i>“Set the duration (in seconds) from the screen locking to the screen turning off
         * for Windows 10 Mobile devices. Supported values are 11-1800. Valid values 11 to
         * 1800”</i>
         * 
         * @param lockScreenTimeoutInSeconds
         *            value of {@code lockScreenTimeoutInSeconds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lockScreenTimeoutInSeconds(Integer lockScreenTimeoutInSeconds) {
            this.lockScreenTimeoutInSeconds = lockScreenTimeoutInSeconds;
            this.changedFields = changedFields.add("lockScreenTimeoutInSeconds");
            return this;
        }

        /**
         * <i>“Disables the ability to quickly switch between users that are logged on
         * simultaneously without logging off.”</i>
         * 
         * @param logonBlockFastUserSwitching
         *            value of {@code logonBlockFastUserSwitching} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder logonBlockFastUserSwitching(Boolean logonBlockFastUserSwitching) {
            this.logonBlockFastUserSwitching = logonBlockFastUserSwitching;
            this.changedFields = changedFields.add("logonBlockFastUserSwitching");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the MMS send/receive functionality on the
         * device.”</i>
         * 
         * @param messagingBlockMMS
         *            value of {@code messagingBlockMMS} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder messagingBlockMMS(Boolean messagingBlockMMS) {
            this.messagingBlockMMS = messagingBlockMMS;
            this.changedFields = changedFields.add("messagingBlockMMS");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the RCS send/receive functionality on the
         * device.”</i>
         * 
         * @param messagingBlockRichCommunicationServices
         *            value of {@code messagingBlockRichCommunicationServices} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder messagingBlockRichCommunicationServices(Boolean messagingBlockRichCommunicationServices) {
            this.messagingBlockRichCommunicationServices = messagingBlockRichCommunicationServices;
            this.changedFields = changedFields.add("messagingBlockRichCommunicationServices");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block text message back up and restore and Messaging
         * Everywhere.”</i>
         * 
         * @param messagingBlockSync
         *            value of {@code messagingBlockSync} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder messagingBlockSync(Boolean messagingBlockSync) {
            this.messagingBlockSync = messagingBlockSync;
            this.changedFields = changedFields.add("messagingBlockSync");
            return this;
        }

        /**
         * <i>“Indicates whether or not to Block a Microsoft account.”</i>
         * 
         * @param microsoftAccountBlocked
         *            value of {@code microsoftAccountBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftAccountBlocked(Boolean microsoftAccountBlocked) {
            this.microsoftAccountBlocked = microsoftAccountBlocked;
            this.changedFields = changedFields.add("microsoftAccountBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to Block Microsoft account settings sync.”</i>
         * 
         * @param microsoftAccountBlockSettingsSync
         *            value of {@code microsoftAccountBlockSettingsSync} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftAccountBlockSettingsSync(Boolean microsoftAccountBlockSettingsSync) {
            this.microsoftAccountBlockSettingsSync = microsoftAccountBlockSettingsSync;
            this.changedFields = changedFields.add("microsoftAccountBlockSettingsSync");
            return this;
        }

        /**
         * <i>“Controls the Microsoft Account Sign-In Assistant (wlidsvc) NT service.”</i>
         * 
         * @param microsoftAccountSignInAssistantSettings
         *            value of {@code microsoftAccountSignInAssistantSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftAccountSignInAssistantSettings(SignInAssistantOptions microsoftAccountSignInAssistantSettings) {
            this.microsoftAccountSignInAssistantSettings = microsoftAccountSignInAssistantSettings;
            this.changedFields = changedFields.add("microsoftAccountSignInAssistantSettings");
            return this;
        }

        /**
         * <i>“If set, proxy settings will be applied to all processes and accounts in the
         * device. Otherwise, it will be applied to the user account that’s enrolled into
         * MDM.”</i>
         * 
         * @param networkProxyApplySettingsDeviceWide
         *            value of {@code networkProxyApplySettingsDeviceWide} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder networkProxyApplySettingsDeviceWide(Boolean networkProxyApplySettingsDeviceWide) {
            this.networkProxyApplySettingsDeviceWide = networkProxyApplySettingsDeviceWide;
            this.changedFields = changedFields.add("networkProxyApplySettingsDeviceWide");
            return this;
        }

        /**
         * <i>“Address to the proxy auto-config (PAC) script you want to use.”</i>
         * 
         * @param networkProxyAutomaticConfigurationUrl
         *            value of {@code networkProxyAutomaticConfigurationUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder networkProxyAutomaticConfigurationUrl(String networkProxyAutomaticConfigurationUrl) {
            this.networkProxyAutomaticConfigurationUrl = networkProxyAutomaticConfigurationUrl;
            this.changedFields = changedFields.add("networkProxyAutomaticConfigurationUrl");
            return this;
        }

        /**
         * <i>“Disable automatic detection of settings. If enabled, the system will try to find
         * the path to a proxy auto-config (PAC) script.”</i>
         * 
         * @param networkProxyDisableAutoDetect
         *            value of {@code networkProxyDisableAutoDetect} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder networkProxyDisableAutoDetect(Boolean networkProxyDisableAutoDetect) {
            this.networkProxyDisableAutoDetect = networkProxyDisableAutoDetect;
            this.changedFields = changedFields.add("networkProxyDisableAutoDetect");
            return this;
        }

        /**
         * <i>“Specifies manual proxy server settings.”</i>
         * 
         * @param networkProxyServer
         *            value of {@code networkProxyServer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder networkProxyServer(Windows10NetworkProxyServer networkProxyServer) {
            this.networkProxyServer = networkProxyServer;
            this.changedFields = changedFields.add("networkProxyServer");
            return this;
        }

        /**
         * <i>“Indicates whether or not to Block the user from using near field communication.”</i>
         * 
         * @param nfcBlocked
         *            value of {@code nfcBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder nfcBlocked(Boolean nfcBlocked) {
            this.nfcBlocked = nfcBlocked;
            this.changedFields = changedFields.add("nfcBlocked");
            return this;
        }

        /**
         * <i>“Gets or sets a value allowing IT admins to prevent apps and features from
         * working with files on OneDrive.”</i>
         * 
         * @param oneDriveDisableFileSync
         *            value of {@code oneDriveDisableFileSync} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder oneDriveDisableFileSync(Boolean oneDriveDisableFileSync) {
            this.oneDriveDisableFileSync = oneDriveDisableFileSync;
            this.changedFields = changedFields.add("oneDriveDisableFileSync");
            return this;
        }

        /**
         * <i>“Specify whether PINs or passwords such as "1111" or "1234" are allowed. For
         * Windows 10 desktops, it also controls the use of picture passwords.”</i>
         * 
         * @param passwordBlockSimple
         *            value of {@code passwordBlockSimple} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordBlockSimple(Boolean passwordBlockSimple) {
            this.passwordBlockSimple = passwordBlockSimple;
            this.changedFields = changedFields.add("passwordBlockSimple");
            return this;
        }

        /**
         * <i>“The password expiration in days. Valid values 0 to 730”</i>
         * 
         * @param passwordExpirationDays
         *            value of {@code passwordExpirationDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordExpirationDays(Integer passwordExpirationDays) {
            this.passwordExpirationDays = passwordExpirationDays;
            this.changedFields = changedFields.add("passwordExpirationDays");
            return this;
        }

        /**
         * <i>“This security setting determines the period of time (in days) that a password
         * must be used before the user can change it. Valid values 0 to 998”</i>
         * 
         * @param passwordMinimumAgeInDays
         *            value of {@code passwordMinimumAgeInDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinimumAgeInDays(Integer passwordMinimumAgeInDays) {
            this.passwordMinimumAgeInDays = passwordMinimumAgeInDays;
            this.changedFields = changedFields.add("passwordMinimumAgeInDays");
            return this;
        }

        /**
         * <i>“The number of character sets required in the password.”</i>
         * 
         * @param passwordMinimumCharacterSetCount
         *            value of {@code passwordMinimumCharacterSetCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinimumCharacterSetCount(Integer passwordMinimumCharacterSetCount) {
            this.passwordMinimumCharacterSetCount = passwordMinimumCharacterSetCount;
            this.changedFields = changedFields.add("passwordMinimumCharacterSetCount");
            return this;
        }

        /**
         * <i>“The minimum password length. Valid values 4 to 16”</i>
         * 
         * @param passwordMinimumLength
         *            value of {@code passwordMinimumLength} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinimumLength(Integer passwordMinimumLength) {
            this.passwordMinimumLength = passwordMinimumLength;
            this.changedFields = changedFields.add("passwordMinimumLength");
            return this;
        }

        /**
         * <i>“The minutes of inactivity before the screen times out.”</i>
         * 
         * @param passwordMinutesOfInactivityBeforeScreenTimeout
         *            value of {@code passwordMinutesOfInactivityBeforeScreenTimeout} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinutesOfInactivityBeforeScreenTimeout(Integer passwordMinutesOfInactivityBeforeScreenTimeout) {
            this.passwordMinutesOfInactivityBeforeScreenTimeout = passwordMinutesOfInactivityBeforeScreenTimeout;
            this.changedFields = changedFields.add("passwordMinutesOfInactivityBeforeScreenTimeout");
            return this;
        }

        /**
         * <i>“The number of previous passwords to prevent reuse of. Valid values 0 to 50”</i>
         * 
         * @param passwordPreviousPasswordBlockCount
         *            value of {@code passwordPreviousPasswordBlockCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordPreviousPasswordBlockCount(Integer passwordPreviousPasswordBlockCount) {
            this.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
            this.changedFields = changedFields.add("passwordPreviousPasswordBlockCount");
            return this;
        }

        /**
         * <i>“Indicates whether or not to require the user to have a password.”</i>
         * 
         * @param passwordRequired
         *            value of {@code passwordRequired} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordRequired(Boolean passwordRequired) {
            this.passwordRequired = passwordRequired;
            this.changedFields = changedFields.add("passwordRequired");
            return this;
        }

        /**
         * <i>“The required password type.”</i>
         * 
         * @param passwordRequiredType
         *            value of {@code passwordRequiredType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordRequiredType(RequiredPasswordType passwordRequiredType) {
            this.passwordRequiredType = passwordRequiredType;
            this.changedFields = changedFields.add("passwordRequiredType");
            return this;
        }

        /**
         * <i>“Indicates whether or not to require a password upon resuming from an idle state.”</i>
         * 
         * @param passwordRequireWhenResumeFromIdleState
         *            value of {@code passwordRequireWhenResumeFromIdleState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordRequireWhenResumeFromIdleState(Boolean passwordRequireWhenResumeFromIdleState) {
            this.passwordRequireWhenResumeFromIdleState = passwordRequireWhenResumeFromIdleState;
            this.changedFields = changedFields.add("passwordRequireWhenResumeFromIdleState");
            return this;
        }

        /**
         * <i>“The number of sign in failures before factory reset. Valid values 0 to 999”</i>
         * 
         * @param passwordSignInFailureCountBeforeFactoryReset
         *            value of {@code passwordSignInFailureCountBeforeFactoryReset} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordSignInFailureCountBeforeFactoryReset(Integer passwordSignInFailureCountBeforeFactoryReset) {
            this.passwordSignInFailureCountBeforeFactoryReset = passwordSignInFailureCountBeforeFactoryReset;
            this.changedFields = changedFields.add("passwordSignInFailureCountBeforeFactoryReset");
            return this;
        }

        /**
         * <i>“A http or https Url to a jpg, jpeg or png image that needs to be downloaded and
         * used as the Desktop Image or a file Url to a local image on the file system that
         * needs to used as the Desktop Image.”</i>
         * 
         * @param personalizationDesktopImageUrl
         *            value of {@code personalizationDesktopImageUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder personalizationDesktopImageUrl(String personalizationDesktopImageUrl) {
            this.personalizationDesktopImageUrl = personalizationDesktopImageUrl;
            this.changedFields = changedFields.add("personalizationDesktopImageUrl");
            return this;
        }

        /**
         * <i>“A http or https Url to a jpg, jpeg or png image that neeeds to be downloaded and
         * used as the Lock Screen Image or a file Url to a local image on the file system
         * that needs to be used as the Lock Screen Image.”</i>
         * 
         * @param personalizationLockScreenImageUrl
         *            value of {@code personalizationLockScreenImageUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder personalizationLockScreenImageUrl(String personalizationLockScreenImageUrl) {
            this.personalizationLockScreenImageUrl = personalizationLockScreenImageUrl;
            this.changedFields = changedFields.add("personalizationLockScreenImageUrl");
            return this;
        }

        /**
         * <i>“This setting specifies the action that Windows takes when a user presses the
         * Power button while on battery.”</i>
         * 
         * @param powerButtonActionOnBattery
         *            value of {@code powerButtonActionOnBattery} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder powerButtonActionOnBattery(PowerActionType powerButtonActionOnBattery) {
            this.powerButtonActionOnBattery = powerButtonActionOnBattery;
            this.changedFields = changedFields.add("powerButtonActionOnBattery");
            return this;
        }

        /**
         * <i>“This setting specifies the action that Windows takes when a user presses the
         * Power button while plugged in.”</i>
         * 
         * @param powerButtonActionPluggedIn
         *            value of {@code powerButtonActionPluggedIn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder powerButtonActionPluggedIn(PowerActionType powerButtonActionPluggedIn) {
            this.powerButtonActionPluggedIn = powerButtonActionPluggedIn;
            this.changedFields = changedFields.add("powerButtonActionPluggedIn");
            return this;
        }

        /**
         * <i>“This setting allows you to turn off hybrid sleep while on battery. If you set
         * this setting to disable, a hiberfile is not generated when the system
         * transitions to sleep (Stand By). If you set this setting to enable or do not
         * configure this policy setting, users control this setting.”</i>
         * 
         * @param powerHybridSleepOnBattery
         *            value of {@code powerHybridSleepOnBattery} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder powerHybridSleepOnBattery(Enablement powerHybridSleepOnBattery) {
            this.powerHybridSleepOnBattery = powerHybridSleepOnBattery;
            this.changedFields = changedFields.add("powerHybridSleepOnBattery");
            return this;
        }

        /**
         * <i>“This setting allows you to turn off hybrid sleep while plugged in. If you set
         * this setting to disable, a hiberfile is not generated when the system
         * transitions to sleep (Stand By). If you set this setting to enable or do not
         * configure this policy setting, users control this setting.”</i>
         * 
         * @param powerHybridSleepPluggedIn
         *            value of {@code powerHybridSleepPluggedIn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder powerHybridSleepPluggedIn(Enablement powerHybridSleepPluggedIn) {
            this.powerHybridSleepPluggedIn = powerHybridSleepPluggedIn;
            this.changedFields = changedFields.add("powerHybridSleepPluggedIn");
            return this;
        }

        /**
         * <i>“This setting specifies the action that Windows takes when a user closes the lid
         * on a mobile PC while on battery.”</i>
         * 
         * @param powerLidCloseActionOnBattery
         *            value of {@code powerLidCloseActionOnBattery} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder powerLidCloseActionOnBattery(PowerActionType powerLidCloseActionOnBattery) {
            this.powerLidCloseActionOnBattery = powerLidCloseActionOnBattery;
            this.changedFields = changedFields.add("powerLidCloseActionOnBattery");
            return this;
        }

        /**
         * <i>“This setting specifies the action that Windows takes when a user closes the lid
         * on a mobile PC while plugged in.”</i>
         * 
         * @param powerLidCloseActionPluggedIn
         *            value of {@code powerLidCloseActionPluggedIn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder powerLidCloseActionPluggedIn(PowerActionType powerLidCloseActionPluggedIn) {
            this.powerLidCloseActionPluggedIn = powerLidCloseActionPluggedIn;
            this.changedFields = changedFields.add("powerLidCloseActionPluggedIn");
            return this;
        }

        /**
         * <i>“This setting specifies the action that Windows takes when a user presses the
         * Sleep button while on battery.”</i>
         * 
         * @param powerSleepButtonActionOnBattery
         *            value of {@code powerSleepButtonActionOnBattery} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder powerSleepButtonActionOnBattery(PowerActionType powerSleepButtonActionOnBattery) {
            this.powerSleepButtonActionOnBattery = powerSleepButtonActionOnBattery;
            this.changedFields = changedFields.add("powerSleepButtonActionOnBattery");
            return this;
        }

        /**
         * <i>“This setting specifies the action that Windows takes when a user presses the
         * Sleep button while plugged in.”</i>
         * 
         * @param powerSleepButtonActionPluggedIn
         *            value of {@code powerSleepButtonActionPluggedIn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder powerSleepButtonActionPluggedIn(PowerActionType powerSleepButtonActionPluggedIn) {
            this.powerSleepButtonActionPluggedIn = powerSleepButtonActionPluggedIn;
            this.changedFields = changedFields.add("powerSleepButtonActionPluggedIn");
            return this;
        }

        /**
         * <i>“Prevent user installation of additional printers from printers settings.”</i>
         * 
         * @param printerBlockAddition
         *            value of {@code printerBlockAddition} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder printerBlockAddition(Boolean printerBlockAddition) {
            this.printerBlockAddition = printerBlockAddition;
            this.changedFields = changedFields.add("printerBlockAddition");
            return this;
        }

        /**
         * <i>“Name (network host name) of an installed printer.”</i>
         * 
         * @param printerDefaultName
         *            value of {@code printerDefaultName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder printerDefaultName(String printerDefaultName) {
            this.printerDefaultName = printerDefaultName;
            this.changedFields = changedFields.add("printerDefaultName");
            return this;
        }

        /**
         * <i>“Automatically provision printers based on their names (network host names).”</i>
         * 
         * @param printerNames
         *            value of {@code printerNames} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder printerNames(List<String> printerNames) {
            this.printerNames = printerNames;
            this.changedFields = changedFields.add("printerNames");
            return this;
        }

        /**
         * <i>“Automatically provision printers based on their names (network host names).”</i>
         * 
         * @param printerNames
         *            value of {@code printerNames} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder printerNames(String... printerNames) {
            return printerNames(Arrays.asList(printerNames));
        }

        /**
         * <i>“Automatically provision printers based on their names (network host names).”</i>
         * 
         * @param printerNamesNextLink
         *            value of {@code printerNames@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder printerNamesNextLink(String printerNamesNextLink) {
            this.printerNamesNextLink = printerNamesNextLink;
            this.changedFields = changedFields.add("printerNames");
            return this;
        }

        /**
         * <i>“Enables or disables the use of advertising ID. Added in Windows 10, version 1607
         * .”</i>
         * 
         * @param privacyAdvertisingId
         *            value of {@code privacyAdvertisingId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder privacyAdvertisingId(StateManagementSetting privacyAdvertisingId) {
            this.privacyAdvertisingId = privacyAdvertisingId;
            this.changedFields = changedFields.add("privacyAdvertisingId");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow the automatic acceptance of the pairing and
         * privacy user consent dialog when launching apps.”</i>
         * 
         * @param privacyAutoAcceptPairingAndConsentPrompts
         *            value of {@code privacyAutoAcceptPairingAndConsentPrompts} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder privacyAutoAcceptPairingAndConsentPrompts(Boolean privacyAutoAcceptPairingAndConsentPrompts) {
            this.privacyAutoAcceptPairingAndConsentPrompts = privacyAutoAcceptPairingAndConsentPrompts;
            this.changedFields = changedFields.add("privacyAutoAcceptPairingAndConsentPrompts");
            return this;
        }

        /**
         * <i>“Blocks the usage of cloud based speech services for Cortana, Dictation, or Store
         * applications.”</i>
         * 
         * @param privacyBlockActivityFeed
         *            value of {@code privacyBlockActivityFeed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder privacyBlockActivityFeed(Boolean privacyBlockActivityFeed) {
            this.privacyBlockActivityFeed = privacyBlockActivityFeed;
            this.changedFields = changedFields.add("privacyBlockActivityFeed");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the usage of cloud based speech services for
         * Cortana, Dictation, or Store applications.”</i>
         * 
         * @param privacyBlockInputPersonalization
         *            value of {@code privacyBlockInputPersonalization} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder privacyBlockInputPersonalization(Boolean privacyBlockInputPersonalization) {
            this.privacyBlockInputPersonalization = privacyBlockInputPersonalization;
            this.changedFields = changedFields.add("privacyBlockInputPersonalization");
            return this;
        }

        /**
         * <i>“Blocks the shared experiences/discovery of recently used resources in task
         * switcher etc.”</i>
         * 
         * @param privacyBlockPublishUserActivities
         *            value of {@code privacyBlockPublishUserActivities} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder privacyBlockPublishUserActivities(Boolean privacyBlockPublishUserActivities) {
            this.privacyBlockPublishUserActivities = privacyBlockPublishUserActivities;
            this.changedFields = changedFields.add("privacyBlockPublishUserActivities");
            return this;
        }

        /**
         * <i>“This policy prevents the privacy experience from launching during user logon for
         * new and upgraded users.​”</i>
         * 
         * @param privacyDisableLaunchExperience
         *            value of {@code privacyDisableLaunchExperience} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder privacyDisableLaunchExperience(Boolean privacyDisableLaunchExperience) {
            this.privacyDisableLaunchExperience = privacyDisableLaunchExperience;
            this.changedFields = changedFields.add("privacyDisableLaunchExperience");
            return this;
        }

        /**
         * <i>“Indicates whether or not to Block the user from reset protection mode.”</i>
         * 
         * @param resetProtectionModeBlocked
         *            value of {@code resetProtectionModeBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resetProtectionModeBlocked(Boolean resetProtectionModeBlocked) {
            this.resetProtectionModeBlocked = resetProtectionModeBlocked;
            this.changedFields = changedFields.add("resetProtectionModeBlocked");
            return this;
        }

        /**
         * <i>“Specifies what filter level of safe search is required.”</i>
         * 
         * @param safeSearchFilter
         *            value of {@code safeSearchFilter} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder safeSearchFilter(SafeSearchFilterType safeSearchFilter) {
            this.safeSearchFilter = safeSearchFilter;
            this.changedFields = changedFields.add("safeSearchFilter");
            return this;
        }

        /**
         * <i>“Indicates whether or not to Block the user from taking Screenshots.”</i>
         * 
         * @param screenCaptureBlocked
         *            value of {@code screenCaptureBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder screenCaptureBlocked(Boolean screenCaptureBlocked) {
            this.screenCaptureBlocked = screenCaptureBlocked;
            this.changedFields = changedFields.add("screenCaptureBlocked");
            return this;
        }

        /**
         * <i>“Specifies if search can use diacritics.”</i>
         * 
         * @param searchBlockDiacritics
         *            value of {@code searchBlockDiacritics} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder searchBlockDiacritics(Boolean searchBlockDiacritics) {
            this.searchBlockDiacritics = searchBlockDiacritics;
            this.changedFields = changedFields.add("searchBlockDiacritics");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the web search.”</i>
         * 
         * @param searchBlockWebResults
         *            value of {@code searchBlockWebResults} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder searchBlockWebResults(Boolean searchBlockWebResults) {
            this.searchBlockWebResults = searchBlockWebResults;
            this.changedFields = changedFields.add("searchBlockWebResults");
            return this;
        }

        /**
         * <i>“Specifies whether to use automatic language detection when indexing content and
         * properties.”</i>
         * 
         * @param searchDisableAutoLanguageDetection
         *            value of {@code searchDisableAutoLanguageDetection} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder searchDisableAutoLanguageDetection(Boolean searchDisableAutoLanguageDetection) {
            this.searchDisableAutoLanguageDetection = searchDisableAutoLanguageDetection;
            this.changedFields = changedFields.add("searchDisableAutoLanguageDetection");
            return this;
        }

        /**
         * <i>“Indicates whether or not to disable the search indexer backoff feature.”</i>
         * 
         * @param searchDisableIndexerBackoff
         *            value of {@code searchDisableIndexerBackoff} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder searchDisableIndexerBackoff(Boolean searchDisableIndexerBackoff) {
            this.searchDisableIndexerBackoff = searchDisableIndexerBackoff;
            this.changedFields = changedFields.add("searchDisableIndexerBackoff");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block indexing of WIP-protected items to prevent
         * them from appearing in search results for Cortana or Explorer.”</i>
         * 
         * @param searchDisableIndexingEncryptedItems
         *            value of {@code searchDisableIndexingEncryptedItems} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder searchDisableIndexingEncryptedItems(Boolean searchDisableIndexingEncryptedItems) {
            this.searchDisableIndexingEncryptedItems = searchDisableIndexingEncryptedItems;
            this.changedFields = changedFields.add("searchDisableIndexingEncryptedItems");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow users to add locations on removable drives to
         * libraries and to be indexed.”</i>
         * 
         * @param searchDisableIndexingRemovableDrive
         *            value of {@code searchDisableIndexingRemovableDrive} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder searchDisableIndexingRemovableDrive(Boolean searchDisableIndexingRemovableDrive) {
            this.searchDisableIndexingRemovableDrive = searchDisableIndexingRemovableDrive;
            this.changedFields = changedFields.add("searchDisableIndexingRemovableDrive");
            return this;
        }

        /**
         * <i>“Specifies if search can use location information.”</i>
         * 
         * @param searchDisableLocation
         *            value of {@code searchDisableLocation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder searchDisableLocation(Boolean searchDisableLocation) {
            this.searchDisableLocation = searchDisableLocation;
            this.changedFields = changedFields.add("searchDisableLocation");
            return this;
        }

        /**
         * <i>“Specifies if search can use location information.”</i>
         * 
         * @param searchDisableUseLocation
         *            value of {@code searchDisableUseLocation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder searchDisableUseLocation(Boolean searchDisableUseLocation) {
            this.searchDisableUseLocation = searchDisableUseLocation;
            this.changedFields = changedFields.add("searchDisableUseLocation");
            return this;
        }

        /**
         * <i>“Specifies minimum amount of hard drive space on the same drive as the index
         * location before indexing stops.”</i>
         * 
         * @param searchEnableAutomaticIndexSizeManangement
         *            value of {@code searchEnableAutomaticIndexSizeManangement} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder searchEnableAutomaticIndexSizeManangement(Boolean searchEnableAutomaticIndexSizeManangement) {
            this.searchEnableAutomaticIndexSizeManangement = searchEnableAutomaticIndexSizeManangement;
            this.changedFields = changedFields.add("searchEnableAutomaticIndexSizeManangement");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block remote queries of this computer’s index.”</i>
         * 
         * @param searchEnableRemoteQueries
         *            value of {@code searchEnableRemoteQueries} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder searchEnableRemoteQueries(Boolean searchEnableRemoteQueries) {
            this.searchEnableRemoteQueries = searchEnableRemoteQueries;
            this.changedFields = changedFields.add("searchEnableRemoteQueries");
            return this;
        }

        /**
         * <i>“Specify whether to allow automatic device encryption during OOBE when the device
         * is Azure AD joined (desktop only).”</i>
         * 
         * @param securityBlockAzureADJoinedDevicesAutoEncryption
         *            value of {@code securityBlockAzureADJoinedDevicesAutoEncryption} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder securityBlockAzureADJoinedDevicesAutoEncryption(Boolean securityBlockAzureADJoinedDevicesAutoEncryption) {
            this.securityBlockAzureADJoinedDevicesAutoEncryption = securityBlockAzureADJoinedDevicesAutoEncryption;
            this.changedFields = changedFields.add("securityBlockAzureADJoinedDevicesAutoEncryption");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block access to Accounts in Settings app.”</i>
         * 
         * @param settingsBlockAccountsPage
         *            value of {@code settingsBlockAccountsPage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingsBlockAccountsPage(Boolean settingsBlockAccountsPage) {
            this.settingsBlockAccountsPage = settingsBlockAccountsPage;
            this.changedFields = changedFields.add("settingsBlockAccountsPage");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from installing provisioning packages
         * .”</i>
         * 
         * @param settingsBlockAddProvisioningPackage
         *            value of {@code settingsBlockAddProvisioningPackage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingsBlockAddProvisioningPackage(Boolean settingsBlockAddProvisioningPackage) {
            this.settingsBlockAddProvisioningPackage = settingsBlockAddProvisioningPackage;
            this.changedFields = changedFields.add("settingsBlockAddProvisioningPackage");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block access to Apps in Settings app.”</i>
         * 
         * @param settingsBlockAppsPage
         *            value of {@code settingsBlockAppsPage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingsBlockAppsPage(Boolean settingsBlockAppsPage) {
            this.settingsBlockAppsPage = settingsBlockAppsPage;
            this.changedFields = changedFields.add("settingsBlockAppsPage");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from changing the language settings.”</i>
         * 
         * @param settingsBlockChangeLanguage
         *            value of {@code settingsBlockChangeLanguage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingsBlockChangeLanguage(Boolean settingsBlockChangeLanguage) {
            this.settingsBlockChangeLanguage = settingsBlockChangeLanguage;
            this.changedFields = changedFields.add("settingsBlockChangeLanguage");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from changing power and sleep
         * settings.”</i>
         * 
         * @param settingsBlockChangePowerSleep
         *            value of {@code settingsBlockChangePowerSleep} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingsBlockChangePowerSleep(Boolean settingsBlockChangePowerSleep) {
            this.settingsBlockChangePowerSleep = settingsBlockChangePowerSleep;
            this.changedFields = changedFields.add("settingsBlockChangePowerSleep");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from changing the region settings.”</i>
         * 
         * @param settingsBlockChangeRegion
         *            value of {@code settingsBlockChangeRegion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingsBlockChangeRegion(Boolean settingsBlockChangeRegion) {
            this.settingsBlockChangeRegion = settingsBlockChangeRegion;
            this.changedFields = changedFields.add("settingsBlockChangeRegion");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from changing date and time settings.”</i>
         * 
         * @param settingsBlockChangeSystemTime
         *            value of {@code settingsBlockChangeSystemTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingsBlockChangeSystemTime(Boolean settingsBlockChangeSystemTime) {
            this.settingsBlockChangeSystemTime = settingsBlockChangeSystemTime;
            this.changedFields = changedFields.add("settingsBlockChangeSystemTime");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block access to Devices in Settings app.”</i>
         * 
         * @param settingsBlockDevicesPage
         *            value of {@code settingsBlockDevicesPage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingsBlockDevicesPage(Boolean settingsBlockDevicesPage) {
            this.settingsBlockDevicesPage = settingsBlockDevicesPage;
            this.changedFields = changedFields.add("settingsBlockDevicesPage");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block access to Ease of Access in Settings app.”</i>
         * 
         * @param settingsBlockEaseOfAccessPage
         *            value of {@code settingsBlockEaseOfAccessPage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingsBlockEaseOfAccessPage(Boolean settingsBlockEaseOfAccessPage) {
            this.settingsBlockEaseOfAccessPage = settingsBlockEaseOfAccessPage;
            this.changedFields = changedFields.add("settingsBlockEaseOfAccessPage");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from editing the device name.”</i>
         * 
         * @param settingsBlockEditDeviceName
         *            value of {@code settingsBlockEditDeviceName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingsBlockEditDeviceName(Boolean settingsBlockEditDeviceName) {
            this.settingsBlockEditDeviceName = settingsBlockEditDeviceName;
            this.changedFields = changedFields.add("settingsBlockEditDeviceName");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block access to Gaming in Settings app.”</i>
         * 
         * @param settingsBlockGamingPage
         *            value of {@code settingsBlockGamingPage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingsBlockGamingPage(Boolean settingsBlockGamingPage) {
            this.settingsBlockGamingPage = settingsBlockGamingPage;
            this.changedFields = changedFields.add("settingsBlockGamingPage");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block access to Network &amp; Internet in Settings app.”</i>
         * 
         * @param settingsBlockNetworkInternetPage
         *            value of {@code settingsBlockNetworkInternetPage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingsBlockNetworkInternetPage(Boolean settingsBlockNetworkInternetPage) {
            this.settingsBlockNetworkInternetPage = settingsBlockNetworkInternetPage;
            this.changedFields = changedFields.add("settingsBlockNetworkInternetPage");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block access to Personalization in Settings app.”</i>
         * 
         * @param settingsBlockPersonalizationPage
         *            value of {@code settingsBlockPersonalizationPage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingsBlockPersonalizationPage(Boolean settingsBlockPersonalizationPage) {
            this.settingsBlockPersonalizationPage = settingsBlockPersonalizationPage;
            this.changedFields = changedFields.add("settingsBlockPersonalizationPage");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block access to Privacy in Settings app.”</i>
         * 
         * @param settingsBlockPrivacyPage
         *            value of {@code settingsBlockPrivacyPage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingsBlockPrivacyPage(Boolean settingsBlockPrivacyPage) {
            this.settingsBlockPrivacyPage = settingsBlockPrivacyPage;
            this.changedFields = changedFields.add("settingsBlockPrivacyPage");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the runtime configuration agent from removing
         * provisioning packages.”</i>
         * 
         * @param settingsBlockRemoveProvisioningPackage
         *            value of {@code settingsBlockRemoveProvisioningPackage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingsBlockRemoveProvisioningPackage(Boolean settingsBlockRemoveProvisioningPackage) {
            this.settingsBlockRemoveProvisioningPackage = settingsBlockRemoveProvisioningPackage;
            this.changedFields = changedFields.add("settingsBlockRemoveProvisioningPackage");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block access to Settings app.”</i>
         * 
         * @param settingsBlockSettingsApp
         *            value of {@code settingsBlockSettingsApp} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingsBlockSettingsApp(Boolean settingsBlockSettingsApp) {
            this.settingsBlockSettingsApp = settingsBlockSettingsApp;
            this.changedFields = changedFields.add("settingsBlockSettingsApp");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block access to System in Settings app.”</i>
         * 
         * @param settingsBlockSystemPage
         *            value of {@code settingsBlockSystemPage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingsBlockSystemPage(Boolean settingsBlockSystemPage) {
            this.settingsBlockSystemPage = settingsBlockSystemPage;
            this.changedFields = changedFields.add("settingsBlockSystemPage");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block access to Time &amp; Language in Settings app.”</i>
         * 
         * @param settingsBlockTimeLanguagePage
         *            value of {@code settingsBlockTimeLanguagePage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingsBlockTimeLanguagePage(Boolean settingsBlockTimeLanguagePage) {
            this.settingsBlockTimeLanguagePage = settingsBlockTimeLanguagePage;
            this.changedFields = changedFields.add("settingsBlockTimeLanguagePage");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block access to Update &amp; Security in Settings app.”</i>
         * 
         * @param settingsBlockUpdateSecurityPage
         *            value of {@code settingsBlockUpdateSecurityPage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingsBlockUpdateSecurityPage(Boolean settingsBlockUpdateSecurityPage) {
            this.settingsBlockUpdateSecurityPage = settingsBlockUpdateSecurityPage;
            this.changedFields = changedFields.add("settingsBlockUpdateSecurityPage");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block multiple users of the same app to share data.”</i>
         * 
         * @param sharedUserAppDataAllowed
         *            value of {@code sharedUserAppDataAllowed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sharedUserAppDataAllowed(Boolean sharedUserAppDataAllowed) {
            this.sharedUserAppDataAllowed = sharedUserAppDataAllowed;
            this.changedFields = changedFields.add("sharedUserAppDataAllowed");
            return this;
        }

        /**
         * <i>“Added in Windows 10, version 1703. Allows IT Admins to control whether users are
         * allowed to install apps from places other than the Store.”</i>
         * 
         * @param smartScreenAppInstallControl
         *            value of {@code smartScreenAppInstallControl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder smartScreenAppInstallControl(AppInstallControlType smartScreenAppInstallControl) {
            this.smartScreenAppInstallControl = smartScreenAppInstallControl;
            this.changedFields = changedFields.add("smartScreenAppInstallControl");
            return this;
        }

        /**
         * <i>“Indicates whether or not users can override SmartScreen Filter warnings about
         * potentially malicious websites.”</i>
         * 
         * @param smartScreenBlockPromptOverride
         *            value of {@code smartScreenBlockPromptOverride} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder smartScreenBlockPromptOverride(Boolean smartScreenBlockPromptOverride) {
            this.smartScreenBlockPromptOverride = smartScreenBlockPromptOverride;
            this.changedFields = changedFields.add("smartScreenBlockPromptOverride");
            return this;
        }

        /**
         * <i>“Indicates whether or not users can override the SmartScreen Filter warnings
         * about downloading unverified files”</i>
         * 
         * @param smartScreenBlockPromptOverrideForFiles
         *            value of {@code smartScreenBlockPromptOverrideForFiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder smartScreenBlockPromptOverrideForFiles(Boolean smartScreenBlockPromptOverrideForFiles) {
            this.smartScreenBlockPromptOverrideForFiles = smartScreenBlockPromptOverrideForFiles;
            this.changedFields = changedFields.add("smartScreenBlockPromptOverrideForFiles");
            return this;
        }

        /**
         * <i>“This property will be deprecated in July 2019 and will be replaced by property
         * SmartScreenAppInstallControl. Allows IT Admins to control whether users are
         * allowed to install apps from places other than the Store.”</i>
         * 
         * @param smartScreenEnableAppInstallControl
         *            value of {@code smartScreenEnableAppInstallControl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder smartScreenEnableAppInstallControl(Boolean smartScreenEnableAppInstallControl) {
            this.smartScreenEnableAppInstallControl = smartScreenEnableAppInstallControl;
            this.changedFields = changedFields.add("smartScreenEnableAppInstallControl");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from unpinning apps from taskbar.”</i>
         * 
         * @param startBlockUnpinningAppsFromTaskbar
         *            value of {@code startBlockUnpinningAppsFromTaskbar} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startBlockUnpinningAppsFromTaskbar(Boolean startBlockUnpinningAppsFromTaskbar) {
            this.startBlockUnpinningAppsFromTaskbar = startBlockUnpinningAppsFromTaskbar;
            this.changedFields = changedFields.add("startBlockUnpinningAppsFromTaskbar");
            return this;
        }

        /**
         * <i>“Setting the value of this collapses the app list, removes the app list entirely,
         * or disables the corresponding toggle in the Settings app.”</i>
         * 
         * @param startMenuAppListVisibility
         *            value of {@code startMenuAppListVisibility} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startMenuAppListVisibility(WindowsStartMenuAppListVisibilityType startMenuAppListVisibility) {
            this.startMenuAppListVisibility = startMenuAppListVisibility;
            this.changedFields = changedFields.add("startMenuAppListVisibility");
            return this;
        }

        /**
         * <i>“Enabling this policy hides the change account setting from appearing in the user
         * tile in the start menu.”</i>
         * 
         * @param startMenuHideChangeAccountSettings
         *            value of {@code startMenuHideChangeAccountSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startMenuHideChangeAccountSettings(Boolean startMenuHideChangeAccountSettings) {
            this.startMenuHideChangeAccountSettings = startMenuHideChangeAccountSettings;
            this.changedFields = changedFields.add("startMenuHideChangeAccountSettings");
            return this;
        }

        /**
         * <i>“Enabling this policy hides the most used apps from appearing on the start menu
         * and disables the corresponding toggle in the Settings app.”</i>
         * 
         * @param startMenuHideFrequentlyUsedApps
         *            value of {@code startMenuHideFrequentlyUsedApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startMenuHideFrequentlyUsedApps(Boolean startMenuHideFrequentlyUsedApps) {
            this.startMenuHideFrequentlyUsedApps = startMenuHideFrequentlyUsedApps;
            this.changedFields = changedFields.add("startMenuHideFrequentlyUsedApps");
            return this;
        }

        /**
         * <i>“Enabling this policy hides hibernate from appearing in the power button in the
         * start menu.”</i>
         * 
         * @param startMenuHideHibernate
         *            value of {@code startMenuHideHibernate} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startMenuHideHibernate(Boolean startMenuHideHibernate) {
            this.startMenuHideHibernate = startMenuHideHibernate;
            this.changedFields = changedFields.add("startMenuHideHibernate");
            return this;
        }

        /**
         * <i>“Enabling this policy hides lock from appearing in the user tile in the start
         * menu.”</i>
         * 
         * @param startMenuHideLock
         *            value of {@code startMenuHideLock} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startMenuHideLock(Boolean startMenuHideLock) {
            this.startMenuHideLock = startMenuHideLock;
            this.changedFields = changedFields.add("startMenuHideLock");
            return this;
        }

        /**
         * <i>“Enabling this policy hides the power button from appearing in the start menu.”</i>
         * 
         * @param startMenuHidePowerButton
         *            value of {@code startMenuHidePowerButton} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startMenuHidePowerButton(Boolean startMenuHidePowerButton) {
            this.startMenuHidePowerButton = startMenuHidePowerButton;
            this.changedFields = changedFields.add("startMenuHidePowerButton");
            return this;
        }

        /**
         * <i>“Enabling this policy hides recent jump lists from appearing on the start menu/
         * taskbar and disables the corresponding toggle in the Settings app.”</i>
         * 
         * @param startMenuHideRecentJumpLists
         *            value of {@code startMenuHideRecentJumpLists} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startMenuHideRecentJumpLists(Boolean startMenuHideRecentJumpLists) {
            this.startMenuHideRecentJumpLists = startMenuHideRecentJumpLists;
            this.changedFields = changedFields.add("startMenuHideRecentJumpLists");
            return this;
        }

        /**
         * <i>“Enabling this policy hides recently added apps from appearing on the start menu
         * and disables the corresponding toggle in the Settings app.”</i>
         * 
         * @param startMenuHideRecentlyAddedApps
         *            value of {@code startMenuHideRecentlyAddedApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startMenuHideRecentlyAddedApps(Boolean startMenuHideRecentlyAddedApps) {
            this.startMenuHideRecentlyAddedApps = startMenuHideRecentlyAddedApps;
            this.changedFields = changedFields.add("startMenuHideRecentlyAddedApps");
            return this;
        }

        /**
         * <i>“Enabling this policy hides “Restart/Update and Restart” from appearing in the
         * power button in the start menu.”</i>
         * 
         * @param startMenuHideRestartOptions
         *            value of {@code startMenuHideRestartOptions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startMenuHideRestartOptions(Boolean startMenuHideRestartOptions) {
            this.startMenuHideRestartOptions = startMenuHideRestartOptions;
            this.changedFields = changedFields.add("startMenuHideRestartOptions");
            return this;
        }

        /**
         * <i>“Enabling this policy hides shut down/update and shut down from appearing in the
         * power button in the start menu.”</i>
         * 
         * @param startMenuHideShutDown
         *            value of {@code startMenuHideShutDown} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startMenuHideShutDown(Boolean startMenuHideShutDown) {
            this.startMenuHideShutDown = startMenuHideShutDown;
            this.changedFields = changedFields.add("startMenuHideShutDown");
            return this;
        }

        /**
         * <i>“Enabling this policy hides sign out from appearing in the user tile in the start
         * menu.”</i>
         * 
         * @param startMenuHideSignOut
         *            value of {@code startMenuHideSignOut} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startMenuHideSignOut(Boolean startMenuHideSignOut) {
            this.startMenuHideSignOut = startMenuHideSignOut;
            this.changedFields = changedFields.add("startMenuHideSignOut");
            return this;
        }

        /**
         * <i>“Enabling this policy hides sleep from appearing in the power button in the start
         * menu.”</i>
         * 
         * @param startMenuHideSleep
         *            value of {@code startMenuHideSleep} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startMenuHideSleep(Boolean startMenuHideSleep) {
            this.startMenuHideSleep = startMenuHideSleep;
            this.changedFields = changedFields.add("startMenuHideSleep");
            return this;
        }

        /**
         * <i>“Enabling this policy hides switch account from appearing in the user tile in the
         * start menu.”</i>
         * 
         * @param startMenuHideSwitchAccount
         *            value of {@code startMenuHideSwitchAccount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startMenuHideSwitchAccount(Boolean startMenuHideSwitchAccount) {
            this.startMenuHideSwitchAccount = startMenuHideSwitchAccount;
            this.changedFields = changedFields.add("startMenuHideSwitchAccount");
            return this;
        }

        /**
         * <i>“Enabling this policy hides the user tile from appearing in the start menu.”</i>
         * 
         * @param startMenuHideUserTile
         *            value of {@code startMenuHideUserTile} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startMenuHideUserTile(Boolean startMenuHideUserTile) {
            this.startMenuHideUserTile = startMenuHideUserTile;
            this.changedFields = changedFields.add("startMenuHideUserTile");
            return this;
        }

        /**
         * <i>“This policy setting allows you to import Edge assets to be used with
         * startMenuLayoutXml policy. Start layout can contain secondary tile from Edge app
         * which looks for Edge local asset file. Edge local asset would not exist and
         * cause Edge secondary tile to appear empty in this case. This policy only gets
         * applied when startMenuLayoutXml policy is modified. The value should be a UTF-8
         * Base64 encoded byte array.”</i>
         * 
         * @param startMenuLayoutEdgeAssetsXml
         *            value of {@code startMenuLayoutEdgeAssetsXml} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startMenuLayoutEdgeAssetsXml(byte[] startMenuLayoutEdgeAssetsXml) {
            this.startMenuLayoutEdgeAssetsXml = startMenuLayoutEdgeAssetsXml;
            this.changedFields = changedFields.add("startMenuLayoutEdgeAssetsXml");
            return this;
        }

        /**
         * <i>“Allows admins to override the default Start menu layout and prevents the user
         * from changing it. The layout is modified by specifying an XML file based on a
         * layout modification schema. XML needs to be in a UTF8 encoded byte array format.”</i>
         * 
         * @param startMenuLayoutXml
         *            value of {@code startMenuLayoutXml} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startMenuLayoutXml(byte[] startMenuLayoutXml) {
            this.startMenuLayoutXml = startMenuLayoutXml;
            this.changedFields = changedFields.add("startMenuLayoutXml");
            return this;
        }

        /**
         * <i>“Allows admins to decide how the Start menu is displayed.”</i>
         * 
         * @param startMenuMode
         *            value of {@code startMenuMode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startMenuMode(WindowsStartMenuModeType startMenuMode) {
            this.startMenuMode = startMenuMode;
            this.changedFields = changedFields.add("startMenuMode");
            return this;
        }

        /**
         * <i>“Enforces the visibility (Show/Hide) of the Documents folder shortcut on the
         * Start menu.”</i>
         * 
         * @param startMenuPinnedFolderDocuments
         *            value of {@code startMenuPinnedFolderDocuments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startMenuPinnedFolderDocuments(VisibilitySetting startMenuPinnedFolderDocuments) {
            this.startMenuPinnedFolderDocuments = startMenuPinnedFolderDocuments;
            this.changedFields = changedFields.add("startMenuPinnedFolderDocuments");
            return this;
        }

        /**
         * <i>“Enforces the visibility (Show/Hide) of the Downloads folder shortcut on the
         * Start menu.”</i>
         * 
         * @param startMenuPinnedFolderDownloads
         *            value of {@code startMenuPinnedFolderDownloads} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startMenuPinnedFolderDownloads(VisibilitySetting startMenuPinnedFolderDownloads) {
            this.startMenuPinnedFolderDownloads = startMenuPinnedFolderDownloads;
            this.changedFields = changedFields.add("startMenuPinnedFolderDownloads");
            return this;
        }

        /**
         * <i>“Enforces the visibility (Show/Hide) of the FileExplorer shortcut on the Start
         * menu.”</i>
         * 
         * @param startMenuPinnedFolderFileExplorer
         *            value of {@code startMenuPinnedFolderFileExplorer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startMenuPinnedFolderFileExplorer(VisibilitySetting startMenuPinnedFolderFileExplorer) {
            this.startMenuPinnedFolderFileExplorer = startMenuPinnedFolderFileExplorer;
            this.changedFields = changedFields.add("startMenuPinnedFolderFileExplorer");
            return this;
        }

        /**
         * <i>“Enforces the visibility (Show/Hide) of the HomeGroup folder shortcut on the
         * Start menu.”</i>
         * 
         * @param startMenuPinnedFolderHomeGroup
         *            value of {@code startMenuPinnedFolderHomeGroup} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startMenuPinnedFolderHomeGroup(VisibilitySetting startMenuPinnedFolderHomeGroup) {
            this.startMenuPinnedFolderHomeGroup = startMenuPinnedFolderHomeGroup;
            this.changedFields = changedFields.add("startMenuPinnedFolderHomeGroup");
            return this;
        }

        /**
         * <i>“Enforces the visibility (Show/Hide) of the Music folder shortcut on the Start
         * menu.”</i>
         * 
         * @param startMenuPinnedFolderMusic
         *            value of {@code startMenuPinnedFolderMusic} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startMenuPinnedFolderMusic(VisibilitySetting startMenuPinnedFolderMusic) {
            this.startMenuPinnedFolderMusic = startMenuPinnedFolderMusic;
            this.changedFields = changedFields.add("startMenuPinnedFolderMusic");
            return this;
        }

        /**
         * <i>“Enforces the visibility (Show/Hide) of the Network folder shortcut on the Start
         * menu.”</i>
         * 
         * @param startMenuPinnedFolderNetwork
         *            value of {@code startMenuPinnedFolderNetwork} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startMenuPinnedFolderNetwork(VisibilitySetting startMenuPinnedFolderNetwork) {
            this.startMenuPinnedFolderNetwork = startMenuPinnedFolderNetwork;
            this.changedFields = changedFields.add("startMenuPinnedFolderNetwork");
            return this;
        }

        /**
         * <i>“Enforces the visibility (Show/Hide) of the PersonalFolder shortcut on the Start
         * menu.”</i>
         * 
         * @param startMenuPinnedFolderPersonalFolder
         *            value of {@code startMenuPinnedFolderPersonalFolder} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startMenuPinnedFolderPersonalFolder(VisibilitySetting startMenuPinnedFolderPersonalFolder) {
            this.startMenuPinnedFolderPersonalFolder = startMenuPinnedFolderPersonalFolder;
            this.changedFields = changedFields.add("startMenuPinnedFolderPersonalFolder");
            return this;
        }

        /**
         * <i>“Enforces the visibility (Show/Hide) of the Pictures folder shortcut on the Start
         * menu.”</i>
         * 
         * @param startMenuPinnedFolderPictures
         *            value of {@code startMenuPinnedFolderPictures} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startMenuPinnedFolderPictures(VisibilitySetting startMenuPinnedFolderPictures) {
            this.startMenuPinnedFolderPictures = startMenuPinnedFolderPictures;
            this.changedFields = changedFields.add("startMenuPinnedFolderPictures");
            return this;
        }

        /**
         * <i>“Enforces the visibility (Show/Hide) of the Settings folder shortcut on the Start
         * menu.”</i>
         * 
         * @param startMenuPinnedFolderSettings
         *            value of {@code startMenuPinnedFolderSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startMenuPinnedFolderSettings(VisibilitySetting startMenuPinnedFolderSettings) {
            this.startMenuPinnedFolderSettings = startMenuPinnedFolderSettings;
            this.changedFields = changedFields.add("startMenuPinnedFolderSettings");
            return this;
        }

        /**
         * <i>“Enforces the visibility (Show/Hide) of the Videos folder shortcut on the Start
         * menu.”</i>
         * 
         * @param startMenuPinnedFolderVideos
         *            value of {@code startMenuPinnedFolderVideos} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startMenuPinnedFolderVideos(VisibilitySetting startMenuPinnedFolderVideos) {
            this.startMenuPinnedFolderVideos = startMenuPinnedFolderVideos;
            this.changedFields = changedFields.add("startMenuPinnedFolderVideos");
            return this;
        }

        /**
         * <i>“Indicates whether or not to Block the user from using removable storage.”</i>
         * 
         * @param storageBlockRemovableStorage
         *            value of {@code storageBlockRemovableStorage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder storageBlockRemovableStorage(Boolean storageBlockRemovableStorage) {
            this.storageBlockRemovableStorage = storageBlockRemovableStorage;
            this.changedFields = changedFields.add("storageBlockRemovableStorage");
            return this;
        }

        /**
         * <i>“Indicating whether or not to require encryption on a mobile device.”</i>
         * 
         * @param storageRequireMobileDeviceEncryption
         *            value of {@code storageRequireMobileDeviceEncryption} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder storageRequireMobileDeviceEncryption(Boolean storageRequireMobileDeviceEncryption) {
            this.storageRequireMobileDeviceEncryption = storageRequireMobileDeviceEncryption;
            this.changedFields = changedFields.add("storageRequireMobileDeviceEncryption");
            return this;
        }

        /**
         * <i>“Indicates whether application data is restricted to the system drive.”</i>
         * 
         * @param storageRestrictAppDataToSystemVolume
         *            value of {@code storageRestrictAppDataToSystemVolume} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder storageRestrictAppDataToSystemVolume(Boolean storageRestrictAppDataToSystemVolume) {
            this.storageRestrictAppDataToSystemVolume = storageRestrictAppDataToSystemVolume;
            this.changedFields = changedFields.add("storageRestrictAppDataToSystemVolume");
            return this;
        }

        /**
         * <i>“Indicates whether the installation of applications is restricted to the system
         * drive.”</i>
         * 
         * @param storageRestrictAppInstallToSystemVolume
         *            value of {@code storageRestrictAppInstallToSystemVolume} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder storageRestrictAppInstallToSystemVolume(Boolean storageRestrictAppInstallToSystemVolume) {
            this.storageRestrictAppInstallToSystemVolume = storageRestrictAppInstallToSystemVolume;
            this.changedFields = changedFields.add("storageRestrictAppInstallToSystemVolume");
            return this;
        }

        /**
         * <i>“Gets or sets the fully qualified domain name (FQDN) or IP address of a proxy
         * server to forward Connected User Experiences and Telemetry requests.”</i>
         * 
         * @param systemTelemetryProxyServer
         *            value of {@code systemTelemetryProxyServer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder systemTelemetryProxyServer(String systemTelemetryProxyServer) {
            this.systemTelemetryProxyServer = systemTelemetryProxyServer;
            this.changedFields = changedFields.add("systemTelemetryProxyServer");
            return this;
        }

        /**
         * <i>“Specify whether non-administrators can use Task Manager to end tasks.”</i>
         * 
         * @param taskManagerBlockEndTask
         *            value of {@code taskManagerBlockEndTask} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder taskManagerBlockEndTask(Boolean taskManagerBlockEndTask) {
            this.taskManagerBlockEndTask = taskManagerBlockEndTask;
            this.changedFields = changedFields.add("taskManagerBlockEndTask");
            return this;
        }

        /**
         * <i>“Whether the device is required to connect to the network.”</i>
         * 
         * @param tenantLockdownRequireNetworkDuringOutOfBoxExperience
         *            value of {@code tenantLockdownRequireNetworkDuringOutOfBoxExperience} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tenantLockdownRequireNetworkDuringOutOfBoxExperience(Boolean tenantLockdownRequireNetworkDuringOutOfBoxExperience) {
            this.tenantLockdownRequireNetworkDuringOutOfBoxExperience = tenantLockdownRequireNetworkDuringOutOfBoxExperience;
            this.changedFields = changedFields.add("tenantLockdownRequireNetworkDuringOutOfBoxExperience");
            return this;
        }

        /**
         * <i>“Indicates whether or not to uninstall a fixed list of built-in Windows apps.”</i>
         * 
         * @param uninstallBuiltInApps
         *            value of {@code uninstallBuiltInApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder uninstallBuiltInApps(Boolean uninstallBuiltInApps) {
            this.uninstallBuiltInApps = uninstallBuiltInApps;
            this.changedFields = changedFields.add("uninstallBuiltInApps");
            return this;
        }

        /**
         * <i>“Indicates whether or not to Block the user from USB connection.”</i>
         * 
         * @param usbBlocked
         *            value of {@code usbBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder usbBlocked(Boolean usbBlocked) {
            this.usbBlocked = usbBlocked;
            this.changedFields = changedFields.add("usbBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to Block the user from voice recording.”</i>
         * 
         * @param voiceRecordingBlocked
         *            value of {@code voiceRecordingBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder voiceRecordingBlocked(Boolean voiceRecordingBlocked) {
            this.voiceRecordingBlocked = voiceRecordingBlocked;
            this.changedFields = changedFields.add("voiceRecordingBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not user's localhost IP address is displayed while making
         * phone calls using the WebRTC”</i>
         * 
         * @param webRtcBlockLocalhostIpAddress
         *            value of {@code webRtcBlockLocalhostIpAddress} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder webRtcBlockLocalhostIpAddress(Boolean webRtcBlockLocalhostIpAddress) {
            this.webRtcBlockLocalhostIpAddress = webRtcBlockLocalhostIpAddress;
            this.changedFields = changedFields.add("webRtcBlockLocalhostIpAddress");
            return this;
        }

        /**
         * <i>“Indicating whether or not to block automatically connecting to Wi-Fi hotspots.
         * Has no impact if Wi-Fi is blocked.”</i>
         * 
         * @param wiFiBlockAutomaticConnectHotspots
         *            value of {@code wiFiBlockAutomaticConnectHotspots} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder wiFiBlockAutomaticConnectHotspots(Boolean wiFiBlockAutomaticConnectHotspots) {
            this.wiFiBlockAutomaticConnectHotspots = wiFiBlockAutomaticConnectHotspots;
            this.changedFields = changedFields.add("wiFiBlockAutomaticConnectHotspots");
            return this;
        }

        /**
         * <i>“Indicates whether or not to Block the user from using Wi-Fi.”</i>
         * 
         * @param wiFiBlocked
         *            value of {@code wiFiBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder wiFiBlocked(Boolean wiFiBlocked) {
            this.wiFiBlocked = wiFiBlocked;
            this.changedFields = changedFields.add("wiFiBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to Block the user from using Wi-Fi manual configuration
         * .”</i>
         * 
         * @param wiFiBlockManualConfiguration
         *            value of {@code wiFiBlockManualConfiguration} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder wiFiBlockManualConfiguration(Boolean wiFiBlockManualConfiguration) {
            this.wiFiBlockManualConfiguration = wiFiBlockManualConfiguration;
            this.changedFields = changedFields.add("wiFiBlockManualConfiguration");
            return this;
        }

        /**
         * <i>“Specify how often devices scan for Wi-Fi networks. Supported values are 1-500,
         * where 100 = default, and 500 = low frequency. Valid values 1 to 500”</i>
         * 
         * @param wiFiScanInterval
         *            value of {@code wiFiScanInterval} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder wiFiScanInterval(Integer wiFiScanInterval) {
            this.wiFiScanInterval = wiFiScanInterval;
            this.changedFields = changedFields.add("wiFiScanInterval");
            return this;
        }

        /**
         * <i>“Windows 10 force update schedule for Apps.”</i>
         * 
         * @param windows10AppsForceUpdateSchedule
         *            value of {@code windows10AppsForceUpdateSchedule} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windows10AppsForceUpdateSchedule(Windows10AppsForceUpdateSchedule windows10AppsForceUpdateSchedule) {
            this.windows10AppsForceUpdateSchedule = windows10AppsForceUpdateSchedule;
            this.changedFields = changedFields.add("windows10AppsForceUpdateSchedule");
            return this;
        }

        /**
         * <i>“Allows IT admins to block experiences that are typically for consumers only,
         * such as Start suggestions, Membership notifications, Post-OOBE app install and
         * redirect tiles.”</i>
         * 
         * @param windowsSpotlightBlockConsumerSpecificFeatures
         *            value of {@code windowsSpotlightBlockConsumerSpecificFeatures} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsSpotlightBlockConsumerSpecificFeatures(Boolean windowsSpotlightBlockConsumerSpecificFeatures) {
            this.windowsSpotlightBlockConsumerSpecificFeatures = windowsSpotlightBlockConsumerSpecificFeatures;
            this.changedFields = changedFields.add("windowsSpotlightBlockConsumerSpecificFeatures");
            return this;
        }

        /**
         * <i>“Allows IT admins to turn off all Windows Spotlight features”</i>
         * 
         * @param windowsSpotlightBlocked
         *            value of {@code windowsSpotlightBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsSpotlightBlocked(Boolean windowsSpotlightBlocked) {
            this.windowsSpotlightBlocked = windowsSpotlightBlocked;
            this.changedFields = changedFields.add("windowsSpotlightBlocked");
            return this;
        }

        /**
         * <i>“Block suggestions from Microsoft that show after each OS clean install, upgrade
         * or in an on-going basis to introduce users to what is new or changed”</i>
         * 
         * @param windowsSpotlightBlockOnActionCenter
         *            value of {@code windowsSpotlightBlockOnActionCenter} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsSpotlightBlockOnActionCenter(Boolean windowsSpotlightBlockOnActionCenter) {
            this.windowsSpotlightBlockOnActionCenter = windowsSpotlightBlockOnActionCenter;
            this.changedFields = changedFields.add("windowsSpotlightBlockOnActionCenter");
            return this;
        }

        /**
         * <i>“Block personalized content in Windows spotlight based on user’s device usage.”</i>
         * 
         * @param windowsSpotlightBlockTailoredExperiences
         *            value of {@code windowsSpotlightBlockTailoredExperiences} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsSpotlightBlockTailoredExperiences(Boolean windowsSpotlightBlockTailoredExperiences) {
            this.windowsSpotlightBlockTailoredExperiences = windowsSpotlightBlockTailoredExperiences;
            this.changedFields = changedFields.add("windowsSpotlightBlockTailoredExperiences");
            return this;
        }

        /**
         * <i>“Block third party content delivered via Windows Spotlight”</i>
         * 
         * @param windowsSpotlightBlockThirdPartyNotifications
         *            value of {@code windowsSpotlightBlockThirdPartyNotifications} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsSpotlightBlockThirdPartyNotifications(Boolean windowsSpotlightBlockThirdPartyNotifications) {
            this.windowsSpotlightBlockThirdPartyNotifications = windowsSpotlightBlockThirdPartyNotifications;
            this.changedFields = changedFields.add("windowsSpotlightBlockThirdPartyNotifications");
            return this;
        }

        /**
         * <i>“Block Windows Spotlight Windows welcome experience”</i>
         * 
         * @param windowsSpotlightBlockWelcomeExperience
         *            value of {@code windowsSpotlightBlockWelcomeExperience} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsSpotlightBlockWelcomeExperience(Boolean windowsSpotlightBlockWelcomeExperience) {
            this.windowsSpotlightBlockWelcomeExperience = windowsSpotlightBlockWelcomeExperience;
            this.changedFields = changedFields.add("windowsSpotlightBlockWelcomeExperience");
            return this;
        }

        /**
         * <i>“Allows IT admins to turn off the popup of Windows Tips.”</i>
         * 
         * @param windowsSpotlightBlockWindowsTips
         *            value of {@code windowsSpotlightBlockWindowsTips} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsSpotlightBlockWindowsTips(Boolean windowsSpotlightBlockWindowsTips) {
            this.windowsSpotlightBlockWindowsTips = windowsSpotlightBlockWindowsTips;
            this.changedFields = changedFields.add("windowsSpotlightBlockWindowsTips");
            return this;
        }

        /**
         * <i>“Specifies the type of Spotlight”</i>
         * 
         * @param windowsSpotlightConfigureOnLockScreen
         *            value of {@code windowsSpotlightConfigureOnLockScreen} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsSpotlightConfigureOnLockScreen(WindowsSpotlightEnablementSettings windowsSpotlightConfigureOnLockScreen) {
            this.windowsSpotlightConfigureOnLockScreen = windowsSpotlightConfigureOnLockScreen;
            this.changedFields = changedFields.add("windowsSpotlightConfigureOnLockScreen");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block automatic update of apps from Windows Store.”</i>
         * 
         * @param windowsStoreBlockAutoUpdate
         *            value of {@code windowsStoreBlockAutoUpdate} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsStoreBlockAutoUpdate(Boolean windowsStoreBlockAutoUpdate) {
            this.windowsStoreBlockAutoUpdate = windowsStoreBlockAutoUpdate;
            this.changedFields = changedFields.add("windowsStoreBlockAutoUpdate");
            return this;
        }

        /**
         * <i>“Indicates whether or not to Block the user from using the Windows store.”</i>
         * 
         * @param windowsStoreBlocked
         *            value of {@code windowsStoreBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsStoreBlocked(Boolean windowsStoreBlocked) {
            this.windowsStoreBlocked = windowsStoreBlocked;
            this.changedFields = changedFields.add("windowsStoreBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to enable Private Store Only.”</i>
         * 
         * @param windowsStoreEnablePrivateStoreOnly
         *            value of {@code windowsStoreEnablePrivateStoreOnly} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsStoreEnablePrivateStoreOnly(Boolean windowsStoreEnablePrivateStoreOnly) {
            this.windowsStoreEnablePrivateStoreOnly = windowsStoreEnablePrivateStoreOnly;
            this.changedFields = changedFields.add("windowsStoreEnablePrivateStoreOnly");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow other devices from discovering this PC for
         * projection.”</i>
         * 
         * @param wirelessDisplayBlockProjectionToThisDevice
         *            value of {@code wirelessDisplayBlockProjectionToThisDevice} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder wirelessDisplayBlockProjectionToThisDevice(Boolean wirelessDisplayBlockProjectionToThisDevice) {
            this.wirelessDisplayBlockProjectionToThisDevice = wirelessDisplayBlockProjectionToThisDevice;
            this.changedFields = changedFields.add("wirelessDisplayBlockProjectionToThisDevice");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow user input from wireless display receiver.”</i>
         * 
         * @param wirelessDisplayBlockUserInputFromReceiver
         *            value of {@code wirelessDisplayBlockUserInputFromReceiver} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder wirelessDisplayBlockUserInputFromReceiver(Boolean wirelessDisplayBlockUserInputFromReceiver) {
            this.wirelessDisplayBlockUserInputFromReceiver = wirelessDisplayBlockUserInputFromReceiver;
            this.changedFields = changedFields.add("wirelessDisplayBlockUserInputFromReceiver");
            return this;
        }

        /**
         * <i>“Indicates whether or not to require a PIN for new devices to initiate pairing.”</i>
         * 
         * @param wirelessDisplayRequirePinForPairing
         *            value of {@code wirelessDisplayRequirePinForPairing} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder wirelessDisplayRequirePinForPairing(Boolean wirelessDisplayRequirePinForPairing) {
            this.wirelessDisplayRequirePinForPairing = wirelessDisplayRequirePinForPairing;
            this.changedFields = changedFields.add("wirelessDisplayRequirePinForPairing");
            return this;
        }

        /**
         * <i>“Indicates a list of applications with their access control levels over privacy
         * data categories, and/or the default access levels per category. This collection
         * can contain a maximum of 500 elements.”</i>
         * 
         * @param privacyAccessControls
         *            value of {@code privacyAccessControls} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder privacyAccessControls(List<WindowsPrivacyDataAccessControlItem> privacyAccessControls) {
            this.privacyAccessControls = privacyAccessControls;
            this.changedFields = changedFields.add("privacyAccessControls");
            return this;
        }

        /**
         * <i>“Indicates a list of applications with their access control levels over privacy
         * data categories, and/or the default access levels per category. This collection
         * can contain a maximum of 500 elements.”</i>
         * 
         * @param privacyAccessControls
         *            value of {@code privacyAccessControls} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder privacyAccessControls(WindowsPrivacyDataAccessControlItem... privacyAccessControls) {
            return privacyAccessControls(Arrays.asList(privacyAccessControls));
        }

        public Windows10GeneralConfiguration build() {
            Windows10GeneralConfiguration _x = new Windows10GeneralConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windows10GeneralConfiguration";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.version = version;
            _x.assignments = assignments;
            _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
            _x.deviceStatuses = deviceStatuses;
            _x.deviceStatusOverview = deviceStatusOverview;
            _x.groupAssignments = groupAssignments;
            _x.userStatuses = userStatuses;
            _x.userStatusOverview = userStatusOverview;
            _x.accountsBlockAddingNonMicrosoftAccountEmail = accountsBlockAddingNonMicrosoftAccountEmail;
            _x.activateAppsWithVoice = activateAppsWithVoice;
            _x.antiTheftModeBlocked = antiTheftModeBlocked;
            _x.appManagementMSIAllowUserControlOverInstall = appManagementMSIAllowUserControlOverInstall;
            _x.appManagementMSIAlwaysInstallWithElevatedPrivileges = appManagementMSIAlwaysInstallWithElevatedPrivileges;
            _x.appManagementPackageFamilyNamesToLaunchAfterLogOn = appManagementPackageFamilyNamesToLaunchAfterLogOn;
            _x.appManagementPackageFamilyNamesToLaunchAfterLogOnNextLink = appManagementPackageFamilyNamesToLaunchAfterLogOnNextLink;
            _x.appsAllowTrustedAppsSideloading = appsAllowTrustedAppsSideloading;
            _x.appsBlockWindowsStoreOriginatedApps = appsBlockWindowsStoreOriginatedApps;
            _x.authenticationAllowSecondaryDevice = authenticationAllowSecondaryDevice;
            _x.authenticationPreferredAzureADTenantDomainName = authenticationPreferredAzureADTenantDomainName;
            _x.authenticationWebSignIn = authenticationWebSignIn;
            _x.bluetoothAllowedServices = bluetoothAllowedServices;
            _x.bluetoothAllowedServicesNextLink = bluetoothAllowedServicesNextLink;
            _x.bluetoothBlockAdvertising = bluetoothBlockAdvertising;
            _x.bluetoothBlockDiscoverableMode = bluetoothBlockDiscoverableMode;
            _x.bluetoothBlocked = bluetoothBlocked;
            _x.bluetoothBlockPrePairing = bluetoothBlockPrePairing;
            _x.bluetoothBlockPromptedProximalConnections = bluetoothBlockPromptedProximalConnections;
            _x.cameraBlocked = cameraBlocked;
            _x.cellularBlockDataWhenRoaming = cellularBlockDataWhenRoaming;
            _x.cellularBlockVpn = cellularBlockVpn;
            _x.cellularBlockVpnWhenRoaming = cellularBlockVpnWhenRoaming;
            _x.cellularData = cellularData;
            _x.certificatesBlockManualRootCertificateInstallation = certificatesBlockManualRootCertificateInstallation;
            _x.configureTimeZone = configureTimeZone;
            _x.connectedDevicesServiceBlocked = connectedDevicesServiceBlocked;
            _x.copyPasteBlocked = copyPasteBlocked;
            _x.cortanaBlocked = cortanaBlocked;
            _x.cryptographyAllowFipsAlgorithmPolicy = cryptographyAllowFipsAlgorithmPolicy;
            _x.dataProtectionBlockDirectMemoryAccess = dataProtectionBlockDirectMemoryAccess;
            _x.defenderBlockEndUserAccess = defenderBlockEndUserAccess;
            _x.defenderBlockOnAccessProtection = defenderBlockOnAccessProtection;
            _x.defenderCloudBlockLevel = defenderCloudBlockLevel;
            _x.defenderCloudExtendedTimeout = defenderCloudExtendedTimeout;
            _x.defenderCloudExtendedTimeoutInSeconds = defenderCloudExtendedTimeoutInSeconds;
            _x.defenderDaysBeforeDeletingQuarantinedMalware = defenderDaysBeforeDeletingQuarantinedMalware;
            _x.defenderDetectedMalwareActions = defenderDetectedMalwareActions;
            _x.defenderDisableCatchupFullScan = defenderDisableCatchupFullScan;
            _x.defenderDisableCatchupQuickScan = defenderDisableCatchupQuickScan;
            _x.defenderFileExtensionsToExclude = defenderFileExtensionsToExclude;
            _x.defenderFileExtensionsToExcludeNextLink = defenderFileExtensionsToExcludeNextLink;
            _x.defenderFilesAndFoldersToExclude = defenderFilesAndFoldersToExclude;
            _x.defenderFilesAndFoldersToExcludeNextLink = defenderFilesAndFoldersToExcludeNextLink;
            _x.defenderMonitorFileActivity = defenderMonitorFileActivity;
            _x.defenderPotentiallyUnwantedAppAction = defenderPotentiallyUnwantedAppAction;
            _x.defenderPotentiallyUnwantedAppActionSetting = defenderPotentiallyUnwantedAppActionSetting;
            _x.defenderProcessesToExclude = defenderProcessesToExclude;
            _x.defenderProcessesToExcludeNextLink = defenderProcessesToExcludeNextLink;
            _x.defenderPromptForSampleSubmission = defenderPromptForSampleSubmission;
            _x.defenderRequireBehaviorMonitoring = defenderRequireBehaviorMonitoring;
            _x.defenderRequireCloudProtection = defenderRequireCloudProtection;
            _x.defenderRequireNetworkInspectionSystem = defenderRequireNetworkInspectionSystem;
            _x.defenderRequireRealTimeMonitoring = defenderRequireRealTimeMonitoring;
            _x.defenderScanArchiveFiles = defenderScanArchiveFiles;
            _x.defenderScanDownloads = defenderScanDownloads;
            _x.defenderScanIncomingMail = defenderScanIncomingMail;
            _x.defenderScanMappedNetworkDrivesDuringFullScan = defenderScanMappedNetworkDrivesDuringFullScan;
            _x.defenderScanMaxCpu = defenderScanMaxCpu;
            _x.defenderScanNetworkFiles = defenderScanNetworkFiles;
            _x.defenderScanRemovableDrivesDuringFullScan = defenderScanRemovableDrivesDuringFullScan;
            _x.defenderScanScriptsLoadedInInternetExplorer = defenderScanScriptsLoadedInInternetExplorer;
            _x.defenderScanType = defenderScanType;
            _x.defenderScheduledQuickScanTime = defenderScheduledQuickScanTime;
            _x.defenderScheduledScanTime = defenderScheduledScanTime;
            _x.defenderScheduleScanEnableLowCpuPriority = defenderScheduleScanEnableLowCpuPriority;
            _x.defenderSignatureUpdateIntervalInHours = defenderSignatureUpdateIntervalInHours;
            _x.defenderSubmitSamplesConsentType = defenderSubmitSamplesConsentType;
            _x.defenderSystemScanSchedule = defenderSystemScanSchedule;
            _x.developerUnlockSetting = developerUnlockSetting;
            _x.deviceManagementBlockFactoryResetOnMobile = deviceManagementBlockFactoryResetOnMobile;
            _x.deviceManagementBlockManualUnenroll = deviceManagementBlockManualUnenroll;
            _x.diagnosticsDataSubmissionMode = diagnosticsDataSubmissionMode;
            _x.displayAppListWithGdiDPIScalingTurnedOff = displayAppListWithGdiDPIScalingTurnedOff;
            _x.displayAppListWithGdiDPIScalingTurnedOffNextLink = displayAppListWithGdiDPIScalingTurnedOffNextLink;
            _x.displayAppListWithGdiDPIScalingTurnedOn = displayAppListWithGdiDPIScalingTurnedOn;
            _x.displayAppListWithGdiDPIScalingTurnedOnNextLink = displayAppListWithGdiDPIScalingTurnedOnNextLink;
            _x.edgeAllowStartPagesModification = edgeAllowStartPagesModification;
            _x.edgeBlockAccessToAboutFlags = edgeBlockAccessToAboutFlags;
            _x.edgeBlockAddressBarDropdown = edgeBlockAddressBarDropdown;
            _x.edgeBlockAutofill = edgeBlockAutofill;
            _x.edgeBlockCompatibilityList = edgeBlockCompatibilityList;
            _x.edgeBlockDeveloperTools = edgeBlockDeveloperTools;
            _x.edgeBlocked = edgeBlocked;
            _x.edgeBlockEditFavorites = edgeBlockEditFavorites;
            _x.edgeBlockExtensions = edgeBlockExtensions;
            _x.edgeBlockFullScreenMode = edgeBlockFullScreenMode;
            _x.edgeBlockInPrivateBrowsing = edgeBlockInPrivateBrowsing;
            _x.edgeBlockJavaScript = edgeBlockJavaScript;
            _x.edgeBlockLiveTileDataCollection = edgeBlockLiveTileDataCollection;
            _x.edgeBlockPasswordManager = edgeBlockPasswordManager;
            _x.edgeBlockPopups = edgeBlockPopups;
            _x.edgeBlockPrelaunch = edgeBlockPrelaunch;
            _x.edgeBlockPrinting = edgeBlockPrinting;
            _x.edgeBlockSavingHistory = edgeBlockSavingHistory;
            _x.edgeBlockSearchEngineCustomization = edgeBlockSearchEngineCustomization;
            _x.edgeBlockSearchSuggestions = edgeBlockSearchSuggestions;
            _x.edgeBlockSendingDoNotTrackHeader = edgeBlockSendingDoNotTrackHeader;
            _x.edgeBlockSendingIntranetTrafficToInternetExplorer = edgeBlockSendingIntranetTrafficToInternetExplorer;
            _x.edgeBlockSideloadingExtensions = edgeBlockSideloadingExtensions;
            _x.edgeBlockTabPreloading = edgeBlockTabPreloading;
            _x.edgeBlockWebContentOnNewTabPage = edgeBlockWebContentOnNewTabPage;
            _x.edgeClearBrowsingDataOnExit = edgeClearBrowsingDataOnExit;
            _x.edgeCookiePolicy = edgeCookiePolicy;
            _x.edgeDisableFirstRunPage = edgeDisableFirstRunPage;
            _x.edgeEnterpriseModeSiteListLocation = edgeEnterpriseModeSiteListLocation;
            _x.edgeFavoritesBarVisibility = edgeFavoritesBarVisibility;
            _x.edgeFavoritesListLocation = edgeFavoritesListLocation;
            _x.edgeFirstRunUrl = edgeFirstRunUrl;
            _x.edgeHomeButtonConfiguration = edgeHomeButtonConfiguration;
            _x.edgeHomeButtonConfigurationEnabled = edgeHomeButtonConfigurationEnabled;
            _x.edgeHomepageUrls = edgeHomepageUrls;
            _x.edgeHomepageUrlsNextLink = edgeHomepageUrlsNextLink;
            _x.edgeKioskModeRestriction = edgeKioskModeRestriction;
            _x.edgeKioskResetAfterIdleTimeInMinutes = edgeKioskResetAfterIdleTimeInMinutes;
            _x.edgeNewTabPageURL = edgeNewTabPageURL;
            _x.edgeOpensWith = edgeOpensWith;
            _x.edgePreventCertificateErrorOverride = edgePreventCertificateErrorOverride;
            _x.edgeRequiredExtensionPackageFamilyNames = edgeRequiredExtensionPackageFamilyNames;
            _x.edgeRequiredExtensionPackageFamilyNamesNextLink = edgeRequiredExtensionPackageFamilyNamesNextLink;
            _x.edgeRequireSmartScreen = edgeRequireSmartScreen;
            _x.edgeSearchEngine = edgeSearchEngine;
            _x.edgeSendIntranetTrafficToInternetExplorer = edgeSendIntranetTrafficToInternetExplorer;
            _x.edgeShowMessageWhenOpeningInternetExplorerSites = edgeShowMessageWhenOpeningInternetExplorerSites;
            _x.edgeSyncFavoritesWithInternetExplorer = edgeSyncFavoritesWithInternetExplorer;
            _x.edgeTelemetryForMicrosoft365Analytics = edgeTelemetryForMicrosoft365Analytics;
            _x.enableAutomaticRedeployment = enableAutomaticRedeployment;
            _x.energySaverOnBatteryThresholdPercentage = energySaverOnBatteryThresholdPercentage;
            _x.energySaverPluggedInThresholdPercentage = energySaverPluggedInThresholdPercentage;
            _x.enterpriseCloudPrintDiscoveryEndPoint = enterpriseCloudPrintDiscoveryEndPoint;
            _x.enterpriseCloudPrintDiscoveryMaxLimit = enterpriseCloudPrintDiscoveryMaxLimit;
            _x.enterpriseCloudPrintMopriaDiscoveryResourceIdentifier = enterpriseCloudPrintMopriaDiscoveryResourceIdentifier;
            _x.enterpriseCloudPrintOAuthAuthority = enterpriseCloudPrintOAuthAuthority;
            _x.enterpriseCloudPrintOAuthClientIdentifier = enterpriseCloudPrintOAuthClientIdentifier;
            _x.enterpriseCloudPrintResourceIdentifier = enterpriseCloudPrintResourceIdentifier;
            _x.experienceBlockDeviceDiscovery = experienceBlockDeviceDiscovery;
            _x.experienceBlockErrorDialogWhenNoSIM = experienceBlockErrorDialogWhenNoSIM;
            _x.experienceBlockTaskSwitcher = experienceBlockTaskSwitcher;
            _x.experienceDoNotSyncBrowserSettings = experienceDoNotSyncBrowserSettings;
            _x.findMyFiles = findMyFiles;
            _x.gameDvrBlocked = gameDvrBlocked;
            _x.inkWorkspaceAccess = inkWorkspaceAccess;
            _x.inkWorkspaceAccessState = inkWorkspaceAccessState;
            _x.inkWorkspaceBlockSuggestedApps = inkWorkspaceBlockSuggestedApps;
            _x.internetSharingBlocked = internetSharingBlocked;
            _x.locationServicesBlocked = locationServicesBlocked;
            _x.lockScreenActivateAppsWithVoice = lockScreenActivateAppsWithVoice;
            _x.lockScreenAllowTimeoutConfiguration = lockScreenAllowTimeoutConfiguration;
            _x.lockScreenBlockActionCenterNotifications = lockScreenBlockActionCenterNotifications;
            _x.lockScreenBlockCortana = lockScreenBlockCortana;
            _x.lockScreenBlockToastNotifications = lockScreenBlockToastNotifications;
            _x.lockScreenTimeoutInSeconds = lockScreenTimeoutInSeconds;
            _x.logonBlockFastUserSwitching = logonBlockFastUserSwitching;
            _x.messagingBlockMMS = messagingBlockMMS;
            _x.messagingBlockRichCommunicationServices = messagingBlockRichCommunicationServices;
            _x.messagingBlockSync = messagingBlockSync;
            _x.microsoftAccountBlocked = microsoftAccountBlocked;
            _x.microsoftAccountBlockSettingsSync = microsoftAccountBlockSettingsSync;
            _x.microsoftAccountSignInAssistantSettings = microsoftAccountSignInAssistantSettings;
            _x.networkProxyApplySettingsDeviceWide = networkProxyApplySettingsDeviceWide;
            _x.networkProxyAutomaticConfigurationUrl = networkProxyAutomaticConfigurationUrl;
            _x.networkProxyDisableAutoDetect = networkProxyDisableAutoDetect;
            _x.networkProxyServer = networkProxyServer;
            _x.nfcBlocked = nfcBlocked;
            _x.oneDriveDisableFileSync = oneDriveDisableFileSync;
            _x.passwordBlockSimple = passwordBlockSimple;
            _x.passwordExpirationDays = passwordExpirationDays;
            _x.passwordMinimumAgeInDays = passwordMinimumAgeInDays;
            _x.passwordMinimumCharacterSetCount = passwordMinimumCharacterSetCount;
            _x.passwordMinimumLength = passwordMinimumLength;
            _x.passwordMinutesOfInactivityBeforeScreenTimeout = passwordMinutesOfInactivityBeforeScreenTimeout;
            _x.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
            _x.passwordRequired = passwordRequired;
            _x.passwordRequiredType = passwordRequiredType;
            _x.passwordRequireWhenResumeFromIdleState = passwordRequireWhenResumeFromIdleState;
            _x.passwordSignInFailureCountBeforeFactoryReset = passwordSignInFailureCountBeforeFactoryReset;
            _x.personalizationDesktopImageUrl = personalizationDesktopImageUrl;
            _x.personalizationLockScreenImageUrl = personalizationLockScreenImageUrl;
            _x.powerButtonActionOnBattery = powerButtonActionOnBattery;
            _x.powerButtonActionPluggedIn = powerButtonActionPluggedIn;
            _x.powerHybridSleepOnBattery = powerHybridSleepOnBattery;
            _x.powerHybridSleepPluggedIn = powerHybridSleepPluggedIn;
            _x.powerLidCloseActionOnBattery = powerLidCloseActionOnBattery;
            _x.powerLidCloseActionPluggedIn = powerLidCloseActionPluggedIn;
            _x.powerSleepButtonActionOnBattery = powerSleepButtonActionOnBattery;
            _x.powerSleepButtonActionPluggedIn = powerSleepButtonActionPluggedIn;
            _x.printerBlockAddition = printerBlockAddition;
            _x.printerDefaultName = printerDefaultName;
            _x.printerNames = printerNames;
            _x.printerNamesNextLink = printerNamesNextLink;
            _x.privacyAdvertisingId = privacyAdvertisingId;
            _x.privacyAutoAcceptPairingAndConsentPrompts = privacyAutoAcceptPairingAndConsentPrompts;
            _x.privacyBlockActivityFeed = privacyBlockActivityFeed;
            _x.privacyBlockInputPersonalization = privacyBlockInputPersonalization;
            _x.privacyBlockPublishUserActivities = privacyBlockPublishUserActivities;
            _x.privacyDisableLaunchExperience = privacyDisableLaunchExperience;
            _x.resetProtectionModeBlocked = resetProtectionModeBlocked;
            _x.safeSearchFilter = safeSearchFilter;
            _x.screenCaptureBlocked = screenCaptureBlocked;
            _x.searchBlockDiacritics = searchBlockDiacritics;
            _x.searchBlockWebResults = searchBlockWebResults;
            _x.searchDisableAutoLanguageDetection = searchDisableAutoLanguageDetection;
            _x.searchDisableIndexerBackoff = searchDisableIndexerBackoff;
            _x.searchDisableIndexingEncryptedItems = searchDisableIndexingEncryptedItems;
            _x.searchDisableIndexingRemovableDrive = searchDisableIndexingRemovableDrive;
            _x.searchDisableLocation = searchDisableLocation;
            _x.searchDisableUseLocation = searchDisableUseLocation;
            _x.searchEnableAutomaticIndexSizeManangement = searchEnableAutomaticIndexSizeManangement;
            _x.searchEnableRemoteQueries = searchEnableRemoteQueries;
            _x.securityBlockAzureADJoinedDevicesAutoEncryption = securityBlockAzureADJoinedDevicesAutoEncryption;
            _x.settingsBlockAccountsPage = settingsBlockAccountsPage;
            _x.settingsBlockAddProvisioningPackage = settingsBlockAddProvisioningPackage;
            _x.settingsBlockAppsPage = settingsBlockAppsPage;
            _x.settingsBlockChangeLanguage = settingsBlockChangeLanguage;
            _x.settingsBlockChangePowerSleep = settingsBlockChangePowerSleep;
            _x.settingsBlockChangeRegion = settingsBlockChangeRegion;
            _x.settingsBlockChangeSystemTime = settingsBlockChangeSystemTime;
            _x.settingsBlockDevicesPage = settingsBlockDevicesPage;
            _x.settingsBlockEaseOfAccessPage = settingsBlockEaseOfAccessPage;
            _x.settingsBlockEditDeviceName = settingsBlockEditDeviceName;
            _x.settingsBlockGamingPage = settingsBlockGamingPage;
            _x.settingsBlockNetworkInternetPage = settingsBlockNetworkInternetPage;
            _x.settingsBlockPersonalizationPage = settingsBlockPersonalizationPage;
            _x.settingsBlockPrivacyPage = settingsBlockPrivacyPage;
            _x.settingsBlockRemoveProvisioningPackage = settingsBlockRemoveProvisioningPackage;
            _x.settingsBlockSettingsApp = settingsBlockSettingsApp;
            _x.settingsBlockSystemPage = settingsBlockSystemPage;
            _x.settingsBlockTimeLanguagePage = settingsBlockTimeLanguagePage;
            _x.settingsBlockUpdateSecurityPage = settingsBlockUpdateSecurityPage;
            _x.sharedUserAppDataAllowed = sharedUserAppDataAllowed;
            _x.smartScreenAppInstallControl = smartScreenAppInstallControl;
            _x.smartScreenBlockPromptOverride = smartScreenBlockPromptOverride;
            _x.smartScreenBlockPromptOverrideForFiles = smartScreenBlockPromptOverrideForFiles;
            _x.smartScreenEnableAppInstallControl = smartScreenEnableAppInstallControl;
            _x.startBlockUnpinningAppsFromTaskbar = startBlockUnpinningAppsFromTaskbar;
            _x.startMenuAppListVisibility = startMenuAppListVisibility;
            _x.startMenuHideChangeAccountSettings = startMenuHideChangeAccountSettings;
            _x.startMenuHideFrequentlyUsedApps = startMenuHideFrequentlyUsedApps;
            _x.startMenuHideHibernate = startMenuHideHibernate;
            _x.startMenuHideLock = startMenuHideLock;
            _x.startMenuHidePowerButton = startMenuHidePowerButton;
            _x.startMenuHideRecentJumpLists = startMenuHideRecentJumpLists;
            _x.startMenuHideRecentlyAddedApps = startMenuHideRecentlyAddedApps;
            _x.startMenuHideRestartOptions = startMenuHideRestartOptions;
            _x.startMenuHideShutDown = startMenuHideShutDown;
            _x.startMenuHideSignOut = startMenuHideSignOut;
            _x.startMenuHideSleep = startMenuHideSleep;
            _x.startMenuHideSwitchAccount = startMenuHideSwitchAccount;
            _x.startMenuHideUserTile = startMenuHideUserTile;
            _x.startMenuLayoutEdgeAssetsXml = startMenuLayoutEdgeAssetsXml;
            _x.startMenuLayoutXml = startMenuLayoutXml;
            _x.startMenuMode = startMenuMode;
            _x.startMenuPinnedFolderDocuments = startMenuPinnedFolderDocuments;
            _x.startMenuPinnedFolderDownloads = startMenuPinnedFolderDownloads;
            _x.startMenuPinnedFolderFileExplorer = startMenuPinnedFolderFileExplorer;
            _x.startMenuPinnedFolderHomeGroup = startMenuPinnedFolderHomeGroup;
            _x.startMenuPinnedFolderMusic = startMenuPinnedFolderMusic;
            _x.startMenuPinnedFolderNetwork = startMenuPinnedFolderNetwork;
            _x.startMenuPinnedFolderPersonalFolder = startMenuPinnedFolderPersonalFolder;
            _x.startMenuPinnedFolderPictures = startMenuPinnedFolderPictures;
            _x.startMenuPinnedFolderSettings = startMenuPinnedFolderSettings;
            _x.startMenuPinnedFolderVideos = startMenuPinnedFolderVideos;
            _x.storageBlockRemovableStorage = storageBlockRemovableStorage;
            _x.storageRequireMobileDeviceEncryption = storageRequireMobileDeviceEncryption;
            _x.storageRestrictAppDataToSystemVolume = storageRestrictAppDataToSystemVolume;
            _x.storageRestrictAppInstallToSystemVolume = storageRestrictAppInstallToSystemVolume;
            _x.systemTelemetryProxyServer = systemTelemetryProxyServer;
            _x.taskManagerBlockEndTask = taskManagerBlockEndTask;
            _x.tenantLockdownRequireNetworkDuringOutOfBoxExperience = tenantLockdownRequireNetworkDuringOutOfBoxExperience;
            _x.uninstallBuiltInApps = uninstallBuiltInApps;
            _x.usbBlocked = usbBlocked;
            _x.voiceRecordingBlocked = voiceRecordingBlocked;
            _x.webRtcBlockLocalhostIpAddress = webRtcBlockLocalhostIpAddress;
            _x.wiFiBlockAutomaticConnectHotspots = wiFiBlockAutomaticConnectHotspots;
            _x.wiFiBlocked = wiFiBlocked;
            _x.wiFiBlockManualConfiguration = wiFiBlockManualConfiguration;
            _x.wiFiScanInterval = wiFiScanInterval;
            _x.windows10AppsForceUpdateSchedule = windows10AppsForceUpdateSchedule;
            _x.windowsSpotlightBlockConsumerSpecificFeatures = windowsSpotlightBlockConsumerSpecificFeatures;
            _x.windowsSpotlightBlocked = windowsSpotlightBlocked;
            _x.windowsSpotlightBlockOnActionCenter = windowsSpotlightBlockOnActionCenter;
            _x.windowsSpotlightBlockTailoredExperiences = windowsSpotlightBlockTailoredExperiences;
            _x.windowsSpotlightBlockThirdPartyNotifications = windowsSpotlightBlockThirdPartyNotifications;
            _x.windowsSpotlightBlockWelcomeExperience = windowsSpotlightBlockWelcomeExperience;
            _x.windowsSpotlightBlockWindowsTips = windowsSpotlightBlockWindowsTips;
            _x.windowsSpotlightConfigureOnLockScreen = windowsSpotlightConfigureOnLockScreen;
            _x.windowsStoreBlockAutoUpdate = windowsStoreBlockAutoUpdate;
            _x.windowsStoreBlocked = windowsStoreBlocked;
            _x.windowsStoreEnablePrivateStoreOnly = windowsStoreEnablePrivateStoreOnly;
            _x.wirelessDisplayBlockProjectionToThisDevice = wirelessDisplayBlockProjectionToThisDevice;
            _x.wirelessDisplayBlockUserInputFromReceiver = wirelessDisplayBlockUserInputFromReceiver;
            _x.wirelessDisplayRequirePinForPairing = wirelessDisplayRequirePinForPairing;
            _x.privacyAccessControls = privacyAccessControls;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Indicates whether or not to Block the user from adding email accounts to the
     * device that are not associated with a Microsoft account.”</i>
     * 
     * @return property accountsBlockAddingNonMicrosoftAccountEmail
     */
    @Property(name="accountsBlockAddingNonMicrosoftAccountEmail")
    @JsonIgnore
    public Optional<Boolean> getAccountsBlockAddingNonMicrosoftAccountEmail() {
        return Optional.ofNullable(accountsBlockAddingNonMicrosoftAccountEmail);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * accountsBlockAddingNonMicrosoftAccountEmail} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to Block the user from adding email accounts to the
     * device that are not associated with a Microsoft account.”</i>
     * 
     * @param accountsBlockAddingNonMicrosoftAccountEmail
     *            new value of {@code accountsBlockAddingNonMicrosoftAccountEmail} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code accountsBlockAddingNonMicrosoftAccountEmail} field changed
     */
    public Windows10GeneralConfiguration withAccountsBlockAddingNonMicrosoftAccountEmail(Boolean accountsBlockAddingNonMicrosoftAccountEmail) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("accountsBlockAddingNonMicrosoftAccountEmail");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.accountsBlockAddingNonMicrosoftAccountEmail = accountsBlockAddingNonMicrosoftAccountEmail;
        return _x;
    }

    /**
     * <i>“Specifies if Windows apps can be activated by voice.”</i>
     * 
     * @return property activateAppsWithVoice
     */
    @Property(name="activateAppsWithVoice")
    @JsonIgnore
    public Optional<Enablement> getActivateAppsWithVoice() {
        return Optional.ofNullable(activateAppsWithVoice);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * activateAppsWithVoice} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Specifies if Windows apps can be activated by voice.”</i>
     * 
     * @param activateAppsWithVoice
     *            new value of {@code activateAppsWithVoice} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code activateAppsWithVoice} field changed
     */
    public Windows10GeneralConfiguration withActivateAppsWithVoice(Enablement activateAppsWithVoice) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("activateAppsWithVoice");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.activateAppsWithVoice = activateAppsWithVoice;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from selecting an AntiTheft mode
     * preference (Windows 10 Mobile only).”</i>
     * 
     * @return property antiTheftModeBlocked
     */
    @Property(name="antiTheftModeBlocked")
    @JsonIgnore
    public Optional<Boolean> getAntiTheftModeBlocked() {
        return Optional.ofNullable(antiTheftModeBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * antiTheftModeBlocked} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from selecting an AntiTheft mode
     * preference (Windows 10 Mobile only).”</i>
     * 
     * @param antiTheftModeBlocked
     *            new value of {@code antiTheftModeBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code antiTheftModeBlocked} field changed
     */
    public Windows10GeneralConfiguration withAntiTheftModeBlocked(Boolean antiTheftModeBlocked) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("antiTheftModeBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.antiTheftModeBlocked = antiTheftModeBlocked;
        return _x;
    }

    /**
     * <i>“This policy setting permits users to change installation options that typically
     * are available only to system administrators.”</i>
     * 
     * @return property appManagementMSIAllowUserControlOverInstall
     */
    @Property(name="appManagementMSIAllowUserControlOverInstall")
    @JsonIgnore
    public Optional<Boolean> getAppManagementMSIAllowUserControlOverInstall() {
        return Optional.ofNullable(appManagementMSIAllowUserControlOverInstall);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appManagementMSIAllowUserControlOverInstall} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“This policy setting permits users to change installation options that typically
     * are available only to system administrators.”</i>
     * 
     * @param appManagementMSIAllowUserControlOverInstall
     *            new value of {@code appManagementMSIAllowUserControlOverInstall} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appManagementMSIAllowUserControlOverInstall} field changed
     */
    public Windows10GeneralConfiguration withAppManagementMSIAllowUserControlOverInstall(Boolean appManagementMSIAllowUserControlOverInstall) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("appManagementMSIAllowUserControlOverInstall");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.appManagementMSIAllowUserControlOverInstall = appManagementMSIAllowUserControlOverInstall;
        return _x;
    }

    /**
     * <i>“This policy setting directs Windows Installer to use elevated permissions when
     * it installs any program on the system.”</i>
     * 
     * @return property appManagementMSIAlwaysInstallWithElevatedPrivileges
     */
    @Property(name="appManagementMSIAlwaysInstallWithElevatedPrivileges")
    @JsonIgnore
    public Optional<Boolean> getAppManagementMSIAlwaysInstallWithElevatedPrivileges() {
        return Optional.ofNullable(appManagementMSIAlwaysInstallWithElevatedPrivileges);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appManagementMSIAlwaysInstallWithElevatedPrivileges} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“This policy setting directs Windows Installer to use elevated permissions when
     * it installs any program on the system.”</i>
     * 
     * @param appManagementMSIAlwaysInstallWithElevatedPrivileges
     *            new value of {@code appManagementMSIAlwaysInstallWithElevatedPrivileges} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appManagementMSIAlwaysInstallWithElevatedPrivileges} field changed
     */
    public Windows10GeneralConfiguration withAppManagementMSIAlwaysInstallWithElevatedPrivileges(Boolean appManagementMSIAlwaysInstallWithElevatedPrivileges) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("appManagementMSIAlwaysInstallWithElevatedPrivileges");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.appManagementMSIAlwaysInstallWithElevatedPrivileges = appManagementMSIAlwaysInstallWithElevatedPrivileges;
        return _x;
    }

    /**
     * <i>“List of semi-colon delimited Package Family Names of Windows apps. Listed
     * Windows apps are to be launched after logon.​”</i>
     * 
     * @return property appManagementPackageFamilyNamesToLaunchAfterLogOn
     */
    @Property(name="appManagementPackageFamilyNamesToLaunchAfterLogOn")
    @JsonIgnore
    public CollectionPage<String> getAppManagementPackageFamilyNamesToLaunchAfterLogOn() {
        return new CollectionPage<String>(contextPath, String.class, this.appManagementPackageFamilyNamesToLaunchAfterLogOn, Optional.ofNullable(appManagementPackageFamilyNamesToLaunchAfterLogOnNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appManagementPackageFamilyNamesToLaunchAfterLogOn} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“List of semi-colon delimited Package Family Names of Windows apps. Listed
     * Windows apps are to be launched after logon.​”</i>
     * 
     * @param appManagementPackageFamilyNamesToLaunchAfterLogOn
     *            new value of {@code appManagementPackageFamilyNamesToLaunchAfterLogOn} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appManagementPackageFamilyNamesToLaunchAfterLogOn} field changed
     */
    public Windows10GeneralConfiguration withAppManagementPackageFamilyNamesToLaunchAfterLogOn(List<String> appManagementPackageFamilyNamesToLaunchAfterLogOn) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("appManagementPackageFamilyNamesToLaunchAfterLogOn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.appManagementPackageFamilyNamesToLaunchAfterLogOn = appManagementPackageFamilyNamesToLaunchAfterLogOn;
        return _x;
    }

    /**
     * <i>“List of semi-colon delimited Package Family Names of Windows apps. Listed
     * Windows apps are to be launched after logon.​”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property appManagementPackageFamilyNamesToLaunchAfterLogOn
     */
    @Property(name="appManagementPackageFamilyNamesToLaunchAfterLogOn")
    @JsonIgnore
    public CollectionPage<String> getAppManagementPackageFamilyNamesToLaunchAfterLogOn(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.appManagementPackageFamilyNamesToLaunchAfterLogOn, Optional.ofNullable(appManagementPackageFamilyNamesToLaunchAfterLogOnNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Indicates whether apps from AppX packages signed with a trusted certificate can
     * be side loaded.”</i>
     * 
     * @return property appsAllowTrustedAppsSideloading
     */
    @Property(name="appsAllowTrustedAppsSideloading")
    @JsonIgnore
    public Optional<StateManagementSetting> getAppsAllowTrustedAppsSideloading() {
        return Optional.ofNullable(appsAllowTrustedAppsSideloading);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appsAllowTrustedAppsSideloading} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether apps from AppX packages signed with a trusted certificate can
     * be side loaded.”</i>
     * 
     * @param appsAllowTrustedAppsSideloading
     *            new value of {@code appsAllowTrustedAppsSideloading} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appsAllowTrustedAppsSideloading} field changed
     */
    public Windows10GeneralConfiguration withAppsAllowTrustedAppsSideloading(StateManagementSetting appsAllowTrustedAppsSideloading) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("appsAllowTrustedAppsSideloading");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.appsAllowTrustedAppsSideloading = appsAllowTrustedAppsSideloading;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to disable the launch of all apps from Windows Store
     * that came pre-installed or were downloaded.”</i>
     * 
     * @return property appsBlockWindowsStoreOriginatedApps
     */
    @Property(name="appsBlockWindowsStoreOriginatedApps")
    @JsonIgnore
    public Optional<Boolean> getAppsBlockWindowsStoreOriginatedApps() {
        return Optional.ofNullable(appsBlockWindowsStoreOriginatedApps);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appsBlockWindowsStoreOriginatedApps} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to disable the launch of all apps from Windows Store
     * that came pre-installed or were downloaded.”</i>
     * 
     * @param appsBlockWindowsStoreOriginatedApps
     *            new value of {@code appsBlockWindowsStoreOriginatedApps} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appsBlockWindowsStoreOriginatedApps} field changed
     */
    public Windows10GeneralConfiguration withAppsBlockWindowsStoreOriginatedApps(Boolean appsBlockWindowsStoreOriginatedApps) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("appsBlockWindowsStoreOriginatedApps");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.appsBlockWindowsStoreOriginatedApps = appsBlockWindowsStoreOriginatedApps;
        return _x;
    }

    /**
     * <i>“Allows secondary authentication devices to work with Windows.”</i>
     * 
     * @return property authenticationAllowSecondaryDevice
     */
    @Property(name="authenticationAllowSecondaryDevice")
    @JsonIgnore
    public Optional<Boolean> getAuthenticationAllowSecondaryDevice() {
        return Optional.ofNullable(authenticationAllowSecondaryDevice);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * authenticationAllowSecondaryDevice} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Allows secondary authentication devices to work with Windows.”</i>
     * 
     * @param authenticationAllowSecondaryDevice
     *            new value of {@code authenticationAllowSecondaryDevice} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code authenticationAllowSecondaryDevice} field changed
     */
    public Windows10GeneralConfiguration withAuthenticationAllowSecondaryDevice(Boolean authenticationAllowSecondaryDevice) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("authenticationAllowSecondaryDevice");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.authenticationAllowSecondaryDevice = authenticationAllowSecondaryDevice;
        return _x;
    }

    /**
     * <i>“Specifies the preferred domain among available domains in the Azure AD tenant.”</i>
     * 
     * @return property authenticationPreferredAzureADTenantDomainName
     */
    @Property(name="authenticationPreferredAzureADTenantDomainName")
    @JsonIgnore
    public Optional<String> getAuthenticationPreferredAzureADTenantDomainName() {
        return Optional.ofNullable(authenticationPreferredAzureADTenantDomainName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * authenticationPreferredAzureADTenantDomainName} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Specifies the preferred domain among available domains in the Azure AD tenant.”</i>
     * 
     * @param authenticationPreferredAzureADTenantDomainName
     *            new value of {@code authenticationPreferredAzureADTenantDomainName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code authenticationPreferredAzureADTenantDomainName} field changed
     */
    public Windows10GeneralConfiguration withAuthenticationPreferredAzureADTenantDomainName(String authenticationPreferredAzureADTenantDomainName) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("authenticationPreferredAzureADTenantDomainName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.authenticationPreferredAzureADTenantDomainName = authenticationPreferredAzureADTenantDomainName;
        return _x;
    }

    /**
     * <i>“Indicates whether or not Web Credential Provider will be enabled.”</i>
     * 
     * @return property authenticationWebSignIn
     */
    @Property(name="authenticationWebSignIn")
    @JsonIgnore
    public Optional<Enablement> getAuthenticationWebSignIn() {
        return Optional.ofNullable(authenticationWebSignIn);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * authenticationWebSignIn} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not Web Credential Provider will be enabled.”</i>
     * 
     * @param authenticationWebSignIn
     *            new value of {@code authenticationWebSignIn} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code authenticationWebSignIn} field changed
     */
    public Windows10GeneralConfiguration withAuthenticationWebSignIn(Enablement authenticationWebSignIn) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("authenticationWebSignIn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.authenticationWebSignIn = authenticationWebSignIn;
        return _x;
    }

    /**
     * <i>“Specify a list of allowed Bluetooth services and profiles in hex formatted
     * strings.”</i>
     * 
     * @return property bluetoothAllowedServices
     */
    @Property(name="bluetoothAllowedServices")
    @JsonIgnore
    public CollectionPage<String> getBluetoothAllowedServices() {
        return new CollectionPage<String>(contextPath, String.class, this.bluetoothAllowedServices, Optional.ofNullable(bluetoothAllowedServicesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bluetoothAllowedServices} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Specify a list of allowed Bluetooth services and profiles in hex formatted
     * strings.”</i>
     * 
     * @param bluetoothAllowedServices
     *            new value of {@code bluetoothAllowedServices} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bluetoothAllowedServices} field changed
     */
    public Windows10GeneralConfiguration withBluetoothAllowedServices(List<String> bluetoothAllowedServices) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("bluetoothAllowedServices");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.bluetoothAllowedServices = bluetoothAllowedServices;
        return _x;
    }

    /**
     * <i>“Specify a list of allowed Bluetooth services and profiles in hex formatted
     * strings.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property bluetoothAllowedServices
     */
    @Property(name="bluetoothAllowedServices")
    @JsonIgnore
    public CollectionPage<String> getBluetoothAllowedServices(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.bluetoothAllowedServices, Optional.ofNullable(bluetoothAllowedServicesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Whether or not to Block the user from using bluetooth advertising.”</i>
     * 
     * @return property bluetoothBlockAdvertising
     */
    @Property(name="bluetoothBlockAdvertising")
    @JsonIgnore
    public Optional<Boolean> getBluetoothBlockAdvertising() {
        return Optional.ofNullable(bluetoothBlockAdvertising);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bluetoothBlockAdvertising} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Whether or not to Block the user from using bluetooth advertising.”</i>
     * 
     * @param bluetoothBlockAdvertising
     *            new value of {@code bluetoothBlockAdvertising} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bluetoothBlockAdvertising} field changed
     */
    public Windows10GeneralConfiguration withBluetoothBlockAdvertising(Boolean bluetoothBlockAdvertising) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("bluetoothBlockAdvertising");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.bluetoothBlockAdvertising = bluetoothBlockAdvertising;
        return _x;
    }

    /**
     * <i>“Whether or not to Block the user from using bluetooth discoverable mode.”</i>
     * 
     * @return property bluetoothBlockDiscoverableMode
     */
    @Property(name="bluetoothBlockDiscoverableMode")
    @JsonIgnore
    public Optional<Boolean> getBluetoothBlockDiscoverableMode() {
        return Optional.ofNullable(bluetoothBlockDiscoverableMode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bluetoothBlockDiscoverableMode} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Whether or not to Block the user from using bluetooth discoverable mode.”</i>
     * 
     * @param bluetoothBlockDiscoverableMode
     *            new value of {@code bluetoothBlockDiscoverableMode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bluetoothBlockDiscoverableMode} field changed
     */
    public Windows10GeneralConfiguration withBluetoothBlockDiscoverableMode(Boolean bluetoothBlockDiscoverableMode) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("bluetoothBlockDiscoverableMode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.bluetoothBlockDiscoverableMode = bluetoothBlockDiscoverableMode;
        return _x;
    }

    /**
     * <i>“Whether or not to Block the user from using bluetooth.”</i>
     * 
     * @return property bluetoothBlocked
     */
    @Property(name="bluetoothBlocked")
    @JsonIgnore
    public Optional<Boolean> getBluetoothBlocked() {
        return Optional.ofNullable(bluetoothBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code bluetoothBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Whether or not to Block the user from using bluetooth.”</i>
     * 
     * @param bluetoothBlocked
     *            new value of {@code bluetoothBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bluetoothBlocked} field changed
     */
    public Windows10GeneralConfiguration withBluetoothBlocked(Boolean bluetoothBlocked) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("bluetoothBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.bluetoothBlocked = bluetoothBlocked;
        return _x;
    }

    /**
     * <i>“Whether or not to block specific bundled Bluetooth peripherals to automatically
     * pair with the host device.”</i>
     * 
     * @return property bluetoothBlockPrePairing
     */
    @Property(name="bluetoothBlockPrePairing")
    @JsonIgnore
    public Optional<Boolean> getBluetoothBlockPrePairing() {
        return Optional.ofNullable(bluetoothBlockPrePairing);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bluetoothBlockPrePairing} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Whether or not to block specific bundled Bluetooth peripherals to automatically
     * pair with the host device.”</i>
     * 
     * @param bluetoothBlockPrePairing
     *            new value of {@code bluetoothBlockPrePairing} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bluetoothBlockPrePairing} field changed
     */
    public Windows10GeneralConfiguration withBluetoothBlockPrePairing(Boolean bluetoothBlockPrePairing) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("bluetoothBlockPrePairing");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.bluetoothBlockPrePairing = bluetoothBlockPrePairing;
        return _x;
    }

    /**
     * <i>“Whether or not to block the users from using Swift Pair and other proximity
     * based scenarios.”</i>
     * 
     * @return property bluetoothBlockPromptedProximalConnections
     */
    @Property(name="bluetoothBlockPromptedProximalConnections")
    @JsonIgnore
    public Optional<Boolean> getBluetoothBlockPromptedProximalConnections() {
        return Optional.ofNullable(bluetoothBlockPromptedProximalConnections);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bluetoothBlockPromptedProximalConnections} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Whether or not to block the users from using Swift Pair and other proximity
     * based scenarios.”</i>
     * 
     * @param bluetoothBlockPromptedProximalConnections
     *            new value of {@code bluetoothBlockPromptedProximalConnections} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bluetoothBlockPromptedProximalConnections} field changed
     */
    public Windows10GeneralConfiguration withBluetoothBlockPromptedProximalConnections(Boolean bluetoothBlockPromptedProximalConnections) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("bluetoothBlockPromptedProximalConnections");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.bluetoothBlockPromptedProximalConnections = bluetoothBlockPromptedProximalConnections;
        return _x;
    }

    /**
     * <i>“Whether or not to Block the user from accessing the camera of the device.”</i>
     * 
     * @return property cameraBlocked
     */
    @Property(name="cameraBlocked")
    @JsonIgnore
    public Optional<Boolean> getCameraBlocked() {
        return Optional.ofNullable(cameraBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code cameraBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Whether or not to Block the user from accessing the camera of the device.”</i>
     * 
     * @param cameraBlocked
     *            new value of {@code cameraBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cameraBlocked} field changed
     */
    public Windows10GeneralConfiguration withCameraBlocked(Boolean cameraBlocked) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("cameraBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.cameraBlocked = cameraBlocked;
        return _x;
    }

    /**
     * <i>“Whether or not to Block the user from using data over cellular while roaming.”</i>
     * 
     * @return property cellularBlockDataWhenRoaming
     */
    @Property(name="cellularBlockDataWhenRoaming")
    @JsonIgnore
    public Optional<Boolean> getCellularBlockDataWhenRoaming() {
        return Optional.ofNullable(cellularBlockDataWhenRoaming);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cellularBlockDataWhenRoaming} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Whether or not to Block the user from using data over cellular while roaming.”</i>
     * 
     * @param cellularBlockDataWhenRoaming
     *            new value of {@code cellularBlockDataWhenRoaming} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cellularBlockDataWhenRoaming} field changed
     */
    public Windows10GeneralConfiguration withCellularBlockDataWhenRoaming(Boolean cellularBlockDataWhenRoaming) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("cellularBlockDataWhenRoaming");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.cellularBlockDataWhenRoaming = cellularBlockDataWhenRoaming;
        return _x;
    }

    /**
     * <i>“Whether or not to Block the user from using VPN over cellular.”</i>
     * 
     * @return property cellularBlockVpn
     */
    @Property(name="cellularBlockVpn")
    @JsonIgnore
    public Optional<Boolean> getCellularBlockVpn() {
        return Optional.ofNullable(cellularBlockVpn);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code cellularBlockVpn}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Whether or not to Block the user from using VPN over cellular.”</i>
     * 
     * @param cellularBlockVpn
     *            new value of {@code cellularBlockVpn} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cellularBlockVpn} field changed
     */
    public Windows10GeneralConfiguration withCellularBlockVpn(Boolean cellularBlockVpn) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("cellularBlockVpn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.cellularBlockVpn = cellularBlockVpn;
        return _x;
    }

    /**
     * <i>“Whether or not to Block the user from using VPN when roaming over cellular.”</i>
     * 
     * @return property cellularBlockVpnWhenRoaming
     */
    @Property(name="cellularBlockVpnWhenRoaming")
    @JsonIgnore
    public Optional<Boolean> getCellularBlockVpnWhenRoaming() {
        return Optional.ofNullable(cellularBlockVpnWhenRoaming);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cellularBlockVpnWhenRoaming} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Whether or not to Block the user from using VPN when roaming over cellular.”</i>
     * 
     * @param cellularBlockVpnWhenRoaming
     *            new value of {@code cellularBlockVpnWhenRoaming} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cellularBlockVpnWhenRoaming} field changed
     */
    public Windows10GeneralConfiguration withCellularBlockVpnWhenRoaming(Boolean cellularBlockVpnWhenRoaming) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("cellularBlockVpnWhenRoaming");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.cellularBlockVpnWhenRoaming = cellularBlockVpnWhenRoaming;
        return _x;
    }

    /**
     * <i>“Whether or not to allow the cellular data channel on the device. If not
     * configured, the cellular data channel is allowed and the user can turn it off.”</i>
     * 
     * @return property cellularData
     */
    @Property(name="cellularData")
    @JsonIgnore
    public Optional<ConfigurationUsage> getCellularData() {
        return Optional.ofNullable(cellularData);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code cellularData}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Whether or not to allow the cellular data channel on the device. If not
     * configured, the cellular data channel is allowed and the user can turn it off.”</i>
     * 
     * @param cellularData
     *            new value of {@code cellularData} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cellularData} field changed
     */
    public Windows10GeneralConfiguration withCellularData(ConfigurationUsage cellularData) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("cellularData");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.cellularData = cellularData;
        return _x;
    }

    /**
     * <i>“Whether or not to Block the user from doing manual root certificate installation
     * .”</i>
     * 
     * @return property certificatesBlockManualRootCertificateInstallation
     */
    @Property(name="certificatesBlockManualRootCertificateInstallation")
    @JsonIgnore
    public Optional<Boolean> getCertificatesBlockManualRootCertificateInstallation() {
        return Optional.ofNullable(certificatesBlockManualRootCertificateInstallation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificatesBlockManualRootCertificateInstallation} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Whether or not to Block the user from doing manual root certificate installation
     * .”</i>
     * 
     * @param certificatesBlockManualRootCertificateInstallation
     *            new value of {@code certificatesBlockManualRootCertificateInstallation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificatesBlockManualRootCertificateInstallation} field changed
     */
    public Windows10GeneralConfiguration withCertificatesBlockManualRootCertificateInstallation(Boolean certificatesBlockManualRootCertificateInstallation) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("certificatesBlockManualRootCertificateInstallation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.certificatesBlockManualRootCertificateInstallation = certificatesBlockManualRootCertificateInstallation;
        return _x;
    }

    /**
     * <i>“Specifies the time zone to be applied to the device. This is the standard
     * Windows name for the target time zone.”</i>
     * 
     * @return property configureTimeZone
     */
    @Property(name="configureTimeZone")
    @JsonIgnore
    public Optional<String> getConfigureTimeZone() {
        return Optional.ofNullable(configureTimeZone);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code configureTimeZone
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Specifies the time zone to be applied to the device. This is the standard
     * Windows name for the target time zone.”</i>
     * 
     * @param configureTimeZone
     *            new value of {@code configureTimeZone} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code configureTimeZone} field changed
     */
    public Windows10GeneralConfiguration withConfigureTimeZone(String configureTimeZone) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("configureTimeZone");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.configureTimeZone = configureTimeZone;
        return _x;
    }

    /**
     * <i>“Whether or not to block Connected Devices Service which enables discovery and
     * connection to other devices, remote messaging, remote app sessions and other
     * cross-device experiences.”</i>
     * 
     * @return property connectedDevicesServiceBlocked
     */
    @Property(name="connectedDevicesServiceBlocked")
    @JsonIgnore
    public Optional<Boolean> getConnectedDevicesServiceBlocked() {
        return Optional.ofNullable(connectedDevicesServiceBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * connectedDevicesServiceBlocked} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Whether or not to block Connected Devices Service which enables discovery and
     * connection to other devices, remote messaging, remote app sessions and other
     * cross-device experiences.”</i>
     * 
     * @param connectedDevicesServiceBlocked
     *            new value of {@code connectedDevicesServiceBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code connectedDevicesServiceBlocked} field changed
     */
    public Windows10GeneralConfiguration withConnectedDevicesServiceBlocked(Boolean connectedDevicesServiceBlocked) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("connectedDevicesServiceBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.connectedDevicesServiceBlocked = connectedDevicesServiceBlocked;
        return _x;
    }

    /**
     * <i>“Whether or not to Block the user from using copy paste.”</i>
     * 
     * @return property copyPasteBlocked
     */
    @Property(name="copyPasteBlocked")
    @JsonIgnore
    public Optional<Boolean> getCopyPasteBlocked() {
        return Optional.ofNullable(copyPasteBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code copyPasteBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Whether or not to Block the user from using copy paste.”</i>
     * 
     * @param copyPasteBlocked
     *            new value of {@code copyPasteBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code copyPasteBlocked} field changed
     */
    public Windows10GeneralConfiguration withCopyPasteBlocked(Boolean copyPasteBlocked) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("copyPasteBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.copyPasteBlocked = copyPasteBlocked;
        return _x;
    }

    /**
     * <i>“Whether or not to Block the user from using Cortana.”</i>
     * 
     * @return property cortanaBlocked
     */
    @Property(name="cortanaBlocked")
    @JsonIgnore
    public Optional<Boolean> getCortanaBlocked() {
        return Optional.ofNullable(cortanaBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code cortanaBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Whether or not to Block the user from using Cortana.”</i>
     * 
     * @param cortanaBlocked
     *            new value of {@code cortanaBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cortanaBlocked} field changed
     */
    public Windows10GeneralConfiguration withCortanaBlocked(Boolean cortanaBlocked) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("cortanaBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.cortanaBlocked = cortanaBlocked;
        return _x;
    }

    /**
     * <i>“Specify whether to allow or disallow the Federal Information Processing Standard
     * (FIPS) policy.”</i>
     * 
     * @return property cryptographyAllowFipsAlgorithmPolicy
     */
    @Property(name="cryptographyAllowFipsAlgorithmPolicy")
    @JsonIgnore
    public Optional<Boolean> getCryptographyAllowFipsAlgorithmPolicy() {
        return Optional.ofNullable(cryptographyAllowFipsAlgorithmPolicy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cryptographyAllowFipsAlgorithmPolicy} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Specify whether to allow or disallow the Federal Information Processing Standard
     * (FIPS) policy.”</i>
     * 
     * @param cryptographyAllowFipsAlgorithmPolicy
     *            new value of {@code cryptographyAllowFipsAlgorithmPolicy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cryptographyAllowFipsAlgorithmPolicy} field changed
     */
    public Windows10GeneralConfiguration withCryptographyAllowFipsAlgorithmPolicy(Boolean cryptographyAllowFipsAlgorithmPolicy) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("cryptographyAllowFipsAlgorithmPolicy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.cryptographyAllowFipsAlgorithmPolicy = cryptographyAllowFipsAlgorithmPolicy;
        return _x;
    }

    /**
     * <i>“This policy setting allows you to block direct memory access (DMA) for all hot
     * pluggable PCI downstream ports until a user logs into Windows.”</i>
     * 
     * @return property dataProtectionBlockDirectMemoryAccess
     */
    @Property(name="dataProtectionBlockDirectMemoryAccess")
    @JsonIgnore
    public Optional<Boolean> getDataProtectionBlockDirectMemoryAccess() {
        return Optional.ofNullable(dataProtectionBlockDirectMemoryAccess);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * dataProtectionBlockDirectMemoryAccess} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“This policy setting allows you to block direct memory access (DMA) for all hot
     * pluggable PCI downstream ports until a user logs into Windows.”</i>
     * 
     * @param dataProtectionBlockDirectMemoryAccess
     *            new value of {@code dataProtectionBlockDirectMemoryAccess} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code dataProtectionBlockDirectMemoryAccess} field changed
     */
    public Windows10GeneralConfiguration withDataProtectionBlockDirectMemoryAccess(Boolean dataProtectionBlockDirectMemoryAccess) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("dataProtectionBlockDirectMemoryAccess");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.dataProtectionBlockDirectMemoryAccess = dataProtectionBlockDirectMemoryAccess;
        return _x;
    }

    /**
     * <i>“Whether or not to block end user access to Defender.”</i>
     * 
     * @return property defenderBlockEndUserAccess
     */
    @Property(name="defenderBlockEndUserAccess")
    @JsonIgnore
    public Optional<Boolean> getDefenderBlockEndUserAccess() {
        return Optional.ofNullable(defenderBlockEndUserAccess);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderBlockEndUserAccess} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Whether or not to block end user access to Defender.”</i>
     * 
     * @param defenderBlockEndUserAccess
     *            new value of {@code defenderBlockEndUserAccess} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderBlockEndUserAccess} field changed
     */
    public Windows10GeneralConfiguration withDefenderBlockEndUserAccess(Boolean defenderBlockEndUserAccess) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderBlockEndUserAccess");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderBlockEndUserAccess = defenderBlockEndUserAccess;
        return _x;
    }

    /**
     * <i>“Allows or disallows Windows Defender On Access Protection functionality.”</i>
     * 
     * @return property defenderBlockOnAccessProtection
     */
    @Property(name="defenderBlockOnAccessProtection")
    @JsonIgnore
    public Optional<Boolean> getDefenderBlockOnAccessProtection() {
        return Optional.ofNullable(defenderBlockOnAccessProtection);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderBlockOnAccessProtection} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Allows or disallows Windows Defender On Access Protection functionality.”</i>
     * 
     * @param defenderBlockOnAccessProtection
     *            new value of {@code defenderBlockOnAccessProtection} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderBlockOnAccessProtection} field changed
     */
    public Windows10GeneralConfiguration withDefenderBlockOnAccessProtection(Boolean defenderBlockOnAccessProtection) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderBlockOnAccessProtection");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderBlockOnAccessProtection = defenderBlockOnAccessProtection;
        return _x;
    }

    /**
     * <i>“Specifies the level of cloud-delivered protection.”</i>
     * 
     * @return property defenderCloudBlockLevel
     */
    @Property(name="defenderCloudBlockLevel")
    @JsonIgnore
    public Optional<DefenderCloudBlockLevelType> getDefenderCloudBlockLevel() {
        return Optional.ofNullable(defenderCloudBlockLevel);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderCloudBlockLevel} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Specifies the level of cloud-delivered protection.”</i>
     * 
     * @param defenderCloudBlockLevel
     *            new value of {@code defenderCloudBlockLevel} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderCloudBlockLevel} field changed
     */
    public Windows10GeneralConfiguration withDefenderCloudBlockLevel(DefenderCloudBlockLevelType defenderCloudBlockLevel) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderCloudBlockLevel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderCloudBlockLevel = defenderCloudBlockLevel;
        return _x;
    }

    /**
     * <i>“Timeout extension for file scanning by the cloud. Valid values 0 to 50”</i>
     * 
     * @return property defenderCloudExtendedTimeout
     */
    @Property(name="defenderCloudExtendedTimeout")
    @JsonIgnore
    public Optional<Integer> getDefenderCloudExtendedTimeout() {
        return Optional.ofNullable(defenderCloudExtendedTimeout);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderCloudExtendedTimeout} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Timeout extension for file scanning by the cloud. Valid values 0 to 50”</i>
     * 
     * @param defenderCloudExtendedTimeout
     *            new value of {@code defenderCloudExtendedTimeout} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderCloudExtendedTimeout} field changed
     */
    public Windows10GeneralConfiguration withDefenderCloudExtendedTimeout(Integer defenderCloudExtendedTimeout) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderCloudExtendedTimeout");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderCloudExtendedTimeout = defenderCloudExtendedTimeout;
        return _x;
    }

    /**
     * <i>“Timeout extension for file scanning by the cloud. Valid values 0 to 50”</i>
     * 
     * @return property defenderCloudExtendedTimeoutInSeconds
     */
    @Property(name="defenderCloudExtendedTimeoutInSeconds")
    @JsonIgnore
    public Optional<Integer> getDefenderCloudExtendedTimeoutInSeconds() {
        return Optional.ofNullable(defenderCloudExtendedTimeoutInSeconds);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderCloudExtendedTimeoutInSeconds} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Timeout extension for file scanning by the cloud. Valid values 0 to 50”</i>
     * 
     * @param defenderCloudExtendedTimeoutInSeconds
     *            new value of {@code defenderCloudExtendedTimeoutInSeconds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderCloudExtendedTimeoutInSeconds} field changed
     */
    public Windows10GeneralConfiguration withDefenderCloudExtendedTimeoutInSeconds(Integer defenderCloudExtendedTimeoutInSeconds) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderCloudExtendedTimeoutInSeconds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderCloudExtendedTimeoutInSeconds = defenderCloudExtendedTimeoutInSeconds;
        return _x;
    }

    /**
     * <i>“Number of days before deleting quarantined malware. Valid values 0 to 90”</i>
     * 
     * @return property defenderDaysBeforeDeletingQuarantinedMalware
     */
    @Property(name="defenderDaysBeforeDeletingQuarantinedMalware")
    @JsonIgnore
    public Optional<Integer> getDefenderDaysBeforeDeletingQuarantinedMalware() {
        return Optional.ofNullable(defenderDaysBeforeDeletingQuarantinedMalware);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderDaysBeforeDeletingQuarantinedMalware} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Number of days before deleting quarantined malware. Valid values 0 to 90”</i>
     * 
     * @param defenderDaysBeforeDeletingQuarantinedMalware
     *            new value of {@code defenderDaysBeforeDeletingQuarantinedMalware} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderDaysBeforeDeletingQuarantinedMalware} field changed
     */
    public Windows10GeneralConfiguration withDefenderDaysBeforeDeletingQuarantinedMalware(Integer defenderDaysBeforeDeletingQuarantinedMalware) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderDaysBeforeDeletingQuarantinedMalware");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderDaysBeforeDeletingQuarantinedMalware = defenderDaysBeforeDeletingQuarantinedMalware;
        return _x;
    }

    /**
     * <i>“Gets or sets Defender’s actions to take on detected Malware per threat level.”</i>
     * 
     * @return property defenderDetectedMalwareActions
     */
    @Property(name="defenderDetectedMalwareActions")
    @JsonIgnore
    public Optional<DefenderDetectedMalwareActions> getDefenderDetectedMalwareActions() {
        return Optional.ofNullable(defenderDetectedMalwareActions);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderDetectedMalwareActions} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Gets or sets Defender’s actions to take on detected Malware per threat level.”</i>
     * 
     * @param defenderDetectedMalwareActions
     *            new value of {@code defenderDetectedMalwareActions} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderDetectedMalwareActions} field changed
     */
    public Windows10GeneralConfiguration withDefenderDetectedMalwareActions(DefenderDetectedMalwareActions defenderDetectedMalwareActions) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderDetectedMalwareActions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderDetectedMalwareActions = defenderDetectedMalwareActions;
        return _x;
    }

    /**
     * <i>“When blocked, catch-up scans for scheduled full scans will be turned off.”</i>
     * 
     * @return property defenderDisableCatchupFullScan
     */
    @Property(name="defenderDisableCatchupFullScan")
    @JsonIgnore
    public Optional<Boolean> getDefenderDisableCatchupFullScan() {
        return Optional.ofNullable(defenderDisableCatchupFullScan);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderDisableCatchupFullScan} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“When blocked, catch-up scans for scheduled full scans will be turned off.”</i>
     * 
     * @param defenderDisableCatchupFullScan
     *            new value of {@code defenderDisableCatchupFullScan} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderDisableCatchupFullScan} field changed
     */
    public Windows10GeneralConfiguration withDefenderDisableCatchupFullScan(Boolean defenderDisableCatchupFullScan) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderDisableCatchupFullScan");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderDisableCatchupFullScan = defenderDisableCatchupFullScan;
        return _x;
    }

    /**
     * <i>“When blocked, catch-up scans for scheduled quick scans will be turned off.”</i>
     * 
     * @return property defenderDisableCatchupQuickScan
     */
    @Property(name="defenderDisableCatchupQuickScan")
    @JsonIgnore
    public Optional<Boolean> getDefenderDisableCatchupQuickScan() {
        return Optional.ofNullable(defenderDisableCatchupQuickScan);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderDisableCatchupQuickScan} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“When blocked, catch-up scans for scheduled quick scans will be turned off.”</i>
     * 
     * @param defenderDisableCatchupQuickScan
     *            new value of {@code defenderDisableCatchupQuickScan} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderDisableCatchupQuickScan} field changed
     */
    public Windows10GeneralConfiguration withDefenderDisableCatchupQuickScan(Boolean defenderDisableCatchupQuickScan) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderDisableCatchupQuickScan");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderDisableCatchupQuickScan = defenderDisableCatchupQuickScan;
        return _x;
    }

    /**
     * <i>“File extensions to exclude from scans and real time protection.”</i>
     * 
     * @return property defenderFileExtensionsToExclude
     */
    @Property(name="defenderFileExtensionsToExclude")
    @JsonIgnore
    public CollectionPage<String> getDefenderFileExtensionsToExclude() {
        return new CollectionPage<String>(contextPath, String.class, this.defenderFileExtensionsToExclude, Optional.ofNullable(defenderFileExtensionsToExcludeNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderFileExtensionsToExclude} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“File extensions to exclude from scans and real time protection.”</i>
     * 
     * @param defenderFileExtensionsToExclude
     *            new value of {@code defenderFileExtensionsToExclude} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderFileExtensionsToExclude} field changed
     */
    public Windows10GeneralConfiguration withDefenderFileExtensionsToExclude(List<String> defenderFileExtensionsToExclude) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderFileExtensionsToExclude");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderFileExtensionsToExclude = defenderFileExtensionsToExclude;
        return _x;
    }

    /**
     * <i>“File extensions to exclude from scans and real time protection.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property defenderFileExtensionsToExclude
     */
    @Property(name="defenderFileExtensionsToExclude")
    @JsonIgnore
    public CollectionPage<String> getDefenderFileExtensionsToExclude(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.defenderFileExtensionsToExclude, Optional.ofNullable(defenderFileExtensionsToExcludeNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Files and folder to exclude from scans and real time protection.”</i>
     * 
     * @return property defenderFilesAndFoldersToExclude
     */
    @Property(name="defenderFilesAndFoldersToExclude")
    @JsonIgnore
    public CollectionPage<String> getDefenderFilesAndFoldersToExclude() {
        return new CollectionPage<String>(contextPath, String.class, this.defenderFilesAndFoldersToExclude, Optional.ofNullable(defenderFilesAndFoldersToExcludeNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderFilesAndFoldersToExclude} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Files and folder to exclude from scans and real time protection.”</i>
     * 
     * @param defenderFilesAndFoldersToExclude
     *            new value of {@code defenderFilesAndFoldersToExclude} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderFilesAndFoldersToExclude} field changed
     */
    public Windows10GeneralConfiguration withDefenderFilesAndFoldersToExclude(List<String> defenderFilesAndFoldersToExclude) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderFilesAndFoldersToExclude");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderFilesAndFoldersToExclude = defenderFilesAndFoldersToExclude;
        return _x;
    }

    /**
     * <i>“Files and folder to exclude from scans and real time protection.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property defenderFilesAndFoldersToExclude
     */
    @Property(name="defenderFilesAndFoldersToExclude")
    @JsonIgnore
    public CollectionPage<String> getDefenderFilesAndFoldersToExclude(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.defenderFilesAndFoldersToExclude, Optional.ofNullable(defenderFilesAndFoldersToExcludeNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Value for monitoring file activity.”</i>
     * 
     * @return property defenderMonitorFileActivity
     */
    @Property(name="defenderMonitorFileActivity")
    @JsonIgnore
    public Optional<DefenderMonitorFileActivity> getDefenderMonitorFileActivity() {
        return Optional.ofNullable(defenderMonitorFileActivity);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderMonitorFileActivity} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Value for monitoring file activity.”</i>
     * 
     * @param defenderMonitorFileActivity
     *            new value of {@code defenderMonitorFileActivity} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderMonitorFileActivity} field changed
     */
    public Windows10GeneralConfiguration withDefenderMonitorFileActivity(DefenderMonitorFileActivity defenderMonitorFileActivity) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderMonitorFileActivity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderMonitorFileActivity = defenderMonitorFileActivity;
        return _x;
    }

    /**
     * <i>“Gets or sets Defender’s action to take on Potentially Unwanted Application (PUA)
     * , which includes software with behaviors of ad-injection, software bundling,
     * persistent solicitation for payment or subscription, etc. Defender alerts user
     * when PUA is being downloaded or attempts to install itself. Added in Windows 10
     * for desktop.”</i>
     * 
     * @return property defenderPotentiallyUnwantedAppAction
     */
    @Property(name="defenderPotentiallyUnwantedAppAction")
    @JsonIgnore
    public Optional<DefenderPotentiallyUnwantedAppAction> getDefenderPotentiallyUnwantedAppAction() {
        return Optional.ofNullable(defenderPotentiallyUnwantedAppAction);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderPotentiallyUnwantedAppAction} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Gets or sets Defender’s action to take on Potentially Unwanted Application (PUA)
     * , which includes software with behaviors of ad-injection, software bundling,
     * persistent solicitation for payment or subscription, etc. Defender alerts user
     * when PUA is being downloaded or attempts to install itself. Added in Windows 10
     * for desktop.”</i>
     * 
     * @param defenderPotentiallyUnwantedAppAction
     *            new value of {@code defenderPotentiallyUnwantedAppAction} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderPotentiallyUnwantedAppAction} field changed
     */
    public Windows10GeneralConfiguration withDefenderPotentiallyUnwantedAppAction(DefenderPotentiallyUnwantedAppAction defenderPotentiallyUnwantedAppAction) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderPotentiallyUnwantedAppAction");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderPotentiallyUnwantedAppAction = defenderPotentiallyUnwantedAppAction;
        return _x;
    }

    /**
     * <i>“Gets or sets Defender’s action to take on Potentially Unwanted Application (PUA)
     * , which includes software with behaviors of ad-injection, software bundling,
     * persistent solicitation for payment or subscription, etc. Defender alerts user
     * when PUA is being downloaded or attempts to install itself. Added in Windows 10
     * for desktop.”</i>
     * 
     * @return property defenderPotentiallyUnwantedAppActionSetting
     */
    @Property(name="defenderPotentiallyUnwantedAppActionSetting")
    @JsonIgnore
    public Optional<DefenderProtectionType> getDefenderPotentiallyUnwantedAppActionSetting() {
        return Optional.ofNullable(defenderPotentiallyUnwantedAppActionSetting);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderPotentiallyUnwantedAppActionSetting} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Gets or sets Defender’s action to take on Potentially Unwanted Application (PUA)
     * , which includes software with behaviors of ad-injection, software bundling,
     * persistent solicitation for payment or subscription, etc. Defender alerts user
     * when PUA is being downloaded or attempts to install itself. Added in Windows 10
     * for desktop.”</i>
     * 
     * @param defenderPotentiallyUnwantedAppActionSetting
     *            new value of {@code defenderPotentiallyUnwantedAppActionSetting} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderPotentiallyUnwantedAppActionSetting} field changed
     */
    public Windows10GeneralConfiguration withDefenderPotentiallyUnwantedAppActionSetting(DefenderProtectionType defenderPotentiallyUnwantedAppActionSetting) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderPotentiallyUnwantedAppActionSetting");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderPotentiallyUnwantedAppActionSetting = defenderPotentiallyUnwantedAppActionSetting;
        return _x;
    }

    /**
     * <i>“Processes to exclude from scans and real time protection.”</i>
     * 
     * @return property defenderProcessesToExclude
     */
    @Property(name="defenderProcessesToExclude")
    @JsonIgnore
    public CollectionPage<String> getDefenderProcessesToExclude() {
        return new CollectionPage<String>(contextPath, String.class, this.defenderProcessesToExclude, Optional.ofNullable(defenderProcessesToExcludeNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderProcessesToExclude} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Processes to exclude from scans and real time protection.”</i>
     * 
     * @param defenderProcessesToExclude
     *            new value of {@code defenderProcessesToExclude} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderProcessesToExclude} field changed
     */
    public Windows10GeneralConfiguration withDefenderProcessesToExclude(List<String> defenderProcessesToExclude) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderProcessesToExclude");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderProcessesToExclude = defenderProcessesToExclude;
        return _x;
    }

    /**
     * <i>“Processes to exclude from scans and real time protection.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property defenderProcessesToExclude
     */
    @Property(name="defenderProcessesToExclude")
    @JsonIgnore
    public CollectionPage<String> getDefenderProcessesToExclude(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.defenderProcessesToExclude, Optional.ofNullable(defenderProcessesToExcludeNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The configuration for how to prompt user for sample submission.”</i>
     * 
     * @return property defenderPromptForSampleSubmission
     */
    @Property(name="defenderPromptForSampleSubmission")
    @JsonIgnore
    public Optional<DefenderPromptForSampleSubmission> getDefenderPromptForSampleSubmission() {
        return Optional.ofNullable(defenderPromptForSampleSubmission);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderPromptForSampleSubmission} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The configuration for how to prompt user for sample submission.”</i>
     * 
     * @param defenderPromptForSampleSubmission
     *            new value of {@code defenderPromptForSampleSubmission} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderPromptForSampleSubmission} field changed
     */
    public Windows10GeneralConfiguration withDefenderPromptForSampleSubmission(DefenderPromptForSampleSubmission defenderPromptForSampleSubmission) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderPromptForSampleSubmission");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderPromptForSampleSubmission = defenderPromptForSampleSubmission;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to require behavior monitoring.”</i>
     * 
     * @return property defenderRequireBehaviorMonitoring
     */
    @Property(name="defenderRequireBehaviorMonitoring")
    @JsonIgnore
    public Optional<Boolean> getDefenderRequireBehaviorMonitoring() {
        return Optional.ofNullable(defenderRequireBehaviorMonitoring);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderRequireBehaviorMonitoring} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to require behavior monitoring.”</i>
     * 
     * @param defenderRequireBehaviorMonitoring
     *            new value of {@code defenderRequireBehaviorMonitoring} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderRequireBehaviorMonitoring} field changed
     */
    public Windows10GeneralConfiguration withDefenderRequireBehaviorMonitoring(Boolean defenderRequireBehaviorMonitoring) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderRequireBehaviorMonitoring");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderRequireBehaviorMonitoring = defenderRequireBehaviorMonitoring;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to require cloud protection.”</i>
     * 
     * @return property defenderRequireCloudProtection
     */
    @Property(name="defenderRequireCloudProtection")
    @JsonIgnore
    public Optional<Boolean> getDefenderRequireCloudProtection() {
        return Optional.ofNullable(defenderRequireCloudProtection);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderRequireCloudProtection} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to require cloud protection.”</i>
     * 
     * @param defenderRequireCloudProtection
     *            new value of {@code defenderRequireCloudProtection} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderRequireCloudProtection} field changed
     */
    public Windows10GeneralConfiguration withDefenderRequireCloudProtection(Boolean defenderRequireCloudProtection) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderRequireCloudProtection");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderRequireCloudProtection = defenderRequireCloudProtection;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to require network inspection system.”</i>
     * 
     * @return property defenderRequireNetworkInspectionSystem
     */
    @Property(name="defenderRequireNetworkInspectionSystem")
    @JsonIgnore
    public Optional<Boolean> getDefenderRequireNetworkInspectionSystem() {
        return Optional.ofNullable(defenderRequireNetworkInspectionSystem);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderRequireNetworkInspectionSystem} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to require network inspection system.”</i>
     * 
     * @param defenderRequireNetworkInspectionSystem
     *            new value of {@code defenderRequireNetworkInspectionSystem} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderRequireNetworkInspectionSystem} field changed
     */
    public Windows10GeneralConfiguration withDefenderRequireNetworkInspectionSystem(Boolean defenderRequireNetworkInspectionSystem) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderRequireNetworkInspectionSystem");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderRequireNetworkInspectionSystem = defenderRequireNetworkInspectionSystem;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to require real time monitoring.”</i>
     * 
     * @return property defenderRequireRealTimeMonitoring
     */
    @Property(name="defenderRequireRealTimeMonitoring")
    @JsonIgnore
    public Optional<Boolean> getDefenderRequireRealTimeMonitoring() {
        return Optional.ofNullable(defenderRequireRealTimeMonitoring);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderRequireRealTimeMonitoring} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to require real time monitoring.”</i>
     * 
     * @param defenderRequireRealTimeMonitoring
     *            new value of {@code defenderRequireRealTimeMonitoring} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderRequireRealTimeMonitoring} field changed
     */
    public Windows10GeneralConfiguration withDefenderRequireRealTimeMonitoring(Boolean defenderRequireRealTimeMonitoring) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderRequireRealTimeMonitoring");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderRequireRealTimeMonitoring = defenderRequireRealTimeMonitoring;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to scan archive files.”</i>
     * 
     * @return property defenderScanArchiveFiles
     */
    @Property(name="defenderScanArchiveFiles")
    @JsonIgnore
    public Optional<Boolean> getDefenderScanArchiveFiles() {
        return Optional.ofNullable(defenderScanArchiveFiles);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderScanArchiveFiles} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to scan archive files.”</i>
     * 
     * @param defenderScanArchiveFiles
     *            new value of {@code defenderScanArchiveFiles} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderScanArchiveFiles} field changed
     */
    public Windows10GeneralConfiguration withDefenderScanArchiveFiles(Boolean defenderScanArchiveFiles) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderScanArchiveFiles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderScanArchiveFiles = defenderScanArchiveFiles;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to scan downloads.”</i>
     * 
     * @return property defenderScanDownloads
     */
    @Property(name="defenderScanDownloads")
    @JsonIgnore
    public Optional<Boolean> getDefenderScanDownloads() {
        return Optional.ofNullable(defenderScanDownloads);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderScanDownloads} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to scan downloads.”</i>
     * 
     * @param defenderScanDownloads
     *            new value of {@code defenderScanDownloads} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderScanDownloads} field changed
     */
    public Windows10GeneralConfiguration withDefenderScanDownloads(Boolean defenderScanDownloads) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderScanDownloads");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderScanDownloads = defenderScanDownloads;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to scan incoming mail messages.”</i>
     * 
     * @return property defenderScanIncomingMail
     */
    @Property(name="defenderScanIncomingMail")
    @JsonIgnore
    public Optional<Boolean> getDefenderScanIncomingMail() {
        return Optional.ofNullable(defenderScanIncomingMail);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderScanIncomingMail} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to scan incoming mail messages.”</i>
     * 
     * @param defenderScanIncomingMail
     *            new value of {@code defenderScanIncomingMail} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderScanIncomingMail} field changed
     */
    public Windows10GeneralConfiguration withDefenderScanIncomingMail(Boolean defenderScanIncomingMail) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderScanIncomingMail");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderScanIncomingMail = defenderScanIncomingMail;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to scan mapped network drives during full scan.”</i>
     * 
     * @return property defenderScanMappedNetworkDrivesDuringFullScan
     */
    @Property(name="defenderScanMappedNetworkDrivesDuringFullScan")
    @JsonIgnore
    public Optional<Boolean> getDefenderScanMappedNetworkDrivesDuringFullScan() {
        return Optional.ofNullable(defenderScanMappedNetworkDrivesDuringFullScan);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderScanMappedNetworkDrivesDuringFullScan} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to scan mapped network drives during full scan.”</i>
     * 
     * @param defenderScanMappedNetworkDrivesDuringFullScan
     *            new value of {@code defenderScanMappedNetworkDrivesDuringFullScan} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderScanMappedNetworkDrivesDuringFullScan} field changed
     */
    public Windows10GeneralConfiguration withDefenderScanMappedNetworkDrivesDuringFullScan(Boolean defenderScanMappedNetworkDrivesDuringFullScan) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderScanMappedNetworkDrivesDuringFullScan");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderScanMappedNetworkDrivesDuringFullScan = defenderScanMappedNetworkDrivesDuringFullScan;
        return _x;
    }

    /**
     * <i>“Max CPU usage percentage during scan. Valid values 0 to 100”</i>
     * 
     * @return property defenderScanMaxCpu
     */
    @Property(name="defenderScanMaxCpu")
    @JsonIgnore
    public Optional<Integer> getDefenderScanMaxCpu() {
        return Optional.ofNullable(defenderScanMaxCpu);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderScanMaxCpu} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Max CPU usage percentage during scan. Valid values 0 to 100”</i>
     * 
     * @param defenderScanMaxCpu
     *            new value of {@code defenderScanMaxCpu} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderScanMaxCpu} field changed
     */
    public Windows10GeneralConfiguration withDefenderScanMaxCpu(Integer defenderScanMaxCpu) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderScanMaxCpu");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderScanMaxCpu = defenderScanMaxCpu;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to scan files opened from a network folder.”</i>
     * 
     * @return property defenderScanNetworkFiles
     */
    @Property(name="defenderScanNetworkFiles")
    @JsonIgnore
    public Optional<Boolean> getDefenderScanNetworkFiles() {
        return Optional.ofNullable(defenderScanNetworkFiles);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderScanNetworkFiles} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to scan files opened from a network folder.”</i>
     * 
     * @param defenderScanNetworkFiles
     *            new value of {@code defenderScanNetworkFiles} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderScanNetworkFiles} field changed
     */
    public Windows10GeneralConfiguration withDefenderScanNetworkFiles(Boolean defenderScanNetworkFiles) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderScanNetworkFiles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderScanNetworkFiles = defenderScanNetworkFiles;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to scan removable drives during full scan.”</i>
     * 
     * @return property defenderScanRemovableDrivesDuringFullScan
     */
    @Property(name="defenderScanRemovableDrivesDuringFullScan")
    @JsonIgnore
    public Optional<Boolean> getDefenderScanRemovableDrivesDuringFullScan() {
        return Optional.ofNullable(defenderScanRemovableDrivesDuringFullScan);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderScanRemovableDrivesDuringFullScan} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to scan removable drives during full scan.”</i>
     * 
     * @param defenderScanRemovableDrivesDuringFullScan
     *            new value of {@code defenderScanRemovableDrivesDuringFullScan} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderScanRemovableDrivesDuringFullScan} field changed
     */
    public Windows10GeneralConfiguration withDefenderScanRemovableDrivesDuringFullScan(Boolean defenderScanRemovableDrivesDuringFullScan) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderScanRemovableDrivesDuringFullScan");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderScanRemovableDrivesDuringFullScan = defenderScanRemovableDrivesDuringFullScan;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to scan scripts loaded in Internet Explorer browser.”</i>
     * 
     * @return property defenderScanScriptsLoadedInInternetExplorer
     */
    @Property(name="defenderScanScriptsLoadedInInternetExplorer")
    @JsonIgnore
    public Optional<Boolean> getDefenderScanScriptsLoadedInInternetExplorer() {
        return Optional.ofNullable(defenderScanScriptsLoadedInInternetExplorer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderScanScriptsLoadedInInternetExplorer} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to scan scripts loaded in Internet Explorer browser.”</i>
     * 
     * @param defenderScanScriptsLoadedInInternetExplorer
     *            new value of {@code defenderScanScriptsLoadedInInternetExplorer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderScanScriptsLoadedInInternetExplorer} field changed
     */
    public Windows10GeneralConfiguration withDefenderScanScriptsLoadedInInternetExplorer(Boolean defenderScanScriptsLoadedInInternetExplorer) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderScanScriptsLoadedInInternetExplorer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderScanScriptsLoadedInInternetExplorer = defenderScanScriptsLoadedInInternetExplorer;
        return _x;
    }

    /**
     * <i>“The defender system scan type.”</i>
     * 
     * @return property defenderScanType
     */
    @Property(name="defenderScanType")
    @JsonIgnore
    public Optional<DefenderScanType> getDefenderScanType() {
        return Optional.ofNullable(defenderScanType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code defenderScanType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The defender system scan type.”</i>
     * 
     * @param defenderScanType
     *            new value of {@code defenderScanType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderScanType} field changed
     */
    public Windows10GeneralConfiguration withDefenderScanType(DefenderScanType defenderScanType) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderScanType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderScanType = defenderScanType;
        return _x;
    }

    /**
     * <i>“The time to perform a daily quick scan.”</i>
     * 
     * @return property defenderScheduledQuickScanTime
     */
    @Property(name="defenderScheduledQuickScanTime")
    @JsonIgnore
    public Optional<LocalTime> getDefenderScheduledQuickScanTime() {
        return Optional.ofNullable(defenderScheduledQuickScanTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderScheduledQuickScanTime} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The time to perform a daily quick scan.”</i>
     * 
     * @param defenderScheduledQuickScanTime
     *            new value of {@code defenderScheduledQuickScanTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderScheduledQuickScanTime} field changed
     */
    public Windows10GeneralConfiguration withDefenderScheduledQuickScanTime(LocalTime defenderScheduledQuickScanTime) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderScheduledQuickScanTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderScheduledQuickScanTime = defenderScheduledQuickScanTime;
        return _x;
    }

    /**
     * <i>“The defender time for the system scan.”</i>
     * 
     * @return property defenderScheduledScanTime
     */
    @Property(name="defenderScheduledScanTime")
    @JsonIgnore
    public Optional<LocalTime> getDefenderScheduledScanTime() {
        return Optional.ofNullable(defenderScheduledScanTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderScheduledScanTime} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The defender time for the system scan.”</i>
     * 
     * @param defenderScheduledScanTime
     *            new value of {@code defenderScheduledScanTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderScheduledScanTime} field changed
     */
    public Windows10GeneralConfiguration withDefenderScheduledScanTime(LocalTime defenderScheduledScanTime) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderScheduledScanTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderScheduledScanTime = defenderScheduledScanTime;
        return _x;
    }

    /**
     * <i>“When enabled, low CPU priority will be used during scheduled scans.”</i>
     * 
     * @return property defenderScheduleScanEnableLowCpuPriority
     */
    @Property(name="defenderScheduleScanEnableLowCpuPriority")
    @JsonIgnore
    public Optional<Boolean> getDefenderScheduleScanEnableLowCpuPriority() {
        return Optional.ofNullable(defenderScheduleScanEnableLowCpuPriority);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderScheduleScanEnableLowCpuPriority} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“When enabled, low CPU priority will be used during scheduled scans.”</i>
     * 
     * @param defenderScheduleScanEnableLowCpuPriority
     *            new value of {@code defenderScheduleScanEnableLowCpuPriority} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderScheduleScanEnableLowCpuPriority} field changed
     */
    public Windows10GeneralConfiguration withDefenderScheduleScanEnableLowCpuPriority(Boolean defenderScheduleScanEnableLowCpuPriority) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderScheduleScanEnableLowCpuPriority");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderScheduleScanEnableLowCpuPriority = defenderScheduleScanEnableLowCpuPriority;
        return _x;
    }

    /**
     * <i>“The signature update interval in hours. Specify 0 not to check. Valid values 0
     * to 24”</i>
     * 
     * @return property defenderSignatureUpdateIntervalInHours
     */
    @Property(name="defenderSignatureUpdateIntervalInHours")
    @JsonIgnore
    public Optional<Integer> getDefenderSignatureUpdateIntervalInHours() {
        return Optional.ofNullable(defenderSignatureUpdateIntervalInHours);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderSignatureUpdateIntervalInHours} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The signature update interval in hours. Specify 0 not to check. Valid values 0
     * to 24”</i>
     * 
     * @param defenderSignatureUpdateIntervalInHours
     *            new value of {@code defenderSignatureUpdateIntervalInHours} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderSignatureUpdateIntervalInHours} field changed
     */
    public Windows10GeneralConfiguration withDefenderSignatureUpdateIntervalInHours(Integer defenderSignatureUpdateIntervalInHours) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderSignatureUpdateIntervalInHours");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderSignatureUpdateIntervalInHours = defenderSignatureUpdateIntervalInHours;
        return _x;
    }

    /**
     * <i>“Checks for the user consent level in Windows Defender to send data.”</i>
     * 
     * @return property defenderSubmitSamplesConsentType
     */
    @Property(name="defenderSubmitSamplesConsentType")
    @JsonIgnore
    public Optional<DefenderSubmitSamplesConsentType> getDefenderSubmitSamplesConsentType() {
        return Optional.ofNullable(defenderSubmitSamplesConsentType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderSubmitSamplesConsentType} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Checks for the user consent level in Windows Defender to send data.”</i>
     * 
     * @param defenderSubmitSamplesConsentType
     *            new value of {@code defenderSubmitSamplesConsentType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderSubmitSamplesConsentType} field changed
     */
    public Windows10GeneralConfiguration withDefenderSubmitSamplesConsentType(DefenderSubmitSamplesConsentType defenderSubmitSamplesConsentType) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderSubmitSamplesConsentType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderSubmitSamplesConsentType = defenderSubmitSamplesConsentType;
        return _x;
    }

    /**
     * <i>“Defender day of the week for the system scan.”</i>
     * 
     * @return property defenderSystemScanSchedule
     */
    @Property(name="defenderSystemScanSchedule")
    @JsonIgnore
    public Optional<WeeklySchedule> getDefenderSystemScanSchedule() {
        return Optional.ofNullable(defenderSystemScanSchedule);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderSystemScanSchedule} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Defender day of the week for the system scan.”</i>
     * 
     * @param defenderSystemScanSchedule
     *            new value of {@code defenderSystemScanSchedule} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderSystemScanSchedule} field changed
     */
    public Windows10GeneralConfiguration withDefenderSystemScanSchedule(WeeklySchedule defenderSystemScanSchedule) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderSystemScanSchedule");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.defenderSystemScanSchedule = defenderSystemScanSchedule;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow developer unlock.”</i>
     * 
     * @return property developerUnlockSetting
     */
    @Property(name="developerUnlockSetting")
    @JsonIgnore
    public Optional<StateManagementSetting> getDeveloperUnlockSetting() {
        return Optional.ofNullable(developerUnlockSetting);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * developerUnlockSetting} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow developer unlock.”</i>
     * 
     * @param developerUnlockSetting
     *            new value of {@code developerUnlockSetting} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code developerUnlockSetting} field changed
     */
    public Windows10GeneralConfiguration withDeveloperUnlockSetting(StateManagementSetting developerUnlockSetting) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("developerUnlockSetting");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.developerUnlockSetting = developerUnlockSetting;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to Block the user from resetting their phone.”</i>
     * 
     * @return property deviceManagementBlockFactoryResetOnMobile
     */
    @Property(name="deviceManagementBlockFactoryResetOnMobile")
    @JsonIgnore
    public Optional<Boolean> getDeviceManagementBlockFactoryResetOnMobile() {
        return Optional.ofNullable(deviceManagementBlockFactoryResetOnMobile);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceManagementBlockFactoryResetOnMobile} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to Block the user from resetting their phone.”</i>
     * 
     * @param deviceManagementBlockFactoryResetOnMobile
     *            new value of {@code deviceManagementBlockFactoryResetOnMobile} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceManagementBlockFactoryResetOnMobile} field changed
     */
    public Windows10GeneralConfiguration withDeviceManagementBlockFactoryResetOnMobile(Boolean deviceManagementBlockFactoryResetOnMobile) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("deviceManagementBlockFactoryResetOnMobile");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.deviceManagementBlockFactoryResetOnMobile = deviceManagementBlockFactoryResetOnMobile;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to Block the user from doing manual un-enrollment from
     * device management.”</i>
     * 
     * @return property deviceManagementBlockManualUnenroll
     */
    @Property(name="deviceManagementBlockManualUnenroll")
    @JsonIgnore
    public Optional<Boolean> getDeviceManagementBlockManualUnenroll() {
        return Optional.ofNullable(deviceManagementBlockManualUnenroll);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceManagementBlockManualUnenroll} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to Block the user from doing manual un-enrollment from
     * device management.”</i>
     * 
     * @param deviceManagementBlockManualUnenroll
     *            new value of {@code deviceManagementBlockManualUnenroll} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceManagementBlockManualUnenroll} field changed
     */
    public Windows10GeneralConfiguration withDeviceManagementBlockManualUnenroll(Boolean deviceManagementBlockManualUnenroll) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("deviceManagementBlockManualUnenroll");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.deviceManagementBlockManualUnenroll = deviceManagementBlockManualUnenroll;
        return _x;
    }

    /**
     * <i>“Gets or sets a value allowing the device to send diagnostic and usage telemetry
     * data, such as Watson.”</i>
     * 
     * @return property diagnosticsDataSubmissionMode
     */
    @Property(name="diagnosticsDataSubmissionMode")
    @JsonIgnore
    public Optional<DiagnosticDataSubmissionMode> getDiagnosticsDataSubmissionMode() {
        return Optional.ofNullable(diagnosticsDataSubmissionMode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * diagnosticsDataSubmissionMode} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Gets or sets a value allowing the device to send diagnostic and usage telemetry
     * data, such as Watson.”</i>
     * 
     * @param diagnosticsDataSubmissionMode
     *            new value of {@code diagnosticsDataSubmissionMode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code diagnosticsDataSubmissionMode} field changed
     */
    public Windows10GeneralConfiguration withDiagnosticsDataSubmissionMode(DiagnosticDataSubmissionMode diagnosticsDataSubmissionMode) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("diagnosticsDataSubmissionMode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.diagnosticsDataSubmissionMode = diagnosticsDataSubmissionMode;
        return _x;
    }

    /**
     * <i>“List of legacy applications that have GDI DPI Scaling turned off.”</i>
     * 
     * @return property displayAppListWithGdiDPIScalingTurnedOff
     */
    @Property(name="displayAppListWithGdiDPIScalingTurnedOff")
    @JsonIgnore
    public CollectionPage<String> getDisplayAppListWithGdiDPIScalingTurnedOff() {
        return new CollectionPage<String>(contextPath, String.class, this.displayAppListWithGdiDPIScalingTurnedOff, Optional.ofNullable(displayAppListWithGdiDPIScalingTurnedOffNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * displayAppListWithGdiDPIScalingTurnedOff} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“List of legacy applications that have GDI DPI Scaling turned off.”</i>
     * 
     * @param displayAppListWithGdiDPIScalingTurnedOff
     *            new value of {@code displayAppListWithGdiDPIScalingTurnedOff} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayAppListWithGdiDPIScalingTurnedOff} field changed
     */
    public Windows10GeneralConfiguration withDisplayAppListWithGdiDPIScalingTurnedOff(List<String> displayAppListWithGdiDPIScalingTurnedOff) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("displayAppListWithGdiDPIScalingTurnedOff");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.displayAppListWithGdiDPIScalingTurnedOff = displayAppListWithGdiDPIScalingTurnedOff;
        return _x;
    }

    /**
     * <i>“List of legacy applications that have GDI DPI Scaling turned off.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property displayAppListWithGdiDPIScalingTurnedOff
     */
    @Property(name="displayAppListWithGdiDPIScalingTurnedOff")
    @JsonIgnore
    public CollectionPage<String> getDisplayAppListWithGdiDPIScalingTurnedOff(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.displayAppListWithGdiDPIScalingTurnedOff, Optional.ofNullable(displayAppListWithGdiDPIScalingTurnedOffNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“List of legacy applications that have GDI DPI Scaling turned on.”</i>
     * 
     * @return property displayAppListWithGdiDPIScalingTurnedOn
     */
    @Property(name="displayAppListWithGdiDPIScalingTurnedOn")
    @JsonIgnore
    public CollectionPage<String> getDisplayAppListWithGdiDPIScalingTurnedOn() {
        return new CollectionPage<String>(contextPath, String.class, this.displayAppListWithGdiDPIScalingTurnedOn, Optional.ofNullable(displayAppListWithGdiDPIScalingTurnedOnNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * displayAppListWithGdiDPIScalingTurnedOn} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“List of legacy applications that have GDI DPI Scaling turned on.”</i>
     * 
     * @param displayAppListWithGdiDPIScalingTurnedOn
     *            new value of {@code displayAppListWithGdiDPIScalingTurnedOn} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayAppListWithGdiDPIScalingTurnedOn} field changed
     */
    public Windows10GeneralConfiguration withDisplayAppListWithGdiDPIScalingTurnedOn(List<String> displayAppListWithGdiDPIScalingTurnedOn) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("displayAppListWithGdiDPIScalingTurnedOn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.displayAppListWithGdiDPIScalingTurnedOn = displayAppListWithGdiDPIScalingTurnedOn;
        return _x;
    }

    /**
     * <i>“List of legacy applications that have GDI DPI Scaling turned on.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property displayAppListWithGdiDPIScalingTurnedOn
     */
    @Property(name="displayAppListWithGdiDPIScalingTurnedOn")
    @JsonIgnore
    public CollectionPage<String> getDisplayAppListWithGdiDPIScalingTurnedOn(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.displayAppListWithGdiDPIScalingTurnedOn, Optional.ofNullable(displayAppListWithGdiDPIScalingTurnedOnNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Allow users to change Start pages on Edge. Use the EdgeHomepageUrls to specify
     * the Start pages that the user would see by default when they open Edge.”</i>
     * 
     * @return property edgeAllowStartPagesModification
     */
    @Property(name="edgeAllowStartPagesModification")
    @JsonIgnore
    public Optional<Boolean> getEdgeAllowStartPagesModification() {
        return Optional.ofNullable(edgeAllowStartPagesModification);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeAllowStartPagesModification} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Allow users to change Start pages on Edge. Use the EdgeHomepageUrls to specify
     * the Start pages that the user would see by default when they open Edge.”</i>
     * 
     * @param edgeAllowStartPagesModification
     *            new value of {@code edgeAllowStartPagesModification} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeAllowStartPagesModification} field changed
     */
    public Windows10GeneralConfiguration withEdgeAllowStartPagesModification(Boolean edgeAllowStartPagesModification) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeAllowStartPagesModification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeAllowStartPagesModification = edgeAllowStartPagesModification;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to prevent access to about flags on Edge browser.”</i>
     * 
     * @return property edgeBlockAccessToAboutFlags
     */
    @Property(name="edgeBlockAccessToAboutFlags")
    @JsonIgnore
    public Optional<Boolean> getEdgeBlockAccessToAboutFlags() {
        return Optional.ofNullable(edgeBlockAccessToAboutFlags);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeBlockAccessToAboutFlags} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to prevent access to about flags on Edge browser.”</i>
     * 
     * @param edgeBlockAccessToAboutFlags
     *            new value of {@code edgeBlockAccessToAboutFlags} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeBlockAccessToAboutFlags} field changed
     */
    public Windows10GeneralConfiguration withEdgeBlockAccessToAboutFlags(Boolean edgeBlockAccessToAboutFlags) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeBlockAccessToAboutFlags");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeBlockAccessToAboutFlags = edgeBlockAccessToAboutFlags;
        return _x;
    }

    /**
     * <i>“Block the address bar dropdown functionality in Microsoft Edge. Disable this
     * settings to minimize network connections from Microsoft Edge to Microsoft
     * services.”</i>
     * 
     * @return property edgeBlockAddressBarDropdown
     */
    @Property(name="edgeBlockAddressBarDropdown")
    @JsonIgnore
    public Optional<Boolean> getEdgeBlockAddressBarDropdown() {
        return Optional.ofNullable(edgeBlockAddressBarDropdown);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeBlockAddressBarDropdown} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Block the address bar dropdown functionality in Microsoft Edge. Disable this
     * settings to minimize network connections from Microsoft Edge to Microsoft
     * services.”</i>
     * 
     * @param edgeBlockAddressBarDropdown
     *            new value of {@code edgeBlockAddressBarDropdown} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeBlockAddressBarDropdown} field changed
     */
    public Windows10GeneralConfiguration withEdgeBlockAddressBarDropdown(Boolean edgeBlockAddressBarDropdown) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeBlockAddressBarDropdown");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeBlockAddressBarDropdown = edgeBlockAddressBarDropdown;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block auto fill.”</i>
     * 
     * @return property edgeBlockAutofill
     */
    @Property(name="edgeBlockAutofill")
    @JsonIgnore
    public Optional<Boolean> getEdgeBlockAutofill() {
        return Optional.ofNullable(edgeBlockAutofill);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code edgeBlockAutofill
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to block auto fill.”</i>
     * 
     * @param edgeBlockAutofill
     *            new value of {@code edgeBlockAutofill} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeBlockAutofill} field changed
     */
    public Windows10GeneralConfiguration withEdgeBlockAutofill(Boolean edgeBlockAutofill) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeBlockAutofill");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeBlockAutofill = edgeBlockAutofill;
        return _x;
    }

    /**
     * <i>“Block Microsoft compatibility list in Microsoft Edge. This list from Microsoft
     * helps Edge properly display sites with known compatibility issues.”</i>
     * 
     * @return property edgeBlockCompatibilityList
     */
    @Property(name="edgeBlockCompatibilityList")
    @JsonIgnore
    public Optional<Boolean> getEdgeBlockCompatibilityList() {
        return Optional.ofNullable(edgeBlockCompatibilityList);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeBlockCompatibilityList} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Block Microsoft compatibility list in Microsoft Edge. This list from Microsoft
     * helps Edge properly display sites with known compatibility issues.”</i>
     * 
     * @param edgeBlockCompatibilityList
     *            new value of {@code edgeBlockCompatibilityList} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeBlockCompatibilityList} field changed
     */
    public Windows10GeneralConfiguration withEdgeBlockCompatibilityList(Boolean edgeBlockCompatibilityList) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeBlockCompatibilityList");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeBlockCompatibilityList = edgeBlockCompatibilityList;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block developer tools in the Edge browser.”</i>
     * 
     * @return property edgeBlockDeveloperTools
     */
    @Property(name="edgeBlockDeveloperTools")
    @JsonIgnore
    public Optional<Boolean> getEdgeBlockDeveloperTools() {
        return Optional.ofNullable(edgeBlockDeveloperTools);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeBlockDeveloperTools} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block developer tools in the Edge browser.”</i>
     * 
     * @param edgeBlockDeveloperTools
     *            new value of {@code edgeBlockDeveloperTools} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeBlockDeveloperTools} field changed
     */
    public Windows10GeneralConfiguration withEdgeBlockDeveloperTools(Boolean edgeBlockDeveloperTools) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeBlockDeveloperTools");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeBlockDeveloperTools = edgeBlockDeveloperTools;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to Block the user from using the Edge browser.”</i>
     * 
     * @return property edgeBlocked
     */
    @Property(name="edgeBlocked")
    @JsonIgnore
    public Optional<Boolean> getEdgeBlocked() {
        return Optional.ofNullable(edgeBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code edgeBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to Block the user from using the Edge browser.”</i>
     * 
     * @param edgeBlocked
     *            new value of {@code edgeBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeBlocked} field changed
     */
    public Windows10GeneralConfiguration withEdgeBlocked(Boolean edgeBlocked) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeBlocked = edgeBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to Block the user from making changes to Favorites.”</i>
     * 
     * @return property edgeBlockEditFavorites
     */
    @Property(name="edgeBlockEditFavorites")
    @JsonIgnore
    public Optional<Boolean> getEdgeBlockEditFavorites() {
        return Optional.ofNullable(edgeBlockEditFavorites);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeBlockEditFavorites} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to Block the user from making changes to Favorites.”</i>
     * 
     * @param edgeBlockEditFavorites
     *            new value of {@code edgeBlockEditFavorites} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeBlockEditFavorites} field changed
     */
    public Windows10GeneralConfiguration withEdgeBlockEditFavorites(Boolean edgeBlockEditFavorites) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeBlockEditFavorites");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeBlockEditFavorites = edgeBlockEditFavorites;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block extensions in the Edge browser.”</i>
     * 
     * @return property edgeBlockExtensions
     */
    @Property(name="edgeBlockExtensions")
    @JsonIgnore
    public Optional<Boolean> getEdgeBlockExtensions() {
        return Optional.ofNullable(edgeBlockExtensions);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeBlockExtensions} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block extensions in the Edge browser.”</i>
     * 
     * @param edgeBlockExtensions
     *            new value of {@code edgeBlockExtensions} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeBlockExtensions} field changed
     */
    public Windows10GeneralConfiguration withEdgeBlockExtensions(Boolean edgeBlockExtensions) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeBlockExtensions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeBlockExtensions = edgeBlockExtensions;
        return _x;
    }

    /**
     * <i>“Allow or prevent Edge from entering the full screen mode.”</i>
     * 
     * @return property edgeBlockFullScreenMode
     */
    @Property(name="edgeBlockFullScreenMode")
    @JsonIgnore
    public Optional<Boolean> getEdgeBlockFullScreenMode() {
        return Optional.ofNullable(edgeBlockFullScreenMode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeBlockFullScreenMode} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Allow or prevent Edge from entering the full screen mode.”</i>
     * 
     * @param edgeBlockFullScreenMode
     *            new value of {@code edgeBlockFullScreenMode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeBlockFullScreenMode} field changed
     */
    public Windows10GeneralConfiguration withEdgeBlockFullScreenMode(Boolean edgeBlockFullScreenMode) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeBlockFullScreenMode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeBlockFullScreenMode = edgeBlockFullScreenMode;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block InPrivate browsing on corporate networks, in
     * the Edge browser.”</i>
     * 
     * @return property edgeBlockInPrivateBrowsing
     */
    @Property(name="edgeBlockInPrivateBrowsing")
    @JsonIgnore
    public Optional<Boolean> getEdgeBlockInPrivateBrowsing() {
        return Optional.ofNullable(edgeBlockInPrivateBrowsing);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeBlockInPrivateBrowsing} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block InPrivate browsing on corporate networks, in
     * the Edge browser.”</i>
     * 
     * @param edgeBlockInPrivateBrowsing
     *            new value of {@code edgeBlockInPrivateBrowsing} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeBlockInPrivateBrowsing} field changed
     */
    public Windows10GeneralConfiguration withEdgeBlockInPrivateBrowsing(Boolean edgeBlockInPrivateBrowsing) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeBlockInPrivateBrowsing");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeBlockInPrivateBrowsing = edgeBlockInPrivateBrowsing;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to Block the user from using JavaScript.”</i>
     * 
     * @return property edgeBlockJavaScript
     */
    @Property(name="edgeBlockJavaScript")
    @JsonIgnore
    public Optional<Boolean> getEdgeBlockJavaScript() {
        return Optional.ofNullable(edgeBlockJavaScript);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeBlockJavaScript} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to Block the user from using JavaScript.”</i>
     * 
     * @param edgeBlockJavaScript
     *            new value of {@code edgeBlockJavaScript} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeBlockJavaScript} field changed
     */
    public Windows10GeneralConfiguration withEdgeBlockJavaScript(Boolean edgeBlockJavaScript) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeBlockJavaScript");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeBlockJavaScript = edgeBlockJavaScript;
        return _x;
    }

    /**
     * <i>“Block the collection of information by Microsoft for live tile creation when
     * users pin a site to Start from Microsoft Edge.”</i>
     * 
     * @return property edgeBlockLiveTileDataCollection
     */
    @Property(name="edgeBlockLiveTileDataCollection")
    @JsonIgnore
    public Optional<Boolean> getEdgeBlockLiveTileDataCollection() {
        return Optional.ofNullable(edgeBlockLiveTileDataCollection);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeBlockLiveTileDataCollection} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Block the collection of information by Microsoft for live tile creation when
     * users pin a site to Start from Microsoft Edge.”</i>
     * 
     * @param edgeBlockLiveTileDataCollection
     *            new value of {@code edgeBlockLiveTileDataCollection} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeBlockLiveTileDataCollection} field changed
     */
    public Windows10GeneralConfiguration withEdgeBlockLiveTileDataCollection(Boolean edgeBlockLiveTileDataCollection) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeBlockLiveTileDataCollection");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeBlockLiveTileDataCollection = edgeBlockLiveTileDataCollection;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to Block password manager.”</i>
     * 
     * @return property edgeBlockPasswordManager
     */
    @Property(name="edgeBlockPasswordManager")
    @JsonIgnore
    public Optional<Boolean> getEdgeBlockPasswordManager() {
        return Optional.ofNullable(edgeBlockPasswordManager);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeBlockPasswordManager} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to Block password manager.”</i>
     * 
     * @param edgeBlockPasswordManager
     *            new value of {@code edgeBlockPasswordManager} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeBlockPasswordManager} field changed
     */
    public Windows10GeneralConfiguration withEdgeBlockPasswordManager(Boolean edgeBlockPasswordManager) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeBlockPasswordManager");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeBlockPasswordManager = edgeBlockPasswordManager;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block popups.”</i>
     * 
     * @return property edgeBlockPopups
     */
    @Property(name="edgeBlockPopups")
    @JsonIgnore
    public Optional<Boolean> getEdgeBlockPopups() {
        return Optional.ofNullable(edgeBlockPopups);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code edgeBlockPopups}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to block popups.”</i>
     * 
     * @param edgeBlockPopups
     *            new value of {@code edgeBlockPopups} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeBlockPopups} field changed
     */
    public Windows10GeneralConfiguration withEdgeBlockPopups(Boolean edgeBlockPopups) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeBlockPopups");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeBlockPopups = edgeBlockPopups;
        return _x;
    }

    /**
     * <i>“Decide whether Microsoft Edge is prelaunched at Windows startup.”</i>
     * 
     * @return property edgeBlockPrelaunch
     */
    @Property(name="edgeBlockPrelaunch")
    @JsonIgnore
    public Optional<Boolean> getEdgeBlockPrelaunch() {
        return Optional.ofNullable(edgeBlockPrelaunch);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeBlockPrelaunch} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Decide whether Microsoft Edge is prelaunched at Windows startup.”</i>
     * 
     * @param edgeBlockPrelaunch
     *            new value of {@code edgeBlockPrelaunch} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeBlockPrelaunch} field changed
     */
    public Windows10GeneralConfiguration withEdgeBlockPrelaunch(Boolean edgeBlockPrelaunch) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeBlockPrelaunch");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeBlockPrelaunch = edgeBlockPrelaunch;
        return _x;
    }

    /**
     * <i>“Configure Edge to allow or block printing.”</i>
     * 
     * @return property edgeBlockPrinting
     */
    @Property(name="edgeBlockPrinting")
    @JsonIgnore
    public Optional<Boolean> getEdgeBlockPrinting() {
        return Optional.ofNullable(edgeBlockPrinting);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code edgeBlockPrinting
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Configure Edge to allow or block printing.”</i>
     * 
     * @param edgeBlockPrinting
     *            new value of {@code edgeBlockPrinting} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeBlockPrinting} field changed
     */
    public Windows10GeneralConfiguration withEdgeBlockPrinting(Boolean edgeBlockPrinting) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeBlockPrinting");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeBlockPrinting = edgeBlockPrinting;
        return _x;
    }

    /**
     * <i>“Configure Edge to allow browsing history to be saved or to never save browsing
     * history.”</i>
     * 
     * @return property edgeBlockSavingHistory
     */
    @Property(name="edgeBlockSavingHistory")
    @JsonIgnore
    public Optional<Boolean> getEdgeBlockSavingHistory() {
        return Optional.ofNullable(edgeBlockSavingHistory);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeBlockSavingHistory} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Configure Edge to allow browsing history to be saved or to never save browsing
     * history.”</i>
     * 
     * @param edgeBlockSavingHistory
     *            new value of {@code edgeBlockSavingHistory} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeBlockSavingHistory} field changed
     */
    public Windows10GeneralConfiguration withEdgeBlockSavingHistory(Boolean edgeBlockSavingHistory) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeBlockSavingHistory");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeBlockSavingHistory = edgeBlockSavingHistory;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from adding new search engine or
     * changing the default search engine.”</i>
     * 
     * @return property edgeBlockSearchEngineCustomization
     */
    @Property(name="edgeBlockSearchEngineCustomization")
    @JsonIgnore
    public Optional<Boolean> getEdgeBlockSearchEngineCustomization() {
        return Optional.ofNullable(edgeBlockSearchEngineCustomization);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeBlockSearchEngineCustomization} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from adding new search engine or
     * changing the default search engine.”</i>
     * 
     * @param edgeBlockSearchEngineCustomization
     *            new value of {@code edgeBlockSearchEngineCustomization} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeBlockSearchEngineCustomization} field changed
     */
    public Windows10GeneralConfiguration withEdgeBlockSearchEngineCustomization(Boolean edgeBlockSearchEngineCustomization) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeBlockSearchEngineCustomization");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeBlockSearchEngineCustomization = edgeBlockSearchEngineCustomization;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from using the search suggestions in
     * the address bar.”</i>
     * 
     * @return property edgeBlockSearchSuggestions
     */
    @Property(name="edgeBlockSearchSuggestions")
    @JsonIgnore
    public Optional<Boolean> getEdgeBlockSearchSuggestions() {
        return Optional.ofNullable(edgeBlockSearchSuggestions);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeBlockSearchSuggestions} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from using the search suggestions in
     * the address bar.”</i>
     * 
     * @param edgeBlockSearchSuggestions
     *            new value of {@code edgeBlockSearchSuggestions} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeBlockSearchSuggestions} field changed
     */
    public Windows10GeneralConfiguration withEdgeBlockSearchSuggestions(Boolean edgeBlockSearchSuggestions) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeBlockSearchSuggestions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeBlockSearchSuggestions = edgeBlockSearchSuggestions;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to Block the user from sending the do not track header.”</i>
     * 
     * @return property edgeBlockSendingDoNotTrackHeader
     */
    @Property(name="edgeBlockSendingDoNotTrackHeader")
    @JsonIgnore
    public Optional<Boolean> getEdgeBlockSendingDoNotTrackHeader() {
        return Optional.ofNullable(edgeBlockSendingDoNotTrackHeader);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeBlockSendingDoNotTrackHeader} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to Block the user from sending the do not track header.”</i>
     * 
     * @param edgeBlockSendingDoNotTrackHeader
     *            new value of {@code edgeBlockSendingDoNotTrackHeader} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeBlockSendingDoNotTrackHeader} field changed
     */
    public Windows10GeneralConfiguration withEdgeBlockSendingDoNotTrackHeader(Boolean edgeBlockSendingDoNotTrackHeader) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeBlockSendingDoNotTrackHeader");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeBlockSendingDoNotTrackHeader = edgeBlockSendingDoNotTrackHeader;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to switch the intranet traffic from Edge to Internet
     * Explorer. Note: the name of this property is misleading; the property is
     * obsolete, use EdgeSendIntranetTrafficToInternetExplorer instead.”</i>
     * 
     * @return property edgeBlockSendingIntranetTrafficToInternetExplorer
     */
    @Property(name="edgeBlockSendingIntranetTrafficToInternetExplorer")
    @JsonIgnore
    public Optional<Boolean> getEdgeBlockSendingIntranetTrafficToInternetExplorer() {
        return Optional.ofNullable(edgeBlockSendingIntranetTrafficToInternetExplorer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeBlockSendingIntranetTrafficToInternetExplorer} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to switch the intranet traffic from Edge to Internet
     * Explorer. Note: the name of this property is misleading; the property is
     * obsolete, use EdgeSendIntranetTrafficToInternetExplorer instead.”</i>
     * 
     * @param edgeBlockSendingIntranetTrafficToInternetExplorer
     *            new value of {@code edgeBlockSendingIntranetTrafficToInternetExplorer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeBlockSendingIntranetTrafficToInternetExplorer} field changed
     */
    public Windows10GeneralConfiguration withEdgeBlockSendingIntranetTrafficToInternetExplorer(Boolean edgeBlockSendingIntranetTrafficToInternetExplorer) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeBlockSendingIntranetTrafficToInternetExplorer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeBlockSendingIntranetTrafficToInternetExplorer = edgeBlockSendingIntranetTrafficToInternetExplorer;
        return _x;
    }

    /**
     * <i>“Indicates whether the user can sideload extensions.”</i>
     * 
     * @return property edgeBlockSideloadingExtensions
     */
    @Property(name="edgeBlockSideloadingExtensions")
    @JsonIgnore
    public Optional<Boolean> getEdgeBlockSideloadingExtensions() {
        return Optional.ofNullable(edgeBlockSideloadingExtensions);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeBlockSideloadingExtensions} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether the user can sideload extensions.”</i>
     * 
     * @param edgeBlockSideloadingExtensions
     *            new value of {@code edgeBlockSideloadingExtensions} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeBlockSideloadingExtensions} field changed
     */
    public Windows10GeneralConfiguration withEdgeBlockSideloadingExtensions(Boolean edgeBlockSideloadingExtensions) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeBlockSideloadingExtensions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeBlockSideloadingExtensions = edgeBlockSideloadingExtensions;
        return _x;
    }

    /**
     * <i>“Configure whether Edge preloads the new tab page at Windows startup.”</i>
     * 
     * @return property edgeBlockTabPreloading
     */
    @Property(name="edgeBlockTabPreloading")
    @JsonIgnore
    public Optional<Boolean> getEdgeBlockTabPreloading() {
        return Optional.ofNullable(edgeBlockTabPreloading);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeBlockTabPreloading} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Configure whether Edge preloads the new tab page at Windows startup.”</i>
     * 
     * @param edgeBlockTabPreloading
     *            new value of {@code edgeBlockTabPreloading} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeBlockTabPreloading} field changed
     */
    public Windows10GeneralConfiguration withEdgeBlockTabPreloading(Boolean edgeBlockTabPreloading) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeBlockTabPreloading");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeBlockTabPreloading = edgeBlockTabPreloading;
        return _x;
    }

    /**
     * <i>“Configure to load a blank page in Edge instead of the default New tab page and
     * prevent users from changing it.”</i>
     * 
     * @return property edgeBlockWebContentOnNewTabPage
     */
    @Property(name="edgeBlockWebContentOnNewTabPage")
    @JsonIgnore
    public Optional<Boolean> getEdgeBlockWebContentOnNewTabPage() {
        return Optional.ofNullable(edgeBlockWebContentOnNewTabPage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeBlockWebContentOnNewTabPage} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Configure to load a blank page in Edge instead of the default New tab page and
     * prevent users from changing it.”</i>
     * 
     * @param edgeBlockWebContentOnNewTabPage
     *            new value of {@code edgeBlockWebContentOnNewTabPage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeBlockWebContentOnNewTabPage} field changed
     */
    public Windows10GeneralConfiguration withEdgeBlockWebContentOnNewTabPage(Boolean edgeBlockWebContentOnNewTabPage) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeBlockWebContentOnNewTabPage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeBlockWebContentOnNewTabPage = edgeBlockWebContentOnNewTabPage;
        return _x;
    }

    /**
     * <i>“Clear browsing data on exiting Microsoft Edge.”</i>
     * 
     * @return property edgeClearBrowsingDataOnExit
     */
    @Property(name="edgeClearBrowsingDataOnExit")
    @JsonIgnore
    public Optional<Boolean> getEdgeClearBrowsingDataOnExit() {
        return Optional.ofNullable(edgeClearBrowsingDataOnExit);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeClearBrowsingDataOnExit} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Clear browsing data on exiting Microsoft Edge.”</i>
     * 
     * @param edgeClearBrowsingDataOnExit
     *            new value of {@code edgeClearBrowsingDataOnExit} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeClearBrowsingDataOnExit} field changed
     */
    public Windows10GeneralConfiguration withEdgeClearBrowsingDataOnExit(Boolean edgeClearBrowsingDataOnExit) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeClearBrowsingDataOnExit");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeClearBrowsingDataOnExit = edgeClearBrowsingDataOnExit;
        return _x;
    }

    /**
     * <i>“Indicates which cookies to block in the Edge browser.”</i>
     * 
     * @return property edgeCookiePolicy
     */
    @Property(name="edgeCookiePolicy")
    @JsonIgnore
    public Optional<EdgeCookiePolicy> getEdgeCookiePolicy() {
        return Optional.ofNullable(edgeCookiePolicy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code edgeCookiePolicy}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates which cookies to block in the Edge browser.”</i>
     * 
     * @param edgeCookiePolicy
     *            new value of {@code edgeCookiePolicy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeCookiePolicy} field changed
     */
    public Windows10GeneralConfiguration withEdgeCookiePolicy(EdgeCookiePolicy edgeCookiePolicy) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeCookiePolicy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeCookiePolicy = edgeCookiePolicy;
        return _x;
    }

    /**
     * <i>“Block the Microsoft web page that opens on the first use of Microsoft Edge. This
     * policy allows enterprises, like those enrolled in zero emissions configurations,
     * to block this page.”</i>
     * 
     * @return property edgeDisableFirstRunPage
     */
    @Property(name="edgeDisableFirstRunPage")
    @JsonIgnore
    public Optional<Boolean> getEdgeDisableFirstRunPage() {
        return Optional.ofNullable(edgeDisableFirstRunPage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeDisableFirstRunPage} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Block the Microsoft web page that opens on the first use of Microsoft Edge. This
     * policy allows enterprises, like those enrolled in zero emissions configurations,
     * to block this page.”</i>
     * 
     * @param edgeDisableFirstRunPage
     *            new value of {@code edgeDisableFirstRunPage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeDisableFirstRunPage} field changed
     */
    public Windows10GeneralConfiguration withEdgeDisableFirstRunPage(Boolean edgeDisableFirstRunPage) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeDisableFirstRunPage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeDisableFirstRunPage = edgeDisableFirstRunPage;
        return _x;
    }

    /**
     * <i>“Indicates the enterprise mode site list location. Could be a local file, local
     * network or http location.”</i>
     * 
     * @return property edgeEnterpriseModeSiteListLocation
     */
    @Property(name="edgeEnterpriseModeSiteListLocation")
    @JsonIgnore
    public Optional<String> getEdgeEnterpriseModeSiteListLocation() {
        return Optional.ofNullable(edgeEnterpriseModeSiteListLocation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeEnterpriseModeSiteListLocation} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates the enterprise mode site list location. Could be a local file, local
     * network or http location.”</i>
     * 
     * @param edgeEnterpriseModeSiteListLocation
     *            new value of {@code edgeEnterpriseModeSiteListLocation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeEnterpriseModeSiteListLocation} field changed
     */
    public Windows10GeneralConfiguration withEdgeEnterpriseModeSiteListLocation(String edgeEnterpriseModeSiteListLocation) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeEnterpriseModeSiteListLocation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeEnterpriseModeSiteListLocation = edgeEnterpriseModeSiteListLocation;
        return _x;
    }

    /**
     * <i>“Get or set a value that specifies whether to set the favorites bar to always be
     * visible or hidden on any page.”</i>
     * 
     * @return property edgeFavoritesBarVisibility
     */
    @Property(name="edgeFavoritesBarVisibility")
    @JsonIgnore
    public Optional<VisibilitySetting> getEdgeFavoritesBarVisibility() {
        return Optional.ofNullable(edgeFavoritesBarVisibility);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeFavoritesBarVisibility} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Get or set a value that specifies whether to set the favorites bar to always be
     * visible or hidden on any page.”</i>
     * 
     * @param edgeFavoritesBarVisibility
     *            new value of {@code edgeFavoritesBarVisibility} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeFavoritesBarVisibility} field changed
     */
    public Windows10GeneralConfiguration withEdgeFavoritesBarVisibility(VisibilitySetting edgeFavoritesBarVisibility) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeFavoritesBarVisibility");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeFavoritesBarVisibility = edgeFavoritesBarVisibility;
        return _x;
    }

    /**
     * <i>“The location of the favorites list to provision. Could be a local file, local
     * network or http location.”</i>
     * 
     * @return property edgeFavoritesListLocation
     */
    @Property(name="edgeFavoritesListLocation")
    @JsonIgnore
    public Optional<String> getEdgeFavoritesListLocation() {
        return Optional.ofNullable(edgeFavoritesListLocation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeFavoritesListLocation} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The location of the favorites list to provision. Could be a local file, local
     * network or http location.”</i>
     * 
     * @param edgeFavoritesListLocation
     *            new value of {@code edgeFavoritesListLocation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeFavoritesListLocation} field changed
     */
    public Windows10GeneralConfiguration withEdgeFavoritesListLocation(String edgeFavoritesListLocation) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeFavoritesListLocation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeFavoritesListLocation = edgeFavoritesListLocation;
        return _x;
    }

    /**
     * <i>“The first run URL for when Edge browser is opened for the first time.”</i>
     * 
     * @return property edgeFirstRunUrl
     */
    @Property(name="edgeFirstRunUrl")
    @JsonIgnore
    public Optional<String> getEdgeFirstRunUrl() {
        return Optional.ofNullable(edgeFirstRunUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code edgeFirstRunUrl}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The first run URL for when Edge browser is opened for the first time.”</i>
     * 
     * @param edgeFirstRunUrl
     *            new value of {@code edgeFirstRunUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeFirstRunUrl} field changed
     */
    public Windows10GeneralConfiguration withEdgeFirstRunUrl(String edgeFirstRunUrl) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeFirstRunUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeFirstRunUrl = edgeFirstRunUrl;
        return _x;
    }

    /**
     * <i>“Causes the Home button to either hide, load the default Start page, load a New
     * tab page, or a custom URL”</i>
     * 
     * @return property edgeHomeButtonConfiguration
     */
    @Property(name="edgeHomeButtonConfiguration")
    @JsonIgnore
    public Optional<EdgeHomeButtonConfiguration> getEdgeHomeButtonConfiguration() {
        return Optional.ofNullable(edgeHomeButtonConfiguration);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeHomeButtonConfiguration} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Causes the Home button to either hide, load the default Start page, load a New
     * tab page, or a custom URL”</i>
     * 
     * @param edgeHomeButtonConfiguration
     *            new value of {@code edgeHomeButtonConfiguration} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeHomeButtonConfiguration} field changed
     */
    public Windows10GeneralConfiguration withEdgeHomeButtonConfiguration(EdgeHomeButtonConfiguration edgeHomeButtonConfiguration) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeHomeButtonConfiguration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeHomeButtonConfiguration = edgeHomeButtonConfiguration;
        return _x;
    }

    /**
     * <i>“Enable the Home button configuration.”</i>
     * 
     * @return property edgeHomeButtonConfigurationEnabled
     */
    @Property(name="edgeHomeButtonConfigurationEnabled")
    @JsonIgnore
    public Optional<Boolean> getEdgeHomeButtonConfigurationEnabled() {
        return Optional.ofNullable(edgeHomeButtonConfigurationEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeHomeButtonConfigurationEnabled} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Enable the Home button configuration.”</i>
     * 
     * @param edgeHomeButtonConfigurationEnabled
     *            new value of {@code edgeHomeButtonConfigurationEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeHomeButtonConfigurationEnabled} field changed
     */
    public Windows10GeneralConfiguration withEdgeHomeButtonConfigurationEnabled(Boolean edgeHomeButtonConfigurationEnabled) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeHomeButtonConfigurationEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeHomeButtonConfigurationEnabled = edgeHomeButtonConfigurationEnabled;
        return _x;
    }

    /**
     * <i>“The list of URLs for homepages shodwn on MDM-enrolled devices on Edge browser.”</i>
     * 
     * @return property edgeHomepageUrls
     */
    @Property(name="edgeHomepageUrls")
    @JsonIgnore
    public CollectionPage<String> getEdgeHomepageUrls() {
        return new CollectionPage<String>(contextPath, String.class, this.edgeHomepageUrls, Optional.ofNullable(edgeHomepageUrlsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code edgeHomepageUrls}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The list of URLs for homepages shodwn on MDM-enrolled devices on Edge browser.”</i>
     * 
     * @param edgeHomepageUrls
     *            new value of {@code edgeHomepageUrls} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeHomepageUrls} field changed
     */
    public Windows10GeneralConfiguration withEdgeHomepageUrls(List<String> edgeHomepageUrls) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeHomepageUrls");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeHomepageUrls = edgeHomepageUrls;
        return _x;
    }

    /**
     * <i>“The list of URLs for homepages shodwn on MDM-enrolled devices on Edge browser.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property edgeHomepageUrls
     */
    @Property(name="edgeHomepageUrls")
    @JsonIgnore
    public CollectionPage<String> getEdgeHomepageUrls(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.edgeHomepageUrls, Optional.ofNullable(edgeHomepageUrlsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Controls how the Microsoft Edge settings are restricted based on the configure
     * kiosk mode.”</i>
     * 
     * @return property edgeKioskModeRestriction
     */
    @Property(name="edgeKioskModeRestriction")
    @JsonIgnore
    public Optional<EdgeKioskModeRestrictionType> getEdgeKioskModeRestriction() {
        return Optional.ofNullable(edgeKioskModeRestriction);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeKioskModeRestriction} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Controls how the Microsoft Edge settings are restricted based on the configure
     * kiosk mode.”</i>
     * 
     * @param edgeKioskModeRestriction
     *            new value of {@code edgeKioskModeRestriction} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeKioskModeRestriction} field changed
     */
    public Windows10GeneralConfiguration withEdgeKioskModeRestriction(EdgeKioskModeRestrictionType edgeKioskModeRestriction) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeKioskModeRestriction");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeKioskModeRestriction = edgeKioskModeRestriction;
        return _x;
    }

    /**
     * <i>“Specifies the time in minutes from the last user activity before Microsoft Edge
     * kiosk resets.  Valid values are 0-1440. The default is 5. 0 indicates no reset.
     * Valid values 0 to 1440”</i>
     * 
     * @return property edgeKioskResetAfterIdleTimeInMinutes
     */
    @Property(name="edgeKioskResetAfterIdleTimeInMinutes")
    @JsonIgnore
    public Optional<Integer> getEdgeKioskResetAfterIdleTimeInMinutes() {
        return Optional.ofNullable(edgeKioskResetAfterIdleTimeInMinutes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeKioskResetAfterIdleTimeInMinutes} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Specifies the time in minutes from the last user activity before Microsoft Edge
     * kiosk resets.  Valid values are 0-1440. The default is 5. 0 indicates no reset.
     * Valid values 0 to 1440”</i>
     * 
     * @param edgeKioskResetAfterIdleTimeInMinutes
     *            new value of {@code edgeKioskResetAfterIdleTimeInMinutes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeKioskResetAfterIdleTimeInMinutes} field changed
     */
    public Windows10GeneralConfiguration withEdgeKioskResetAfterIdleTimeInMinutes(Integer edgeKioskResetAfterIdleTimeInMinutes) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeKioskResetAfterIdleTimeInMinutes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeKioskResetAfterIdleTimeInMinutes = edgeKioskResetAfterIdleTimeInMinutes;
        return _x;
    }

    /**
     * <i>“Specify the page opened when new tabs are created.”</i>
     * 
     * @return property edgeNewTabPageURL
     */
    @Property(name="edgeNewTabPageURL")
    @JsonIgnore
    public Optional<String> getEdgeNewTabPageURL() {
        return Optional.ofNullable(edgeNewTabPageURL);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code edgeNewTabPageURL
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Specify the page opened when new tabs are created.”</i>
     * 
     * @param edgeNewTabPageURL
     *            new value of {@code edgeNewTabPageURL} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeNewTabPageURL} field changed
     */
    public Windows10GeneralConfiguration withEdgeNewTabPageURL(String edgeNewTabPageURL) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeNewTabPageURL");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeNewTabPageURL = edgeNewTabPageURL;
        return _x;
    }

    /**
     * <i>“Specify what kind of pages are open at start.”</i>
     * 
     * @return property edgeOpensWith
     */
    @Property(name="edgeOpensWith")
    @JsonIgnore
    public Optional<EdgeOpenOptions> getEdgeOpensWith() {
        return Optional.ofNullable(edgeOpensWith);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code edgeOpensWith}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Specify what kind of pages are open at start.”</i>
     * 
     * @param edgeOpensWith
     *            new value of {@code edgeOpensWith} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeOpensWith} field changed
     */
    public Windows10GeneralConfiguration withEdgeOpensWith(EdgeOpenOptions edgeOpensWith) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeOpensWith");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeOpensWith = edgeOpensWith;
        return _x;
    }

    /**
     * <i>“Allow or prevent users from overriding certificate errors.”</i>
     * 
     * @return property edgePreventCertificateErrorOverride
     */
    @Property(name="edgePreventCertificateErrorOverride")
    @JsonIgnore
    public Optional<Boolean> getEdgePreventCertificateErrorOverride() {
        return Optional.ofNullable(edgePreventCertificateErrorOverride);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgePreventCertificateErrorOverride} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Allow or prevent users from overriding certificate errors.”</i>
     * 
     * @param edgePreventCertificateErrorOverride
     *            new value of {@code edgePreventCertificateErrorOverride} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgePreventCertificateErrorOverride} field changed
     */
    public Windows10GeneralConfiguration withEdgePreventCertificateErrorOverride(Boolean edgePreventCertificateErrorOverride) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgePreventCertificateErrorOverride");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgePreventCertificateErrorOverride = edgePreventCertificateErrorOverride;
        return _x;
    }

    /**
     * <i>“Specify the list of package family names of browser extensions that are required
     * and cannot be turned off by the user.”</i>
     * 
     * @return property edgeRequiredExtensionPackageFamilyNames
     */
    @Property(name="edgeRequiredExtensionPackageFamilyNames")
    @JsonIgnore
    public CollectionPage<String> getEdgeRequiredExtensionPackageFamilyNames() {
        return new CollectionPage<String>(contextPath, String.class, this.edgeRequiredExtensionPackageFamilyNames, Optional.ofNullable(edgeRequiredExtensionPackageFamilyNamesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeRequiredExtensionPackageFamilyNames} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Specify the list of package family names of browser extensions that are required
     * and cannot be turned off by the user.”</i>
     * 
     * @param edgeRequiredExtensionPackageFamilyNames
     *            new value of {@code edgeRequiredExtensionPackageFamilyNames} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeRequiredExtensionPackageFamilyNames} field changed
     */
    public Windows10GeneralConfiguration withEdgeRequiredExtensionPackageFamilyNames(List<String> edgeRequiredExtensionPackageFamilyNames) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeRequiredExtensionPackageFamilyNames");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeRequiredExtensionPackageFamilyNames = edgeRequiredExtensionPackageFamilyNames;
        return _x;
    }

    /**
     * <i>“Specify the list of package family names of browser extensions that are required
     * and cannot be turned off by the user.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property edgeRequiredExtensionPackageFamilyNames
     */
    @Property(name="edgeRequiredExtensionPackageFamilyNames")
    @JsonIgnore
    public CollectionPage<String> getEdgeRequiredExtensionPackageFamilyNames(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.edgeRequiredExtensionPackageFamilyNames, Optional.ofNullable(edgeRequiredExtensionPackageFamilyNamesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Indicates whether or not to Require the user to use the smart screen filter.”</i>
     * 
     * @return property edgeRequireSmartScreen
     */
    @Property(name="edgeRequireSmartScreen")
    @JsonIgnore
    public Optional<Boolean> getEdgeRequireSmartScreen() {
        return Optional.ofNullable(edgeRequireSmartScreen);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeRequireSmartScreen} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to Require the user to use the smart screen filter.”</i>
     * 
     * @param edgeRequireSmartScreen
     *            new value of {@code edgeRequireSmartScreen} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeRequireSmartScreen} field changed
     */
    public Windows10GeneralConfiguration withEdgeRequireSmartScreen(Boolean edgeRequireSmartScreen) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeRequireSmartScreen");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeRequireSmartScreen = edgeRequireSmartScreen;
        return _x;
    }

    /**
     * <i>“Allows IT admins to set a default search engine for MDM-Controlled devices.
     * Users can override this and change their default search engine provided the
     * AllowSearchEngineCustomization policy is not set.”</i>
     * 
     * @return property edgeSearchEngine
     */
    @Property(name="edgeSearchEngine")
    @JsonIgnore
    public Optional<EdgeSearchEngineBase> getEdgeSearchEngine() {
        return Optional.ofNullable(edgeSearchEngine);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code edgeSearchEngine}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Allows IT admins to set a default search engine for MDM-Controlled devices.
     * Users can override this and change their default search engine provided the
     * AllowSearchEngineCustomization policy is not set.”</i>
     * 
     * @param edgeSearchEngine
     *            new value of {@code edgeSearchEngine} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeSearchEngine} field changed
     */
    public Windows10GeneralConfiguration withEdgeSearchEngine(EdgeSearchEngineBase edgeSearchEngine) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeSearchEngine");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeSearchEngine = edgeSearchEngine;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to switch the intranet traffic from Edge to Internet
     * Explorer.”</i>
     * 
     * @return property edgeSendIntranetTrafficToInternetExplorer
     */
    @Property(name="edgeSendIntranetTrafficToInternetExplorer")
    @JsonIgnore
    public Optional<Boolean> getEdgeSendIntranetTrafficToInternetExplorer() {
        return Optional.ofNullable(edgeSendIntranetTrafficToInternetExplorer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeSendIntranetTrafficToInternetExplorer} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to switch the intranet traffic from Edge to Internet
     * Explorer.”</i>
     * 
     * @param edgeSendIntranetTrafficToInternetExplorer
     *            new value of {@code edgeSendIntranetTrafficToInternetExplorer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeSendIntranetTrafficToInternetExplorer} field changed
     */
    public Windows10GeneralConfiguration withEdgeSendIntranetTrafficToInternetExplorer(Boolean edgeSendIntranetTrafficToInternetExplorer) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeSendIntranetTrafficToInternetExplorer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeSendIntranetTrafficToInternetExplorer = edgeSendIntranetTrafficToInternetExplorer;
        return _x;
    }

    /**
     * <i>“Controls the message displayed by Edge before switching to Internet Explorer.”</i>
     * 
     * @return property edgeShowMessageWhenOpeningInternetExplorerSites
     */
    @Property(name="edgeShowMessageWhenOpeningInternetExplorerSites")
    @JsonIgnore
    public Optional<InternetExplorerMessageSetting> getEdgeShowMessageWhenOpeningInternetExplorerSites() {
        return Optional.ofNullable(edgeShowMessageWhenOpeningInternetExplorerSites);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeShowMessageWhenOpeningInternetExplorerSites} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Controls the message displayed by Edge before switching to Internet Explorer.”</i>
     * 
     * @param edgeShowMessageWhenOpeningInternetExplorerSites
     *            new value of {@code edgeShowMessageWhenOpeningInternetExplorerSites} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeShowMessageWhenOpeningInternetExplorerSites} field changed
     */
    public Windows10GeneralConfiguration withEdgeShowMessageWhenOpeningInternetExplorerSites(InternetExplorerMessageSetting edgeShowMessageWhenOpeningInternetExplorerSites) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeShowMessageWhenOpeningInternetExplorerSites");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeShowMessageWhenOpeningInternetExplorerSites = edgeShowMessageWhenOpeningInternetExplorerSites;
        return _x;
    }

    /**
     * <i>“Enable favorites sync between Internet Explorer and Microsoft Edge. Additions,
     * deletions, modifications and order changes to favorites are shared between
     * browsers.”</i>
     * 
     * @return property edgeSyncFavoritesWithInternetExplorer
     */
    @Property(name="edgeSyncFavoritesWithInternetExplorer")
    @JsonIgnore
    public Optional<Boolean> getEdgeSyncFavoritesWithInternetExplorer() {
        return Optional.ofNullable(edgeSyncFavoritesWithInternetExplorer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeSyncFavoritesWithInternetExplorer} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Enable favorites sync between Internet Explorer and Microsoft Edge. Additions,
     * deletions, modifications and order changes to favorites are shared between
     * browsers.”</i>
     * 
     * @param edgeSyncFavoritesWithInternetExplorer
     *            new value of {@code edgeSyncFavoritesWithInternetExplorer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeSyncFavoritesWithInternetExplorer} field changed
     */
    public Windows10GeneralConfiguration withEdgeSyncFavoritesWithInternetExplorer(Boolean edgeSyncFavoritesWithInternetExplorer) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeSyncFavoritesWithInternetExplorer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeSyncFavoritesWithInternetExplorer = edgeSyncFavoritesWithInternetExplorer;
        return _x;
    }

    /**
     * <i>“Specifies what type of telemetry data (none, intranet, internet, both) is sent
     * to Microsoft 365 Analytics”</i>
     * 
     * @return property edgeTelemetryForMicrosoft365Analytics
     */
    @Property(name="edgeTelemetryForMicrosoft365Analytics")
    @JsonIgnore
    public Optional<EdgeTelemetryMode> getEdgeTelemetryForMicrosoft365Analytics() {
        return Optional.ofNullable(edgeTelemetryForMicrosoft365Analytics);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * edgeTelemetryForMicrosoft365Analytics} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Specifies what type of telemetry data (none, intranet, internet, both) is sent
     * to Microsoft 365 Analytics”</i>
     * 
     * @param edgeTelemetryForMicrosoft365Analytics
     *            new value of {@code edgeTelemetryForMicrosoft365Analytics} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code edgeTelemetryForMicrosoft365Analytics} field changed
     */
    public Windows10GeneralConfiguration withEdgeTelemetryForMicrosoft365Analytics(EdgeTelemetryMode edgeTelemetryForMicrosoft365Analytics) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("edgeTelemetryForMicrosoft365Analytics");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.edgeTelemetryForMicrosoft365Analytics = edgeTelemetryForMicrosoft365Analytics;
        return _x;
    }

    /**
     * <i>“Allow users with administrative rights to delete all user data and settings
     * using CTRL + Win + R at the device lock screen so that the device can be
     * automatically re-configured and re-enrolled into management.”</i>
     * 
     * @return property enableAutomaticRedeployment
     */
    @Property(name="enableAutomaticRedeployment")
    @JsonIgnore
    public Optional<Boolean> getEnableAutomaticRedeployment() {
        return Optional.ofNullable(enableAutomaticRedeployment);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enableAutomaticRedeployment} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Allow users with administrative rights to delete all user data and settings
     * using CTRL + Win + R at the device lock screen so that the device can be
     * automatically re-configured and re-enrolled into management.”</i>
     * 
     * @param enableAutomaticRedeployment
     *            new value of {@code enableAutomaticRedeployment} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enableAutomaticRedeployment} field changed
     */
    public Windows10GeneralConfiguration withEnableAutomaticRedeployment(Boolean enableAutomaticRedeployment) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("enableAutomaticRedeployment");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.enableAutomaticRedeployment = enableAutomaticRedeployment;
        return _x;
    }

    /**
     * <i>“This setting allows you to specify battery charge level at which Energy Saver is
     * turned on. While on battery, Energy Saver is automatically turned on at (and
     * below) the specified battery charge level. Valid input range (0-100). Valid
     * values 0 to 100”</i>
     * 
     * @return property energySaverOnBatteryThresholdPercentage
     */
    @Property(name="energySaverOnBatteryThresholdPercentage")
    @JsonIgnore
    public Optional<Integer> getEnergySaverOnBatteryThresholdPercentage() {
        return Optional.ofNullable(energySaverOnBatteryThresholdPercentage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * energySaverOnBatteryThresholdPercentage} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“This setting allows you to specify battery charge level at which Energy Saver is
     * turned on. While on battery, Energy Saver is automatically turned on at (and
     * below) the specified battery charge level. Valid input range (0-100). Valid
     * values 0 to 100”</i>
     * 
     * @param energySaverOnBatteryThresholdPercentage
     *            new value of {@code energySaverOnBatteryThresholdPercentage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code energySaverOnBatteryThresholdPercentage} field changed
     */
    public Windows10GeneralConfiguration withEnergySaverOnBatteryThresholdPercentage(Integer energySaverOnBatteryThresholdPercentage) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("energySaverOnBatteryThresholdPercentage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.energySaverOnBatteryThresholdPercentage = energySaverOnBatteryThresholdPercentage;
        return _x;
    }

    /**
     * <i>“This setting allows you to specify battery charge level at which Energy Saver is
     * turned on. While plugged in, Energy Saver is automatically turned on at (and
     * below) the specified battery charge level. Valid input range (0-100). Valid
     * values 0 to 100”</i>
     * 
     * @return property energySaverPluggedInThresholdPercentage
     */
    @Property(name="energySaverPluggedInThresholdPercentage")
    @JsonIgnore
    public Optional<Integer> getEnergySaverPluggedInThresholdPercentage() {
        return Optional.ofNullable(energySaverPluggedInThresholdPercentage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * energySaverPluggedInThresholdPercentage} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“This setting allows you to specify battery charge level at which Energy Saver is
     * turned on. While plugged in, Energy Saver is automatically turned on at (and
     * below) the specified battery charge level. Valid input range (0-100). Valid
     * values 0 to 100”</i>
     * 
     * @param energySaverPluggedInThresholdPercentage
     *            new value of {@code energySaverPluggedInThresholdPercentage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code energySaverPluggedInThresholdPercentage} field changed
     */
    public Windows10GeneralConfiguration withEnergySaverPluggedInThresholdPercentage(Integer energySaverPluggedInThresholdPercentage) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("energySaverPluggedInThresholdPercentage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.energySaverPluggedInThresholdPercentage = energySaverPluggedInThresholdPercentage;
        return _x;
    }

    /**
     * <i>“Endpoint for discovering cloud printers.”</i>
     * 
     * @return property enterpriseCloudPrintDiscoveryEndPoint
     */
    @Property(name="enterpriseCloudPrintDiscoveryEndPoint")
    @JsonIgnore
    public Optional<String> getEnterpriseCloudPrintDiscoveryEndPoint() {
        return Optional.ofNullable(enterpriseCloudPrintDiscoveryEndPoint);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enterpriseCloudPrintDiscoveryEndPoint} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Endpoint for discovering cloud printers.”</i>
     * 
     * @param enterpriseCloudPrintDiscoveryEndPoint
     *            new value of {@code enterpriseCloudPrintDiscoveryEndPoint} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enterpriseCloudPrintDiscoveryEndPoint} field changed
     */
    public Windows10GeneralConfiguration withEnterpriseCloudPrintDiscoveryEndPoint(String enterpriseCloudPrintDiscoveryEndPoint) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("enterpriseCloudPrintDiscoveryEndPoint");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.enterpriseCloudPrintDiscoveryEndPoint = enterpriseCloudPrintDiscoveryEndPoint;
        return _x;
    }

    /**
     * <i>“Maximum number of printers that should be queried from a discovery endpoint.
     * This is a mobile only setting. Valid values 1 to 65535”</i>
     * 
     * @return property enterpriseCloudPrintDiscoveryMaxLimit
     */
    @Property(name="enterpriseCloudPrintDiscoveryMaxLimit")
    @JsonIgnore
    public Optional<Integer> getEnterpriseCloudPrintDiscoveryMaxLimit() {
        return Optional.ofNullable(enterpriseCloudPrintDiscoveryMaxLimit);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enterpriseCloudPrintDiscoveryMaxLimit} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Maximum number of printers that should be queried from a discovery endpoint.
     * This is a mobile only setting. Valid values 1 to 65535”</i>
     * 
     * @param enterpriseCloudPrintDiscoveryMaxLimit
     *            new value of {@code enterpriseCloudPrintDiscoveryMaxLimit} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enterpriseCloudPrintDiscoveryMaxLimit} field changed
     */
    public Windows10GeneralConfiguration withEnterpriseCloudPrintDiscoveryMaxLimit(Integer enterpriseCloudPrintDiscoveryMaxLimit) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("enterpriseCloudPrintDiscoveryMaxLimit");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.enterpriseCloudPrintDiscoveryMaxLimit = enterpriseCloudPrintDiscoveryMaxLimit;
        return _x;
    }

    /**
     * <i>“OAuth resource URI for printer discovery service as configured in Azure portal.”</i>
     * 
     * @return property enterpriseCloudPrintMopriaDiscoveryResourceIdentifier
     */
    @Property(name="enterpriseCloudPrintMopriaDiscoveryResourceIdentifier")
    @JsonIgnore
    public Optional<String> getEnterpriseCloudPrintMopriaDiscoveryResourceIdentifier() {
        return Optional.ofNullable(enterpriseCloudPrintMopriaDiscoveryResourceIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enterpriseCloudPrintMopriaDiscoveryResourceIdentifier} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“OAuth resource URI for printer discovery service as configured in Azure portal.”</i>
     * 
     * @param enterpriseCloudPrintMopriaDiscoveryResourceIdentifier
     *            new value of {@code enterpriseCloudPrintMopriaDiscoveryResourceIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enterpriseCloudPrintMopriaDiscoveryResourceIdentifier} field changed
     */
    public Windows10GeneralConfiguration withEnterpriseCloudPrintMopriaDiscoveryResourceIdentifier(String enterpriseCloudPrintMopriaDiscoveryResourceIdentifier) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("enterpriseCloudPrintMopriaDiscoveryResourceIdentifier");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.enterpriseCloudPrintMopriaDiscoveryResourceIdentifier = enterpriseCloudPrintMopriaDiscoveryResourceIdentifier;
        return _x;
    }

    /**
     * <i>“Authentication endpoint for acquiring OAuth tokens.”</i>
     * 
     * @return property enterpriseCloudPrintOAuthAuthority
     */
    @Property(name="enterpriseCloudPrintOAuthAuthority")
    @JsonIgnore
    public Optional<String> getEnterpriseCloudPrintOAuthAuthority() {
        return Optional.ofNullable(enterpriseCloudPrintOAuthAuthority);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enterpriseCloudPrintOAuthAuthority} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Authentication endpoint for acquiring OAuth tokens.”</i>
     * 
     * @param enterpriseCloudPrintOAuthAuthority
     *            new value of {@code enterpriseCloudPrintOAuthAuthority} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enterpriseCloudPrintOAuthAuthority} field changed
     */
    public Windows10GeneralConfiguration withEnterpriseCloudPrintOAuthAuthority(String enterpriseCloudPrintOAuthAuthority) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("enterpriseCloudPrintOAuthAuthority");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.enterpriseCloudPrintOAuthAuthority = enterpriseCloudPrintOAuthAuthority;
        return _x;
    }

    /**
     * <i>“GUID of a client application authorized to retrieve OAuth tokens from the OAuth
     * Authority.”</i>
     * 
     * @return property enterpriseCloudPrintOAuthClientIdentifier
     */
    @Property(name="enterpriseCloudPrintOAuthClientIdentifier")
    @JsonIgnore
    public Optional<String> getEnterpriseCloudPrintOAuthClientIdentifier() {
        return Optional.ofNullable(enterpriseCloudPrintOAuthClientIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enterpriseCloudPrintOAuthClientIdentifier} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“GUID of a client application authorized to retrieve OAuth tokens from the OAuth
     * Authority.”</i>
     * 
     * @param enterpriseCloudPrintOAuthClientIdentifier
     *            new value of {@code enterpriseCloudPrintOAuthClientIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enterpriseCloudPrintOAuthClientIdentifier} field changed
     */
    public Windows10GeneralConfiguration withEnterpriseCloudPrintOAuthClientIdentifier(String enterpriseCloudPrintOAuthClientIdentifier) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("enterpriseCloudPrintOAuthClientIdentifier");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.enterpriseCloudPrintOAuthClientIdentifier = enterpriseCloudPrintOAuthClientIdentifier;
        return _x;
    }

    /**
     * <i>“OAuth resource URI for print service as configured in the Azure portal.”</i>
     * 
     * @return property enterpriseCloudPrintResourceIdentifier
     */
    @Property(name="enterpriseCloudPrintResourceIdentifier")
    @JsonIgnore
    public Optional<String> getEnterpriseCloudPrintResourceIdentifier() {
        return Optional.ofNullable(enterpriseCloudPrintResourceIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enterpriseCloudPrintResourceIdentifier} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“OAuth resource URI for print service as configured in the Azure portal.”</i>
     * 
     * @param enterpriseCloudPrintResourceIdentifier
     *            new value of {@code enterpriseCloudPrintResourceIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enterpriseCloudPrintResourceIdentifier} field changed
     */
    public Windows10GeneralConfiguration withEnterpriseCloudPrintResourceIdentifier(String enterpriseCloudPrintResourceIdentifier) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("enterpriseCloudPrintResourceIdentifier");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.enterpriseCloudPrintResourceIdentifier = enterpriseCloudPrintResourceIdentifier;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to enable device discovery UX.”</i>
     * 
     * @return property experienceBlockDeviceDiscovery
     */
    @Property(name="experienceBlockDeviceDiscovery")
    @JsonIgnore
    public Optional<Boolean> getExperienceBlockDeviceDiscovery() {
        return Optional.ofNullable(experienceBlockDeviceDiscovery);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * experienceBlockDeviceDiscovery} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to enable device discovery UX.”</i>
     * 
     * @param experienceBlockDeviceDiscovery
     *            new value of {@code experienceBlockDeviceDiscovery} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code experienceBlockDeviceDiscovery} field changed
     */
    public Windows10GeneralConfiguration withExperienceBlockDeviceDiscovery(Boolean experienceBlockDeviceDiscovery) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("experienceBlockDeviceDiscovery");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.experienceBlockDeviceDiscovery = experienceBlockDeviceDiscovery;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow the error dialog from displaying if no SIM
     * card is detected.”</i>
     * 
     * @return property experienceBlockErrorDialogWhenNoSIM
     */
    @Property(name="experienceBlockErrorDialogWhenNoSIM")
    @JsonIgnore
    public Optional<Boolean> getExperienceBlockErrorDialogWhenNoSIM() {
        return Optional.ofNullable(experienceBlockErrorDialogWhenNoSIM);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * experienceBlockErrorDialogWhenNoSIM} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow the error dialog from displaying if no SIM
     * card is detected.”</i>
     * 
     * @param experienceBlockErrorDialogWhenNoSIM
     *            new value of {@code experienceBlockErrorDialogWhenNoSIM} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code experienceBlockErrorDialogWhenNoSIM} field changed
     */
    public Windows10GeneralConfiguration withExperienceBlockErrorDialogWhenNoSIM(Boolean experienceBlockErrorDialogWhenNoSIM) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("experienceBlockErrorDialogWhenNoSIM");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.experienceBlockErrorDialogWhenNoSIM = experienceBlockErrorDialogWhenNoSIM;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to enable task switching on the device.”</i>
     * 
     * @return property experienceBlockTaskSwitcher
     */
    @Property(name="experienceBlockTaskSwitcher")
    @JsonIgnore
    public Optional<Boolean> getExperienceBlockTaskSwitcher() {
        return Optional.ofNullable(experienceBlockTaskSwitcher);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * experienceBlockTaskSwitcher} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to enable task switching on the device.”</i>
     * 
     * @param experienceBlockTaskSwitcher
     *            new value of {@code experienceBlockTaskSwitcher} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code experienceBlockTaskSwitcher} field changed
     */
    public Windows10GeneralConfiguration withExperienceBlockTaskSwitcher(Boolean experienceBlockTaskSwitcher) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("experienceBlockTaskSwitcher");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.experienceBlockTaskSwitcher = experienceBlockTaskSwitcher;
        return _x;
    }

    /**
     * <i>“Allow or prevent the syncing of Microsoft Edge Browser settings. Option for IT
     * admins to prevent syncing across devices, but allow user override.”</i>
     * 
     * @return property experienceDoNotSyncBrowserSettings
     */
    @Property(name="experienceDoNotSyncBrowserSettings")
    @JsonIgnore
    public Optional<BrowserSyncSetting> getExperienceDoNotSyncBrowserSettings() {
        return Optional.ofNullable(experienceDoNotSyncBrowserSettings);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * experienceDoNotSyncBrowserSettings} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Allow or prevent the syncing of Microsoft Edge Browser settings. Option for IT
     * admins to prevent syncing across devices, but allow user override.”</i>
     * 
     * @param experienceDoNotSyncBrowserSettings
     *            new value of {@code experienceDoNotSyncBrowserSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code experienceDoNotSyncBrowserSettings} field changed
     */
    public Windows10GeneralConfiguration withExperienceDoNotSyncBrowserSettings(BrowserSyncSetting experienceDoNotSyncBrowserSettings) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("experienceDoNotSyncBrowserSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.experienceDoNotSyncBrowserSettings = experienceDoNotSyncBrowserSettings;
        return _x;
    }

    /**
     * <i>“Controls if the user can configure search to Find My Files mode, which searches
     * files in secondary hard drives and also outside of the user profile. Find My
     * Files does not allow users to search files or locations to which they do not
     * have access.”</i>
     * 
     * @return property findMyFiles
     */
    @Property(name="findMyFiles")
    @JsonIgnore
    public Optional<Enablement> getFindMyFiles() {
        return Optional.ofNullable(findMyFiles);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code findMyFiles}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Controls if the user can configure search to Find My Files mode, which searches
     * files in secondary hard drives and also outside of the user profile. Find My
     * Files does not allow users to search files or locations to which they do not
     * have access.”</i>
     * 
     * @param findMyFiles
     *            new value of {@code findMyFiles} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code findMyFiles} field changed
     */
    public Windows10GeneralConfiguration withFindMyFiles(Enablement findMyFiles) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("findMyFiles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.findMyFiles = findMyFiles;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block DVR and broadcasting.”</i>
     * 
     * @return property gameDvrBlocked
     */
    @Property(name="gameDvrBlocked")
    @JsonIgnore
    public Optional<Boolean> getGameDvrBlocked() {
        return Optional.ofNullable(gameDvrBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code gameDvrBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to block DVR and broadcasting.”</i>
     * 
     * @param gameDvrBlocked
     *            new value of {@code gameDvrBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code gameDvrBlocked} field changed
     */
    public Windows10GeneralConfiguration withGameDvrBlocked(Boolean gameDvrBlocked) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("gameDvrBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.gameDvrBlocked = gameDvrBlocked;
        return _x;
    }

    /**
     * <i>“Controls the user access to the ink workspace, from the desktop and from above
     * the lock screen.”</i>
     * 
     * @return property inkWorkspaceAccess
     */
    @Property(name="inkWorkspaceAccess")
    @JsonIgnore
    public Optional<InkAccessSetting> getInkWorkspaceAccess() {
        return Optional.ofNullable(inkWorkspaceAccess);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * inkWorkspaceAccess} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Controls the user access to the ink workspace, from the desktop and from above
     * the lock screen.”</i>
     * 
     * @param inkWorkspaceAccess
     *            new value of {@code inkWorkspaceAccess} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code inkWorkspaceAccess} field changed
     */
    public Windows10GeneralConfiguration withInkWorkspaceAccess(InkAccessSetting inkWorkspaceAccess) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("inkWorkspaceAccess");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.inkWorkspaceAccess = inkWorkspaceAccess;
        return _x;
    }

    /**
     * <i>“Controls the user access to the ink workspace, from the desktop and from above
     * the lock screen.”</i>
     * 
     * @return property inkWorkspaceAccessState
     */
    @Property(name="inkWorkspaceAccessState")
    @JsonIgnore
    public Optional<StateManagementSetting> getInkWorkspaceAccessState() {
        return Optional.ofNullable(inkWorkspaceAccessState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * inkWorkspaceAccessState} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Controls the user access to the ink workspace, from the desktop and from above
     * the lock screen.”</i>
     * 
     * @param inkWorkspaceAccessState
     *            new value of {@code inkWorkspaceAccessState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code inkWorkspaceAccessState} field changed
     */
    public Windows10GeneralConfiguration withInkWorkspaceAccessState(StateManagementSetting inkWorkspaceAccessState) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("inkWorkspaceAccessState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.inkWorkspaceAccessState = inkWorkspaceAccessState;
        return _x;
    }

    /**
     * <i>“Specify whether to show recommended app suggestions in the ink workspace.”</i>
     * 
     * @return property inkWorkspaceBlockSuggestedApps
     */
    @Property(name="inkWorkspaceBlockSuggestedApps")
    @JsonIgnore
    public Optional<Boolean> getInkWorkspaceBlockSuggestedApps() {
        return Optional.ofNullable(inkWorkspaceBlockSuggestedApps);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * inkWorkspaceBlockSuggestedApps} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Specify whether to show recommended app suggestions in the ink workspace.”</i>
     * 
     * @param inkWorkspaceBlockSuggestedApps
     *            new value of {@code inkWorkspaceBlockSuggestedApps} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code inkWorkspaceBlockSuggestedApps} field changed
     */
    public Windows10GeneralConfiguration withInkWorkspaceBlockSuggestedApps(Boolean inkWorkspaceBlockSuggestedApps) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("inkWorkspaceBlockSuggestedApps");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.inkWorkspaceBlockSuggestedApps = inkWorkspaceBlockSuggestedApps;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to Block the user from using internet sharing.”</i>
     * 
     * @return property internetSharingBlocked
     */
    @Property(name="internetSharingBlocked")
    @JsonIgnore
    public Optional<Boolean> getInternetSharingBlocked() {
        return Optional.ofNullable(internetSharingBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * internetSharingBlocked} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to Block the user from using internet sharing.”</i>
     * 
     * @param internetSharingBlocked
     *            new value of {@code internetSharingBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code internetSharingBlocked} field changed
     */
    public Windows10GeneralConfiguration withInternetSharingBlocked(Boolean internetSharingBlocked) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("internetSharingBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.internetSharingBlocked = internetSharingBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to Block the user from location services.”</i>
     * 
     * @return property locationServicesBlocked
     */
    @Property(name="locationServicesBlocked")
    @JsonIgnore
    public Optional<Boolean> getLocationServicesBlocked() {
        return Optional.ofNullable(locationServicesBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * locationServicesBlocked} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to Block the user from location services.”</i>
     * 
     * @param locationServicesBlocked
     *            new value of {@code locationServicesBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code locationServicesBlocked} field changed
     */
    public Windows10GeneralConfiguration withLocationServicesBlocked(Boolean locationServicesBlocked) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("locationServicesBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.locationServicesBlocked = locationServicesBlocked;
        return _x;
    }

    /**
     * <i>“This policy setting specifies whether Windows apps can be activated by voice
     * while the system is locked.”</i>
     * 
     * @return property lockScreenActivateAppsWithVoice
     */
    @Property(name="lockScreenActivateAppsWithVoice")
    @JsonIgnore
    public Optional<Enablement> getLockScreenActivateAppsWithVoice() {
        return Optional.ofNullable(lockScreenActivateAppsWithVoice);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lockScreenActivateAppsWithVoice} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“This policy setting specifies whether Windows apps can be activated by voice
     * while the system is locked.”</i>
     * 
     * @param lockScreenActivateAppsWithVoice
     *            new value of {@code lockScreenActivateAppsWithVoice} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lockScreenActivateAppsWithVoice} field changed
     */
    public Windows10GeneralConfiguration withLockScreenActivateAppsWithVoice(Enablement lockScreenActivateAppsWithVoice) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("lockScreenActivateAppsWithVoice");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.lockScreenActivateAppsWithVoice = lockScreenActivateAppsWithVoice;
        return _x;
    }

    /**
     * <i>“Specify whether to show a user-configurable setting to control the screen
     * timeout while on the lock screen of Windows 10 Mobile devices. If this policy is
     * set to Allow, the value set by lockScreenTimeoutInSeconds is ignored.”</i>
     * 
     * @return property lockScreenAllowTimeoutConfiguration
     */
    @Property(name="lockScreenAllowTimeoutConfiguration")
    @JsonIgnore
    public Optional<Boolean> getLockScreenAllowTimeoutConfiguration() {
        return Optional.ofNullable(lockScreenAllowTimeoutConfiguration);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lockScreenAllowTimeoutConfiguration} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Specify whether to show a user-configurable setting to control the screen
     * timeout while on the lock screen of Windows 10 Mobile devices. If this policy is
     * set to Allow, the value set by lockScreenTimeoutInSeconds is ignored.”</i>
     * 
     * @param lockScreenAllowTimeoutConfiguration
     *            new value of {@code lockScreenAllowTimeoutConfiguration} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lockScreenAllowTimeoutConfiguration} field changed
     */
    public Windows10GeneralConfiguration withLockScreenAllowTimeoutConfiguration(Boolean lockScreenAllowTimeoutConfiguration) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("lockScreenAllowTimeoutConfiguration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.lockScreenAllowTimeoutConfiguration = lockScreenAllowTimeoutConfiguration;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block action center notifications over lock screen.”</i>
     * 
     * @return property lockScreenBlockActionCenterNotifications
     */
    @Property(name="lockScreenBlockActionCenterNotifications")
    @JsonIgnore
    public Optional<Boolean> getLockScreenBlockActionCenterNotifications() {
        return Optional.ofNullable(lockScreenBlockActionCenterNotifications);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lockScreenBlockActionCenterNotifications} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block action center notifications over lock screen.”</i>
     * 
     * @param lockScreenBlockActionCenterNotifications
     *            new value of {@code lockScreenBlockActionCenterNotifications} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lockScreenBlockActionCenterNotifications} field changed
     */
    public Windows10GeneralConfiguration withLockScreenBlockActionCenterNotifications(Boolean lockScreenBlockActionCenterNotifications) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("lockScreenBlockActionCenterNotifications");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.lockScreenBlockActionCenterNotifications = lockScreenBlockActionCenterNotifications;
        return _x;
    }

    /**
     * <i>“Indicates whether or not the user can interact with Cortana using speech while
     * the system is locked.”</i>
     * 
     * @return property lockScreenBlockCortana
     */
    @Property(name="lockScreenBlockCortana")
    @JsonIgnore
    public Optional<Boolean> getLockScreenBlockCortana() {
        return Optional.ofNullable(lockScreenBlockCortana);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lockScreenBlockCortana} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not the user can interact with Cortana using speech while
     * the system is locked.”</i>
     * 
     * @param lockScreenBlockCortana
     *            new value of {@code lockScreenBlockCortana} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lockScreenBlockCortana} field changed
     */
    public Windows10GeneralConfiguration withLockScreenBlockCortana(Boolean lockScreenBlockCortana) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("lockScreenBlockCortana");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.lockScreenBlockCortana = lockScreenBlockCortana;
        return _x;
    }

    /**
     * <i>“Indicates whether to allow toast notifications above the device lock screen.”</i>
     * 
     * @return property lockScreenBlockToastNotifications
     */
    @Property(name="lockScreenBlockToastNotifications")
    @JsonIgnore
    public Optional<Boolean> getLockScreenBlockToastNotifications() {
        return Optional.ofNullable(lockScreenBlockToastNotifications);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lockScreenBlockToastNotifications} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether to allow toast notifications above the device lock screen.”</i>
     * 
     * @param lockScreenBlockToastNotifications
     *            new value of {@code lockScreenBlockToastNotifications} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lockScreenBlockToastNotifications} field changed
     */
    public Windows10GeneralConfiguration withLockScreenBlockToastNotifications(Boolean lockScreenBlockToastNotifications) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("lockScreenBlockToastNotifications");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.lockScreenBlockToastNotifications = lockScreenBlockToastNotifications;
        return _x;
    }

    /**
     * <i>“Set the duration (in seconds) from the screen locking to the screen turning off
     * for Windows 10 Mobile devices. Supported values are 11-1800. Valid values 11 to
     * 1800”</i>
     * 
     * @return property lockScreenTimeoutInSeconds
     */
    @Property(name="lockScreenTimeoutInSeconds")
    @JsonIgnore
    public Optional<Integer> getLockScreenTimeoutInSeconds() {
        return Optional.ofNullable(lockScreenTimeoutInSeconds);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lockScreenTimeoutInSeconds} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Set the duration (in seconds) from the screen locking to the screen turning off
     * for Windows 10 Mobile devices. Supported values are 11-1800. Valid values 11 to
     * 1800”</i>
     * 
     * @param lockScreenTimeoutInSeconds
     *            new value of {@code lockScreenTimeoutInSeconds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lockScreenTimeoutInSeconds} field changed
     */
    public Windows10GeneralConfiguration withLockScreenTimeoutInSeconds(Integer lockScreenTimeoutInSeconds) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("lockScreenTimeoutInSeconds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.lockScreenTimeoutInSeconds = lockScreenTimeoutInSeconds;
        return _x;
    }

    /**
     * <i>“Disables the ability to quickly switch between users that are logged on
     * simultaneously without logging off.”</i>
     * 
     * @return property logonBlockFastUserSwitching
     */
    @Property(name="logonBlockFastUserSwitching")
    @JsonIgnore
    public Optional<Boolean> getLogonBlockFastUserSwitching() {
        return Optional.ofNullable(logonBlockFastUserSwitching);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * logonBlockFastUserSwitching} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Disables the ability to quickly switch between users that are logged on
     * simultaneously without logging off.”</i>
     * 
     * @param logonBlockFastUserSwitching
     *            new value of {@code logonBlockFastUserSwitching} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code logonBlockFastUserSwitching} field changed
     */
    public Windows10GeneralConfiguration withLogonBlockFastUserSwitching(Boolean logonBlockFastUserSwitching) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("logonBlockFastUserSwitching");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.logonBlockFastUserSwitching = logonBlockFastUserSwitching;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the MMS send/receive functionality on the
     * device.”</i>
     * 
     * @return property messagingBlockMMS
     */
    @Property(name="messagingBlockMMS")
    @JsonIgnore
    public Optional<Boolean> getMessagingBlockMMS() {
        return Optional.ofNullable(messagingBlockMMS);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code messagingBlockMMS
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to block the MMS send/receive functionality on the
     * device.”</i>
     * 
     * @param messagingBlockMMS
     *            new value of {@code messagingBlockMMS} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code messagingBlockMMS} field changed
     */
    public Windows10GeneralConfiguration withMessagingBlockMMS(Boolean messagingBlockMMS) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("messagingBlockMMS");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.messagingBlockMMS = messagingBlockMMS;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the RCS send/receive functionality on the
     * device.”</i>
     * 
     * @return property messagingBlockRichCommunicationServices
     */
    @Property(name="messagingBlockRichCommunicationServices")
    @JsonIgnore
    public Optional<Boolean> getMessagingBlockRichCommunicationServices() {
        return Optional.ofNullable(messagingBlockRichCommunicationServices);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * messagingBlockRichCommunicationServices} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the RCS send/receive functionality on the
     * device.”</i>
     * 
     * @param messagingBlockRichCommunicationServices
     *            new value of {@code messagingBlockRichCommunicationServices} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code messagingBlockRichCommunicationServices} field changed
     */
    public Windows10GeneralConfiguration withMessagingBlockRichCommunicationServices(Boolean messagingBlockRichCommunicationServices) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("messagingBlockRichCommunicationServices");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.messagingBlockRichCommunicationServices = messagingBlockRichCommunicationServices;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block text message back up and restore and Messaging
     * Everywhere.”</i>
     * 
     * @return property messagingBlockSync
     */
    @Property(name="messagingBlockSync")
    @JsonIgnore
    public Optional<Boolean> getMessagingBlockSync() {
        return Optional.ofNullable(messagingBlockSync);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * messagingBlockSync} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block text message back up and restore and Messaging
     * Everywhere.”</i>
     * 
     * @param messagingBlockSync
     *            new value of {@code messagingBlockSync} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code messagingBlockSync} field changed
     */
    public Windows10GeneralConfiguration withMessagingBlockSync(Boolean messagingBlockSync) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("messagingBlockSync");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.messagingBlockSync = messagingBlockSync;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to Block a Microsoft account.”</i>
     * 
     * @return property microsoftAccountBlocked
     */
    @Property(name="microsoftAccountBlocked")
    @JsonIgnore
    public Optional<Boolean> getMicrosoftAccountBlocked() {
        return Optional.ofNullable(microsoftAccountBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * microsoftAccountBlocked} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to Block a Microsoft account.”</i>
     * 
     * @param microsoftAccountBlocked
     *            new value of {@code microsoftAccountBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code microsoftAccountBlocked} field changed
     */
    public Windows10GeneralConfiguration withMicrosoftAccountBlocked(Boolean microsoftAccountBlocked) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("microsoftAccountBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.microsoftAccountBlocked = microsoftAccountBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to Block Microsoft account settings sync.”</i>
     * 
     * @return property microsoftAccountBlockSettingsSync
     */
    @Property(name="microsoftAccountBlockSettingsSync")
    @JsonIgnore
    public Optional<Boolean> getMicrosoftAccountBlockSettingsSync() {
        return Optional.ofNullable(microsoftAccountBlockSettingsSync);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * microsoftAccountBlockSettingsSync} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to Block Microsoft account settings sync.”</i>
     * 
     * @param microsoftAccountBlockSettingsSync
     *            new value of {@code microsoftAccountBlockSettingsSync} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code microsoftAccountBlockSettingsSync} field changed
     */
    public Windows10GeneralConfiguration withMicrosoftAccountBlockSettingsSync(Boolean microsoftAccountBlockSettingsSync) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("microsoftAccountBlockSettingsSync");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.microsoftAccountBlockSettingsSync = microsoftAccountBlockSettingsSync;
        return _x;
    }

    /**
     * <i>“Controls the Microsoft Account Sign-In Assistant (wlidsvc) NT service.”</i>
     * 
     * @return property microsoftAccountSignInAssistantSettings
     */
    @Property(name="microsoftAccountSignInAssistantSettings")
    @JsonIgnore
    public Optional<SignInAssistantOptions> getMicrosoftAccountSignInAssistantSettings() {
        return Optional.ofNullable(microsoftAccountSignInAssistantSettings);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * microsoftAccountSignInAssistantSettings} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Controls the Microsoft Account Sign-In Assistant (wlidsvc) NT service.”</i>
     * 
     * @param microsoftAccountSignInAssistantSettings
     *            new value of {@code microsoftAccountSignInAssistantSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code microsoftAccountSignInAssistantSettings} field changed
     */
    public Windows10GeneralConfiguration withMicrosoftAccountSignInAssistantSettings(SignInAssistantOptions microsoftAccountSignInAssistantSettings) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("microsoftAccountSignInAssistantSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.microsoftAccountSignInAssistantSettings = microsoftAccountSignInAssistantSettings;
        return _x;
    }

    /**
     * <i>“If set, proxy settings will be applied to all processes and accounts in the
     * device. Otherwise, it will be applied to the user account that’s enrolled into
     * MDM.”</i>
     * 
     * @return property networkProxyApplySettingsDeviceWide
     */
    @Property(name="networkProxyApplySettingsDeviceWide")
    @JsonIgnore
    public Optional<Boolean> getNetworkProxyApplySettingsDeviceWide() {
        return Optional.ofNullable(networkProxyApplySettingsDeviceWide);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * networkProxyApplySettingsDeviceWide} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“If set, proxy settings will be applied to all processes and accounts in the
     * device. Otherwise, it will be applied to the user account that’s enrolled into
     * MDM.”</i>
     * 
     * @param networkProxyApplySettingsDeviceWide
     *            new value of {@code networkProxyApplySettingsDeviceWide} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code networkProxyApplySettingsDeviceWide} field changed
     */
    public Windows10GeneralConfiguration withNetworkProxyApplySettingsDeviceWide(Boolean networkProxyApplySettingsDeviceWide) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("networkProxyApplySettingsDeviceWide");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.networkProxyApplySettingsDeviceWide = networkProxyApplySettingsDeviceWide;
        return _x;
    }

    /**
     * <i>“Address to the proxy auto-config (PAC) script you want to use.”</i>
     * 
     * @return property networkProxyAutomaticConfigurationUrl
     */
    @Property(name="networkProxyAutomaticConfigurationUrl")
    @JsonIgnore
    public Optional<String> getNetworkProxyAutomaticConfigurationUrl() {
        return Optional.ofNullable(networkProxyAutomaticConfigurationUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * networkProxyAutomaticConfigurationUrl} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Address to the proxy auto-config (PAC) script you want to use.”</i>
     * 
     * @param networkProxyAutomaticConfigurationUrl
     *            new value of {@code networkProxyAutomaticConfigurationUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code networkProxyAutomaticConfigurationUrl} field changed
     */
    public Windows10GeneralConfiguration withNetworkProxyAutomaticConfigurationUrl(String networkProxyAutomaticConfigurationUrl) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("networkProxyAutomaticConfigurationUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.networkProxyAutomaticConfigurationUrl = networkProxyAutomaticConfigurationUrl;
        return _x;
    }

    /**
     * <i>“Disable automatic detection of settings. If enabled, the system will try to find
     * the path to a proxy auto-config (PAC) script.”</i>
     * 
     * @return property networkProxyDisableAutoDetect
     */
    @Property(name="networkProxyDisableAutoDetect")
    @JsonIgnore
    public Optional<Boolean> getNetworkProxyDisableAutoDetect() {
        return Optional.ofNullable(networkProxyDisableAutoDetect);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * networkProxyDisableAutoDetect} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Disable automatic detection of settings. If enabled, the system will try to find
     * the path to a proxy auto-config (PAC) script.”</i>
     * 
     * @param networkProxyDisableAutoDetect
     *            new value of {@code networkProxyDisableAutoDetect} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code networkProxyDisableAutoDetect} field changed
     */
    public Windows10GeneralConfiguration withNetworkProxyDisableAutoDetect(Boolean networkProxyDisableAutoDetect) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("networkProxyDisableAutoDetect");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.networkProxyDisableAutoDetect = networkProxyDisableAutoDetect;
        return _x;
    }

    /**
     * <i>“Specifies manual proxy server settings.”</i>
     * 
     * @return property networkProxyServer
     */
    @Property(name="networkProxyServer")
    @JsonIgnore
    public Optional<Windows10NetworkProxyServer> getNetworkProxyServer() {
        return Optional.ofNullable(networkProxyServer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * networkProxyServer} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Specifies manual proxy server settings.”</i>
     * 
     * @param networkProxyServer
     *            new value of {@code networkProxyServer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code networkProxyServer} field changed
     */
    public Windows10GeneralConfiguration withNetworkProxyServer(Windows10NetworkProxyServer networkProxyServer) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("networkProxyServer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.networkProxyServer = networkProxyServer;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to Block the user from using near field communication.”</i>
     * 
     * @return property nfcBlocked
     */
    @Property(name="nfcBlocked")
    @JsonIgnore
    public Optional<Boolean> getNfcBlocked() {
        return Optional.ofNullable(nfcBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code nfcBlocked} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Indicates whether or not to Block the user from using near field communication.”</i>
     * 
     * @param nfcBlocked
     *            new value of {@code nfcBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code nfcBlocked} field changed
     */
    public Windows10GeneralConfiguration withNfcBlocked(Boolean nfcBlocked) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("nfcBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.nfcBlocked = nfcBlocked;
        return _x;
    }

    /**
     * <i>“Gets or sets a value allowing IT admins to prevent apps and features from
     * working with files on OneDrive.”</i>
     * 
     * @return property oneDriveDisableFileSync
     */
    @Property(name="oneDriveDisableFileSync")
    @JsonIgnore
    public Optional<Boolean> getOneDriveDisableFileSync() {
        return Optional.ofNullable(oneDriveDisableFileSync);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * oneDriveDisableFileSync} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Gets or sets a value allowing IT admins to prevent apps and features from
     * working with files on OneDrive.”</i>
     * 
     * @param oneDriveDisableFileSync
     *            new value of {@code oneDriveDisableFileSync} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code oneDriveDisableFileSync} field changed
     */
    public Windows10GeneralConfiguration withOneDriveDisableFileSync(Boolean oneDriveDisableFileSync) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("oneDriveDisableFileSync");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.oneDriveDisableFileSync = oneDriveDisableFileSync;
        return _x;
    }

    /**
     * <i>“Specify whether PINs or passwords such as "1111" or "1234" are allowed. For
     * Windows 10 desktops, it also controls the use of picture passwords.”</i>
     * 
     * @return property passwordBlockSimple
     */
    @Property(name="passwordBlockSimple")
    @JsonIgnore
    public Optional<Boolean> getPasswordBlockSimple() {
        return Optional.ofNullable(passwordBlockSimple);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordBlockSimple} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Specify whether PINs or passwords such as "1111" or "1234" are allowed. For
     * Windows 10 desktops, it also controls the use of picture passwords.”</i>
     * 
     * @param passwordBlockSimple
     *            new value of {@code passwordBlockSimple} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordBlockSimple} field changed
     */
    public Windows10GeneralConfiguration withPasswordBlockSimple(Boolean passwordBlockSimple) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordBlockSimple");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.passwordBlockSimple = passwordBlockSimple;
        return _x;
    }

    /**
     * <i>“The password expiration in days. Valid values 0 to 730”</i>
     * 
     * @return property passwordExpirationDays
     */
    @Property(name="passwordExpirationDays")
    @JsonIgnore
    public Optional<Integer> getPasswordExpirationDays() {
        return Optional.ofNullable(passwordExpirationDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordExpirationDays} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The password expiration in days. Valid values 0 to 730”</i>
     * 
     * @param passwordExpirationDays
     *            new value of {@code passwordExpirationDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordExpirationDays} field changed
     */
    public Windows10GeneralConfiguration withPasswordExpirationDays(Integer passwordExpirationDays) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordExpirationDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.passwordExpirationDays = passwordExpirationDays;
        return _x;
    }

    /**
     * <i>“This security setting determines the period of time (in days) that a password
     * must be used before the user can change it. Valid values 0 to 998”</i>
     * 
     * @return property passwordMinimumAgeInDays
     */
    @Property(name="passwordMinimumAgeInDays")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumAgeInDays() {
        return Optional.ofNullable(passwordMinimumAgeInDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumAgeInDays} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“This security setting determines the period of time (in days) that a password
     * must be used before the user can change it. Valid values 0 to 998”</i>
     * 
     * @param passwordMinimumAgeInDays
     *            new value of {@code passwordMinimumAgeInDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumAgeInDays} field changed
     */
    public Windows10GeneralConfiguration withPasswordMinimumAgeInDays(Integer passwordMinimumAgeInDays) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordMinimumAgeInDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.passwordMinimumAgeInDays = passwordMinimumAgeInDays;
        return _x;
    }

    /**
     * <i>“The number of character sets required in the password.”</i>
     * 
     * @return property passwordMinimumCharacterSetCount
     */
    @Property(name="passwordMinimumCharacterSetCount")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumCharacterSetCount() {
        return Optional.ofNullable(passwordMinimumCharacterSetCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumCharacterSetCount} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The number of character sets required in the password.”</i>
     * 
     * @param passwordMinimumCharacterSetCount
     *            new value of {@code passwordMinimumCharacterSetCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumCharacterSetCount} field changed
     */
    public Windows10GeneralConfiguration withPasswordMinimumCharacterSetCount(Integer passwordMinimumCharacterSetCount) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordMinimumCharacterSetCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.passwordMinimumCharacterSetCount = passwordMinimumCharacterSetCount;
        return _x;
    }

    /**
     * <i>“The minimum password length. Valid values 4 to 16”</i>
     * 
     * @return property passwordMinimumLength
     */
    @Property(name="passwordMinimumLength")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumLength() {
        return Optional.ofNullable(passwordMinimumLength);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumLength} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The minimum password length. Valid values 4 to 16”</i>
     * 
     * @param passwordMinimumLength
     *            new value of {@code passwordMinimumLength} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumLength} field changed
     */
    public Windows10GeneralConfiguration withPasswordMinimumLength(Integer passwordMinimumLength) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordMinimumLength");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.passwordMinimumLength = passwordMinimumLength;
        return _x;
    }

    /**
     * <i>“The minutes of inactivity before the screen times out.”</i>
     * 
     * @return property passwordMinutesOfInactivityBeforeScreenTimeout
     */
    @Property(name="passwordMinutesOfInactivityBeforeScreenTimeout")
    @JsonIgnore
    public Optional<Integer> getPasswordMinutesOfInactivityBeforeScreenTimeout() {
        return Optional.ofNullable(passwordMinutesOfInactivityBeforeScreenTimeout);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinutesOfInactivityBeforeScreenTimeout} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The minutes of inactivity before the screen times out.”</i>
     * 
     * @param passwordMinutesOfInactivityBeforeScreenTimeout
     *            new value of {@code passwordMinutesOfInactivityBeforeScreenTimeout} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinutesOfInactivityBeforeScreenTimeout} field changed
     */
    public Windows10GeneralConfiguration withPasswordMinutesOfInactivityBeforeScreenTimeout(Integer passwordMinutesOfInactivityBeforeScreenTimeout) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordMinutesOfInactivityBeforeScreenTimeout");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.passwordMinutesOfInactivityBeforeScreenTimeout = passwordMinutesOfInactivityBeforeScreenTimeout;
        return _x;
    }

    /**
     * <i>“The number of previous passwords to prevent reuse of. Valid values 0 to 50”</i>
     * 
     * @return property passwordPreviousPasswordBlockCount
     */
    @Property(name="passwordPreviousPasswordBlockCount")
    @JsonIgnore
    public Optional<Integer> getPasswordPreviousPasswordBlockCount() {
        return Optional.ofNullable(passwordPreviousPasswordBlockCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordPreviousPasswordBlockCount} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The number of previous passwords to prevent reuse of. Valid values 0 to 50”</i>
     * 
     * @param passwordPreviousPasswordBlockCount
     *            new value of {@code passwordPreviousPasswordBlockCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordPreviousPasswordBlockCount} field changed
     */
    public Windows10GeneralConfiguration withPasswordPreviousPasswordBlockCount(Integer passwordPreviousPasswordBlockCount) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordPreviousPasswordBlockCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to require the user to have a password.”</i>
     * 
     * @return property passwordRequired
     */
    @Property(name="passwordRequired")
    @JsonIgnore
    public Optional<Boolean> getPasswordRequired() {
        return Optional.ofNullable(passwordRequired);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code passwordRequired}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to require the user to have a password.”</i>
     * 
     * @param passwordRequired
     *            new value of {@code passwordRequired} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordRequired} field changed
     */
    public Windows10GeneralConfiguration withPasswordRequired(Boolean passwordRequired) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.passwordRequired = passwordRequired;
        return _x;
    }

    /**
     * <i>“The required password type.”</i>
     * 
     * @return property passwordRequiredType
     */
    @Property(name="passwordRequiredType")
    @JsonIgnore
    public Optional<RequiredPasswordType> getPasswordRequiredType() {
        return Optional.ofNullable(passwordRequiredType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordRequiredType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The required password type.”</i>
     * 
     * @param passwordRequiredType
     *            new value of {@code passwordRequiredType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordRequiredType} field changed
     */
    public Windows10GeneralConfiguration withPasswordRequiredType(RequiredPasswordType passwordRequiredType) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordRequiredType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.passwordRequiredType = passwordRequiredType;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to require a password upon resuming from an idle state.”</i>
     * 
     * @return property passwordRequireWhenResumeFromIdleState
     */
    @Property(name="passwordRequireWhenResumeFromIdleState")
    @JsonIgnore
    public Optional<Boolean> getPasswordRequireWhenResumeFromIdleState() {
        return Optional.ofNullable(passwordRequireWhenResumeFromIdleState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordRequireWhenResumeFromIdleState} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to require a password upon resuming from an idle state.”</i>
     * 
     * @param passwordRequireWhenResumeFromIdleState
     *            new value of {@code passwordRequireWhenResumeFromIdleState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordRequireWhenResumeFromIdleState} field changed
     */
    public Windows10GeneralConfiguration withPasswordRequireWhenResumeFromIdleState(Boolean passwordRequireWhenResumeFromIdleState) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordRequireWhenResumeFromIdleState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.passwordRequireWhenResumeFromIdleState = passwordRequireWhenResumeFromIdleState;
        return _x;
    }

    /**
     * <i>“The number of sign in failures before factory reset. Valid values 0 to 999”</i>
     * 
     * @return property passwordSignInFailureCountBeforeFactoryReset
     */
    @Property(name="passwordSignInFailureCountBeforeFactoryReset")
    @JsonIgnore
    public Optional<Integer> getPasswordSignInFailureCountBeforeFactoryReset() {
        return Optional.ofNullable(passwordSignInFailureCountBeforeFactoryReset);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordSignInFailureCountBeforeFactoryReset} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The number of sign in failures before factory reset. Valid values 0 to 999”</i>
     * 
     * @param passwordSignInFailureCountBeforeFactoryReset
     *            new value of {@code passwordSignInFailureCountBeforeFactoryReset} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordSignInFailureCountBeforeFactoryReset} field changed
     */
    public Windows10GeneralConfiguration withPasswordSignInFailureCountBeforeFactoryReset(Integer passwordSignInFailureCountBeforeFactoryReset) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordSignInFailureCountBeforeFactoryReset");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.passwordSignInFailureCountBeforeFactoryReset = passwordSignInFailureCountBeforeFactoryReset;
        return _x;
    }

    /**
     * <i>“A http or https Url to a jpg, jpeg or png image that needs to be downloaded and
     * used as the Desktop Image or a file Url to a local image on the file system that
     * needs to used as the Desktop Image.”</i>
     * 
     * @return property personalizationDesktopImageUrl
     */
    @Property(name="personalizationDesktopImageUrl")
    @JsonIgnore
    public Optional<String> getPersonalizationDesktopImageUrl() {
        return Optional.ofNullable(personalizationDesktopImageUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * personalizationDesktopImageUrl} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“A http or https Url to a jpg, jpeg or png image that needs to be downloaded and
     * used as the Desktop Image or a file Url to a local image on the file system that
     * needs to used as the Desktop Image.”</i>
     * 
     * @param personalizationDesktopImageUrl
     *            new value of {@code personalizationDesktopImageUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code personalizationDesktopImageUrl} field changed
     */
    public Windows10GeneralConfiguration withPersonalizationDesktopImageUrl(String personalizationDesktopImageUrl) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("personalizationDesktopImageUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.personalizationDesktopImageUrl = personalizationDesktopImageUrl;
        return _x;
    }

    /**
     * <i>“A http or https Url to a jpg, jpeg or png image that neeeds to be downloaded and
     * used as the Lock Screen Image or a file Url to a local image on the file system
     * that needs to be used as the Lock Screen Image.”</i>
     * 
     * @return property personalizationLockScreenImageUrl
     */
    @Property(name="personalizationLockScreenImageUrl")
    @JsonIgnore
    public Optional<String> getPersonalizationLockScreenImageUrl() {
        return Optional.ofNullable(personalizationLockScreenImageUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * personalizationLockScreenImageUrl} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“A http or https Url to a jpg, jpeg or png image that neeeds to be downloaded and
     * used as the Lock Screen Image or a file Url to a local image on the file system
     * that needs to be used as the Lock Screen Image.”</i>
     * 
     * @param personalizationLockScreenImageUrl
     *            new value of {@code personalizationLockScreenImageUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code personalizationLockScreenImageUrl} field changed
     */
    public Windows10GeneralConfiguration withPersonalizationLockScreenImageUrl(String personalizationLockScreenImageUrl) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("personalizationLockScreenImageUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.personalizationLockScreenImageUrl = personalizationLockScreenImageUrl;
        return _x;
    }

    /**
     * <i>“This setting specifies the action that Windows takes when a user presses the
     * Power button while on battery.”</i>
     * 
     * @return property powerButtonActionOnBattery
     */
    @Property(name="powerButtonActionOnBattery")
    @JsonIgnore
    public Optional<PowerActionType> getPowerButtonActionOnBattery() {
        return Optional.ofNullable(powerButtonActionOnBattery);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * powerButtonActionOnBattery} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“This setting specifies the action that Windows takes when a user presses the
     * Power button while on battery.”</i>
     * 
     * @param powerButtonActionOnBattery
     *            new value of {@code powerButtonActionOnBattery} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code powerButtonActionOnBattery} field changed
     */
    public Windows10GeneralConfiguration withPowerButtonActionOnBattery(PowerActionType powerButtonActionOnBattery) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("powerButtonActionOnBattery");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.powerButtonActionOnBattery = powerButtonActionOnBattery;
        return _x;
    }

    /**
     * <i>“This setting specifies the action that Windows takes when a user presses the
     * Power button while plugged in.”</i>
     * 
     * @return property powerButtonActionPluggedIn
     */
    @Property(name="powerButtonActionPluggedIn")
    @JsonIgnore
    public Optional<PowerActionType> getPowerButtonActionPluggedIn() {
        return Optional.ofNullable(powerButtonActionPluggedIn);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * powerButtonActionPluggedIn} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“This setting specifies the action that Windows takes when a user presses the
     * Power button while plugged in.”</i>
     * 
     * @param powerButtonActionPluggedIn
     *            new value of {@code powerButtonActionPluggedIn} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code powerButtonActionPluggedIn} field changed
     */
    public Windows10GeneralConfiguration withPowerButtonActionPluggedIn(PowerActionType powerButtonActionPluggedIn) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("powerButtonActionPluggedIn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.powerButtonActionPluggedIn = powerButtonActionPluggedIn;
        return _x;
    }

    /**
     * <i>“This setting allows you to turn off hybrid sleep while on battery. If you set
     * this setting to disable, a hiberfile is not generated when the system
     * transitions to sleep (Stand By). If you set this setting to enable or do not
     * configure this policy setting, users control this setting.”</i>
     * 
     * @return property powerHybridSleepOnBattery
     */
    @Property(name="powerHybridSleepOnBattery")
    @JsonIgnore
    public Optional<Enablement> getPowerHybridSleepOnBattery() {
        return Optional.ofNullable(powerHybridSleepOnBattery);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * powerHybridSleepOnBattery} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“This setting allows you to turn off hybrid sleep while on battery. If you set
     * this setting to disable, a hiberfile is not generated when the system
     * transitions to sleep (Stand By). If you set this setting to enable or do not
     * configure this policy setting, users control this setting.”</i>
     * 
     * @param powerHybridSleepOnBattery
     *            new value of {@code powerHybridSleepOnBattery} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code powerHybridSleepOnBattery} field changed
     */
    public Windows10GeneralConfiguration withPowerHybridSleepOnBattery(Enablement powerHybridSleepOnBattery) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("powerHybridSleepOnBattery");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.powerHybridSleepOnBattery = powerHybridSleepOnBattery;
        return _x;
    }

    /**
     * <i>“This setting allows you to turn off hybrid sleep while plugged in. If you set
     * this setting to disable, a hiberfile is not generated when the system
     * transitions to sleep (Stand By). If you set this setting to enable or do not
     * configure this policy setting, users control this setting.”</i>
     * 
     * @return property powerHybridSleepPluggedIn
     */
    @Property(name="powerHybridSleepPluggedIn")
    @JsonIgnore
    public Optional<Enablement> getPowerHybridSleepPluggedIn() {
        return Optional.ofNullable(powerHybridSleepPluggedIn);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * powerHybridSleepPluggedIn} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“This setting allows you to turn off hybrid sleep while plugged in. If you set
     * this setting to disable, a hiberfile is not generated when the system
     * transitions to sleep (Stand By). If you set this setting to enable or do not
     * configure this policy setting, users control this setting.”</i>
     * 
     * @param powerHybridSleepPluggedIn
     *            new value of {@code powerHybridSleepPluggedIn} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code powerHybridSleepPluggedIn} field changed
     */
    public Windows10GeneralConfiguration withPowerHybridSleepPluggedIn(Enablement powerHybridSleepPluggedIn) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("powerHybridSleepPluggedIn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.powerHybridSleepPluggedIn = powerHybridSleepPluggedIn;
        return _x;
    }

    /**
     * <i>“This setting specifies the action that Windows takes when a user closes the lid
     * on a mobile PC while on battery.”</i>
     * 
     * @return property powerLidCloseActionOnBattery
     */
    @Property(name="powerLidCloseActionOnBattery")
    @JsonIgnore
    public Optional<PowerActionType> getPowerLidCloseActionOnBattery() {
        return Optional.ofNullable(powerLidCloseActionOnBattery);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * powerLidCloseActionOnBattery} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“This setting specifies the action that Windows takes when a user closes the lid
     * on a mobile PC while on battery.”</i>
     * 
     * @param powerLidCloseActionOnBattery
     *            new value of {@code powerLidCloseActionOnBattery} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code powerLidCloseActionOnBattery} field changed
     */
    public Windows10GeneralConfiguration withPowerLidCloseActionOnBattery(PowerActionType powerLidCloseActionOnBattery) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("powerLidCloseActionOnBattery");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.powerLidCloseActionOnBattery = powerLidCloseActionOnBattery;
        return _x;
    }

    /**
     * <i>“This setting specifies the action that Windows takes when a user closes the lid
     * on a mobile PC while plugged in.”</i>
     * 
     * @return property powerLidCloseActionPluggedIn
     */
    @Property(name="powerLidCloseActionPluggedIn")
    @JsonIgnore
    public Optional<PowerActionType> getPowerLidCloseActionPluggedIn() {
        return Optional.ofNullable(powerLidCloseActionPluggedIn);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * powerLidCloseActionPluggedIn} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“This setting specifies the action that Windows takes when a user closes the lid
     * on a mobile PC while plugged in.”</i>
     * 
     * @param powerLidCloseActionPluggedIn
     *            new value of {@code powerLidCloseActionPluggedIn} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code powerLidCloseActionPluggedIn} field changed
     */
    public Windows10GeneralConfiguration withPowerLidCloseActionPluggedIn(PowerActionType powerLidCloseActionPluggedIn) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("powerLidCloseActionPluggedIn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.powerLidCloseActionPluggedIn = powerLidCloseActionPluggedIn;
        return _x;
    }

    /**
     * <i>“This setting specifies the action that Windows takes when a user presses the
     * Sleep button while on battery.”</i>
     * 
     * @return property powerSleepButtonActionOnBattery
     */
    @Property(name="powerSleepButtonActionOnBattery")
    @JsonIgnore
    public Optional<PowerActionType> getPowerSleepButtonActionOnBattery() {
        return Optional.ofNullable(powerSleepButtonActionOnBattery);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * powerSleepButtonActionOnBattery} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“This setting specifies the action that Windows takes when a user presses the
     * Sleep button while on battery.”</i>
     * 
     * @param powerSleepButtonActionOnBattery
     *            new value of {@code powerSleepButtonActionOnBattery} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code powerSleepButtonActionOnBattery} field changed
     */
    public Windows10GeneralConfiguration withPowerSleepButtonActionOnBattery(PowerActionType powerSleepButtonActionOnBattery) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("powerSleepButtonActionOnBattery");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.powerSleepButtonActionOnBattery = powerSleepButtonActionOnBattery;
        return _x;
    }

    /**
     * <i>“This setting specifies the action that Windows takes when a user presses the
     * Sleep button while plugged in.”</i>
     * 
     * @return property powerSleepButtonActionPluggedIn
     */
    @Property(name="powerSleepButtonActionPluggedIn")
    @JsonIgnore
    public Optional<PowerActionType> getPowerSleepButtonActionPluggedIn() {
        return Optional.ofNullable(powerSleepButtonActionPluggedIn);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * powerSleepButtonActionPluggedIn} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“This setting specifies the action that Windows takes when a user presses the
     * Sleep button while plugged in.”</i>
     * 
     * @param powerSleepButtonActionPluggedIn
     *            new value of {@code powerSleepButtonActionPluggedIn} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code powerSleepButtonActionPluggedIn} field changed
     */
    public Windows10GeneralConfiguration withPowerSleepButtonActionPluggedIn(PowerActionType powerSleepButtonActionPluggedIn) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("powerSleepButtonActionPluggedIn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.powerSleepButtonActionPluggedIn = powerSleepButtonActionPluggedIn;
        return _x;
    }

    /**
     * <i>“Prevent user installation of additional printers from printers settings.”</i>
     * 
     * @return property printerBlockAddition
     */
    @Property(name="printerBlockAddition")
    @JsonIgnore
    public Optional<Boolean> getPrinterBlockAddition() {
        return Optional.ofNullable(printerBlockAddition);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * printerBlockAddition} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Prevent user installation of additional printers from printers settings.”</i>
     * 
     * @param printerBlockAddition
     *            new value of {@code printerBlockAddition} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code printerBlockAddition} field changed
     */
    public Windows10GeneralConfiguration withPrinterBlockAddition(Boolean printerBlockAddition) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("printerBlockAddition");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.printerBlockAddition = printerBlockAddition;
        return _x;
    }

    /**
     * <i>“Name (network host name) of an installed printer.”</i>
     * 
     * @return property printerDefaultName
     */
    @Property(name="printerDefaultName")
    @JsonIgnore
    public Optional<String> getPrinterDefaultName() {
        return Optional.ofNullable(printerDefaultName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * printerDefaultName} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Name (network host name) of an installed printer.”</i>
     * 
     * @param printerDefaultName
     *            new value of {@code printerDefaultName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code printerDefaultName} field changed
     */
    public Windows10GeneralConfiguration withPrinterDefaultName(String printerDefaultName) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("printerDefaultName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.printerDefaultName = printerDefaultName;
        return _x;
    }

    /**
     * <i>“Automatically provision printers based on their names (network host names).”</i>
     * 
     * @return property printerNames
     */
    @Property(name="printerNames")
    @JsonIgnore
    public CollectionPage<String> getPrinterNames() {
        return new CollectionPage<String>(contextPath, String.class, this.printerNames, Optional.ofNullable(printerNamesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code printerNames}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Automatically provision printers based on their names (network host names).”</i>
     * 
     * @param printerNames
     *            new value of {@code printerNames} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code printerNames} field changed
     */
    public Windows10GeneralConfiguration withPrinterNames(List<String> printerNames) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("printerNames");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.printerNames = printerNames;
        return _x;
    }

    /**
     * <i>“Automatically provision printers based on their names (network host names).”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property printerNames
     */
    @Property(name="printerNames")
    @JsonIgnore
    public CollectionPage<String> getPrinterNames(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.printerNames, Optional.ofNullable(printerNamesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Enables or disables the use of advertising ID. Added in Windows 10, version 1607
     * .”</i>
     * 
     * @return property privacyAdvertisingId
     */
    @Property(name="privacyAdvertisingId")
    @JsonIgnore
    public Optional<StateManagementSetting> getPrivacyAdvertisingId() {
        return Optional.ofNullable(privacyAdvertisingId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * privacyAdvertisingId} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Enables or disables the use of advertising ID. Added in Windows 10, version 1607
     * .”</i>
     * 
     * @param privacyAdvertisingId
     *            new value of {@code privacyAdvertisingId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code privacyAdvertisingId} field changed
     */
    public Windows10GeneralConfiguration withPrivacyAdvertisingId(StateManagementSetting privacyAdvertisingId) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("privacyAdvertisingId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.privacyAdvertisingId = privacyAdvertisingId;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow the automatic acceptance of the pairing and
     * privacy user consent dialog when launching apps.”</i>
     * 
     * @return property privacyAutoAcceptPairingAndConsentPrompts
     */
    @Property(name="privacyAutoAcceptPairingAndConsentPrompts")
    @JsonIgnore
    public Optional<Boolean> getPrivacyAutoAcceptPairingAndConsentPrompts() {
        return Optional.ofNullable(privacyAutoAcceptPairingAndConsentPrompts);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * privacyAutoAcceptPairingAndConsentPrompts} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow the automatic acceptance of the pairing and
     * privacy user consent dialog when launching apps.”</i>
     * 
     * @param privacyAutoAcceptPairingAndConsentPrompts
     *            new value of {@code privacyAutoAcceptPairingAndConsentPrompts} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code privacyAutoAcceptPairingAndConsentPrompts} field changed
     */
    public Windows10GeneralConfiguration withPrivacyAutoAcceptPairingAndConsentPrompts(Boolean privacyAutoAcceptPairingAndConsentPrompts) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("privacyAutoAcceptPairingAndConsentPrompts");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.privacyAutoAcceptPairingAndConsentPrompts = privacyAutoAcceptPairingAndConsentPrompts;
        return _x;
    }

    /**
     * <i>“Blocks the usage of cloud based speech services for Cortana, Dictation, or Store
     * applications.”</i>
     * 
     * @return property privacyBlockActivityFeed
     */
    @Property(name="privacyBlockActivityFeed")
    @JsonIgnore
    public Optional<Boolean> getPrivacyBlockActivityFeed() {
        return Optional.ofNullable(privacyBlockActivityFeed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * privacyBlockActivityFeed} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Blocks the usage of cloud based speech services for Cortana, Dictation, or Store
     * applications.”</i>
     * 
     * @param privacyBlockActivityFeed
     *            new value of {@code privacyBlockActivityFeed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code privacyBlockActivityFeed} field changed
     */
    public Windows10GeneralConfiguration withPrivacyBlockActivityFeed(Boolean privacyBlockActivityFeed) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("privacyBlockActivityFeed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.privacyBlockActivityFeed = privacyBlockActivityFeed;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the usage of cloud based speech services for
     * Cortana, Dictation, or Store applications.”</i>
     * 
     * @return property privacyBlockInputPersonalization
     */
    @Property(name="privacyBlockInputPersonalization")
    @JsonIgnore
    public Optional<Boolean> getPrivacyBlockInputPersonalization() {
        return Optional.ofNullable(privacyBlockInputPersonalization);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * privacyBlockInputPersonalization} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the usage of cloud based speech services for
     * Cortana, Dictation, or Store applications.”</i>
     * 
     * @param privacyBlockInputPersonalization
     *            new value of {@code privacyBlockInputPersonalization} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code privacyBlockInputPersonalization} field changed
     */
    public Windows10GeneralConfiguration withPrivacyBlockInputPersonalization(Boolean privacyBlockInputPersonalization) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("privacyBlockInputPersonalization");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.privacyBlockInputPersonalization = privacyBlockInputPersonalization;
        return _x;
    }

    /**
     * <i>“Blocks the shared experiences/discovery of recently used resources in task
     * switcher etc.”</i>
     * 
     * @return property privacyBlockPublishUserActivities
     */
    @Property(name="privacyBlockPublishUserActivities")
    @JsonIgnore
    public Optional<Boolean> getPrivacyBlockPublishUserActivities() {
        return Optional.ofNullable(privacyBlockPublishUserActivities);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * privacyBlockPublishUserActivities} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Blocks the shared experiences/discovery of recently used resources in task
     * switcher etc.”</i>
     * 
     * @param privacyBlockPublishUserActivities
     *            new value of {@code privacyBlockPublishUserActivities} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code privacyBlockPublishUserActivities} field changed
     */
    public Windows10GeneralConfiguration withPrivacyBlockPublishUserActivities(Boolean privacyBlockPublishUserActivities) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("privacyBlockPublishUserActivities");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.privacyBlockPublishUserActivities = privacyBlockPublishUserActivities;
        return _x;
    }

    /**
     * <i>“This policy prevents the privacy experience from launching during user logon for
     * new and upgraded users.​”</i>
     * 
     * @return property privacyDisableLaunchExperience
     */
    @Property(name="privacyDisableLaunchExperience")
    @JsonIgnore
    public Optional<Boolean> getPrivacyDisableLaunchExperience() {
        return Optional.ofNullable(privacyDisableLaunchExperience);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * privacyDisableLaunchExperience} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“This policy prevents the privacy experience from launching during user logon for
     * new and upgraded users.​”</i>
     * 
     * @param privacyDisableLaunchExperience
     *            new value of {@code privacyDisableLaunchExperience} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code privacyDisableLaunchExperience} field changed
     */
    public Windows10GeneralConfiguration withPrivacyDisableLaunchExperience(Boolean privacyDisableLaunchExperience) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("privacyDisableLaunchExperience");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.privacyDisableLaunchExperience = privacyDisableLaunchExperience;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to Block the user from reset protection mode.”</i>
     * 
     * @return property resetProtectionModeBlocked
     */
    @Property(name="resetProtectionModeBlocked")
    @JsonIgnore
    public Optional<Boolean> getResetProtectionModeBlocked() {
        return Optional.ofNullable(resetProtectionModeBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * resetProtectionModeBlocked} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to Block the user from reset protection mode.”</i>
     * 
     * @param resetProtectionModeBlocked
     *            new value of {@code resetProtectionModeBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code resetProtectionModeBlocked} field changed
     */
    public Windows10GeneralConfiguration withResetProtectionModeBlocked(Boolean resetProtectionModeBlocked) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("resetProtectionModeBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.resetProtectionModeBlocked = resetProtectionModeBlocked;
        return _x;
    }

    /**
     * <i>“Specifies what filter level of safe search is required.”</i>
     * 
     * @return property safeSearchFilter
     */
    @Property(name="safeSearchFilter")
    @JsonIgnore
    public Optional<SafeSearchFilterType> getSafeSearchFilter() {
        return Optional.ofNullable(safeSearchFilter);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code safeSearchFilter}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Specifies what filter level of safe search is required.”</i>
     * 
     * @param safeSearchFilter
     *            new value of {@code safeSearchFilter} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code safeSearchFilter} field changed
     */
    public Windows10GeneralConfiguration withSafeSearchFilter(SafeSearchFilterType safeSearchFilter) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("safeSearchFilter");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.safeSearchFilter = safeSearchFilter;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to Block the user from taking Screenshots.”</i>
     * 
     * @return property screenCaptureBlocked
     */
    @Property(name="screenCaptureBlocked")
    @JsonIgnore
    public Optional<Boolean> getScreenCaptureBlocked() {
        return Optional.ofNullable(screenCaptureBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * screenCaptureBlocked} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to Block the user from taking Screenshots.”</i>
     * 
     * @param screenCaptureBlocked
     *            new value of {@code screenCaptureBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code screenCaptureBlocked} field changed
     */
    public Windows10GeneralConfiguration withScreenCaptureBlocked(Boolean screenCaptureBlocked) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("screenCaptureBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.screenCaptureBlocked = screenCaptureBlocked;
        return _x;
    }

    /**
     * <i>“Specifies if search can use diacritics.”</i>
     * 
     * @return property searchBlockDiacritics
     */
    @Property(name="searchBlockDiacritics")
    @JsonIgnore
    public Optional<Boolean> getSearchBlockDiacritics() {
        return Optional.ofNullable(searchBlockDiacritics);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * searchBlockDiacritics} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Specifies if search can use diacritics.”</i>
     * 
     * @param searchBlockDiacritics
     *            new value of {@code searchBlockDiacritics} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code searchBlockDiacritics} field changed
     */
    public Windows10GeneralConfiguration withSearchBlockDiacritics(Boolean searchBlockDiacritics) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("searchBlockDiacritics");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.searchBlockDiacritics = searchBlockDiacritics;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the web search.”</i>
     * 
     * @return property searchBlockWebResults
     */
    @Property(name="searchBlockWebResults")
    @JsonIgnore
    public Optional<Boolean> getSearchBlockWebResults() {
        return Optional.ofNullable(searchBlockWebResults);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * searchBlockWebResults} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the web search.”</i>
     * 
     * @param searchBlockWebResults
     *            new value of {@code searchBlockWebResults} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code searchBlockWebResults} field changed
     */
    public Windows10GeneralConfiguration withSearchBlockWebResults(Boolean searchBlockWebResults) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("searchBlockWebResults");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.searchBlockWebResults = searchBlockWebResults;
        return _x;
    }

    /**
     * <i>“Specifies whether to use automatic language detection when indexing content and
     * properties.”</i>
     * 
     * @return property searchDisableAutoLanguageDetection
     */
    @Property(name="searchDisableAutoLanguageDetection")
    @JsonIgnore
    public Optional<Boolean> getSearchDisableAutoLanguageDetection() {
        return Optional.ofNullable(searchDisableAutoLanguageDetection);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * searchDisableAutoLanguageDetection} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Specifies whether to use automatic language detection when indexing content and
     * properties.”</i>
     * 
     * @param searchDisableAutoLanguageDetection
     *            new value of {@code searchDisableAutoLanguageDetection} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code searchDisableAutoLanguageDetection} field changed
     */
    public Windows10GeneralConfiguration withSearchDisableAutoLanguageDetection(Boolean searchDisableAutoLanguageDetection) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("searchDisableAutoLanguageDetection");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.searchDisableAutoLanguageDetection = searchDisableAutoLanguageDetection;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to disable the search indexer backoff feature.”</i>
     * 
     * @return property searchDisableIndexerBackoff
     */
    @Property(name="searchDisableIndexerBackoff")
    @JsonIgnore
    public Optional<Boolean> getSearchDisableIndexerBackoff() {
        return Optional.ofNullable(searchDisableIndexerBackoff);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * searchDisableIndexerBackoff} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to disable the search indexer backoff feature.”</i>
     * 
     * @param searchDisableIndexerBackoff
     *            new value of {@code searchDisableIndexerBackoff} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code searchDisableIndexerBackoff} field changed
     */
    public Windows10GeneralConfiguration withSearchDisableIndexerBackoff(Boolean searchDisableIndexerBackoff) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("searchDisableIndexerBackoff");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.searchDisableIndexerBackoff = searchDisableIndexerBackoff;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block indexing of WIP-protected items to prevent
     * them from appearing in search results for Cortana or Explorer.”</i>
     * 
     * @return property searchDisableIndexingEncryptedItems
     */
    @Property(name="searchDisableIndexingEncryptedItems")
    @JsonIgnore
    public Optional<Boolean> getSearchDisableIndexingEncryptedItems() {
        return Optional.ofNullable(searchDisableIndexingEncryptedItems);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * searchDisableIndexingEncryptedItems} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block indexing of WIP-protected items to prevent
     * them from appearing in search results for Cortana or Explorer.”</i>
     * 
     * @param searchDisableIndexingEncryptedItems
     *            new value of {@code searchDisableIndexingEncryptedItems} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code searchDisableIndexingEncryptedItems} field changed
     */
    public Windows10GeneralConfiguration withSearchDisableIndexingEncryptedItems(Boolean searchDisableIndexingEncryptedItems) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("searchDisableIndexingEncryptedItems");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.searchDisableIndexingEncryptedItems = searchDisableIndexingEncryptedItems;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow users to add locations on removable drives to
     * libraries and to be indexed.”</i>
     * 
     * @return property searchDisableIndexingRemovableDrive
     */
    @Property(name="searchDisableIndexingRemovableDrive")
    @JsonIgnore
    public Optional<Boolean> getSearchDisableIndexingRemovableDrive() {
        return Optional.ofNullable(searchDisableIndexingRemovableDrive);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * searchDisableIndexingRemovableDrive} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow users to add locations on removable drives to
     * libraries and to be indexed.”</i>
     * 
     * @param searchDisableIndexingRemovableDrive
     *            new value of {@code searchDisableIndexingRemovableDrive} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code searchDisableIndexingRemovableDrive} field changed
     */
    public Windows10GeneralConfiguration withSearchDisableIndexingRemovableDrive(Boolean searchDisableIndexingRemovableDrive) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("searchDisableIndexingRemovableDrive");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.searchDisableIndexingRemovableDrive = searchDisableIndexingRemovableDrive;
        return _x;
    }

    /**
     * <i>“Specifies if search can use location information.”</i>
     * 
     * @return property searchDisableLocation
     */
    @Property(name="searchDisableLocation")
    @JsonIgnore
    public Optional<Boolean> getSearchDisableLocation() {
        return Optional.ofNullable(searchDisableLocation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * searchDisableLocation} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Specifies if search can use location information.”</i>
     * 
     * @param searchDisableLocation
     *            new value of {@code searchDisableLocation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code searchDisableLocation} field changed
     */
    public Windows10GeneralConfiguration withSearchDisableLocation(Boolean searchDisableLocation) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("searchDisableLocation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.searchDisableLocation = searchDisableLocation;
        return _x;
    }

    /**
     * <i>“Specifies if search can use location information.”</i>
     * 
     * @return property searchDisableUseLocation
     */
    @Property(name="searchDisableUseLocation")
    @JsonIgnore
    public Optional<Boolean> getSearchDisableUseLocation() {
        return Optional.ofNullable(searchDisableUseLocation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * searchDisableUseLocation} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Specifies if search can use location information.”</i>
     * 
     * @param searchDisableUseLocation
     *            new value of {@code searchDisableUseLocation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code searchDisableUseLocation} field changed
     */
    public Windows10GeneralConfiguration withSearchDisableUseLocation(Boolean searchDisableUseLocation) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("searchDisableUseLocation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.searchDisableUseLocation = searchDisableUseLocation;
        return _x;
    }

    /**
     * <i>“Specifies minimum amount of hard drive space on the same drive as the index
     * location before indexing stops.”</i>
     * 
     * @return property searchEnableAutomaticIndexSizeManangement
     */
    @Property(name="searchEnableAutomaticIndexSizeManangement")
    @JsonIgnore
    public Optional<Boolean> getSearchEnableAutomaticIndexSizeManangement() {
        return Optional.ofNullable(searchEnableAutomaticIndexSizeManangement);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * searchEnableAutomaticIndexSizeManangement} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Specifies minimum amount of hard drive space on the same drive as the index
     * location before indexing stops.”</i>
     * 
     * @param searchEnableAutomaticIndexSizeManangement
     *            new value of {@code searchEnableAutomaticIndexSizeManangement} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code searchEnableAutomaticIndexSizeManangement} field changed
     */
    public Windows10GeneralConfiguration withSearchEnableAutomaticIndexSizeManangement(Boolean searchEnableAutomaticIndexSizeManangement) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("searchEnableAutomaticIndexSizeManangement");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.searchEnableAutomaticIndexSizeManangement = searchEnableAutomaticIndexSizeManangement;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block remote queries of this computer’s index.”</i>
     * 
     * @return property searchEnableRemoteQueries
     */
    @Property(name="searchEnableRemoteQueries")
    @JsonIgnore
    public Optional<Boolean> getSearchEnableRemoteQueries() {
        return Optional.ofNullable(searchEnableRemoteQueries);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * searchEnableRemoteQueries} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block remote queries of this computer’s index.”</i>
     * 
     * @param searchEnableRemoteQueries
     *            new value of {@code searchEnableRemoteQueries} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code searchEnableRemoteQueries} field changed
     */
    public Windows10GeneralConfiguration withSearchEnableRemoteQueries(Boolean searchEnableRemoteQueries) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("searchEnableRemoteQueries");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.searchEnableRemoteQueries = searchEnableRemoteQueries;
        return _x;
    }

    /**
     * <i>“Specify whether to allow automatic device encryption during OOBE when the device
     * is Azure AD joined (desktop only).”</i>
     * 
     * @return property securityBlockAzureADJoinedDevicesAutoEncryption
     */
    @Property(name="securityBlockAzureADJoinedDevicesAutoEncryption")
    @JsonIgnore
    public Optional<Boolean> getSecurityBlockAzureADJoinedDevicesAutoEncryption() {
        return Optional.ofNullable(securityBlockAzureADJoinedDevicesAutoEncryption);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * securityBlockAzureADJoinedDevicesAutoEncryption} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Specify whether to allow automatic device encryption during OOBE when the device
     * is Azure AD joined (desktop only).”</i>
     * 
     * @param securityBlockAzureADJoinedDevicesAutoEncryption
     *            new value of {@code securityBlockAzureADJoinedDevicesAutoEncryption} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code securityBlockAzureADJoinedDevicesAutoEncryption} field changed
     */
    public Windows10GeneralConfiguration withSecurityBlockAzureADJoinedDevicesAutoEncryption(Boolean securityBlockAzureADJoinedDevicesAutoEncryption) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("securityBlockAzureADJoinedDevicesAutoEncryption");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.securityBlockAzureADJoinedDevicesAutoEncryption = securityBlockAzureADJoinedDevicesAutoEncryption;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block access to Accounts in Settings app.”</i>
     * 
     * @return property settingsBlockAccountsPage
     */
    @Property(name="settingsBlockAccountsPage")
    @JsonIgnore
    public Optional<Boolean> getSettingsBlockAccountsPage() {
        return Optional.ofNullable(settingsBlockAccountsPage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingsBlockAccountsPage} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block access to Accounts in Settings app.”</i>
     * 
     * @param settingsBlockAccountsPage
     *            new value of {@code settingsBlockAccountsPage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingsBlockAccountsPage} field changed
     */
    public Windows10GeneralConfiguration withSettingsBlockAccountsPage(Boolean settingsBlockAccountsPage) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("settingsBlockAccountsPage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.settingsBlockAccountsPage = settingsBlockAccountsPage;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from installing provisioning packages
     * .”</i>
     * 
     * @return property settingsBlockAddProvisioningPackage
     */
    @Property(name="settingsBlockAddProvisioningPackage")
    @JsonIgnore
    public Optional<Boolean> getSettingsBlockAddProvisioningPackage() {
        return Optional.ofNullable(settingsBlockAddProvisioningPackage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingsBlockAddProvisioningPackage} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from installing provisioning packages
     * .”</i>
     * 
     * @param settingsBlockAddProvisioningPackage
     *            new value of {@code settingsBlockAddProvisioningPackage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingsBlockAddProvisioningPackage} field changed
     */
    public Windows10GeneralConfiguration withSettingsBlockAddProvisioningPackage(Boolean settingsBlockAddProvisioningPackage) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("settingsBlockAddProvisioningPackage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.settingsBlockAddProvisioningPackage = settingsBlockAddProvisioningPackage;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block access to Apps in Settings app.”</i>
     * 
     * @return property settingsBlockAppsPage
     */
    @Property(name="settingsBlockAppsPage")
    @JsonIgnore
    public Optional<Boolean> getSettingsBlockAppsPage() {
        return Optional.ofNullable(settingsBlockAppsPage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingsBlockAppsPage} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block access to Apps in Settings app.”</i>
     * 
     * @param settingsBlockAppsPage
     *            new value of {@code settingsBlockAppsPage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingsBlockAppsPage} field changed
     */
    public Windows10GeneralConfiguration withSettingsBlockAppsPage(Boolean settingsBlockAppsPage) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("settingsBlockAppsPage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.settingsBlockAppsPage = settingsBlockAppsPage;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from changing the language settings.”</i>
     * 
     * @return property settingsBlockChangeLanguage
     */
    @Property(name="settingsBlockChangeLanguage")
    @JsonIgnore
    public Optional<Boolean> getSettingsBlockChangeLanguage() {
        return Optional.ofNullable(settingsBlockChangeLanguage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingsBlockChangeLanguage} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from changing the language settings.”</i>
     * 
     * @param settingsBlockChangeLanguage
     *            new value of {@code settingsBlockChangeLanguage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingsBlockChangeLanguage} field changed
     */
    public Windows10GeneralConfiguration withSettingsBlockChangeLanguage(Boolean settingsBlockChangeLanguage) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("settingsBlockChangeLanguage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.settingsBlockChangeLanguage = settingsBlockChangeLanguage;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from changing power and sleep
     * settings.”</i>
     * 
     * @return property settingsBlockChangePowerSleep
     */
    @Property(name="settingsBlockChangePowerSleep")
    @JsonIgnore
    public Optional<Boolean> getSettingsBlockChangePowerSleep() {
        return Optional.ofNullable(settingsBlockChangePowerSleep);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingsBlockChangePowerSleep} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from changing power and sleep
     * settings.”</i>
     * 
     * @param settingsBlockChangePowerSleep
     *            new value of {@code settingsBlockChangePowerSleep} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingsBlockChangePowerSleep} field changed
     */
    public Windows10GeneralConfiguration withSettingsBlockChangePowerSleep(Boolean settingsBlockChangePowerSleep) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("settingsBlockChangePowerSleep");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.settingsBlockChangePowerSleep = settingsBlockChangePowerSleep;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from changing the region settings.”</i>
     * 
     * @return property settingsBlockChangeRegion
     */
    @Property(name="settingsBlockChangeRegion")
    @JsonIgnore
    public Optional<Boolean> getSettingsBlockChangeRegion() {
        return Optional.ofNullable(settingsBlockChangeRegion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingsBlockChangeRegion} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from changing the region settings.”</i>
     * 
     * @param settingsBlockChangeRegion
     *            new value of {@code settingsBlockChangeRegion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingsBlockChangeRegion} field changed
     */
    public Windows10GeneralConfiguration withSettingsBlockChangeRegion(Boolean settingsBlockChangeRegion) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("settingsBlockChangeRegion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.settingsBlockChangeRegion = settingsBlockChangeRegion;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from changing date and time settings.”</i>
     * 
     * @return property settingsBlockChangeSystemTime
     */
    @Property(name="settingsBlockChangeSystemTime")
    @JsonIgnore
    public Optional<Boolean> getSettingsBlockChangeSystemTime() {
        return Optional.ofNullable(settingsBlockChangeSystemTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingsBlockChangeSystemTime} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from changing date and time settings.”</i>
     * 
     * @param settingsBlockChangeSystemTime
     *            new value of {@code settingsBlockChangeSystemTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingsBlockChangeSystemTime} field changed
     */
    public Windows10GeneralConfiguration withSettingsBlockChangeSystemTime(Boolean settingsBlockChangeSystemTime) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("settingsBlockChangeSystemTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.settingsBlockChangeSystemTime = settingsBlockChangeSystemTime;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block access to Devices in Settings app.”</i>
     * 
     * @return property settingsBlockDevicesPage
     */
    @Property(name="settingsBlockDevicesPage")
    @JsonIgnore
    public Optional<Boolean> getSettingsBlockDevicesPage() {
        return Optional.ofNullable(settingsBlockDevicesPage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingsBlockDevicesPage} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block access to Devices in Settings app.”</i>
     * 
     * @param settingsBlockDevicesPage
     *            new value of {@code settingsBlockDevicesPage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingsBlockDevicesPage} field changed
     */
    public Windows10GeneralConfiguration withSettingsBlockDevicesPage(Boolean settingsBlockDevicesPage) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("settingsBlockDevicesPage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.settingsBlockDevicesPage = settingsBlockDevicesPage;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block access to Ease of Access in Settings app.”</i>
     * 
     * @return property settingsBlockEaseOfAccessPage
     */
    @Property(name="settingsBlockEaseOfAccessPage")
    @JsonIgnore
    public Optional<Boolean> getSettingsBlockEaseOfAccessPage() {
        return Optional.ofNullable(settingsBlockEaseOfAccessPage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingsBlockEaseOfAccessPage} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block access to Ease of Access in Settings app.”</i>
     * 
     * @param settingsBlockEaseOfAccessPage
     *            new value of {@code settingsBlockEaseOfAccessPage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingsBlockEaseOfAccessPage} field changed
     */
    public Windows10GeneralConfiguration withSettingsBlockEaseOfAccessPage(Boolean settingsBlockEaseOfAccessPage) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("settingsBlockEaseOfAccessPage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.settingsBlockEaseOfAccessPage = settingsBlockEaseOfAccessPage;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from editing the device name.”</i>
     * 
     * @return property settingsBlockEditDeviceName
     */
    @Property(name="settingsBlockEditDeviceName")
    @JsonIgnore
    public Optional<Boolean> getSettingsBlockEditDeviceName() {
        return Optional.ofNullable(settingsBlockEditDeviceName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingsBlockEditDeviceName} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from editing the device name.”</i>
     * 
     * @param settingsBlockEditDeviceName
     *            new value of {@code settingsBlockEditDeviceName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingsBlockEditDeviceName} field changed
     */
    public Windows10GeneralConfiguration withSettingsBlockEditDeviceName(Boolean settingsBlockEditDeviceName) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("settingsBlockEditDeviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.settingsBlockEditDeviceName = settingsBlockEditDeviceName;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block access to Gaming in Settings app.”</i>
     * 
     * @return property settingsBlockGamingPage
     */
    @Property(name="settingsBlockGamingPage")
    @JsonIgnore
    public Optional<Boolean> getSettingsBlockGamingPage() {
        return Optional.ofNullable(settingsBlockGamingPage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingsBlockGamingPage} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block access to Gaming in Settings app.”</i>
     * 
     * @param settingsBlockGamingPage
     *            new value of {@code settingsBlockGamingPage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingsBlockGamingPage} field changed
     */
    public Windows10GeneralConfiguration withSettingsBlockGamingPage(Boolean settingsBlockGamingPage) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("settingsBlockGamingPage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.settingsBlockGamingPage = settingsBlockGamingPage;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block access to Network &amp; Internet in Settings app.”</i>
     * 
     * @return property settingsBlockNetworkInternetPage
     */
    @Property(name="settingsBlockNetworkInternetPage")
    @JsonIgnore
    public Optional<Boolean> getSettingsBlockNetworkInternetPage() {
        return Optional.ofNullable(settingsBlockNetworkInternetPage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingsBlockNetworkInternetPage} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block access to Network &amp; Internet in Settings app.”</i>
     * 
     * @param settingsBlockNetworkInternetPage
     *            new value of {@code settingsBlockNetworkInternetPage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingsBlockNetworkInternetPage} field changed
     */
    public Windows10GeneralConfiguration withSettingsBlockNetworkInternetPage(Boolean settingsBlockNetworkInternetPage) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("settingsBlockNetworkInternetPage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.settingsBlockNetworkInternetPage = settingsBlockNetworkInternetPage;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block access to Personalization in Settings app.”</i>
     * 
     * @return property settingsBlockPersonalizationPage
     */
    @Property(name="settingsBlockPersonalizationPage")
    @JsonIgnore
    public Optional<Boolean> getSettingsBlockPersonalizationPage() {
        return Optional.ofNullable(settingsBlockPersonalizationPage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingsBlockPersonalizationPage} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block access to Personalization in Settings app.”</i>
     * 
     * @param settingsBlockPersonalizationPage
     *            new value of {@code settingsBlockPersonalizationPage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingsBlockPersonalizationPage} field changed
     */
    public Windows10GeneralConfiguration withSettingsBlockPersonalizationPage(Boolean settingsBlockPersonalizationPage) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("settingsBlockPersonalizationPage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.settingsBlockPersonalizationPage = settingsBlockPersonalizationPage;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block access to Privacy in Settings app.”</i>
     * 
     * @return property settingsBlockPrivacyPage
     */
    @Property(name="settingsBlockPrivacyPage")
    @JsonIgnore
    public Optional<Boolean> getSettingsBlockPrivacyPage() {
        return Optional.ofNullable(settingsBlockPrivacyPage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingsBlockPrivacyPage} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block access to Privacy in Settings app.”</i>
     * 
     * @param settingsBlockPrivacyPage
     *            new value of {@code settingsBlockPrivacyPage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingsBlockPrivacyPage} field changed
     */
    public Windows10GeneralConfiguration withSettingsBlockPrivacyPage(Boolean settingsBlockPrivacyPage) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("settingsBlockPrivacyPage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.settingsBlockPrivacyPage = settingsBlockPrivacyPage;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the runtime configuration agent from removing
     * provisioning packages.”</i>
     * 
     * @return property settingsBlockRemoveProvisioningPackage
     */
    @Property(name="settingsBlockRemoveProvisioningPackage")
    @JsonIgnore
    public Optional<Boolean> getSettingsBlockRemoveProvisioningPackage() {
        return Optional.ofNullable(settingsBlockRemoveProvisioningPackage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingsBlockRemoveProvisioningPackage} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the runtime configuration agent from removing
     * provisioning packages.”</i>
     * 
     * @param settingsBlockRemoveProvisioningPackage
     *            new value of {@code settingsBlockRemoveProvisioningPackage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingsBlockRemoveProvisioningPackage} field changed
     */
    public Windows10GeneralConfiguration withSettingsBlockRemoveProvisioningPackage(Boolean settingsBlockRemoveProvisioningPackage) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("settingsBlockRemoveProvisioningPackage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.settingsBlockRemoveProvisioningPackage = settingsBlockRemoveProvisioningPackage;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block access to Settings app.”</i>
     * 
     * @return property settingsBlockSettingsApp
     */
    @Property(name="settingsBlockSettingsApp")
    @JsonIgnore
    public Optional<Boolean> getSettingsBlockSettingsApp() {
        return Optional.ofNullable(settingsBlockSettingsApp);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingsBlockSettingsApp} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block access to Settings app.”</i>
     * 
     * @param settingsBlockSettingsApp
     *            new value of {@code settingsBlockSettingsApp} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingsBlockSettingsApp} field changed
     */
    public Windows10GeneralConfiguration withSettingsBlockSettingsApp(Boolean settingsBlockSettingsApp) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("settingsBlockSettingsApp");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.settingsBlockSettingsApp = settingsBlockSettingsApp;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block access to System in Settings app.”</i>
     * 
     * @return property settingsBlockSystemPage
     */
    @Property(name="settingsBlockSystemPage")
    @JsonIgnore
    public Optional<Boolean> getSettingsBlockSystemPage() {
        return Optional.ofNullable(settingsBlockSystemPage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingsBlockSystemPage} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block access to System in Settings app.”</i>
     * 
     * @param settingsBlockSystemPage
     *            new value of {@code settingsBlockSystemPage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingsBlockSystemPage} field changed
     */
    public Windows10GeneralConfiguration withSettingsBlockSystemPage(Boolean settingsBlockSystemPage) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("settingsBlockSystemPage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.settingsBlockSystemPage = settingsBlockSystemPage;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block access to Time &amp; Language in Settings app.”</i>
     * 
     * @return property settingsBlockTimeLanguagePage
     */
    @Property(name="settingsBlockTimeLanguagePage")
    @JsonIgnore
    public Optional<Boolean> getSettingsBlockTimeLanguagePage() {
        return Optional.ofNullable(settingsBlockTimeLanguagePage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingsBlockTimeLanguagePage} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block access to Time &amp; Language in Settings app.”</i>
     * 
     * @param settingsBlockTimeLanguagePage
     *            new value of {@code settingsBlockTimeLanguagePage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingsBlockTimeLanguagePage} field changed
     */
    public Windows10GeneralConfiguration withSettingsBlockTimeLanguagePage(Boolean settingsBlockTimeLanguagePage) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("settingsBlockTimeLanguagePage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.settingsBlockTimeLanguagePage = settingsBlockTimeLanguagePage;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block access to Update &amp; Security in Settings app.”</i>
     * 
     * @return property settingsBlockUpdateSecurityPage
     */
    @Property(name="settingsBlockUpdateSecurityPage")
    @JsonIgnore
    public Optional<Boolean> getSettingsBlockUpdateSecurityPage() {
        return Optional.ofNullable(settingsBlockUpdateSecurityPage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingsBlockUpdateSecurityPage} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block access to Update &amp; Security in Settings app.”</i>
     * 
     * @param settingsBlockUpdateSecurityPage
     *            new value of {@code settingsBlockUpdateSecurityPage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingsBlockUpdateSecurityPage} field changed
     */
    public Windows10GeneralConfiguration withSettingsBlockUpdateSecurityPage(Boolean settingsBlockUpdateSecurityPage) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("settingsBlockUpdateSecurityPage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.settingsBlockUpdateSecurityPage = settingsBlockUpdateSecurityPage;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block multiple users of the same app to share data.”</i>
     * 
     * @return property sharedUserAppDataAllowed
     */
    @Property(name="sharedUserAppDataAllowed")
    @JsonIgnore
    public Optional<Boolean> getSharedUserAppDataAllowed() {
        return Optional.ofNullable(sharedUserAppDataAllowed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * sharedUserAppDataAllowed} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block multiple users of the same app to share data.”</i>
     * 
     * @param sharedUserAppDataAllowed
     *            new value of {@code sharedUserAppDataAllowed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code sharedUserAppDataAllowed} field changed
     */
    public Windows10GeneralConfiguration withSharedUserAppDataAllowed(Boolean sharedUserAppDataAllowed) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("sharedUserAppDataAllowed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.sharedUserAppDataAllowed = sharedUserAppDataAllowed;
        return _x;
    }

    /**
     * <i>“Added in Windows 10, version 1703. Allows IT Admins to control whether users are
     * allowed to install apps from places other than the Store.”</i>
     * 
     * @return property smartScreenAppInstallControl
     */
    @Property(name="smartScreenAppInstallControl")
    @JsonIgnore
    public Optional<AppInstallControlType> getSmartScreenAppInstallControl() {
        return Optional.ofNullable(smartScreenAppInstallControl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * smartScreenAppInstallControl} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Added in Windows 10, version 1703. Allows IT Admins to control whether users are
     * allowed to install apps from places other than the Store.”</i>
     * 
     * @param smartScreenAppInstallControl
     *            new value of {@code smartScreenAppInstallControl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code smartScreenAppInstallControl} field changed
     */
    public Windows10GeneralConfiguration withSmartScreenAppInstallControl(AppInstallControlType smartScreenAppInstallControl) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("smartScreenAppInstallControl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.smartScreenAppInstallControl = smartScreenAppInstallControl;
        return _x;
    }

    /**
     * <i>“Indicates whether or not users can override SmartScreen Filter warnings about
     * potentially malicious websites.”</i>
     * 
     * @return property smartScreenBlockPromptOverride
     */
    @Property(name="smartScreenBlockPromptOverride")
    @JsonIgnore
    public Optional<Boolean> getSmartScreenBlockPromptOverride() {
        return Optional.ofNullable(smartScreenBlockPromptOverride);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * smartScreenBlockPromptOverride} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not users can override SmartScreen Filter warnings about
     * potentially malicious websites.”</i>
     * 
     * @param smartScreenBlockPromptOverride
     *            new value of {@code smartScreenBlockPromptOverride} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code smartScreenBlockPromptOverride} field changed
     */
    public Windows10GeneralConfiguration withSmartScreenBlockPromptOverride(Boolean smartScreenBlockPromptOverride) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("smartScreenBlockPromptOverride");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.smartScreenBlockPromptOverride = smartScreenBlockPromptOverride;
        return _x;
    }

    /**
     * <i>“Indicates whether or not users can override the SmartScreen Filter warnings
     * about downloading unverified files”</i>
     * 
     * @return property smartScreenBlockPromptOverrideForFiles
     */
    @Property(name="smartScreenBlockPromptOverrideForFiles")
    @JsonIgnore
    public Optional<Boolean> getSmartScreenBlockPromptOverrideForFiles() {
        return Optional.ofNullable(smartScreenBlockPromptOverrideForFiles);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * smartScreenBlockPromptOverrideForFiles} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not users can override the SmartScreen Filter warnings
     * about downloading unverified files”</i>
     * 
     * @param smartScreenBlockPromptOverrideForFiles
     *            new value of {@code smartScreenBlockPromptOverrideForFiles} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code smartScreenBlockPromptOverrideForFiles} field changed
     */
    public Windows10GeneralConfiguration withSmartScreenBlockPromptOverrideForFiles(Boolean smartScreenBlockPromptOverrideForFiles) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("smartScreenBlockPromptOverrideForFiles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.smartScreenBlockPromptOverrideForFiles = smartScreenBlockPromptOverrideForFiles;
        return _x;
    }

    /**
     * <i>“This property will be deprecated in July 2019 and will be replaced by property
     * SmartScreenAppInstallControl. Allows IT Admins to control whether users are
     * allowed to install apps from places other than the Store.”</i>
     * 
     * @return property smartScreenEnableAppInstallControl
     */
    @Property(name="smartScreenEnableAppInstallControl")
    @JsonIgnore
    public Optional<Boolean> getSmartScreenEnableAppInstallControl() {
        return Optional.ofNullable(smartScreenEnableAppInstallControl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * smartScreenEnableAppInstallControl} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“This property will be deprecated in July 2019 and will be replaced by property
     * SmartScreenAppInstallControl. Allows IT Admins to control whether users are
     * allowed to install apps from places other than the Store.”</i>
     * 
     * @param smartScreenEnableAppInstallControl
     *            new value of {@code smartScreenEnableAppInstallControl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code smartScreenEnableAppInstallControl} field changed
     */
    public Windows10GeneralConfiguration withSmartScreenEnableAppInstallControl(Boolean smartScreenEnableAppInstallControl) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("smartScreenEnableAppInstallControl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.smartScreenEnableAppInstallControl = smartScreenEnableAppInstallControl;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from unpinning apps from taskbar.”</i>
     * 
     * @return property startBlockUnpinningAppsFromTaskbar
     */
    @Property(name="startBlockUnpinningAppsFromTaskbar")
    @JsonIgnore
    public Optional<Boolean> getStartBlockUnpinningAppsFromTaskbar() {
        return Optional.ofNullable(startBlockUnpinningAppsFromTaskbar);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startBlockUnpinningAppsFromTaskbar} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from unpinning apps from taskbar.”</i>
     * 
     * @param startBlockUnpinningAppsFromTaskbar
     *            new value of {@code startBlockUnpinningAppsFromTaskbar} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startBlockUnpinningAppsFromTaskbar} field changed
     */
    public Windows10GeneralConfiguration withStartBlockUnpinningAppsFromTaskbar(Boolean startBlockUnpinningAppsFromTaskbar) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("startBlockUnpinningAppsFromTaskbar");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.startBlockUnpinningAppsFromTaskbar = startBlockUnpinningAppsFromTaskbar;
        return _x;
    }

    /**
     * <i>“Setting the value of this collapses the app list, removes the app list entirely,
     * or disables the corresponding toggle in the Settings app.”</i>
     * 
     * @return property startMenuAppListVisibility
     */
    @Property(name="startMenuAppListVisibility")
    @JsonIgnore
    public Optional<WindowsStartMenuAppListVisibilityType> getStartMenuAppListVisibility() {
        return Optional.ofNullable(startMenuAppListVisibility);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startMenuAppListVisibility} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Setting the value of this collapses the app list, removes the app list entirely,
     * or disables the corresponding toggle in the Settings app.”</i>
     * 
     * @param startMenuAppListVisibility
     *            new value of {@code startMenuAppListVisibility} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startMenuAppListVisibility} field changed
     */
    public Windows10GeneralConfiguration withStartMenuAppListVisibility(WindowsStartMenuAppListVisibilityType startMenuAppListVisibility) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("startMenuAppListVisibility");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.startMenuAppListVisibility = startMenuAppListVisibility;
        return _x;
    }

    /**
     * <i>“Enabling this policy hides the change account setting from appearing in the user
     * tile in the start menu.”</i>
     * 
     * @return property startMenuHideChangeAccountSettings
     */
    @Property(name="startMenuHideChangeAccountSettings")
    @JsonIgnore
    public Optional<Boolean> getStartMenuHideChangeAccountSettings() {
        return Optional.ofNullable(startMenuHideChangeAccountSettings);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startMenuHideChangeAccountSettings} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Enabling this policy hides the change account setting from appearing in the user
     * tile in the start menu.”</i>
     * 
     * @param startMenuHideChangeAccountSettings
     *            new value of {@code startMenuHideChangeAccountSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startMenuHideChangeAccountSettings} field changed
     */
    public Windows10GeneralConfiguration withStartMenuHideChangeAccountSettings(Boolean startMenuHideChangeAccountSettings) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("startMenuHideChangeAccountSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.startMenuHideChangeAccountSettings = startMenuHideChangeAccountSettings;
        return _x;
    }

    /**
     * <i>“Enabling this policy hides the most used apps from appearing on the start menu
     * and disables the corresponding toggle in the Settings app.”</i>
     * 
     * @return property startMenuHideFrequentlyUsedApps
     */
    @Property(name="startMenuHideFrequentlyUsedApps")
    @JsonIgnore
    public Optional<Boolean> getStartMenuHideFrequentlyUsedApps() {
        return Optional.ofNullable(startMenuHideFrequentlyUsedApps);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startMenuHideFrequentlyUsedApps} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Enabling this policy hides the most used apps from appearing on the start menu
     * and disables the corresponding toggle in the Settings app.”</i>
     * 
     * @param startMenuHideFrequentlyUsedApps
     *            new value of {@code startMenuHideFrequentlyUsedApps} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startMenuHideFrequentlyUsedApps} field changed
     */
    public Windows10GeneralConfiguration withStartMenuHideFrequentlyUsedApps(Boolean startMenuHideFrequentlyUsedApps) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("startMenuHideFrequentlyUsedApps");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.startMenuHideFrequentlyUsedApps = startMenuHideFrequentlyUsedApps;
        return _x;
    }

    /**
     * <i>“Enabling this policy hides hibernate from appearing in the power button in the
     * start menu.”</i>
     * 
     * @return property startMenuHideHibernate
     */
    @Property(name="startMenuHideHibernate")
    @JsonIgnore
    public Optional<Boolean> getStartMenuHideHibernate() {
        return Optional.ofNullable(startMenuHideHibernate);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startMenuHideHibernate} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Enabling this policy hides hibernate from appearing in the power button in the
     * start menu.”</i>
     * 
     * @param startMenuHideHibernate
     *            new value of {@code startMenuHideHibernate} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startMenuHideHibernate} field changed
     */
    public Windows10GeneralConfiguration withStartMenuHideHibernate(Boolean startMenuHideHibernate) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("startMenuHideHibernate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.startMenuHideHibernate = startMenuHideHibernate;
        return _x;
    }

    /**
     * <i>“Enabling this policy hides lock from appearing in the user tile in the start
     * menu.”</i>
     * 
     * @return property startMenuHideLock
     */
    @Property(name="startMenuHideLock")
    @JsonIgnore
    public Optional<Boolean> getStartMenuHideLock() {
        return Optional.ofNullable(startMenuHideLock);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code startMenuHideLock
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Enabling this policy hides lock from appearing in the user tile in the start
     * menu.”</i>
     * 
     * @param startMenuHideLock
     *            new value of {@code startMenuHideLock} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startMenuHideLock} field changed
     */
    public Windows10GeneralConfiguration withStartMenuHideLock(Boolean startMenuHideLock) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("startMenuHideLock");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.startMenuHideLock = startMenuHideLock;
        return _x;
    }

    /**
     * <i>“Enabling this policy hides the power button from appearing in the start menu.”</i>
     * 
     * @return property startMenuHidePowerButton
     */
    @Property(name="startMenuHidePowerButton")
    @JsonIgnore
    public Optional<Boolean> getStartMenuHidePowerButton() {
        return Optional.ofNullable(startMenuHidePowerButton);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startMenuHidePowerButton} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Enabling this policy hides the power button from appearing in the start menu.”</i>
     * 
     * @param startMenuHidePowerButton
     *            new value of {@code startMenuHidePowerButton} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startMenuHidePowerButton} field changed
     */
    public Windows10GeneralConfiguration withStartMenuHidePowerButton(Boolean startMenuHidePowerButton) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("startMenuHidePowerButton");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.startMenuHidePowerButton = startMenuHidePowerButton;
        return _x;
    }

    /**
     * <i>“Enabling this policy hides recent jump lists from appearing on the start menu/
     * taskbar and disables the corresponding toggle in the Settings app.”</i>
     * 
     * @return property startMenuHideRecentJumpLists
     */
    @Property(name="startMenuHideRecentJumpLists")
    @JsonIgnore
    public Optional<Boolean> getStartMenuHideRecentJumpLists() {
        return Optional.ofNullable(startMenuHideRecentJumpLists);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startMenuHideRecentJumpLists} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Enabling this policy hides recent jump lists from appearing on the start menu/
     * taskbar and disables the corresponding toggle in the Settings app.”</i>
     * 
     * @param startMenuHideRecentJumpLists
     *            new value of {@code startMenuHideRecentJumpLists} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startMenuHideRecentJumpLists} field changed
     */
    public Windows10GeneralConfiguration withStartMenuHideRecentJumpLists(Boolean startMenuHideRecentJumpLists) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("startMenuHideRecentJumpLists");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.startMenuHideRecentJumpLists = startMenuHideRecentJumpLists;
        return _x;
    }

    /**
     * <i>“Enabling this policy hides recently added apps from appearing on the start menu
     * and disables the corresponding toggle in the Settings app.”</i>
     * 
     * @return property startMenuHideRecentlyAddedApps
     */
    @Property(name="startMenuHideRecentlyAddedApps")
    @JsonIgnore
    public Optional<Boolean> getStartMenuHideRecentlyAddedApps() {
        return Optional.ofNullable(startMenuHideRecentlyAddedApps);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startMenuHideRecentlyAddedApps} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Enabling this policy hides recently added apps from appearing on the start menu
     * and disables the corresponding toggle in the Settings app.”</i>
     * 
     * @param startMenuHideRecentlyAddedApps
     *            new value of {@code startMenuHideRecentlyAddedApps} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startMenuHideRecentlyAddedApps} field changed
     */
    public Windows10GeneralConfiguration withStartMenuHideRecentlyAddedApps(Boolean startMenuHideRecentlyAddedApps) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("startMenuHideRecentlyAddedApps");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.startMenuHideRecentlyAddedApps = startMenuHideRecentlyAddedApps;
        return _x;
    }

    /**
     * <i>“Enabling this policy hides “Restart/Update and Restart” from appearing in the
     * power button in the start menu.”</i>
     * 
     * @return property startMenuHideRestartOptions
     */
    @Property(name="startMenuHideRestartOptions")
    @JsonIgnore
    public Optional<Boolean> getStartMenuHideRestartOptions() {
        return Optional.ofNullable(startMenuHideRestartOptions);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startMenuHideRestartOptions} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Enabling this policy hides “Restart/Update and Restart” from appearing in the
     * power button in the start menu.”</i>
     * 
     * @param startMenuHideRestartOptions
     *            new value of {@code startMenuHideRestartOptions} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startMenuHideRestartOptions} field changed
     */
    public Windows10GeneralConfiguration withStartMenuHideRestartOptions(Boolean startMenuHideRestartOptions) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("startMenuHideRestartOptions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.startMenuHideRestartOptions = startMenuHideRestartOptions;
        return _x;
    }

    /**
     * <i>“Enabling this policy hides shut down/update and shut down from appearing in the
     * power button in the start menu.”</i>
     * 
     * @return property startMenuHideShutDown
     */
    @Property(name="startMenuHideShutDown")
    @JsonIgnore
    public Optional<Boolean> getStartMenuHideShutDown() {
        return Optional.ofNullable(startMenuHideShutDown);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startMenuHideShutDown} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Enabling this policy hides shut down/update and shut down from appearing in the
     * power button in the start menu.”</i>
     * 
     * @param startMenuHideShutDown
     *            new value of {@code startMenuHideShutDown} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startMenuHideShutDown} field changed
     */
    public Windows10GeneralConfiguration withStartMenuHideShutDown(Boolean startMenuHideShutDown) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("startMenuHideShutDown");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.startMenuHideShutDown = startMenuHideShutDown;
        return _x;
    }

    /**
     * <i>“Enabling this policy hides sign out from appearing in the user tile in the start
     * menu.”</i>
     * 
     * @return property startMenuHideSignOut
     */
    @Property(name="startMenuHideSignOut")
    @JsonIgnore
    public Optional<Boolean> getStartMenuHideSignOut() {
        return Optional.ofNullable(startMenuHideSignOut);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startMenuHideSignOut} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Enabling this policy hides sign out from appearing in the user tile in the start
     * menu.”</i>
     * 
     * @param startMenuHideSignOut
     *            new value of {@code startMenuHideSignOut} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startMenuHideSignOut} field changed
     */
    public Windows10GeneralConfiguration withStartMenuHideSignOut(Boolean startMenuHideSignOut) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("startMenuHideSignOut");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.startMenuHideSignOut = startMenuHideSignOut;
        return _x;
    }

    /**
     * <i>“Enabling this policy hides sleep from appearing in the power button in the start
     * menu.”</i>
     * 
     * @return property startMenuHideSleep
     */
    @Property(name="startMenuHideSleep")
    @JsonIgnore
    public Optional<Boolean> getStartMenuHideSleep() {
        return Optional.ofNullable(startMenuHideSleep);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startMenuHideSleep} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Enabling this policy hides sleep from appearing in the power button in the start
     * menu.”</i>
     * 
     * @param startMenuHideSleep
     *            new value of {@code startMenuHideSleep} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startMenuHideSleep} field changed
     */
    public Windows10GeneralConfiguration withStartMenuHideSleep(Boolean startMenuHideSleep) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("startMenuHideSleep");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.startMenuHideSleep = startMenuHideSleep;
        return _x;
    }

    /**
     * <i>“Enabling this policy hides switch account from appearing in the user tile in the
     * start menu.”</i>
     * 
     * @return property startMenuHideSwitchAccount
     */
    @Property(name="startMenuHideSwitchAccount")
    @JsonIgnore
    public Optional<Boolean> getStartMenuHideSwitchAccount() {
        return Optional.ofNullable(startMenuHideSwitchAccount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startMenuHideSwitchAccount} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Enabling this policy hides switch account from appearing in the user tile in the
     * start menu.”</i>
     * 
     * @param startMenuHideSwitchAccount
     *            new value of {@code startMenuHideSwitchAccount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startMenuHideSwitchAccount} field changed
     */
    public Windows10GeneralConfiguration withStartMenuHideSwitchAccount(Boolean startMenuHideSwitchAccount) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("startMenuHideSwitchAccount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.startMenuHideSwitchAccount = startMenuHideSwitchAccount;
        return _x;
    }

    /**
     * <i>“Enabling this policy hides the user tile from appearing in the start menu.”</i>
     * 
     * @return property startMenuHideUserTile
     */
    @Property(name="startMenuHideUserTile")
    @JsonIgnore
    public Optional<Boolean> getStartMenuHideUserTile() {
        return Optional.ofNullable(startMenuHideUserTile);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startMenuHideUserTile} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Enabling this policy hides the user tile from appearing in the start menu.”</i>
     * 
     * @param startMenuHideUserTile
     *            new value of {@code startMenuHideUserTile} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startMenuHideUserTile} field changed
     */
    public Windows10GeneralConfiguration withStartMenuHideUserTile(Boolean startMenuHideUserTile) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("startMenuHideUserTile");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.startMenuHideUserTile = startMenuHideUserTile;
        return _x;
    }

    /**
     * <i>“This policy setting allows you to import Edge assets to be used with
     * startMenuLayoutXml policy. Start layout can contain secondary tile from Edge app
     * which looks for Edge local asset file. Edge local asset would not exist and
     * cause Edge secondary tile to appear empty in this case. This policy only gets
     * applied when startMenuLayoutXml policy is modified. The value should be a UTF-8
     * Base64 encoded byte array.”</i>
     * 
     * @return property startMenuLayoutEdgeAssetsXml
     */
    @Property(name="startMenuLayoutEdgeAssetsXml")
    @JsonIgnore
    public Optional<byte[]> getStartMenuLayoutEdgeAssetsXml() {
        return Optional.ofNullable(startMenuLayoutEdgeAssetsXml);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startMenuLayoutEdgeAssetsXml} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“This policy setting allows you to import Edge assets to be used with
     * startMenuLayoutXml policy. Start layout can contain secondary tile from Edge app
     * which looks for Edge local asset file. Edge local asset would not exist and
     * cause Edge secondary tile to appear empty in this case. This policy only gets
     * applied when startMenuLayoutXml policy is modified. The value should be a UTF-8
     * Base64 encoded byte array.”</i>
     * 
     * @param startMenuLayoutEdgeAssetsXml
     *            new value of {@code startMenuLayoutEdgeAssetsXml} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startMenuLayoutEdgeAssetsXml} field changed
     */
    public Windows10GeneralConfiguration withStartMenuLayoutEdgeAssetsXml(byte[] startMenuLayoutEdgeAssetsXml) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("startMenuLayoutEdgeAssetsXml");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.startMenuLayoutEdgeAssetsXml = startMenuLayoutEdgeAssetsXml;
        return _x;
    }

    /**
     * <i>“Allows admins to override the default Start menu layout and prevents the user
     * from changing it. The layout is modified by specifying an XML file based on a
     * layout modification schema. XML needs to be in a UTF8 encoded byte array format.”</i>
     * 
     * @return property startMenuLayoutXml
     */
    @Property(name="startMenuLayoutXml")
    @JsonIgnore
    public Optional<byte[]> getStartMenuLayoutXml() {
        return Optional.ofNullable(startMenuLayoutXml);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startMenuLayoutXml} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Allows admins to override the default Start menu layout and prevents the user
     * from changing it. The layout is modified by specifying an XML file based on a
     * layout modification schema. XML needs to be in a UTF8 encoded byte array format.”</i>
     * 
     * @param startMenuLayoutXml
     *            new value of {@code startMenuLayoutXml} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startMenuLayoutXml} field changed
     */
    public Windows10GeneralConfiguration withStartMenuLayoutXml(byte[] startMenuLayoutXml) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("startMenuLayoutXml");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.startMenuLayoutXml = startMenuLayoutXml;
        return _x;
    }

    /**
     * <i>“Allows admins to decide how the Start menu is displayed.”</i>
     * 
     * @return property startMenuMode
     */
    @Property(name="startMenuMode")
    @JsonIgnore
    public Optional<WindowsStartMenuModeType> getStartMenuMode() {
        return Optional.ofNullable(startMenuMode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code startMenuMode}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Allows admins to decide how the Start menu is displayed.”</i>
     * 
     * @param startMenuMode
     *            new value of {@code startMenuMode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startMenuMode} field changed
     */
    public Windows10GeneralConfiguration withStartMenuMode(WindowsStartMenuModeType startMenuMode) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("startMenuMode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.startMenuMode = startMenuMode;
        return _x;
    }

    /**
     * <i>“Enforces the visibility (Show/Hide) of the Documents folder shortcut on the
     * Start menu.”</i>
     * 
     * @return property startMenuPinnedFolderDocuments
     */
    @Property(name="startMenuPinnedFolderDocuments")
    @JsonIgnore
    public Optional<VisibilitySetting> getStartMenuPinnedFolderDocuments() {
        return Optional.ofNullable(startMenuPinnedFolderDocuments);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startMenuPinnedFolderDocuments} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Enforces the visibility (Show/Hide) of the Documents folder shortcut on the
     * Start menu.”</i>
     * 
     * @param startMenuPinnedFolderDocuments
     *            new value of {@code startMenuPinnedFolderDocuments} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startMenuPinnedFolderDocuments} field changed
     */
    public Windows10GeneralConfiguration withStartMenuPinnedFolderDocuments(VisibilitySetting startMenuPinnedFolderDocuments) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("startMenuPinnedFolderDocuments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.startMenuPinnedFolderDocuments = startMenuPinnedFolderDocuments;
        return _x;
    }

    /**
     * <i>“Enforces the visibility (Show/Hide) of the Downloads folder shortcut on the
     * Start menu.”</i>
     * 
     * @return property startMenuPinnedFolderDownloads
     */
    @Property(name="startMenuPinnedFolderDownloads")
    @JsonIgnore
    public Optional<VisibilitySetting> getStartMenuPinnedFolderDownloads() {
        return Optional.ofNullable(startMenuPinnedFolderDownloads);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startMenuPinnedFolderDownloads} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Enforces the visibility (Show/Hide) of the Downloads folder shortcut on the
     * Start menu.”</i>
     * 
     * @param startMenuPinnedFolderDownloads
     *            new value of {@code startMenuPinnedFolderDownloads} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startMenuPinnedFolderDownloads} field changed
     */
    public Windows10GeneralConfiguration withStartMenuPinnedFolderDownloads(VisibilitySetting startMenuPinnedFolderDownloads) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("startMenuPinnedFolderDownloads");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.startMenuPinnedFolderDownloads = startMenuPinnedFolderDownloads;
        return _x;
    }

    /**
     * <i>“Enforces the visibility (Show/Hide) of the FileExplorer shortcut on the Start
     * menu.”</i>
     * 
     * @return property startMenuPinnedFolderFileExplorer
     */
    @Property(name="startMenuPinnedFolderFileExplorer")
    @JsonIgnore
    public Optional<VisibilitySetting> getStartMenuPinnedFolderFileExplorer() {
        return Optional.ofNullable(startMenuPinnedFolderFileExplorer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startMenuPinnedFolderFileExplorer} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Enforces the visibility (Show/Hide) of the FileExplorer shortcut on the Start
     * menu.”</i>
     * 
     * @param startMenuPinnedFolderFileExplorer
     *            new value of {@code startMenuPinnedFolderFileExplorer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startMenuPinnedFolderFileExplorer} field changed
     */
    public Windows10GeneralConfiguration withStartMenuPinnedFolderFileExplorer(VisibilitySetting startMenuPinnedFolderFileExplorer) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("startMenuPinnedFolderFileExplorer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.startMenuPinnedFolderFileExplorer = startMenuPinnedFolderFileExplorer;
        return _x;
    }

    /**
     * <i>“Enforces the visibility (Show/Hide) of the HomeGroup folder shortcut on the
     * Start menu.”</i>
     * 
     * @return property startMenuPinnedFolderHomeGroup
     */
    @Property(name="startMenuPinnedFolderHomeGroup")
    @JsonIgnore
    public Optional<VisibilitySetting> getStartMenuPinnedFolderHomeGroup() {
        return Optional.ofNullable(startMenuPinnedFolderHomeGroup);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startMenuPinnedFolderHomeGroup} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Enforces the visibility (Show/Hide) of the HomeGroup folder shortcut on the
     * Start menu.”</i>
     * 
     * @param startMenuPinnedFolderHomeGroup
     *            new value of {@code startMenuPinnedFolderHomeGroup} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startMenuPinnedFolderHomeGroup} field changed
     */
    public Windows10GeneralConfiguration withStartMenuPinnedFolderHomeGroup(VisibilitySetting startMenuPinnedFolderHomeGroup) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("startMenuPinnedFolderHomeGroup");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.startMenuPinnedFolderHomeGroup = startMenuPinnedFolderHomeGroup;
        return _x;
    }

    /**
     * <i>“Enforces the visibility (Show/Hide) of the Music folder shortcut on the Start
     * menu.”</i>
     * 
     * @return property startMenuPinnedFolderMusic
     */
    @Property(name="startMenuPinnedFolderMusic")
    @JsonIgnore
    public Optional<VisibilitySetting> getStartMenuPinnedFolderMusic() {
        return Optional.ofNullable(startMenuPinnedFolderMusic);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startMenuPinnedFolderMusic} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Enforces the visibility (Show/Hide) of the Music folder shortcut on the Start
     * menu.”</i>
     * 
     * @param startMenuPinnedFolderMusic
     *            new value of {@code startMenuPinnedFolderMusic} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startMenuPinnedFolderMusic} field changed
     */
    public Windows10GeneralConfiguration withStartMenuPinnedFolderMusic(VisibilitySetting startMenuPinnedFolderMusic) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("startMenuPinnedFolderMusic");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.startMenuPinnedFolderMusic = startMenuPinnedFolderMusic;
        return _x;
    }

    /**
     * <i>“Enforces the visibility (Show/Hide) of the Network folder shortcut on the Start
     * menu.”</i>
     * 
     * @return property startMenuPinnedFolderNetwork
     */
    @Property(name="startMenuPinnedFolderNetwork")
    @JsonIgnore
    public Optional<VisibilitySetting> getStartMenuPinnedFolderNetwork() {
        return Optional.ofNullable(startMenuPinnedFolderNetwork);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startMenuPinnedFolderNetwork} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Enforces the visibility (Show/Hide) of the Network folder shortcut on the Start
     * menu.”</i>
     * 
     * @param startMenuPinnedFolderNetwork
     *            new value of {@code startMenuPinnedFolderNetwork} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startMenuPinnedFolderNetwork} field changed
     */
    public Windows10GeneralConfiguration withStartMenuPinnedFolderNetwork(VisibilitySetting startMenuPinnedFolderNetwork) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("startMenuPinnedFolderNetwork");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.startMenuPinnedFolderNetwork = startMenuPinnedFolderNetwork;
        return _x;
    }

    /**
     * <i>“Enforces the visibility (Show/Hide) of the PersonalFolder shortcut on the Start
     * menu.”</i>
     * 
     * @return property startMenuPinnedFolderPersonalFolder
     */
    @Property(name="startMenuPinnedFolderPersonalFolder")
    @JsonIgnore
    public Optional<VisibilitySetting> getStartMenuPinnedFolderPersonalFolder() {
        return Optional.ofNullable(startMenuPinnedFolderPersonalFolder);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startMenuPinnedFolderPersonalFolder} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Enforces the visibility (Show/Hide) of the PersonalFolder shortcut on the Start
     * menu.”</i>
     * 
     * @param startMenuPinnedFolderPersonalFolder
     *            new value of {@code startMenuPinnedFolderPersonalFolder} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startMenuPinnedFolderPersonalFolder} field changed
     */
    public Windows10GeneralConfiguration withStartMenuPinnedFolderPersonalFolder(VisibilitySetting startMenuPinnedFolderPersonalFolder) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("startMenuPinnedFolderPersonalFolder");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.startMenuPinnedFolderPersonalFolder = startMenuPinnedFolderPersonalFolder;
        return _x;
    }

    /**
     * <i>“Enforces the visibility (Show/Hide) of the Pictures folder shortcut on the Start
     * menu.”</i>
     * 
     * @return property startMenuPinnedFolderPictures
     */
    @Property(name="startMenuPinnedFolderPictures")
    @JsonIgnore
    public Optional<VisibilitySetting> getStartMenuPinnedFolderPictures() {
        return Optional.ofNullable(startMenuPinnedFolderPictures);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startMenuPinnedFolderPictures} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Enforces the visibility (Show/Hide) of the Pictures folder shortcut on the Start
     * menu.”</i>
     * 
     * @param startMenuPinnedFolderPictures
     *            new value of {@code startMenuPinnedFolderPictures} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startMenuPinnedFolderPictures} field changed
     */
    public Windows10GeneralConfiguration withStartMenuPinnedFolderPictures(VisibilitySetting startMenuPinnedFolderPictures) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("startMenuPinnedFolderPictures");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.startMenuPinnedFolderPictures = startMenuPinnedFolderPictures;
        return _x;
    }

    /**
     * <i>“Enforces the visibility (Show/Hide) of the Settings folder shortcut on the Start
     * menu.”</i>
     * 
     * @return property startMenuPinnedFolderSettings
     */
    @Property(name="startMenuPinnedFolderSettings")
    @JsonIgnore
    public Optional<VisibilitySetting> getStartMenuPinnedFolderSettings() {
        return Optional.ofNullable(startMenuPinnedFolderSettings);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startMenuPinnedFolderSettings} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Enforces the visibility (Show/Hide) of the Settings folder shortcut on the Start
     * menu.”</i>
     * 
     * @param startMenuPinnedFolderSettings
     *            new value of {@code startMenuPinnedFolderSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startMenuPinnedFolderSettings} field changed
     */
    public Windows10GeneralConfiguration withStartMenuPinnedFolderSettings(VisibilitySetting startMenuPinnedFolderSettings) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("startMenuPinnedFolderSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.startMenuPinnedFolderSettings = startMenuPinnedFolderSettings;
        return _x;
    }

    /**
     * <i>“Enforces the visibility (Show/Hide) of the Videos folder shortcut on the Start
     * menu.”</i>
     * 
     * @return property startMenuPinnedFolderVideos
     */
    @Property(name="startMenuPinnedFolderVideos")
    @JsonIgnore
    public Optional<VisibilitySetting> getStartMenuPinnedFolderVideos() {
        return Optional.ofNullable(startMenuPinnedFolderVideos);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * startMenuPinnedFolderVideos} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Enforces the visibility (Show/Hide) of the Videos folder shortcut on the Start
     * menu.”</i>
     * 
     * @param startMenuPinnedFolderVideos
     *            new value of {@code startMenuPinnedFolderVideos} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startMenuPinnedFolderVideos} field changed
     */
    public Windows10GeneralConfiguration withStartMenuPinnedFolderVideos(VisibilitySetting startMenuPinnedFolderVideos) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("startMenuPinnedFolderVideos");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.startMenuPinnedFolderVideos = startMenuPinnedFolderVideos;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to Block the user from using removable storage.”</i>
     * 
     * @return property storageBlockRemovableStorage
     */
    @Property(name="storageBlockRemovableStorage")
    @JsonIgnore
    public Optional<Boolean> getStorageBlockRemovableStorage() {
        return Optional.ofNullable(storageBlockRemovableStorage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * storageBlockRemovableStorage} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to Block the user from using removable storage.”</i>
     * 
     * @param storageBlockRemovableStorage
     *            new value of {@code storageBlockRemovableStorage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code storageBlockRemovableStorage} field changed
     */
    public Windows10GeneralConfiguration withStorageBlockRemovableStorage(Boolean storageBlockRemovableStorage) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("storageBlockRemovableStorage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.storageBlockRemovableStorage = storageBlockRemovableStorage;
        return _x;
    }

    /**
     * <i>“Indicating whether or not to require encryption on a mobile device.”</i>
     * 
     * @return property storageRequireMobileDeviceEncryption
     */
    @Property(name="storageRequireMobileDeviceEncryption")
    @JsonIgnore
    public Optional<Boolean> getStorageRequireMobileDeviceEncryption() {
        return Optional.ofNullable(storageRequireMobileDeviceEncryption);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * storageRequireMobileDeviceEncryption} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicating whether or not to require encryption on a mobile device.”</i>
     * 
     * @param storageRequireMobileDeviceEncryption
     *            new value of {@code storageRequireMobileDeviceEncryption} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code storageRequireMobileDeviceEncryption} field changed
     */
    public Windows10GeneralConfiguration withStorageRequireMobileDeviceEncryption(Boolean storageRequireMobileDeviceEncryption) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("storageRequireMobileDeviceEncryption");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.storageRequireMobileDeviceEncryption = storageRequireMobileDeviceEncryption;
        return _x;
    }

    /**
     * <i>“Indicates whether application data is restricted to the system drive.”</i>
     * 
     * @return property storageRestrictAppDataToSystemVolume
     */
    @Property(name="storageRestrictAppDataToSystemVolume")
    @JsonIgnore
    public Optional<Boolean> getStorageRestrictAppDataToSystemVolume() {
        return Optional.ofNullable(storageRestrictAppDataToSystemVolume);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * storageRestrictAppDataToSystemVolume} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether application data is restricted to the system drive.”</i>
     * 
     * @param storageRestrictAppDataToSystemVolume
     *            new value of {@code storageRestrictAppDataToSystemVolume} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code storageRestrictAppDataToSystemVolume} field changed
     */
    public Windows10GeneralConfiguration withStorageRestrictAppDataToSystemVolume(Boolean storageRestrictAppDataToSystemVolume) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("storageRestrictAppDataToSystemVolume");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.storageRestrictAppDataToSystemVolume = storageRestrictAppDataToSystemVolume;
        return _x;
    }

    /**
     * <i>“Indicates whether the installation of applications is restricted to the system
     * drive.”</i>
     * 
     * @return property storageRestrictAppInstallToSystemVolume
     */
    @Property(name="storageRestrictAppInstallToSystemVolume")
    @JsonIgnore
    public Optional<Boolean> getStorageRestrictAppInstallToSystemVolume() {
        return Optional.ofNullable(storageRestrictAppInstallToSystemVolume);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * storageRestrictAppInstallToSystemVolume} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether the installation of applications is restricted to the system
     * drive.”</i>
     * 
     * @param storageRestrictAppInstallToSystemVolume
     *            new value of {@code storageRestrictAppInstallToSystemVolume} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code storageRestrictAppInstallToSystemVolume} field changed
     */
    public Windows10GeneralConfiguration withStorageRestrictAppInstallToSystemVolume(Boolean storageRestrictAppInstallToSystemVolume) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("storageRestrictAppInstallToSystemVolume");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.storageRestrictAppInstallToSystemVolume = storageRestrictAppInstallToSystemVolume;
        return _x;
    }

    /**
     * <i>“Gets or sets the fully qualified domain name (FQDN) or IP address of a proxy
     * server to forward Connected User Experiences and Telemetry requests.”</i>
     * 
     * @return property systemTelemetryProxyServer
     */
    @Property(name="systemTelemetryProxyServer")
    @JsonIgnore
    public Optional<String> getSystemTelemetryProxyServer() {
        return Optional.ofNullable(systemTelemetryProxyServer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * systemTelemetryProxyServer} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Gets or sets the fully qualified domain name (FQDN) or IP address of a proxy
     * server to forward Connected User Experiences and Telemetry requests.”</i>
     * 
     * @param systemTelemetryProxyServer
     *            new value of {@code systemTelemetryProxyServer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code systemTelemetryProxyServer} field changed
     */
    public Windows10GeneralConfiguration withSystemTelemetryProxyServer(String systemTelemetryProxyServer) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("systemTelemetryProxyServer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.systemTelemetryProxyServer = systemTelemetryProxyServer;
        return _x;
    }

    /**
     * <i>“Specify whether non-administrators can use Task Manager to end tasks.”</i>
     * 
     * @return property taskManagerBlockEndTask
     */
    @Property(name="taskManagerBlockEndTask")
    @JsonIgnore
    public Optional<Boolean> getTaskManagerBlockEndTask() {
        return Optional.ofNullable(taskManagerBlockEndTask);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * taskManagerBlockEndTask} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Specify whether non-administrators can use Task Manager to end tasks.”</i>
     * 
     * @param taskManagerBlockEndTask
     *            new value of {@code taskManagerBlockEndTask} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code taskManagerBlockEndTask} field changed
     */
    public Windows10GeneralConfiguration withTaskManagerBlockEndTask(Boolean taskManagerBlockEndTask) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("taskManagerBlockEndTask");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.taskManagerBlockEndTask = taskManagerBlockEndTask;
        return _x;
    }

    /**
     * <i>“Whether the device is required to connect to the network.”</i>
     * 
     * @return property tenantLockdownRequireNetworkDuringOutOfBoxExperience
     */
    @Property(name="tenantLockdownRequireNetworkDuringOutOfBoxExperience")
    @JsonIgnore
    public Optional<Boolean> getTenantLockdownRequireNetworkDuringOutOfBoxExperience() {
        return Optional.ofNullable(tenantLockdownRequireNetworkDuringOutOfBoxExperience);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * tenantLockdownRequireNetworkDuringOutOfBoxExperience} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Whether the device is required to connect to the network.”</i>
     * 
     * @param tenantLockdownRequireNetworkDuringOutOfBoxExperience
     *            new value of {@code tenantLockdownRequireNetworkDuringOutOfBoxExperience} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code tenantLockdownRequireNetworkDuringOutOfBoxExperience} field changed
     */
    public Windows10GeneralConfiguration withTenantLockdownRequireNetworkDuringOutOfBoxExperience(Boolean tenantLockdownRequireNetworkDuringOutOfBoxExperience) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("tenantLockdownRequireNetworkDuringOutOfBoxExperience");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.tenantLockdownRequireNetworkDuringOutOfBoxExperience = tenantLockdownRequireNetworkDuringOutOfBoxExperience;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to uninstall a fixed list of built-in Windows apps.”</i>
     * 
     * @return property uninstallBuiltInApps
     */
    @Property(name="uninstallBuiltInApps")
    @JsonIgnore
    public Optional<Boolean> getUninstallBuiltInApps() {
        return Optional.ofNullable(uninstallBuiltInApps);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * uninstallBuiltInApps} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to uninstall a fixed list of built-in Windows apps.”</i>
     * 
     * @param uninstallBuiltInApps
     *            new value of {@code uninstallBuiltInApps} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code uninstallBuiltInApps} field changed
     */
    public Windows10GeneralConfiguration withUninstallBuiltInApps(Boolean uninstallBuiltInApps) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("uninstallBuiltInApps");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.uninstallBuiltInApps = uninstallBuiltInApps;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to Block the user from USB connection.”</i>
     * 
     * @return property usbBlocked
     */
    @Property(name="usbBlocked")
    @JsonIgnore
    public Optional<Boolean> getUsbBlocked() {
        return Optional.ofNullable(usbBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code usbBlocked} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Indicates whether or not to Block the user from USB connection.”</i>
     * 
     * @param usbBlocked
     *            new value of {@code usbBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code usbBlocked} field changed
     */
    public Windows10GeneralConfiguration withUsbBlocked(Boolean usbBlocked) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("usbBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.usbBlocked = usbBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to Block the user from voice recording.”</i>
     * 
     * @return property voiceRecordingBlocked
     */
    @Property(name="voiceRecordingBlocked")
    @JsonIgnore
    public Optional<Boolean> getVoiceRecordingBlocked() {
        return Optional.ofNullable(voiceRecordingBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * voiceRecordingBlocked} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to Block the user from voice recording.”</i>
     * 
     * @param voiceRecordingBlocked
     *            new value of {@code voiceRecordingBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code voiceRecordingBlocked} field changed
     */
    public Windows10GeneralConfiguration withVoiceRecordingBlocked(Boolean voiceRecordingBlocked) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("voiceRecordingBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.voiceRecordingBlocked = voiceRecordingBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not user's localhost IP address is displayed while making
     * phone calls using the WebRTC”</i>
     * 
     * @return property webRtcBlockLocalhostIpAddress
     */
    @Property(name="webRtcBlockLocalhostIpAddress")
    @JsonIgnore
    public Optional<Boolean> getWebRtcBlockLocalhostIpAddress() {
        return Optional.ofNullable(webRtcBlockLocalhostIpAddress);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * webRtcBlockLocalhostIpAddress} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not user's localhost IP address is displayed while making
     * phone calls using the WebRTC”</i>
     * 
     * @param webRtcBlockLocalhostIpAddress
     *            new value of {@code webRtcBlockLocalhostIpAddress} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code webRtcBlockLocalhostIpAddress} field changed
     */
    public Windows10GeneralConfiguration withWebRtcBlockLocalhostIpAddress(Boolean webRtcBlockLocalhostIpAddress) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("webRtcBlockLocalhostIpAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.webRtcBlockLocalhostIpAddress = webRtcBlockLocalhostIpAddress;
        return _x;
    }

    /**
     * <i>“Indicating whether or not to block automatically connecting to Wi-Fi hotspots.
     * Has no impact if Wi-Fi is blocked.”</i>
     * 
     * @return property wiFiBlockAutomaticConnectHotspots
     */
    @Property(name="wiFiBlockAutomaticConnectHotspots")
    @JsonIgnore
    public Optional<Boolean> getWiFiBlockAutomaticConnectHotspots() {
        return Optional.ofNullable(wiFiBlockAutomaticConnectHotspots);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * wiFiBlockAutomaticConnectHotspots} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicating whether or not to block automatically connecting to Wi-Fi hotspots.
     * Has no impact if Wi-Fi is blocked.”</i>
     * 
     * @param wiFiBlockAutomaticConnectHotspots
     *            new value of {@code wiFiBlockAutomaticConnectHotspots} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code wiFiBlockAutomaticConnectHotspots} field changed
     */
    public Windows10GeneralConfiguration withWiFiBlockAutomaticConnectHotspots(Boolean wiFiBlockAutomaticConnectHotspots) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("wiFiBlockAutomaticConnectHotspots");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.wiFiBlockAutomaticConnectHotspots = wiFiBlockAutomaticConnectHotspots;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to Block the user from using Wi-Fi.”</i>
     * 
     * @return property wiFiBlocked
     */
    @Property(name="wiFiBlocked")
    @JsonIgnore
    public Optional<Boolean> getWiFiBlocked() {
        return Optional.ofNullable(wiFiBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code wiFiBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to Block the user from using Wi-Fi.”</i>
     * 
     * @param wiFiBlocked
     *            new value of {@code wiFiBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code wiFiBlocked} field changed
     */
    public Windows10GeneralConfiguration withWiFiBlocked(Boolean wiFiBlocked) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("wiFiBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.wiFiBlocked = wiFiBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to Block the user from using Wi-Fi manual configuration
     * .”</i>
     * 
     * @return property wiFiBlockManualConfiguration
     */
    @Property(name="wiFiBlockManualConfiguration")
    @JsonIgnore
    public Optional<Boolean> getWiFiBlockManualConfiguration() {
        return Optional.ofNullable(wiFiBlockManualConfiguration);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * wiFiBlockManualConfiguration} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to Block the user from using Wi-Fi manual configuration
     * .”</i>
     * 
     * @param wiFiBlockManualConfiguration
     *            new value of {@code wiFiBlockManualConfiguration} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code wiFiBlockManualConfiguration} field changed
     */
    public Windows10GeneralConfiguration withWiFiBlockManualConfiguration(Boolean wiFiBlockManualConfiguration) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("wiFiBlockManualConfiguration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.wiFiBlockManualConfiguration = wiFiBlockManualConfiguration;
        return _x;
    }

    /**
     * <i>“Specify how often devices scan for Wi-Fi networks. Supported values are 1-500,
     * where 100 = default, and 500 = low frequency. Valid values 1 to 500”</i>
     * 
     * @return property wiFiScanInterval
     */
    @Property(name="wiFiScanInterval")
    @JsonIgnore
    public Optional<Integer> getWiFiScanInterval() {
        return Optional.ofNullable(wiFiScanInterval);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code wiFiScanInterval}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Specify how often devices scan for Wi-Fi networks. Supported values are 1-500,
     * where 100 = default, and 500 = low frequency. Valid values 1 to 500”</i>
     * 
     * @param wiFiScanInterval
     *            new value of {@code wiFiScanInterval} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code wiFiScanInterval} field changed
     */
    public Windows10GeneralConfiguration withWiFiScanInterval(Integer wiFiScanInterval) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("wiFiScanInterval");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.wiFiScanInterval = wiFiScanInterval;
        return _x;
    }

    /**
     * <i>“Windows 10 force update schedule for Apps.”</i>
     * 
     * @return property windows10AppsForceUpdateSchedule
     */
    @Property(name="windows10AppsForceUpdateSchedule")
    @JsonIgnore
    public Optional<Windows10AppsForceUpdateSchedule> getWindows10AppsForceUpdateSchedule() {
        return Optional.ofNullable(windows10AppsForceUpdateSchedule);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windows10AppsForceUpdateSchedule} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Windows 10 force update schedule for Apps.”</i>
     * 
     * @param windows10AppsForceUpdateSchedule
     *            new value of {@code windows10AppsForceUpdateSchedule} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windows10AppsForceUpdateSchedule} field changed
     */
    public Windows10GeneralConfiguration withWindows10AppsForceUpdateSchedule(Windows10AppsForceUpdateSchedule windows10AppsForceUpdateSchedule) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("windows10AppsForceUpdateSchedule");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.windows10AppsForceUpdateSchedule = windows10AppsForceUpdateSchedule;
        return _x;
    }

    /**
     * <i>“Allows IT admins to block experiences that are typically for consumers only,
     * such as Start suggestions, Membership notifications, Post-OOBE app install and
     * redirect tiles.”</i>
     * 
     * @return property windowsSpotlightBlockConsumerSpecificFeatures
     */
    @Property(name="windowsSpotlightBlockConsumerSpecificFeatures")
    @JsonIgnore
    public Optional<Boolean> getWindowsSpotlightBlockConsumerSpecificFeatures() {
        return Optional.ofNullable(windowsSpotlightBlockConsumerSpecificFeatures);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsSpotlightBlockConsumerSpecificFeatures} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Allows IT admins to block experiences that are typically for consumers only,
     * such as Start suggestions, Membership notifications, Post-OOBE app install and
     * redirect tiles.”</i>
     * 
     * @param windowsSpotlightBlockConsumerSpecificFeatures
     *            new value of {@code windowsSpotlightBlockConsumerSpecificFeatures} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsSpotlightBlockConsumerSpecificFeatures} field changed
     */
    public Windows10GeneralConfiguration withWindowsSpotlightBlockConsumerSpecificFeatures(Boolean windowsSpotlightBlockConsumerSpecificFeatures) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("windowsSpotlightBlockConsumerSpecificFeatures");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.windowsSpotlightBlockConsumerSpecificFeatures = windowsSpotlightBlockConsumerSpecificFeatures;
        return _x;
    }

    /**
     * <i>“Allows IT admins to turn off all Windows Spotlight features”</i>
     * 
     * @return property windowsSpotlightBlocked
     */
    @Property(name="windowsSpotlightBlocked")
    @JsonIgnore
    public Optional<Boolean> getWindowsSpotlightBlocked() {
        return Optional.ofNullable(windowsSpotlightBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsSpotlightBlocked} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Allows IT admins to turn off all Windows Spotlight features”</i>
     * 
     * @param windowsSpotlightBlocked
     *            new value of {@code windowsSpotlightBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsSpotlightBlocked} field changed
     */
    public Windows10GeneralConfiguration withWindowsSpotlightBlocked(Boolean windowsSpotlightBlocked) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("windowsSpotlightBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.windowsSpotlightBlocked = windowsSpotlightBlocked;
        return _x;
    }

    /**
     * <i>“Block suggestions from Microsoft that show after each OS clean install, upgrade
     * or in an on-going basis to introduce users to what is new or changed”</i>
     * 
     * @return property windowsSpotlightBlockOnActionCenter
     */
    @Property(name="windowsSpotlightBlockOnActionCenter")
    @JsonIgnore
    public Optional<Boolean> getWindowsSpotlightBlockOnActionCenter() {
        return Optional.ofNullable(windowsSpotlightBlockOnActionCenter);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsSpotlightBlockOnActionCenter} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Block suggestions from Microsoft that show after each OS clean install, upgrade
     * or in an on-going basis to introduce users to what is new or changed”</i>
     * 
     * @param windowsSpotlightBlockOnActionCenter
     *            new value of {@code windowsSpotlightBlockOnActionCenter} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsSpotlightBlockOnActionCenter} field changed
     */
    public Windows10GeneralConfiguration withWindowsSpotlightBlockOnActionCenter(Boolean windowsSpotlightBlockOnActionCenter) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("windowsSpotlightBlockOnActionCenter");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.windowsSpotlightBlockOnActionCenter = windowsSpotlightBlockOnActionCenter;
        return _x;
    }

    /**
     * <i>“Block personalized content in Windows spotlight based on user’s device usage.”</i>
     * 
     * @return property windowsSpotlightBlockTailoredExperiences
     */
    @Property(name="windowsSpotlightBlockTailoredExperiences")
    @JsonIgnore
    public Optional<Boolean> getWindowsSpotlightBlockTailoredExperiences() {
        return Optional.ofNullable(windowsSpotlightBlockTailoredExperiences);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsSpotlightBlockTailoredExperiences} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Block personalized content in Windows spotlight based on user’s device usage.”</i>
     * 
     * @param windowsSpotlightBlockTailoredExperiences
     *            new value of {@code windowsSpotlightBlockTailoredExperiences} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsSpotlightBlockTailoredExperiences} field changed
     */
    public Windows10GeneralConfiguration withWindowsSpotlightBlockTailoredExperiences(Boolean windowsSpotlightBlockTailoredExperiences) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("windowsSpotlightBlockTailoredExperiences");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.windowsSpotlightBlockTailoredExperiences = windowsSpotlightBlockTailoredExperiences;
        return _x;
    }

    /**
     * <i>“Block third party content delivered via Windows Spotlight”</i>
     * 
     * @return property windowsSpotlightBlockThirdPartyNotifications
     */
    @Property(name="windowsSpotlightBlockThirdPartyNotifications")
    @JsonIgnore
    public Optional<Boolean> getWindowsSpotlightBlockThirdPartyNotifications() {
        return Optional.ofNullable(windowsSpotlightBlockThirdPartyNotifications);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsSpotlightBlockThirdPartyNotifications} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Block third party content delivered via Windows Spotlight”</i>
     * 
     * @param windowsSpotlightBlockThirdPartyNotifications
     *            new value of {@code windowsSpotlightBlockThirdPartyNotifications} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsSpotlightBlockThirdPartyNotifications} field changed
     */
    public Windows10GeneralConfiguration withWindowsSpotlightBlockThirdPartyNotifications(Boolean windowsSpotlightBlockThirdPartyNotifications) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("windowsSpotlightBlockThirdPartyNotifications");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.windowsSpotlightBlockThirdPartyNotifications = windowsSpotlightBlockThirdPartyNotifications;
        return _x;
    }

    /**
     * <i>“Block Windows Spotlight Windows welcome experience”</i>
     * 
     * @return property windowsSpotlightBlockWelcomeExperience
     */
    @Property(name="windowsSpotlightBlockWelcomeExperience")
    @JsonIgnore
    public Optional<Boolean> getWindowsSpotlightBlockWelcomeExperience() {
        return Optional.ofNullable(windowsSpotlightBlockWelcomeExperience);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsSpotlightBlockWelcomeExperience} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Block Windows Spotlight Windows welcome experience”</i>
     * 
     * @param windowsSpotlightBlockWelcomeExperience
     *            new value of {@code windowsSpotlightBlockWelcomeExperience} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsSpotlightBlockWelcomeExperience} field changed
     */
    public Windows10GeneralConfiguration withWindowsSpotlightBlockWelcomeExperience(Boolean windowsSpotlightBlockWelcomeExperience) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("windowsSpotlightBlockWelcomeExperience");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.windowsSpotlightBlockWelcomeExperience = windowsSpotlightBlockWelcomeExperience;
        return _x;
    }

    /**
     * <i>“Allows IT admins to turn off the popup of Windows Tips.”</i>
     * 
     * @return property windowsSpotlightBlockWindowsTips
     */
    @Property(name="windowsSpotlightBlockWindowsTips")
    @JsonIgnore
    public Optional<Boolean> getWindowsSpotlightBlockWindowsTips() {
        return Optional.ofNullable(windowsSpotlightBlockWindowsTips);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsSpotlightBlockWindowsTips} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Allows IT admins to turn off the popup of Windows Tips.”</i>
     * 
     * @param windowsSpotlightBlockWindowsTips
     *            new value of {@code windowsSpotlightBlockWindowsTips} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsSpotlightBlockWindowsTips} field changed
     */
    public Windows10GeneralConfiguration withWindowsSpotlightBlockWindowsTips(Boolean windowsSpotlightBlockWindowsTips) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("windowsSpotlightBlockWindowsTips");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.windowsSpotlightBlockWindowsTips = windowsSpotlightBlockWindowsTips;
        return _x;
    }

    /**
     * <i>“Specifies the type of Spotlight”</i>
     * 
     * @return property windowsSpotlightConfigureOnLockScreen
     */
    @Property(name="windowsSpotlightConfigureOnLockScreen")
    @JsonIgnore
    public Optional<WindowsSpotlightEnablementSettings> getWindowsSpotlightConfigureOnLockScreen() {
        return Optional.ofNullable(windowsSpotlightConfigureOnLockScreen);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsSpotlightConfigureOnLockScreen} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Specifies the type of Spotlight”</i>
     * 
     * @param windowsSpotlightConfigureOnLockScreen
     *            new value of {@code windowsSpotlightConfigureOnLockScreen} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsSpotlightConfigureOnLockScreen} field changed
     */
    public Windows10GeneralConfiguration withWindowsSpotlightConfigureOnLockScreen(WindowsSpotlightEnablementSettings windowsSpotlightConfigureOnLockScreen) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("windowsSpotlightConfigureOnLockScreen");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.windowsSpotlightConfigureOnLockScreen = windowsSpotlightConfigureOnLockScreen;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block automatic update of apps from Windows Store.”</i>
     * 
     * @return property windowsStoreBlockAutoUpdate
     */
    @Property(name="windowsStoreBlockAutoUpdate")
    @JsonIgnore
    public Optional<Boolean> getWindowsStoreBlockAutoUpdate() {
        return Optional.ofNullable(windowsStoreBlockAutoUpdate);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsStoreBlockAutoUpdate} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block automatic update of apps from Windows Store.”</i>
     * 
     * @param windowsStoreBlockAutoUpdate
     *            new value of {@code windowsStoreBlockAutoUpdate} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsStoreBlockAutoUpdate} field changed
     */
    public Windows10GeneralConfiguration withWindowsStoreBlockAutoUpdate(Boolean windowsStoreBlockAutoUpdate) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("windowsStoreBlockAutoUpdate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.windowsStoreBlockAutoUpdate = windowsStoreBlockAutoUpdate;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to Block the user from using the Windows store.”</i>
     * 
     * @return property windowsStoreBlocked
     */
    @Property(name="windowsStoreBlocked")
    @JsonIgnore
    public Optional<Boolean> getWindowsStoreBlocked() {
        return Optional.ofNullable(windowsStoreBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsStoreBlocked} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to Block the user from using the Windows store.”</i>
     * 
     * @param windowsStoreBlocked
     *            new value of {@code windowsStoreBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsStoreBlocked} field changed
     */
    public Windows10GeneralConfiguration withWindowsStoreBlocked(Boolean windowsStoreBlocked) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("windowsStoreBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.windowsStoreBlocked = windowsStoreBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to enable Private Store Only.”</i>
     * 
     * @return property windowsStoreEnablePrivateStoreOnly
     */
    @Property(name="windowsStoreEnablePrivateStoreOnly")
    @JsonIgnore
    public Optional<Boolean> getWindowsStoreEnablePrivateStoreOnly() {
        return Optional.ofNullable(windowsStoreEnablePrivateStoreOnly);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsStoreEnablePrivateStoreOnly} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to enable Private Store Only.”</i>
     * 
     * @param windowsStoreEnablePrivateStoreOnly
     *            new value of {@code windowsStoreEnablePrivateStoreOnly} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsStoreEnablePrivateStoreOnly} field changed
     */
    public Windows10GeneralConfiguration withWindowsStoreEnablePrivateStoreOnly(Boolean windowsStoreEnablePrivateStoreOnly) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("windowsStoreEnablePrivateStoreOnly");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.windowsStoreEnablePrivateStoreOnly = windowsStoreEnablePrivateStoreOnly;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow other devices from discovering this PC for
     * projection.”</i>
     * 
     * @return property wirelessDisplayBlockProjectionToThisDevice
     */
    @Property(name="wirelessDisplayBlockProjectionToThisDevice")
    @JsonIgnore
    public Optional<Boolean> getWirelessDisplayBlockProjectionToThisDevice() {
        return Optional.ofNullable(wirelessDisplayBlockProjectionToThisDevice);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * wirelessDisplayBlockProjectionToThisDevice} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow other devices from discovering this PC for
     * projection.”</i>
     * 
     * @param wirelessDisplayBlockProjectionToThisDevice
     *            new value of {@code wirelessDisplayBlockProjectionToThisDevice} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code wirelessDisplayBlockProjectionToThisDevice} field changed
     */
    public Windows10GeneralConfiguration withWirelessDisplayBlockProjectionToThisDevice(Boolean wirelessDisplayBlockProjectionToThisDevice) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("wirelessDisplayBlockProjectionToThisDevice");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.wirelessDisplayBlockProjectionToThisDevice = wirelessDisplayBlockProjectionToThisDevice;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow user input from wireless display receiver.”</i>
     * 
     * @return property wirelessDisplayBlockUserInputFromReceiver
     */
    @Property(name="wirelessDisplayBlockUserInputFromReceiver")
    @JsonIgnore
    public Optional<Boolean> getWirelessDisplayBlockUserInputFromReceiver() {
        return Optional.ofNullable(wirelessDisplayBlockUserInputFromReceiver);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * wirelessDisplayBlockUserInputFromReceiver} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow user input from wireless display receiver.”</i>
     * 
     * @param wirelessDisplayBlockUserInputFromReceiver
     *            new value of {@code wirelessDisplayBlockUserInputFromReceiver} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code wirelessDisplayBlockUserInputFromReceiver} field changed
     */
    public Windows10GeneralConfiguration withWirelessDisplayBlockUserInputFromReceiver(Boolean wirelessDisplayBlockUserInputFromReceiver) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("wirelessDisplayBlockUserInputFromReceiver");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.wirelessDisplayBlockUserInputFromReceiver = wirelessDisplayBlockUserInputFromReceiver;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to require a PIN for new devices to initiate pairing.”</i>
     * 
     * @return property wirelessDisplayRequirePinForPairing
     */
    @Property(name="wirelessDisplayRequirePinForPairing")
    @JsonIgnore
    public Optional<Boolean> getWirelessDisplayRequirePinForPairing() {
        return Optional.ofNullable(wirelessDisplayRequirePinForPairing);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * wirelessDisplayRequirePinForPairing} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to require a PIN for new devices to initiate pairing.”</i>
     * 
     * @param wirelessDisplayRequirePinForPairing
     *            new value of {@code wirelessDisplayRequirePinForPairing} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code wirelessDisplayRequirePinForPairing} field changed
     */
    public Windows10GeneralConfiguration withWirelessDisplayRequirePinForPairing(Boolean wirelessDisplayRequirePinForPairing) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("wirelessDisplayRequirePinForPairing");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.wirelessDisplayRequirePinForPairing = wirelessDisplayRequirePinForPairing;
        return _x;
    }

    public Windows10GeneralConfiguration withUnmappedField(String name, Object value) {
        Windows10GeneralConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“Indicates a list of applications with their access control levels over privacy
     * data categories, and/or the default access levels per category. This collection
     * can contain a maximum of 500 elements.”</i>
     * 
     * @return navigational property privacyAccessControls
     */
    @NavigationProperty(name="privacyAccessControls")
    @JsonIgnore
    public WindowsPrivacyDataAccessControlItemCollectionRequest getPrivacyAccessControls() {
        return new WindowsPrivacyDataAccessControlItemCollectionRequest(
                        contextPath.addSegment("privacyAccessControls"), Optional.ofNullable(privacyAccessControls));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * privacyAccessControls} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates a list of applications with their access control levels over privacy
     * data categories, and/or the default access levels per category. This collection
     * can contain a maximum of 500 elements.”</i>
     * 
     * @param privacyAccessControls
     *            new value of {@code privacyAccessControls} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code privacyAccessControls} field changed
     */
    public Windows10GeneralConfiguration withPrivacyAccessControls(List<WindowsPrivacyDataAccessControlItem> privacyAccessControls) {
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = changedFields.add("privacyAccessControls");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10GeneralConfiguration");
        _x.privacyAccessControls = privacyAccessControls;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows10GeneralConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows10GeneralConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Windows10GeneralConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Windows10GeneralConfiguration _copy() {
        Windows10GeneralConfiguration _x = new Windows10GeneralConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.version = version;
        _x.assignments = assignments;
        _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
        _x.deviceStatuses = deviceStatuses;
        _x.deviceStatusOverview = deviceStatusOverview;
        _x.groupAssignments = groupAssignments;
        _x.userStatuses = userStatuses;
        _x.userStatusOverview = userStatusOverview;
        _x.accountsBlockAddingNonMicrosoftAccountEmail = accountsBlockAddingNonMicrosoftAccountEmail;
        _x.activateAppsWithVoice = activateAppsWithVoice;
        _x.antiTheftModeBlocked = antiTheftModeBlocked;
        _x.appManagementMSIAllowUserControlOverInstall = appManagementMSIAllowUserControlOverInstall;
        _x.appManagementMSIAlwaysInstallWithElevatedPrivileges = appManagementMSIAlwaysInstallWithElevatedPrivileges;
        _x.appManagementPackageFamilyNamesToLaunchAfterLogOn = appManagementPackageFamilyNamesToLaunchAfterLogOn;
        _x.appsAllowTrustedAppsSideloading = appsAllowTrustedAppsSideloading;
        _x.appsBlockWindowsStoreOriginatedApps = appsBlockWindowsStoreOriginatedApps;
        _x.authenticationAllowSecondaryDevice = authenticationAllowSecondaryDevice;
        _x.authenticationPreferredAzureADTenantDomainName = authenticationPreferredAzureADTenantDomainName;
        _x.authenticationWebSignIn = authenticationWebSignIn;
        _x.bluetoothAllowedServices = bluetoothAllowedServices;
        _x.bluetoothBlockAdvertising = bluetoothBlockAdvertising;
        _x.bluetoothBlockDiscoverableMode = bluetoothBlockDiscoverableMode;
        _x.bluetoothBlocked = bluetoothBlocked;
        _x.bluetoothBlockPrePairing = bluetoothBlockPrePairing;
        _x.bluetoothBlockPromptedProximalConnections = bluetoothBlockPromptedProximalConnections;
        _x.cameraBlocked = cameraBlocked;
        _x.cellularBlockDataWhenRoaming = cellularBlockDataWhenRoaming;
        _x.cellularBlockVpn = cellularBlockVpn;
        _x.cellularBlockVpnWhenRoaming = cellularBlockVpnWhenRoaming;
        _x.cellularData = cellularData;
        _x.certificatesBlockManualRootCertificateInstallation = certificatesBlockManualRootCertificateInstallation;
        _x.configureTimeZone = configureTimeZone;
        _x.connectedDevicesServiceBlocked = connectedDevicesServiceBlocked;
        _x.copyPasteBlocked = copyPasteBlocked;
        _x.cortanaBlocked = cortanaBlocked;
        _x.cryptographyAllowFipsAlgorithmPolicy = cryptographyAllowFipsAlgorithmPolicy;
        _x.dataProtectionBlockDirectMemoryAccess = dataProtectionBlockDirectMemoryAccess;
        _x.defenderBlockEndUserAccess = defenderBlockEndUserAccess;
        _x.defenderBlockOnAccessProtection = defenderBlockOnAccessProtection;
        _x.defenderCloudBlockLevel = defenderCloudBlockLevel;
        _x.defenderCloudExtendedTimeout = defenderCloudExtendedTimeout;
        _x.defenderCloudExtendedTimeoutInSeconds = defenderCloudExtendedTimeoutInSeconds;
        _x.defenderDaysBeforeDeletingQuarantinedMalware = defenderDaysBeforeDeletingQuarantinedMalware;
        _x.defenderDetectedMalwareActions = defenderDetectedMalwareActions;
        _x.defenderDisableCatchupFullScan = defenderDisableCatchupFullScan;
        _x.defenderDisableCatchupQuickScan = defenderDisableCatchupQuickScan;
        _x.defenderFileExtensionsToExclude = defenderFileExtensionsToExclude;
        _x.defenderFilesAndFoldersToExclude = defenderFilesAndFoldersToExclude;
        _x.defenderMonitorFileActivity = defenderMonitorFileActivity;
        _x.defenderPotentiallyUnwantedAppAction = defenderPotentiallyUnwantedAppAction;
        _x.defenderPotentiallyUnwantedAppActionSetting = defenderPotentiallyUnwantedAppActionSetting;
        _x.defenderProcessesToExclude = defenderProcessesToExclude;
        _x.defenderPromptForSampleSubmission = defenderPromptForSampleSubmission;
        _x.defenderRequireBehaviorMonitoring = defenderRequireBehaviorMonitoring;
        _x.defenderRequireCloudProtection = defenderRequireCloudProtection;
        _x.defenderRequireNetworkInspectionSystem = defenderRequireNetworkInspectionSystem;
        _x.defenderRequireRealTimeMonitoring = defenderRequireRealTimeMonitoring;
        _x.defenderScanArchiveFiles = defenderScanArchiveFiles;
        _x.defenderScanDownloads = defenderScanDownloads;
        _x.defenderScanIncomingMail = defenderScanIncomingMail;
        _x.defenderScanMappedNetworkDrivesDuringFullScan = defenderScanMappedNetworkDrivesDuringFullScan;
        _x.defenderScanMaxCpu = defenderScanMaxCpu;
        _x.defenderScanNetworkFiles = defenderScanNetworkFiles;
        _x.defenderScanRemovableDrivesDuringFullScan = defenderScanRemovableDrivesDuringFullScan;
        _x.defenderScanScriptsLoadedInInternetExplorer = defenderScanScriptsLoadedInInternetExplorer;
        _x.defenderScanType = defenderScanType;
        _x.defenderScheduledQuickScanTime = defenderScheduledQuickScanTime;
        _x.defenderScheduledScanTime = defenderScheduledScanTime;
        _x.defenderScheduleScanEnableLowCpuPriority = defenderScheduleScanEnableLowCpuPriority;
        _x.defenderSignatureUpdateIntervalInHours = defenderSignatureUpdateIntervalInHours;
        _x.defenderSubmitSamplesConsentType = defenderSubmitSamplesConsentType;
        _x.defenderSystemScanSchedule = defenderSystemScanSchedule;
        _x.developerUnlockSetting = developerUnlockSetting;
        _x.deviceManagementBlockFactoryResetOnMobile = deviceManagementBlockFactoryResetOnMobile;
        _x.deviceManagementBlockManualUnenroll = deviceManagementBlockManualUnenroll;
        _x.diagnosticsDataSubmissionMode = diagnosticsDataSubmissionMode;
        _x.displayAppListWithGdiDPIScalingTurnedOff = displayAppListWithGdiDPIScalingTurnedOff;
        _x.displayAppListWithGdiDPIScalingTurnedOn = displayAppListWithGdiDPIScalingTurnedOn;
        _x.edgeAllowStartPagesModification = edgeAllowStartPagesModification;
        _x.edgeBlockAccessToAboutFlags = edgeBlockAccessToAboutFlags;
        _x.edgeBlockAddressBarDropdown = edgeBlockAddressBarDropdown;
        _x.edgeBlockAutofill = edgeBlockAutofill;
        _x.edgeBlockCompatibilityList = edgeBlockCompatibilityList;
        _x.edgeBlockDeveloperTools = edgeBlockDeveloperTools;
        _x.edgeBlocked = edgeBlocked;
        _x.edgeBlockEditFavorites = edgeBlockEditFavorites;
        _x.edgeBlockExtensions = edgeBlockExtensions;
        _x.edgeBlockFullScreenMode = edgeBlockFullScreenMode;
        _x.edgeBlockInPrivateBrowsing = edgeBlockInPrivateBrowsing;
        _x.edgeBlockJavaScript = edgeBlockJavaScript;
        _x.edgeBlockLiveTileDataCollection = edgeBlockLiveTileDataCollection;
        _x.edgeBlockPasswordManager = edgeBlockPasswordManager;
        _x.edgeBlockPopups = edgeBlockPopups;
        _x.edgeBlockPrelaunch = edgeBlockPrelaunch;
        _x.edgeBlockPrinting = edgeBlockPrinting;
        _x.edgeBlockSavingHistory = edgeBlockSavingHistory;
        _x.edgeBlockSearchEngineCustomization = edgeBlockSearchEngineCustomization;
        _x.edgeBlockSearchSuggestions = edgeBlockSearchSuggestions;
        _x.edgeBlockSendingDoNotTrackHeader = edgeBlockSendingDoNotTrackHeader;
        _x.edgeBlockSendingIntranetTrafficToInternetExplorer = edgeBlockSendingIntranetTrafficToInternetExplorer;
        _x.edgeBlockSideloadingExtensions = edgeBlockSideloadingExtensions;
        _x.edgeBlockTabPreloading = edgeBlockTabPreloading;
        _x.edgeBlockWebContentOnNewTabPage = edgeBlockWebContentOnNewTabPage;
        _x.edgeClearBrowsingDataOnExit = edgeClearBrowsingDataOnExit;
        _x.edgeCookiePolicy = edgeCookiePolicy;
        _x.edgeDisableFirstRunPage = edgeDisableFirstRunPage;
        _x.edgeEnterpriseModeSiteListLocation = edgeEnterpriseModeSiteListLocation;
        _x.edgeFavoritesBarVisibility = edgeFavoritesBarVisibility;
        _x.edgeFavoritesListLocation = edgeFavoritesListLocation;
        _x.edgeFirstRunUrl = edgeFirstRunUrl;
        _x.edgeHomeButtonConfiguration = edgeHomeButtonConfiguration;
        _x.edgeHomeButtonConfigurationEnabled = edgeHomeButtonConfigurationEnabled;
        _x.edgeHomepageUrls = edgeHomepageUrls;
        _x.edgeKioskModeRestriction = edgeKioskModeRestriction;
        _x.edgeKioskResetAfterIdleTimeInMinutes = edgeKioskResetAfterIdleTimeInMinutes;
        _x.edgeNewTabPageURL = edgeNewTabPageURL;
        _x.edgeOpensWith = edgeOpensWith;
        _x.edgePreventCertificateErrorOverride = edgePreventCertificateErrorOverride;
        _x.edgeRequiredExtensionPackageFamilyNames = edgeRequiredExtensionPackageFamilyNames;
        _x.edgeRequireSmartScreen = edgeRequireSmartScreen;
        _x.edgeSearchEngine = edgeSearchEngine;
        _x.edgeSendIntranetTrafficToInternetExplorer = edgeSendIntranetTrafficToInternetExplorer;
        _x.edgeShowMessageWhenOpeningInternetExplorerSites = edgeShowMessageWhenOpeningInternetExplorerSites;
        _x.edgeSyncFavoritesWithInternetExplorer = edgeSyncFavoritesWithInternetExplorer;
        _x.edgeTelemetryForMicrosoft365Analytics = edgeTelemetryForMicrosoft365Analytics;
        _x.enableAutomaticRedeployment = enableAutomaticRedeployment;
        _x.energySaverOnBatteryThresholdPercentage = energySaverOnBatteryThresholdPercentage;
        _x.energySaverPluggedInThresholdPercentage = energySaverPluggedInThresholdPercentage;
        _x.enterpriseCloudPrintDiscoveryEndPoint = enterpriseCloudPrintDiscoveryEndPoint;
        _x.enterpriseCloudPrintDiscoveryMaxLimit = enterpriseCloudPrintDiscoveryMaxLimit;
        _x.enterpriseCloudPrintMopriaDiscoveryResourceIdentifier = enterpriseCloudPrintMopriaDiscoveryResourceIdentifier;
        _x.enterpriseCloudPrintOAuthAuthority = enterpriseCloudPrintOAuthAuthority;
        _x.enterpriseCloudPrintOAuthClientIdentifier = enterpriseCloudPrintOAuthClientIdentifier;
        _x.enterpriseCloudPrintResourceIdentifier = enterpriseCloudPrintResourceIdentifier;
        _x.experienceBlockDeviceDiscovery = experienceBlockDeviceDiscovery;
        _x.experienceBlockErrorDialogWhenNoSIM = experienceBlockErrorDialogWhenNoSIM;
        _x.experienceBlockTaskSwitcher = experienceBlockTaskSwitcher;
        _x.experienceDoNotSyncBrowserSettings = experienceDoNotSyncBrowserSettings;
        _x.findMyFiles = findMyFiles;
        _x.gameDvrBlocked = gameDvrBlocked;
        _x.inkWorkspaceAccess = inkWorkspaceAccess;
        _x.inkWorkspaceAccessState = inkWorkspaceAccessState;
        _x.inkWorkspaceBlockSuggestedApps = inkWorkspaceBlockSuggestedApps;
        _x.internetSharingBlocked = internetSharingBlocked;
        _x.locationServicesBlocked = locationServicesBlocked;
        _x.lockScreenActivateAppsWithVoice = lockScreenActivateAppsWithVoice;
        _x.lockScreenAllowTimeoutConfiguration = lockScreenAllowTimeoutConfiguration;
        _x.lockScreenBlockActionCenterNotifications = lockScreenBlockActionCenterNotifications;
        _x.lockScreenBlockCortana = lockScreenBlockCortana;
        _x.lockScreenBlockToastNotifications = lockScreenBlockToastNotifications;
        _x.lockScreenTimeoutInSeconds = lockScreenTimeoutInSeconds;
        _x.logonBlockFastUserSwitching = logonBlockFastUserSwitching;
        _x.messagingBlockMMS = messagingBlockMMS;
        _x.messagingBlockRichCommunicationServices = messagingBlockRichCommunicationServices;
        _x.messagingBlockSync = messagingBlockSync;
        _x.microsoftAccountBlocked = microsoftAccountBlocked;
        _x.microsoftAccountBlockSettingsSync = microsoftAccountBlockSettingsSync;
        _x.microsoftAccountSignInAssistantSettings = microsoftAccountSignInAssistantSettings;
        _x.networkProxyApplySettingsDeviceWide = networkProxyApplySettingsDeviceWide;
        _x.networkProxyAutomaticConfigurationUrl = networkProxyAutomaticConfigurationUrl;
        _x.networkProxyDisableAutoDetect = networkProxyDisableAutoDetect;
        _x.networkProxyServer = networkProxyServer;
        _x.nfcBlocked = nfcBlocked;
        _x.oneDriveDisableFileSync = oneDriveDisableFileSync;
        _x.passwordBlockSimple = passwordBlockSimple;
        _x.passwordExpirationDays = passwordExpirationDays;
        _x.passwordMinimumAgeInDays = passwordMinimumAgeInDays;
        _x.passwordMinimumCharacterSetCount = passwordMinimumCharacterSetCount;
        _x.passwordMinimumLength = passwordMinimumLength;
        _x.passwordMinutesOfInactivityBeforeScreenTimeout = passwordMinutesOfInactivityBeforeScreenTimeout;
        _x.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
        _x.passwordRequired = passwordRequired;
        _x.passwordRequiredType = passwordRequiredType;
        _x.passwordRequireWhenResumeFromIdleState = passwordRequireWhenResumeFromIdleState;
        _x.passwordSignInFailureCountBeforeFactoryReset = passwordSignInFailureCountBeforeFactoryReset;
        _x.personalizationDesktopImageUrl = personalizationDesktopImageUrl;
        _x.personalizationLockScreenImageUrl = personalizationLockScreenImageUrl;
        _x.powerButtonActionOnBattery = powerButtonActionOnBattery;
        _x.powerButtonActionPluggedIn = powerButtonActionPluggedIn;
        _x.powerHybridSleepOnBattery = powerHybridSleepOnBattery;
        _x.powerHybridSleepPluggedIn = powerHybridSleepPluggedIn;
        _x.powerLidCloseActionOnBattery = powerLidCloseActionOnBattery;
        _x.powerLidCloseActionPluggedIn = powerLidCloseActionPluggedIn;
        _x.powerSleepButtonActionOnBattery = powerSleepButtonActionOnBattery;
        _x.powerSleepButtonActionPluggedIn = powerSleepButtonActionPluggedIn;
        _x.printerBlockAddition = printerBlockAddition;
        _x.printerDefaultName = printerDefaultName;
        _x.printerNames = printerNames;
        _x.privacyAdvertisingId = privacyAdvertisingId;
        _x.privacyAutoAcceptPairingAndConsentPrompts = privacyAutoAcceptPairingAndConsentPrompts;
        _x.privacyBlockActivityFeed = privacyBlockActivityFeed;
        _x.privacyBlockInputPersonalization = privacyBlockInputPersonalization;
        _x.privacyBlockPublishUserActivities = privacyBlockPublishUserActivities;
        _x.privacyDisableLaunchExperience = privacyDisableLaunchExperience;
        _x.resetProtectionModeBlocked = resetProtectionModeBlocked;
        _x.safeSearchFilter = safeSearchFilter;
        _x.screenCaptureBlocked = screenCaptureBlocked;
        _x.searchBlockDiacritics = searchBlockDiacritics;
        _x.searchBlockWebResults = searchBlockWebResults;
        _x.searchDisableAutoLanguageDetection = searchDisableAutoLanguageDetection;
        _x.searchDisableIndexerBackoff = searchDisableIndexerBackoff;
        _x.searchDisableIndexingEncryptedItems = searchDisableIndexingEncryptedItems;
        _x.searchDisableIndexingRemovableDrive = searchDisableIndexingRemovableDrive;
        _x.searchDisableLocation = searchDisableLocation;
        _x.searchDisableUseLocation = searchDisableUseLocation;
        _x.searchEnableAutomaticIndexSizeManangement = searchEnableAutomaticIndexSizeManangement;
        _x.searchEnableRemoteQueries = searchEnableRemoteQueries;
        _x.securityBlockAzureADJoinedDevicesAutoEncryption = securityBlockAzureADJoinedDevicesAutoEncryption;
        _x.settingsBlockAccountsPage = settingsBlockAccountsPage;
        _x.settingsBlockAddProvisioningPackage = settingsBlockAddProvisioningPackage;
        _x.settingsBlockAppsPage = settingsBlockAppsPage;
        _x.settingsBlockChangeLanguage = settingsBlockChangeLanguage;
        _x.settingsBlockChangePowerSleep = settingsBlockChangePowerSleep;
        _x.settingsBlockChangeRegion = settingsBlockChangeRegion;
        _x.settingsBlockChangeSystemTime = settingsBlockChangeSystemTime;
        _x.settingsBlockDevicesPage = settingsBlockDevicesPage;
        _x.settingsBlockEaseOfAccessPage = settingsBlockEaseOfAccessPage;
        _x.settingsBlockEditDeviceName = settingsBlockEditDeviceName;
        _x.settingsBlockGamingPage = settingsBlockGamingPage;
        _x.settingsBlockNetworkInternetPage = settingsBlockNetworkInternetPage;
        _x.settingsBlockPersonalizationPage = settingsBlockPersonalizationPage;
        _x.settingsBlockPrivacyPage = settingsBlockPrivacyPage;
        _x.settingsBlockRemoveProvisioningPackage = settingsBlockRemoveProvisioningPackage;
        _x.settingsBlockSettingsApp = settingsBlockSettingsApp;
        _x.settingsBlockSystemPage = settingsBlockSystemPage;
        _x.settingsBlockTimeLanguagePage = settingsBlockTimeLanguagePage;
        _x.settingsBlockUpdateSecurityPage = settingsBlockUpdateSecurityPage;
        _x.sharedUserAppDataAllowed = sharedUserAppDataAllowed;
        _x.smartScreenAppInstallControl = smartScreenAppInstallControl;
        _x.smartScreenBlockPromptOverride = smartScreenBlockPromptOverride;
        _x.smartScreenBlockPromptOverrideForFiles = smartScreenBlockPromptOverrideForFiles;
        _x.smartScreenEnableAppInstallControl = smartScreenEnableAppInstallControl;
        _x.startBlockUnpinningAppsFromTaskbar = startBlockUnpinningAppsFromTaskbar;
        _x.startMenuAppListVisibility = startMenuAppListVisibility;
        _x.startMenuHideChangeAccountSettings = startMenuHideChangeAccountSettings;
        _x.startMenuHideFrequentlyUsedApps = startMenuHideFrequentlyUsedApps;
        _x.startMenuHideHibernate = startMenuHideHibernate;
        _x.startMenuHideLock = startMenuHideLock;
        _x.startMenuHidePowerButton = startMenuHidePowerButton;
        _x.startMenuHideRecentJumpLists = startMenuHideRecentJumpLists;
        _x.startMenuHideRecentlyAddedApps = startMenuHideRecentlyAddedApps;
        _x.startMenuHideRestartOptions = startMenuHideRestartOptions;
        _x.startMenuHideShutDown = startMenuHideShutDown;
        _x.startMenuHideSignOut = startMenuHideSignOut;
        _x.startMenuHideSleep = startMenuHideSleep;
        _x.startMenuHideSwitchAccount = startMenuHideSwitchAccount;
        _x.startMenuHideUserTile = startMenuHideUserTile;
        _x.startMenuLayoutEdgeAssetsXml = startMenuLayoutEdgeAssetsXml;
        _x.startMenuLayoutXml = startMenuLayoutXml;
        _x.startMenuMode = startMenuMode;
        _x.startMenuPinnedFolderDocuments = startMenuPinnedFolderDocuments;
        _x.startMenuPinnedFolderDownloads = startMenuPinnedFolderDownloads;
        _x.startMenuPinnedFolderFileExplorer = startMenuPinnedFolderFileExplorer;
        _x.startMenuPinnedFolderHomeGroup = startMenuPinnedFolderHomeGroup;
        _x.startMenuPinnedFolderMusic = startMenuPinnedFolderMusic;
        _x.startMenuPinnedFolderNetwork = startMenuPinnedFolderNetwork;
        _x.startMenuPinnedFolderPersonalFolder = startMenuPinnedFolderPersonalFolder;
        _x.startMenuPinnedFolderPictures = startMenuPinnedFolderPictures;
        _x.startMenuPinnedFolderSettings = startMenuPinnedFolderSettings;
        _x.startMenuPinnedFolderVideos = startMenuPinnedFolderVideos;
        _x.storageBlockRemovableStorage = storageBlockRemovableStorage;
        _x.storageRequireMobileDeviceEncryption = storageRequireMobileDeviceEncryption;
        _x.storageRestrictAppDataToSystemVolume = storageRestrictAppDataToSystemVolume;
        _x.storageRestrictAppInstallToSystemVolume = storageRestrictAppInstallToSystemVolume;
        _x.systemTelemetryProxyServer = systemTelemetryProxyServer;
        _x.taskManagerBlockEndTask = taskManagerBlockEndTask;
        _x.tenantLockdownRequireNetworkDuringOutOfBoxExperience = tenantLockdownRequireNetworkDuringOutOfBoxExperience;
        _x.uninstallBuiltInApps = uninstallBuiltInApps;
        _x.usbBlocked = usbBlocked;
        _x.voiceRecordingBlocked = voiceRecordingBlocked;
        _x.webRtcBlockLocalhostIpAddress = webRtcBlockLocalhostIpAddress;
        _x.wiFiBlockAutomaticConnectHotspots = wiFiBlockAutomaticConnectHotspots;
        _x.wiFiBlocked = wiFiBlocked;
        _x.wiFiBlockManualConfiguration = wiFiBlockManualConfiguration;
        _x.wiFiScanInterval = wiFiScanInterval;
        _x.windows10AppsForceUpdateSchedule = windows10AppsForceUpdateSchedule;
        _x.windowsSpotlightBlockConsumerSpecificFeatures = windowsSpotlightBlockConsumerSpecificFeatures;
        _x.windowsSpotlightBlocked = windowsSpotlightBlocked;
        _x.windowsSpotlightBlockOnActionCenter = windowsSpotlightBlockOnActionCenter;
        _x.windowsSpotlightBlockTailoredExperiences = windowsSpotlightBlockTailoredExperiences;
        _x.windowsSpotlightBlockThirdPartyNotifications = windowsSpotlightBlockThirdPartyNotifications;
        _x.windowsSpotlightBlockWelcomeExperience = windowsSpotlightBlockWelcomeExperience;
        _x.windowsSpotlightBlockWindowsTips = windowsSpotlightBlockWindowsTips;
        _x.windowsSpotlightConfigureOnLockScreen = windowsSpotlightConfigureOnLockScreen;
        _x.windowsStoreBlockAutoUpdate = windowsStoreBlockAutoUpdate;
        _x.windowsStoreBlocked = windowsStoreBlocked;
        _x.windowsStoreEnablePrivateStoreOnly = windowsStoreEnablePrivateStoreOnly;
        _x.wirelessDisplayBlockProjectionToThisDevice = wirelessDisplayBlockProjectionToThisDevice;
        _x.wirelessDisplayBlockUserInputFromReceiver = wirelessDisplayBlockUserInputFromReceiver;
        _x.wirelessDisplayRequirePinForPairing = wirelessDisplayRequirePinForPairing;
        _x.privacyAccessControls = privacyAccessControls;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Windows10GeneralConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceSettingStateSummaries=");
        b.append(this.deviceSettingStateSummaries);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("deviceStatusOverview=");
        b.append(this.deviceStatusOverview);
        b.append(", ");
        b.append("groupAssignments=");
        b.append(this.groupAssignments);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("userStatusOverview=");
        b.append(this.userStatusOverview);
        b.append(", ");
        b.append("accountsBlockAddingNonMicrosoftAccountEmail=");
        b.append(this.accountsBlockAddingNonMicrosoftAccountEmail);
        b.append(", ");
        b.append("activateAppsWithVoice=");
        b.append(this.activateAppsWithVoice);
        b.append(", ");
        b.append("antiTheftModeBlocked=");
        b.append(this.antiTheftModeBlocked);
        b.append(", ");
        b.append("appManagementMSIAllowUserControlOverInstall=");
        b.append(this.appManagementMSIAllowUserControlOverInstall);
        b.append(", ");
        b.append("appManagementMSIAlwaysInstallWithElevatedPrivileges=");
        b.append(this.appManagementMSIAlwaysInstallWithElevatedPrivileges);
        b.append(", ");
        b.append("appManagementPackageFamilyNamesToLaunchAfterLogOn=");
        b.append(this.appManagementPackageFamilyNamesToLaunchAfterLogOn);
        b.append(", ");
        b.append("appsAllowTrustedAppsSideloading=");
        b.append(this.appsAllowTrustedAppsSideloading);
        b.append(", ");
        b.append("appsBlockWindowsStoreOriginatedApps=");
        b.append(this.appsBlockWindowsStoreOriginatedApps);
        b.append(", ");
        b.append("authenticationAllowSecondaryDevice=");
        b.append(this.authenticationAllowSecondaryDevice);
        b.append(", ");
        b.append("authenticationPreferredAzureADTenantDomainName=");
        b.append(this.authenticationPreferredAzureADTenantDomainName);
        b.append(", ");
        b.append("authenticationWebSignIn=");
        b.append(this.authenticationWebSignIn);
        b.append(", ");
        b.append("bluetoothAllowedServices=");
        b.append(this.bluetoothAllowedServices);
        b.append(", ");
        b.append("bluetoothBlockAdvertising=");
        b.append(this.bluetoothBlockAdvertising);
        b.append(", ");
        b.append("bluetoothBlockDiscoverableMode=");
        b.append(this.bluetoothBlockDiscoverableMode);
        b.append(", ");
        b.append("bluetoothBlocked=");
        b.append(this.bluetoothBlocked);
        b.append(", ");
        b.append("bluetoothBlockPrePairing=");
        b.append(this.bluetoothBlockPrePairing);
        b.append(", ");
        b.append("bluetoothBlockPromptedProximalConnections=");
        b.append(this.bluetoothBlockPromptedProximalConnections);
        b.append(", ");
        b.append("cameraBlocked=");
        b.append(this.cameraBlocked);
        b.append(", ");
        b.append("cellularBlockDataWhenRoaming=");
        b.append(this.cellularBlockDataWhenRoaming);
        b.append(", ");
        b.append("cellularBlockVpn=");
        b.append(this.cellularBlockVpn);
        b.append(", ");
        b.append("cellularBlockVpnWhenRoaming=");
        b.append(this.cellularBlockVpnWhenRoaming);
        b.append(", ");
        b.append("cellularData=");
        b.append(this.cellularData);
        b.append(", ");
        b.append("certificatesBlockManualRootCertificateInstallation=");
        b.append(this.certificatesBlockManualRootCertificateInstallation);
        b.append(", ");
        b.append("configureTimeZone=");
        b.append(this.configureTimeZone);
        b.append(", ");
        b.append("connectedDevicesServiceBlocked=");
        b.append(this.connectedDevicesServiceBlocked);
        b.append(", ");
        b.append("copyPasteBlocked=");
        b.append(this.copyPasteBlocked);
        b.append(", ");
        b.append("cortanaBlocked=");
        b.append(this.cortanaBlocked);
        b.append(", ");
        b.append("cryptographyAllowFipsAlgorithmPolicy=");
        b.append(this.cryptographyAllowFipsAlgorithmPolicy);
        b.append(", ");
        b.append("dataProtectionBlockDirectMemoryAccess=");
        b.append(this.dataProtectionBlockDirectMemoryAccess);
        b.append(", ");
        b.append("defenderBlockEndUserAccess=");
        b.append(this.defenderBlockEndUserAccess);
        b.append(", ");
        b.append("defenderBlockOnAccessProtection=");
        b.append(this.defenderBlockOnAccessProtection);
        b.append(", ");
        b.append("defenderCloudBlockLevel=");
        b.append(this.defenderCloudBlockLevel);
        b.append(", ");
        b.append("defenderCloudExtendedTimeout=");
        b.append(this.defenderCloudExtendedTimeout);
        b.append(", ");
        b.append("defenderCloudExtendedTimeoutInSeconds=");
        b.append(this.defenderCloudExtendedTimeoutInSeconds);
        b.append(", ");
        b.append("defenderDaysBeforeDeletingQuarantinedMalware=");
        b.append(this.defenderDaysBeforeDeletingQuarantinedMalware);
        b.append(", ");
        b.append("defenderDetectedMalwareActions=");
        b.append(this.defenderDetectedMalwareActions);
        b.append(", ");
        b.append("defenderDisableCatchupFullScan=");
        b.append(this.defenderDisableCatchupFullScan);
        b.append(", ");
        b.append("defenderDisableCatchupQuickScan=");
        b.append(this.defenderDisableCatchupQuickScan);
        b.append(", ");
        b.append("defenderFileExtensionsToExclude=");
        b.append(this.defenderFileExtensionsToExclude);
        b.append(", ");
        b.append("defenderFilesAndFoldersToExclude=");
        b.append(this.defenderFilesAndFoldersToExclude);
        b.append(", ");
        b.append("defenderMonitorFileActivity=");
        b.append(this.defenderMonitorFileActivity);
        b.append(", ");
        b.append("defenderPotentiallyUnwantedAppAction=");
        b.append(this.defenderPotentiallyUnwantedAppAction);
        b.append(", ");
        b.append("defenderPotentiallyUnwantedAppActionSetting=");
        b.append(this.defenderPotentiallyUnwantedAppActionSetting);
        b.append(", ");
        b.append("defenderProcessesToExclude=");
        b.append(this.defenderProcessesToExclude);
        b.append(", ");
        b.append("defenderPromptForSampleSubmission=");
        b.append(this.defenderPromptForSampleSubmission);
        b.append(", ");
        b.append("defenderRequireBehaviorMonitoring=");
        b.append(this.defenderRequireBehaviorMonitoring);
        b.append(", ");
        b.append("defenderRequireCloudProtection=");
        b.append(this.defenderRequireCloudProtection);
        b.append(", ");
        b.append("defenderRequireNetworkInspectionSystem=");
        b.append(this.defenderRequireNetworkInspectionSystem);
        b.append(", ");
        b.append("defenderRequireRealTimeMonitoring=");
        b.append(this.defenderRequireRealTimeMonitoring);
        b.append(", ");
        b.append("defenderScanArchiveFiles=");
        b.append(this.defenderScanArchiveFiles);
        b.append(", ");
        b.append("defenderScanDownloads=");
        b.append(this.defenderScanDownloads);
        b.append(", ");
        b.append("defenderScanIncomingMail=");
        b.append(this.defenderScanIncomingMail);
        b.append(", ");
        b.append("defenderScanMappedNetworkDrivesDuringFullScan=");
        b.append(this.defenderScanMappedNetworkDrivesDuringFullScan);
        b.append(", ");
        b.append("defenderScanMaxCpu=");
        b.append(this.defenderScanMaxCpu);
        b.append(", ");
        b.append("defenderScanNetworkFiles=");
        b.append(this.defenderScanNetworkFiles);
        b.append(", ");
        b.append("defenderScanRemovableDrivesDuringFullScan=");
        b.append(this.defenderScanRemovableDrivesDuringFullScan);
        b.append(", ");
        b.append("defenderScanScriptsLoadedInInternetExplorer=");
        b.append(this.defenderScanScriptsLoadedInInternetExplorer);
        b.append(", ");
        b.append("defenderScanType=");
        b.append(this.defenderScanType);
        b.append(", ");
        b.append("defenderScheduledQuickScanTime=");
        b.append(this.defenderScheduledQuickScanTime);
        b.append(", ");
        b.append("defenderScheduledScanTime=");
        b.append(this.defenderScheduledScanTime);
        b.append(", ");
        b.append("defenderScheduleScanEnableLowCpuPriority=");
        b.append(this.defenderScheduleScanEnableLowCpuPriority);
        b.append(", ");
        b.append("defenderSignatureUpdateIntervalInHours=");
        b.append(this.defenderSignatureUpdateIntervalInHours);
        b.append(", ");
        b.append("defenderSubmitSamplesConsentType=");
        b.append(this.defenderSubmitSamplesConsentType);
        b.append(", ");
        b.append("defenderSystemScanSchedule=");
        b.append(this.defenderSystemScanSchedule);
        b.append(", ");
        b.append("developerUnlockSetting=");
        b.append(this.developerUnlockSetting);
        b.append(", ");
        b.append("deviceManagementBlockFactoryResetOnMobile=");
        b.append(this.deviceManagementBlockFactoryResetOnMobile);
        b.append(", ");
        b.append("deviceManagementBlockManualUnenroll=");
        b.append(this.deviceManagementBlockManualUnenroll);
        b.append(", ");
        b.append("diagnosticsDataSubmissionMode=");
        b.append(this.diagnosticsDataSubmissionMode);
        b.append(", ");
        b.append("displayAppListWithGdiDPIScalingTurnedOff=");
        b.append(this.displayAppListWithGdiDPIScalingTurnedOff);
        b.append(", ");
        b.append("displayAppListWithGdiDPIScalingTurnedOn=");
        b.append(this.displayAppListWithGdiDPIScalingTurnedOn);
        b.append(", ");
        b.append("edgeAllowStartPagesModification=");
        b.append(this.edgeAllowStartPagesModification);
        b.append(", ");
        b.append("edgeBlockAccessToAboutFlags=");
        b.append(this.edgeBlockAccessToAboutFlags);
        b.append(", ");
        b.append("edgeBlockAddressBarDropdown=");
        b.append(this.edgeBlockAddressBarDropdown);
        b.append(", ");
        b.append("edgeBlockAutofill=");
        b.append(this.edgeBlockAutofill);
        b.append(", ");
        b.append("edgeBlockCompatibilityList=");
        b.append(this.edgeBlockCompatibilityList);
        b.append(", ");
        b.append("edgeBlockDeveloperTools=");
        b.append(this.edgeBlockDeveloperTools);
        b.append(", ");
        b.append("edgeBlocked=");
        b.append(this.edgeBlocked);
        b.append(", ");
        b.append("edgeBlockEditFavorites=");
        b.append(this.edgeBlockEditFavorites);
        b.append(", ");
        b.append("edgeBlockExtensions=");
        b.append(this.edgeBlockExtensions);
        b.append(", ");
        b.append("edgeBlockFullScreenMode=");
        b.append(this.edgeBlockFullScreenMode);
        b.append(", ");
        b.append("edgeBlockInPrivateBrowsing=");
        b.append(this.edgeBlockInPrivateBrowsing);
        b.append(", ");
        b.append("edgeBlockJavaScript=");
        b.append(this.edgeBlockJavaScript);
        b.append(", ");
        b.append("edgeBlockLiveTileDataCollection=");
        b.append(this.edgeBlockLiveTileDataCollection);
        b.append(", ");
        b.append("edgeBlockPasswordManager=");
        b.append(this.edgeBlockPasswordManager);
        b.append(", ");
        b.append("edgeBlockPopups=");
        b.append(this.edgeBlockPopups);
        b.append(", ");
        b.append("edgeBlockPrelaunch=");
        b.append(this.edgeBlockPrelaunch);
        b.append(", ");
        b.append("edgeBlockPrinting=");
        b.append(this.edgeBlockPrinting);
        b.append(", ");
        b.append("edgeBlockSavingHistory=");
        b.append(this.edgeBlockSavingHistory);
        b.append(", ");
        b.append("edgeBlockSearchEngineCustomization=");
        b.append(this.edgeBlockSearchEngineCustomization);
        b.append(", ");
        b.append("edgeBlockSearchSuggestions=");
        b.append(this.edgeBlockSearchSuggestions);
        b.append(", ");
        b.append("edgeBlockSendingDoNotTrackHeader=");
        b.append(this.edgeBlockSendingDoNotTrackHeader);
        b.append(", ");
        b.append("edgeBlockSendingIntranetTrafficToInternetExplorer=");
        b.append(this.edgeBlockSendingIntranetTrafficToInternetExplorer);
        b.append(", ");
        b.append("edgeBlockSideloadingExtensions=");
        b.append(this.edgeBlockSideloadingExtensions);
        b.append(", ");
        b.append("edgeBlockTabPreloading=");
        b.append(this.edgeBlockTabPreloading);
        b.append(", ");
        b.append("edgeBlockWebContentOnNewTabPage=");
        b.append(this.edgeBlockWebContentOnNewTabPage);
        b.append(", ");
        b.append("edgeClearBrowsingDataOnExit=");
        b.append(this.edgeClearBrowsingDataOnExit);
        b.append(", ");
        b.append("edgeCookiePolicy=");
        b.append(this.edgeCookiePolicy);
        b.append(", ");
        b.append("edgeDisableFirstRunPage=");
        b.append(this.edgeDisableFirstRunPage);
        b.append(", ");
        b.append("edgeEnterpriseModeSiteListLocation=");
        b.append(this.edgeEnterpriseModeSiteListLocation);
        b.append(", ");
        b.append("edgeFavoritesBarVisibility=");
        b.append(this.edgeFavoritesBarVisibility);
        b.append(", ");
        b.append("edgeFavoritesListLocation=");
        b.append(this.edgeFavoritesListLocation);
        b.append(", ");
        b.append("edgeFirstRunUrl=");
        b.append(this.edgeFirstRunUrl);
        b.append(", ");
        b.append("edgeHomeButtonConfiguration=");
        b.append(this.edgeHomeButtonConfiguration);
        b.append(", ");
        b.append("edgeHomeButtonConfigurationEnabled=");
        b.append(this.edgeHomeButtonConfigurationEnabled);
        b.append(", ");
        b.append("edgeHomepageUrls=");
        b.append(this.edgeHomepageUrls);
        b.append(", ");
        b.append("edgeKioskModeRestriction=");
        b.append(this.edgeKioskModeRestriction);
        b.append(", ");
        b.append("edgeKioskResetAfterIdleTimeInMinutes=");
        b.append(this.edgeKioskResetAfterIdleTimeInMinutes);
        b.append(", ");
        b.append("edgeNewTabPageURL=");
        b.append(this.edgeNewTabPageURL);
        b.append(", ");
        b.append("edgeOpensWith=");
        b.append(this.edgeOpensWith);
        b.append(", ");
        b.append("edgePreventCertificateErrorOverride=");
        b.append(this.edgePreventCertificateErrorOverride);
        b.append(", ");
        b.append("edgeRequiredExtensionPackageFamilyNames=");
        b.append(this.edgeRequiredExtensionPackageFamilyNames);
        b.append(", ");
        b.append("edgeRequireSmartScreen=");
        b.append(this.edgeRequireSmartScreen);
        b.append(", ");
        b.append("edgeSearchEngine=");
        b.append(this.edgeSearchEngine);
        b.append(", ");
        b.append("edgeSendIntranetTrafficToInternetExplorer=");
        b.append(this.edgeSendIntranetTrafficToInternetExplorer);
        b.append(", ");
        b.append("edgeShowMessageWhenOpeningInternetExplorerSites=");
        b.append(this.edgeShowMessageWhenOpeningInternetExplorerSites);
        b.append(", ");
        b.append("edgeSyncFavoritesWithInternetExplorer=");
        b.append(this.edgeSyncFavoritesWithInternetExplorer);
        b.append(", ");
        b.append("edgeTelemetryForMicrosoft365Analytics=");
        b.append(this.edgeTelemetryForMicrosoft365Analytics);
        b.append(", ");
        b.append("enableAutomaticRedeployment=");
        b.append(this.enableAutomaticRedeployment);
        b.append(", ");
        b.append("energySaverOnBatteryThresholdPercentage=");
        b.append(this.energySaverOnBatteryThresholdPercentage);
        b.append(", ");
        b.append("energySaverPluggedInThresholdPercentage=");
        b.append(this.energySaverPluggedInThresholdPercentage);
        b.append(", ");
        b.append("enterpriseCloudPrintDiscoveryEndPoint=");
        b.append(this.enterpriseCloudPrintDiscoveryEndPoint);
        b.append(", ");
        b.append("enterpriseCloudPrintDiscoveryMaxLimit=");
        b.append(this.enterpriseCloudPrintDiscoveryMaxLimit);
        b.append(", ");
        b.append("enterpriseCloudPrintMopriaDiscoveryResourceIdentifier=");
        b.append(this.enterpriseCloudPrintMopriaDiscoveryResourceIdentifier);
        b.append(", ");
        b.append("enterpriseCloudPrintOAuthAuthority=");
        b.append(this.enterpriseCloudPrintOAuthAuthority);
        b.append(", ");
        b.append("enterpriseCloudPrintOAuthClientIdentifier=");
        b.append(this.enterpriseCloudPrintOAuthClientIdentifier);
        b.append(", ");
        b.append("enterpriseCloudPrintResourceIdentifier=");
        b.append(this.enterpriseCloudPrintResourceIdentifier);
        b.append(", ");
        b.append("experienceBlockDeviceDiscovery=");
        b.append(this.experienceBlockDeviceDiscovery);
        b.append(", ");
        b.append("experienceBlockErrorDialogWhenNoSIM=");
        b.append(this.experienceBlockErrorDialogWhenNoSIM);
        b.append(", ");
        b.append("experienceBlockTaskSwitcher=");
        b.append(this.experienceBlockTaskSwitcher);
        b.append(", ");
        b.append("experienceDoNotSyncBrowserSettings=");
        b.append(this.experienceDoNotSyncBrowserSettings);
        b.append(", ");
        b.append("findMyFiles=");
        b.append(this.findMyFiles);
        b.append(", ");
        b.append("gameDvrBlocked=");
        b.append(this.gameDvrBlocked);
        b.append(", ");
        b.append("inkWorkspaceAccess=");
        b.append(this.inkWorkspaceAccess);
        b.append(", ");
        b.append("inkWorkspaceAccessState=");
        b.append(this.inkWorkspaceAccessState);
        b.append(", ");
        b.append("inkWorkspaceBlockSuggestedApps=");
        b.append(this.inkWorkspaceBlockSuggestedApps);
        b.append(", ");
        b.append("internetSharingBlocked=");
        b.append(this.internetSharingBlocked);
        b.append(", ");
        b.append("locationServicesBlocked=");
        b.append(this.locationServicesBlocked);
        b.append(", ");
        b.append("lockScreenActivateAppsWithVoice=");
        b.append(this.lockScreenActivateAppsWithVoice);
        b.append(", ");
        b.append("lockScreenAllowTimeoutConfiguration=");
        b.append(this.lockScreenAllowTimeoutConfiguration);
        b.append(", ");
        b.append("lockScreenBlockActionCenterNotifications=");
        b.append(this.lockScreenBlockActionCenterNotifications);
        b.append(", ");
        b.append("lockScreenBlockCortana=");
        b.append(this.lockScreenBlockCortana);
        b.append(", ");
        b.append("lockScreenBlockToastNotifications=");
        b.append(this.lockScreenBlockToastNotifications);
        b.append(", ");
        b.append("lockScreenTimeoutInSeconds=");
        b.append(this.lockScreenTimeoutInSeconds);
        b.append(", ");
        b.append("logonBlockFastUserSwitching=");
        b.append(this.logonBlockFastUserSwitching);
        b.append(", ");
        b.append("messagingBlockMMS=");
        b.append(this.messagingBlockMMS);
        b.append(", ");
        b.append("messagingBlockRichCommunicationServices=");
        b.append(this.messagingBlockRichCommunicationServices);
        b.append(", ");
        b.append("messagingBlockSync=");
        b.append(this.messagingBlockSync);
        b.append(", ");
        b.append("microsoftAccountBlocked=");
        b.append(this.microsoftAccountBlocked);
        b.append(", ");
        b.append("microsoftAccountBlockSettingsSync=");
        b.append(this.microsoftAccountBlockSettingsSync);
        b.append(", ");
        b.append("microsoftAccountSignInAssistantSettings=");
        b.append(this.microsoftAccountSignInAssistantSettings);
        b.append(", ");
        b.append("networkProxyApplySettingsDeviceWide=");
        b.append(this.networkProxyApplySettingsDeviceWide);
        b.append(", ");
        b.append("networkProxyAutomaticConfigurationUrl=");
        b.append(this.networkProxyAutomaticConfigurationUrl);
        b.append(", ");
        b.append("networkProxyDisableAutoDetect=");
        b.append(this.networkProxyDisableAutoDetect);
        b.append(", ");
        b.append("networkProxyServer=");
        b.append(this.networkProxyServer);
        b.append(", ");
        b.append("nfcBlocked=");
        b.append(this.nfcBlocked);
        b.append(", ");
        b.append("oneDriveDisableFileSync=");
        b.append(this.oneDriveDisableFileSync);
        b.append(", ");
        b.append("passwordBlockSimple=");
        b.append(this.passwordBlockSimple);
        b.append(", ");
        b.append("passwordExpirationDays=");
        b.append(this.passwordExpirationDays);
        b.append(", ");
        b.append("passwordMinimumAgeInDays=");
        b.append(this.passwordMinimumAgeInDays);
        b.append(", ");
        b.append("passwordMinimumCharacterSetCount=");
        b.append(this.passwordMinimumCharacterSetCount);
        b.append(", ");
        b.append("passwordMinimumLength=");
        b.append(this.passwordMinimumLength);
        b.append(", ");
        b.append("passwordMinutesOfInactivityBeforeScreenTimeout=");
        b.append(this.passwordMinutesOfInactivityBeforeScreenTimeout);
        b.append(", ");
        b.append("passwordPreviousPasswordBlockCount=");
        b.append(this.passwordPreviousPasswordBlockCount);
        b.append(", ");
        b.append("passwordRequired=");
        b.append(this.passwordRequired);
        b.append(", ");
        b.append("passwordRequiredType=");
        b.append(this.passwordRequiredType);
        b.append(", ");
        b.append("passwordRequireWhenResumeFromIdleState=");
        b.append(this.passwordRequireWhenResumeFromIdleState);
        b.append(", ");
        b.append("passwordSignInFailureCountBeforeFactoryReset=");
        b.append(this.passwordSignInFailureCountBeforeFactoryReset);
        b.append(", ");
        b.append("personalizationDesktopImageUrl=");
        b.append(this.personalizationDesktopImageUrl);
        b.append(", ");
        b.append("personalizationLockScreenImageUrl=");
        b.append(this.personalizationLockScreenImageUrl);
        b.append(", ");
        b.append("powerButtonActionOnBattery=");
        b.append(this.powerButtonActionOnBattery);
        b.append(", ");
        b.append("powerButtonActionPluggedIn=");
        b.append(this.powerButtonActionPluggedIn);
        b.append(", ");
        b.append("powerHybridSleepOnBattery=");
        b.append(this.powerHybridSleepOnBattery);
        b.append(", ");
        b.append("powerHybridSleepPluggedIn=");
        b.append(this.powerHybridSleepPluggedIn);
        b.append(", ");
        b.append("powerLidCloseActionOnBattery=");
        b.append(this.powerLidCloseActionOnBattery);
        b.append(", ");
        b.append("powerLidCloseActionPluggedIn=");
        b.append(this.powerLidCloseActionPluggedIn);
        b.append(", ");
        b.append("powerSleepButtonActionOnBattery=");
        b.append(this.powerSleepButtonActionOnBattery);
        b.append(", ");
        b.append("powerSleepButtonActionPluggedIn=");
        b.append(this.powerSleepButtonActionPluggedIn);
        b.append(", ");
        b.append("printerBlockAddition=");
        b.append(this.printerBlockAddition);
        b.append(", ");
        b.append("printerDefaultName=");
        b.append(this.printerDefaultName);
        b.append(", ");
        b.append("printerNames=");
        b.append(this.printerNames);
        b.append(", ");
        b.append("privacyAdvertisingId=");
        b.append(this.privacyAdvertisingId);
        b.append(", ");
        b.append("privacyAutoAcceptPairingAndConsentPrompts=");
        b.append(this.privacyAutoAcceptPairingAndConsentPrompts);
        b.append(", ");
        b.append("privacyBlockActivityFeed=");
        b.append(this.privacyBlockActivityFeed);
        b.append(", ");
        b.append("privacyBlockInputPersonalization=");
        b.append(this.privacyBlockInputPersonalization);
        b.append(", ");
        b.append("privacyBlockPublishUserActivities=");
        b.append(this.privacyBlockPublishUserActivities);
        b.append(", ");
        b.append("privacyDisableLaunchExperience=");
        b.append(this.privacyDisableLaunchExperience);
        b.append(", ");
        b.append("resetProtectionModeBlocked=");
        b.append(this.resetProtectionModeBlocked);
        b.append(", ");
        b.append("safeSearchFilter=");
        b.append(this.safeSearchFilter);
        b.append(", ");
        b.append("screenCaptureBlocked=");
        b.append(this.screenCaptureBlocked);
        b.append(", ");
        b.append("searchBlockDiacritics=");
        b.append(this.searchBlockDiacritics);
        b.append(", ");
        b.append("searchBlockWebResults=");
        b.append(this.searchBlockWebResults);
        b.append(", ");
        b.append("searchDisableAutoLanguageDetection=");
        b.append(this.searchDisableAutoLanguageDetection);
        b.append(", ");
        b.append("searchDisableIndexerBackoff=");
        b.append(this.searchDisableIndexerBackoff);
        b.append(", ");
        b.append("searchDisableIndexingEncryptedItems=");
        b.append(this.searchDisableIndexingEncryptedItems);
        b.append(", ");
        b.append("searchDisableIndexingRemovableDrive=");
        b.append(this.searchDisableIndexingRemovableDrive);
        b.append(", ");
        b.append("searchDisableLocation=");
        b.append(this.searchDisableLocation);
        b.append(", ");
        b.append("searchDisableUseLocation=");
        b.append(this.searchDisableUseLocation);
        b.append(", ");
        b.append("searchEnableAutomaticIndexSizeManangement=");
        b.append(this.searchEnableAutomaticIndexSizeManangement);
        b.append(", ");
        b.append("searchEnableRemoteQueries=");
        b.append(this.searchEnableRemoteQueries);
        b.append(", ");
        b.append("securityBlockAzureADJoinedDevicesAutoEncryption=");
        b.append(this.securityBlockAzureADJoinedDevicesAutoEncryption);
        b.append(", ");
        b.append("settingsBlockAccountsPage=");
        b.append(this.settingsBlockAccountsPage);
        b.append(", ");
        b.append("settingsBlockAddProvisioningPackage=");
        b.append(this.settingsBlockAddProvisioningPackage);
        b.append(", ");
        b.append("settingsBlockAppsPage=");
        b.append(this.settingsBlockAppsPage);
        b.append(", ");
        b.append("settingsBlockChangeLanguage=");
        b.append(this.settingsBlockChangeLanguage);
        b.append(", ");
        b.append("settingsBlockChangePowerSleep=");
        b.append(this.settingsBlockChangePowerSleep);
        b.append(", ");
        b.append("settingsBlockChangeRegion=");
        b.append(this.settingsBlockChangeRegion);
        b.append(", ");
        b.append("settingsBlockChangeSystemTime=");
        b.append(this.settingsBlockChangeSystemTime);
        b.append(", ");
        b.append("settingsBlockDevicesPage=");
        b.append(this.settingsBlockDevicesPage);
        b.append(", ");
        b.append("settingsBlockEaseOfAccessPage=");
        b.append(this.settingsBlockEaseOfAccessPage);
        b.append(", ");
        b.append("settingsBlockEditDeviceName=");
        b.append(this.settingsBlockEditDeviceName);
        b.append(", ");
        b.append("settingsBlockGamingPage=");
        b.append(this.settingsBlockGamingPage);
        b.append(", ");
        b.append("settingsBlockNetworkInternetPage=");
        b.append(this.settingsBlockNetworkInternetPage);
        b.append(", ");
        b.append("settingsBlockPersonalizationPage=");
        b.append(this.settingsBlockPersonalizationPage);
        b.append(", ");
        b.append("settingsBlockPrivacyPage=");
        b.append(this.settingsBlockPrivacyPage);
        b.append(", ");
        b.append("settingsBlockRemoveProvisioningPackage=");
        b.append(this.settingsBlockRemoveProvisioningPackage);
        b.append(", ");
        b.append("settingsBlockSettingsApp=");
        b.append(this.settingsBlockSettingsApp);
        b.append(", ");
        b.append("settingsBlockSystemPage=");
        b.append(this.settingsBlockSystemPage);
        b.append(", ");
        b.append("settingsBlockTimeLanguagePage=");
        b.append(this.settingsBlockTimeLanguagePage);
        b.append(", ");
        b.append("settingsBlockUpdateSecurityPage=");
        b.append(this.settingsBlockUpdateSecurityPage);
        b.append(", ");
        b.append("sharedUserAppDataAllowed=");
        b.append(this.sharedUserAppDataAllowed);
        b.append(", ");
        b.append("smartScreenAppInstallControl=");
        b.append(this.smartScreenAppInstallControl);
        b.append(", ");
        b.append("smartScreenBlockPromptOverride=");
        b.append(this.smartScreenBlockPromptOverride);
        b.append(", ");
        b.append("smartScreenBlockPromptOverrideForFiles=");
        b.append(this.smartScreenBlockPromptOverrideForFiles);
        b.append(", ");
        b.append("smartScreenEnableAppInstallControl=");
        b.append(this.smartScreenEnableAppInstallControl);
        b.append(", ");
        b.append("startBlockUnpinningAppsFromTaskbar=");
        b.append(this.startBlockUnpinningAppsFromTaskbar);
        b.append(", ");
        b.append("startMenuAppListVisibility=");
        b.append(this.startMenuAppListVisibility);
        b.append(", ");
        b.append("startMenuHideChangeAccountSettings=");
        b.append(this.startMenuHideChangeAccountSettings);
        b.append(", ");
        b.append("startMenuHideFrequentlyUsedApps=");
        b.append(this.startMenuHideFrequentlyUsedApps);
        b.append(", ");
        b.append("startMenuHideHibernate=");
        b.append(this.startMenuHideHibernate);
        b.append(", ");
        b.append("startMenuHideLock=");
        b.append(this.startMenuHideLock);
        b.append(", ");
        b.append("startMenuHidePowerButton=");
        b.append(this.startMenuHidePowerButton);
        b.append(", ");
        b.append("startMenuHideRecentJumpLists=");
        b.append(this.startMenuHideRecentJumpLists);
        b.append(", ");
        b.append("startMenuHideRecentlyAddedApps=");
        b.append(this.startMenuHideRecentlyAddedApps);
        b.append(", ");
        b.append("startMenuHideRestartOptions=");
        b.append(this.startMenuHideRestartOptions);
        b.append(", ");
        b.append("startMenuHideShutDown=");
        b.append(this.startMenuHideShutDown);
        b.append(", ");
        b.append("startMenuHideSignOut=");
        b.append(this.startMenuHideSignOut);
        b.append(", ");
        b.append("startMenuHideSleep=");
        b.append(this.startMenuHideSleep);
        b.append(", ");
        b.append("startMenuHideSwitchAccount=");
        b.append(this.startMenuHideSwitchAccount);
        b.append(", ");
        b.append("startMenuHideUserTile=");
        b.append(this.startMenuHideUserTile);
        b.append(", ");
        b.append("startMenuLayoutEdgeAssetsXml=");
        b.append(this.startMenuLayoutEdgeAssetsXml);
        b.append(", ");
        b.append("startMenuLayoutXml=");
        b.append(this.startMenuLayoutXml);
        b.append(", ");
        b.append("startMenuMode=");
        b.append(this.startMenuMode);
        b.append(", ");
        b.append("startMenuPinnedFolderDocuments=");
        b.append(this.startMenuPinnedFolderDocuments);
        b.append(", ");
        b.append("startMenuPinnedFolderDownloads=");
        b.append(this.startMenuPinnedFolderDownloads);
        b.append(", ");
        b.append("startMenuPinnedFolderFileExplorer=");
        b.append(this.startMenuPinnedFolderFileExplorer);
        b.append(", ");
        b.append("startMenuPinnedFolderHomeGroup=");
        b.append(this.startMenuPinnedFolderHomeGroup);
        b.append(", ");
        b.append("startMenuPinnedFolderMusic=");
        b.append(this.startMenuPinnedFolderMusic);
        b.append(", ");
        b.append("startMenuPinnedFolderNetwork=");
        b.append(this.startMenuPinnedFolderNetwork);
        b.append(", ");
        b.append("startMenuPinnedFolderPersonalFolder=");
        b.append(this.startMenuPinnedFolderPersonalFolder);
        b.append(", ");
        b.append("startMenuPinnedFolderPictures=");
        b.append(this.startMenuPinnedFolderPictures);
        b.append(", ");
        b.append("startMenuPinnedFolderSettings=");
        b.append(this.startMenuPinnedFolderSettings);
        b.append(", ");
        b.append("startMenuPinnedFolderVideos=");
        b.append(this.startMenuPinnedFolderVideos);
        b.append(", ");
        b.append("storageBlockRemovableStorage=");
        b.append(this.storageBlockRemovableStorage);
        b.append(", ");
        b.append("storageRequireMobileDeviceEncryption=");
        b.append(this.storageRequireMobileDeviceEncryption);
        b.append(", ");
        b.append("storageRestrictAppDataToSystemVolume=");
        b.append(this.storageRestrictAppDataToSystemVolume);
        b.append(", ");
        b.append("storageRestrictAppInstallToSystemVolume=");
        b.append(this.storageRestrictAppInstallToSystemVolume);
        b.append(", ");
        b.append("systemTelemetryProxyServer=");
        b.append(this.systemTelemetryProxyServer);
        b.append(", ");
        b.append("taskManagerBlockEndTask=");
        b.append(this.taskManagerBlockEndTask);
        b.append(", ");
        b.append("tenantLockdownRequireNetworkDuringOutOfBoxExperience=");
        b.append(this.tenantLockdownRequireNetworkDuringOutOfBoxExperience);
        b.append(", ");
        b.append("uninstallBuiltInApps=");
        b.append(this.uninstallBuiltInApps);
        b.append(", ");
        b.append("usbBlocked=");
        b.append(this.usbBlocked);
        b.append(", ");
        b.append("voiceRecordingBlocked=");
        b.append(this.voiceRecordingBlocked);
        b.append(", ");
        b.append("webRtcBlockLocalhostIpAddress=");
        b.append(this.webRtcBlockLocalhostIpAddress);
        b.append(", ");
        b.append("wiFiBlockAutomaticConnectHotspots=");
        b.append(this.wiFiBlockAutomaticConnectHotspots);
        b.append(", ");
        b.append("wiFiBlocked=");
        b.append(this.wiFiBlocked);
        b.append(", ");
        b.append("wiFiBlockManualConfiguration=");
        b.append(this.wiFiBlockManualConfiguration);
        b.append(", ");
        b.append("wiFiScanInterval=");
        b.append(this.wiFiScanInterval);
        b.append(", ");
        b.append("windows10AppsForceUpdateSchedule=");
        b.append(this.windows10AppsForceUpdateSchedule);
        b.append(", ");
        b.append("windowsSpotlightBlockConsumerSpecificFeatures=");
        b.append(this.windowsSpotlightBlockConsumerSpecificFeatures);
        b.append(", ");
        b.append("windowsSpotlightBlocked=");
        b.append(this.windowsSpotlightBlocked);
        b.append(", ");
        b.append("windowsSpotlightBlockOnActionCenter=");
        b.append(this.windowsSpotlightBlockOnActionCenter);
        b.append(", ");
        b.append("windowsSpotlightBlockTailoredExperiences=");
        b.append(this.windowsSpotlightBlockTailoredExperiences);
        b.append(", ");
        b.append("windowsSpotlightBlockThirdPartyNotifications=");
        b.append(this.windowsSpotlightBlockThirdPartyNotifications);
        b.append(", ");
        b.append("windowsSpotlightBlockWelcomeExperience=");
        b.append(this.windowsSpotlightBlockWelcomeExperience);
        b.append(", ");
        b.append("windowsSpotlightBlockWindowsTips=");
        b.append(this.windowsSpotlightBlockWindowsTips);
        b.append(", ");
        b.append("windowsSpotlightConfigureOnLockScreen=");
        b.append(this.windowsSpotlightConfigureOnLockScreen);
        b.append(", ");
        b.append("windowsStoreBlockAutoUpdate=");
        b.append(this.windowsStoreBlockAutoUpdate);
        b.append(", ");
        b.append("windowsStoreBlocked=");
        b.append(this.windowsStoreBlocked);
        b.append(", ");
        b.append("windowsStoreEnablePrivateStoreOnly=");
        b.append(this.windowsStoreEnablePrivateStoreOnly);
        b.append(", ");
        b.append("wirelessDisplayBlockProjectionToThisDevice=");
        b.append(this.wirelessDisplayBlockProjectionToThisDevice);
        b.append(", ");
        b.append("wirelessDisplayBlockUserInputFromReceiver=");
        b.append(this.wirelessDisplayBlockUserInputFromReceiver);
        b.append(", ");
        b.append("wirelessDisplayRequirePinForPairing=");
        b.append(this.wirelessDisplayRequirePinForPairing);
        b.append(", ");
        b.append("privacyAccessControls=");
        b.append(this.privacyAccessControls);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
