package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.BitLockerFixedDrivePolicy;
import odata.msgraph.client.beta.complex.BitLockerRemovableDrivePolicy;
import odata.msgraph.client.beta.complex.BitLockerSystemDrivePolicy;
import odata.msgraph.client.beta.complex.DefenderDetectedMalwareActions;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.complex.DeviceManagementUserRightsSetting;
import odata.msgraph.client.beta.complex.WindowsFirewallNetworkProfile;
import odata.msgraph.client.beta.complex.WindowsFirewallRule;
import odata.msgraph.client.beta.enums.AppLockerApplicationControlType;
import odata.msgraph.client.beta.enums.ApplicationGuardBlockClipboardSharingType;
import odata.msgraph.client.beta.enums.ApplicationGuardBlockFileTransferType;
import odata.msgraph.client.beta.enums.ApplicationGuardEnabledOptions;
import odata.msgraph.client.beta.enums.BitLockerRecoveryPasswordRotationType;
import odata.msgraph.client.beta.enums.DefenderAttackSurfaceType;
import odata.msgraph.client.beta.enums.DefenderCloudBlockLevelType;
import odata.msgraph.client.beta.enums.DefenderProtectionType;
import odata.msgraph.client.beta.enums.DefenderRealtimeScanDirection;
import odata.msgraph.client.beta.enums.DefenderScanType;
import odata.msgraph.client.beta.enums.DefenderSecurityCenterITContactDisplayType;
import odata.msgraph.client.beta.enums.DefenderSecurityCenterNotificationsFromAppType;
import odata.msgraph.client.beta.enums.DefenderSubmitSamplesConsentType;
import odata.msgraph.client.beta.enums.DeviceGuardLocalSystemAuthorityCredentialGuardType;
import odata.msgraph.client.beta.enums.DmaGuardDeviceEnumerationPolicyType;
import odata.msgraph.client.beta.enums.Enablement;
import odata.msgraph.client.beta.enums.FirewallCertificateRevocationListCheckMethodType;
import odata.msgraph.client.beta.enums.FirewallPacketQueueingMethodType;
import odata.msgraph.client.beta.enums.FirewallPreSharedKeyEncodingMethodType;
import odata.msgraph.client.beta.enums.FolderProtectionType;
import odata.msgraph.client.beta.enums.LanManagerAuthenticationLevel;
import odata.msgraph.client.beta.enums.LocalSecurityOptionsAdministratorElevationPromptBehaviorType;
import odata.msgraph.client.beta.enums.LocalSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUserType;
import odata.msgraph.client.beta.enums.LocalSecurityOptionsInformationDisplayedOnLockScreenType;
import odata.msgraph.client.beta.enums.LocalSecurityOptionsInformationShownOnLockScreenType;
import odata.msgraph.client.beta.enums.LocalSecurityOptionsMinimumSessionSecurity;
import odata.msgraph.client.beta.enums.LocalSecurityOptionsSmartCardRemovalBehaviorType;
import odata.msgraph.client.beta.enums.LocalSecurityOptionsStandardUserElevationPromptBehaviorType;
import odata.msgraph.client.beta.enums.SecureBootWithDMAType;
import odata.msgraph.client.beta.enums.ServiceStartType;
import odata.msgraph.client.beta.enums.WeeklySchedule;
import odata.msgraph.client.beta.enums.WindowsDefenderTamperProtectionOptions;


/**
 * <i>“This topic provides descriptions of the declared methods, properties and
 * relationships exposed by the Windows10EndpointProtectionConfiguration resource.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "applicationGuardAllowCameraMicrophoneRedirection", 
    "applicationGuardAllowFileSaveOnHost", 
    "applicationGuardAllowPersistence", 
    "applicationGuardAllowPrintToLocalPrinters", 
    "applicationGuardAllowPrintToNetworkPrinters", 
    "applicationGuardAllowPrintToPDF", 
    "applicationGuardAllowPrintToXPS", 
    "applicationGuardAllowVirtualGPU", 
    "applicationGuardBlockClipboardSharing", 
    "applicationGuardBlockFileTransfer", 
    "applicationGuardBlockNonEnterpriseContent", 
    "applicationGuardCertificateThumbprints", 
    "applicationGuardEnabled", 
    "applicationGuardEnabledOptions", 
    "applicationGuardForceAuditing", 
    "appLockerApplicationControl", 
    "bitLockerAllowStandardUserEncryption", 
    "bitLockerDisableWarningForOtherDiskEncryption", 
    "bitLockerEnableStorageCardEncryptionOnMobile", 
    "bitLockerEncryptDevice", 
    "bitLockerFixedDrivePolicy", 
    "bitLockerRecoveryPasswordRotation", 
    "bitLockerRemovableDrivePolicy", 
    "bitLockerSystemDrivePolicy", 
    "defenderAdditionalGuardedFolders", 
    "defenderAdobeReaderLaunchChildProcess", 
    "defenderAdvancedRansomewareProtectionType", 
    "defenderAllowBehaviorMonitoring", 
    "defenderAllowCloudProtection", 
    "defenderAllowEndUserAccess", 
    "defenderAllowIntrusionPreventionSystem", 
    "defenderAllowOnAccessProtection", 
    "defenderAllowRealTimeMonitoring", 
    "defenderAllowScanArchiveFiles", 
    "defenderAllowScanDownloads", 
    "defenderAllowScanNetworkFiles", 
    "defenderAllowScanRemovableDrivesDuringFullScan", 
    "defenderAllowScanScriptsLoadedInInternetExplorer", 
    "defenderAttackSurfaceReductionExcludedPaths", 
    "defenderBlockEndUserAccess", 
    "defenderBlockPersistenceThroughWmiType", 
    "defenderCheckForSignaturesBeforeRunningScan", 
    "defenderCloudBlockLevel", 
    "defenderCloudExtendedTimeoutInSeconds", 
    "defenderDaysBeforeDeletingQuarantinedMalware", 
    "defenderDetectedMalwareActions", 
    "defenderDisableBehaviorMonitoring", 
    "defenderDisableCatchupFullScan", 
    "defenderDisableCatchupQuickScan", 
    "defenderDisableCloudProtection", 
    "defenderDisableIntrusionPreventionSystem", 
    "defenderDisableOnAccessProtection", 
    "defenderDisableRealTimeMonitoring", 
    "defenderDisableScanArchiveFiles", 
    "defenderDisableScanDownloads", 
    "defenderDisableScanNetworkFiles", 
    "defenderDisableScanRemovableDrivesDuringFullScan", 
    "defenderDisableScanScriptsLoadedInInternetExplorer", 
    "defenderEmailContentExecution", 
    "defenderEmailContentExecutionType", 
    "defenderEnableLowCpuPriority", 
    "defenderEnableScanIncomingMail", 
    "defenderEnableScanMappedNetworkDrivesDuringFullScan", 
    "defenderExploitProtectionXml", 
    "defenderExploitProtectionXmlFileName", 
    "defenderFileExtensionsToExclude", 
    "defenderFilesAndFoldersToExclude", 
    "defenderGuardedFoldersAllowedAppPaths", 
    "defenderGuardMyFoldersType", 
    "defenderNetworkProtectionType", 
    "defenderOfficeAppsExecutableContentCreationOrLaunch", 
    "defenderOfficeAppsExecutableContentCreationOrLaunchType", 
    "defenderOfficeAppsLaunchChildProcess", 
    "defenderOfficeAppsLaunchChildProcessType", 
    "defenderOfficeAppsOtherProcessInjection", 
    "defenderOfficeAppsOtherProcessInjectionType", 
    "defenderOfficeCommunicationAppsLaunchChildProcess", 
    "defenderOfficeMacroCodeAllowWin32Imports", 
    "defenderOfficeMacroCodeAllowWin32ImportsType", 
    "defenderPotentiallyUnwantedAppAction", 
    "defenderPreventCredentialStealingType", 
    "defenderProcessCreation", 
    "defenderProcessCreationType", 
    "defenderProcessesToExclude", 
    "defenderScanDirection", 
    "defenderScanMaxCpuPercentage", 
    "defenderScanType", 
    "defenderScheduledQuickScanTime", 
    "defenderScheduledScanDay", 
    "defenderScheduledScanTime", 
    "defenderScriptDownloadedPayloadExecution", 
    "defenderScriptDownloadedPayloadExecutionType", 
    "defenderScriptObfuscatedMacroCode", 
    "defenderScriptObfuscatedMacroCodeType", 
    "defenderSecurityCenterBlockExploitProtectionOverride", 
    "defenderSecurityCenterDisableAccountUI", 
    "defenderSecurityCenterDisableAppBrowserUI", 
    "defenderSecurityCenterDisableClearTpmUI", 
    "defenderSecurityCenterDisableFamilyUI", 
    "defenderSecurityCenterDisableHardwareUI", 
    "defenderSecurityCenterDisableHealthUI", 
    "defenderSecurityCenterDisableNetworkUI", 
    "defenderSecurityCenterDisableNotificationAreaUI", 
    "defenderSecurityCenterDisableRansomwareUI", 
    "defenderSecurityCenterDisableSecureBootUI", 
    "defenderSecurityCenterDisableTroubleshootingUI", 
    "defenderSecurityCenterDisableVirusUI", 
    "defenderSecurityCenterDisableVulnerableTpmFirmwareUpdateUI", 
    "defenderSecurityCenterHelpEmail", 
    "defenderSecurityCenterHelpPhone", 
    "defenderSecurityCenterHelpURL", 
    "defenderSecurityCenterITContactDisplay", 
    "defenderSecurityCenterNotificationsFromApp", 
    "defenderSecurityCenterOrganizationDisplayName", 
    "defenderSignatureUpdateIntervalInHours", 
    "defenderSubmitSamplesConsentType", 
    "defenderUntrustedExecutable", 
    "defenderUntrustedExecutableType", 
    "defenderUntrustedUSBProcess", 
    "defenderUntrustedUSBProcessType", 
    "deviceGuardEnableSecureBootWithDMA", 
    "deviceGuardEnableVirtualizationBasedSecurity", 
    "deviceGuardLaunchSystemGuard", 
    "deviceGuardLocalSystemAuthorityCredentialGuardSettings", 
    "deviceGuardSecureBootWithDMA", 
    "dmaGuardDeviceEnumerationPolicy", 
    "firewallBlockStatefulFTP", 
    "firewallCertificateRevocationListCheckMethod", 
    "firewallIdleTimeoutForSecurityAssociationInSeconds", 
    "firewallIPSecExemptionsAllowDHCP", 
    "firewallIPSecExemptionsAllowICMP", 
    "firewallIPSecExemptionsAllowNeighborDiscovery", 
    "firewallIPSecExemptionsAllowRouterDiscovery", 
    "firewallIPSecExemptionsNone", 
    "firewallMergeKeyingModuleSettings", 
    "firewallPacketQueueingMethod", 
    "firewallPreSharedKeyEncodingMethod", 
    "firewallProfileDomain", 
    "firewallProfilePrivate", 
    "firewallProfilePublic", 
    "firewallRules", 
    "lanManagerAuthenticationLevel", 
    "lanManagerWorkstationDisableInsecureGuestLogons", 
    "localSecurityOptionsAdministratorAccountName", 
    "localSecurityOptionsAdministratorElevationPromptBehavior", 
    "localSecurityOptionsAllowAnonymousEnumerationOfSAMAccountsAndShares", 
    "localSecurityOptionsAllowPKU2UAuthenticationRequests", 
    "localSecurityOptionsAllowRemoteCallsToSecurityAccountsManager", 
    "localSecurityOptionsAllowRemoteCallsToSecurityAccountsManagerHelperBool", 
    "localSecurityOptionsAllowSystemToBeShutDownWithoutHavingToLogOn", 
    "localSecurityOptionsAllowUIAccessApplicationElevation", 
    "localSecurityOptionsAllowUIAccessApplicationsForSecureLocations", 
    "localSecurityOptionsAllowUndockWithoutHavingToLogon", 
    "localSecurityOptionsBlockMicrosoftAccounts", 
    "localSecurityOptionsBlockRemoteLogonWithBlankPassword", 
    "localSecurityOptionsBlockRemoteOpticalDriveAccess", 
    "localSecurityOptionsBlockUsersInstallingPrinterDrivers", 
    "localSecurityOptionsClearVirtualMemoryPageFile", 
    "localSecurityOptionsClientDigitallySignCommunicationsAlways", 
    "localSecurityOptionsClientSendUnencryptedPasswordToThirdPartySMBServers", 
    "localSecurityOptionsDetectApplicationInstallationsAndPromptForElevation", 
    "localSecurityOptionsDisableAdministratorAccount", 
    "localSecurityOptionsDisableClientDigitallySignCommunicationsIfServerAgrees", 
    "localSecurityOptionsDisableGuestAccount", 
    "localSecurityOptionsDisableServerDigitallySignCommunicationsAlways", 
    "localSecurityOptionsDisableServerDigitallySignCommunicationsIfClientAgrees", 
    "localSecurityOptionsDoNotAllowAnonymousEnumerationOfSAMAccounts", 
    "localSecurityOptionsDoNotRequireCtrlAltDel", 
    "localSecurityOptionsDoNotStoreLANManagerHashValueOnNextPasswordChange", 
    "localSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUser", 
    "localSecurityOptionsGuestAccountName", 
    "localSecurityOptionsHideLastSignedInUser", 
    "localSecurityOptionsHideUsernameAtSignIn", 
    "localSecurityOptionsInformationDisplayedOnLockScreen", 
    "localSecurityOptionsInformationShownOnLockScreen", 
    "localSecurityOptionsLogOnMessageText", 
    "localSecurityOptionsLogOnMessageTitle", 
    "localSecurityOptionsMachineInactivityLimit", 
    "localSecurityOptionsMachineInactivityLimitInMinutes", 
    "localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedClients", 
    "localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedServers", 
    "localSecurityOptionsOnlyElevateSignedExecutables", 
    "localSecurityOptionsRestrictAnonymousAccessToNamedPipesAndShares", 
    "localSecurityOptionsSmartCardRemovalBehavior", 
    "localSecurityOptionsStandardUserElevationPromptBehavior", 
    "localSecurityOptionsSwitchToSecureDesktopWhenPromptingForElevation", 
    "localSecurityOptionsUseAdminApprovalMode", 
    "localSecurityOptionsUseAdminApprovalModeForAdministrators", 
    "localSecurityOptionsVirtualizeFileAndRegistryWriteFailuresToPerUserLocations", 
    "smartScreenBlockOverrideForFiles", 
    "smartScreenEnableInShell", 
    "userRightsAccessCredentialManagerAsTrustedCaller", 
    "userRightsActAsPartOfTheOperatingSystem", 
    "userRightsAllowAccessFromNetwork", 
    "userRightsBackupData", 
    "userRightsBlockAccessFromNetwork", 
    "userRightsChangeSystemTime", 
    "userRightsCreateGlobalObjects", 
    "userRightsCreatePageFile", 
    "userRightsCreatePermanentSharedObjects", 
    "userRightsCreateSymbolicLinks", 
    "userRightsCreateToken", 
    "userRightsDebugPrograms", 
    "userRightsDelegation", 
    "userRightsDenyLocalLogOn", 
    "userRightsGenerateSecurityAudits", 
    "userRightsImpersonateClient", 
    "userRightsIncreaseSchedulingPriority", 
    "userRightsLoadUnloadDrivers", 
    "userRightsLocalLogOn", 
    "userRightsLockMemory", 
    "userRightsManageAuditingAndSecurityLogs", 
    "userRightsManageVolumes", 
    "userRightsModifyFirmwareEnvironment", 
    "userRightsModifyObjectLabels", 
    "userRightsProfileSingleProcess", 
    "userRightsRemoteDesktopServicesLogOn", 
    "userRightsRemoteShutdown", 
    "userRightsRestoreData", 
    "userRightsTakeOwnership", 
    "windowsDefenderTamperProtection", 
    "xboxServicesAccessoryManagementServiceStartupMode", 
    "xboxServicesEnableXboxGameSaveTask", 
    "xboxServicesLiveAuthManagerServiceStartupMode", 
    "xboxServicesLiveGameSaveServiceStartupMode", 
    "xboxServicesLiveNetworkingServiceStartupMode"})
@JsonInclude(Include.NON_NULL)
public class Windows10EndpointProtectionConfiguration extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windows10EndpointProtectionConfiguration";
    }

    @JsonProperty("applicationGuardAllowCameraMicrophoneRedirection")
    protected Boolean applicationGuardAllowCameraMicrophoneRedirection;

    @JsonProperty("applicationGuardAllowFileSaveOnHost")
    protected Boolean applicationGuardAllowFileSaveOnHost;

    @JsonProperty("applicationGuardAllowPersistence")
    protected Boolean applicationGuardAllowPersistence;

    @JsonProperty("applicationGuardAllowPrintToLocalPrinters")
    protected Boolean applicationGuardAllowPrintToLocalPrinters;

    @JsonProperty("applicationGuardAllowPrintToNetworkPrinters")
    protected Boolean applicationGuardAllowPrintToNetworkPrinters;

    @JsonProperty("applicationGuardAllowPrintToPDF")
    protected Boolean applicationGuardAllowPrintToPDF;

    @JsonProperty("applicationGuardAllowPrintToXPS")
    protected Boolean applicationGuardAllowPrintToXPS;

    @JsonProperty("applicationGuardAllowVirtualGPU")
    protected Boolean applicationGuardAllowVirtualGPU;

    @JsonProperty("applicationGuardBlockClipboardSharing")
    protected ApplicationGuardBlockClipboardSharingType applicationGuardBlockClipboardSharing;

    @JsonProperty("applicationGuardBlockFileTransfer")
    protected ApplicationGuardBlockFileTransferType applicationGuardBlockFileTransfer;

    @JsonProperty("applicationGuardBlockNonEnterpriseContent")
    protected Boolean applicationGuardBlockNonEnterpriseContent;

    @JsonProperty("applicationGuardCertificateThumbprints")
    protected List<String> applicationGuardCertificateThumbprints;

    @JsonProperty("applicationGuardCertificateThumbprints@nextLink")
    protected String applicationGuardCertificateThumbprintsNextLink;

    @JsonProperty("applicationGuardEnabled")
    protected Boolean applicationGuardEnabled;

    @JsonProperty("applicationGuardEnabledOptions")
    protected ApplicationGuardEnabledOptions applicationGuardEnabledOptions;

    @JsonProperty("applicationGuardForceAuditing")
    protected Boolean applicationGuardForceAuditing;

    @JsonProperty("appLockerApplicationControl")
    protected AppLockerApplicationControlType appLockerApplicationControl;

    @JsonProperty("bitLockerAllowStandardUserEncryption")
    protected Boolean bitLockerAllowStandardUserEncryption;

    @JsonProperty("bitLockerDisableWarningForOtherDiskEncryption")
    protected Boolean bitLockerDisableWarningForOtherDiskEncryption;

    @JsonProperty("bitLockerEnableStorageCardEncryptionOnMobile")
    protected Boolean bitLockerEnableStorageCardEncryptionOnMobile;

    @JsonProperty("bitLockerEncryptDevice")
    protected Boolean bitLockerEncryptDevice;

    @JsonProperty("bitLockerFixedDrivePolicy")
    protected BitLockerFixedDrivePolicy bitLockerFixedDrivePolicy;

    @JsonProperty("bitLockerRecoveryPasswordRotation")
    protected BitLockerRecoveryPasswordRotationType bitLockerRecoveryPasswordRotation;

    @JsonProperty("bitLockerRemovableDrivePolicy")
    protected BitLockerRemovableDrivePolicy bitLockerRemovableDrivePolicy;

    @JsonProperty("bitLockerSystemDrivePolicy")
    protected BitLockerSystemDrivePolicy bitLockerSystemDrivePolicy;

    @JsonProperty("defenderAdditionalGuardedFolders")
    protected List<String> defenderAdditionalGuardedFolders;

    @JsonProperty("defenderAdditionalGuardedFolders@nextLink")
    protected String defenderAdditionalGuardedFoldersNextLink;

    @JsonProperty("defenderAdobeReaderLaunchChildProcess")
    protected DefenderProtectionType defenderAdobeReaderLaunchChildProcess;

    @JsonProperty("defenderAdvancedRansomewareProtectionType")
    protected DefenderProtectionType defenderAdvancedRansomewareProtectionType;

    @JsonProperty("defenderAllowBehaviorMonitoring")
    protected Boolean defenderAllowBehaviorMonitoring;

    @JsonProperty("defenderAllowCloudProtection")
    protected Boolean defenderAllowCloudProtection;

    @JsonProperty("defenderAllowEndUserAccess")
    protected Boolean defenderAllowEndUserAccess;

    @JsonProperty("defenderAllowIntrusionPreventionSystem")
    protected Boolean defenderAllowIntrusionPreventionSystem;

    @JsonProperty("defenderAllowOnAccessProtection")
    protected Boolean defenderAllowOnAccessProtection;

    @JsonProperty("defenderAllowRealTimeMonitoring")
    protected Boolean defenderAllowRealTimeMonitoring;

    @JsonProperty("defenderAllowScanArchiveFiles")
    protected Boolean defenderAllowScanArchiveFiles;

    @JsonProperty("defenderAllowScanDownloads")
    protected Boolean defenderAllowScanDownloads;

    @JsonProperty("defenderAllowScanNetworkFiles")
    protected Boolean defenderAllowScanNetworkFiles;

    @JsonProperty("defenderAllowScanRemovableDrivesDuringFullScan")
    protected Boolean defenderAllowScanRemovableDrivesDuringFullScan;

    @JsonProperty("defenderAllowScanScriptsLoadedInInternetExplorer")
    protected Boolean defenderAllowScanScriptsLoadedInInternetExplorer;

    @JsonProperty("defenderAttackSurfaceReductionExcludedPaths")
    protected List<String> defenderAttackSurfaceReductionExcludedPaths;

    @JsonProperty("defenderAttackSurfaceReductionExcludedPaths@nextLink")
    protected String defenderAttackSurfaceReductionExcludedPathsNextLink;

    @JsonProperty("defenderBlockEndUserAccess")
    protected Boolean defenderBlockEndUserAccess;

    @JsonProperty("defenderBlockPersistenceThroughWmiType")
    protected DefenderAttackSurfaceType defenderBlockPersistenceThroughWmiType;

    @JsonProperty("defenderCheckForSignaturesBeforeRunningScan")
    protected Boolean defenderCheckForSignaturesBeforeRunningScan;

    @JsonProperty("defenderCloudBlockLevel")
    protected DefenderCloudBlockLevelType defenderCloudBlockLevel;

    @JsonProperty("defenderCloudExtendedTimeoutInSeconds")
    protected Integer defenderCloudExtendedTimeoutInSeconds;

    @JsonProperty("defenderDaysBeforeDeletingQuarantinedMalware")
    protected Integer defenderDaysBeforeDeletingQuarantinedMalware;

    @JsonProperty("defenderDetectedMalwareActions")
    protected DefenderDetectedMalwareActions defenderDetectedMalwareActions;

    @JsonProperty("defenderDisableBehaviorMonitoring")
    protected Boolean defenderDisableBehaviorMonitoring;

    @JsonProperty("defenderDisableCatchupFullScan")
    protected Boolean defenderDisableCatchupFullScan;

    @JsonProperty("defenderDisableCatchupQuickScan")
    protected Boolean defenderDisableCatchupQuickScan;

    @JsonProperty("defenderDisableCloudProtection")
    protected Boolean defenderDisableCloudProtection;

    @JsonProperty("defenderDisableIntrusionPreventionSystem")
    protected Boolean defenderDisableIntrusionPreventionSystem;

    @JsonProperty("defenderDisableOnAccessProtection")
    protected Boolean defenderDisableOnAccessProtection;

    @JsonProperty("defenderDisableRealTimeMonitoring")
    protected Boolean defenderDisableRealTimeMonitoring;

    @JsonProperty("defenderDisableScanArchiveFiles")
    protected Boolean defenderDisableScanArchiveFiles;

    @JsonProperty("defenderDisableScanDownloads")
    protected Boolean defenderDisableScanDownloads;

    @JsonProperty("defenderDisableScanNetworkFiles")
    protected Boolean defenderDisableScanNetworkFiles;

    @JsonProperty("defenderDisableScanRemovableDrivesDuringFullScan")
    protected Boolean defenderDisableScanRemovableDrivesDuringFullScan;

    @JsonProperty("defenderDisableScanScriptsLoadedInInternetExplorer")
    protected Boolean defenderDisableScanScriptsLoadedInInternetExplorer;

    @JsonProperty("defenderEmailContentExecution")
    protected DefenderProtectionType defenderEmailContentExecution;

    @JsonProperty("defenderEmailContentExecutionType")
    protected DefenderAttackSurfaceType defenderEmailContentExecutionType;

    @JsonProperty("defenderEnableLowCpuPriority")
    protected Boolean defenderEnableLowCpuPriority;

    @JsonProperty("defenderEnableScanIncomingMail")
    protected Boolean defenderEnableScanIncomingMail;

    @JsonProperty("defenderEnableScanMappedNetworkDrivesDuringFullScan")
    protected Boolean defenderEnableScanMappedNetworkDrivesDuringFullScan;

    @JsonProperty("defenderExploitProtectionXml")
    protected byte[] defenderExploitProtectionXml;

    @JsonProperty("defenderExploitProtectionXmlFileName")
    protected String defenderExploitProtectionXmlFileName;

    @JsonProperty("defenderFileExtensionsToExclude")
    protected List<String> defenderFileExtensionsToExclude;

    @JsonProperty("defenderFileExtensionsToExclude@nextLink")
    protected String defenderFileExtensionsToExcludeNextLink;

    @JsonProperty("defenderFilesAndFoldersToExclude")
    protected List<String> defenderFilesAndFoldersToExclude;

    @JsonProperty("defenderFilesAndFoldersToExclude@nextLink")
    protected String defenderFilesAndFoldersToExcludeNextLink;

    @JsonProperty("defenderGuardedFoldersAllowedAppPaths")
    protected List<String> defenderGuardedFoldersAllowedAppPaths;

    @JsonProperty("defenderGuardedFoldersAllowedAppPaths@nextLink")
    protected String defenderGuardedFoldersAllowedAppPathsNextLink;

    @JsonProperty("defenderGuardMyFoldersType")
    protected FolderProtectionType defenderGuardMyFoldersType;

    @JsonProperty("defenderNetworkProtectionType")
    protected DefenderProtectionType defenderNetworkProtectionType;

    @JsonProperty("defenderOfficeAppsExecutableContentCreationOrLaunch")
    protected DefenderProtectionType defenderOfficeAppsExecutableContentCreationOrLaunch;

    @JsonProperty("defenderOfficeAppsExecutableContentCreationOrLaunchType")
    protected DefenderAttackSurfaceType defenderOfficeAppsExecutableContentCreationOrLaunchType;

    @JsonProperty("defenderOfficeAppsLaunchChildProcess")
    protected DefenderProtectionType defenderOfficeAppsLaunchChildProcess;

    @JsonProperty("defenderOfficeAppsLaunchChildProcessType")
    protected DefenderAttackSurfaceType defenderOfficeAppsLaunchChildProcessType;

    @JsonProperty("defenderOfficeAppsOtherProcessInjection")
    protected DefenderProtectionType defenderOfficeAppsOtherProcessInjection;

    @JsonProperty("defenderOfficeAppsOtherProcessInjectionType")
    protected DefenderAttackSurfaceType defenderOfficeAppsOtherProcessInjectionType;

    @JsonProperty("defenderOfficeCommunicationAppsLaunchChildProcess")
    protected DefenderProtectionType defenderOfficeCommunicationAppsLaunchChildProcess;

    @JsonProperty("defenderOfficeMacroCodeAllowWin32Imports")
    protected DefenderProtectionType defenderOfficeMacroCodeAllowWin32Imports;

    @JsonProperty("defenderOfficeMacroCodeAllowWin32ImportsType")
    protected DefenderAttackSurfaceType defenderOfficeMacroCodeAllowWin32ImportsType;

    @JsonProperty("defenderPotentiallyUnwantedAppAction")
    protected DefenderProtectionType defenderPotentiallyUnwantedAppAction;

    @JsonProperty("defenderPreventCredentialStealingType")
    protected DefenderProtectionType defenderPreventCredentialStealingType;

    @JsonProperty("defenderProcessCreation")
    protected DefenderProtectionType defenderProcessCreation;

    @JsonProperty("defenderProcessCreationType")
    protected DefenderAttackSurfaceType defenderProcessCreationType;

    @JsonProperty("defenderProcessesToExclude")
    protected List<String> defenderProcessesToExclude;

    @JsonProperty("defenderProcessesToExclude@nextLink")
    protected String defenderProcessesToExcludeNextLink;

    @JsonProperty("defenderScanDirection")
    protected DefenderRealtimeScanDirection defenderScanDirection;

    @JsonProperty("defenderScanMaxCpuPercentage")
    protected Integer defenderScanMaxCpuPercentage;

    @JsonProperty("defenderScanType")
    protected DefenderScanType defenderScanType;

    @JsonProperty("defenderScheduledQuickScanTime")
    protected LocalTime defenderScheduledQuickScanTime;

    @JsonProperty("defenderScheduledScanDay")
    protected WeeklySchedule defenderScheduledScanDay;

    @JsonProperty("defenderScheduledScanTime")
    protected LocalTime defenderScheduledScanTime;

    @JsonProperty("defenderScriptDownloadedPayloadExecution")
    protected DefenderProtectionType defenderScriptDownloadedPayloadExecution;

    @JsonProperty("defenderScriptDownloadedPayloadExecutionType")
    protected DefenderAttackSurfaceType defenderScriptDownloadedPayloadExecutionType;

    @JsonProperty("defenderScriptObfuscatedMacroCode")
    protected DefenderProtectionType defenderScriptObfuscatedMacroCode;

    @JsonProperty("defenderScriptObfuscatedMacroCodeType")
    protected DefenderAttackSurfaceType defenderScriptObfuscatedMacroCodeType;

    @JsonProperty("defenderSecurityCenterBlockExploitProtectionOverride")
    protected Boolean defenderSecurityCenterBlockExploitProtectionOverride;

    @JsonProperty("defenderSecurityCenterDisableAccountUI")
    protected Boolean defenderSecurityCenterDisableAccountUI;

    @JsonProperty("defenderSecurityCenterDisableAppBrowserUI")
    protected Boolean defenderSecurityCenterDisableAppBrowserUI;

    @JsonProperty("defenderSecurityCenterDisableClearTpmUI")
    protected Boolean defenderSecurityCenterDisableClearTpmUI;

    @JsonProperty("defenderSecurityCenterDisableFamilyUI")
    protected Boolean defenderSecurityCenterDisableFamilyUI;

    @JsonProperty("defenderSecurityCenterDisableHardwareUI")
    protected Boolean defenderSecurityCenterDisableHardwareUI;

    @JsonProperty("defenderSecurityCenterDisableHealthUI")
    protected Boolean defenderSecurityCenterDisableHealthUI;

    @JsonProperty("defenderSecurityCenterDisableNetworkUI")
    protected Boolean defenderSecurityCenterDisableNetworkUI;

    @JsonProperty("defenderSecurityCenterDisableNotificationAreaUI")
    protected Boolean defenderSecurityCenterDisableNotificationAreaUI;

    @JsonProperty("defenderSecurityCenterDisableRansomwareUI")
    protected Boolean defenderSecurityCenterDisableRansomwareUI;

    @JsonProperty("defenderSecurityCenterDisableSecureBootUI")
    protected Boolean defenderSecurityCenterDisableSecureBootUI;

    @JsonProperty("defenderSecurityCenterDisableTroubleshootingUI")
    protected Boolean defenderSecurityCenterDisableTroubleshootingUI;

    @JsonProperty("defenderSecurityCenterDisableVirusUI")
    protected Boolean defenderSecurityCenterDisableVirusUI;

    @JsonProperty("defenderSecurityCenterDisableVulnerableTpmFirmwareUpdateUI")
    protected Boolean defenderSecurityCenterDisableVulnerableTpmFirmwareUpdateUI;

    @JsonProperty("defenderSecurityCenterHelpEmail")
    protected String defenderSecurityCenterHelpEmail;

    @JsonProperty("defenderSecurityCenterHelpPhone")
    protected String defenderSecurityCenterHelpPhone;

    @JsonProperty("defenderSecurityCenterHelpURL")
    protected String defenderSecurityCenterHelpURL;

    @JsonProperty("defenderSecurityCenterITContactDisplay")
    protected DefenderSecurityCenterITContactDisplayType defenderSecurityCenterITContactDisplay;

    @JsonProperty("defenderSecurityCenterNotificationsFromApp")
    protected DefenderSecurityCenterNotificationsFromAppType defenderSecurityCenterNotificationsFromApp;

    @JsonProperty("defenderSecurityCenterOrganizationDisplayName")
    protected String defenderSecurityCenterOrganizationDisplayName;

    @JsonProperty("defenderSignatureUpdateIntervalInHours")
    protected Integer defenderSignatureUpdateIntervalInHours;

    @JsonProperty("defenderSubmitSamplesConsentType")
    protected DefenderSubmitSamplesConsentType defenderSubmitSamplesConsentType;

    @JsonProperty("defenderUntrustedExecutable")
    protected DefenderProtectionType defenderUntrustedExecutable;

    @JsonProperty("defenderUntrustedExecutableType")
    protected DefenderAttackSurfaceType defenderUntrustedExecutableType;

    @JsonProperty("defenderUntrustedUSBProcess")
    protected DefenderProtectionType defenderUntrustedUSBProcess;

    @JsonProperty("defenderUntrustedUSBProcessType")
    protected DefenderAttackSurfaceType defenderUntrustedUSBProcessType;

    @JsonProperty("deviceGuardEnableSecureBootWithDMA")
    protected Boolean deviceGuardEnableSecureBootWithDMA;

    @JsonProperty("deviceGuardEnableVirtualizationBasedSecurity")
    protected Boolean deviceGuardEnableVirtualizationBasedSecurity;

    @JsonProperty("deviceGuardLaunchSystemGuard")
    protected Enablement deviceGuardLaunchSystemGuard;

    @JsonProperty("deviceGuardLocalSystemAuthorityCredentialGuardSettings")
    protected DeviceGuardLocalSystemAuthorityCredentialGuardType deviceGuardLocalSystemAuthorityCredentialGuardSettings;

    @JsonProperty("deviceGuardSecureBootWithDMA")
    protected SecureBootWithDMAType deviceGuardSecureBootWithDMA;

    @JsonProperty("dmaGuardDeviceEnumerationPolicy")
    protected DmaGuardDeviceEnumerationPolicyType dmaGuardDeviceEnumerationPolicy;

    @JsonProperty("firewallBlockStatefulFTP")
    protected Boolean firewallBlockStatefulFTP;

    @JsonProperty("firewallCertificateRevocationListCheckMethod")
    protected FirewallCertificateRevocationListCheckMethodType firewallCertificateRevocationListCheckMethod;

    @JsonProperty("firewallIdleTimeoutForSecurityAssociationInSeconds")
    protected Integer firewallIdleTimeoutForSecurityAssociationInSeconds;

    @JsonProperty("firewallIPSecExemptionsAllowDHCP")
    protected Boolean firewallIPSecExemptionsAllowDHCP;

    @JsonProperty("firewallIPSecExemptionsAllowICMP")
    protected Boolean firewallIPSecExemptionsAllowICMP;

    @JsonProperty("firewallIPSecExemptionsAllowNeighborDiscovery")
    protected Boolean firewallIPSecExemptionsAllowNeighborDiscovery;

    @JsonProperty("firewallIPSecExemptionsAllowRouterDiscovery")
    protected Boolean firewallIPSecExemptionsAllowRouterDiscovery;

    @JsonProperty("firewallIPSecExemptionsNone")
    protected Boolean firewallIPSecExemptionsNone;

    @JsonProperty("firewallMergeKeyingModuleSettings")
    protected Boolean firewallMergeKeyingModuleSettings;

    @JsonProperty("firewallPacketQueueingMethod")
    protected FirewallPacketQueueingMethodType firewallPacketQueueingMethod;

    @JsonProperty("firewallPreSharedKeyEncodingMethod")
    protected FirewallPreSharedKeyEncodingMethodType firewallPreSharedKeyEncodingMethod;

    @JsonProperty("firewallProfileDomain")
    protected WindowsFirewallNetworkProfile firewallProfileDomain;

    @JsonProperty("firewallProfilePrivate")
    protected WindowsFirewallNetworkProfile firewallProfilePrivate;

    @JsonProperty("firewallProfilePublic")
    protected WindowsFirewallNetworkProfile firewallProfilePublic;

    @JsonProperty("firewallRules")
    protected List<WindowsFirewallRule> firewallRules;

    @JsonProperty("firewallRules@nextLink")
    protected String firewallRulesNextLink;

    @JsonProperty("lanManagerAuthenticationLevel")
    protected LanManagerAuthenticationLevel lanManagerAuthenticationLevel;

    @JsonProperty("lanManagerWorkstationDisableInsecureGuestLogons")
    protected Boolean lanManagerWorkstationDisableInsecureGuestLogons;

    @JsonProperty("localSecurityOptionsAdministratorAccountName")
    protected String localSecurityOptionsAdministratorAccountName;

    @JsonProperty("localSecurityOptionsAdministratorElevationPromptBehavior")
    protected LocalSecurityOptionsAdministratorElevationPromptBehaviorType localSecurityOptionsAdministratorElevationPromptBehavior;

    @JsonProperty("localSecurityOptionsAllowAnonymousEnumerationOfSAMAccountsAndShares")
    protected Boolean localSecurityOptionsAllowAnonymousEnumerationOfSAMAccountsAndShares;

    @JsonProperty("localSecurityOptionsAllowPKU2UAuthenticationRequests")
    protected Boolean localSecurityOptionsAllowPKU2UAuthenticationRequests;

    @JsonProperty("localSecurityOptionsAllowRemoteCallsToSecurityAccountsManager")
    protected String localSecurityOptionsAllowRemoteCallsToSecurityAccountsManager;

    @JsonProperty("localSecurityOptionsAllowRemoteCallsToSecurityAccountsManagerHelperBool")
    protected Boolean localSecurityOptionsAllowRemoteCallsToSecurityAccountsManagerHelperBool;

    @JsonProperty("localSecurityOptionsAllowSystemToBeShutDownWithoutHavingToLogOn")
    protected Boolean localSecurityOptionsAllowSystemToBeShutDownWithoutHavingToLogOn;

    @JsonProperty("localSecurityOptionsAllowUIAccessApplicationElevation")
    protected Boolean localSecurityOptionsAllowUIAccessApplicationElevation;

    @JsonProperty("localSecurityOptionsAllowUIAccessApplicationsForSecureLocations")
    protected Boolean localSecurityOptionsAllowUIAccessApplicationsForSecureLocations;

    @JsonProperty("localSecurityOptionsAllowUndockWithoutHavingToLogon")
    protected Boolean localSecurityOptionsAllowUndockWithoutHavingToLogon;

    @JsonProperty("localSecurityOptionsBlockMicrosoftAccounts")
    protected Boolean localSecurityOptionsBlockMicrosoftAccounts;

    @JsonProperty("localSecurityOptionsBlockRemoteLogonWithBlankPassword")
    protected Boolean localSecurityOptionsBlockRemoteLogonWithBlankPassword;

    @JsonProperty("localSecurityOptionsBlockRemoteOpticalDriveAccess")
    protected Boolean localSecurityOptionsBlockRemoteOpticalDriveAccess;

    @JsonProperty("localSecurityOptionsBlockUsersInstallingPrinterDrivers")
    protected Boolean localSecurityOptionsBlockUsersInstallingPrinterDrivers;

    @JsonProperty("localSecurityOptionsClearVirtualMemoryPageFile")
    protected Boolean localSecurityOptionsClearVirtualMemoryPageFile;

    @JsonProperty("localSecurityOptionsClientDigitallySignCommunicationsAlways")
    protected Boolean localSecurityOptionsClientDigitallySignCommunicationsAlways;

    @JsonProperty("localSecurityOptionsClientSendUnencryptedPasswordToThirdPartySMBServers")
    protected Boolean localSecurityOptionsClientSendUnencryptedPasswordToThirdPartySMBServers;

    @JsonProperty("localSecurityOptionsDetectApplicationInstallationsAndPromptForElevation")
    protected Boolean localSecurityOptionsDetectApplicationInstallationsAndPromptForElevation;

    @JsonProperty("localSecurityOptionsDisableAdministratorAccount")
    protected Boolean localSecurityOptionsDisableAdministratorAccount;

    @JsonProperty("localSecurityOptionsDisableClientDigitallySignCommunicationsIfServerAgrees")
    protected Boolean localSecurityOptionsDisableClientDigitallySignCommunicationsIfServerAgrees;

    @JsonProperty("localSecurityOptionsDisableGuestAccount")
    protected Boolean localSecurityOptionsDisableGuestAccount;

    @JsonProperty("localSecurityOptionsDisableServerDigitallySignCommunicationsAlways")
    protected Boolean localSecurityOptionsDisableServerDigitallySignCommunicationsAlways;

    @JsonProperty("localSecurityOptionsDisableServerDigitallySignCommunicationsIfClientAgrees")
    protected Boolean localSecurityOptionsDisableServerDigitallySignCommunicationsIfClientAgrees;

    @JsonProperty("localSecurityOptionsDoNotAllowAnonymousEnumerationOfSAMAccounts")
    protected Boolean localSecurityOptionsDoNotAllowAnonymousEnumerationOfSAMAccounts;

    @JsonProperty("localSecurityOptionsDoNotRequireCtrlAltDel")
    protected Boolean localSecurityOptionsDoNotRequireCtrlAltDel;

    @JsonProperty("localSecurityOptionsDoNotStoreLANManagerHashValueOnNextPasswordChange")
    protected Boolean localSecurityOptionsDoNotStoreLANManagerHashValueOnNextPasswordChange;

    @JsonProperty("localSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUser")
    protected LocalSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUserType localSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUser;

    @JsonProperty("localSecurityOptionsGuestAccountName")
    protected String localSecurityOptionsGuestAccountName;

    @JsonProperty("localSecurityOptionsHideLastSignedInUser")
    protected Boolean localSecurityOptionsHideLastSignedInUser;

    @JsonProperty("localSecurityOptionsHideUsernameAtSignIn")
    protected Boolean localSecurityOptionsHideUsernameAtSignIn;

    @JsonProperty("localSecurityOptionsInformationDisplayedOnLockScreen")
    protected LocalSecurityOptionsInformationDisplayedOnLockScreenType localSecurityOptionsInformationDisplayedOnLockScreen;

    @JsonProperty("localSecurityOptionsInformationShownOnLockScreen")
    protected LocalSecurityOptionsInformationShownOnLockScreenType localSecurityOptionsInformationShownOnLockScreen;

    @JsonProperty("localSecurityOptionsLogOnMessageText")
    protected String localSecurityOptionsLogOnMessageText;

    @JsonProperty("localSecurityOptionsLogOnMessageTitle")
    protected String localSecurityOptionsLogOnMessageTitle;

    @JsonProperty("localSecurityOptionsMachineInactivityLimit")
    protected Integer localSecurityOptionsMachineInactivityLimit;

    @JsonProperty("localSecurityOptionsMachineInactivityLimitInMinutes")
    protected Integer localSecurityOptionsMachineInactivityLimitInMinutes;

    @JsonProperty("localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedClients")
    protected LocalSecurityOptionsMinimumSessionSecurity localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedClients;

    @JsonProperty("localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedServers")
    protected LocalSecurityOptionsMinimumSessionSecurity localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedServers;

    @JsonProperty("localSecurityOptionsOnlyElevateSignedExecutables")
    protected Boolean localSecurityOptionsOnlyElevateSignedExecutables;

    @JsonProperty("localSecurityOptionsRestrictAnonymousAccessToNamedPipesAndShares")
    protected Boolean localSecurityOptionsRestrictAnonymousAccessToNamedPipesAndShares;

    @JsonProperty("localSecurityOptionsSmartCardRemovalBehavior")
    protected LocalSecurityOptionsSmartCardRemovalBehaviorType localSecurityOptionsSmartCardRemovalBehavior;

    @JsonProperty("localSecurityOptionsStandardUserElevationPromptBehavior")
    protected LocalSecurityOptionsStandardUserElevationPromptBehaviorType localSecurityOptionsStandardUserElevationPromptBehavior;

    @JsonProperty("localSecurityOptionsSwitchToSecureDesktopWhenPromptingForElevation")
    protected Boolean localSecurityOptionsSwitchToSecureDesktopWhenPromptingForElevation;

    @JsonProperty("localSecurityOptionsUseAdminApprovalMode")
    protected Boolean localSecurityOptionsUseAdminApprovalMode;

    @JsonProperty("localSecurityOptionsUseAdminApprovalModeForAdministrators")
    protected Boolean localSecurityOptionsUseAdminApprovalModeForAdministrators;

    @JsonProperty("localSecurityOptionsVirtualizeFileAndRegistryWriteFailuresToPerUserLocations")
    protected Boolean localSecurityOptionsVirtualizeFileAndRegistryWriteFailuresToPerUserLocations;

    @JsonProperty("smartScreenBlockOverrideForFiles")
    protected Boolean smartScreenBlockOverrideForFiles;

    @JsonProperty("smartScreenEnableInShell")
    protected Boolean smartScreenEnableInShell;

    @JsonProperty("userRightsAccessCredentialManagerAsTrustedCaller")
    protected DeviceManagementUserRightsSetting userRightsAccessCredentialManagerAsTrustedCaller;

    @JsonProperty("userRightsActAsPartOfTheOperatingSystem")
    protected DeviceManagementUserRightsSetting userRightsActAsPartOfTheOperatingSystem;

    @JsonProperty("userRightsAllowAccessFromNetwork")
    protected DeviceManagementUserRightsSetting userRightsAllowAccessFromNetwork;

    @JsonProperty("userRightsBackupData")
    protected DeviceManagementUserRightsSetting userRightsBackupData;

    @JsonProperty("userRightsBlockAccessFromNetwork")
    protected DeviceManagementUserRightsSetting userRightsBlockAccessFromNetwork;

    @JsonProperty("userRightsChangeSystemTime")
    protected DeviceManagementUserRightsSetting userRightsChangeSystemTime;

    @JsonProperty("userRightsCreateGlobalObjects")
    protected DeviceManagementUserRightsSetting userRightsCreateGlobalObjects;

    @JsonProperty("userRightsCreatePageFile")
    protected DeviceManagementUserRightsSetting userRightsCreatePageFile;

    @JsonProperty("userRightsCreatePermanentSharedObjects")
    protected DeviceManagementUserRightsSetting userRightsCreatePermanentSharedObjects;

    @JsonProperty("userRightsCreateSymbolicLinks")
    protected DeviceManagementUserRightsSetting userRightsCreateSymbolicLinks;

    @JsonProperty("userRightsCreateToken")
    protected DeviceManagementUserRightsSetting userRightsCreateToken;

    @JsonProperty("userRightsDebugPrograms")
    protected DeviceManagementUserRightsSetting userRightsDebugPrograms;

    @JsonProperty("userRightsDelegation")
    protected DeviceManagementUserRightsSetting userRightsDelegation;

    @JsonProperty("userRightsDenyLocalLogOn")
    protected DeviceManagementUserRightsSetting userRightsDenyLocalLogOn;

    @JsonProperty("userRightsGenerateSecurityAudits")
    protected DeviceManagementUserRightsSetting userRightsGenerateSecurityAudits;

    @JsonProperty("userRightsImpersonateClient")
    protected DeviceManagementUserRightsSetting userRightsImpersonateClient;

    @JsonProperty("userRightsIncreaseSchedulingPriority")
    protected DeviceManagementUserRightsSetting userRightsIncreaseSchedulingPriority;

    @JsonProperty("userRightsLoadUnloadDrivers")
    protected DeviceManagementUserRightsSetting userRightsLoadUnloadDrivers;

    @JsonProperty("userRightsLocalLogOn")
    protected DeviceManagementUserRightsSetting userRightsLocalLogOn;

    @JsonProperty("userRightsLockMemory")
    protected DeviceManagementUserRightsSetting userRightsLockMemory;

    @JsonProperty("userRightsManageAuditingAndSecurityLogs")
    protected DeviceManagementUserRightsSetting userRightsManageAuditingAndSecurityLogs;

    @JsonProperty("userRightsManageVolumes")
    protected DeviceManagementUserRightsSetting userRightsManageVolumes;

    @JsonProperty("userRightsModifyFirmwareEnvironment")
    protected DeviceManagementUserRightsSetting userRightsModifyFirmwareEnvironment;

    @JsonProperty("userRightsModifyObjectLabels")
    protected DeviceManagementUserRightsSetting userRightsModifyObjectLabels;

    @JsonProperty("userRightsProfileSingleProcess")
    protected DeviceManagementUserRightsSetting userRightsProfileSingleProcess;

    @JsonProperty("userRightsRemoteDesktopServicesLogOn")
    protected DeviceManagementUserRightsSetting userRightsRemoteDesktopServicesLogOn;

    @JsonProperty("userRightsRemoteShutdown")
    protected DeviceManagementUserRightsSetting userRightsRemoteShutdown;

    @JsonProperty("userRightsRestoreData")
    protected DeviceManagementUserRightsSetting userRightsRestoreData;

    @JsonProperty("userRightsTakeOwnership")
    protected DeviceManagementUserRightsSetting userRightsTakeOwnership;

    @JsonProperty("windowsDefenderTamperProtection")
    protected WindowsDefenderTamperProtectionOptions windowsDefenderTamperProtection;

    @JsonProperty("xboxServicesAccessoryManagementServiceStartupMode")
    protected ServiceStartType xboxServicesAccessoryManagementServiceStartupMode;

    @JsonProperty("xboxServicesEnableXboxGameSaveTask")
    protected Boolean xboxServicesEnableXboxGameSaveTask;

    @JsonProperty("xboxServicesLiveAuthManagerServiceStartupMode")
    protected ServiceStartType xboxServicesLiveAuthManagerServiceStartupMode;

    @JsonProperty("xboxServicesLiveGameSaveServiceStartupMode")
    protected ServiceStartType xboxServicesLiveGameSaveServiceStartupMode;

    @JsonProperty("xboxServicesLiveNetworkingServiceStartupMode")
    protected ServiceStartType xboxServicesLiveNetworkingServiceStartupMode;

    protected Windows10EndpointProtectionConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindows10EndpointProtectionConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private Integer version;
        private List<DeviceConfigurationAssignment> assignments;
        private List<SettingStateDeviceSummary> deviceSettingStateSummaries;
        private List<DeviceConfigurationDeviceStatus> deviceStatuses;
        private DeviceConfigurationDeviceOverview deviceStatusOverview;
        private List<DeviceConfigurationGroupAssignment> groupAssignments;
        private List<DeviceConfigurationUserStatus> userStatuses;
        private DeviceConfigurationUserOverview userStatusOverview;
        private Boolean applicationGuardAllowCameraMicrophoneRedirection;
        private Boolean applicationGuardAllowFileSaveOnHost;
        private Boolean applicationGuardAllowPersistence;
        private Boolean applicationGuardAllowPrintToLocalPrinters;
        private Boolean applicationGuardAllowPrintToNetworkPrinters;
        private Boolean applicationGuardAllowPrintToPDF;
        private Boolean applicationGuardAllowPrintToXPS;
        private Boolean applicationGuardAllowVirtualGPU;
        private ApplicationGuardBlockClipboardSharingType applicationGuardBlockClipboardSharing;
        private ApplicationGuardBlockFileTransferType applicationGuardBlockFileTransfer;
        private Boolean applicationGuardBlockNonEnterpriseContent;
        private List<String> applicationGuardCertificateThumbprints;
        private String applicationGuardCertificateThumbprintsNextLink;
        private Boolean applicationGuardEnabled;
        private ApplicationGuardEnabledOptions applicationGuardEnabledOptions;
        private Boolean applicationGuardForceAuditing;
        private AppLockerApplicationControlType appLockerApplicationControl;
        private Boolean bitLockerAllowStandardUserEncryption;
        private Boolean bitLockerDisableWarningForOtherDiskEncryption;
        private Boolean bitLockerEnableStorageCardEncryptionOnMobile;
        private Boolean bitLockerEncryptDevice;
        private BitLockerFixedDrivePolicy bitLockerFixedDrivePolicy;
        private BitLockerRecoveryPasswordRotationType bitLockerRecoveryPasswordRotation;
        private BitLockerRemovableDrivePolicy bitLockerRemovableDrivePolicy;
        private BitLockerSystemDrivePolicy bitLockerSystemDrivePolicy;
        private List<String> defenderAdditionalGuardedFolders;
        private String defenderAdditionalGuardedFoldersNextLink;
        private DefenderProtectionType defenderAdobeReaderLaunchChildProcess;
        private DefenderProtectionType defenderAdvancedRansomewareProtectionType;
        private Boolean defenderAllowBehaviorMonitoring;
        private Boolean defenderAllowCloudProtection;
        private Boolean defenderAllowEndUserAccess;
        private Boolean defenderAllowIntrusionPreventionSystem;
        private Boolean defenderAllowOnAccessProtection;
        private Boolean defenderAllowRealTimeMonitoring;
        private Boolean defenderAllowScanArchiveFiles;
        private Boolean defenderAllowScanDownloads;
        private Boolean defenderAllowScanNetworkFiles;
        private Boolean defenderAllowScanRemovableDrivesDuringFullScan;
        private Boolean defenderAllowScanScriptsLoadedInInternetExplorer;
        private List<String> defenderAttackSurfaceReductionExcludedPaths;
        private String defenderAttackSurfaceReductionExcludedPathsNextLink;
        private Boolean defenderBlockEndUserAccess;
        private DefenderAttackSurfaceType defenderBlockPersistenceThroughWmiType;
        private Boolean defenderCheckForSignaturesBeforeRunningScan;
        private DefenderCloudBlockLevelType defenderCloudBlockLevel;
        private Integer defenderCloudExtendedTimeoutInSeconds;
        private Integer defenderDaysBeforeDeletingQuarantinedMalware;
        private DefenderDetectedMalwareActions defenderDetectedMalwareActions;
        private Boolean defenderDisableBehaviorMonitoring;
        private Boolean defenderDisableCatchupFullScan;
        private Boolean defenderDisableCatchupQuickScan;
        private Boolean defenderDisableCloudProtection;
        private Boolean defenderDisableIntrusionPreventionSystem;
        private Boolean defenderDisableOnAccessProtection;
        private Boolean defenderDisableRealTimeMonitoring;
        private Boolean defenderDisableScanArchiveFiles;
        private Boolean defenderDisableScanDownloads;
        private Boolean defenderDisableScanNetworkFiles;
        private Boolean defenderDisableScanRemovableDrivesDuringFullScan;
        private Boolean defenderDisableScanScriptsLoadedInInternetExplorer;
        private DefenderProtectionType defenderEmailContentExecution;
        private DefenderAttackSurfaceType defenderEmailContentExecutionType;
        private Boolean defenderEnableLowCpuPriority;
        private Boolean defenderEnableScanIncomingMail;
        private Boolean defenderEnableScanMappedNetworkDrivesDuringFullScan;
        private byte[] defenderExploitProtectionXml;
        private String defenderExploitProtectionXmlFileName;
        private List<String> defenderFileExtensionsToExclude;
        private String defenderFileExtensionsToExcludeNextLink;
        private List<String> defenderFilesAndFoldersToExclude;
        private String defenderFilesAndFoldersToExcludeNextLink;
        private List<String> defenderGuardedFoldersAllowedAppPaths;
        private String defenderGuardedFoldersAllowedAppPathsNextLink;
        private FolderProtectionType defenderGuardMyFoldersType;
        private DefenderProtectionType defenderNetworkProtectionType;
        private DefenderProtectionType defenderOfficeAppsExecutableContentCreationOrLaunch;
        private DefenderAttackSurfaceType defenderOfficeAppsExecutableContentCreationOrLaunchType;
        private DefenderProtectionType defenderOfficeAppsLaunchChildProcess;
        private DefenderAttackSurfaceType defenderOfficeAppsLaunchChildProcessType;
        private DefenderProtectionType defenderOfficeAppsOtherProcessInjection;
        private DefenderAttackSurfaceType defenderOfficeAppsOtherProcessInjectionType;
        private DefenderProtectionType defenderOfficeCommunicationAppsLaunchChildProcess;
        private DefenderProtectionType defenderOfficeMacroCodeAllowWin32Imports;
        private DefenderAttackSurfaceType defenderOfficeMacroCodeAllowWin32ImportsType;
        private DefenderProtectionType defenderPotentiallyUnwantedAppAction;
        private DefenderProtectionType defenderPreventCredentialStealingType;
        private DefenderProtectionType defenderProcessCreation;
        private DefenderAttackSurfaceType defenderProcessCreationType;
        private List<String> defenderProcessesToExclude;
        private String defenderProcessesToExcludeNextLink;
        private DefenderRealtimeScanDirection defenderScanDirection;
        private Integer defenderScanMaxCpuPercentage;
        private DefenderScanType defenderScanType;
        private LocalTime defenderScheduledQuickScanTime;
        private WeeklySchedule defenderScheduledScanDay;
        private LocalTime defenderScheduledScanTime;
        private DefenderProtectionType defenderScriptDownloadedPayloadExecution;
        private DefenderAttackSurfaceType defenderScriptDownloadedPayloadExecutionType;
        private DefenderProtectionType defenderScriptObfuscatedMacroCode;
        private DefenderAttackSurfaceType defenderScriptObfuscatedMacroCodeType;
        private Boolean defenderSecurityCenterBlockExploitProtectionOverride;
        private Boolean defenderSecurityCenterDisableAccountUI;
        private Boolean defenderSecurityCenterDisableAppBrowserUI;
        private Boolean defenderSecurityCenterDisableClearTpmUI;
        private Boolean defenderSecurityCenterDisableFamilyUI;
        private Boolean defenderSecurityCenterDisableHardwareUI;
        private Boolean defenderSecurityCenterDisableHealthUI;
        private Boolean defenderSecurityCenterDisableNetworkUI;
        private Boolean defenderSecurityCenterDisableNotificationAreaUI;
        private Boolean defenderSecurityCenterDisableRansomwareUI;
        private Boolean defenderSecurityCenterDisableSecureBootUI;
        private Boolean defenderSecurityCenterDisableTroubleshootingUI;
        private Boolean defenderSecurityCenterDisableVirusUI;
        private Boolean defenderSecurityCenterDisableVulnerableTpmFirmwareUpdateUI;
        private String defenderSecurityCenterHelpEmail;
        private String defenderSecurityCenterHelpPhone;
        private String defenderSecurityCenterHelpURL;
        private DefenderSecurityCenterITContactDisplayType defenderSecurityCenterITContactDisplay;
        private DefenderSecurityCenterNotificationsFromAppType defenderSecurityCenterNotificationsFromApp;
        private String defenderSecurityCenterOrganizationDisplayName;
        private Integer defenderSignatureUpdateIntervalInHours;
        private DefenderSubmitSamplesConsentType defenderSubmitSamplesConsentType;
        private DefenderProtectionType defenderUntrustedExecutable;
        private DefenderAttackSurfaceType defenderUntrustedExecutableType;
        private DefenderProtectionType defenderUntrustedUSBProcess;
        private DefenderAttackSurfaceType defenderUntrustedUSBProcessType;
        private Boolean deviceGuardEnableSecureBootWithDMA;
        private Boolean deviceGuardEnableVirtualizationBasedSecurity;
        private Enablement deviceGuardLaunchSystemGuard;
        private DeviceGuardLocalSystemAuthorityCredentialGuardType deviceGuardLocalSystemAuthorityCredentialGuardSettings;
        private SecureBootWithDMAType deviceGuardSecureBootWithDMA;
        private DmaGuardDeviceEnumerationPolicyType dmaGuardDeviceEnumerationPolicy;
        private Boolean firewallBlockStatefulFTP;
        private FirewallCertificateRevocationListCheckMethodType firewallCertificateRevocationListCheckMethod;
        private Integer firewallIdleTimeoutForSecurityAssociationInSeconds;
        private Boolean firewallIPSecExemptionsAllowDHCP;
        private Boolean firewallIPSecExemptionsAllowICMP;
        private Boolean firewallIPSecExemptionsAllowNeighborDiscovery;
        private Boolean firewallIPSecExemptionsAllowRouterDiscovery;
        private Boolean firewallIPSecExemptionsNone;
        private Boolean firewallMergeKeyingModuleSettings;
        private FirewallPacketQueueingMethodType firewallPacketQueueingMethod;
        private FirewallPreSharedKeyEncodingMethodType firewallPreSharedKeyEncodingMethod;
        private WindowsFirewallNetworkProfile firewallProfileDomain;
        private WindowsFirewallNetworkProfile firewallProfilePrivate;
        private WindowsFirewallNetworkProfile firewallProfilePublic;
        private List<WindowsFirewallRule> firewallRules;
        private String firewallRulesNextLink;
        private LanManagerAuthenticationLevel lanManagerAuthenticationLevel;
        private Boolean lanManagerWorkstationDisableInsecureGuestLogons;
        private String localSecurityOptionsAdministratorAccountName;
        private LocalSecurityOptionsAdministratorElevationPromptBehaviorType localSecurityOptionsAdministratorElevationPromptBehavior;
        private Boolean localSecurityOptionsAllowAnonymousEnumerationOfSAMAccountsAndShares;
        private Boolean localSecurityOptionsAllowPKU2UAuthenticationRequests;
        private String localSecurityOptionsAllowRemoteCallsToSecurityAccountsManager;
        private Boolean localSecurityOptionsAllowRemoteCallsToSecurityAccountsManagerHelperBool;
        private Boolean localSecurityOptionsAllowSystemToBeShutDownWithoutHavingToLogOn;
        private Boolean localSecurityOptionsAllowUIAccessApplicationElevation;
        private Boolean localSecurityOptionsAllowUIAccessApplicationsForSecureLocations;
        private Boolean localSecurityOptionsAllowUndockWithoutHavingToLogon;
        private Boolean localSecurityOptionsBlockMicrosoftAccounts;
        private Boolean localSecurityOptionsBlockRemoteLogonWithBlankPassword;
        private Boolean localSecurityOptionsBlockRemoteOpticalDriveAccess;
        private Boolean localSecurityOptionsBlockUsersInstallingPrinterDrivers;
        private Boolean localSecurityOptionsClearVirtualMemoryPageFile;
        private Boolean localSecurityOptionsClientDigitallySignCommunicationsAlways;
        private Boolean localSecurityOptionsClientSendUnencryptedPasswordToThirdPartySMBServers;
        private Boolean localSecurityOptionsDetectApplicationInstallationsAndPromptForElevation;
        private Boolean localSecurityOptionsDisableAdministratorAccount;
        private Boolean localSecurityOptionsDisableClientDigitallySignCommunicationsIfServerAgrees;
        private Boolean localSecurityOptionsDisableGuestAccount;
        private Boolean localSecurityOptionsDisableServerDigitallySignCommunicationsAlways;
        private Boolean localSecurityOptionsDisableServerDigitallySignCommunicationsIfClientAgrees;
        private Boolean localSecurityOptionsDoNotAllowAnonymousEnumerationOfSAMAccounts;
        private Boolean localSecurityOptionsDoNotRequireCtrlAltDel;
        private Boolean localSecurityOptionsDoNotStoreLANManagerHashValueOnNextPasswordChange;
        private LocalSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUserType localSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUser;
        private String localSecurityOptionsGuestAccountName;
        private Boolean localSecurityOptionsHideLastSignedInUser;
        private Boolean localSecurityOptionsHideUsernameAtSignIn;
        private LocalSecurityOptionsInformationDisplayedOnLockScreenType localSecurityOptionsInformationDisplayedOnLockScreen;
        private LocalSecurityOptionsInformationShownOnLockScreenType localSecurityOptionsInformationShownOnLockScreen;
        private String localSecurityOptionsLogOnMessageText;
        private String localSecurityOptionsLogOnMessageTitle;
        private Integer localSecurityOptionsMachineInactivityLimit;
        private Integer localSecurityOptionsMachineInactivityLimitInMinutes;
        private LocalSecurityOptionsMinimumSessionSecurity localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedClients;
        private LocalSecurityOptionsMinimumSessionSecurity localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedServers;
        private Boolean localSecurityOptionsOnlyElevateSignedExecutables;
        private Boolean localSecurityOptionsRestrictAnonymousAccessToNamedPipesAndShares;
        private LocalSecurityOptionsSmartCardRemovalBehaviorType localSecurityOptionsSmartCardRemovalBehavior;
        private LocalSecurityOptionsStandardUserElevationPromptBehaviorType localSecurityOptionsStandardUserElevationPromptBehavior;
        private Boolean localSecurityOptionsSwitchToSecureDesktopWhenPromptingForElevation;
        private Boolean localSecurityOptionsUseAdminApprovalMode;
        private Boolean localSecurityOptionsUseAdminApprovalModeForAdministrators;
        private Boolean localSecurityOptionsVirtualizeFileAndRegistryWriteFailuresToPerUserLocations;
        private Boolean smartScreenBlockOverrideForFiles;
        private Boolean smartScreenEnableInShell;
        private DeviceManagementUserRightsSetting userRightsAccessCredentialManagerAsTrustedCaller;
        private DeviceManagementUserRightsSetting userRightsActAsPartOfTheOperatingSystem;
        private DeviceManagementUserRightsSetting userRightsAllowAccessFromNetwork;
        private DeviceManagementUserRightsSetting userRightsBackupData;
        private DeviceManagementUserRightsSetting userRightsBlockAccessFromNetwork;
        private DeviceManagementUserRightsSetting userRightsChangeSystemTime;
        private DeviceManagementUserRightsSetting userRightsCreateGlobalObjects;
        private DeviceManagementUserRightsSetting userRightsCreatePageFile;
        private DeviceManagementUserRightsSetting userRightsCreatePermanentSharedObjects;
        private DeviceManagementUserRightsSetting userRightsCreateSymbolicLinks;
        private DeviceManagementUserRightsSetting userRightsCreateToken;
        private DeviceManagementUserRightsSetting userRightsDebugPrograms;
        private DeviceManagementUserRightsSetting userRightsDelegation;
        private DeviceManagementUserRightsSetting userRightsDenyLocalLogOn;
        private DeviceManagementUserRightsSetting userRightsGenerateSecurityAudits;
        private DeviceManagementUserRightsSetting userRightsImpersonateClient;
        private DeviceManagementUserRightsSetting userRightsIncreaseSchedulingPriority;
        private DeviceManagementUserRightsSetting userRightsLoadUnloadDrivers;
        private DeviceManagementUserRightsSetting userRightsLocalLogOn;
        private DeviceManagementUserRightsSetting userRightsLockMemory;
        private DeviceManagementUserRightsSetting userRightsManageAuditingAndSecurityLogs;
        private DeviceManagementUserRightsSetting userRightsManageVolumes;
        private DeviceManagementUserRightsSetting userRightsModifyFirmwareEnvironment;
        private DeviceManagementUserRightsSetting userRightsModifyObjectLabels;
        private DeviceManagementUserRightsSetting userRightsProfileSingleProcess;
        private DeviceManagementUserRightsSetting userRightsRemoteDesktopServicesLogOn;
        private DeviceManagementUserRightsSetting userRightsRemoteShutdown;
        private DeviceManagementUserRightsSetting userRightsRestoreData;
        private DeviceManagementUserRightsSetting userRightsTakeOwnership;
        private WindowsDefenderTamperProtectionOptions windowsDefenderTamperProtection;
        private ServiceStartType xboxServicesAccessoryManagementServiceStartupMode;
        private Boolean xboxServicesEnableXboxGameSaveTask;
        private ServiceStartType xboxServicesLiveAuthManagerServiceStartupMode;
        private ServiceStartType xboxServicesLiveGameSaveServiceStartupMode;
        private ServiceStartType xboxServicesLiveNetworkingServiceStartupMode;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder assignments(List<DeviceConfigurationAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(DeviceConfigurationAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder deviceSettingStateSummaries(List<SettingStateDeviceSummary> deviceSettingStateSummaries) {
            this.deviceSettingStateSummaries = deviceSettingStateSummaries;
            this.changedFields = changedFields.add("deviceSettingStateSummaries");
            return this;
        }

        public Builder deviceSettingStateSummaries(SettingStateDeviceSummary... deviceSettingStateSummaries) {
            return deviceSettingStateSummaries(Arrays.asList(deviceSettingStateSummaries));
        }

        public Builder deviceStatuses(List<DeviceConfigurationDeviceStatus> deviceStatuses) {
            this.deviceStatuses = deviceStatuses;
            this.changedFields = changedFields.add("deviceStatuses");
            return this;
        }

        public Builder deviceStatuses(DeviceConfigurationDeviceStatus... deviceStatuses) {
            return deviceStatuses(Arrays.asList(deviceStatuses));
        }

        public Builder deviceStatusOverview(DeviceConfigurationDeviceOverview deviceStatusOverview) {
            this.deviceStatusOverview = deviceStatusOverview;
            this.changedFields = changedFields.add("deviceStatusOverview");
            return this;
        }

        public Builder groupAssignments(List<DeviceConfigurationGroupAssignment> groupAssignments) {
            this.groupAssignments = groupAssignments;
            this.changedFields = changedFields.add("groupAssignments");
            return this;
        }

        public Builder groupAssignments(DeviceConfigurationGroupAssignment... groupAssignments) {
            return groupAssignments(Arrays.asList(groupAssignments));
        }

        public Builder userStatuses(List<DeviceConfigurationUserStatus> userStatuses) {
            this.userStatuses = userStatuses;
            this.changedFields = changedFields.add("userStatuses");
            return this;
        }

        public Builder userStatuses(DeviceConfigurationUserStatus... userStatuses) {
            return userStatuses(Arrays.asList(userStatuses));
        }

        public Builder userStatusOverview(DeviceConfigurationUserOverview userStatusOverview) {
            this.userStatusOverview = userStatusOverview;
            this.changedFields = changedFields.add("userStatusOverview");
            return this;
        }

        /**
         * <i>“Gets or sets whether applications inside Microsoft Defender Application Guard
         * can access the device’s camera and microphone.”</i>
         * 
         * @param applicationGuardAllowCameraMicrophoneRedirection
         *            value of {@code applicationGuardAllowCameraMicrophoneRedirection} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicationGuardAllowCameraMicrophoneRedirection(Boolean applicationGuardAllowCameraMicrophoneRedirection) {
            this.applicationGuardAllowCameraMicrophoneRedirection = applicationGuardAllowCameraMicrophoneRedirection;
            this.changedFields = changedFields.add("applicationGuardAllowCameraMicrophoneRedirection");
            return this;
        }

        /**
         * <i>“Allow users to download files from Edge in the application guard container and
         * save them on the host file system”</i>
         * 
         * @param applicationGuardAllowFileSaveOnHost
         *            value of {@code applicationGuardAllowFileSaveOnHost} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicationGuardAllowFileSaveOnHost(Boolean applicationGuardAllowFileSaveOnHost) {
            this.applicationGuardAllowFileSaveOnHost = applicationGuardAllowFileSaveOnHost;
            this.changedFields = changedFields.add("applicationGuardAllowFileSaveOnHost");
            return this;
        }

        /**
         * <i>“Allow persisting user generated data inside the App Guard Containter (favorites,
         * cookies, web passwords, etc.)”</i>
         * 
         * @param applicationGuardAllowPersistence
         *            value of {@code applicationGuardAllowPersistence} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicationGuardAllowPersistence(Boolean applicationGuardAllowPersistence) {
            this.applicationGuardAllowPersistence = applicationGuardAllowPersistence;
            this.changedFields = changedFields.add("applicationGuardAllowPersistence");
            return this;
        }

        /**
         * <i>“Allow printing to Local Printers from Container”</i>
         * 
         * @param applicationGuardAllowPrintToLocalPrinters
         *            value of {@code applicationGuardAllowPrintToLocalPrinters} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicationGuardAllowPrintToLocalPrinters(Boolean applicationGuardAllowPrintToLocalPrinters) {
            this.applicationGuardAllowPrintToLocalPrinters = applicationGuardAllowPrintToLocalPrinters;
            this.changedFields = changedFields.add("applicationGuardAllowPrintToLocalPrinters");
            return this;
        }

        /**
         * <i>“Allow printing to Network Printers from Container”</i>
         * 
         * @param applicationGuardAllowPrintToNetworkPrinters
         *            value of {@code applicationGuardAllowPrintToNetworkPrinters} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicationGuardAllowPrintToNetworkPrinters(Boolean applicationGuardAllowPrintToNetworkPrinters) {
            this.applicationGuardAllowPrintToNetworkPrinters = applicationGuardAllowPrintToNetworkPrinters;
            this.changedFields = changedFields.add("applicationGuardAllowPrintToNetworkPrinters");
            return this;
        }

        /**
         * <i>“Allow printing to PDF from Container”</i>
         * 
         * @param applicationGuardAllowPrintToPDF
         *            value of {@code applicationGuardAllowPrintToPDF} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicationGuardAllowPrintToPDF(Boolean applicationGuardAllowPrintToPDF) {
            this.applicationGuardAllowPrintToPDF = applicationGuardAllowPrintToPDF;
            this.changedFields = changedFields.add("applicationGuardAllowPrintToPDF");
            return this;
        }

        /**
         * <i>“Allow printing to XPS from Container”</i>
         * 
         * @param applicationGuardAllowPrintToXPS
         *            value of {@code applicationGuardAllowPrintToXPS} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicationGuardAllowPrintToXPS(Boolean applicationGuardAllowPrintToXPS) {
            this.applicationGuardAllowPrintToXPS = applicationGuardAllowPrintToXPS;
            this.changedFields = changedFields.add("applicationGuardAllowPrintToXPS");
            return this;
        }

        /**
         * <i>“Allow application guard to use virtual GPU”</i>
         * 
         * @param applicationGuardAllowVirtualGPU
         *            value of {@code applicationGuardAllowVirtualGPU} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicationGuardAllowVirtualGPU(Boolean applicationGuardAllowVirtualGPU) {
            this.applicationGuardAllowVirtualGPU = applicationGuardAllowVirtualGPU;
            this.changedFields = changedFields.add("applicationGuardAllowVirtualGPU");
            return this;
        }

        /**
         * <i>“Block clipboard to share data from Host to Container, or from Container to Host,
         * or both ways, or neither ways.”</i>
         * 
         * @param applicationGuardBlockClipboardSharing
         *            value of {@code applicationGuardBlockClipboardSharing} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicationGuardBlockClipboardSharing(ApplicationGuardBlockClipboardSharingType applicationGuardBlockClipboardSharing) {
            this.applicationGuardBlockClipboardSharing = applicationGuardBlockClipboardSharing;
            this.changedFields = changedFields.add("applicationGuardBlockClipboardSharing");
            return this;
        }

        /**
         * <i>“Block clipboard to transfer image file, text file or neither of them”</i>
         * 
         * @param applicationGuardBlockFileTransfer
         *            value of {@code applicationGuardBlockFileTransfer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicationGuardBlockFileTransfer(ApplicationGuardBlockFileTransferType applicationGuardBlockFileTransfer) {
            this.applicationGuardBlockFileTransfer = applicationGuardBlockFileTransfer;
            this.changedFields = changedFields.add("applicationGuardBlockFileTransfer");
            return this;
        }

        /**
         * <i>“Block enterprise sites to load non-enterprise content, such as third party plug-
         * ins”</i>
         * 
         * @param applicationGuardBlockNonEnterpriseContent
         *            value of {@code applicationGuardBlockNonEnterpriseContent} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicationGuardBlockNonEnterpriseContent(Boolean applicationGuardBlockNonEnterpriseContent) {
            this.applicationGuardBlockNonEnterpriseContent = applicationGuardBlockNonEnterpriseContent;
            this.changedFields = changedFields.add("applicationGuardBlockNonEnterpriseContent");
            return this;
        }

        /**
         * <i>“Allows certain device level Root Certificates to be shared with the Microsoft
         * Defender Application Guard container.”</i>
         * 
         * @param applicationGuardCertificateThumbprints
         *            value of {@code applicationGuardCertificateThumbprints} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicationGuardCertificateThumbprints(List<String> applicationGuardCertificateThumbprints) {
            this.applicationGuardCertificateThumbprints = applicationGuardCertificateThumbprints;
            this.changedFields = changedFields.add("applicationGuardCertificateThumbprints");
            return this;
        }

        /**
         * <i>“Allows certain device level Root Certificates to be shared with the Microsoft
         * Defender Application Guard container.”</i>
         * 
         * @param applicationGuardCertificateThumbprints
         *            value of {@code applicationGuardCertificateThumbprints} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicationGuardCertificateThumbprints(String... applicationGuardCertificateThumbprints) {
            return applicationGuardCertificateThumbprints(Arrays.asList(applicationGuardCertificateThumbprints));
        }

        /**
         * <i>“Allows certain device level Root Certificates to be shared with the Microsoft
         * Defender Application Guard container.”</i>
         * 
         * @param applicationGuardCertificateThumbprintsNextLink
         *            value of {@code applicationGuardCertificateThumbprints@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicationGuardCertificateThumbprintsNextLink(String applicationGuardCertificateThumbprintsNextLink) {
            this.applicationGuardCertificateThumbprintsNextLink = applicationGuardCertificateThumbprintsNextLink;
            this.changedFields = changedFields.add("applicationGuardCertificateThumbprints");
            return this;
        }

        /**
         * <i>“Enable Windows Defender Application Guard”</i>
         * 
         * @param applicationGuardEnabled
         *            value of {@code applicationGuardEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicationGuardEnabled(Boolean applicationGuardEnabled) {
            this.applicationGuardEnabled = applicationGuardEnabled;
            this.changedFields = changedFields.add("applicationGuardEnabled");
            return this;
        }

        /**
         * <i>“Enable Windows Defender Application Guard for newer Windows builds”</i>
         * 
         * @param applicationGuardEnabledOptions
         *            value of {@code applicationGuardEnabledOptions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicationGuardEnabledOptions(ApplicationGuardEnabledOptions applicationGuardEnabledOptions) {
            this.applicationGuardEnabledOptions = applicationGuardEnabledOptions;
            this.changedFields = changedFields.add("applicationGuardEnabledOptions");
            return this;
        }

        /**
         * <i>“Force auditing will persist Windows logs and events to meet security/compliance
         * criteria (sample events are user login-logoff, use of privilege rights, software
         * installation, system changes, etc.)”</i>
         * 
         * @param applicationGuardForceAuditing
         *            value of {@code applicationGuardForceAuditing} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicationGuardForceAuditing(Boolean applicationGuardForceAuditing) {
            this.applicationGuardForceAuditing = applicationGuardForceAuditing;
            this.changedFields = changedFields.add("applicationGuardForceAuditing");
            return this;
        }

        /**
         * <i>“Enables the Admin to choose what types of app to allow on devices.”</i>
         * 
         * @param appLockerApplicationControl
         *            value of {@code appLockerApplicationControl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appLockerApplicationControl(AppLockerApplicationControlType appLockerApplicationControl) {
            this.appLockerApplicationControl = appLockerApplicationControl;
            this.changedFields = changedFields.add("appLockerApplicationControl");
            return this;
        }

        /**
         * <i>“Allows the admin to allow standard users to enable encrpytion during Azure AD
         * Join.”</i>
         * 
         * @param bitLockerAllowStandardUserEncryption
         *            value of {@code bitLockerAllowStandardUserEncryption} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bitLockerAllowStandardUserEncryption(Boolean bitLockerAllowStandardUserEncryption) {
            this.bitLockerAllowStandardUserEncryption = bitLockerAllowStandardUserEncryption;
            this.changedFields = changedFields.add("bitLockerAllowStandardUserEncryption");
            return this;
        }

        /**
         * <i>“Allows the Admin to disable the warning prompt for other disk encryption on the
         * user machines.”</i>
         * 
         * @param bitLockerDisableWarningForOtherDiskEncryption
         *            value of {@code bitLockerDisableWarningForOtherDiskEncryption} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bitLockerDisableWarningForOtherDiskEncryption(Boolean bitLockerDisableWarningForOtherDiskEncryption) {
            this.bitLockerDisableWarningForOtherDiskEncryption = bitLockerDisableWarningForOtherDiskEncryption;
            this.changedFields = changedFields.add("bitLockerDisableWarningForOtherDiskEncryption");
            return this;
        }

        /**
         * <i>“Allows the admin to require encryption to be turned on using BitLocker. This
         * policy is valid only for a mobile SKU.”</i>
         * 
         * @param bitLockerEnableStorageCardEncryptionOnMobile
         *            value of {@code bitLockerEnableStorageCardEncryptionOnMobile} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bitLockerEnableStorageCardEncryptionOnMobile(Boolean bitLockerEnableStorageCardEncryptionOnMobile) {
            this.bitLockerEnableStorageCardEncryptionOnMobile = bitLockerEnableStorageCardEncryptionOnMobile;
            this.changedFields = changedFields.add("bitLockerEnableStorageCardEncryptionOnMobile");
            return this;
        }

        /**
         * <i>“Allows the admin to require encryption to be turned on using BitLocker.”</i>
         * 
         * @param bitLockerEncryptDevice
         *            value of {@code bitLockerEncryptDevice} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bitLockerEncryptDevice(Boolean bitLockerEncryptDevice) {
            this.bitLockerEncryptDevice = bitLockerEncryptDevice;
            this.changedFields = changedFields.add("bitLockerEncryptDevice");
            return this;
        }

        /**
         * <i>“BitLocker Fixed Drive Policy.”</i>
         * 
         * @param bitLockerFixedDrivePolicy
         *            value of {@code bitLockerFixedDrivePolicy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bitLockerFixedDrivePolicy(BitLockerFixedDrivePolicy bitLockerFixedDrivePolicy) {
            this.bitLockerFixedDrivePolicy = bitLockerFixedDrivePolicy;
            this.changedFields = changedFields.add("bitLockerFixedDrivePolicy");
            return this;
        }

        /**
         * <i>“This setting initiates a client-driven recovery password rotation after an OS
         * drive recovery (either by using bootmgr or WinRE).”</i>
         * 
         * @param bitLockerRecoveryPasswordRotation
         *            value of {@code bitLockerRecoveryPasswordRotation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bitLockerRecoveryPasswordRotation(BitLockerRecoveryPasswordRotationType bitLockerRecoveryPasswordRotation) {
            this.bitLockerRecoveryPasswordRotation = bitLockerRecoveryPasswordRotation;
            this.changedFields = changedFields.add("bitLockerRecoveryPasswordRotation");
            return this;
        }

        /**
         * <i>“BitLocker Removable Drive Policy.”</i>
         * 
         * @param bitLockerRemovableDrivePolicy
         *            value of {@code bitLockerRemovableDrivePolicy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bitLockerRemovableDrivePolicy(BitLockerRemovableDrivePolicy bitLockerRemovableDrivePolicy) {
            this.bitLockerRemovableDrivePolicy = bitLockerRemovableDrivePolicy;
            this.changedFields = changedFields.add("bitLockerRemovableDrivePolicy");
            return this;
        }

        /**
         * <i>“BitLocker System Drive Policy.”</i>
         * 
         * @param bitLockerSystemDrivePolicy
         *            value of {@code bitLockerSystemDrivePolicy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bitLockerSystemDrivePolicy(BitLockerSystemDrivePolicy bitLockerSystemDrivePolicy) {
            this.bitLockerSystemDrivePolicy = bitLockerSystemDrivePolicy;
            this.changedFields = changedFields.add("bitLockerSystemDrivePolicy");
            return this;
        }

        /**
         * <i>“List of folder paths to be added to the list of protected folders”</i>
         * 
         * @param defenderAdditionalGuardedFolders
         *            value of {@code defenderAdditionalGuardedFolders} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderAdditionalGuardedFolders(List<String> defenderAdditionalGuardedFolders) {
            this.defenderAdditionalGuardedFolders = defenderAdditionalGuardedFolders;
            this.changedFields = changedFields.add("defenderAdditionalGuardedFolders");
            return this;
        }

        /**
         * <i>“List of folder paths to be added to the list of protected folders”</i>
         * 
         * @param defenderAdditionalGuardedFolders
         *            value of {@code defenderAdditionalGuardedFolders} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderAdditionalGuardedFolders(String... defenderAdditionalGuardedFolders) {
            return defenderAdditionalGuardedFolders(Arrays.asList(defenderAdditionalGuardedFolders));
        }

        /**
         * <i>“List of folder paths to be added to the list of protected folders”</i>
         * 
         * @param defenderAdditionalGuardedFoldersNextLink
         *            value of {@code defenderAdditionalGuardedFolders@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderAdditionalGuardedFoldersNextLink(String defenderAdditionalGuardedFoldersNextLink) {
            this.defenderAdditionalGuardedFoldersNextLink = defenderAdditionalGuardedFoldersNextLink;
            this.changedFields = changedFields.add("defenderAdditionalGuardedFolders");
            return this;
        }

        /**
         * <i>“Value indicating the behavior of Adobe Reader from creating child processes”</i>
         * 
         * @param defenderAdobeReaderLaunchChildProcess
         *            value of {@code defenderAdobeReaderLaunchChildProcess} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderAdobeReaderLaunchChildProcess(DefenderProtectionType defenderAdobeReaderLaunchChildProcess) {
            this.defenderAdobeReaderLaunchChildProcess = defenderAdobeReaderLaunchChildProcess;
            this.changedFields = changedFields.add("defenderAdobeReaderLaunchChildProcess");
            return this;
        }

        /**
         * <i>“Value indicating use of advanced protection against ransomeware”</i>
         * 
         * @param defenderAdvancedRansomewareProtectionType
         *            value of {@code defenderAdvancedRansomewareProtectionType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderAdvancedRansomewareProtectionType(DefenderProtectionType defenderAdvancedRansomewareProtectionType) {
            this.defenderAdvancedRansomewareProtectionType = defenderAdvancedRansomewareProtectionType;
            this.changedFields = changedFields.add("defenderAdvancedRansomewareProtectionType");
            return this;
        }

        /**
         * <i>“Allows or disallows Windows Defender Behavior Monitoring functionality.”</i>
         * 
         * @param defenderAllowBehaviorMonitoring
         *            value of {@code defenderAllowBehaviorMonitoring} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderAllowBehaviorMonitoring(Boolean defenderAllowBehaviorMonitoring) {
            this.defenderAllowBehaviorMonitoring = defenderAllowBehaviorMonitoring;
            this.changedFields = changedFields.add("defenderAllowBehaviorMonitoring");
            return this;
        }

        /**
         * <i>“To best protect your PC, Windows Defender will send information to Microsoft
         * about any problems it finds. Microsoft will analyze that information, learn more
         * about problems affecting you and other customers, and offer improved solutions.”</i>
         * 
         * @param defenderAllowCloudProtection
         *            value of {@code defenderAllowCloudProtection} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderAllowCloudProtection(Boolean defenderAllowCloudProtection) {
            this.defenderAllowCloudProtection = defenderAllowCloudProtection;
            this.changedFields = changedFields.add("defenderAllowCloudProtection");
            return this;
        }

        /**
         * <i>“Allows or disallows user access to the Windows Defender UI. If disallowed, all
         * Windows Defender notifications will also be suppressed.”</i>
         * 
         * @param defenderAllowEndUserAccess
         *            value of {@code defenderAllowEndUserAccess} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderAllowEndUserAccess(Boolean defenderAllowEndUserAccess) {
            this.defenderAllowEndUserAccess = defenderAllowEndUserAccess;
            this.changedFields = changedFields.add("defenderAllowEndUserAccess");
            return this;
        }

        /**
         * <i>“Allows or disallows Windows Defender Intrusion Prevention functionality.”</i>
         * 
         * @param defenderAllowIntrusionPreventionSystem
         *            value of {@code defenderAllowIntrusionPreventionSystem} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderAllowIntrusionPreventionSystem(Boolean defenderAllowIntrusionPreventionSystem) {
            this.defenderAllowIntrusionPreventionSystem = defenderAllowIntrusionPreventionSystem;
            this.changedFields = changedFields.add("defenderAllowIntrusionPreventionSystem");
            return this;
        }

        /**
         * <i>“Allows or disallows Windows Defender On Access Protection functionality.”</i>
         * 
         * @param defenderAllowOnAccessProtection
         *            value of {@code defenderAllowOnAccessProtection} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderAllowOnAccessProtection(Boolean defenderAllowOnAccessProtection) {
            this.defenderAllowOnAccessProtection = defenderAllowOnAccessProtection;
            this.changedFields = changedFields.add("defenderAllowOnAccessProtection");
            return this;
        }

        /**
         * <i>“Allows or disallows Windows Defender Realtime Monitoring functionality.”</i>
         * 
         * @param defenderAllowRealTimeMonitoring
         *            value of {@code defenderAllowRealTimeMonitoring} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderAllowRealTimeMonitoring(Boolean defenderAllowRealTimeMonitoring) {
            this.defenderAllowRealTimeMonitoring = defenderAllowRealTimeMonitoring;
            this.changedFields = changedFields.add("defenderAllowRealTimeMonitoring");
            return this;
        }

        /**
         * <i>“Allows or disallows scanning of archives.”</i>
         * 
         * @param defenderAllowScanArchiveFiles
         *            value of {@code defenderAllowScanArchiveFiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderAllowScanArchiveFiles(Boolean defenderAllowScanArchiveFiles) {
            this.defenderAllowScanArchiveFiles = defenderAllowScanArchiveFiles;
            this.changedFields = changedFields.add("defenderAllowScanArchiveFiles");
            return this;
        }

        /**
         * <i>“Allows or disallows Windows Defender IOAVP Protection functionality.”</i>
         * 
         * @param defenderAllowScanDownloads
         *            value of {@code defenderAllowScanDownloads} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderAllowScanDownloads(Boolean defenderAllowScanDownloads) {
            this.defenderAllowScanDownloads = defenderAllowScanDownloads;
            this.changedFields = changedFields.add("defenderAllowScanDownloads");
            return this;
        }

        /**
         * <i>“Allows or disallows a scanning of network files.”</i>
         * 
         * @param defenderAllowScanNetworkFiles
         *            value of {@code defenderAllowScanNetworkFiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderAllowScanNetworkFiles(Boolean defenderAllowScanNetworkFiles) {
            this.defenderAllowScanNetworkFiles = defenderAllowScanNetworkFiles;
            this.changedFields = changedFields.add("defenderAllowScanNetworkFiles");
            return this;
        }

        /**
         * <i>“Allows or disallows a full scan of removable drives. During a quick scan,
         * removable drives may still be scanned.”</i>
         * 
         * @param defenderAllowScanRemovableDrivesDuringFullScan
         *            value of {@code defenderAllowScanRemovableDrivesDuringFullScan} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderAllowScanRemovableDrivesDuringFullScan(Boolean defenderAllowScanRemovableDrivesDuringFullScan) {
            this.defenderAllowScanRemovableDrivesDuringFullScan = defenderAllowScanRemovableDrivesDuringFullScan;
            this.changedFields = changedFields.add("defenderAllowScanRemovableDrivesDuringFullScan");
            return this;
        }

        /**
         * <i>“Allows or disallows Windows Defender Script Scanning functionality.”</i>
         * 
         * @param defenderAllowScanScriptsLoadedInInternetExplorer
         *            value of {@code defenderAllowScanScriptsLoadedInInternetExplorer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderAllowScanScriptsLoadedInInternetExplorer(Boolean defenderAllowScanScriptsLoadedInInternetExplorer) {
            this.defenderAllowScanScriptsLoadedInInternetExplorer = defenderAllowScanScriptsLoadedInInternetExplorer;
            this.changedFields = changedFields.add("defenderAllowScanScriptsLoadedInInternetExplorer");
            return this;
        }

        /**
         * <i>“List of exe files and folders to be excluded from attack surface reduction rules”</i>
         * 
         * @param defenderAttackSurfaceReductionExcludedPaths
         *            value of {@code defenderAttackSurfaceReductionExcludedPaths} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderAttackSurfaceReductionExcludedPaths(List<String> defenderAttackSurfaceReductionExcludedPaths) {
            this.defenderAttackSurfaceReductionExcludedPaths = defenderAttackSurfaceReductionExcludedPaths;
            this.changedFields = changedFields.add("defenderAttackSurfaceReductionExcludedPaths");
            return this;
        }

        /**
         * <i>“List of exe files and folders to be excluded from attack surface reduction rules”</i>
         * 
         * @param defenderAttackSurfaceReductionExcludedPaths
         *            value of {@code defenderAttackSurfaceReductionExcludedPaths} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderAttackSurfaceReductionExcludedPaths(String... defenderAttackSurfaceReductionExcludedPaths) {
            return defenderAttackSurfaceReductionExcludedPaths(Arrays.asList(defenderAttackSurfaceReductionExcludedPaths));
        }

        /**
         * <i>“List of exe files and folders to be excluded from attack surface reduction rules”</i>
         * 
         * @param defenderAttackSurfaceReductionExcludedPathsNextLink
         *            value of {@code defenderAttackSurfaceReductionExcludedPaths@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderAttackSurfaceReductionExcludedPathsNextLink(String defenderAttackSurfaceReductionExcludedPathsNextLink) {
            this.defenderAttackSurfaceReductionExcludedPathsNextLink = defenderAttackSurfaceReductionExcludedPathsNextLink;
            this.changedFields = changedFields.add("defenderAttackSurfaceReductionExcludedPaths");
            return this;
        }

        /**
         * <i>“Allows or disallows user access to the Windows Defender UI. If disallowed, all
         * Windows Defender notifications will also be suppressed.”</i>
         * 
         * @param defenderBlockEndUserAccess
         *            value of {@code defenderBlockEndUserAccess} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderBlockEndUserAccess(Boolean defenderBlockEndUserAccess) {
            this.defenderBlockEndUserAccess = defenderBlockEndUserAccess;
            this.changedFields = changedFields.add("defenderBlockEndUserAccess");
            return this;
        }

        /**
         * <i>“Value indicating the behavior of Block persistence through WMI event
         * subscription”</i>
         * 
         * @param defenderBlockPersistenceThroughWmiType
         *            value of {@code defenderBlockPersistenceThroughWmiType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderBlockPersistenceThroughWmiType(DefenderAttackSurfaceType defenderBlockPersistenceThroughWmiType) {
            this.defenderBlockPersistenceThroughWmiType = defenderBlockPersistenceThroughWmiType;
            this.changedFields = changedFields.add("defenderBlockPersistenceThroughWmiType");
            return this;
        }

        /**
         * <i>“This policy setting allows you to manage whether a check for new virus and
         * spyware definitions will occur before running a scan.”</i>
         * 
         * @param defenderCheckForSignaturesBeforeRunningScan
         *            value of {@code defenderCheckForSignaturesBeforeRunningScan} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderCheckForSignaturesBeforeRunningScan(Boolean defenderCheckForSignaturesBeforeRunningScan) {
            this.defenderCheckForSignaturesBeforeRunningScan = defenderCheckForSignaturesBeforeRunningScan;
            this.changedFields = changedFields.add("defenderCheckForSignaturesBeforeRunningScan");
            return this;
        }

        /**
         * <i>“Added in Windows 10, version 1709. This policy setting determines how aggressive
         * Windows Defender Antivirus will be in blocking and scanning suspicious files.
         * Value type is integer. This feature requires the "Join Microsoft MAPS" setting
         * enabled in order to function.”</i>
         * 
         * @param defenderCloudBlockLevel
         *            value of {@code defenderCloudBlockLevel} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderCloudBlockLevel(DefenderCloudBlockLevelType defenderCloudBlockLevel) {
            this.defenderCloudBlockLevel = defenderCloudBlockLevel;
            this.changedFields = changedFields.add("defenderCloudBlockLevel");
            return this;
        }

        /**
         * <i>“Added in Windows 10, version 1709. This feature allows Windows Defender
         * Antivirus to block a suspicious file for up to 60 seconds, and scan it in the
         * cloud to make sure it's safe. Value type is integer, range is 0 - 50. This
         * feature depends on three other MAPS settings the must all be enabled- "Configure
         * the 'Block at First Sight' feature; "Join Microsoft MAPS"; "Send file samples
         * when further analysis is required". Valid values 0 to 50”</i>
         * 
         * @param defenderCloudExtendedTimeoutInSeconds
         *            value of {@code defenderCloudExtendedTimeoutInSeconds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderCloudExtendedTimeoutInSeconds(Integer defenderCloudExtendedTimeoutInSeconds) {
            this.defenderCloudExtendedTimeoutInSeconds = defenderCloudExtendedTimeoutInSeconds;
            this.changedFields = changedFields.add("defenderCloudExtendedTimeoutInSeconds");
            return this;
        }

        /**
         * <i>“Time period (in days) that quarantine items will be stored on the system. Valid
         * values 0 to 90”</i>
         * 
         * @param defenderDaysBeforeDeletingQuarantinedMalware
         *            value of {@code defenderDaysBeforeDeletingQuarantinedMalware} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderDaysBeforeDeletingQuarantinedMalware(Integer defenderDaysBeforeDeletingQuarantinedMalware) {
            this.defenderDaysBeforeDeletingQuarantinedMalware = defenderDaysBeforeDeletingQuarantinedMalware;
            this.changedFields = changedFields.add("defenderDaysBeforeDeletingQuarantinedMalware");
            return this;
        }

        /**
         * <i>“Allows an administrator to specify any valid threat severity levels and the
         * corresponding default action ID to take.”</i>
         * 
         * @param defenderDetectedMalwareActions
         *            value of {@code defenderDetectedMalwareActions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderDetectedMalwareActions(DefenderDetectedMalwareActions defenderDetectedMalwareActions) {
            this.defenderDetectedMalwareActions = defenderDetectedMalwareActions;
            this.changedFields = changedFields.add("defenderDetectedMalwareActions");
            return this;
        }

        /**
         * <i>“Allows or disallows Windows Defender Behavior Monitoring functionality.”</i>
         * 
         * @param defenderDisableBehaviorMonitoring
         *            value of {@code defenderDisableBehaviorMonitoring} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderDisableBehaviorMonitoring(Boolean defenderDisableBehaviorMonitoring) {
            this.defenderDisableBehaviorMonitoring = defenderDisableBehaviorMonitoring;
            this.changedFields = changedFields.add("defenderDisableBehaviorMonitoring");
            return this;
        }

        /**
         * <i>“This policy setting allows you to configure catch-up scans for scheduled full
         * scans. A catch-up scan is a scan that is initiated because a regularly scheduled
         * scan was missed. Usually these scheduled scans are missed because the computer
         * was turned off at the scheduled time.”</i>
         * 
         * @param defenderDisableCatchupFullScan
         *            value of {@code defenderDisableCatchupFullScan} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderDisableCatchupFullScan(Boolean defenderDisableCatchupFullScan) {
            this.defenderDisableCatchupFullScan = defenderDisableCatchupFullScan;
            this.changedFields = changedFields.add("defenderDisableCatchupFullScan");
            return this;
        }

        /**
         * <i>“This policy setting allows you to configure catch-up scans for scheduled quick
         * scans. A catch-up scan is a scan that is initiated because a regularly scheduled
         * scan was missed. Usually these scheduled scans are missed because the computer
         * was turned off at the scheduled time.”</i>
         * 
         * @param defenderDisableCatchupQuickScan
         *            value of {@code defenderDisableCatchupQuickScan} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderDisableCatchupQuickScan(Boolean defenderDisableCatchupQuickScan) {
            this.defenderDisableCatchupQuickScan = defenderDisableCatchupQuickScan;
            this.changedFields = changedFields.add("defenderDisableCatchupQuickScan");
            return this;
        }

        /**
         * <i>“To best protect your PC, Windows Defender will send information to Microsoft
         * about any problems it finds. Microsoft will analyze that information, learn more
         * about problems affecting you and other customers, and offer improved solutions.”</i>
         * 
         * @param defenderDisableCloudProtection
         *            value of {@code defenderDisableCloudProtection} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderDisableCloudProtection(Boolean defenderDisableCloudProtection) {
            this.defenderDisableCloudProtection = defenderDisableCloudProtection;
            this.changedFields = changedFields.add("defenderDisableCloudProtection");
            return this;
        }

        /**
         * <i>“Allows or disallows Windows Defender Intrusion Prevention functionality.”</i>
         * 
         * @param defenderDisableIntrusionPreventionSystem
         *            value of {@code defenderDisableIntrusionPreventionSystem} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderDisableIntrusionPreventionSystem(Boolean defenderDisableIntrusionPreventionSystem) {
            this.defenderDisableIntrusionPreventionSystem = defenderDisableIntrusionPreventionSystem;
            this.changedFields = changedFields.add("defenderDisableIntrusionPreventionSystem");
            return this;
        }

        /**
         * <i>“Allows or disallows Windows Defender On Access Protection functionality.”</i>
         * 
         * @param defenderDisableOnAccessProtection
         *            value of {@code defenderDisableOnAccessProtection} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderDisableOnAccessProtection(Boolean defenderDisableOnAccessProtection) {
            this.defenderDisableOnAccessProtection = defenderDisableOnAccessProtection;
            this.changedFields = changedFields.add("defenderDisableOnAccessProtection");
            return this;
        }

        /**
         * <i>“Allows or disallows Windows Defender Realtime Monitoring functionality.”</i>
         * 
         * @param defenderDisableRealTimeMonitoring
         *            value of {@code defenderDisableRealTimeMonitoring} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderDisableRealTimeMonitoring(Boolean defenderDisableRealTimeMonitoring) {
            this.defenderDisableRealTimeMonitoring = defenderDisableRealTimeMonitoring;
            this.changedFields = changedFields.add("defenderDisableRealTimeMonitoring");
            return this;
        }

        /**
         * <i>“Allows or disallows scanning of archives.”</i>
         * 
         * @param defenderDisableScanArchiveFiles
         *            value of {@code defenderDisableScanArchiveFiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderDisableScanArchiveFiles(Boolean defenderDisableScanArchiveFiles) {
            this.defenderDisableScanArchiveFiles = defenderDisableScanArchiveFiles;
            this.changedFields = changedFields.add("defenderDisableScanArchiveFiles");
            return this;
        }

        /**
         * <i>“Allows or disallows Windows Defender IOAVP Protection functionality.”</i>
         * 
         * @param defenderDisableScanDownloads
         *            value of {@code defenderDisableScanDownloads} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderDisableScanDownloads(Boolean defenderDisableScanDownloads) {
            this.defenderDisableScanDownloads = defenderDisableScanDownloads;
            this.changedFields = changedFields.add("defenderDisableScanDownloads");
            return this;
        }

        /**
         * <i>“Allows or disallows a scanning of network files.”</i>
         * 
         * @param defenderDisableScanNetworkFiles
         *            value of {@code defenderDisableScanNetworkFiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderDisableScanNetworkFiles(Boolean defenderDisableScanNetworkFiles) {
            this.defenderDisableScanNetworkFiles = defenderDisableScanNetworkFiles;
            this.changedFields = changedFields.add("defenderDisableScanNetworkFiles");
            return this;
        }

        /**
         * <i>“Allows or disallows a full scan of removable drives. During a quick scan,
         * removable drives may still be scanned.”</i>
         * 
         * @param defenderDisableScanRemovableDrivesDuringFullScan
         *            value of {@code defenderDisableScanRemovableDrivesDuringFullScan} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderDisableScanRemovableDrivesDuringFullScan(Boolean defenderDisableScanRemovableDrivesDuringFullScan) {
            this.defenderDisableScanRemovableDrivesDuringFullScan = defenderDisableScanRemovableDrivesDuringFullScan;
            this.changedFields = changedFields.add("defenderDisableScanRemovableDrivesDuringFullScan");
            return this;
        }

        /**
         * <i>“Allows or disallows Windows Defender Script Scanning functionality.”</i>
         * 
         * @param defenderDisableScanScriptsLoadedInInternetExplorer
         *            value of {@code defenderDisableScanScriptsLoadedInInternetExplorer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderDisableScanScriptsLoadedInInternetExplorer(Boolean defenderDisableScanScriptsLoadedInInternetExplorer) {
            this.defenderDisableScanScriptsLoadedInInternetExplorer = defenderDisableScanScriptsLoadedInInternetExplorer;
            this.changedFields = changedFields.add("defenderDisableScanScriptsLoadedInInternetExplorer");
            return this;
        }

        /**
         * <i>“Value indicating if execution of executable content (exe, dll, ps, js, vbs, etc)
         * should be dropped from email (webmail/mail-client)”</i>
         * 
         * @param defenderEmailContentExecution
         *            value of {@code defenderEmailContentExecution} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderEmailContentExecution(DefenderProtectionType defenderEmailContentExecution) {
            this.defenderEmailContentExecution = defenderEmailContentExecution;
            this.changedFields = changedFields.add("defenderEmailContentExecution");
            return this;
        }

        /**
         * <i>“Value indicating if execution of executable content (exe, dll, ps, js, vbs, etc)
         * should be dropped from email (webmail/mail-client)”</i>
         * 
         * @param defenderEmailContentExecutionType
         *            value of {@code defenderEmailContentExecutionType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderEmailContentExecutionType(DefenderAttackSurfaceType defenderEmailContentExecutionType) {
            this.defenderEmailContentExecutionType = defenderEmailContentExecutionType;
            this.changedFields = changedFields.add("defenderEmailContentExecutionType");
            return this;
        }

        /**
         * <i>“This policy setting allows you to enable or disable low CPU priority for
         * scheduled scans.”</i>
         * 
         * @param defenderEnableLowCpuPriority
         *            value of {@code defenderEnableLowCpuPriority} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderEnableLowCpuPriority(Boolean defenderEnableLowCpuPriority) {
            this.defenderEnableLowCpuPriority = defenderEnableLowCpuPriority;
            this.changedFields = changedFields.add("defenderEnableLowCpuPriority");
            return this;
        }

        /**
         * <i>“Allows or disallows scanning of email.”</i>
         * 
         * @param defenderEnableScanIncomingMail
         *            value of {@code defenderEnableScanIncomingMail} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderEnableScanIncomingMail(Boolean defenderEnableScanIncomingMail) {
            this.defenderEnableScanIncomingMail = defenderEnableScanIncomingMail;
            this.changedFields = changedFields.add("defenderEnableScanIncomingMail");
            return this;
        }

        /**
         * <i>“Allows or disallows a full scan of mapped network drives.”</i>
         * 
         * @param defenderEnableScanMappedNetworkDrivesDuringFullScan
         *            value of {@code defenderEnableScanMappedNetworkDrivesDuringFullScan} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderEnableScanMappedNetworkDrivesDuringFullScan(Boolean defenderEnableScanMappedNetworkDrivesDuringFullScan) {
            this.defenderEnableScanMappedNetworkDrivesDuringFullScan = defenderEnableScanMappedNetworkDrivesDuringFullScan;
            this.changedFields = changedFields.add("defenderEnableScanMappedNetworkDrivesDuringFullScan");
            return this;
        }

        /**
         * <i>“Xml content containing information regarding exploit protection details.”</i>
         * 
         * @param defenderExploitProtectionXml
         *            value of {@code defenderExploitProtectionXml} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderExploitProtectionXml(byte[] defenderExploitProtectionXml) {
            this.defenderExploitProtectionXml = defenderExploitProtectionXml;
            this.changedFields = changedFields.add("defenderExploitProtectionXml");
            return this;
        }

        /**
         * <i>“Name of the file from which DefenderExploitProtectionXml was obtained.”</i>
         * 
         * @param defenderExploitProtectionXmlFileName
         *            value of {@code defenderExploitProtectionXmlFileName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderExploitProtectionXmlFileName(String defenderExploitProtectionXmlFileName) {
            this.defenderExploitProtectionXmlFileName = defenderExploitProtectionXmlFileName;
            this.changedFields = changedFields.add("defenderExploitProtectionXmlFileName");
            return this;
        }

        /**
         * <i>“File extensions to exclude from scans and real time protection.”</i>
         * 
         * @param defenderFileExtensionsToExclude
         *            value of {@code defenderFileExtensionsToExclude} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderFileExtensionsToExclude(List<String> defenderFileExtensionsToExclude) {
            this.defenderFileExtensionsToExclude = defenderFileExtensionsToExclude;
            this.changedFields = changedFields.add("defenderFileExtensionsToExclude");
            return this;
        }

        /**
         * <i>“File extensions to exclude from scans and real time protection.”</i>
         * 
         * @param defenderFileExtensionsToExclude
         *            value of {@code defenderFileExtensionsToExclude} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderFileExtensionsToExclude(String... defenderFileExtensionsToExclude) {
            return defenderFileExtensionsToExclude(Arrays.asList(defenderFileExtensionsToExclude));
        }

        /**
         * <i>“File extensions to exclude from scans and real time protection.”</i>
         * 
         * @param defenderFileExtensionsToExcludeNextLink
         *            value of {@code defenderFileExtensionsToExclude@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderFileExtensionsToExcludeNextLink(String defenderFileExtensionsToExcludeNextLink) {
            this.defenderFileExtensionsToExcludeNextLink = defenderFileExtensionsToExcludeNextLink;
            this.changedFields = changedFields.add("defenderFileExtensionsToExclude");
            return this;
        }

        /**
         * <i>“Files and folder to exclude from scans and real time protection.”</i>
         * 
         * @param defenderFilesAndFoldersToExclude
         *            value of {@code defenderFilesAndFoldersToExclude} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderFilesAndFoldersToExclude(List<String> defenderFilesAndFoldersToExclude) {
            this.defenderFilesAndFoldersToExclude = defenderFilesAndFoldersToExclude;
            this.changedFields = changedFields.add("defenderFilesAndFoldersToExclude");
            return this;
        }

        /**
         * <i>“Files and folder to exclude from scans and real time protection.”</i>
         * 
         * @param defenderFilesAndFoldersToExclude
         *            value of {@code defenderFilesAndFoldersToExclude} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderFilesAndFoldersToExclude(String... defenderFilesAndFoldersToExclude) {
            return defenderFilesAndFoldersToExclude(Arrays.asList(defenderFilesAndFoldersToExclude));
        }

        /**
         * <i>“Files and folder to exclude from scans and real time protection.”</i>
         * 
         * @param defenderFilesAndFoldersToExcludeNextLink
         *            value of {@code defenderFilesAndFoldersToExclude@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderFilesAndFoldersToExcludeNextLink(String defenderFilesAndFoldersToExcludeNextLink) {
            this.defenderFilesAndFoldersToExcludeNextLink = defenderFilesAndFoldersToExcludeNextLink;
            this.changedFields = changedFields.add("defenderFilesAndFoldersToExclude");
            return this;
        }

        /**
         * <i>“List of paths to exe that are allowed to access protected folders”</i>
         * 
         * @param defenderGuardedFoldersAllowedAppPaths
         *            value of {@code defenderGuardedFoldersAllowedAppPaths} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderGuardedFoldersAllowedAppPaths(List<String> defenderGuardedFoldersAllowedAppPaths) {
            this.defenderGuardedFoldersAllowedAppPaths = defenderGuardedFoldersAllowedAppPaths;
            this.changedFields = changedFields.add("defenderGuardedFoldersAllowedAppPaths");
            return this;
        }

        /**
         * <i>“List of paths to exe that are allowed to access protected folders”</i>
         * 
         * @param defenderGuardedFoldersAllowedAppPaths
         *            value of {@code defenderGuardedFoldersAllowedAppPaths} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderGuardedFoldersAllowedAppPaths(String... defenderGuardedFoldersAllowedAppPaths) {
            return defenderGuardedFoldersAllowedAppPaths(Arrays.asList(defenderGuardedFoldersAllowedAppPaths));
        }

        /**
         * <i>“List of paths to exe that are allowed to access protected folders”</i>
         * 
         * @param defenderGuardedFoldersAllowedAppPathsNextLink
         *            value of {@code defenderGuardedFoldersAllowedAppPaths@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderGuardedFoldersAllowedAppPathsNextLink(String defenderGuardedFoldersAllowedAppPathsNextLink) {
            this.defenderGuardedFoldersAllowedAppPathsNextLink = defenderGuardedFoldersAllowedAppPathsNextLink;
            this.changedFields = changedFields.add("defenderGuardedFoldersAllowedAppPaths");
            return this;
        }

        /**
         * <i>“Value indicating the behavior of protected folders”</i>
         * 
         * @param defenderGuardMyFoldersType
         *            value of {@code defenderGuardMyFoldersType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderGuardMyFoldersType(FolderProtectionType defenderGuardMyFoldersType) {
            this.defenderGuardMyFoldersType = defenderGuardMyFoldersType;
            this.changedFields = changedFields.add("defenderGuardMyFoldersType");
            return this;
        }

        /**
         * <i>“Value indicating the behavior of NetworkProtection”</i>
         * 
         * @param defenderNetworkProtectionType
         *            value of {@code defenderNetworkProtectionType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderNetworkProtectionType(DefenderProtectionType defenderNetworkProtectionType) {
            this.defenderNetworkProtectionType = defenderNetworkProtectionType;
            this.changedFields = changedFields.add("defenderNetworkProtectionType");
            return this;
        }

        /**
         * <i>“Value indicating the behavior of Office applications/macros creating or
         * launching executable content”</i>
         * 
         * @param defenderOfficeAppsExecutableContentCreationOrLaunch
         *            value of {@code defenderOfficeAppsExecutableContentCreationOrLaunch} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderOfficeAppsExecutableContentCreationOrLaunch(DefenderProtectionType defenderOfficeAppsExecutableContentCreationOrLaunch) {
            this.defenderOfficeAppsExecutableContentCreationOrLaunch = defenderOfficeAppsExecutableContentCreationOrLaunch;
            this.changedFields = changedFields.add("defenderOfficeAppsExecutableContentCreationOrLaunch");
            return this;
        }

        /**
         * <i>“Value indicating the behavior of Office applications/macros creating or
         * launching executable content”</i>
         * 
         * @param defenderOfficeAppsExecutableContentCreationOrLaunchType
         *            value of {@code defenderOfficeAppsExecutableContentCreationOrLaunchType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderOfficeAppsExecutableContentCreationOrLaunchType(DefenderAttackSurfaceType defenderOfficeAppsExecutableContentCreationOrLaunchType) {
            this.defenderOfficeAppsExecutableContentCreationOrLaunchType = defenderOfficeAppsExecutableContentCreationOrLaunchType;
            this.changedFields = changedFields.add("defenderOfficeAppsExecutableContentCreationOrLaunchType");
            return this;
        }

        /**
         * <i>“Value indicating the behavior of Office application launching child processes”</i>
         * 
         * @param defenderOfficeAppsLaunchChildProcess
         *            value of {@code defenderOfficeAppsLaunchChildProcess} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderOfficeAppsLaunchChildProcess(DefenderProtectionType defenderOfficeAppsLaunchChildProcess) {
            this.defenderOfficeAppsLaunchChildProcess = defenderOfficeAppsLaunchChildProcess;
            this.changedFields = changedFields.add("defenderOfficeAppsLaunchChildProcess");
            return this;
        }

        /**
         * <i>“Value indicating the behavior of Office application launching child processes”</i>
         * 
         * @param defenderOfficeAppsLaunchChildProcessType
         *            value of {@code defenderOfficeAppsLaunchChildProcessType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderOfficeAppsLaunchChildProcessType(DefenderAttackSurfaceType defenderOfficeAppsLaunchChildProcessType) {
            this.defenderOfficeAppsLaunchChildProcessType = defenderOfficeAppsLaunchChildProcessType;
            this.changedFields = changedFields.add("defenderOfficeAppsLaunchChildProcessType");
            return this;
        }

        /**
         * <i>“Value indicating the behavior of  Office applications injecting into other
         * processes”</i>
         * 
         * @param defenderOfficeAppsOtherProcessInjection
         *            value of {@code defenderOfficeAppsOtherProcessInjection} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderOfficeAppsOtherProcessInjection(DefenderProtectionType defenderOfficeAppsOtherProcessInjection) {
            this.defenderOfficeAppsOtherProcessInjection = defenderOfficeAppsOtherProcessInjection;
            this.changedFields = changedFields.add("defenderOfficeAppsOtherProcessInjection");
            return this;
        }

        /**
         * <i>“Value indicating the behavior of Office applications injecting into other
         * processes”</i>
         * 
         * @param defenderOfficeAppsOtherProcessInjectionType
         *            value of {@code defenderOfficeAppsOtherProcessInjectionType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderOfficeAppsOtherProcessInjectionType(DefenderAttackSurfaceType defenderOfficeAppsOtherProcessInjectionType) {
            this.defenderOfficeAppsOtherProcessInjectionType = defenderOfficeAppsOtherProcessInjectionType;
            this.changedFields = changedFields.add("defenderOfficeAppsOtherProcessInjectionType");
            return this;
        }

        /**
         * <i>“Value indicating the behavior of Office communication applications, including
         * Microsoft Outlook, from creating child processes”</i>
         * 
         * @param defenderOfficeCommunicationAppsLaunchChildProcess
         *            value of {@code defenderOfficeCommunicationAppsLaunchChildProcess} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderOfficeCommunicationAppsLaunchChildProcess(DefenderProtectionType defenderOfficeCommunicationAppsLaunchChildProcess) {
            this.defenderOfficeCommunicationAppsLaunchChildProcess = defenderOfficeCommunicationAppsLaunchChildProcess;
            this.changedFields = changedFields.add("defenderOfficeCommunicationAppsLaunchChildProcess");
            return this;
        }

        /**
         * <i>“Value indicating the behavior of Win32 imports from Macro code in Office”</i>
         * 
         * @param defenderOfficeMacroCodeAllowWin32Imports
         *            value of {@code defenderOfficeMacroCodeAllowWin32Imports} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderOfficeMacroCodeAllowWin32Imports(DefenderProtectionType defenderOfficeMacroCodeAllowWin32Imports) {
            this.defenderOfficeMacroCodeAllowWin32Imports = defenderOfficeMacroCodeAllowWin32Imports;
            this.changedFields = changedFields.add("defenderOfficeMacroCodeAllowWin32Imports");
            return this;
        }

        /**
         * <i>“Value indicating the behavior of Win32 imports from Macro code in Office”</i>
         * 
         * @param defenderOfficeMacroCodeAllowWin32ImportsType
         *            value of {@code defenderOfficeMacroCodeAllowWin32ImportsType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderOfficeMacroCodeAllowWin32ImportsType(DefenderAttackSurfaceType defenderOfficeMacroCodeAllowWin32ImportsType) {
            this.defenderOfficeMacroCodeAllowWin32ImportsType = defenderOfficeMacroCodeAllowWin32ImportsType;
            this.changedFields = changedFields.add("defenderOfficeMacroCodeAllowWin32ImportsType");
            return this;
        }

        /**
         * <i>“Added in Windows 10, version 1607. Specifies the level of detection for
         * potentially unwanted applications (PUAs). Windows Defender alerts you when
         * potentially unwanted software is being downloaded or attempts to install itself
         * on your computer.”</i>
         * 
         * @param defenderPotentiallyUnwantedAppAction
         *            value of {@code defenderPotentiallyUnwantedAppAction} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderPotentiallyUnwantedAppAction(DefenderProtectionType defenderPotentiallyUnwantedAppAction) {
            this.defenderPotentiallyUnwantedAppAction = defenderPotentiallyUnwantedAppAction;
            this.changedFields = changedFields.add("defenderPotentiallyUnwantedAppAction");
            return this;
        }

        /**
         * <i>“Value indicating if credential stealing from the Windows local security
         * authority subsystem is permitted”</i>
         * 
         * @param defenderPreventCredentialStealingType
         *            value of {@code defenderPreventCredentialStealingType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderPreventCredentialStealingType(DefenderProtectionType defenderPreventCredentialStealingType) {
            this.defenderPreventCredentialStealingType = defenderPreventCredentialStealingType;
            this.changedFields = changedFields.add("defenderPreventCredentialStealingType");
            return this;
        }

        /**
         * <i>“Value indicating response to process creations originating from PSExec and WMI
         * commands”</i>
         * 
         * @param defenderProcessCreation
         *            value of {@code defenderProcessCreation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderProcessCreation(DefenderProtectionType defenderProcessCreation) {
            this.defenderProcessCreation = defenderProcessCreation;
            this.changedFields = changedFields.add("defenderProcessCreation");
            return this;
        }

        /**
         * <i>“Value indicating response to process creations originating from PSExec and WMI
         * commands”</i>
         * 
         * @param defenderProcessCreationType
         *            value of {@code defenderProcessCreationType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderProcessCreationType(DefenderAttackSurfaceType defenderProcessCreationType) {
            this.defenderProcessCreationType = defenderProcessCreationType;
            this.changedFields = changedFields.add("defenderProcessCreationType");
            return this;
        }

        /**
         * <i>“Processes to exclude from scans and real time protection.”</i>
         * 
         * @param defenderProcessesToExclude
         *            value of {@code defenderProcessesToExclude} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderProcessesToExclude(List<String> defenderProcessesToExclude) {
            this.defenderProcessesToExclude = defenderProcessesToExclude;
            this.changedFields = changedFields.add("defenderProcessesToExclude");
            return this;
        }

        /**
         * <i>“Processes to exclude from scans and real time protection.”</i>
         * 
         * @param defenderProcessesToExclude
         *            value of {@code defenderProcessesToExclude} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderProcessesToExclude(String... defenderProcessesToExclude) {
            return defenderProcessesToExclude(Arrays.asList(defenderProcessesToExclude));
        }

        /**
         * <i>“Processes to exclude from scans and real time protection.”</i>
         * 
         * @param defenderProcessesToExcludeNextLink
         *            value of {@code defenderProcessesToExclude@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderProcessesToExcludeNextLink(String defenderProcessesToExcludeNextLink) {
            this.defenderProcessesToExcludeNextLink = defenderProcessesToExcludeNextLink;
            this.changedFields = changedFields.add("defenderProcessesToExclude");
            return this;
        }

        /**
         * <i>“Controls which sets of files should be monitored.”</i>
         * 
         * @param defenderScanDirection
         *            value of {@code defenderScanDirection} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderScanDirection(DefenderRealtimeScanDirection defenderScanDirection) {
            this.defenderScanDirection = defenderScanDirection;
            this.changedFields = changedFields.add("defenderScanDirection");
            return this;
        }

        /**
         * <i>“Represents the average CPU load factor for the Windows Defender scan (in percent
         * ). The default value is 50. Valid values 0 to 100”</i>
         * 
         * @param defenderScanMaxCpuPercentage
         *            value of {@code defenderScanMaxCpuPercentage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderScanMaxCpuPercentage(Integer defenderScanMaxCpuPercentage) {
            this.defenderScanMaxCpuPercentage = defenderScanMaxCpuPercentage;
            this.changedFields = changedFields.add("defenderScanMaxCpuPercentage");
            return this;
        }

        /**
         * <i>“Selects whether to perform a quick scan or full scan.”</i>
         * 
         * @param defenderScanType
         *            value of {@code defenderScanType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderScanType(DefenderScanType defenderScanType) {
            this.defenderScanType = defenderScanType;
            this.changedFields = changedFields.add("defenderScanType");
            return this;
        }

        /**
         * <i>“Selects the time of day that the Windows Defender quick scan should run. For
         * example, a value of 0=12:00AM, a value of 60=1:00AM, a value of 120=2:00, and so
         * on, up to a value of 1380=11:00PM. The default value is 120”</i>
         * 
         * @param defenderScheduledQuickScanTime
         *            value of {@code defenderScheduledQuickScanTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderScheduledQuickScanTime(LocalTime defenderScheduledQuickScanTime) {
            this.defenderScheduledQuickScanTime = defenderScheduledQuickScanTime;
            this.changedFields = changedFields.add("defenderScheduledQuickScanTime");
            return this;
        }

        /**
         * <i>“Selects the day that the Windows Defender scan should run.”</i>
         * 
         * @param defenderScheduledScanDay
         *            value of {@code defenderScheduledScanDay} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderScheduledScanDay(WeeklySchedule defenderScheduledScanDay) {
            this.defenderScheduledScanDay = defenderScheduledScanDay;
            this.changedFields = changedFields.add("defenderScheduledScanDay");
            return this;
        }

        /**
         * <i>“Selects the time of day that the Windows Defender scan should run.”</i>
         * 
         * @param defenderScheduledScanTime
         *            value of {@code defenderScheduledScanTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderScheduledScanTime(LocalTime defenderScheduledScanTime) {
            this.defenderScheduledScanTime = defenderScheduledScanTime;
            this.changedFields = changedFields.add("defenderScheduledScanTime");
            return this;
        }

        /**
         * <i>“Value indicating the behavior of js/vbs executing payload downloaded from
         * Internet”</i>
         * 
         * @param defenderScriptDownloadedPayloadExecution
         *            value of {@code defenderScriptDownloadedPayloadExecution} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderScriptDownloadedPayloadExecution(DefenderProtectionType defenderScriptDownloadedPayloadExecution) {
            this.defenderScriptDownloadedPayloadExecution = defenderScriptDownloadedPayloadExecution;
            this.changedFields = changedFields.add("defenderScriptDownloadedPayloadExecution");
            return this;
        }

        /**
         * <i>“Value indicating the behavior of js/vbs executing payload downloaded from
         * Internet”</i>
         * 
         * @param defenderScriptDownloadedPayloadExecutionType
         *            value of {@code defenderScriptDownloadedPayloadExecutionType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderScriptDownloadedPayloadExecutionType(DefenderAttackSurfaceType defenderScriptDownloadedPayloadExecutionType) {
            this.defenderScriptDownloadedPayloadExecutionType = defenderScriptDownloadedPayloadExecutionType;
            this.changedFields = changedFields.add("defenderScriptDownloadedPayloadExecutionType");
            return this;
        }

        /**
         * <i>“Value indicating the behavior of obfuscated js/vbs/ps/macro code”</i>
         * 
         * @param defenderScriptObfuscatedMacroCode
         *            value of {@code defenderScriptObfuscatedMacroCode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderScriptObfuscatedMacroCode(DefenderProtectionType defenderScriptObfuscatedMacroCode) {
            this.defenderScriptObfuscatedMacroCode = defenderScriptObfuscatedMacroCode;
            this.changedFields = changedFields.add("defenderScriptObfuscatedMacroCode");
            return this;
        }

        /**
         * <i>“Value indicating the behavior of obfuscated js/vbs/ps/macro code”</i>
         * 
         * @param defenderScriptObfuscatedMacroCodeType
         *            value of {@code defenderScriptObfuscatedMacroCodeType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderScriptObfuscatedMacroCodeType(DefenderAttackSurfaceType defenderScriptObfuscatedMacroCodeType) {
            this.defenderScriptObfuscatedMacroCodeType = defenderScriptObfuscatedMacroCodeType;
            this.changedFields = changedFields.add("defenderScriptObfuscatedMacroCodeType");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block user from overriding Exploit Protection
         * settings.”</i>
         * 
         * @param defenderSecurityCenterBlockExploitProtectionOverride
         *            value of {@code defenderSecurityCenterBlockExploitProtectionOverride} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderSecurityCenterBlockExploitProtectionOverride(Boolean defenderSecurityCenterBlockExploitProtectionOverride) {
            this.defenderSecurityCenterBlockExploitProtectionOverride = defenderSecurityCenterBlockExploitProtectionOverride;
            this.changedFields = changedFields.add("defenderSecurityCenterBlockExploitProtectionOverride");
            return this;
        }

        /**
         * <i>“Used to disable the display of the account protection area.”</i>
         * 
         * @param defenderSecurityCenterDisableAccountUI
         *            value of {@code defenderSecurityCenterDisableAccountUI} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderSecurityCenterDisableAccountUI(Boolean defenderSecurityCenterDisableAccountUI) {
            this.defenderSecurityCenterDisableAccountUI = defenderSecurityCenterDisableAccountUI;
            this.changedFields = changedFields.add("defenderSecurityCenterDisableAccountUI");
            return this;
        }

        /**
         * <i>“Used to disable the display of the app and browser protection area.”</i>
         * 
         * @param defenderSecurityCenterDisableAppBrowserUI
         *            value of {@code defenderSecurityCenterDisableAppBrowserUI} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderSecurityCenterDisableAppBrowserUI(Boolean defenderSecurityCenterDisableAppBrowserUI) {
            this.defenderSecurityCenterDisableAppBrowserUI = defenderSecurityCenterDisableAppBrowserUI;
            this.changedFields = changedFields.add("defenderSecurityCenterDisableAppBrowserUI");
            return this;
        }

        /**
         * <i>“Used to disable the display of the Clear TPM button.”</i>
         * 
         * @param defenderSecurityCenterDisableClearTpmUI
         *            value of {@code defenderSecurityCenterDisableClearTpmUI} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderSecurityCenterDisableClearTpmUI(Boolean defenderSecurityCenterDisableClearTpmUI) {
            this.defenderSecurityCenterDisableClearTpmUI = defenderSecurityCenterDisableClearTpmUI;
            this.changedFields = changedFields.add("defenderSecurityCenterDisableClearTpmUI");
            return this;
        }

        /**
         * <i>“Used to disable the display of the family options area.”</i>
         * 
         * @param defenderSecurityCenterDisableFamilyUI
         *            value of {@code defenderSecurityCenterDisableFamilyUI} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderSecurityCenterDisableFamilyUI(Boolean defenderSecurityCenterDisableFamilyUI) {
            this.defenderSecurityCenterDisableFamilyUI = defenderSecurityCenterDisableFamilyUI;
            this.changedFields = changedFields.add("defenderSecurityCenterDisableFamilyUI");
            return this;
        }

        /**
         * <i>“Used to disable the display of the hardware protection area.”</i>
         * 
         * @param defenderSecurityCenterDisableHardwareUI
         *            value of {@code defenderSecurityCenterDisableHardwareUI} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderSecurityCenterDisableHardwareUI(Boolean defenderSecurityCenterDisableHardwareUI) {
            this.defenderSecurityCenterDisableHardwareUI = defenderSecurityCenterDisableHardwareUI;
            this.changedFields = changedFields.add("defenderSecurityCenterDisableHardwareUI");
            return this;
        }

        /**
         * <i>“Used to disable the display of the device performance and health area.”</i>
         * 
         * @param defenderSecurityCenterDisableHealthUI
         *            value of {@code defenderSecurityCenterDisableHealthUI} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderSecurityCenterDisableHealthUI(Boolean defenderSecurityCenterDisableHealthUI) {
            this.defenderSecurityCenterDisableHealthUI = defenderSecurityCenterDisableHealthUI;
            this.changedFields = changedFields.add("defenderSecurityCenterDisableHealthUI");
            return this;
        }

        /**
         * <i>“Used to disable the display of the firewall and network protection area.”</i>
         * 
         * @param defenderSecurityCenterDisableNetworkUI
         *            value of {@code defenderSecurityCenterDisableNetworkUI} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderSecurityCenterDisableNetworkUI(Boolean defenderSecurityCenterDisableNetworkUI) {
            this.defenderSecurityCenterDisableNetworkUI = defenderSecurityCenterDisableNetworkUI;
            this.changedFields = changedFields.add("defenderSecurityCenterDisableNetworkUI");
            return this;
        }

        /**
         * <i>“Used to disable the display of the notification area control. The user needs to
         * either sign out and sign in or reboot the computer for this setting to take
         * effect.”</i>
         * 
         * @param defenderSecurityCenterDisableNotificationAreaUI
         *            value of {@code defenderSecurityCenterDisableNotificationAreaUI} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderSecurityCenterDisableNotificationAreaUI(Boolean defenderSecurityCenterDisableNotificationAreaUI) {
            this.defenderSecurityCenterDisableNotificationAreaUI = defenderSecurityCenterDisableNotificationAreaUI;
            this.changedFields = changedFields.add("defenderSecurityCenterDisableNotificationAreaUI");
            return this;
        }

        /**
         * <i>“Used to disable the display of the ransomware protection area.”</i>
         * 
         * @param defenderSecurityCenterDisableRansomwareUI
         *            value of {@code defenderSecurityCenterDisableRansomwareUI} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderSecurityCenterDisableRansomwareUI(Boolean defenderSecurityCenterDisableRansomwareUI) {
            this.defenderSecurityCenterDisableRansomwareUI = defenderSecurityCenterDisableRansomwareUI;
            this.changedFields = changedFields.add("defenderSecurityCenterDisableRansomwareUI");
            return this;
        }

        /**
         * <i>“Used to disable the display of the secure boot area under Device security.”</i>
         * 
         * @param defenderSecurityCenterDisableSecureBootUI
         *            value of {@code defenderSecurityCenterDisableSecureBootUI} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderSecurityCenterDisableSecureBootUI(Boolean defenderSecurityCenterDisableSecureBootUI) {
            this.defenderSecurityCenterDisableSecureBootUI = defenderSecurityCenterDisableSecureBootUI;
            this.changedFields = changedFields.add("defenderSecurityCenterDisableSecureBootUI");
            return this;
        }

        /**
         * <i>“Used to disable the display of the security process troubleshooting under Device
         * security.”</i>
         * 
         * @param defenderSecurityCenterDisableTroubleshootingUI
         *            value of {@code defenderSecurityCenterDisableTroubleshootingUI} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderSecurityCenterDisableTroubleshootingUI(Boolean defenderSecurityCenterDisableTroubleshootingUI) {
            this.defenderSecurityCenterDisableTroubleshootingUI = defenderSecurityCenterDisableTroubleshootingUI;
            this.changedFields = changedFields.add("defenderSecurityCenterDisableTroubleshootingUI");
            return this;
        }

        /**
         * <i>“Used to disable the display of the virus and threat protection area.”</i>
         * 
         * @param defenderSecurityCenterDisableVirusUI
         *            value of {@code defenderSecurityCenterDisableVirusUI} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderSecurityCenterDisableVirusUI(Boolean defenderSecurityCenterDisableVirusUI) {
            this.defenderSecurityCenterDisableVirusUI = defenderSecurityCenterDisableVirusUI;
            this.changedFields = changedFields.add("defenderSecurityCenterDisableVirusUI");
            return this;
        }

        /**
         * <i>“Used to disable the display of update TPM Firmware when a vulnerable firmware is
         * detected.”</i>
         * 
         * @param defenderSecurityCenterDisableVulnerableTpmFirmwareUpdateUI
         *            value of {@code defenderSecurityCenterDisableVulnerableTpmFirmwareUpdateUI} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderSecurityCenterDisableVulnerableTpmFirmwareUpdateUI(Boolean defenderSecurityCenterDisableVulnerableTpmFirmwareUpdateUI) {
            this.defenderSecurityCenterDisableVulnerableTpmFirmwareUpdateUI = defenderSecurityCenterDisableVulnerableTpmFirmwareUpdateUI;
            this.changedFields = changedFields.add("defenderSecurityCenterDisableVulnerableTpmFirmwareUpdateUI");
            return this;
        }

        /**
         * <i>“The email address that is displayed to users.”</i>
         * 
         * @param defenderSecurityCenterHelpEmail
         *            value of {@code defenderSecurityCenterHelpEmail} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderSecurityCenterHelpEmail(String defenderSecurityCenterHelpEmail) {
            this.defenderSecurityCenterHelpEmail = defenderSecurityCenterHelpEmail;
            this.changedFields = changedFields.add("defenderSecurityCenterHelpEmail");
            return this;
        }

        /**
         * <i>“The phone number or Skype ID that is displayed to users.”</i>
         * 
         * @param defenderSecurityCenterHelpPhone
         *            value of {@code defenderSecurityCenterHelpPhone} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderSecurityCenterHelpPhone(String defenderSecurityCenterHelpPhone) {
            this.defenderSecurityCenterHelpPhone = defenderSecurityCenterHelpPhone;
            this.changedFields = changedFields.add("defenderSecurityCenterHelpPhone");
            return this;
        }

        /**
         * <i>“The help portal URL this is displayed to users.”</i>
         * 
         * @param defenderSecurityCenterHelpURL
         *            value of {@code defenderSecurityCenterHelpURL} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderSecurityCenterHelpURL(String defenderSecurityCenterHelpURL) {
            this.defenderSecurityCenterHelpURL = defenderSecurityCenterHelpURL;
            this.changedFields = changedFields.add("defenderSecurityCenterHelpURL");
            return this;
        }

        /**
         * <i>“Configure where to display IT contact information to end users.”</i>
         * 
         * @param defenderSecurityCenterITContactDisplay
         *            value of {@code defenderSecurityCenterITContactDisplay} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderSecurityCenterITContactDisplay(DefenderSecurityCenterITContactDisplayType defenderSecurityCenterITContactDisplay) {
            this.defenderSecurityCenterITContactDisplay = defenderSecurityCenterITContactDisplay;
            this.changedFields = changedFields.add("defenderSecurityCenterITContactDisplay");
            return this;
        }

        /**
         * <i>“Notifications to show from the displayed areas of app”</i>
         * 
         * @param defenderSecurityCenterNotificationsFromApp
         *            value of {@code defenderSecurityCenterNotificationsFromApp} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderSecurityCenterNotificationsFromApp(DefenderSecurityCenterNotificationsFromAppType defenderSecurityCenterNotificationsFromApp) {
            this.defenderSecurityCenterNotificationsFromApp = defenderSecurityCenterNotificationsFromApp;
            this.changedFields = changedFields.add("defenderSecurityCenterNotificationsFromApp");
            return this;
        }

        /**
         * <i>“The company name that is displayed to the users.”</i>
         * 
         * @param defenderSecurityCenterOrganizationDisplayName
         *            value of {@code defenderSecurityCenterOrganizationDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderSecurityCenterOrganizationDisplayName(String defenderSecurityCenterOrganizationDisplayName) {
            this.defenderSecurityCenterOrganizationDisplayName = defenderSecurityCenterOrganizationDisplayName;
            this.changedFields = changedFields.add("defenderSecurityCenterOrganizationDisplayName");
            return this;
        }

        /**
         * <i>“Specifies the interval (in hours) that will be used to check for signatures, so
         * instead of using the ScheduleDay and ScheduleTime the check for new signatures
         * will be set according to the interval. Valid values 0 to 24”</i>
         * 
         * @param defenderSignatureUpdateIntervalInHours
         *            value of {@code defenderSignatureUpdateIntervalInHours} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderSignatureUpdateIntervalInHours(Integer defenderSignatureUpdateIntervalInHours) {
            this.defenderSignatureUpdateIntervalInHours = defenderSignatureUpdateIntervalInHours;
            this.changedFields = changedFields.add("defenderSignatureUpdateIntervalInHours");
            return this;
        }

        /**
         * <i>“Checks for the user consent level in Windows Defender to send data.”</i>
         * 
         * @param defenderSubmitSamplesConsentType
         *            value of {@code defenderSubmitSamplesConsentType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderSubmitSamplesConsentType(DefenderSubmitSamplesConsentType defenderSubmitSamplesConsentType) {
            this.defenderSubmitSamplesConsentType = defenderSubmitSamplesConsentType;
            this.changedFields = changedFields.add("defenderSubmitSamplesConsentType");
            return this;
        }

        /**
         * <i>“Value indicating response to executables that don't meet a prevalence, age, or
         * trusted list criteria”</i>
         * 
         * @param defenderUntrustedExecutable
         *            value of {@code defenderUntrustedExecutable} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderUntrustedExecutable(DefenderProtectionType defenderUntrustedExecutable) {
            this.defenderUntrustedExecutable = defenderUntrustedExecutable;
            this.changedFields = changedFields.add("defenderUntrustedExecutable");
            return this;
        }

        /**
         * <i>“Value indicating response to executables that don't meet a prevalence, age, or
         * trusted list criteria”</i>
         * 
         * @param defenderUntrustedExecutableType
         *            value of {@code defenderUntrustedExecutableType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderUntrustedExecutableType(DefenderAttackSurfaceType defenderUntrustedExecutableType) {
            this.defenderUntrustedExecutableType = defenderUntrustedExecutableType;
            this.changedFields = changedFields.add("defenderUntrustedExecutableType");
            return this;
        }

        /**
         * <i>“Value indicating response to untrusted and unsigned processes that run from USB”</i>
         * 
         * @param defenderUntrustedUSBProcess
         *            value of {@code defenderUntrustedUSBProcess} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderUntrustedUSBProcess(DefenderProtectionType defenderUntrustedUSBProcess) {
            this.defenderUntrustedUSBProcess = defenderUntrustedUSBProcess;
            this.changedFields = changedFields.add("defenderUntrustedUSBProcess");
            return this;
        }

        /**
         * <i>“Value indicating response to untrusted and unsigned processes that run from USB”</i>
         * 
         * @param defenderUntrustedUSBProcessType
         *            value of {@code defenderUntrustedUSBProcessType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defenderUntrustedUSBProcessType(DefenderAttackSurfaceType defenderUntrustedUSBProcessType) {
            this.defenderUntrustedUSBProcessType = defenderUntrustedUSBProcessType;
            this.changedFields = changedFields.add("defenderUntrustedUSBProcessType");
            return this;
        }

        /**
         * <i>“This property will be deprecated in May 2019 and will be replaced with property
         * DeviceGuardSecureBootWithDMA. Specifies whether Platform Security Level is
         * enabled at next reboot.”</i>
         * 
         * @param deviceGuardEnableSecureBootWithDMA
         *            value of {@code deviceGuardEnableSecureBootWithDMA} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceGuardEnableSecureBootWithDMA(Boolean deviceGuardEnableSecureBootWithDMA) {
            this.deviceGuardEnableSecureBootWithDMA = deviceGuardEnableSecureBootWithDMA;
            this.changedFields = changedFields.add("deviceGuardEnableSecureBootWithDMA");
            return this;
        }

        /**
         * <i>“Turns On Virtualization Based Security(VBS).”</i>
         * 
         * @param deviceGuardEnableVirtualizationBasedSecurity
         *            value of {@code deviceGuardEnableVirtualizationBasedSecurity} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceGuardEnableVirtualizationBasedSecurity(Boolean deviceGuardEnableVirtualizationBasedSecurity) {
            this.deviceGuardEnableVirtualizationBasedSecurity = deviceGuardEnableVirtualizationBasedSecurity;
            this.changedFields = changedFields.add("deviceGuardEnableVirtualizationBasedSecurity");
            return this;
        }

        /**
         * <i>“Allows the IT admin to configure the launch of System Guard.”</i>
         * 
         * @param deviceGuardLaunchSystemGuard
         *            value of {@code deviceGuardLaunchSystemGuard} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceGuardLaunchSystemGuard(Enablement deviceGuardLaunchSystemGuard) {
            this.deviceGuardLaunchSystemGuard = deviceGuardLaunchSystemGuard;
            this.changedFields = changedFields.add("deviceGuardLaunchSystemGuard");
            return this;
        }

        /**
         * <i>“Turn on Credential Guard when Platform Security Level with Secure Boot and
         * Virtualization Based Security are both enabled.”</i>
         * 
         * @param deviceGuardLocalSystemAuthorityCredentialGuardSettings
         *            value of {@code deviceGuardLocalSystemAuthorityCredentialGuardSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceGuardLocalSystemAuthorityCredentialGuardSettings(DeviceGuardLocalSystemAuthorityCredentialGuardType deviceGuardLocalSystemAuthorityCredentialGuardSettings) {
            this.deviceGuardLocalSystemAuthorityCredentialGuardSettings = deviceGuardLocalSystemAuthorityCredentialGuardSettings;
            this.changedFields = changedFields.add("deviceGuardLocalSystemAuthorityCredentialGuardSettings");
            return this;
        }

        /**
         * <i>“Specifies whether Platform Security Level is enabled at next reboot.”</i>
         * 
         * @param deviceGuardSecureBootWithDMA
         *            value of {@code deviceGuardSecureBootWithDMA} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceGuardSecureBootWithDMA(SecureBootWithDMAType deviceGuardSecureBootWithDMA) {
            this.deviceGuardSecureBootWithDMA = deviceGuardSecureBootWithDMA;
            this.changedFields = changedFields.add("deviceGuardSecureBootWithDMA");
            return this;
        }

        /**
         * <i>“This policy is intended to provide additional security against external DMA
         * capable devices. It allows for more control over the enumeration of external DMA
         * capable devices incompatible with DMA Remapping/device memory isolation and
         * sandboxing. This policy only takes effect when Kernel DMA Protection is
         * supported and enabled by the system firmware. Kernel DMA Protection is a
         * platform feature that cannot be controlled via policy or by end user. It has to
         * be supported by the system at the time of manufacturing. To check if the system
         * supports Kernel DMA Protection, please check the Kernel DMA Protection field in
         * the Summary page of MSINFO32.exe.”</i>
         * 
         * @param dmaGuardDeviceEnumerationPolicy
         *            value of {@code dmaGuardDeviceEnumerationPolicy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dmaGuardDeviceEnumerationPolicy(DmaGuardDeviceEnumerationPolicyType dmaGuardDeviceEnumerationPolicy) {
            this.dmaGuardDeviceEnumerationPolicy = dmaGuardDeviceEnumerationPolicy;
            this.changedFields = changedFields.add("dmaGuardDeviceEnumerationPolicy");
            return this;
        }

        /**
         * <i>“Blocks stateful FTP connections to the device”</i>
         * 
         * @param firewallBlockStatefulFTP
         *            value of {@code firewallBlockStatefulFTP} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder firewallBlockStatefulFTP(Boolean firewallBlockStatefulFTP) {
            this.firewallBlockStatefulFTP = firewallBlockStatefulFTP;
            this.changedFields = changedFields.add("firewallBlockStatefulFTP");
            return this;
        }

        /**
         * <i>“Specify how the certificate revocation list is to be enforced”</i>
         * 
         * @param firewallCertificateRevocationListCheckMethod
         *            value of {@code firewallCertificateRevocationListCheckMethod} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder firewallCertificateRevocationListCheckMethod(FirewallCertificateRevocationListCheckMethodType firewallCertificateRevocationListCheckMethod) {
            this.firewallCertificateRevocationListCheckMethod = firewallCertificateRevocationListCheckMethod;
            this.changedFields = changedFields.add("firewallCertificateRevocationListCheckMethod");
            return this;
        }

        /**
         * <i>“Configures the idle timeout for security associations, in seconds, from 300 to
         * 3600 inclusive. This is the period after which security associations will expire
         * and be deleted. Valid values 300 to 3600”</i>
         * 
         * @param firewallIdleTimeoutForSecurityAssociationInSeconds
         *            value of {@code firewallIdleTimeoutForSecurityAssociationInSeconds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder firewallIdleTimeoutForSecurityAssociationInSeconds(Integer firewallIdleTimeoutForSecurityAssociationInSeconds) {
            this.firewallIdleTimeoutForSecurityAssociationInSeconds = firewallIdleTimeoutForSecurityAssociationInSeconds;
            this.changedFields = changedFields.add("firewallIdleTimeoutForSecurityAssociationInSeconds");
            return this;
        }

        /**
         * <i>“Configures IPSec exemptions to allow both IPv4 and IPv6 DHCP traffic”</i>
         * 
         * @param firewallIPSecExemptionsAllowDHCP
         *            value of {@code firewallIPSecExemptionsAllowDHCP} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder firewallIPSecExemptionsAllowDHCP(Boolean firewallIPSecExemptionsAllowDHCP) {
            this.firewallIPSecExemptionsAllowDHCP = firewallIPSecExemptionsAllowDHCP;
            this.changedFields = changedFields.add("firewallIPSecExemptionsAllowDHCP");
            return this;
        }

        /**
         * <i>“Configures IPSec exemptions to allow ICMP”</i>
         * 
         * @param firewallIPSecExemptionsAllowICMP
         *            value of {@code firewallIPSecExemptionsAllowICMP} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder firewallIPSecExemptionsAllowICMP(Boolean firewallIPSecExemptionsAllowICMP) {
            this.firewallIPSecExemptionsAllowICMP = firewallIPSecExemptionsAllowICMP;
            this.changedFields = changedFields.add("firewallIPSecExemptionsAllowICMP");
            return this;
        }

        /**
         * <i>“Configures IPSec exemptions to allow neighbor discovery IPv6 ICMP type-codes”</i>
         * 
         * @param firewallIPSecExemptionsAllowNeighborDiscovery
         *            value of {@code firewallIPSecExemptionsAllowNeighborDiscovery} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder firewallIPSecExemptionsAllowNeighborDiscovery(Boolean firewallIPSecExemptionsAllowNeighborDiscovery) {
            this.firewallIPSecExemptionsAllowNeighborDiscovery = firewallIPSecExemptionsAllowNeighborDiscovery;
            this.changedFields = changedFields.add("firewallIPSecExemptionsAllowNeighborDiscovery");
            return this;
        }

        /**
         * <i>“Configures IPSec exemptions to allow router discovery IPv6 ICMP type-codes”</i>
         * 
         * @param firewallIPSecExemptionsAllowRouterDiscovery
         *            value of {@code firewallIPSecExemptionsAllowRouterDiscovery} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder firewallIPSecExemptionsAllowRouterDiscovery(Boolean firewallIPSecExemptionsAllowRouterDiscovery) {
            this.firewallIPSecExemptionsAllowRouterDiscovery = firewallIPSecExemptionsAllowRouterDiscovery;
            this.changedFields = changedFields.add("firewallIPSecExemptionsAllowRouterDiscovery");
            return this;
        }

        /**
         * <i>“Configures IPSec exemptions to no exemptions”</i>
         * 
         * @param firewallIPSecExemptionsNone
         *            value of {@code firewallIPSecExemptionsNone} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder firewallIPSecExemptionsNone(Boolean firewallIPSecExemptionsNone) {
            this.firewallIPSecExemptionsNone = firewallIPSecExemptionsNone;
            this.changedFields = changedFields.add("firewallIPSecExemptionsNone");
            return this;
        }

        /**
         * <i>“If an authentication set is not fully supported by a keying module, direct the
         * module to ignore only unsupported authentication suites rather than the entire
         * set”</i>
         * 
         * @param firewallMergeKeyingModuleSettings
         *            value of {@code firewallMergeKeyingModuleSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder firewallMergeKeyingModuleSettings(Boolean firewallMergeKeyingModuleSettings) {
            this.firewallMergeKeyingModuleSettings = firewallMergeKeyingModuleSettings;
            this.changedFields = changedFields.add("firewallMergeKeyingModuleSettings");
            return this;
        }

        /**
         * <i>“Configures how packet queueing should be applied in the tunnel gateway scenario”</i>
         * 
         * @param firewallPacketQueueingMethod
         *            value of {@code firewallPacketQueueingMethod} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder firewallPacketQueueingMethod(FirewallPacketQueueingMethodType firewallPacketQueueingMethod) {
            this.firewallPacketQueueingMethod = firewallPacketQueueingMethod;
            this.changedFields = changedFields.add("firewallPacketQueueingMethod");
            return this;
        }

        /**
         * <i>“Select the preshared key encoding to be used”</i>
         * 
         * @param firewallPreSharedKeyEncodingMethod
         *            value of {@code firewallPreSharedKeyEncodingMethod} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder firewallPreSharedKeyEncodingMethod(FirewallPreSharedKeyEncodingMethodType firewallPreSharedKeyEncodingMethod) {
            this.firewallPreSharedKeyEncodingMethod = firewallPreSharedKeyEncodingMethod;
            this.changedFields = changedFields.add("firewallPreSharedKeyEncodingMethod");
            return this;
        }

        /**
         * <i>“Configures the firewall profile settings for domain networks”</i>
         * 
         * @param firewallProfileDomain
         *            value of {@code firewallProfileDomain} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder firewallProfileDomain(WindowsFirewallNetworkProfile firewallProfileDomain) {
            this.firewallProfileDomain = firewallProfileDomain;
            this.changedFields = changedFields.add("firewallProfileDomain");
            return this;
        }

        /**
         * <i>“Configures the firewall profile settings for private networks”</i>
         * 
         * @param firewallProfilePrivate
         *            value of {@code firewallProfilePrivate} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder firewallProfilePrivate(WindowsFirewallNetworkProfile firewallProfilePrivate) {
            this.firewallProfilePrivate = firewallProfilePrivate;
            this.changedFields = changedFields.add("firewallProfilePrivate");
            return this;
        }

        /**
         * <i>“Configures the firewall profile settings for public networks”</i>
         * 
         * @param firewallProfilePublic
         *            value of {@code firewallProfilePublic} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder firewallProfilePublic(WindowsFirewallNetworkProfile firewallProfilePublic) {
            this.firewallProfilePublic = firewallProfilePublic;
            this.changedFields = changedFields.add("firewallProfilePublic");
            return this;
        }

        /**
         * <i>“Configures the firewall rule settings. This collection can contain a maximum of
         * 150 elements.”</i>
         * 
         * @param firewallRules
         *            value of {@code firewallRules} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder firewallRules(List<WindowsFirewallRule> firewallRules) {
            this.firewallRules = firewallRules;
            this.changedFields = changedFields.add("firewallRules");
            return this;
        }

        /**
         * <i>“Configures the firewall rule settings. This collection can contain a maximum of
         * 150 elements.”</i>
         * 
         * @param firewallRules
         *            value of {@code firewallRules} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder firewallRules(WindowsFirewallRule... firewallRules) {
            return firewallRules(Arrays.asList(firewallRules));
        }

        /**
         * <i>“Configures the firewall rule settings. This collection can contain a maximum of
         * 150 elements.”</i>
         * 
         * @param firewallRulesNextLink
         *            value of {@code firewallRules@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder firewallRulesNextLink(String firewallRulesNextLink) {
            this.firewallRulesNextLink = firewallRulesNextLink;
            this.changedFields = changedFields.add("firewallRules");
            return this;
        }

        /**
         * <i>“This security setting determines which challenge/response authentication
         * protocol is used for network logons.”</i>
         * 
         * @param lanManagerAuthenticationLevel
         *            value of {@code lanManagerAuthenticationLevel} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lanManagerAuthenticationLevel(LanManagerAuthenticationLevel lanManagerAuthenticationLevel) {
            this.lanManagerAuthenticationLevel = lanManagerAuthenticationLevel;
            this.changedFields = changedFields.add("lanManagerAuthenticationLevel");
            return this;
        }

        /**
         * <i>“If enabled,the SMB client will allow insecure guest logons. If not configured,
         * the SMB client will reject insecure guest logons.”</i>
         * 
         * @param lanManagerWorkstationDisableInsecureGuestLogons
         *            value of {@code lanManagerWorkstationDisableInsecureGuestLogons} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lanManagerWorkstationDisableInsecureGuestLogons(Boolean lanManagerWorkstationDisableInsecureGuestLogons) {
            this.lanManagerWorkstationDisableInsecureGuestLogons = lanManagerWorkstationDisableInsecureGuestLogons;
            this.changedFields = changedFields.add("lanManagerWorkstationDisableInsecureGuestLogons");
            return this;
        }

        /**
         * <i>“Define a different account name to be associated with the security identifier (
         * SID) for the account “Administrator”.”</i>
         * 
         * @param localSecurityOptionsAdministratorAccountName
         *            value of {@code localSecurityOptionsAdministratorAccountName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsAdministratorAccountName(String localSecurityOptionsAdministratorAccountName) {
            this.localSecurityOptionsAdministratorAccountName = localSecurityOptionsAdministratorAccountName;
            this.changedFields = changedFields.add("localSecurityOptionsAdministratorAccountName");
            return this;
        }

        /**
         * <i>“Define the behavior of the elevation prompt for admins in Admin Approval Mode.”</i>
         * 
         * @param localSecurityOptionsAdministratorElevationPromptBehavior
         *            value of {@code localSecurityOptionsAdministratorElevationPromptBehavior} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsAdministratorElevationPromptBehavior(LocalSecurityOptionsAdministratorElevationPromptBehaviorType localSecurityOptionsAdministratorElevationPromptBehavior) {
            this.localSecurityOptionsAdministratorElevationPromptBehavior = localSecurityOptionsAdministratorElevationPromptBehavior;
            this.changedFields = changedFields.add("localSecurityOptionsAdministratorElevationPromptBehavior");
            return this;
        }

        /**
         * <i>“This security setting determines whether to allows anonymous users to perform
         * certain activities, such as enumerating the names of domain accounts and network
         * shares.”</i>
         * 
         * @param localSecurityOptionsAllowAnonymousEnumerationOfSAMAccountsAndShares
         *            value of {@code localSecurityOptionsAllowAnonymousEnumerationOfSAMAccountsAndShares} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsAllowAnonymousEnumerationOfSAMAccountsAndShares(Boolean localSecurityOptionsAllowAnonymousEnumerationOfSAMAccountsAndShares) {
            this.localSecurityOptionsAllowAnonymousEnumerationOfSAMAccountsAndShares = localSecurityOptionsAllowAnonymousEnumerationOfSAMAccountsAndShares;
            this.changedFields = changedFields.add("localSecurityOptionsAllowAnonymousEnumerationOfSAMAccountsAndShares");
            return this;
        }

        /**
         * <i>“Block PKU2U authentication requests to this device to use online identities.”</i>
         * 
         * @param localSecurityOptionsAllowPKU2UAuthenticationRequests
         *            value of {@code localSecurityOptionsAllowPKU2UAuthenticationRequests} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsAllowPKU2UAuthenticationRequests(Boolean localSecurityOptionsAllowPKU2UAuthenticationRequests) {
            this.localSecurityOptionsAllowPKU2UAuthenticationRequests = localSecurityOptionsAllowPKU2UAuthenticationRequests;
            this.changedFields = changedFields.add("localSecurityOptionsAllowPKU2UAuthenticationRequests");
            return this;
        }

        /**
         * <i>“Edit the default Security Descriptor Definition Language string to allow or deny
         * users and groups to make remote calls to the SAM.”</i>
         * 
         * @param localSecurityOptionsAllowRemoteCallsToSecurityAccountsManager
         *            value of {@code localSecurityOptionsAllowRemoteCallsToSecurityAccountsManager} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsAllowRemoteCallsToSecurityAccountsManager(String localSecurityOptionsAllowRemoteCallsToSecurityAccountsManager) {
            this.localSecurityOptionsAllowRemoteCallsToSecurityAccountsManager = localSecurityOptionsAllowRemoteCallsToSecurityAccountsManager;
            this.changedFields = changedFields.add("localSecurityOptionsAllowRemoteCallsToSecurityAccountsManager");
            return this;
        }

        /**
         * <i>“UI helper boolean for
         * LocalSecurityOptionsAllowRemoteCallsToSecurityAccountsManager entity”</i>
         * 
         * @param localSecurityOptionsAllowRemoteCallsToSecurityAccountsManagerHelperBool
         *            value of {@code localSecurityOptionsAllowRemoteCallsToSecurityAccountsManagerHelperBool} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsAllowRemoteCallsToSecurityAccountsManagerHelperBool(Boolean localSecurityOptionsAllowRemoteCallsToSecurityAccountsManagerHelperBool) {
            this.localSecurityOptionsAllowRemoteCallsToSecurityAccountsManagerHelperBool = localSecurityOptionsAllowRemoteCallsToSecurityAccountsManagerHelperBool;
            this.changedFields = changedFields.add("localSecurityOptionsAllowRemoteCallsToSecurityAccountsManagerHelperBool");
            return this;
        }

        /**
         * <i>“This security setting determines whether a computer can be shut down without
         * having to log on to Windows.”</i>
         * 
         * @param localSecurityOptionsAllowSystemToBeShutDownWithoutHavingToLogOn
         *            value of {@code localSecurityOptionsAllowSystemToBeShutDownWithoutHavingToLogOn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsAllowSystemToBeShutDownWithoutHavingToLogOn(Boolean localSecurityOptionsAllowSystemToBeShutDownWithoutHavingToLogOn) {
            this.localSecurityOptionsAllowSystemToBeShutDownWithoutHavingToLogOn = localSecurityOptionsAllowSystemToBeShutDownWithoutHavingToLogOn;
            this.changedFields = changedFields.add("localSecurityOptionsAllowSystemToBeShutDownWithoutHavingToLogOn");
            return this;
        }

        /**
         * <i>“Allow UIAccess apps to prompt for elevation without using the secure desktop.”</i>
         * 
         * @param localSecurityOptionsAllowUIAccessApplicationElevation
         *            value of {@code localSecurityOptionsAllowUIAccessApplicationElevation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsAllowUIAccessApplicationElevation(Boolean localSecurityOptionsAllowUIAccessApplicationElevation) {
            this.localSecurityOptionsAllowUIAccessApplicationElevation = localSecurityOptionsAllowUIAccessApplicationElevation;
            this.changedFields = changedFields.add("localSecurityOptionsAllowUIAccessApplicationElevation");
            return this;
        }

        /**
         * <i>“Allow UIAccess apps to prompt for elevation without using the secure desktop.
         * Default is enabled”</i>
         * 
         * @param localSecurityOptionsAllowUIAccessApplicationsForSecureLocations
         *            value of {@code localSecurityOptionsAllowUIAccessApplicationsForSecureLocations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsAllowUIAccessApplicationsForSecureLocations(Boolean localSecurityOptionsAllowUIAccessApplicationsForSecureLocations) {
            this.localSecurityOptionsAllowUIAccessApplicationsForSecureLocations = localSecurityOptionsAllowUIAccessApplicationsForSecureLocations;
            this.changedFields = changedFields.add("localSecurityOptionsAllowUIAccessApplicationsForSecureLocations");
            return this;
        }

        /**
         * <i>“Prevent a portable computer from being undocked without having to log in.”</i>
         * 
         * @param localSecurityOptionsAllowUndockWithoutHavingToLogon
         *            value of {@code localSecurityOptionsAllowUndockWithoutHavingToLogon} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsAllowUndockWithoutHavingToLogon(Boolean localSecurityOptionsAllowUndockWithoutHavingToLogon) {
            this.localSecurityOptionsAllowUndockWithoutHavingToLogon = localSecurityOptionsAllowUndockWithoutHavingToLogon;
            this.changedFields = changedFields.add("localSecurityOptionsAllowUndockWithoutHavingToLogon");
            return this;
        }

        /**
         * <i>“Prevent users from adding new Microsoft accounts to this computer.”</i>
         * 
         * @param localSecurityOptionsBlockMicrosoftAccounts
         *            value of {@code localSecurityOptionsBlockMicrosoftAccounts} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsBlockMicrosoftAccounts(Boolean localSecurityOptionsBlockMicrosoftAccounts) {
            this.localSecurityOptionsBlockMicrosoftAccounts = localSecurityOptionsBlockMicrosoftAccounts;
            this.changedFields = changedFields.add("localSecurityOptionsBlockMicrosoftAccounts");
            return this;
        }

        /**
         * <i>“Enable Local accounts that are not password protected to log on from locations
         * other than the physical device.Default is enabled”</i>
         * 
         * @param localSecurityOptionsBlockRemoteLogonWithBlankPassword
         *            value of {@code localSecurityOptionsBlockRemoteLogonWithBlankPassword} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsBlockRemoteLogonWithBlankPassword(Boolean localSecurityOptionsBlockRemoteLogonWithBlankPassword) {
            this.localSecurityOptionsBlockRemoteLogonWithBlankPassword = localSecurityOptionsBlockRemoteLogonWithBlankPassword;
            this.changedFields = changedFields.add("localSecurityOptionsBlockRemoteLogonWithBlankPassword");
            return this;
        }

        /**
         * <i>“Enabling this settings allows only interactively logged on user to access CD-ROM
         * media.”</i>
         * 
         * @param localSecurityOptionsBlockRemoteOpticalDriveAccess
         *            value of {@code localSecurityOptionsBlockRemoteOpticalDriveAccess} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsBlockRemoteOpticalDriveAccess(Boolean localSecurityOptionsBlockRemoteOpticalDriveAccess) {
            this.localSecurityOptionsBlockRemoteOpticalDriveAccess = localSecurityOptionsBlockRemoteOpticalDriveAccess;
            this.changedFields = changedFields.add("localSecurityOptionsBlockRemoteOpticalDriveAccess");
            return this;
        }

        /**
         * <i>“Restrict installing printer drivers as part of connecting to a shared printer to
         * admins only.”</i>
         * 
         * @param localSecurityOptionsBlockUsersInstallingPrinterDrivers
         *            value of {@code localSecurityOptionsBlockUsersInstallingPrinterDrivers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsBlockUsersInstallingPrinterDrivers(Boolean localSecurityOptionsBlockUsersInstallingPrinterDrivers) {
            this.localSecurityOptionsBlockUsersInstallingPrinterDrivers = localSecurityOptionsBlockUsersInstallingPrinterDrivers;
            this.changedFields = changedFields.add("localSecurityOptionsBlockUsersInstallingPrinterDrivers");
            return this;
        }

        /**
         * <i>“This security setting determines whether the virtual memory pagefile is cleared
         * when the system is shut down.”</i>
         * 
         * @param localSecurityOptionsClearVirtualMemoryPageFile
         *            value of {@code localSecurityOptionsClearVirtualMemoryPageFile} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsClearVirtualMemoryPageFile(Boolean localSecurityOptionsClearVirtualMemoryPageFile) {
            this.localSecurityOptionsClearVirtualMemoryPageFile = localSecurityOptionsClearVirtualMemoryPageFile;
            this.changedFields = changedFields.add("localSecurityOptionsClearVirtualMemoryPageFile");
            return this;
        }

        /**
         * <i>“This security setting determines whether packet signing is required by the SMB
         * client component.”</i>
         * 
         * @param localSecurityOptionsClientDigitallySignCommunicationsAlways
         *            value of {@code localSecurityOptionsClientDigitallySignCommunicationsAlways} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsClientDigitallySignCommunicationsAlways(Boolean localSecurityOptionsClientDigitallySignCommunicationsAlways) {
            this.localSecurityOptionsClientDigitallySignCommunicationsAlways = localSecurityOptionsClientDigitallySignCommunicationsAlways;
            this.changedFields = changedFields.add("localSecurityOptionsClientDigitallySignCommunicationsAlways");
            return this;
        }

        /**
         * <i>“If this security setting is enabled, the Server Message Block (SMB) redirector
         * is allowed to send plaintext passwords to non-Microsoft SMB servers that do not
         * support password encryption during authentication.”</i>
         * 
         * @param localSecurityOptionsClientSendUnencryptedPasswordToThirdPartySMBServers
         *            value of {@code localSecurityOptionsClientSendUnencryptedPasswordToThirdPartySMBServers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsClientSendUnencryptedPasswordToThirdPartySMBServers(Boolean localSecurityOptionsClientSendUnencryptedPasswordToThirdPartySMBServers) {
            this.localSecurityOptionsClientSendUnencryptedPasswordToThirdPartySMBServers = localSecurityOptionsClientSendUnencryptedPasswordToThirdPartySMBServers;
            this.changedFields = changedFields.add("localSecurityOptionsClientSendUnencryptedPasswordToThirdPartySMBServers");
            return this;
        }

        /**
         * <i>“App installations requiring elevated privileges will prompt for admin
         * credentials.Default is enabled”</i>
         * 
         * @param localSecurityOptionsDetectApplicationInstallationsAndPromptForElevation
         *            value of {@code localSecurityOptionsDetectApplicationInstallationsAndPromptForElevation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsDetectApplicationInstallationsAndPromptForElevation(Boolean localSecurityOptionsDetectApplicationInstallationsAndPromptForElevation) {
            this.localSecurityOptionsDetectApplicationInstallationsAndPromptForElevation = localSecurityOptionsDetectApplicationInstallationsAndPromptForElevation;
            this.changedFields = changedFields.add("localSecurityOptionsDetectApplicationInstallationsAndPromptForElevation");
            return this;
        }

        /**
         * <i>“Determines whether the Local Administrator account is enabled or disabled.”</i>
         * 
         * @param localSecurityOptionsDisableAdministratorAccount
         *            value of {@code localSecurityOptionsDisableAdministratorAccount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsDisableAdministratorAccount(Boolean localSecurityOptionsDisableAdministratorAccount) {
            this.localSecurityOptionsDisableAdministratorAccount = localSecurityOptionsDisableAdministratorAccount;
            this.changedFields = changedFields.add("localSecurityOptionsDisableAdministratorAccount");
            return this;
        }

        /**
         * <i>“This security setting determines whether the SMB client attempts to negotiate
         * SMB packet signing.”</i>
         * 
         * @param localSecurityOptionsDisableClientDigitallySignCommunicationsIfServerAgrees
         *            value of {@code localSecurityOptionsDisableClientDigitallySignCommunicationsIfServerAgrees} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsDisableClientDigitallySignCommunicationsIfServerAgrees(Boolean localSecurityOptionsDisableClientDigitallySignCommunicationsIfServerAgrees) {
            this.localSecurityOptionsDisableClientDigitallySignCommunicationsIfServerAgrees = localSecurityOptionsDisableClientDigitallySignCommunicationsIfServerAgrees;
            this.changedFields = changedFields.add("localSecurityOptionsDisableClientDigitallySignCommunicationsIfServerAgrees");
            return this;
        }

        /**
         * <i>“Determines if the Guest account is enabled or disabled.”</i>
         * 
         * @param localSecurityOptionsDisableGuestAccount
         *            value of {@code localSecurityOptionsDisableGuestAccount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsDisableGuestAccount(Boolean localSecurityOptionsDisableGuestAccount) {
            this.localSecurityOptionsDisableGuestAccount = localSecurityOptionsDisableGuestAccount;
            this.changedFields = changedFields.add("localSecurityOptionsDisableGuestAccount");
            return this;
        }

        /**
         * <i>“This security setting determines whether packet signing is required by the SMB
         * server component.”</i>
         * 
         * @param localSecurityOptionsDisableServerDigitallySignCommunicationsAlways
         *            value of {@code localSecurityOptionsDisableServerDigitallySignCommunicationsAlways} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsDisableServerDigitallySignCommunicationsAlways(Boolean localSecurityOptionsDisableServerDigitallySignCommunicationsAlways) {
            this.localSecurityOptionsDisableServerDigitallySignCommunicationsAlways = localSecurityOptionsDisableServerDigitallySignCommunicationsAlways;
            this.changedFields = changedFields.add("localSecurityOptionsDisableServerDigitallySignCommunicationsAlways");
            return this;
        }

        /**
         * <i>“This security setting determines whether the SMB server will negotiate SMB
         * packet signing with clients that request it.”</i>
         * 
         * @param localSecurityOptionsDisableServerDigitallySignCommunicationsIfClientAgrees
         *            value of {@code localSecurityOptionsDisableServerDigitallySignCommunicationsIfClientAgrees} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsDisableServerDigitallySignCommunicationsIfClientAgrees(Boolean localSecurityOptionsDisableServerDigitallySignCommunicationsIfClientAgrees) {
            this.localSecurityOptionsDisableServerDigitallySignCommunicationsIfClientAgrees = localSecurityOptionsDisableServerDigitallySignCommunicationsIfClientAgrees;
            this.changedFields = changedFields.add("localSecurityOptionsDisableServerDigitallySignCommunicationsIfClientAgrees");
            return this;
        }

        /**
         * <i>“This security setting determines what additional permissions will be granted for
         * anonymous connections to the computer.”</i>
         * 
         * @param localSecurityOptionsDoNotAllowAnonymousEnumerationOfSAMAccounts
         *            value of {@code localSecurityOptionsDoNotAllowAnonymousEnumerationOfSAMAccounts} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsDoNotAllowAnonymousEnumerationOfSAMAccounts(Boolean localSecurityOptionsDoNotAllowAnonymousEnumerationOfSAMAccounts) {
            this.localSecurityOptionsDoNotAllowAnonymousEnumerationOfSAMAccounts = localSecurityOptionsDoNotAllowAnonymousEnumerationOfSAMAccounts;
            this.changedFields = changedFields.add("localSecurityOptionsDoNotAllowAnonymousEnumerationOfSAMAccounts");
            return this;
        }

        /**
         * <i>“Require CTRL+ALT+DEL to be pressed before a user can log on.”</i>
         * 
         * @param localSecurityOptionsDoNotRequireCtrlAltDel
         *            value of {@code localSecurityOptionsDoNotRequireCtrlAltDel} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsDoNotRequireCtrlAltDel(Boolean localSecurityOptionsDoNotRequireCtrlAltDel) {
            this.localSecurityOptionsDoNotRequireCtrlAltDel = localSecurityOptionsDoNotRequireCtrlAltDel;
            this.changedFields = changedFields.add("localSecurityOptionsDoNotRequireCtrlAltDel");
            return this;
        }

        /**
         * <i>“This security setting determines if, at the next password change, the LAN
         * Manager (LM) hash value for the new password is stored. It’s not stored by
         * default.”</i>
         * 
         * @param localSecurityOptionsDoNotStoreLANManagerHashValueOnNextPasswordChange
         *            value of {@code localSecurityOptionsDoNotStoreLANManagerHashValueOnNextPasswordChange} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsDoNotStoreLANManagerHashValueOnNextPasswordChange(Boolean localSecurityOptionsDoNotStoreLANManagerHashValueOnNextPasswordChange) {
            this.localSecurityOptionsDoNotStoreLANManagerHashValueOnNextPasswordChange = localSecurityOptionsDoNotStoreLANManagerHashValueOnNextPasswordChange;
            this.changedFields = changedFields.add("localSecurityOptionsDoNotStoreLANManagerHashValueOnNextPasswordChange");
            return this;
        }

        /**
         * <i>“Define who is allowed to format and eject removable NTFS media.”</i>
         * 
         * @param localSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUser
         *            value of {@code localSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUser} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUser(LocalSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUserType localSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUser) {
            this.localSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUser = localSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUser;
            this.changedFields = changedFields.add("localSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUser");
            return this;
        }

        /**
         * <i>“Define a different account name to be associated with the security identifier (
         * SID) for the account “Guest”.”</i>
         * 
         * @param localSecurityOptionsGuestAccountName
         *            value of {@code localSecurityOptionsGuestAccountName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsGuestAccountName(String localSecurityOptionsGuestAccountName) {
            this.localSecurityOptionsGuestAccountName = localSecurityOptionsGuestAccountName;
            this.changedFields = changedFields.add("localSecurityOptionsGuestAccountName");
            return this;
        }

        /**
         * <i>“Do not display the username of the last person who signed in on this device.”</i>
         * 
         * @param localSecurityOptionsHideLastSignedInUser
         *            value of {@code localSecurityOptionsHideLastSignedInUser} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsHideLastSignedInUser(Boolean localSecurityOptionsHideLastSignedInUser) {
            this.localSecurityOptionsHideLastSignedInUser = localSecurityOptionsHideLastSignedInUser;
            this.changedFields = changedFields.add("localSecurityOptionsHideLastSignedInUser");
            return this;
        }

        /**
         * <i>“Do not display the username of the person signing in to this device after
         * credentials are entered and before the device’s desktop is shown.”</i>
         * 
         * @param localSecurityOptionsHideUsernameAtSignIn
         *            value of {@code localSecurityOptionsHideUsernameAtSignIn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsHideUsernameAtSignIn(Boolean localSecurityOptionsHideUsernameAtSignIn) {
            this.localSecurityOptionsHideUsernameAtSignIn = localSecurityOptionsHideUsernameAtSignIn;
            this.changedFields = changedFields.add("localSecurityOptionsHideUsernameAtSignIn");
            return this;
        }

        /**
         * <i>“Configure the user information that is displayed when the session is locked. If
         * not configured, user display name, domain and username are shown”</i>
         * 
         * @param localSecurityOptionsInformationDisplayedOnLockScreen
         *            value of {@code localSecurityOptionsInformationDisplayedOnLockScreen} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsInformationDisplayedOnLockScreen(LocalSecurityOptionsInformationDisplayedOnLockScreenType localSecurityOptionsInformationDisplayedOnLockScreen) {
            this.localSecurityOptionsInformationDisplayedOnLockScreen = localSecurityOptionsInformationDisplayedOnLockScreen;
            this.changedFields = changedFields.add("localSecurityOptionsInformationDisplayedOnLockScreen");
            return this;
        }

        /**
         * <i>“Configure the user information that is displayed when the session is locked. If
         * not configured, user display name, domain and username are shown”</i>
         * 
         * @param localSecurityOptionsInformationShownOnLockScreen
         *            value of {@code localSecurityOptionsInformationShownOnLockScreen} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsInformationShownOnLockScreen(LocalSecurityOptionsInformationShownOnLockScreenType localSecurityOptionsInformationShownOnLockScreen) {
            this.localSecurityOptionsInformationShownOnLockScreen = localSecurityOptionsInformationShownOnLockScreen;
            this.changedFields = changedFields.add("localSecurityOptionsInformationShownOnLockScreen");
            return this;
        }

        /**
         * <i>“Set message text for users attempting to log in.”</i>
         * 
         * @param localSecurityOptionsLogOnMessageText
         *            value of {@code localSecurityOptionsLogOnMessageText} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsLogOnMessageText(String localSecurityOptionsLogOnMessageText) {
            this.localSecurityOptionsLogOnMessageText = localSecurityOptionsLogOnMessageText;
            this.changedFields = changedFields.add("localSecurityOptionsLogOnMessageText");
            return this;
        }

        /**
         * <i>“Set message title for users attempting to log in.”</i>
         * 
         * @param localSecurityOptionsLogOnMessageTitle
         *            value of {@code localSecurityOptionsLogOnMessageTitle} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsLogOnMessageTitle(String localSecurityOptionsLogOnMessageTitle) {
            this.localSecurityOptionsLogOnMessageTitle = localSecurityOptionsLogOnMessageTitle;
            this.changedFields = changedFields.add("localSecurityOptionsLogOnMessageTitle");
            return this;
        }

        /**
         * <i>“Define maximum minutes of inactivity on the interactive desktop’s login screen
         * until the screen saver runs. Valid values 0 to 9999”</i>
         * 
         * @param localSecurityOptionsMachineInactivityLimit
         *            value of {@code localSecurityOptionsMachineInactivityLimit} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsMachineInactivityLimit(Integer localSecurityOptionsMachineInactivityLimit) {
            this.localSecurityOptionsMachineInactivityLimit = localSecurityOptionsMachineInactivityLimit;
            this.changedFields = changedFields.add("localSecurityOptionsMachineInactivityLimit");
            return this;
        }

        /**
         * <i>“Define maximum minutes of inactivity on the interactive desktop’s login screen
         * until the screen saver runs. Valid values 0 to 9999”</i>
         * 
         * @param localSecurityOptionsMachineInactivityLimitInMinutes
         *            value of {@code localSecurityOptionsMachineInactivityLimitInMinutes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsMachineInactivityLimitInMinutes(Integer localSecurityOptionsMachineInactivityLimitInMinutes) {
            this.localSecurityOptionsMachineInactivityLimitInMinutes = localSecurityOptionsMachineInactivityLimitInMinutes;
            this.changedFields = changedFields.add("localSecurityOptionsMachineInactivityLimitInMinutes");
            return this;
        }

        /**
         * <i>“This security setting allows a client to require the negotiation of 128-bit
         * encryption and/or NTLMv2 session security.”</i>
         * 
         * @param localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedClients
         *            value of {@code localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedClients} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedClients(LocalSecurityOptionsMinimumSessionSecurity localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedClients) {
            this.localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedClients = localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedClients;
            this.changedFields = changedFields.add("localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedClients");
            return this;
        }

        /**
         * <i>“This security setting allows a server to require the negotiation of 128-bit
         * encryption and/or NTLMv2 session security.”</i>
         * 
         * @param localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedServers
         *            value of {@code localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedServers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedServers(LocalSecurityOptionsMinimumSessionSecurity localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedServers) {
            this.localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedServers = localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedServers;
            this.changedFields = changedFields.add("localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedServers");
            return this;
        }

        /**
         * <i>“Enforce PKI certification path validation for a given executable file before it
         * is permitted to run.”</i>
         * 
         * @param localSecurityOptionsOnlyElevateSignedExecutables
         *            value of {@code localSecurityOptionsOnlyElevateSignedExecutables} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsOnlyElevateSignedExecutables(Boolean localSecurityOptionsOnlyElevateSignedExecutables) {
            this.localSecurityOptionsOnlyElevateSignedExecutables = localSecurityOptionsOnlyElevateSignedExecutables;
            this.changedFields = changedFields.add("localSecurityOptionsOnlyElevateSignedExecutables");
            return this;
        }

        /**
         * <i>“By default, this security setting restricts anonymous access to shares and pipes
         * to the settings for named pipes that can be accessed anonymously and Shares that
         * can be accessed anonymously”</i>
         * 
         * @param localSecurityOptionsRestrictAnonymousAccessToNamedPipesAndShares
         *            value of {@code localSecurityOptionsRestrictAnonymousAccessToNamedPipesAndShares} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsRestrictAnonymousAccessToNamedPipesAndShares(Boolean localSecurityOptionsRestrictAnonymousAccessToNamedPipesAndShares) {
            this.localSecurityOptionsRestrictAnonymousAccessToNamedPipesAndShares = localSecurityOptionsRestrictAnonymousAccessToNamedPipesAndShares;
            this.changedFields = changedFields.add("localSecurityOptionsRestrictAnonymousAccessToNamedPipesAndShares");
            return this;
        }

        /**
         * <i>“This security setting determines what happens when the smart card for a logged-
         * on user is removed from the smart card reader.”</i>
         * 
         * @param localSecurityOptionsSmartCardRemovalBehavior
         *            value of {@code localSecurityOptionsSmartCardRemovalBehavior} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsSmartCardRemovalBehavior(LocalSecurityOptionsSmartCardRemovalBehaviorType localSecurityOptionsSmartCardRemovalBehavior) {
            this.localSecurityOptionsSmartCardRemovalBehavior = localSecurityOptionsSmartCardRemovalBehavior;
            this.changedFields = changedFields.add("localSecurityOptionsSmartCardRemovalBehavior");
            return this;
        }

        /**
         * <i>“Define the behavior of the elevation prompt for standard users.”</i>
         * 
         * @param localSecurityOptionsStandardUserElevationPromptBehavior
         *            value of {@code localSecurityOptionsStandardUserElevationPromptBehavior} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsStandardUserElevationPromptBehavior(LocalSecurityOptionsStandardUserElevationPromptBehaviorType localSecurityOptionsStandardUserElevationPromptBehavior) {
            this.localSecurityOptionsStandardUserElevationPromptBehavior = localSecurityOptionsStandardUserElevationPromptBehavior;
            this.changedFields = changedFields.add("localSecurityOptionsStandardUserElevationPromptBehavior");
            return this;
        }

        /**
         * <i>“Enable all elevation requests to go to the interactive user's desktop rather
         * than the secure desktop. Prompt behavior policy settings for admins and standard
         * users are used.”</i>
         * 
         * @param localSecurityOptionsSwitchToSecureDesktopWhenPromptingForElevation
         *            value of {@code localSecurityOptionsSwitchToSecureDesktopWhenPromptingForElevation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsSwitchToSecureDesktopWhenPromptingForElevation(Boolean localSecurityOptionsSwitchToSecureDesktopWhenPromptingForElevation) {
            this.localSecurityOptionsSwitchToSecureDesktopWhenPromptingForElevation = localSecurityOptionsSwitchToSecureDesktopWhenPromptingForElevation;
            this.changedFields = changedFields.add("localSecurityOptionsSwitchToSecureDesktopWhenPromptingForElevation");
            return this;
        }

        /**
         * <i>“Defines whether the built-in admin account uses Admin Approval Mode or runs all
         * apps with full admin privileges.Default is enabled”</i>
         * 
         * @param localSecurityOptionsUseAdminApprovalMode
         *            value of {@code localSecurityOptionsUseAdminApprovalMode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsUseAdminApprovalMode(Boolean localSecurityOptionsUseAdminApprovalMode) {
            this.localSecurityOptionsUseAdminApprovalMode = localSecurityOptionsUseAdminApprovalMode;
            this.changedFields = changedFields.add("localSecurityOptionsUseAdminApprovalMode");
            return this;
        }

        /**
         * <i>“Define whether Admin Approval Mode and all UAC policy settings are enabled,
         * default is enabled”</i>
         * 
         * @param localSecurityOptionsUseAdminApprovalModeForAdministrators
         *            value of {@code localSecurityOptionsUseAdminApprovalModeForAdministrators} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsUseAdminApprovalModeForAdministrators(Boolean localSecurityOptionsUseAdminApprovalModeForAdministrators) {
            this.localSecurityOptionsUseAdminApprovalModeForAdministrators = localSecurityOptionsUseAdminApprovalModeForAdministrators;
            this.changedFields = changedFields.add("localSecurityOptionsUseAdminApprovalModeForAdministrators");
            return this;
        }

        /**
         * <i>“Virtualize file and registry write failures to per user locations”</i>
         * 
         * @param localSecurityOptionsVirtualizeFileAndRegistryWriteFailuresToPerUserLocations
         *            value of {@code localSecurityOptionsVirtualizeFileAndRegistryWriteFailuresToPerUserLocations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localSecurityOptionsVirtualizeFileAndRegistryWriteFailuresToPerUserLocations(Boolean localSecurityOptionsVirtualizeFileAndRegistryWriteFailuresToPerUserLocations) {
            this.localSecurityOptionsVirtualizeFileAndRegistryWriteFailuresToPerUserLocations = localSecurityOptionsVirtualizeFileAndRegistryWriteFailuresToPerUserLocations;
            this.changedFields = changedFields.add("localSecurityOptionsVirtualizeFileAndRegistryWriteFailuresToPerUserLocations");
            return this;
        }

        /**
         * <i>“Allows IT Admins to control whether users can can ignore SmartScreen warnings
         * and run malicious files.”</i>
         * 
         * @param smartScreenBlockOverrideForFiles
         *            value of {@code smartScreenBlockOverrideForFiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder smartScreenBlockOverrideForFiles(Boolean smartScreenBlockOverrideForFiles) {
            this.smartScreenBlockOverrideForFiles = smartScreenBlockOverrideForFiles;
            this.changedFields = changedFields.add("smartScreenBlockOverrideForFiles");
            return this;
        }

        /**
         * <i>“Allows IT Admins to configure SmartScreen for Windows.”</i>
         * 
         * @param smartScreenEnableInShell
         *            value of {@code smartScreenEnableInShell} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder smartScreenEnableInShell(Boolean smartScreenEnableInShell) {
            this.smartScreenEnableInShell = smartScreenEnableInShell;
            this.changedFields = changedFields.add("smartScreenEnableInShell");
            return this;
        }

        /**
         * <i>“This user right is used by Credential Manager during Backup/Restore. Users'
         * saved credentials might be compromised if this privilege is given to other
         * entities. Only states NotConfigured and Allowed are supported”</i>
         * 
         * @param userRightsAccessCredentialManagerAsTrustedCaller
         *            value of {@code userRightsAccessCredentialManagerAsTrustedCaller} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userRightsAccessCredentialManagerAsTrustedCaller(DeviceManagementUserRightsSetting userRightsAccessCredentialManagerAsTrustedCaller) {
            this.userRightsAccessCredentialManagerAsTrustedCaller = userRightsAccessCredentialManagerAsTrustedCaller;
            this.changedFields = changedFields.add("userRightsAccessCredentialManagerAsTrustedCaller");
            return this;
        }

        /**
         * <i>“This user right allows a process to impersonate any user without authentication.
         * The process can therefore gain access to the same local resources as that user.
         * Only states NotConfigured and Allowed are supported”</i>
         * 
         * @param userRightsActAsPartOfTheOperatingSystem
         *            value of {@code userRightsActAsPartOfTheOperatingSystem} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userRightsActAsPartOfTheOperatingSystem(DeviceManagementUserRightsSetting userRightsActAsPartOfTheOperatingSystem) {
            this.userRightsActAsPartOfTheOperatingSystem = userRightsActAsPartOfTheOperatingSystem;
            this.changedFields = changedFields.add("userRightsActAsPartOfTheOperatingSystem");
            return this;
        }

        /**
         * <i>“This user right determines which users and groups are allowed to connect to the
         * computer over the network. State Allowed is supported.”</i>
         * 
         * @param userRightsAllowAccessFromNetwork
         *            value of {@code userRightsAllowAccessFromNetwork} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userRightsAllowAccessFromNetwork(DeviceManagementUserRightsSetting userRightsAllowAccessFromNetwork) {
            this.userRightsAllowAccessFromNetwork = userRightsAllowAccessFromNetwork;
            this.changedFields = changedFields.add("userRightsAllowAccessFromNetwork");
            return this;
        }

        /**
         * <i>“This user right determines which users can bypass file, directory, registry, and
         * other persistent objects permissions when backing up files and directories. Only
         * states NotConfigured and Allowed are supported”</i>
         * 
         * @param userRightsBackupData
         *            value of {@code userRightsBackupData} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userRightsBackupData(DeviceManagementUserRightsSetting userRightsBackupData) {
            this.userRightsBackupData = userRightsBackupData;
            this.changedFields = changedFields.add("userRightsBackupData");
            return this;
        }

        /**
         * <i>“This user right determines which users and groups are block from connecting to
         * the computer over the network. State Block is supported.”</i>
         * 
         * @param userRightsBlockAccessFromNetwork
         *            value of {@code userRightsBlockAccessFromNetwork} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userRightsBlockAccessFromNetwork(DeviceManagementUserRightsSetting userRightsBlockAccessFromNetwork) {
            this.userRightsBlockAccessFromNetwork = userRightsBlockAccessFromNetwork;
            this.changedFields = changedFields.add("userRightsBlockAccessFromNetwork");
            return this;
        }

        /**
         * <i>“This user right determines which users and groups can change the time and date
         * on the internal clock of the computer. Only states NotConfigured and Allowed are
         * supported”</i>
         * 
         * @param userRightsChangeSystemTime
         *            value of {@code userRightsChangeSystemTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userRightsChangeSystemTime(DeviceManagementUserRightsSetting userRightsChangeSystemTime) {
            this.userRightsChangeSystemTime = userRightsChangeSystemTime;
            this.changedFields = changedFields.add("userRightsChangeSystemTime");
            return this;
        }

        /**
         * <i>“This security setting determines whether users can create global objects that
         * are available to all sessions. Users who can create global objects could affect
         * processes that run under other users' sessions, which could lead to application
         * failure or data corruption. Only states NotConfigured and Allowed are supported”</i>
         * 
         * @param userRightsCreateGlobalObjects
         *            value of {@code userRightsCreateGlobalObjects} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userRightsCreateGlobalObjects(DeviceManagementUserRightsSetting userRightsCreateGlobalObjects) {
            this.userRightsCreateGlobalObjects = userRightsCreateGlobalObjects;
            this.changedFields = changedFields.add("userRightsCreateGlobalObjects");
            return this;
        }

        /**
         * <i>“This user right determines which users and groups can call an internal API to
         * create and change the size of a page file. Only states NotConfigured and Allowed
         * are supported”</i>
         * 
         * @param userRightsCreatePageFile
         *            value of {@code userRightsCreatePageFile} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userRightsCreatePageFile(DeviceManagementUserRightsSetting userRightsCreatePageFile) {
            this.userRightsCreatePageFile = userRightsCreatePageFile;
            this.changedFields = changedFields.add("userRightsCreatePageFile");
            return this;
        }

        /**
         * <i>“This user right determines which accounts can be used by processes to create a
         * directory object using the object manager. Only states NotConfigured and Allowed
         * are supported”</i>
         * 
         * @param userRightsCreatePermanentSharedObjects
         *            value of {@code userRightsCreatePermanentSharedObjects} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userRightsCreatePermanentSharedObjects(DeviceManagementUserRightsSetting userRightsCreatePermanentSharedObjects) {
            this.userRightsCreatePermanentSharedObjects = userRightsCreatePermanentSharedObjects;
            this.changedFields = changedFields.add("userRightsCreatePermanentSharedObjects");
            return this;
        }

        /**
         * <i>“This user right determines if the user can create a symbolic link from the
         * computer to which they are logged on. Only states NotConfigured and Allowed are
         * supported”</i>
         * 
         * @param userRightsCreateSymbolicLinks
         *            value of {@code userRightsCreateSymbolicLinks} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userRightsCreateSymbolicLinks(DeviceManagementUserRightsSetting userRightsCreateSymbolicLinks) {
            this.userRightsCreateSymbolicLinks = userRightsCreateSymbolicLinks;
            this.changedFields = changedFields.add("userRightsCreateSymbolicLinks");
            return this;
        }

        /**
         * <i>“This user right determines which users/groups can be used by processes to create
         * a token that can then be used to get access to any local resources when the
         * process uses an internal API to create an access token. Only states
         * NotConfigured and Allowed are supported”</i>
         * 
         * @param userRightsCreateToken
         *            value of {@code userRightsCreateToken} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userRightsCreateToken(DeviceManagementUserRightsSetting userRightsCreateToken) {
            this.userRightsCreateToken = userRightsCreateToken;
            this.changedFields = changedFields.add("userRightsCreateToken");
            return this;
        }

        /**
         * <i>“This user right determines which users can attach a debugger to any process or
         * to the kernel. Only states NotConfigured and Allowed are supported”</i>
         * 
         * @param userRightsDebugPrograms
         *            value of {@code userRightsDebugPrograms} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userRightsDebugPrograms(DeviceManagementUserRightsSetting userRightsDebugPrograms) {
            this.userRightsDebugPrograms = userRightsDebugPrograms;
            this.changedFields = changedFields.add("userRightsDebugPrograms");
            return this;
        }

        /**
         * <i>“This user right determines which users can set the Trusted for Delegation
         * setting on a user or computer object. Only states NotConfigured and Allowed are
         * supported.”</i>
         * 
         * @param userRightsDelegation
         *            value of {@code userRightsDelegation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userRightsDelegation(DeviceManagementUserRightsSetting userRightsDelegation) {
            this.userRightsDelegation = userRightsDelegation;
            this.changedFields = changedFields.add("userRightsDelegation");
            return this;
        }

        /**
         * <i>“This user right determines which users cannot log on to the computer. States
         * NotConfigured, Blocked are supported”</i>
         * 
         * @param userRightsDenyLocalLogOn
         *            value of {@code userRightsDenyLocalLogOn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userRightsDenyLocalLogOn(DeviceManagementUserRightsSetting userRightsDenyLocalLogOn) {
            this.userRightsDenyLocalLogOn = userRightsDenyLocalLogOn;
            this.changedFields = changedFields.add("userRightsDenyLocalLogOn");
            return this;
        }

        /**
         * <i>“This user right determines which accounts can be used by a process to add
         * entries to the security log. The security log is used to trace unauthorized
         * system access.  Only states NotConfigured and Allowed are supported.”</i>
         * 
         * @param userRightsGenerateSecurityAudits
         *            value of {@code userRightsGenerateSecurityAudits} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userRightsGenerateSecurityAudits(DeviceManagementUserRightsSetting userRightsGenerateSecurityAudits) {
            this.userRightsGenerateSecurityAudits = userRightsGenerateSecurityAudits;
            this.changedFields = changedFields.add("userRightsGenerateSecurityAudits");
            return this;
        }

        /**
         * <i>“Assigning this user right to a user allows programs running on behalf of that
         * user to impersonate a client. Requiring this user right for this kind of
         * impersonation prevents an unauthorized user from convincing a client to connect
         * to a service that they have created and then impersonating that client, which
         * can elevate the unauthorized user's permissions to administrative or system
         * levels. Only states NotConfigured and Allowed are supported.”</i>
         * 
         * @param userRightsImpersonateClient
         *            value of {@code userRightsImpersonateClient} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userRightsImpersonateClient(DeviceManagementUserRightsSetting userRightsImpersonateClient) {
            this.userRightsImpersonateClient = userRightsImpersonateClient;
            this.changedFields = changedFields.add("userRightsImpersonateClient");
            return this;
        }

        /**
         * <i>“This user right determines which accounts can use a process with Write Property
         * access to another process to increase the execution priority assigned to the
         * other process. Only states NotConfigured and Allowed are supported.”</i>
         * 
         * @param userRightsIncreaseSchedulingPriority
         *            value of {@code userRightsIncreaseSchedulingPriority} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userRightsIncreaseSchedulingPriority(DeviceManagementUserRightsSetting userRightsIncreaseSchedulingPriority) {
            this.userRightsIncreaseSchedulingPriority = userRightsIncreaseSchedulingPriority;
            this.changedFields = changedFields.add("userRightsIncreaseSchedulingPriority");
            return this;
        }

        /**
         * <i>“This user right determines which users can dynamically load and unload device
         * drivers or other code in to kernel mode. Only states NotConfigured and Allowed
         * are supported.”</i>
         * 
         * @param userRightsLoadUnloadDrivers
         *            value of {@code userRightsLoadUnloadDrivers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userRightsLoadUnloadDrivers(DeviceManagementUserRightsSetting userRightsLoadUnloadDrivers) {
            this.userRightsLoadUnloadDrivers = userRightsLoadUnloadDrivers;
            this.changedFields = changedFields.add("userRightsLoadUnloadDrivers");
            return this;
        }

        /**
         * <i>“This user right determines which users can log on to the computer. States
         * NotConfigured, Allowed are supported”</i>
         * 
         * @param userRightsLocalLogOn
         *            value of {@code userRightsLocalLogOn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userRightsLocalLogOn(DeviceManagementUserRightsSetting userRightsLocalLogOn) {
            this.userRightsLocalLogOn = userRightsLocalLogOn;
            this.changedFields = changedFields.add("userRightsLocalLogOn");
            return this;
        }

        /**
         * <i>“This user right determines which accounts can use a process to keep data in
         * physical memory, which prevents the system from paging the data to virtual
         * memory on disk. Only states NotConfigured and Allowed are supported.”</i>
         * 
         * @param userRightsLockMemory
         *            value of {@code userRightsLockMemory} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userRightsLockMemory(DeviceManagementUserRightsSetting userRightsLockMemory) {
            this.userRightsLockMemory = userRightsLockMemory;
            this.changedFields = changedFields.add("userRightsLockMemory");
            return this;
        }

        /**
         * <i>“This user right determines which users can specify object access auditing
         * options for individual resources, such as files, Active Directory objects, and
         * registry keys. Only states NotConfigured and Allowed are supported.”</i>
         * 
         * @param userRightsManageAuditingAndSecurityLogs
         *            value of {@code userRightsManageAuditingAndSecurityLogs} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userRightsManageAuditingAndSecurityLogs(DeviceManagementUserRightsSetting userRightsManageAuditingAndSecurityLogs) {
            this.userRightsManageAuditingAndSecurityLogs = userRightsManageAuditingAndSecurityLogs;
            this.changedFields = changedFields.add("userRightsManageAuditingAndSecurityLogs");
            return this;
        }

        /**
         * <i>“This user right determines which users and groups can run maintenance tasks on a
         * volume, such as remote defragmentation. Only states NotConfigured and Allowed
         * are supported.”</i>
         * 
         * @param userRightsManageVolumes
         *            value of {@code userRightsManageVolumes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userRightsManageVolumes(DeviceManagementUserRightsSetting userRightsManageVolumes) {
            this.userRightsManageVolumes = userRightsManageVolumes;
            this.changedFields = changedFields.add("userRightsManageVolumes");
            return this;
        }

        /**
         * <i>“This user right determines who can modify firmware environment values. Only
         * states NotConfigured and Allowed are supported.”</i>
         * 
         * @param userRightsModifyFirmwareEnvironment
         *            value of {@code userRightsModifyFirmwareEnvironment} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userRightsModifyFirmwareEnvironment(DeviceManagementUserRightsSetting userRightsModifyFirmwareEnvironment) {
            this.userRightsModifyFirmwareEnvironment = userRightsModifyFirmwareEnvironment;
            this.changedFields = changedFields.add("userRightsModifyFirmwareEnvironment");
            return this;
        }

        /**
         * <i>“This user right determines which user accounts can modify the integrity label of
         * objects, such as files, registry keys, or processes owned by other users. Only
         * states NotConfigured and Allowed are supported.”</i>
         * 
         * @param userRightsModifyObjectLabels
         *            value of {@code userRightsModifyObjectLabels} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userRightsModifyObjectLabels(DeviceManagementUserRightsSetting userRightsModifyObjectLabels) {
            this.userRightsModifyObjectLabels = userRightsModifyObjectLabels;
            this.changedFields = changedFields.add("userRightsModifyObjectLabels");
            return this;
        }

        /**
         * <i>“This user right determines which users can use performance monitoring tools to
         * monitor the performance of system processes. Only states NotConfigured and
         * Allowed are supported.”</i>
         * 
         * @param userRightsProfileSingleProcess
         *            value of {@code userRightsProfileSingleProcess} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userRightsProfileSingleProcess(DeviceManagementUserRightsSetting userRightsProfileSingleProcess) {
            this.userRightsProfileSingleProcess = userRightsProfileSingleProcess;
            this.changedFields = changedFields.add("userRightsProfileSingleProcess");
            return this;
        }

        /**
         * <i>“This user right determines which users and groups are prohibited from logging on
         * as a Remote Desktop Services client. Only states NotConfigured and Blocked are
         * supported”</i>
         * 
         * @param userRightsRemoteDesktopServicesLogOn
         *            value of {@code userRightsRemoteDesktopServicesLogOn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userRightsRemoteDesktopServicesLogOn(DeviceManagementUserRightsSetting userRightsRemoteDesktopServicesLogOn) {
            this.userRightsRemoteDesktopServicesLogOn = userRightsRemoteDesktopServicesLogOn;
            this.changedFields = changedFields.add("userRightsRemoteDesktopServicesLogOn");
            return this;
        }

        /**
         * <i>“This user right determines which users are allowed to shut down a computer from
         * a remote location on the network. Misuse of this user right can result in a
         * denial of service. Only states NotConfigured and Allowed are supported.”</i>
         * 
         * @param userRightsRemoteShutdown
         *            value of {@code userRightsRemoteShutdown} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userRightsRemoteShutdown(DeviceManagementUserRightsSetting userRightsRemoteShutdown) {
            this.userRightsRemoteShutdown = userRightsRemoteShutdown;
            this.changedFields = changedFields.add("userRightsRemoteShutdown");
            return this;
        }

        /**
         * <i>“This user right determines which users can bypass file, directory, registry, and
         * other persistent objects permissions when restoring backed up files and
         * directories, and determines which users can set any valid security principal as
         * the owner of an object. Only states NotConfigured and Allowed are supported.”</i>
         * 
         * @param userRightsRestoreData
         *            value of {@code userRightsRestoreData} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userRightsRestoreData(DeviceManagementUserRightsSetting userRightsRestoreData) {
            this.userRightsRestoreData = userRightsRestoreData;
            this.changedFields = changedFields.add("userRightsRestoreData");
            return this;
        }

        /**
         * <i>“This user right determines which users can take ownership of any securable
         * object in the system, including Active Directory objects, files and folders,
         * printers, registry keys, processes, and threads. Only states NotConfigured and
         * Allowed are supported.”</i>
         * 
         * @param userRightsTakeOwnership
         *            value of {@code userRightsTakeOwnership} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userRightsTakeOwnership(DeviceManagementUserRightsSetting userRightsTakeOwnership) {
            this.userRightsTakeOwnership = userRightsTakeOwnership;
            this.changedFields = changedFields.add("userRightsTakeOwnership");
            return this;
        }

        /**
         * <i>“Configure windows defender TamperProtection settings”</i>
         * 
         * @param windowsDefenderTamperProtection
         *            value of {@code windowsDefenderTamperProtection} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsDefenderTamperProtection(WindowsDefenderTamperProtectionOptions windowsDefenderTamperProtection) {
            this.windowsDefenderTamperProtection = windowsDefenderTamperProtection;
            this.changedFields = changedFields.add("windowsDefenderTamperProtection");
            return this;
        }

        /**
         * <i>“This setting determines whether the Accessory management service's start type is
         * Automatic(2), Manual(3), Disabled(4). Default: Manual.”</i>
         * 
         * @param xboxServicesAccessoryManagementServiceStartupMode
         *            value of {@code xboxServicesAccessoryManagementServiceStartupMode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder xboxServicesAccessoryManagementServiceStartupMode(ServiceStartType xboxServicesAccessoryManagementServiceStartupMode) {
            this.xboxServicesAccessoryManagementServiceStartupMode = xboxServicesAccessoryManagementServiceStartupMode;
            this.changedFields = changedFields.add("xboxServicesAccessoryManagementServiceStartupMode");
            return this;
        }

        /**
         * <i>“This setting determines whether xbox game save is enabled (1) or disabled (0).”</i>
         * 
         * @param xboxServicesEnableXboxGameSaveTask
         *            value of {@code xboxServicesEnableXboxGameSaveTask} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder xboxServicesEnableXboxGameSaveTask(Boolean xboxServicesEnableXboxGameSaveTask) {
            this.xboxServicesEnableXboxGameSaveTask = xboxServicesEnableXboxGameSaveTask;
            this.changedFields = changedFields.add("xboxServicesEnableXboxGameSaveTask");
            return this;
        }

        /**
         * <i>“This setting determines whether Live Auth Manager service's start type is
         * Automatic(2), Manual(3), Disabled(4). Default: Manual.”</i>
         * 
         * @param xboxServicesLiveAuthManagerServiceStartupMode
         *            value of {@code xboxServicesLiveAuthManagerServiceStartupMode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder xboxServicesLiveAuthManagerServiceStartupMode(ServiceStartType xboxServicesLiveAuthManagerServiceStartupMode) {
            this.xboxServicesLiveAuthManagerServiceStartupMode = xboxServicesLiveAuthManagerServiceStartupMode;
            this.changedFields = changedFields.add("xboxServicesLiveAuthManagerServiceStartupMode");
            return this;
        }

        /**
         * <i>“This setting determines whether Live Game save service's start type is Automatic
         * (2), Manual(3), Disabled(4). Default: Manual.”</i>
         * 
         * @param xboxServicesLiveGameSaveServiceStartupMode
         *            value of {@code xboxServicesLiveGameSaveServiceStartupMode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder xboxServicesLiveGameSaveServiceStartupMode(ServiceStartType xboxServicesLiveGameSaveServiceStartupMode) {
            this.xboxServicesLiveGameSaveServiceStartupMode = xboxServicesLiveGameSaveServiceStartupMode;
            this.changedFields = changedFields.add("xboxServicesLiveGameSaveServiceStartupMode");
            return this;
        }

        /**
         * <i>“This setting determines whether Networking service's start type is Automatic(2),
         * Manual(3), Disabled(4). Default: Manual.”</i>
         * 
         * @param xboxServicesLiveNetworkingServiceStartupMode
         *            value of {@code xboxServicesLiveNetworkingServiceStartupMode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder xboxServicesLiveNetworkingServiceStartupMode(ServiceStartType xboxServicesLiveNetworkingServiceStartupMode) {
            this.xboxServicesLiveNetworkingServiceStartupMode = xboxServicesLiveNetworkingServiceStartupMode;
            this.changedFields = changedFields.add("xboxServicesLiveNetworkingServiceStartupMode");
            return this;
        }

        public Windows10EndpointProtectionConfiguration build() {
            Windows10EndpointProtectionConfiguration _x = new Windows10EndpointProtectionConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windows10EndpointProtectionConfiguration";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.version = version;
            _x.assignments = assignments;
            _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
            _x.deviceStatuses = deviceStatuses;
            _x.deviceStatusOverview = deviceStatusOverview;
            _x.groupAssignments = groupAssignments;
            _x.userStatuses = userStatuses;
            _x.userStatusOverview = userStatusOverview;
            _x.applicationGuardAllowCameraMicrophoneRedirection = applicationGuardAllowCameraMicrophoneRedirection;
            _x.applicationGuardAllowFileSaveOnHost = applicationGuardAllowFileSaveOnHost;
            _x.applicationGuardAllowPersistence = applicationGuardAllowPersistence;
            _x.applicationGuardAllowPrintToLocalPrinters = applicationGuardAllowPrintToLocalPrinters;
            _x.applicationGuardAllowPrintToNetworkPrinters = applicationGuardAllowPrintToNetworkPrinters;
            _x.applicationGuardAllowPrintToPDF = applicationGuardAllowPrintToPDF;
            _x.applicationGuardAllowPrintToXPS = applicationGuardAllowPrintToXPS;
            _x.applicationGuardAllowVirtualGPU = applicationGuardAllowVirtualGPU;
            _x.applicationGuardBlockClipboardSharing = applicationGuardBlockClipboardSharing;
            _x.applicationGuardBlockFileTransfer = applicationGuardBlockFileTransfer;
            _x.applicationGuardBlockNonEnterpriseContent = applicationGuardBlockNonEnterpriseContent;
            _x.applicationGuardCertificateThumbprints = applicationGuardCertificateThumbprints;
            _x.applicationGuardCertificateThumbprintsNextLink = applicationGuardCertificateThumbprintsNextLink;
            _x.applicationGuardEnabled = applicationGuardEnabled;
            _x.applicationGuardEnabledOptions = applicationGuardEnabledOptions;
            _x.applicationGuardForceAuditing = applicationGuardForceAuditing;
            _x.appLockerApplicationControl = appLockerApplicationControl;
            _x.bitLockerAllowStandardUserEncryption = bitLockerAllowStandardUserEncryption;
            _x.bitLockerDisableWarningForOtherDiskEncryption = bitLockerDisableWarningForOtherDiskEncryption;
            _x.bitLockerEnableStorageCardEncryptionOnMobile = bitLockerEnableStorageCardEncryptionOnMobile;
            _x.bitLockerEncryptDevice = bitLockerEncryptDevice;
            _x.bitLockerFixedDrivePolicy = bitLockerFixedDrivePolicy;
            _x.bitLockerRecoveryPasswordRotation = bitLockerRecoveryPasswordRotation;
            _x.bitLockerRemovableDrivePolicy = bitLockerRemovableDrivePolicy;
            _x.bitLockerSystemDrivePolicy = bitLockerSystemDrivePolicy;
            _x.defenderAdditionalGuardedFolders = defenderAdditionalGuardedFolders;
            _x.defenderAdditionalGuardedFoldersNextLink = defenderAdditionalGuardedFoldersNextLink;
            _x.defenderAdobeReaderLaunchChildProcess = defenderAdobeReaderLaunchChildProcess;
            _x.defenderAdvancedRansomewareProtectionType = defenderAdvancedRansomewareProtectionType;
            _x.defenderAllowBehaviorMonitoring = defenderAllowBehaviorMonitoring;
            _x.defenderAllowCloudProtection = defenderAllowCloudProtection;
            _x.defenderAllowEndUserAccess = defenderAllowEndUserAccess;
            _x.defenderAllowIntrusionPreventionSystem = defenderAllowIntrusionPreventionSystem;
            _x.defenderAllowOnAccessProtection = defenderAllowOnAccessProtection;
            _x.defenderAllowRealTimeMonitoring = defenderAllowRealTimeMonitoring;
            _x.defenderAllowScanArchiveFiles = defenderAllowScanArchiveFiles;
            _x.defenderAllowScanDownloads = defenderAllowScanDownloads;
            _x.defenderAllowScanNetworkFiles = defenderAllowScanNetworkFiles;
            _x.defenderAllowScanRemovableDrivesDuringFullScan = defenderAllowScanRemovableDrivesDuringFullScan;
            _x.defenderAllowScanScriptsLoadedInInternetExplorer = defenderAllowScanScriptsLoadedInInternetExplorer;
            _x.defenderAttackSurfaceReductionExcludedPaths = defenderAttackSurfaceReductionExcludedPaths;
            _x.defenderAttackSurfaceReductionExcludedPathsNextLink = defenderAttackSurfaceReductionExcludedPathsNextLink;
            _x.defenderBlockEndUserAccess = defenderBlockEndUserAccess;
            _x.defenderBlockPersistenceThroughWmiType = defenderBlockPersistenceThroughWmiType;
            _x.defenderCheckForSignaturesBeforeRunningScan = defenderCheckForSignaturesBeforeRunningScan;
            _x.defenderCloudBlockLevel = defenderCloudBlockLevel;
            _x.defenderCloudExtendedTimeoutInSeconds = defenderCloudExtendedTimeoutInSeconds;
            _x.defenderDaysBeforeDeletingQuarantinedMalware = defenderDaysBeforeDeletingQuarantinedMalware;
            _x.defenderDetectedMalwareActions = defenderDetectedMalwareActions;
            _x.defenderDisableBehaviorMonitoring = defenderDisableBehaviorMonitoring;
            _x.defenderDisableCatchupFullScan = defenderDisableCatchupFullScan;
            _x.defenderDisableCatchupQuickScan = defenderDisableCatchupQuickScan;
            _x.defenderDisableCloudProtection = defenderDisableCloudProtection;
            _x.defenderDisableIntrusionPreventionSystem = defenderDisableIntrusionPreventionSystem;
            _x.defenderDisableOnAccessProtection = defenderDisableOnAccessProtection;
            _x.defenderDisableRealTimeMonitoring = defenderDisableRealTimeMonitoring;
            _x.defenderDisableScanArchiveFiles = defenderDisableScanArchiveFiles;
            _x.defenderDisableScanDownloads = defenderDisableScanDownloads;
            _x.defenderDisableScanNetworkFiles = defenderDisableScanNetworkFiles;
            _x.defenderDisableScanRemovableDrivesDuringFullScan = defenderDisableScanRemovableDrivesDuringFullScan;
            _x.defenderDisableScanScriptsLoadedInInternetExplorer = defenderDisableScanScriptsLoadedInInternetExplorer;
            _x.defenderEmailContentExecution = defenderEmailContentExecution;
            _x.defenderEmailContentExecutionType = defenderEmailContentExecutionType;
            _x.defenderEnableLowCpuPriority = defenderEnableLowCpuPriority;
            _x.defenderEnableScanIncomingMail = defenderEnableScanIncomingMail;
            _x.defenderEnableScanMappedNetworkDrivesDuringFullScan = defenderEnableScanMappedNetworkDrivesDuringFullScan;
            _x.defenderExploitProtectionXml = defenderExploitProtectionXml;
            _x.defenderExploitProtectionXmlFileName = defenderExploitProtectionXmlFileName;
            _x.defenderFileExtensionsToExclude = defenderFileExtensionsToExclude;
            _x.defenderFileExtensionsToExcludeNextLink = defenderFileExtensionsToExcludeNextLink;
            _x.defenderFilesAndFoldersToExclude = defenderFilesAndFoldersToExclude;
            _x.defenderFilesAndFoldersToExcludeNextLink = defenderFilesAndFoldersToExcludeNextLink;
            _x.defenderGuardedFoldersAllowedAppPaths = defenderGuardedFoldersAllowedAppPaths;
            _x.defenderGuardedFoldersAllowedAppPathsNextLink = defenderGuardedFoldersAllowedAppPathsNextLink;
            _x.defenderGuardMyFoldersType = defenderGuardMyFoldersType;
            _x.defenderNetworkProtectionType = defenderNetworkProtectionType;
            _x.defenderOfficeAppsExecutableContentCreationOrLaunch = defenderOfficeAppsExecutableContentCreationOrLaunch;
            _x.defenderOfficeAppsExecutableContentCreationOrLaunchType = defenderOfficeAppsExecutableContentCreationOrLaunchType;
            _x.defenderOfficeAppsLaunchChildProcess = defenderOfficeAppsLaunchChildProcess;
            _x.defenderOfficeAppsLaunchChildProcessType = defenderOfficeAppsLaunchChildProcessType;
            _x.defenderOfficeAppsOtherProcessInjection = defenderOfficeAppsOtherProcessInjection;
            _x.defenderOfficeAppsOtherProcessInjectionType = defenderOfficeAppsOtherProcessInjectionType;
            _x.defenderOfficeCommunicationAppsLaunchChildProcess = defenderOfficeCommunicationAppsLaunchChildProcess;
            _x.defenderOfficeMacroCodeAllowWin32Imports = defenderOfficeMacroCodeAllowWin32Imports;
            _x.defenderOfficeMacroCodeAllowWin32ImportsType = defenderOfficeMacroCodeAllowWin32ImportsType;
            _x.defenderPotentiallyUnwantedAppAction = defenderPotentiallyUnwantedAppAction;
            _x.defenderPreventCredentialStealingType = defenderPreventCredentialStealingType;
            _x.defenderProcessCreation = defenderProcessCreation;
            _x.defenderProcessCreationType = defenderProcessCreationType;
            _x.defenderProcessesToExclude = defenderProcessesToExclude;
            _x.defenderProcessesToExcludeNextLink = defenderProcessesToExcludeNextLink;
            _x.defenderScanDirection = defenderScanDirection;
            _x.defenderScanMaxCpuPercentage = defenderScanMaxCpuPercentage;
            _x.defenderScanType = defenderScanType;
            _x.defenderScheduledQuickScanTime = defenderScheduledQuickScanTime;
            _x.defenderScheduledScanDay = defenderScheduledScanDay;
            _x.defenderScheduledScanTime = defenderScheduledScanTime;
            _x.defenderScriptDownloadedPayloadExecution = defenderScriptDownloadedPayloadExecution;
            _x.defenderScriptDownloadedPayloadExecutionType = defenderScriptDownloadedPayloadExecutionType;
            _x.defenderScriptObfuscatedMacroCode = defenderScriptObfuscatedMacroCode;
            _x.defenderScriptObfuscatedMacroCodeType = defenderScriptObfuscatedMacroCodeType;
            _x.defenderSecurityCenterBlockExploitProtectionOverride = defenderSecurityCenterBlockExploitProtectionOverride;
            _x.defenderSecurityCenterDisableAccountUI = defenderSecurityCenterDisableAccountUI;
            _x.defenderSecurityCenterDisableAppBrowserUI = defenderSecurityCenterDisableAppBrowserUI;
            _x.defenderSecurityCenterDisableClearTpmUI = defenderSecurityCenterDisableClearTpmUI;
            _x.defenderSecurityCenterDisableFamilyUI = defenderSecurityCenterDisableFamilyUI;
            _x.defenderSecurityCenterDisableHardwareUI = defenderSecurityCenterDisableHardwareUI;
            _x.defenderSecurityCenterDisableHealthUI = defenderSecurityCenterDisableHealthUI;
            _x.defenderSecurityCenterDisableNetworkUI = defenderSecurityCenterDisableNetworkUI;
            _x.defenderSecurityCenterDisableNotificationAreaUI = defenderSecurityCenterDisableNotificationAreaUI;
            _x.defenderSecurityCenterDisableRansomwareUI = defenderSecurityCenterDisableRansomwareUI;
            _x.defenderSecurityCenterDisableSecureBootUI = defenderSecurityCenterDisableSecureBootUI;
            _x.defenderSecurityCenterDisableTroubleshootingUI = defenderSecurityCenterDisableTroubleshootingUI;
            _x.defenderSecurityCenterDisableVirusUI = defenderSecurityCenterDisableVirusUI;
            _x.defenderSecurityCenterDisableVulnerableTpmFirmwareUpdateUI = defenderSecurityCenterDisableVulnerableTpmFirmwareUpdateUI;
            _x.defenderSecurityCenterHelpEmail = defenderSecurityCenterHelpEmail;
            _x.defenderSecurityCenterHelpPhone = defenderSecurityCenterHelpPhone;
            _x.defenderSecurityCenterHelpURL = defenderSecurityCenterHelpURL;
            _x.defenderSecurityCenterITContactDisplay = defenderSecurityCenterITContactDisplay;
            _x.defenderSecurityCenterNotificationsFromApp = defenderSecurityCenterNotificationsFromApp;
            _x.defenderSecurityCenterOrganizationDisplayName = defenderSecurityCenterOrganizationDisplayName;
            _x.defenderSignatureUpdateIntervalInHours = defenderSignatureUpdateIntervalInHours;
            _x.defenderSubmitSamplesConsentType = defenderSubmitSamplesConsentType;
            _x.defenderUntrustedExecutable = defenderUntrustedExecutable;
            _x.defenderUntrustedExecutableType = defenderUntrustedExecutableType;
            _x.defenderUntrustedUSBProcess = defenderUntrustedUSBProcess;
            _x.defenderUntrustedUSBProcessType = defenderUntrustedUSBProcessType;
            _x.deviceGuardEnableSecureBootWithDMA = deviceGuardEnableSecureBootWithDMA;
            _x.deviceGuardEnableVirtualizationBasedSecurity = deviceGuardEnableVirtualizationBasedSecurity;
            _x.deviceGuardLaunchSystemGuard = deviceGuardLaunchSystemGuard;
            _x.deviceGuardLocalSystemAuthorityCredentialGuardSettings = deviceGuardLocalSystemAuthorityCredentialGuardSettings;
            _x.deviceGuardSecureBootWithDMA = deviceGuardSecureBootWithDMA;
            _x.dmaGuardDeviceEnumerationPolicy = dmaGuardDeviceEnumerationPolicy;
            _x.firewallBlockStatefulFTP = firewallBlockStatefulFTP;
            _x.firewallCertificateRevocationListCheckMethod = firewallCertificateRevocationListCheckMethod;
            _x.firewallIdleTimeoutForSecurityAssociationInSeconds = firewallIdleTimeoutForSecurityAssociationInSeconds;
            _x.firewallIPSecExemptionsAllowDHCP = firewallIPSecExemptionsAllowDHCP;
            _x.firewallIPSecExemptionsAllowICMP = firewallIPSecExemptionsAllowICMP;
            _x.firewallIPSecExemptionsAllowNeighborDiscovery = firewallIPSecExemptionsAllowNeighborDiscovery;
            _x.firewallIPSecExemptionsAllowRouterDiscovery = firewallIPSecExemptionsAllowRouterDiscovery;
            _x.firewallIPSecExemptionsNone = firewallIPSecExemptionsNone;
            _x.firewallMergeKeyingModuleSettings = firewallMergeKeyingModuleSettings;
            _x.firewallPacketQueueingMethod = firewallPacketQueueingMethod;
            _x.firewallPreSharedKeyEncodingMethod = firewallPreSharedKeyEncodingMethod;
            _x.firewallProfileDomain = firewallProfileDomain;
            _x.firewallProfilePrivate = firewallProfilePrivate;
            _x.firewallProfilePublic = firewallProfilePublic;
            _x.firewallRules = firewallRules;
            _x.firewallRulesNextLink = firewallRulesNextLink;
            _x.lanManagerAuthenticationLevel = lanManagerAuthenticationLevel;
            _x.lanManagerWorkstationDisableInsecureGuestLogons = lanManagerWorkstationDisableInsecureGuestLogons;
            _x.localSecurityOptionsAdministratorAccountName = localSecurityOptionsAdministratorAccountName;
            _x.localSecurityOptionsAdministratorElevationPromptBehavior = localSecurityOptionsAdministratorElevationPromptBehavior;
            _x.localSecurityOptionsAllowAnonymousEnumerationOfSAMAccountsAndShares = localSecurityOptionsAllowAnonymousEnumerationOfSAMAccountsAndShares;
            _x.localSecurityOptionsAllowPKU2UAuthenticationRequests = localSecurityOptionsAllowPKU2UAuthenticationRequests;
            _x.localSecurityOptionsAllowRemoteCallsToSecurityAccountsManager = localSecurityOptionsAllowRemoteCallsToSecurityAccountsManager;
            _x.localSecurityOptionsAllowRemoteCallsToSecurityAccountsManagerHelperBool = localSecurityOptionsAllowRemoteCallsToSecurityAccountsManagerHelperBool;
            _x.localSecurityOptionsAllowSystemToBeShutDownWithoutHavingToLogOn = localSecurityOptionsAllowSystemToBeShutDownWithoutHavingToLogOn;
            _x.localSecurityOptionsAllowUIAccessApplicationElevation = localSecurityOptionsAllowUIAccessApplicationElevation;
            _x.localSecurityOptionsAllowUIAccessApplicationsForSecureLocations = localSecurityOptionsAllowUIAccessApplicationsForSecureLocations;
            _x.localSecurityOptionsAllowUndockWithoutHavingToLogon = localSecurityOptionsAllowUndockWithoutHavingToLogon;
            _x.localSecurityOptionsBlockMicrosoftAccounts = localSecurityOptionsBlockMicrosoftAccounts;
            _x.localSecurityOptionsBlockRemoteLogonWithBlankPassword = localSecurityOptionsBlockRemoteLogonWithBlankPassword;
            _x.localSecurityOptionsBlockRemoteOpticalDriveAccess = localSecurityOptionsBlockRemoteOpticalDriveAccess;
            _x.localSecurityOptionsBlockUsersInstallingPrinterDrivers = localSecurityOptionsBlockUsersInstallingPrinterDrivers;
            _x.localSecurityOptionsClearVirtualMemoryPageFile = localSecurityOptionsClearVirtualMemoryPageFile;
            _x.localSecurityOptionsClientDigitallySignCommunicationsAlways = localSecurityOptionsClientDigitallySignCommunicationsAlways;
            _x.localSecurityOptionsClientSendUnencryptedPasswordToThirdPartySMBServers = localSecurityOptionsClientSendUnencryptedPasswordToThirdPartySMBServers;
            _x.localSecurityOptionsDetectApplicationInstallationsAndPromptForElevation = localSecurityOptionsDetectApplicationInstallationsAndPromptForElevation;
            _x.localSecurityOptionsDisableAdministratorAccount = localSecurityOptionsDisableAdministratorAccount;
            _x.localSecurityOptionsDisableClientDigitallySignCommunicationsIfServerAgrees = localSecurityOptionsDisableClientDigitallySignCommunicationsIfServerAgrees;
            _x.localSecurityOptionsDisableGuestAccount = localSecurityOptionsDisableGuestAccount;
            _x.localSecurityOptionsDisableServerDigitallySignCommunicationsAlways = localSecurityOptionsDisableServerDigitallySignCommunicationsAlways;
            _x.localSecurityOptionsDisableServerDigitallySignCommunicationsIfClientAgrees = localSecurityOptionsDisableServerDigitallySignCommunicationsIfClientAgrees;
            _x.localSecurityOptionsDoNotAllowAnonymousEnumerationOfSAMAccounts = localSecurityOptionsDoNotAllowAnonymousEnumerationOfSAMAccounts;
            _x.localSecurityOptionsDoNotRequireCtrlAltDel = localSecurityOptionsDoNotRequireCtrlAltDel;
            _x.localSecurityOptionsDoNotStoreLANManagerHashValueOnNextPasswordChange = localSecurityOptionsDoNotStoreLANManagerHashValueOnNextPasswordChange;
            _x.localSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUser = localSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUser;
            _x.localSecurityOptionsGuestAccountName = localSecurityOptionsGuestAccountName;
            _x.localSecurityOptionsHideLastSignedInUser = localSecurityOptionsHideLastSignedInUser;
            _x.localSecurityOptionsHideUsernameAtSignIn = localSecurityOptionsHideUsernameAtSignIn;
            _x.localSecurityOptionsInformationDisplayedOnLockScreen = localSecurityOptionsInformationDisplayedOnLockScreen;
            _x.localSecurityOptionsInformationShownOnLockScreen = localSecurityOptionsInformationShownOnLockScreen;
            _x.localSecurityOptionsLogOnMessageText = localSecurityOptionsLogOnMessageText;
            _x.localSecurityOptionsLogOnMessageTitle = localSecurityOptionsLogOnMessageTitle;
            _x.localSecurityOptionsMachineInactivityLimit = localSecurityOptionsMachineInactivityLimit;
            _x.localSecurityOptionsMachineInactivityLimitInMinutes = localSecurityOptionsMachineInactivityLimitInMinutes;
            _x.localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedClients = localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedClients;
            _x.localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedServers = localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedServers;
            _x.localSecurityOptionsOnlyElevateSignedExecutables = localSecurityOptionsOnlyElevateSignedExecutables;
            _x.localSecurityOptionsRestrictAnonymousAccessToNamedPipesAndShares = localSecurityOptionsRestrictAnonymousAccessToNamedPipesAndShares;
            _x.localSecurityOptionsSmartCardRemovalBehavior = localSecurityOptionsSmartCardRemovalBehavior;
            _x.localSecurityOptionsStandardUserElevationPromptBehavior = localSecurityOptionsStandardUserElevationPromptBehavior;
            _x.localSecurityOptionsSwitchToSecureDesktopWhenPromptingForElevation = localSecurityOptionsSwitchToSecureDesktopWhenPromptingForElevation;
            _x.localSecurityOptionsUseAdminApprovalMode = localSecurityOptionsUseAdminApprovalMode;
            _x.localSecurityOptionsUseAdminApprovalModeForAdministrators = localSecurityOptionsUseAdminApprovalModeForAdministrators;
            _x.localSecurityOptionsVirtualizeFileAndRegistryWriteFailuresToPerUserLocations = localSecurityOptionsVirtualizeFileAndRegistryWriteFailuresToPerUserLocations;
            _x.smartScreenBlockOverrideForFiles = smartScreenBlockOverrideForFiles;
            _x.smartScreenEnableInShell = smartScreenEnableInShell;
            _x.userRightsAccessCredentialManagerAsTrustedCaller = userRightsAccessCredentialManagerAsTrustedCaller;
            _x.userRightsActAsPartOfTheOperatingSystem = userRightsActAsPartOfTheOperatingSystem;
            _x.userRightsAllowAccessFromNetwork = userRightsAllowAccessFromNetwork;
            _x.userRightsBackupData = userRightsBackupData;
            _x.userRightsBlockAccessFromNetwork = userRightsBlockAccessFromNetwork;
            _x.userRightsChangeSystemTime = userRightsChangeSystemTime;
            _x.userRightsCreateGlobalObjects = userRightsCreateGlobalObjects;
            _x.userRightsCreatePageFile = userRightsCreatePageFile;
            _x.userRightsCreatePermanentSharedObjects = userRightsCreatePermanentSharedObjects;
            _x.userRightsCreateSymbolicLinks = userRightsCreateSymbolicLinks;
            _x.userRightsCreateToken = userRightsCreateToken;
            _x.userRightsDebugPrograms = userRightsDebugPrograms;
            _x.userRightsDelegation = userRightsDelegation;
            _x.userRightsDenyLocalLogOn = userRightsDenyLocalLogOn;
            _x.userRightsGenerateSecurityAudits = userRightsGenerateSecurityAudits;
            _x.userRightsImpersonateClient = userRightsImpersonateClient;
            _x.userRightsIncreaseSchedulingPriority = userRightsIncreaseSchedulingPriority;
            _x.userRightsLoadUnloadDrivers = userRightsLoadUnloadDrivers;
            _x.userRightsLocalLogOn = userRightsLocalLogOn;
            _x.userRightsLockMemory = userRightsLockMemory;
            _x.userRightsManageAuditingAndSecurityLogs = userRightsManageAuditingAndSecurityLogs;
            _x.userRightsManageVolumes = userRightsManageVolumes;
            _x.userRightsModifyFirmwareEnvironment = userRightsModifyFirmwareEnvironment;
            _x.userRightsModifyObjectLabels = userRightsModifyObjectLabels;
            _x.userRightsProfileSingleProcess = userRightsProfileSingleProcess;
            _x.userRightsRemoteDesktopServicesLogOn = userRightsRemoteDesktopServicesLogOn;
            _x.userRightsRemoteShutdown = userRightsRemoteShutdown;
            _x.userRightsRestoreData = userRightsRestoreData;
            _x.userRightsTakeOwnership = userRightsTakeOwnership;
            _x.windowsDefenderTamperProtection = windowsDefenderTamperProtection;
            _x.xboxServicesAccessoryManagementServiceStartupMode = xboxServicesAccessoryManagementServiceStartupMode;
            _x.xboxServicesEnableXboxGameSaveTask = xboxServicesEnableXboxGameSaveTask;
            _x.xboxServicesLiveAuthManagerServiceStartupMode = xboxServicesLiveAuthManagerServiceStartupMode;
            _x.xboxServicesLiveGameSaveServiceStartupMode = xboxServicesLiveGameSaveServiceStartupMode;
            _x.xboxServicesLiveNetworkingServiceStartupMode = xboxServicesLiveNetworkingServiceStartupMode;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Gets or sets whether applications inside Microsoft Defender Application Guard
     * can access the device’s camera and microphone.”</i>
     * 
     * @return property applicationGuardAllowCameraMicrophoneRedirection
     */
    @Property(name="applicationGuardAllowCameraMicrophoneRedirection")
    @JsonIgnore
    public Optional<Boolean> getApplicationGuardAllowCameraMicrophoneRedirection() {
        return Optional.ofNullable(applicationGuardAllowCameraMicrophoneRedirection);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * applicationGuardAllowCameraMicrophoneRedirection} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Gets or sets whether applications inside Microsoft Defender Application Guard
     * can access the device’s camera and microphone.”</i>
     * 
     * @param applicationGuardAllowCameraMicrophoneRedirection
     *            new value of {@code applicationGuardAllowCameraMicrophoneRedirection} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applicationGuardAllowCameraMicrophoneRedirection} field changed
     */
    public Windows10EndpointProtectionConfiguration withApplicationGuardAllowCameraMicrophoneRedirection(Boolean applicationGuardAllowCameraMicrophoneRedirection) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("applicationGuardAllowCameraMicrophoneRedirection");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.applicationGuardAllowCameraMicrophoneRedirection = applicationGuardAllowCameraMicrophoneRedirection;
        return _x;
    }

    /**
     * <i>“Allow users to download files from Edge in the application guard container and
     * save them on the host file system”</i>
     * 
     * @return property applicationGuardAllowFileSaveOnHost
     */
    @Property(name="applicationGuardAllowFileSaveOnHost")
    @JsonIgnore
    public Optional<Boolean> getApplicationGuardAllowFileSaveOnHost() {
        return Optional.ofNullable(applicationGuardAllowFileSaveOnHost);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * applicationGuardAllowFileSaveOnHost} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Allow users to download files from Edge in the application guard container and
     * save them on the host file system”</i>
     * 
     * @param applicationGuardAllowFileSaveOnHost
     *            new value of {@code applicationGuardAllowFileSaveOnHost} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applicationGuardAllowFileSaveOnHost} field changed
     */
    public Windows10EndpointProtectionConfiguration withApplicationGuardAllowFileSaveOnHost(Boolean applicationGuardAllowFileSaveOnHost) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("applicationGuardAllowFileSaveOnHost");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.applicationGuardAllowFileSaveOnHost = applicationGuardAllowFileSaveOnHost;
        return _x;
    }

    /**
     * <i>“Allow persisting user generated data inside the App Guard Containter (favorites,
     * cookies, web passwords, etc.)”</i>
     * 
     * @return property applicationGuardAllowPersistence
     */
    @Property(name="applicationGuardAllowPersistence")
    @JsonIgnore
    public Optional<Boolean> getApplicationGuardAllowPersistence() {
        return Optional.ofNullable(applicationGuardAllowPersistence);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * applicationGuardAllowPersistence} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Allow persisting user generated data inside the App Guard Containter (favorites,
     * cookies, web passwords, etc.)”</i>
     * 
     * @param applicationGuardAllowPersistence
     *            new value of {@code applicationGuardAllowPersistence} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applicationGuardAllowPersistence} field changed
     */
    public Windows10EndpointProtectionConfiguration withApplicationGuardAllowPersistence(Boolean applicationGuardAllowPersistence) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("applicationGuardAllowPersistence");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.applicationGuardAllowPersistence = applicationGuardAllowPersistence;
        return _x;
    }

    /**
     * <i>“Allow printing to Local Printers from Container”</i>
     * 
     * @return property applicationGuardAllowPrintToLocalPrinters
     */
    @Property(name="applicationGuardAllowPrintToLocalPrinters")
    @JsonIgnore
    public Optional<Boolean> getApplicationGuardAllowPrintToLocalPrinters() {
        return Optional.ofNullable(applicationGuardAllowPrintToLocalPrinters);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * applicationGuardAllowPrintToLocalPrinters} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Allow printing to Local Printers from Container”</i>
     * 
     * @param applicationGuardAllowPrintToLocalPrinters
     *            new value of {@code applicationGuardAllowPrintToLocalPrinters} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applicationGuardAllowPrintToLocalPrinters} field changed
     */
    public Windows10EndpointProtectionConfiguration withApplicationGuardAllowPrintToLocalPrinters(Boolean applicationGuardAllowPrintToLocalPrinters) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("applicationGuardAllowPrintToLocalPrinters");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.applicationGuardAllowPrintToLocalPrinters = applicationGuardAllowPrintToLocalPrinters;
        return _x;
    }

    /**
     * <i>“Allow printing to Network Printers from Container”</i>
     * 
     * @return property applicationGuardAllowPrintToNetworkPrinters
     */
    @Property(name="applicationGuardAllowPrintToNetworkPrinters")
    @JsonIgnore
    public Optional<Boolean> getApplicationGuardAllowPrintToNetworkPrinters() {
        return Optional.ofNullable(applicationGuardAllowPrintToNetworkPrinters);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * applicationGuardAllowPrintToNetworkPrinters} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Allow printing to Network Printers from Container”</i>
     * 
     * @param applicationGuardAllowPrintToNetworkPrinters
     *            new value of {@code applicationGuardAllowPrintToNetworkPrinters} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applicationGuardAllowPrintToNetworkPrinters} field changed
     */
    public Windows10EndpointProtectionConfiguration withApplicationGuardAllowPrintToNetworkPrinters(Boolean applicationGuardAllowPrintToNetworkPrinters) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("applicationGuardAllowPrintToNetworkPrinters");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.applicationGuardAllowPrintToNetworkPrinters = applicationGuardAllowPrintToNetworkPrinters;
        return _x;
    }

    /**
     * <i>“Allow printing to PDF from Container”</i>
     * 
     * @return property applicationGuardAllowPrintToPDF
     */
    @Property(name="applicationGuardAllowPrintToPDF")
    @JsonIgnore
    public Optional<Boolean> getApplicationGuardAllowPrintToPDF() {
        return Optional.ofNullable(applicationGuardAllowPrintToPDF);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * applicationGuardAllowPrintToPDF} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Allow printing to PDF from Container”</i>
     * 
     * @param applicationGuardAllowPrintToPDF
     *            new value of {@code applicationGuardAllowPrintToPDF} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applicationGuardAllowPrintToPDF} field changed
     */
    public Windows10EndpointProtectionConfiguration withApplicationGuardAllowPrintToPDF(Boolean applicationGuardAllowPrintToPDF) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("applicationGuardAllowPrintToPDF");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.applicationGuardAllowPrintToPDF = applicationGuardAllowPrintToPDF;
        return _x;
    }

    /**
     * <i>“Allow printing to XPS from Container”</i>
     * 
     * @return property applicationGuardAllowPrintToXPS
     */
    @Property(name="applicationGuardAllowPrintToXPS")
    @JsonIgnore
    public Optional<Boolean> getApplicationGuardAllowPrintToXPS() {
        return Optional.ofNullable(applicationGuardAllowPrintToXPS);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * applicationGuardAllowPrintToXPS} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Allow printing to XPS from Container”</i>
     * 
     * @param applicationGuardAllowPrintToXPS
     *            new value of {@code applicationGuardAllowPrintToXPS} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applicationGuardAllowPrintToXPS} field changed
     */
    public Windows10EndpointProtectionConfiguration withApplicationGuardAllowPrintToXPS(Boolean applicationGuardAllowPrintToXPS) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("applicationGuardAllowPrintToXPS");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.applicationGuardAllowPrintToXPS = applicationGuardAllowPrintToXPS;
        return _x;
    }

    /**
     * <i>“Allow application guard to use virtual GPU”</i>
     * 
     * @return property applicationGuardAllowVirtualGPU
     */
    @Property(name="applicationGuardAllowVirtualGPU")
    @JsonIgnore
    public Optional<Boolean> getApplicationGuardAllowVirtualGPU() {
        return Optional.ofNullable(applicationGuardAllowVirtualGPU);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * applicationGuardAllowVirtualGPU} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Allow application guard to use virtual GPU”</i>
     * 
     * @param applicationGuardAllowVirtualGPU
     *            new value of {@code applicationGuardAllowVirtualGPU} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applicationGuardAllowVirtualGPU} field changed
     */
    public Windows10EndpointProtectionConfiguration withApplicationGuardAllowVirtualGPU(Boolean applicationGuardAllowVirtualGPU) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("applicationGuardAllowVirtualGPU");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.applicationGuardAllowVirtualGPU = applicationGuardAllowVirtualGPU;
        return _x;
    }

    /**
     * <i>“Block clipboard to share data from Host to Container, or from Container to Host,
     * or both ways, or neither ways.”</i>
     * 
     * @return property applicationGuardBlockClipboardSharing
     */
    @Property(name="applicationGuardBlockClipboardSharing")
    @JsonIgnore
    public Optional<ApplicationGuardBlockClipboardSharingType> getApplicationGuardBlockClipboardSharing() {
        return Optional.ofNullable(applicationGuardBlockClipboardSharing);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * applicationGuardBlockClipboardSharing} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Block clipboard to share data from Host to Container, or from Container to Host,
     * or both ways, or neither ways.”</i>
     * 
     * @param applicationGuardBlockClipboardSharing
     *            new value of {@code applicationGuardBlockClipboardSharing} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applicationGuardBlockClipboardSharing} field changed
     */
    public Windows10EndpointProtectionConfiguration withApplicationGuardBlockClipboardSharing(ApplicationGuardBlockClipboardSharingType applicationGuardBlockClipboardSharing) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("applicationGuardBlockClipboardSharing");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.applicationGuardBlockClipboardSharing = applicationGuardBlockClipboardSharing;
        return _x;
    }

    /**
     * <i>“Block clipboard to transfer image file, text file or neither of them”</i>
     * 
     * @return property applicationGuardBlockFileTransfer
     */
    @Property(name="applicationGuardBlockFileTransfer")
    @JsonIgnore
    public Optional<ApplicationGuardBlockFileTransferType> getApplicationGuardBlockFileTransfer() {
        return Optional.ofNullable(applicationGuardBlockFileTransfer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * applicationGuardBlockFileTransfer} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Block clipboard to transfer image file, text file or neither of them”</i>
     * 
     * @param applicationGuardBlockFileTransfer
     *            new value of {@code applicationGuardBlockFileTransfer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applicationGuardBlockFileTransfer} field changed
     */
    public Windows10EndpointProtectionConfiguration withApplicationGuardBlockFileTransfer(ApplicationGuardBlockFileTransferType applicationGuardBlockFileTransfer) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("applicationGuardBlockFileTransfer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.applicationGuardBlockFileTransfer = applicationGuardBlockFileTransfer;
        return _x;
    }

    /**
     * <i>“Block enterprise sites to load non-enterprise content, such as third party plug-
     * ins”</i>
     * 
     * @return property applicationGuardBlockNonEnterpriseContent
     */
    @Property(name="applicationGuardBlockNonEnterpriseContent")
    @JsonIgnore
    public Optional<Boolean> getApplicationGuardBlockNonEnterpriseContent() {
        return Optional.ofNullable(applicationGuardBlockNonEnterpriseContent);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * applicationGuardBlockNonEnterpriseContent} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Block enterprise sites to load non-enterprise content, such as third party plug-
     * ins”</i>
     * 
     * @param applicationGuardBlockNonEnterpriseContent
     *            new value of {@code applicationGuardBlockNonEnterpriseContent} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applicationGuardBlockNonEnterpriseContent} field changed
     */
    public Windows10EndpointProtectionConfiguration withApplicationGuardBlockNonEnterpriseContent(Boolean applicationGuardBlockNonEnterpriseContent) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("applicationGuardBlockNonEnterpriseContent");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.applicationGuardBlockNonEnterpriseContent = applicationGuardBlockNonEnterpriseContent;
        return _x;
    }

    /**
     * <i>“Allows certain device level Root Certificates to be shared with the Microsoft
     * Defender Application Guard container.”</i>
     * 
     * @return property applicationGuardCertificateThumbprints
     */
    @Property(name="applicationGuardCertificateThumbprints")
    @JsonIgnore
    public CollectionPage<String> getApplicationGuardCertificateThumbprints() {
        return new CollectionPage<String>(contextPath, String.class, this.applicationGuardCertificateThumbprints, Optional.ofNullable(applicationGuardCertificateThumbprintsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * applicationGuardCertificateThumbprints} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Allows certain device level Root Certificates to be shared with the Microsoft
     * Defender Application Guard container.”</i>
     * 
     * @param applicationGuardCertificateThumbprints
     *            new value of {@code applicationGuardCertificateThumbprints} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applicationGuardCertificateThumbprints} field changed
     */
    public Windows10EndpointProtectionConfiguration withApplicationGuardCertificateThumbprints(List<String> applicationGuardCertificateThumbprints) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("applicationGuardCertificateThumbprints");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.applicationGuardCertificateThumbprints = applicationGuardCertificateThumbprints;
        return _x;
    }

    /**
     * <i>“Allows certain device level Root Certificates to be shared with the Microsoft
     * Defender Application Guard container.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property applicationGuardCertificateThumbprints
     */
    @Property(name="applicationGuardCertificateThumbprints")
    @JsonIgnore
    public CollectionPage<String> getApplicationGuardCertificateThumbprints(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.applicationGuardCertificateThumbprints, Optional.ofNullable(applicationGuardCertificateThumbprintsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Enable Windows Defender Application Guard”</i>
     * 
     * @return property applicationGuardEnabled
     */
    @Property(name="applicationGuardEnabled")
    @JsonIgnore
    public Optional<Boolean> getApplicationGuardEnabled() {
        return Optional.ofNullable(applicationGuardEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * applicationGuardEnabled} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Enable Windows Defender Application Guard”</i>
     * 
     * @param applicationGuardEnabled
     *            new value of {@code applicationGuardEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applicationGuardEnabled} field changed
     */
    public Windows10EndpointProtectionConfiguration withApplicationGuardEnabled(Boolean applicationGuardEnabled) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("applicationGuardEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.applicationGuardEnabled = applicationGuardEnabled;
        return _x;
    }

    /**
     * <i>“Enable Windows Defender Application Guard for newer Windows builds”</i>
     * 
     * @return property applicationGuardEnabledOptions
     */
    @Property(name="applicationGuardEnabledOptions")
    @JsonIgnore
    public Optional<ApplicationGuardEnabledOptions> getApplicationGuardEnabledOptions() {
        return Optional.ofNullable(applicationGuardEnabledOptions);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * applicationGuardEnabledOptions} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Enable Windows Defender Application Guard for newer Windows builds”</i>
     * 
     * @param applicationGuardEnabledOptions
     *            new value of {@code applicationGuardEnabledOptions} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applicationGuardEnabledOptions} field changed
     */
    public Windows10EndpointProtectionConfiguration withApplicationGuardEnabledOptions(ApplicationGuardEnabledOptions applicationGuardEnabledOptions) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("applicationGuardEnabledOptions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.applicationGuardEnabledOptions = applicationGuardEnabledOptions;
        return _x;
    }

    /**
     * <i>“Force auditing will persist Windows logs and events to meet security/compliance
     * criteria (sample events are user login-logoff, use of privilege rights, software
     * installation, system changes, etc.)”</i>
     * 
     * @return property applicationGuardForceAuditing
     */
    @Property(name="applicationGuardForceAuditing")
    @JsonIgnore
    public Optional<Boolean> getApplicationGuardForceAuditing() {
        return Optional.ofNullable(applicationGuardForceAuditing);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * applicationGuardForceAuditing} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Force auditing will persist Windows logs and events to meet security/compliance
     * criteria (sample events are user login-logoff, use of privilege rights, software
     * installation, system changes, etc.)”</i>
     * 
     * @param applicationGuardForceAuditing
     *            new value of {@code applicationGuardForceAuditing} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applicationGuardForceAuditing} field changed
     */
    public Windows10EndpointProtectionConfiguration withApplicationGuardForceAuditing(Boolean applicationGuardForceAuditing) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("applicationGuardForceAuditing");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.applicationGuardForceAuditing = applicationGuardForceAuditing;
        return _x;
    }

    /**
     * <i>“Enables the Admin to choose what types of app to allow on devices.”</i>
     * 
     * @return property appLockerApplicationControl
     */
    @Property(name="appLockerApplicationControl")
    @JsonIgnore
    public Optional<AppLockerApplicationControlType> getAppLockerApplicationControl() {
        return Optional.ofNullable(appLockerApplicationControl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appLockerApplicationControl} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Enables the Admin to choose what types of app to allow on devices.”</i>
     * 
     * @param appLockerApplicationControl
     *            new value of {@code appLockerApplicationControl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appLockerApplicationControl} field changed
     */
    public Windows10EndpointProtectionConfiguration withAppLockerApplicationControl(AppLockerApplicationControlType appLockerApplicationControl) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("appLockerApplicationControl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.appLockerApplicationControl = appLockerApplicationControl;
        return _x;
    }

    /**
     * <i>“Allows the admin to allow standard users to enable encrpytion during Azure AD
     * Join.”</i>
     * 
     * @return property bitLockerAllowStandardUserEncryption
     */
    @Property(name="bitLockerAllowStandardUserEncryption")
    @JsonIgnore
    public Optional<Boolean> getBitLockerAllowStandardUserEncryption() {
        return Optional.ofNullable(bitLockerAllowStandardUserEncryption);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bitLockerAllowStandardUserEncryption} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Allows the admin to allow standard users to enable encrpytion during Azure AD
     * Join.”</i>
     * 
     * @param bitLockerAllowStandardUserEncryption
     *            new value of {@code bitLockerAllowStandardUserEncryption} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bitLockerAllowStandardUserEncryption} field changed
     */
    public Windows10EndpointProtectionConfiguration withBitLockerAllowStandardUserEncryption(Boolean bitLockerAllowStandardUserEncryption) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("bitLockerAllowStandardUserEncryption");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.bitLockerAllowStandardUserEncryption = bitLockerAllowStandardUserEncryption;
        return _x;
    }

    /**
     * <i>“Allows the Admin to disable the warning prompt for other disk encryption on the
     * user machines.”</i>
     * 
     * @return property bitLockerDisableWarningForOtherDiskEncryption
     */
    @Property(name="bitLockerDisableWarningForOtherDiskEncryption")
    @JsonIgnore
    public Optional<Boolean> getBitLockerDisableWarningForOtherDiskEncryption() {
        return Optional.ofNullable(bitLockerDisableWarningForOtherDiskEncryption);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bitLockerDisableWarningForOtherDiskEncryption} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Allows the Admin to disable the warning prompt for other disk encryption on the
     * user machines.”</i>
     * 
     * @param bitLockerDisableWarningForOtherDiskEncryption
     *            new value of {@code bitLockerDisableWarningForOtherDiskEncryption} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bitLockerDisableWarningForOtherDiskEncryption} field changed
     */
    public Windows10EndpointProtectionConfiguration withBitLockerDisableWarningForOtherDiskEncryption(Boolean bitLockerDisableWarningForOtherDiskEncryption) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("bitLockerDisableWarningForOtherDiskEncryption");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.bitLockerDisableWarningForOtherDiskEncryption = bitLockerDisableWarningForOtherDiskEncryption;
        return _x;
    }

    /**
     * <i>“Allows the admin to require encryption to be turned on using BitLocker. This
     * policy is valid only for a mobile SKU.”</i>
     * 
     * @return property bitLockerEnableStorageCardEncryptionOnMobile
     */
    @Property(name="bitLockerEnableStorageCardEncryptionOnMobile")
    @JsonIgnore
    public Optional<Boolean> getBitLockerEnableStorageCardEncryptionOnMobile() {
        return Optional.ofNullable(bitLockerEnableStorageCardEncryptionOnMobile);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bitLockerEnableStorageCardEncryptionOnMobile} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Allows the admin to require encryption to be turned on using BitLocker. This
     * policy is valid only for a mobile SKU.”</i>
     * 
     * @param bitLockerEnableStorageCardEncryptionOnMobile
     *            new value of {@code bitLockerEnableStorageCardEncryptionOnMobile} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bitLockerEnableStorageCardEncryptionOnMobile} field changed
     */
    public Windows10EndpointProtectionConfiguration withBitLockerEnableStorageCardEncryptionOnMobile(Boolean bitLockerEnableStorageCardEncryptionOnMobile) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("bitLockerEnableStorageCardEncryptionOnMobile");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.bitLockerEnableStorageCardEncryptionOnMobile = bitLockerEnableStorageCardEncryptionOnMobile;
        return _x;
    }

    /**
     * <i>“Allows the admin to require encryption to be turned on using BitLocker.”</i>
     * 
     * @return property bitLockerEncryptDevice
     */
    @Property(name="bitLockerEncryptDevice")
    @JsonIgnore
    public Optional<Boolean> getBitLockerEncryptDevice() {
        return Optional.ofNullable(bitLockerEncryptDevice);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bitLockerEncryptDevice} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Allows the admin to require encryption to be turned on using BitLocker.”</i>
     * 
     * @param bitLockerEncryptDevice
     *            new value of {@code bitLockerEncryptDevice} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bitLockerEncryptDevice} field changed
     */
    public Windows10EndpointProtectionConfiguration withBitLockerEncryptDevice(Boolean bitLockerEncryptDevice) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("bitLockerEncryptDevice");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.bitLockerEncryptDevice = bitLockerEncryptDevice;
        return _x;
    }

    /**
     * <i>“BitLocker Fixed Drive Policy.”</i>
     * 
     * @return property bitLockerFixedDrivePolicy
     */
    @Property(name="bitLockerFixedDrivePolicy")
    @JsonIgnore
    public Optional<BitLockerFixedDrivePolicy> getBitLockerFixedDrivePolicy() {
        return Optional.ofNullable(bitLockerFixedDrivePolicy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bitLockerFixedDrivePolicy} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“BitLocker Fixed Drive Policy.”</i>
     * 
     * @param bitLockerFixedDrivePolicy
     *            new value of {@code bitLockerFixedDrivePolicy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bitLockerFixedDrivePolicy} field changed
     */
    public Windows10EndpointProtectionConfiguration withBitLockerFixedDrivePolicy(BitLockerFixedDrivePolicy bitLockerFixedDrivePolicy) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("bitLockerFixedDrivePolicy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.bitLockerFixedDrivePolicy = bitLockerFixedDrivePolicy;
        return _x;
    }

    /**
     * <i>“This setting initiates a client-driven recovery password rotation after an OS
     * drive recovery (either by using bootmgr or WinRE).”</i>
     * 
     * @return property bitLockerRecoveryPasswordRotation
     */
    @Property(name="bitLockerRecoveryPasswordRotation")
    @JsonIgnore
    public Optional<BitLockerRecoveryPasswordRotationType> getBitLockerRecoveryPasswordRotation() {
        return Optional.ofNullable(bitLockerRecoveryPasswordRotation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bitLockerRecoveryPasswordRotation} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“This setting initiates a client-driven recovery password rotation after an OS
     * drive recovery (either by using bootmgr or WinRE).”</i>
     * 
     * @param bitLockerRecoveryPasswordRotation
     *            new value of {@code bitLockerRecoveryPasswordRotation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bitLockerRecoveryPasswordRotation} field changed
     */
    public Windows10EndpointProtectionConfiguration withBitLockerRecoveryPasswordRotation(BitLockerRecoveryPasswordRotationType bitLockerRecoveryPasswordRotation) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("bitLockerRecoveryPasswordRotation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.bitLockerRecoveryPasswordRotation = bitLockerRecoveryPasswordRotation;
        return _x;
    }

    /**
     * <i>“BitLocker Removable Drive Policy.”</i>
     * 
     * @return property bitLockerRemovableDrivePolicy
     */
    @Property(name="bitLockerRemovableDrivePolicy")
    @JsonIgnore
    public Optional<BitLockerRemovableDrivePolicy> getBitLockerRemovableDrivePolicy() {
        return Optional.ofNullable(bitLockerRemovableDrivePolicy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bitLockerRemovableDrivePolicy} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“BitLocker Removable Drive Policy.”</i>
     * 
     * @param bitLockerRemovableDrivePolicy
     *            new value of {@code bitLockerRemovableDrivePolicy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bitLockerRemovableDrivePolicy} field changed
     */
    public Windows10EndpointProtectionConfiguration withBitLockerRemovableDrivePolicy(BitLockerRemovableDrivePolicy bitLockerRemovableDrivePolicy) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("bitLockerRemovableDrivePolicy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.bitLockerRemovableDrivePolicy = bitLockerRemovableDrivePolicy;
        return _x;
    }

    /**
     * <i>“BitLocker System Drive Policy.”</i>
     * 
     * @return property bitLockerSystemDrivePolicy
     */
    @Property(name="bitLockerSystemDrivePolicy")
    @JsonIgnore
    public Optional<BitLockerSystemDrivePolicy> getBitLockerSystemDrivePolicy() {
        return Optional.ofNullable(bitLockerSystemDrivePolicy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bitLockerSystemDrivePolicy} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“BitLocker System Drive Policy.”</i>
     * 
     * @param bitLockerSystemDrivePolicy
     *            new value of {@code bitLockerSystemDrivePolicy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bitLockerSystemDrivePolicy} field changed
     */
    public Windows10EndpointProtectionConfiguration withBitLockerSystemDrivePolicy(BitLockerSystemDrivePolicy bitLockerSystemDrivePolicy) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("bitLockerSystemDrivePolicy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.bitLockerSystemDrivePolicy = bitLockerSystemDrivePolicy;
        return _x;
    }

    /**
     * <i>“List of folder paths to be added to the list of protected folders”</i>
     * 
     * @return property defenderAdditionalGuardedFolders
     */
    @Property(name="defenderAdditionalGuardedFolders")
    @JsonIgnore
    public CollectionPage<String> getDefenderAdditionalGuardedFolders() {
        return new CollectionPage<String>(contextPath, String.class, this.defenderAdditionalGuardedFolders, Optional.ofNullable(defenderAdditionalGuardedFoldersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderAdditionalGuardedFolders} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“List of folder paths to be added to the list of protected folders”</i>
     * 
     * @param defenderAdditionalGuardedFolders
     *            new value of {@code defenderAdditionalGuardedFolders} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderAdditionalGuardedFolders} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderAdditionalGuardedFolders(List<String> defenderAdditionalGuardedFolders) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderAdditionalGuardedFolders");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderAdditionalGuardedFolders = defenderAdditionalGuardedFolders;
        return _x;
    }

    /**
     * <i>“List of folder paths to be added to the list of protected folders”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property defenderAdditionalGuardedFolders
     */
    @Property(name="defenderAdditionalGuardedFolders")
    @JsonIgnore
    public CollectionPage<String> getDefenderAdditionalGuardedFolders(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.defenderAdditionalGuardedFolders, Optional.ofNullable(defenderAdditionalGuardedFoldersNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Value indicating the behavior of Adobe Reader from creating child processes”</i>
     * 
     * @return property defenderAdobeReaderLaunchChildProcess
     */
    @Property(name="defenderAdobeReaderLaunchChildProcess")
    @JsonIgnore
    public Optional<DefenderProtectionType> getDefenderAdobeReaderLaunchChildProcess() {
        return Optional.ofNullable(defenderAdobeReaderLaunchChildProcess);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderAdobeReaderLaunchChildProcess} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Value indicating the behavior of Adobe Reader from creating child processes”</i>
     * 
     * @param defenderAdobeReaderLaunchChildProcess
     *            new value of {@code defenderAdobeReaderLaunchChildProcess} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderAdobeReaderLaunchChildProcess} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderAdobeReaderLaunchChildProcess(DefenderProtectionType defenderAdobeReaderLaunchChildProcess) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderAdobeReaderLaunchChildProcess");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderAdobeReaderLaunchChildProcess = defenderAdobeReaderLaunchChildProcess;
        return _x;
    }

    /**
     * <i>“Value indicating use of advanced protection against ransomeware”</i>
     * 
     * @return property defenderAdvancedRansomewareProtectionType
     */
    @Property(name="defenderAdvancedRansomewareProtectionType")
    @JsonIgnore
    public Optional<DefenderProtectionType> getDefenderAdvancedRansomewareProtectionType() {
        return Optional.ofNullable(defenderAdvancedRansomewareProtectionType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderAdvancedRansomewareProtectionType} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Value indicating use of advanced protection against ransomeware”</i>
     * 
     * @param defenderAdvancedRansomewareProtectionType
     *            new value of {@code defenderAdvancedRansomewareProtectionType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderAdvancedRansomewareProtectionType} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderAdvancedRansomewareProtectionType(DefenderProtectionType defenderAdvancedRansomewareProtectionType) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderAdvancedRansomewareProtectionType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderAdvancedRansomewareProtectionType = defenderAdvancedRansomewareProtectionType;
        return _x;
    }

    /**
     * <i>“Allows or disallows Windows Defender Behavior Monitoring functionality.”</i>
     * 
     * @return property defenderAllowBehaviorMonitoring
     */
    @Property(name="defenderAllowBehaviorMonitoring")
    @JsonIgnore
    public Optional<Boolean> getDefenderAllowBehaviorMonitoring() {
        return Optional.ofNullable(defenderAllowBehaviorMonitoring);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderAllowBehaviorMonitoring} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Allows or disallows Windows Defender Behavior Monitoring functionality.”</i>
     * 
     * @param defenderAllowBehaviorMonitoring
     *            new value of {@code defenderAllowBehaviorMonitoring} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderAllowBehaviorMonitoring} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderAllowBehaviorMonitoring(Boolean defenderAllowBehaviorMonitoring) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderAllowBehaviorMonitoring");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderAllowBehaviorMonitoring = defenderAllowBehaviorMonitoring;
        return _x;
    }

    /**
     * <i>“To best protect your PC, Windows Defender will send information to Microsoft
     * about any problems it finds. Microsoft will analyze that information, learn more
     * about problems affecting you and other customers, and offer improved solutions.”</i>
     * 
     * @return property defenderAllowCloudProtection
     */
    @Property(name="defenderAllowCloudProtection")
    @JsonIgnore
    public Optional<Boolean> getDefenderAllowCloudProtection() {
        return Optional.ofNullable(defenderAllowCloudProtection);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderAllowCloudProtection} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“To best protect your PC, Windows Defender will send information to Microsoft
     * about any problems it finds. Microsoft will analyze that information, learn more
     * about problems affecting you and other customers, and offer improved solutions.”</i>
     * 
     * @param defenderAllowCloudProtection
     *            new value of {@code defenderAllowCloudProtection} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderAllowCloudProtection} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderAllowCloudProtection(Boolean defenderAllowCloudProtection) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderAllowCloudProtection");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderAllowCloudProtection = defenderAllowCloudProtection;
        return _x;
    }

    /**
     * <i>“Allows or disallows user access to the Windows Defender UI. If disallowed, all
     * Windows Defender notifications will also be suppressed.”</i>
     * 
     * @return property defenderAllowEndUserAccess
     */
    @Property(name="defenderAllowEndUserAccess")
    @JsonIgnore
    public Optional<Boolean> getDefenderAllowEndUserAccess() {
        return Optional.ofNullable(defenderAllowEndUserAccess);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderAllowEndUserAccess} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Allows or disallows user access to the Windows Defender UI. If disallowed, all
     * Windows Defender notifications will also be suppressed.”</i>
     * 
     * @param defenderAllowEndUserAccess
     *            new value of {@code defenderAllowEndUserAccess} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderAllowEndUserAccess} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderAllowEndUserAccess(Boolean defenderAllowEndUserAccess) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderAllowEndUserAccess");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderAllowEndUserAccess = defenderAllowEndUserAccess;
        return _x;
    }

    /**
     * <i>“Allows or disallows Windows Defender Intrusion Prevention functionality.”</i>
     * 
     * @return property defenderAllowIntrusionPreventionSystem
     */
    @Property(name="defenderAllowIntrusionPreventionSystem")
    @JsonIgnore
    public Optional<Boolean> getDefenderAllowIntrusionPreventionSystem() {
        return Optional.ofNullable(defenderAllowIntrusionPreventionSystem);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderAllowIntrusionPreventionSystem} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Allows or disallows Windows Defender Intrusion Prevention functionality.”</i>
     * 
     * @param defenderAllowIntrusionPreventionSystem
     *            new value of {@code defenderAllowIntrusionPreventionSystem} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderAllowIntrusionPreventionSystem} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderAllowIntrusionPreventionSystem(Boolean defenderAllowIntrusionPreventionSystem) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderAllowIntrusionPreventionSystem");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderAllowIntrusionPreventionSystem = defenderAllowIntrusionPreventionSystem;
        return _x;
    }

    /**
     * <i>“Allows or disallows Windows Defender On Access Protection functionality.”</i>
     * 
     * @return property defenderAllowOnAccessProtection
     */
    @Property(name="defenderAllowOnAccessProtection")
    @JsonIgnore
    public Optional<Boolean> getDefenderAllowOnAccessProtection() {
        return Optional.ofNullable(defenderAllowOnAccessProtection);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderAllowOnAccessProtection} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Allows or disallows Windows Defender On Access Protection functionality.”</i>
     * 
     * @param defenderAllowOnAccessProtection
     *            new value of {@code defenderAllowOnAccessProtection} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderAllowOnAccessProtection} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderAllowOnAccessProtection(Boolean defenderAllowOnAccessProtection) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderAllowOnAccessProtection");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderAllowOnAccessProtection = defenderAllowOnAccessProtection;
        return _x;
    }

    /**
     * <i>“Allows or disallows Windows Defender Realtime Monitoring functionality.”</i>
     * 
     * @return property defenderAllowRealTimeMonitoring
     */
    @Property(name="defenderAllowRealTimeMonitoring")
    @JsonIgnore
    public Optional<Boolean> getDefenderAllowRealTimeMonitoring() {
        return Optional.ofNullable(defenderAllowRealTimeMonitoring);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderAllowRealTimeMonitoring} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Allows or disallows Windows Defender Realtime Monitoring functionality.”</i>
     * 
     * @param defenderAllowRealTimeMonitoring
     *            new value of {@code defenderAllowRealTimeMonitoring} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderAllowRealTimeMonitoring} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderAllowRealTimeMonitoring(Boolean defenderAllowRealTimeMonitoring) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderAllowRealTimeMonitoring");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderAllowRealTimeMonitoring = defenderAllowRealTimeMonitoring;
        return _x;
    }

    /**
     * <i>“Allows or disallows scanning of archives.”</i>
     * 
     * @return property defenderAllowScanArchiveFiles
     */
    @Property(name="defenderAllowScanArchiveFiles")
    @JsonIgnore
    public Optional<Boolean> getDefenderAllowScanArchiveFiles() {
        return Optional.ofNullable(defenderAllowScanArchiveFiles);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderAllowScanArchiveFiles} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Allows or disallows scanning of archives.”</i>
     * 
     * @param defenderAllowScanArchiveFiles
     *            new value of {@code defenderAllowScanArchiveFiles} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderAllowScanArchiveFiles} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderAllowScanArchiveFiles(Boolean defenderAllowScanArchiveFiles) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderAllowScanArchiveFiles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderAllowScanArchiveFiles = defenderAllowScanArchiveFiles;
        return _x;
    }

    /**
     * <i>“Allows or disallows Windows Defender IOAVP Protection functionality.”</i>
     * 
     * @return property defenderAllowScanDownloads
     */
    @Property(name="defenderAllowScanDownloads")
    @JsonIgnore
    public Optional<Boolean> getDefenderAllowScanDownloads() {
        return Optional.ofNullable(defenderAllowScanDownloads);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderAllowScanDownloads} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Allows or disallows Windows Defender IOAVP Protection functionality.”</i>
     * 
     * @param defenderAllowScanDownloads
     *            new value of {@code defenderAllowScanDownloads} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderAllowScanDownloads} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderAllowScanDownloads(Boolean defenderAllowScanDownloads) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderAllowScanDownloads");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderAllowScanDownloads = defenderAllowScanDownloads;
        return _x;
    }

    /**
     * <i>“Allows or disallows a scanning of network files.”</i>
     * 
     * @return property defenderAllowScanNetworkFiles
     */
    @Property(name="defenderAllowScanNetworkFiles")
    @JsonIgnore
    public Optional<Boolean> getDefenderAllowScanNetworkFiles() {
        return Optional.ofNullable(defenderAllowScanNetworkFiles);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderAllowScanNetworkFiles} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Allows or disallows a scanning of network files.”</i>
     * 
     * @param defenderAllowScanNetworkFiles
     *            new value of {@code defenderAllowScanNetworkFiles} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderAllowScanNetworkFiles} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderAllowScanNetworkFiles(Boolean defenderAllowScanNetworkFiles) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderAllowScanNetworkFiles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderAllowScanNetworkFiles = defenderAllowScanNetworkFiles;
        return _x;
    }

    /**
     * <i>“Allows or disallows a full scan of removable drives. During a quick scan,
     * removable drives may still be scanned.”</i>
     * 
     * @return property defenderAllowScanRemovableDrivesDuringFullScan
     */
    @Property(name="defenderAllowScanRemovableDrivesDuringFullScan")
    @JsonIgnore
    public Optional<Boolean> getDefenderAllowScanRemovableDrivesDuringFullScan() {
        return Optional.ofNullable(defenderAllowScanRemovableDrivesDuringFullScan);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderAllowScanRemovableDrivesDuringFullScan} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Allows or disallows a full scan of removable drives. During a quick scan,
     * removable drives may still be scanned.”</i>
     * 
     * @param defenderAllowScanRemovableDrivesDuringFullScan
     *            new value of {@code defenderAllowScanRemovableDrivesDuringFullScan} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderAllowScanRemovableDrivesDuringFullScan} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderAllowScanRemovableDrivesDuringFullScan(Boolean defenderAllowScanRemovableDrivesDuringFullScan) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderAllowScanRemovableDrivesDuringFullScan");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderAllowScanRemovableDrivesDuringFullScan = defenderAllowScanRemovableDrivesDuringFullScan;
        return _x;
    }

    /**
     * <i>“Allows or disallows Windows Defender Script Scanning functionality.”</i>
     * 
     * @return property defenderAllowScanScriptsLoadedInInternetExplorer
     */
    @Property(name="defenderAllowScanScriptsLoadedInInternetExplorer")
    @JsonIgnore
    public Optional<Boolean> getDefenderAllowScanScriptsLoadedInInternetExplorer() {
        return Optional.ofNullable(defenderAllowScanScriptsLoadedInInternetExplorer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderAllowScanScriptsLoadedInInternetExplorer} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Allows or disallows Windows Defender Script Scanning functionality.”</i>
     * 
     * @param defenderAllowScanScriptsLoadedInInternetExplorer
     *            new value of {@code defenderAllowScanScriptsLoadedInInternetExplorer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderAllowScanScriptsLoadedInInternetExplorer} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderAllowScanScriptsLoadedInInternetExplorer(Boolean defenderAllowScanScriptsLoadedInInternetExplorer) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderAllowScanScriptsLoadedInInternetExplorer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderAllowScanScriptsLoadedInInternetExplorer = defenderAllowScanScriptsLoadedInInternetExplorer;
        return _x;
    }

    /**
     * <i>“List of exe files and folders to be excluded from attack surface reduction rules”</i>
     * 
     * @return property defenderAttackSurfaceReductionExcludedPaths
     */
    @Property(name="defenderAttackSurfaceReductionExcludedPaths")
    @JsonIgnore
    public CollectionPage<String> getDefenderAttackSurfaceReductionExcludedPaths() {
        return new CollectionPage<String>(contextPath, String.class, this.defenderAttackSurfaceReductionExcludedPaths, Optional.ofNullable(defenderAttackSurfaceReductionExcludedPathsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderAttackSurfaceReductionExcludedPaths} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“List of exe files and folders to be excluded from attack surface reduction rules”</i>
     * 
     * @param defenderAttackSurfaceReductionExcludedPaths
     *            new value of {@code defenderAttackSurfaceReductionExcludedPaths} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderAttackSurfaceReductionExcludedPaths} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderAttackSurfaceReductionExcludedPaths(List<String> defenderAttackSurfaceReductionExcludedPaths) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderAttackSurfaceReductionExcludedPaths");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderAttackSurfaceReductionExcludedPaths = defenderAttackSurfaceReductionExcludedPaths;
        return _x;
    }

    /**
     * <i>“List of exe files and folders to be excluded from attack surface reduction rules”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property defenderAttackSurfaceReductionExcludedPaths
     */
    @Property(name="defenderAttackSurfaceReductionExcludedPaths")
    @JsonIgnore
    public CollectionPage<String> getDefenderAttackSurfaceReductionExcludedPaths(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.defenderAttackSurfaceReductionExcludedPaths, Optional.ofNullable(defenderAttackSurfaceReductionExcludedPathsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Allows or disallows user access to the Windows Defender UI. If disallowed, all
     * Windows Defender notifications will also be suppressed.”</i>
     * 
     * @return property defenderBlockEndUserAccess
     */
    @Property(name="defenderBlockEndUserAccess")
    @JsonIgnore
    public Optional<Boolean> getDefenderBlockEndUserAccess() {
        return Optional.ofNullable(defenderBlockEndUserAccess);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderBlockEndUserAccess} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Allows or disallows user access to the Windows Defender UI. If disallowed, all
     * Windows Defender notifications will also be suppressed.”</i>
     * 
     * @param defenderBlockEndUserAccess
     *            new value of {@code defenderBlockEndUserAccess} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderBlockEndUserAccess} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderBlockEndUserAccess(Boolean defenderBlockEndUserAccess) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderBlockEndUserAccess");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderBlockEndUserAccess = defenderBlockEndUserAccess;
        return _x;
    }

    /**
     * <i>“Value indicating the behavior of Block persistence through WMI event
     * subscription”</i>
     * 
     * @return property defenderBlockPersistenceThroughWmiType
     */
    @Property(name="defenderBlockPersistenceThroughWmiType")
    @JsonIgnore
    public Optional<DefenderAttackSurfaceType> getDefenderBlockPersistenceThroughWmiType() {
        return Optional.ofNullable(defenderBlockPersistenceThroughWmiType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderBlockPersistenceThroughWmiType} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Value indicating the behavior of Block persistence through WMI event
     * subscription”</i>
     * 
     * @param defenderBlockPersistenceThroughWmiType
     *            new value of {@code defenderBlockPersistenceThroughWmiType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderBlockPersistenceThroughWmiType} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderBlockPersistenceThroughWmiType(DefenderAttackSurfaceType defenderBlockPersistenceThroughWmiType) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderBlockPersistenceThroughWmiType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderBlockPersistenceThroughWmiType = defenderBlockPersistenceThroughWmiType;
        return _x;
    }

    /**
     * <i>“This policy setting allows you to manage whether a check for new virus and
     * spyware definitions will occur before running a scan.”</i>
     * 
     * @return property defenderCheckForSignaturesBeforeRunningScan
     */
    @Property(name="defenderCheckForSignaturesBeforeRunningScan")
    @JsonIgnore
    public Optional<Boolean> getDefenderCheckForSignaturesBeforeRunningScan() {
        return Optional.ofNullable(defenderCheckForSignaturesBeforeRunningScan);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderCheckForSignaturesBeforeRunningScan} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“This policy setting allows you to manage whether a check for new virus and
     * spyware definitions will occur before running a scan.”</i>
     * 
     * @param defenderCheckForSignaturesBeforeRunningScan
     *            new value of {@code defenderCheckForSignaturesBeforeRunningScan} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderCheckForSignaturesBeforeRunningScan} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderCheckForSignaturesBeforeRunningScan(Boolean defenderCheckForSignaturesBeforeRunningScan) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderCheckForSignaturesBeforeRunningScan");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderCheckForSignaturesBeforeRunningScan = defenderCheckForSignaturesBeforeRunningScan;
        return _x;
    }

    /**
     * <i>“Added in Windows 10, version 1709. This policy setting determines how aggressive
     * Windows Defender Antivirus will be in blocking and scanning suspicious files.
     * Value type is integer. This feature requires the "Join Microsoft MAPS" setting
     * enabled in order to function.”</i>
     * 
     * @return property defenderCloudBlockLevel
     */
    @Property(name="defenderCloudBlockLevel")
    @JsonIgnore
    public Optional<DefenderCloudBlockLevelType> getDefenderCloudBlockLevel() {
        return Optional.ofNullable(defenderCloudBlockLevel);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderCloudBlockLevel} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Added in Windows 10, version 1709. This policy setting determines how aggressive
     * Windows Defender Antivirus will be in blocking and scanning suspicious files.
     * Value type is integer. This feature requires the "Join Microsoft MAPS" setting
     * enabled in order to function.”</i>
     * 
     * @param defenderCloudBlockLevel
     *            new value of {@code defenderCloudBlockLevel} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderCloudBlockLevel} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderCloudBlockLevel(DefenderCloudBlockLevelType defenderCloudBlockLevel) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderCloudBlockLevel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderCloudBlockLevel = defenderCloudBlockLevel;
        return _x;
    }

    /**
     * <i>“Added in Windows 10, version 1709. This feature allows Windows Defender
     * Antivirus to block a suspicious file for up to 60 seconds, and scan it in the
     * cloud to make sure it's safe. Value type is integer, range is 0 - 50. This
     * feature depends on three other MAPS settings the must all be enabled- "Configure
     * the 'Block at First Sight' feature; "Join Microsoft MAPS"; "Send file samples
     * when further analysis is required". Valid values 0 to 50”</i>
     * 
     * @return property defenderCloudExtendedTimeoutInSeconds
     */
    @Property(name="defenderCloudExtendedTimeoutInSeconds")
    @JsonIgnore
    public Optional<Integer> getDefenderCloudExtendedTimeoutInSeconds() {
        return Optional.ofNullable(defenderCloudExtendedTimeoutInSeconds);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderCloudExtendedTimeoutInSeconds} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Added in Windows 10, version 1709. This feature allows Windows Defender
     * Antivirus to block a suspicious file for up to 60 seconds, and scan it in the
     * cloud to make sure it's safe. Value type is integer, range is 0 - 50. This
     * feature depends on three other MAPS settings the must all be enabled- "Configure
     * the 'Block at First Sight' feature; "Join Microsoft MAPS"; "Send file samples
     * when further analysis is required". Valid values 0 to 50”</i>
     * 
     * @param defenderCloudExtendedTimeoutInSeconds
     *            new value of {@code defenderCloudExtendedTimeoutInSeconds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderCloudExtendedTimeoutInSeconds} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderCloudExtendedTimeoutInSeconds(Integer defenderCloudExtendedTimeoutInSeconds) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderCloudExtendedTimeoutInSeconds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderCloudExtendedTimeoutInSeconds = defenderCloudExtendedTimeoutInSeconds;
        return _x;
    }

    /**
     * <i>“Time period (in days) that quarantine items will be stored on the system. Valid
     * values 0 to 90”</i>
     * 
     * @return property defenderDaysBeforeDeletingQuarantinedMalware
     */
    @Property(name="defenderDaysBeforeDeletingQuarantinedMalware")
    @JsonIgnore
    public Optional<Integer> getDefenderDaysBeforeDeletingQuarantinedMalware() {
        return Optional.ofNullable(defenderDaysBeforeDeletingQuarantinedMalware);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderDaysBeforeDeletingQuarantinedMalware} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Time period (in days) that quarantine items will be stored on the system. Valid
     * values 0 to 90”</i>
     * 
     * @param defenderDaysBeforeDeletingQuarantinedMalware
     *            new value of {@code defenderDaysBeforeDeletingQuarantinedMalware} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderDaysBeforeDeletingQuarantinedMalware} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderDaysBeforeDeletingQuarantinedMalware(Integer defenderDaysBeforeDeletingQuarantinedMalware) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderDaysBeforeDeletingQuarantinedMalware");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderDaysBeforeDeletingQuarantinedMalware = defenderDaysBeforeDeletingQuarantinedMalware;
        return _x;
    }

    /**
     * <i>“Allows an administrator to specify any valid threat severity levels and the
     * corresponding default action ID to take.”</i>
     * 
     * @return property defenderDetectedMalwareActions
     */
    @Property(name="defenderDetectedMalwareActions")
    @JsonIgnore
    public Optional<DefenderDetectedMalwareActions> getDefenderDetectedMalwareActions() {
        return Optional.ofNullable(defenderDetectedMalwareActions);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderDetectedMalwareActions} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Allows an administrator to specify any valid threat severity levels and the
     * corresponding default action ID to take.”</i>
     * 
     * @param defenderDetectedMalwareActions
     *            new value of {@code defenderDetectedMalwareActions} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderDetectedMalwareActions} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderDetectedMalwareActions(DefenderDetectedMalwareActions defenderDetectedMalwareActions) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderDetectedMalwareActions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderDetectedMalwareActions = defenderDetectedMalwareActions;
        return _x;
    }

    /**
     * <i>“Allows or disallows Windows Defender Behavior Monitoring functionality.”</i>
     * 
     * @return property defenderDisableBehaviorMonitoring
     */
    @Property(name="defenderDisableBehaviorMonitoring")
    @JsonIgnore
    public Optional<Boolean> getDefenderDisableBehaviorMonitoring() {
        return Optional.ofNullable(defenderDisableBehaviorMonitoring);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderDisableBehaviorMonitoring} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Allows or disallows Windows Defender Behavior Monitoring functionality.”</i>
     * 
     * @param defenderDisableBehaviorMonitoring
     *            new value of {@code defenderDisableBehaviorMonitoring} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderDisableBehaviorMonitoring} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderDisableBehaviorMonitoring(Boolean defenderDisableBehaviorMonitoring) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderDisableBehaviorMonitoring");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderDisableBehaviorMonitoring = defenderDisableBehaviorMonitoring;
        return _x;
    }

    /**
     * <i>“This policy setting allows you to configure catch-up scans for scheduled full
     * scans. A catch-up scan is a scan that is initiated because a regularly scheduled
     * scan was missed. Usually these scheduled scans are missed because the computer
     * was turned off at the scheduled time.”</i>
     * 
     * @return property defenderDisableCatchupFullScan
     */
    @Property(name="defenderDisableCatchupFullScan")
    @JsonIgnore
    public Optional<Boolean> getDefenderDisableCatchupFullScan() {
        return Optional.ofNullable(defenderDisableCatchupFullScan);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderDisableCatchupFullScan} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“This policy setting allows you to configure catch-up scans for scheduled full
     * scans. A catch-up scan is a scan that is initiated because a regularly scheduled
     * scan was missed. Usually these scheduled scans are missed because the computer
     * was turned off at the scheduled time.”</i>
     * 
     * @param defenderDisableCatchupFullScan
     *            new value of {@code defenderDisableCatchupFullScan} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderDisableCatchupFullScan} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderDisableCatchupFullScan(Boolean defenderDisableCatchupFullScan) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderDisableCatchupFullScan");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderDisableCatchupFullScan = defenderDisableCatchupFullScan;
        return _x;
    }

    /**
     * <i>“This policy setting allows you to configure catch-up scans for scheduled quick
     * scans. A catch-up scan is a scan that is initiated because a regularly scheduled
     * scan was missed. Usually these scheduled scans are missed because the computer
     * was turned off at the scheduled time.”</i>
     * 
     * @return property defenderDisableCatchupQuickScan
     */
    @Property(name="defenderDisableCatchupQuickScan")
    @JsonIgnore
    public Optional<Boolean> getDefenderDisableCatchupQuickScan() {
        return Optional.ofNullable(defenderDisableCatchupQuickScan);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderDisableCatchupQuickScan} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“This policy setting allows you to configure catch-up scans for scheduled quick
     * scans. A catch-up scan is a scan that is initiated because a regularly scheduled
     * scan was missed. Usually these scheduled scans are missed because the computer
     * was turned off at the scheduled time.”</i>
     * 
     * @param defenderDisableCatchupQuickScan
     *            new value of {@code defenderDisableCatchupQuickScan} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderDisableCatchupQuickScan} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderDisableCatchupQuickScan(Boolean defenderDisableCatchupQuickScan) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderDisableCatchupQuickScan");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderDisableCatchupQuickScan = defenderDisableCatchupQuickScan;
        return _x;
    }

    /**
     * <i>“To best protect your PC, Windows Defender will send information to Microsoft
     * about any problems it finds. Microsoft will analyze that information, learn more
     * about problems affecting you and other customers, and offer improved solutions.”</i>
     * 
     * @return property defenderDisableCloudProtection
     */
    @Property(name="defenderDisableCloudProtection")
    @JsonIgnore
    public Optional<Boolean> getDefenderDisableCloudProtection() {
        return Optional.ofNullable(defenderDisableCloudProtection);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderDisableCloudProtection} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“To best protect your PC, Windows Defender will send information to Microsoft
     * about any problems it finds. Microsoft will analyze that information, learn more
     * about problems affecting you and other customers, and offer improved solutions.”</i>
     * 
     * @param defenderDisableCloudProtection
     *            new value of {@code defenderDisableCloudProtection} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderDisableCloudProtection} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderDisableCloudProtection(Boolean defenderDisableCloudProtection) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderDisableCloudProtection");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderDisableCloudProtection = defenderDisableCloudProtection;
        return _x;
    }

    /**
     * <i>“Allows or disallows Windows Defender Intrusion Prevention functionality.”</i>
     * 
     * @return property defenderDisableIntrusionPreventionSystem
     */
    @Property(name="defenderDisableIntrusionPreventionSystem")
    @JsonIgnore
    public Optional<Boolean> getDefenderDisableIntrusionPreventionSystem() {
        return Optional.ofNullable(defenderDisableIntrusionPreventionSystem);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderDisableIntrusionPreventionSystem} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Allows or disallows Windows Defender Intrusion Prevention functionality.”</i>
     * 
     * @param defenderDisableIntrusionPreventionSystem
     *            new value of {@code defenderDisableIntrusionPreventionSystem} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderDisableIntrusionPreventionSystem} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderDisableIntrusionPreventionSystem(Boolean defenderDisableIntrusionPreventionSystem) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderDisableIntrusionPreventionSystem");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderDisableIntrusionPreventionSystem = defenderDisableIntrusionPreventionSystem;
        return _x;
    }

    /**
     * <i>“Allows or disallows Windows Defender On Access Protection functionality.”</i>
     * 
     * @return property defenderDisableOnAccessProtection
     */
    @Property(name="defenderDisableOnAccessProtection")
    @JsonIgnore
    public Optional<Boolean> getDefenderDisableOnAccessProtection() {
        return Optional.ofNullable(defenderDisableOnAccessProtection);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderDisableOnAccessProtection} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Allows or disallows Windows Defender On Access Protection functionality.”</i>
     * 
     * @param defenderDisableOnAccessProtection
     *            new value of {@code defenderDisableOnAccessProtection} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderDisableOnAccessProtection} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderDisableOnAccessProtection(Boolean defenderDisableOnAccessProtection) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderDisableOnAccessProtection");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderDisableOnAccessProtection = defenderDisableOnAccessProtection;
        return _x;
    }

    /**
     * <i>“Allows or disallows Windows Defender Realtime Monitoring functionality.”</i>
     * 
     * @return property defenderDisableRealTimeMonitoring
     */
    @Property(name="defenderDisableRealTimeMonitoring")
    @JsonIgnore
    public Optional<Boolean> getDefenderDisableRealTimeMonitoring() {
        return Optional.ofNullable(defenderDisableRealTimeMonitoring);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderDisableRealTimeMonitoring} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Allows or disallows Windows Defender Realtime Monitoring functionality.”</i>
     * 
     * @param defenderDisableRealTimeMonitoring
     *            new value of {@code defenderDisableRealTimeMonitoring} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderDisableRealTimeMonitoring} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderDisableRealTimeMonitoring(Boolean defenderDisableRealTimeMonitoring) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderDisableRealTimeMonitoring");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderDisableRealTimeMonitoring = defenderDisableRealTimeMonitoring;
        return _x;
    }

    /**
     * <i>“Allows or disallows scanning of archives.”</i>
     * 
     * @return property defenderDisableScanArchiveFiles
     */
    @Property(name="defenderDisableScanArchiveFiles")
    @JsonIgnore
    public Optional<Boolean> getDefenderDisableScanArchiveFiles() {
        return Optional.ofNullable(defenderDisableScanArchiveFiles);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderDisableScanArchiveFiles} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Allows or disallows scanning of archives.”</i>
     * 
     * @param defenderDisableScanArchiveFiles
     *            new value of {@code defenderDisableScanArchiveFiles} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderDisableScanArchiveFiles} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderDisableScanArchiveFiles(Boolean defenderDisableScanArchiveFiles) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderDisableScanArchiveFiles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderDisableScanArchiveFiles = defenderDisableScanArchiveFiles;
        return _x;
    }

    /**
     * <i>“Allows or disallows Windows Defender IOAVP Protection functionality.”</i>
     * 
     * @return property defenderDisableScanDownloads
     */
    @Property(name="defenderDisableScanDownloads")
    @JsonIgnore
    public Optional<Boolean> getDefenderDisableScanDownloads() {
        return Optional.ofNullable(defenderDisableScanDownloads);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderDisableScanDownloads} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Allows or disallows Windows Defender IOAVP Protection functionality.”</i>
     * 
     * @param defenderDisableScanDownloads
     *            new value of {@code defenderDisableScanDownloads} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderDisableScanDownloads} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderDisableScanDownloads(Boolean defenderDisableScanDownloads) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderDisableScanDownloads");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderDisableScanDownloads = defenderDisableScanDownloads;
        return _x;
    }

    /**
     * <i>“Allows or disallows a scanning of network files.”</i>
     * 
     * @return property defenderDisableScanNetworkFiles
     */
    @Property(name="defenderDisableScanNetworkFiles")
    @JsonIgnore
    public Optional<Boolean> getDefenderDisableScanNetworkFiles() {
        return Optional.ofNullable(defenderDisableScanNetworkFiles);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderDisableScanNetworkFiles} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Allows or disallows a scanning of network files.”</i>
     * 
     * @param defenderDisableScanNetworkFiles
     *            new value of {@code defenderDisableScanNetworkFiles} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderDisableScanNetworkFiles} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderDisableScanNetworkFiles(Boolean defenderDisableScanNetworkFiles) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderDisableScanNetworkFiles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderDisableScanNetworkFiles = defenderDisableScanNetworkFiles;
        return _x;
    }

    /**
     * <i>“Allows or disallows a full scan of removable drives. During a quick scan,
     * removable drives may still be scanned.”</i>
     * 
     * @return property defenderDisableScanRemovableDrivesDuringFullScan
     */
    @Property(name="defenderDisableScanRemovableDrivesDuringFullScan")
    @JsonIgnore
    public Optional<Boolean> getDefenderDisableScanRemovableDrivesDuringFullScan() {
        return Optional.ofNullable(defenderDisableScanRemovableDrivesDuringFullScan);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderDisableScanRemovableDrivesDuringFullScan} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Allows or disallows a full scan of removable drives. During a quick scan,
     * removable drives may still be scanned.”</i>
     * 
     * @param defenderDisableScanRemovableDrivesDuringFullScan
     *            new value of {@code defenderDisableScanRemovableDrivesDuringFullScan} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderDisableScanRemovableDrivesDuringFullScan} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderDisableScanRemovableDrivesDuringFullScan(Boolean defenderDisableScanRemovableDrivesDuringFullScan) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderDisableScanRemovableDrivesDuringFullScan");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderDisableScanRemovableDrivesDuringFullScan = defenderDisableScanRemovableDrivesDuringFullScan;
        return _x;
    }

    /**
     * <i>“Allows or disallows Windows Defender Script Scanning functionality.”</i>
     * 
     * @return property defenderDisableScanScriptsLoadedInInternetExplorer
     */
    @Property(name="defenderDisableScanScriptsLoadedInInternetExplorer")
    @JsonIgnore
    public Optional<Boolean> getDefenderDisableScanScriptsLoadedInInternetExplorer() {
        return Optional.ofNullable(defenderDisableScanScriptsLoadedInInternetExplorer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderDisableScanScriptsLoadedInInternetExplorer} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Allows or disallows Windows Defender Script Scanning functionality.”</i>
     * 
     * @param defenderDisableScanScriptsLoadedInInternetExplorer
     *            new value of {@code defenderDisableScanScriptsLoadedInInternetExplorer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderDisableScanScriptsLoadedInInternetExplorer} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderDisableScanScriptsLoadedInInternetExplorer(Boolean defenderDisableScanScriptsLoadedInInternetExplorer) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderDisableScanScriptsLoadedInInternetExplorer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderDisableScanScriptsLoadedInInternetExplorer = defenderDisableScanScriptsLoadedInInternetExplorer;
        return _x;
    }

    /**
     * <i>“Value indicating if execution of executable content (exe, dll, ps, js, vbs, etc)
     * should be dropped from email (webmail/mail-client)”</i>
     * 
     * @return property defenderEmailContentExecution
     */
    @Property(name="defenderEmailContentExecution")
    @JsonIgnore
    public Optional<DefenderProtectionType> getDefenderEmailContentExecution() {
        return Optional.ofNullable(defenderEmailContentExecution);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderEmailContentExecution} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Value indicating if execution of executable content (exe, dll, ps, js, vbs, etc)
     * should be dropped from email (webmail/mail-client)”</i>
     * 
     * @param defenderEmailContentExecution
     *            new value of {@code defenderEmailContentExecution} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderEmailContentExecution} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderEmailContentExecution(DefenderProtectionType defenderEmailContentExecution) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderEmailContentExecution");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderEmailContentExecution = defenderEmailContentExecution;
        return _x;
    }

    /**
     * <i>“Value indicating if execution of executable content (exe, dll, ps, js, vbs, etc)
     * should be dropped from email (webmail/mail-client)”</i>
     * 
     * @return property defenderEmailContentExecutionType
     */
    @Property(name="defenderEmailContentExecutionType")
    @JsonIgnore
    public Optional<DefenderAttackSurfaceType> getDefenderEmailContentExecutionType() {
        return Optional.ofNullable(defenderEmailContentExecutionType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderEmailContentExecutionType} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Value indicating if execution of executable content (exe, dll, ps, js, vbs, etc)
     * should be dropped from email (webmail/mail-client)”</i>
     * 
     * @param defenderEmailContentExecutionType
     *            new value of {@code defenderEmailContentExecutionType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderEmailContentExecutionType} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderEmailContentExecutionType(DefenderAttackSurfaceType defenderEmailContentExecutionType) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderEmailContentExecutionType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderEmailContentExecutionType = defenderEmailContentExecutionType;
        return _x;
    }

    /**
     * <i>“This policy setting allows you to enable or disable low CPU priority for
     * scheduled scans.”</i>
     * 
     * @return property defenderEnableLowCpuPriority
     */
    @Property(name="defenderEnableLowCpuPriority")
    @JsonIgnore
    public Optional<Boolean> getDefenderEnableLowCpuPriority() {
        return Optional.ofNullable(defenderEnableLowCpuPriority);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderEnableLowCpuPriority} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“This policy setting allows you to enable or disable low CPU priority for
     * scheduled scans.”</i>
     * 
     * @param defenderEnableLowCpuPriority
     *            new value of {@code defenderEnableLowCpuPriority} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderEnableLowCpuPriority} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderEnableLowCpuPriority(Boolean defenderEnableLowCpuPriority) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderEnableLowCpuPriority");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderEnableLowCpuPriority = defenderEnableLowCpuPriority;
        return _x;
    }

    /**
     * <i>“Allows or disallows scanning of email.”</i>
     * 
     * @return property defenderEnableScanIncomingMail
     */
    @Property(name="defenderEnableScanIncomingMail")
    @JsonIgnore
    public Optional<Boolean> getDefenderEnableScanIncomingMail() {
        return Optional.ofNullable(defenderEnableScanIncomingMail);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderEnableScanIncomingMail} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Allows or disallows scanning of email.”</i>
     * 
     * @param defenderEnableScanIncomingMail
     *            new value of {@code defenderEnableScanIncomingMail} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderEnableScanIncomingMail} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderEnableScanIncomingMail(Boolean defenderEnableScanIncomingMail) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderEnableScanIncomingMail");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderEnableScanIncomingMail = defenderEnableScanIncomingMail;
        return _x;
    }

    /**
     * <i>“Allows or disallows a full scan of mapped network drives.”</i>
     * 
     * @return property defenderEnableScanMappedNetworkDrivesDuringFullScan
     */
    @Property(name="defenderEnableScanMappedNetworkDrivesDuringFullScan")
    @JsonIgnore
    public Optional<Boolean> getDefenderEnableScanMappedNetworkDrivesDuringFullScan() {
        return Optional.ofNullable(defenderEnableScanMappedNetworkDrivesDuringFullScan);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderEnableScanMappedNetworkDrivesDuringFullScan} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Allows or disallows a full scan of mapped network drives.”</i>
     * 
     * @param defenderEnableScanMappedNetworkDrivesDuringFullScan
     *            new value of {@code defenderEnableScanMappedNetworkDrivesDuringFullScan} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderEnableScanMappedNetworkDrivesDuringFullScan} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderEnableScanMappedNetworkDrivesDuringFullScan(Boolean defenderEnableScanMappedNetworkDrivesDuringFullScan) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderEnableScanMappedNetworkDrivesDuringFullScan");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderEnableScanMappedNetworkDrivesDuringFullScan = defenderEnableScanMappedNetworkDrivesDuringFullScan;
        return _x;
    }

    /**
     * <i>“Xml content containing information regarding exploit protection details.”</i>
     * 
     * @return property defenderExploitProtectionXml
     */
    @Property(name="defenderExploitProtectionXml")
    @JsonIgnore
    public Optional<byte[]> getDefenderExploitProtectionXml() {
        return Optional.ofNullable(defenderExploitProtectionXml);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderExploitProtectionXml} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Xml content containing information regarding exploit protection details.”</i>
     * 
     * @param defenderExploitProtectionXml
     *            new value of {@code defenderExploitProtectionXml} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderExploitProtectionXml} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderExploitProtectionXml(byte[] defenderExploitProtectionXml) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderExploitProtectionXml");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderExploitProtectionXml = defenderExploitProtectionXml;
        return _x;
    }

    /**
     * <i>“Name of the file from which DefenderExploitProtectionXml was obtained.”</i>
     * 
     * @return property defenderExploitProtectionXmlFileName
     */
    @Property(name="defenderExploitProtectionXmlFileName")
    @JsonIgnore
    public Optional<String> getDefenderExploitProtectionXmlFileName() {
        return Optional.ofNullable(defenderExploitProtectionXmlFileName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderExploitProtectionXmlFileName} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Name of the file from which DefenderExploitProtectionXml was obtained.”</i>
     * 
     * @param defenderExploitProtectionXmlFileName
     *            new value of {@code defenderExploitProtectionXmlFileName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderExploitProtectionXmlFileName} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderExploitProtectionXmlFileName(String defenderExploitProtectionXmlFileName) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderExploitProtectionXmlFileName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderExploitProtectionXmlFileName = defenderExploitProtectionXmlFileName;
        return _x;
    }

    /**
     * <i>“File extensions to exclude from scans and real time protection.”</i>
     * 
     * @return property defenderFileExtensionsToExclude
     */
    @Property(name="defenderFileExtensionsToExclude")
    @JsonIgnore
    public CollectionPage<String> getDefenderFileExtensionsToExclude() {
        return new CollectionPage<String>(contextPath, String.class, this.defenderFileExtensionsToExclude, Optional.ofNullable(defenderFileExtensionsToExcludeNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderFileExtensionsToExclude} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“File extensions to exclude from scans and real time protection.”</i>
     * 
     * @param defenderFileExtensionsToExclude
     *            new value of {@code defenderFileExtensionsToExclude} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderFileExtensionsToExclude} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderFileExtensionsToExclude(List<String> defenderFileExtensionsToExclude) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderFileExtensionsToExclude");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderFileExtensionsToExclude = defenderFileExtensionsToExclude;
        return _x;
    }

    /**
     * <i>“File extensions to exclude from scans and real time protection.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property defenderFileExtensionsToExclude
     */
    @Property(name="defenderFileExtensionsToExclude")
    @JsonIgnore
    public CollectionPage<String> getDefenderFileExtensionsToExclude(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.defenderFileExtensionsToExclude, Optional.ofNullable(defenderFileExtensionsToExcludeNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Files and folder to exclude from scans and real time protection.”</i>
     * 
     * @return property defenderFilesAndFoldersToExclude
     */
    @Property(name="defenderFilesAndFoldersToExclude")
    @JsonIgnore
    public CollectionPage<String> getDefenderFilesAndFoldersToExclude() {
        return new CollectionPage<String>(contextPath, String.class, this.defenderFilesAndFoldersToExclude, Optional.ofNullable(defenderFilesAndFoldersToExcludeNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderFilesAndFoldersToExclude} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Files and folder to exclude from scans and real time protection.”</i>
     * 
     * @param defenderFilesAndFoldersToExclude
     *            new value of {@code defenderFilesAndFoldersToExclude} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderFilesAndFoldersToExclude} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderFilesAndFoldersToExclude(List<String> defenderFilesAndFoldersToExclude) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderFilesAndFoldersToExclude");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderFilesAndFoldersToExclude = defenderFilesAndFoldersToExclude;
        return _x;
    }

    /**
     * <i>“Files and folder to exclude from scans and real time protection.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property defenderFilesAndFoldersToExclude
     */
    @Property(name="defenderFilesAndFoldersToExclude")
    @JsonIgnore
    public CollectionPage<String> getDefenderFilesAndFoldersToExclude(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.defenderFilesAndFoldersToExclude, Optional.ofNullable(defenderFilesAndFoldersToExcludeNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“List of paths to exe that are allowed to access protected folders”</i>
     * 
     * @return property defenderGuardedFoldersAllowedAppPaths
     */
    @Property(name="defenderGuardedFoldersAllowedAppPaths")
    @JsonIgnore
    public CollectionPage<String> getDefenderGuardedFoldersAllowedAppPaths() {
        return new CollectionPage<String>(contextPath, String.class, this.defenderGuardedFoldersAllowedAppPaths, Optional.ofNullable(defenderGuardedFoldersAllowedAppPathsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderGuardedFoldersAllowedAppPaths} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“List of paths to exe that are allowed to access protected folders”</i>
     * 
     * @param defenderGuardedFoldersAllowedAppPaths
     *            new value of {@code defenderGuardedFoldersAllowedAppPaths} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderGuardedFoldersAllowedAppPaths} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderGuardedFoldersAllowedAppPaths(List<String> defenderGuardedFoldersAllowedAppPaths) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderGuardedFoldersAllowedAppPaths");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderGuardedFoldersAllowedAppPaths = defenderGuardedFoldersAllowedAppPaths;
        return _x;
    }

    /**
     * <i>“List of paths to exe that are allowed to access protected folders”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property defenderGuardedFoldersAllowedAppPaths
     */
    @Property(name="defenderGuardedFoldersAllowedAppPaths")
    @JsonIgnore
    public CollectionPage<String> getDefenderGuardedFoldersAllowedAppPaths(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.defenderGuardedFoldersAllowedAppPaths, Optional.ofNullable(defenderGuardedFoldersAllowedAppPathsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Value indicating the behavior of protected folders”</i>
     * 
     * @return property defenderGuardMyFoldersType
     */
    @Property(name="defenderGuardMyFoldersType")
    @JsonIgnore
    public Optional<FolderProtectionType> getDefenderGuardMyFoldersType() {
        return Optional.ofNullable(defenderGuardMyFoldersType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderGuardMyFoldersType} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Value indicating the behavior of protected folders”</i>
     * 
     * @param defenderGuardMyFoldersType
     *            new value of {@code defenderGuardMyFoldersType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderGuardMyFoldersType} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderGuardMyFoldersType(FolderProtectionType defenderGuardMyFoldersType) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderGuardMyFoldersType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderGuardMyFoldersType = defenderGuardMyFoldersType;
        return _x;
    }

    /**
     * <i>“Value indicating the behavior of NetworkProtection”</i>
     * 
     * @return property defenderNetworkProtectionType
     */
    @Property(name="defenderNetworkProtectionType")
    @JsonIgnore
    public Optional<DefenderProtectionType> getDefenderNetworkProtectionType() {
        return Optional.ofNullable(defenderNetworkProtectionType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderNetworkProtectionType} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Value indicating the behavior of NetworkProtection”</i>
     * 
     * @param defenderNetworkProtectionType
     *            new value of {@code defenderNetworkProtectionType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderNetworkProtectionType} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderNetworkProtectionType(DefenderProtectionType defenderNetworkProtectionType) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderNetworkProtectionType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderNetworkProtectionType = defenderNetworkProtectionType;
        return _x;
    }

    /**
     * <i>“Value indicating the behavior of Office applications/macros creating or
     * launching executable content”</i>
     * 
     * @return property defenderOfficeAppsExecutableContentCreationOrLaunch
     */
    @Property(name="defenderOfficeAppsExecutableContentCreationOrLaunch")
    @JsonIgnore
    public Optional<DefenderProtectionType> getDefenderOfficeAppsExecutableContentCreationOrLaunch() {
        return Optional.ofNullable(defenderOfficeAppsExecutableContentCreationOrLaunch);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderOfficeAppsExecutableContentCreationOrLaunch} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Value indicating the behavior of Office applications/macros creating or
     * launching executable content”</i>
     * 
     * @param defenderOfficeAppsExecutableContentCreationOrLaunch
     *            new value of {@code defenderOfficeAppsExecutableContentCreationOrLaunch} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderOfficeAppsExecutableContentCreationOrLaunch} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderOfficeAppsExecutableContentCreationOrLaunch(DefenderProtectionType defenderOfficeAppsExecutableContentCreationOrLaunch) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderOfficeAppsExecutableContentCreationOrLaunch");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderOfficeAppsExecutableContentCreationOrLaunch = defenderOfficeAppsExecutableContentCreationOrLaunch;
        return _x;
    }

    /**
     * <i>“Value indicating the behavior of Office applications/macros creating or
     * launching executable content”</i>
     * 
     * @return property defenderOfficeAppsExecutableContentCreationOrLaunchType
     */
    @Property(name="defenderOfficeAppsExecutableContentCreationOrLaunchType")
    @JsonIgnore
    public Optional<DefenderAttackSurfaceType> getDefenderOfficeAppsExecutableContentCreationOrLaunchType() {
        return Optional.ofNullable(defenderOfficeAppsExecutableContentCreationOrLaunchType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderOfficeAppsExecutableContentCreationOrLaunchType} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Value indicating the behavior of Office applications/macros creating or
     * launching executable content”</i>
     * 
     * @param defenderOfficeAppsExecutableContentCreationOrLaunchType
     *            new value of {@code defenderOfficeAppsExecutableContentCreationOrLaunchType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderOfficeAppsExecutableContentCreationOrLaunchType} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderOfficeAppsExecutableContentCreationOrLaunchType(DefenderAttackSurfaceType defenderOfficeAppsExecutableContentCreationOrLaunchType) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderOfficeAppsExecutableContentCreationOrLaunchType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderOfficeAppsExecutableContentCreationOrLaunchType = defenderOfficeAppsExecutableContentCreationOrLaunchType;
        return _x;
    }

    /**
     * <i>“Value indicating the behavior of Office application launching child processes”</i>
     * 
     * @return property defenderOfficeAppsLaunchChildProcess
     */
    @Property(name="defenderOfficeAppsLaunchChildProcess")
    @JsonIgnore
    public Optional<DefenderProtectionType> getDefenderOfficeAppsLaunchChildProcess() {
        return Optional.ofNullable(defenderOfficeAppsLaunchChildProcess);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderOfficeAppsLaunchChildProcess} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Value indicating the behavior of Office application launching child processes”</i>
     * 
     * @param defenderOfficeAppsLaunchChildProcess
     *            new value of {@code defenderOfficeAppsLaunchChildProcess} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderOfficeAppsLaunchChildProcess} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderOfficeAppsLaunchChildProcess(DefenderProtectionType defenderOfficeAppsLaunchChildProcess) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderOfficeAppsLaunchChildProcess");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderOfficeAppsLaunchChildProcess = defenderOfficeAppsLaunchChildProcess;
        return _x;
    }

    /**
     * <i>“Value indicating the behavior of Office application launching child processes”</i>
     * 
     * @return property defenderOfficeAppsLaunchChildProcessType
     */
    @Property(name="defenderOfficeAppsLaunchChildProcessType")
    @JsonIgnore
    public Optional<DefenderAttackSurfaceType> getDefenderOfficeAppsLaunchChildProcessType() {
        return Optional.ofNullable(defenderOfficeAppsLaunchChildProcessType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderOfficeAppsLaunchChildProcessType} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Value indicating the behavior of Office application launching child processes”</i>
     * 
     * @param defenderOfficeAppsLaunchChildProcessType
     *            new value of {@code defenderOfficeAppsLaunchChildProcessType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderOfficeAppsLaunchChildProcessType} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderOfficeAppsLaunchChildProcessType(DefenderAttackSurfaceType defenderOfficeAppsLaunchChildProcessType) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderOfficeAppsLaunchChildProcessType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderOfficeAppsLaunchChildProcessType = defenderOfficeAppsLaunchChildProcessType;
        return _x;
    }

    /**
     * <i>“Value indicating the behavior of  Office applications injecting into other
     * processes”</i>
     * 
     * @return property defenderOfficeAppsOtherProcessInjection
     */
    @Property(name="defenderOfficeAppsOtherProcessInjection")
    @JsonIgnore
    public Optional<DefenderProtectionType> getDefenderOfficeAppsOtherProcessInjection() {
        return Optional.ofNullable(defenderOfficeAppsOtherProcessInjection);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderOfficeAppsOtherProcessInjection} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Value indicating the behavior of  Office applications injecting into other
     * processes”</i>
     * 
     * @param defenderOfficeAppsOtherProcessInjection
     *            new value of {@code defenderOfficeAppsOtherProcessInjection} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderOfficeAppsOtherProcessInjection} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderOfficeAppsOtherProcessInjection(DefenderProtectionType defenderOfficeAppsOtherProcessInjection) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderOfficeAppsOtherProcessInjection");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderOfficeAppsOtherProcessInjection = defenderOfficeAppsOtherProcessInjection;
        return _x;
    }

    /**
     * <i>“Value indicating the behavior of Office applications injecting into other
     * processes”</i>
     * 
     * @return property defenderOfficeAppsOtherProcessInjectionType
     */
    @Property(name="defenderOfficeAppsOtherProcessInjectionType")
    @JsonIgnore
    public Optional<DefenderAttackSurfaceType> getDefenderOfficeAppsOtherProcessInjectionType() {
        return Optional.ofNullable(defenderOfficeAppsOtherProcessInjectionType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderOfficeAppsOtherProcessInjectionType} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Value indicating the behavior of Office applications injecting into other
     * processes”</i>
     * 
     * @param defenderOfficeAppsOtherProcessInjectionType
     *            new value of {@code defenderOfficeAppsOtherProcessInjectionType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderOfficeAppsOtherProcessInjectionType} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderOfficeAppsOtherProcessInjectionType(DefenderAttackSurfaceType defenderOfficeAppsOtherProcessInjectionType) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderOfficeAppsOtherProcessInjectionType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderOfficeAppsOtherProcessInjectionType = defenderOfficeAppsOtherProcessInjectionType;
        return _x;
    }

    /**
     * <i>“Value indicating the behavior of Office communication applications, including
     * Microsoft Outlook, from creating child processes”</i>
     * 
     * @return property defenderOfficeCommunicationAppsLaunchChildProcess
     */
    @Property(name="defenderOfficeCommunicationAppsLaunchChildProcess")
    @JsonIgnore
    public Optional<DefenderProtectionType> getDefenderOfficeCommunicationAppsLaunchChildProcess() {
        return Optional.ofNullable(defenderOfficeCommunicationAppsLaunchChildProcess);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderOfficeCommunicationAppsLaunchChildProcess} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Value indicating the behavior of Office communication applications, including
     * Microsoft Outlook, from creating child processes”</i>
     * 
     * @param defenderOfficeCommunicationAppsLaunchChildProcess
     *            new value of {@code defenderOfficeCommunicationAppsLaunchChildProcess} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderOfficeCommunicationAppsLaunchChildProcess} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderOfficeCommunicationAppsLaunchChildProcess(DefenderProtectionType defenderOfficeCommunicationAppsLaunchChildProcess) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderOfficeCommunicationAppsLaunchChildProcess");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderOfficeCommunicationAppsLaunchChildProcess = defenderOfficeCommunicationAppsLaunchChildProcess;
        return _x;
    }

    /**
     * <i>“Value indicating the behavior of Win32 imports from Macro code in Office”</i>
     * 
     * @return property defenderOfficeMacroCodeAllowWin32Imports
     */
    @Property(name="defenderOfficeMacroCodeAllowWin32Imports")
    @JsonIgnore
    public Optional<DefenderProtectionType> getDefenderOfficeMacroCodeAllowWin32Imports() {
        return Optional.ofNullable(defenderOfficeMacroCodeAllowWin32Imports);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderOfficeMacroCodeAllowWin32Imports} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Value indicating the behavior of Win32 imports from Macro code in Office”</i>
     * 
     * @param defenderOfficeMacroCodeAllowWin32Imports
     *            new value of {@code defenderOfficeMacroCodeAllowWin32Imports} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderOfficeMacroCodeAllowWin32Imports} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderOfficeMacroCodeAllowWin32Imports(DefenderProtectionType defenderOfficeMacroCodeAllowWin32Imports) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderOfficeMacroCodeAllowWin32Imports");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderOfficeMacroCodeAllowWin32Imports = defenderOfficeMacroCodeAllowWin32Imports;
        return _x;
    }

    /**
     * <i>“Value indicating the behavior of Win32 imports from Macro code in Office”</i>
     * 
     * @return property defenderOfficeMacroCodeAllowWin32ImportsType
     */
    @Property(name="defenderOfficeMacroCodeAllowWin32ImportsType")
    @JsonIgnore
    public Optional<DefenderAttackSurfaceType> getDefenderOfficeMacroCodeAllowWin32ImportsType() {
        return Optional.ofNullable(defenderOfficeMacroCodeAllowWin32ImportsType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderOfficeMacroCodeAllowWin32ImportsType} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Value indicating the behavior of Win32 imports from Macro code in Office”</i>
     * 
     * @param defenderOfficeMacroCodeAllowWin32ImportsType
     *            new value of {@code defenderOfficeMacroCodeAllowWin32ImportsType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderOfficeMacroCodeAllowWin32ImportsType} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderOfficeMacroCodeAllowWin32ImportsType(DefenderAttackSurfaceType defenderOfficeMacroCodeAllowWin32ImportsType) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderOfficeMacroCodeAllowWin32ImportsType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderOfficeMacroCodeAllowWin32ImportsType = defenderOfficeMacroCodeAllowWin32ImportsType;
        return _x;
    }

    /**
     * <i>“Added in Windows 10, version 1607. Specifies the level of detection for
     * potentially unwanted applications (PUAs). Windows Defender alerts you when
     * potentially unwanted software is being downloaded or attempts to install itself
     * on your computer.”</i>
     * 
     * @return property defenderPotentiallyUnwantedAppAction
     */
    @Property(name="defenderPotentiallyUnwantedAppAction")
    @JsonIgnore
    public Optional<DefenderProtectionType> getDefenderPotentiallyUnwantedAppAction() {
        return Optional.ofNullable(defenderPotentiallyUnwantedAppAction);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderPotentiallyUnwantedAppAction} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Added in Windows 10, version 1607. Specifies the level of detection for
     * potentially unwanted applications (PUAs). Windows Defender alerts you when
     * potentially unwanted software is being downloaded or attempts to install itself
     * on your computer.”</i>
     * 
     * @param defenderPotentiallyUnwantedAppAction
     *            new value of {@code defenderPotentiallyUnwantedAppAction} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderPotentiallyUnwantedAppAction} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderPotentiallyUnwantedAppAction(DefenderProtectionType defenderPotentiallyUnwantedAppAction) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderPotentiallyUnwantedAppAction");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderPotentiallyUnwantedAppAction = defenderPotentiallyUnwantedAppAction;
        return _x;
    }

    /**
     * <i>“Value indicating if credential stealing from the Windows local security
     * authority subsystem is permitted”</i>
     * 
     * @return property defenderPreventCredentialStealingType
     */
    @Property(name="defenderPreventCredentialStealingType")
    @JsonIgnore
    public Optional<DefenderProtectionType> getDefenderPreventCredentialStealingType() {
        return Optional.ofNullable(defenderPreventCredentialStealingType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderPreventCredentialStealingType} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Value indicating if credential stealing from the Windows local security
     * authority subsystem is permitted”</i>
     * 
     * @param defenderPreventCredentialStealingType
     *            new value of {@code defenderPreventCredentialStealingType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderPreventCredentialStealingType} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderPreventCredentialStealingType(DefenderProtectionType defenderPreventCredentialStealingType) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderPreventCredentialStealingType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderPreventCredentialStealingType = defenderPreventCredentialStealingType;
        return _x;
    }

    /**
     * <i>“Value indicating response to process creations originating from PSExec and WMI
     * commands”</i>
     * 
     * @return property defenderProcessCreation
     */
    @Property(name="defenderProcessCreation")
    @JsonIgnore
    public Optional<DefenderProtectionType> getDefenderProcessCreation() {
        return Optional.ofNullable(defenderProcessCreation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderProcessCreation} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Value indicating response to process creations originating from PSExec and WMI
     * commands”</i>
     * 
     * @param defenderProcessCreation
     *            new value of {@code defenderProcessCreation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderProcessCreation} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderProcessCreation(DefenderProtectionType defenderProcessCreation) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderProcessCreation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderProcessCreation = defenderProcessCreation;
        return _x;
    }

    /**
     * <i>“Value indicating response to process creations originating from PSExec and WMI
     * commands”</i>
     * 
     * @return property defenderProcessCreationType
     */
    @Property(name="defenderProcessCreationType")
    @JsonIgnore
    public Optional<DefenderAttackSurfaceType> getDefenderProcessCreationType() {
        return Optional.ofNullable(defenderProcessCreationType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderProcessCreationType} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Value indicating response to process creations originating from PSExec and WMI
     * commands”</i>
     * 
     * @param defenderProcessCreationType
     *            new value of {@code defenderProcessCreationType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderProcessCreationType} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderProcessCreationType(DefenderAttackSurfaceType defenderProcessCreationType) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderProcessCreationType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderProcessCreationType = defenderProcessCreationType;
        return _x;
    }

    /**
     * <i>“Processes to exclude from scans and real time protection.”</i>
     * 
     * @return property defenderProcessesToExclude
     */
    @Property(name="defenderProcessesToExclude")
    @JsonIgnore
    public CollectionPage<String> getDefenderProcessesToExclude() {
        return new CollectionPage<String>(contextPath, String.class, this.defenderProcessesToExclude, Optional.ofNullable(defenderProcessesToExcludeNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderProcessesToExclude} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Processes to exclude from scans and real time protection.”</i>
     * 
     * @param defenderProcessesToExclude
     *            new value of {@code defenderProcessesToExclude} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderProcessesToExclude} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderProcessesToExclude(List<String> defenderProcessesToExclude) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderProcessesToExclude");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderProcessesToExclude = defenderProcessesToExclude;
        return _x;
    }

    /**
     * <i>“Processes to exclude from scans and real time protection.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property defenderProcessesToExclude
     */
    @Property(name="defenderProcessesToExclude")
    @JsonIgnore
    public CollectionPage<String> getDefenderProcessesToExclude(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.defenderProcessesToExclude, Optional.ofNullable(defenderProcessesToExcludeNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Controls which sets of files should be monitored.”</i>
     * 
     * @return property defenderScanDirection
     */
    @Property(name="defenderScanDirection")
    @JsonIgnore
    public Optional<DefenderRealtimeScanDirection> getDefenderScanDirection() {
        return Optional.ofNullable(defenderScanDirection);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderScanDirection} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Controls which sets of files should be monitored.”</i>
     * 
     * @param defenderScanDirection
     *            new value of {@code defenderScanDirection} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderScanDirection} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderScanDirection(DefenderRealtimeScanDirection defenderScanDirection) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderScanDirection");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderScanDirection = defenderScanDirection;
        return _x;
    }

    /**
     * <i>“Represents the average CPU load factor for the Windows Defender scan (in percent
     * ). The default value is 50. Valid values 0 to 100”</i>
     * 
     * @return property defenderScanMaxCpuPercentage
     */
    @Property(name="defenderScanMaxCpuPercentage")
    @JsonIgnore
    public Optional<Integer> getDefenderScanMaxCpuPercentage() {
        return Optional.ofNullable(defenderScanMaxCpuPercentage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderScanMaxCpuPercentage} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Represents the average CPU load factor for the Windows Defender scan (in percent
     * ). The default value is 50. Valid values 0 to 100”</i>
     * 
     * @param defenderScanMaxCpuPercentage
     *            new value of {@code defenderScanMaxCpuPercentage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderScanMaxCpuPercentage} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderScanMaxCpuPercentage(Integer defenderScanMaxCpuPercentage) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderScanMaxCpuPercentage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderScanMaxCpuPercentage = defenderScanMaxCpuPercentage;
        return _x;
    }

    /**
     * <i>“Selects whether to perform a quick scan or full scan.”</i>
     * 
     * @return property defenderScanType
     */
    @Property(name="defenderScanType")
    @JsonIgnore
    public Optional<DefenderScanType> getDefenderScanType() {
        return Optional.ofNullable(defenderScanType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code defenderScanType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Selects whether to perform a quick scan or full scan.”</i>
     * 
     * @param defenderScanType
     *            new value of {@code defenderScanType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderScanType} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderScanType(DefenderScanType defenderScanType) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderScanType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderScanType = defenderScanType;
        return _x;
    }

    /**
     * <i>“Selects the time of day that the Windows Defender quick scan should run. For
     * example, a value of 0=12:00AM, a value of 60=1:00AM, a value of 120=2:00, and so
     * on, up to a value of 1380=11:00PM. The default value is 120”</i>
     * 
     * @return property defenderScheduledQuickScanTime
     */
    @Property(name="defenderScheduledQuickScanTime")
    @JsonIgnore
    public Optional<LocalTime> getDefenderScheduledQuickScanTime() {
        return Optional.ofNullable(defenderScheduledQuickScanTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderScheduledQuickScanTime} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Selects the time of day that the Windows Defender quick scan should run. For
     * example, a value of 0=12:00AM, a value of 60=1:00AM, a value of 120=2:00, and so
     * on, up to a value of 1380=11:00PM. The default value is 120”</i>
     * 
     * @param defenderScheduledQuickScanTime
     *            new value of {@code defenderScheduledQuickScanTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderScheduledQuickScanTime} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderScheduledQuickScanTime(LocalTime defenderScheduledQuickScanTime) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderScheduledQuickScanTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderScheduledQuickScanTime = defenderScheduledQuickScanTime;
        return _x;
    }

    /**
     * <i>“Selects the day that the Windows Defender scan should run.”</i>
     * 
     * @return property defenderScheduledScanDay
     */
    @Property(name="defenderScheduledScanDay")
    @JsonIgnore
    public Optional<WeeklySchedule> getDefenderScheduledScanDay() {
        return Optional.ofNullable(defenderScheduledScanDay);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderScheduledScanDay} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Selects the day that the Windows Defender scan should run.”</i>
     * 
     * @param defenderScheduledScanDay
     *            new value of {@code defenderScheduledScanDay} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderScheduledScanDay} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderScheduledScanDay(WeeklySchedule defenderScheduledScanDay) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderScheduledScanDay");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderScheduledScanDay = defenderScheduledScanDay;
        return _x;
    }

    /**
     * <i>“Selects the time of day that the Windows Defender scan should run.”</i>
     * 
     * @return property defenderScheduledScanTime
     */
    @Property(name="defenderScheduledScanTime")
    @JsonIgnore
    public Optional<LocalTime> getDefenderScheduledScanTime() {
        return Optional.ofNullable(defenderScheduledScanTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderScheduledScanTime} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Selects the time of day that the Windows Defender scan should run.”</i>
     * 
     * @param defenderScheduledScanTime
     *            new value of {@code defenderScheduledScanTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderScheduledScanTime} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderScheduledScanTime(LocalTime defenderScheduledScanTime) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderScheduledScanTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderScheduledScanTime = defenderScheduledScanTime;
        return _x;
    }

    /**
     * <i>“Value indicating the behavior of js/vbs executing payload downloaded from
     * Internet”</i>
     * 
     * @return property defenderScriptDownloadedPayloadExecution
     */
    @Property(name="defenderScriptDownloadedPayloadExecution")
    @JsonIgnore
    public Optional<DefenderProtectionType> getDefenderScriptDownloadedPayloadExecution() {
        return Optional.ofNullable(defenderScriptDownloadedPayloadExecution);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderScriptDownloadedPayloadExecution} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Value indicating the behavior of js/vbs executing payload downloaded from
     * Internet”</i>
     * 
     * @param defenderScriptDownloadedPayloadExecution
     *            new value of {@code defenderScriptDownloadedPayloadExecution} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderScriptDownloadedPayloadExecution} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderScriptDownloadedPayloadExecution(DefenderProtectionType defenderScriptDownloadedPayloadExecution) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderScriptDownloadedPayloadExecution");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderScriptDownloadedPayloadExecution = defenderScriptDownloadedPayloadExecution;
        return _x;
    }

    /**
     * <i>“Value indicating the behavior of js/vbs executing payload downloaded from
     * Internet”</i>
     * 
     * @return property defenderScriptDownloadedPayloadExecutionType
     */
    @Property(name="defenderScriptDownloadedPayloadExecutionType")
    @JsonIgnore
    public Optional<DefenderAttackSurfaceType> getDefenderScriptDownloadedPayloadExecutionType() {
        return Optional.ofNullable(defenderScriptDownloadedPayloadExecutionType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderScriptDownloadedPayloadExecutionType} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Value indicating the behavior of js/vbs executing payload downloaded from
     * Internet”</i>
     * 
     * @param defenderScriptDownloadedPayloadExecutionType
     *            new value of {@code defenderScriptDownloadedPayloadExecutionType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderScriptDownloadedPayloadExecutionType} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderScriptDownloadedPayloadExecutionType(DefenderAttackSurfaceType defenderScriptDownloadedPayloadExecutionType) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderScriptDownloadedPayloadExecutionType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderScriptDownloadedPayloadExecutionType = defenderScriptDownloadedPayloadExecutionType;
        return _x;
    }

    /**
     * <i>“Value indicating the behavior of obfuscated js/vbs/ps/macro code”</i>
     * 
     * @return property defenderScriptObfuscatedMacroCode
     */
    @Property(name="defenderScriptObfuscatedMacroCode")
    @JsonIgnore
    public Optional<DefenderProtectionType> getDefenderScriptObfuscatedMacroCode() {
        return Optional.ofNullable(defenderScriptObfuscatedMacroCode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderScriptObfuscatedMacroCode} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Value indicating the behavior of obfuscated js/vbs/ps/macro code”</i>
     * 
     * @param defenderScriptObfuscatedMacroCode
     *            new value of {@code defenderScriptObfuscatedMacroCode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderScriptObfuscatedMacroCode} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderScriptObfuscatedMacroCode(DefenderProtectionType defenderScriptObfuscatedMacroCode) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderScriptObfuscatedMacroCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderScriptObfuscatedMacroCode = defenderScriptObfuscatedMacroCode;
        return _x;
    }

    /**
     * <i>“Value indicating the behavior of obfuscated js/vbs/ps/macro code”</i>
     * 
     * @return property defenderScriptObfuscatedMacroCodeType
     */
    @Property(name="defenderScriptObfuscatedMacroCodeType")
    @JsonIgnore
    public Optional<DefenderAttackSurfaceType> getDefenderScriptObfuscatedMacroCodeType() {
        return Optional.ofNullable(defenderScriptObfuscatedMacroCodeType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderScriptObfuscatedMacroCodeType} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Value indicating the behavior of obfuscated js/vbs/ps/macro code”</i>
     * 
     * @param defenderScriptObfuscatedMacroCodeType
     *            new value of {@code defenderScriptObfuscatedMacroCodeType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderScriptObfuscatedMacroCodeType} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderScriptObfuscatedMacroCodeType(DefenderAttackSurfaceType defenderScriptObfuscatedMacroCodeType) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderScriptObfuscatedMacroCodeType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderScriptObfuscatedMacroCodeType = defenderScriptObfuscatedMacroCodeType;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block user from overriding Exploit Protection
     * settings.”</i>
     * 
     * @return property defenderSecurityCenterBlockExploitProtectionOverride
     */
    @Property(name="defenderSecurityCenterBlockExploitProtectionOverride")
    @JsonIgnore
    public Optional<Boolean> getDefenderSecurityCenterBlockExploitProtectionOverride() {
        return Optional.ofNullable(defenderSecurityCenterBlockExploitProtectionOverride);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderSecurityCenterBlockExploitProtectionOverride} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block user from overriding Exploit Protection
     * settings.”</i>
     * 
     * @param defenderSecurityCenterBlockExploitProtectionOverride
     *            new value of {@code defenderSecurityCenterBlockExploitProtectionOverride} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderSecurityCenterBlockExploitProtectionOverride} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderSecurityCenterBlockExploitProtectionOverride(Boolean defenderSecurityCenterBlockExploitProtectionOverride) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderSecurityCenterBlockExploitProtectionOverride");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderSecurityCenterBlockExploitProtectionOverride = defenderSecurityCenterBlockExploitProtectionOverride;
        return _x;
    }

    /**
     * <i>“Used to disable the display of the account protection area.”</i>
     * 
     * @return property defenderSecurityCenterDisableAccountUI
     */
    @Property(name="defenderSecurityCenterDisableAccountUI")
    @JsonIgnore
    public Optional<Boolean> getDefenderSecurityCenterDisableAccountUI() {
        return Optional.ofNullable(defenderSecurityCenterDisableAccountUI);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderSecurityCenterDisableAccountUI} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Used to disable the display of the account protection area.”</i>
     * 
     * @param defenderSecurityCenterDisableAccountUI
     *            new value of {@code defenderSecurityCenterDisableAccountUI} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderSecurityCenterDisableAccountUI} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderSecurityCenterDisableAccountUI(Boolean defenderSecurityCenterDisableAccountUI) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderSecurityCenterDisableAccountUI");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderSecurityCenterDisableAccountUI = defenderSecurityCenterDisableAccountUI;
        return _x;
    }

    /**
     * <i>“Used to disable the display of the app and browser protection area.”</i>
     * 
     * @return property defenderSecurityCenterDisableAppBrowserUI
     */
    @Property(name="defenderSecurityCenterDisableAppBrowserUI")
    @JsonIgnore
    public Optional<Boolean> getDefenderSecurityCenterDisableAppBrowserUI() {
        return Optional.ofNullable(defenderSecurityCenterDisableAppBrowserUI);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderSecurityCenterDisableAppBrowserUI} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Used to disable the display of the app and browser protection area.”</i>
     * 
     * @param defenderSecurityCenterDisableAppBrowserUI
     *            new value of {@code defenderSecurityCenterDisableAppBrowserUI} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderSecurityCenterDisableAppBrowserUI} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderSecurityCenterDisableAppBrowserUI(Boolean defenderSecurityCenterDisableAppBrowserUI) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderSecurityCenterDisableAppBrowserUI");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderSecurityCenterDisableAppBrowserUI = defenderSecurityCenterDisableAppBrowserUI;
        return _x;
    }

    /**
     * <i>“Used to disable the display of the Clear TPM button.”</i>
     * 
     * @return property defenderSecurityCenterDisableClearTpmUI
     */
    @Property(name="defenderSecurityCenterDisableClearTpmUI")
    @JsonIgnore
    public Optional<Boolean> getDefenderSecurityCenterDisableClearTpmUI() {
        return Optional.ofNullable(defenderSecurityCenterDisableClearTpmUI);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderSecurityCenterDisableClearTpmUI} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Used to disable the display of the Clear TPM button.”</i>
     * 
     * @param defenderSecurityCenterDisableClearTpmUI
     *            new value of {@code defenderSecurityCenterDisableClearTpmUI} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderSecurityCenterDisableClearTpmUI} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderSecurityCenterDisableClearTpmUI(Boolean defenderSecurityCenterDisableClearTpmUI) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderSecurityCenterDisableClearTpmUI");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderSecurityCenterDisableClearTpmUI = defenderSecurityCenterDisableClearTpmUI;
        return _x;
    }

    /**
     * <i>“Used to disable the display of the family options area.”</i>
     * 
     * @return property defenderSecurityCenterDisableFamilyUI
     */
    @Property(name="defenderSecurityCenterDisableFamilyUI")
    @JsonIgnore
    public Optional<Boolean> getDefenderSecurityCenterDisableFamilyUI() {
        return Optional.ofNullable(defenderSecurityCenterDisableFamilyUI);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderSecurityCenterDisableFamilyUI} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Used to disable the display of the family options area.”</i>
     * 
     * @param defenderSecurityCenterDisableFamilyUI
     *            new value of {@code defenderSecurityCenterDisableFamilyUI} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderSecurityCenterDisableFamilyUI} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderSecurityCenterDisableFamilyUI(Boolean defenderSecurityCenterDisableFamilyUI) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderSecurityCenterDisableFamilyUI");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderSecurityCenterDisableFamilyUI = defenderSecurityCenterDisableFamilyUI;
        return _x;
    }

    /**
     * <i>“Used to disable the display of the hardware protection area.”</i>
     * 
     * @return property defenderSecurityCenterDisableHardwareUI
     */
    @Property(name="defenderSecurityCenterDisableHardwareUI")
    @JsonIgnore
    public Optional<Boolean> getDefenderSecurityCenterDisableHardwareUI() {
        return Optional.ofNullable(defenderSecurityCenterDisableHardwareUI);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderSecurityCenterDisableHardwareUI} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Used to disable the display of the hardware protection area.”</i>
     * 
     * @param defenderSecurityCenterDisableHardwareUI
     *            new value of {@code defenderSecurityCenterDisableHardwareUI} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderSecurityCenterDisableHardwareUI} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderSecurityCenterDisableHardwareUI(Boolean defenderSecurityCenterDisableHardwareUI) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderSecurityCenterDisableHardwareUI");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderSecurityCenterDisableHardwareUI = defenderSecurityCenterDisableHardwareUI;
        return _x;
    }

    /**
     * <i>“Used to disable the display of the device performance and health area.”</i>
     * 
     * @return property defenderSecurityCenterDisableHealthUI
     */
    @Property(name="defenderSecurityCenterDisableHealthUI")
    @JsonIgnore
    public Optional<Boolean> getDefenderSecurityCenterDisableHealthUI() {
        return Optional.ofNullable(defenderSecurityCenterDisableHealthUI);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderSecurityCenterDisableHealthUI} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Used to disable the display of the device performance and health area.”</i>
     * 
     * @param defenderSecurityCenterDisableHealthUI
     *            new value of {@code defenderSecurityCenterDisableHealthUI} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderSecurityCenterDisableHealthUI} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderSecurityCenterDisableHealthUI(Boolean defenderSecurityCenterDisableHealthUI) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderSecurityCenterDisableHealthUI");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderSecurityCenterDisableHealthUI = defenderSecurityCenterDisableHealthUI;
        return _x;
    }

    /**
     * <i>“Used to disable the display of the firewall and network protection area.”</i>
     * 
     * @return property defenderSecurityCenterDisableNetworkUI
     */
    @Property(name="defenderSecurityCenterDisableNetworkUI")
    @JsonIgnore
    public Optional<Boolean> getDefenderSecurityCenterDisableNetworkUI() {
        return Optional.ofNullable(defenderSecurityCenterDisableNetworkUI);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderSecurityCenterDisableNetworkUI} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Used to disable the display of the firewall and network protection area.”</i>
     * 
     * @param defenderSecurityCenterDisableNetworkUI
     *            new value of {@code defenderSecurityCenterDisableNetworkUI} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderSecurityCenterDisableNetworkUI} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderSecurityCenterDisableNetworkUI(Boolean defenderSecurityCenterDisableNetworkUI) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderSecurityCenterDisableNetworkUI");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderSecurityCenterDisableNetworkUI = defenderSecurityCenterDisableNetworkUI;
        return _x;
    }

    /**
     * <i>“Used to disable the display of the notification area control. The user needs to
     * either sign out and sign in or reboot the computer for this setting to take
     * effect.”</i>
     * 
     * @return property defenderSecurityCenterDisableNotificationAreaUI
     */
    @Property(name="defenderSecurityCenterDisableNotificationAreaUI")
    @JsonIgnore
    public Optional<Boolean> getDefenderSecurityCenterDisableNotificationAreaUI() {
        return Optional.ofNullable(defenderSecurityCenterDisableNotificationAreaUI);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderSecurityCenterDisableNotificationAreaUI} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Used to disable the display of the notification area control. The user needs to
     * either sign out and sign in or reboot the computer for this setting to take
     * effect.”</i>
     * 
     * @param defenderSecurityCenterDisableNotificationAreaUI
     *            new value of {@code defenderSecurityCenterDisableNotificationAreaUI} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderSecurityCenterDisableNotificationAreaUI} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderSecurityCenterDisableNotificationAreaUI(Boolean defenderSecurityCenterDisableNotificationAreaUI) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderSecurityCenterDisableNotificationAreaUI");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderSecurityCenterDisableNotificationAreaUI = defenderSecurityCenterDisableNotificationAreaUI;
        return _x;
    }

    /**
     * <i>“Used to disable the display of the ransomware protection area.”</i>
     * 
     * @return property defenderSecurityCenterDisableRansomwareUI
     */
    @Property(name="defenderSecurityCenterDisableRansomwareUI")
    @JsonIgnore
    public Optional<Boolean> getDefenderSecurityCenterDisableRansomwareUI() {
        return Optional.ofNullable(defenderSecurityCenterDisableRansomwareUI);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderSecurityCenterDisableRansomwareUI} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Used to disable the display of the ransomware protection area.”</i>
     * 
     * @param defenderSecurityCenterDisableRansomwareUI
     *            new value of {@code defenderSecurityCenterDisableRansomwareUI} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderSecurityCenterDisableRansomwareUI} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderSecurityCenterDisableRansomwareUI(Boolean defenderSecurityCenterDisableRansomwareUI) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderSecurityCenterDisableRansomwareUI");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderSecurityCenterDisableRansomwareUI = defenderSecurityCenterDisableRansomwareUI;
        return _x;
    }

    /**
     * <i>“Used to disable the display of the secure boot area under Device security.”</i>
     * 
     * @return property defenderSecurityCenterDisableSecureBootUI
     */
    @Property(name="defenderSecurityCenterDisableSecureBootUI")
    @JsonIgnore
    public Optional<Boolean> getDefenderSecurityCenterDisableSecureBootUI() {
        return Optional.ofNullable(defenderSecurityCenterDisableSecureBootUI);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderSecurityCenterDisableSecureBootUI} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Used to disable the display of the secure boot area under Device security.”</i>
     * 
     * @param defenderSecurityCenterDisableSecureBootUI
     *            new value of {@code defenderSecurityCenterDisableSecureBootUI} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderSecurityCenterDisableSecureBootUI} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderSecurityCenterDisableSecureBootUI(Boolean defenderSecurityCenterDisableSecureBootUI) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderSecurityCenterDisableSecureBootUI");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderSecurityCenterDisableSecureBootUI = defenderSecurityCenterDisableSecureBootUI;
        return _x;
    }

    /**
     * <i>“Used to disable the display of the security process troubleshooting under Device
     * security.”</i>
     * 
     * @return property defenderSecurityCenterDisableTroubleshootingUI
     */
    @Property(name="defenderSecurityCenterDisableTroubleshootingUI")
    @JsonIgnore
    public Optional<Boolean> getDefenderSecurityCenterDisableTroubleshootingUI() {
        return Optional.ofNullable(defenderSecurityCenterDisableTroubleshootingUI);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderSecurityCenterDisableTroubleshootingUI} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Used to disable the display of the security process troubleshooting under Device
     * security.”</i>
     * 
     * @param defenderSecurityCenterDisableTroubleshootingUI
     *            new value of {@code defenderSecurityCenterDisableTroubleshootingUI} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderSecurityCenterDisableTroubleshootingUI} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderSecurityCenterDisableTroubleshootingUI(Boolean defenderSecurityCenterDisableTroubleshootingUI) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderSecurityCenterDisableTroubleshootingUI");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderSecurityCenterDisableTroubleshootingUI = defenderSecurityCenterDisableTroubleshootingUI;
        return _x;
    }

    /**
     * <i>“Used to disable the display of the virus and threat protection area.”</i>
     * 
     * @return property defenderSecurityCenterDisableVirusUI
     */
    @Property(name="defenderSecurityCenterDisableVirusUI")
    @JsonIgnore
    public Optional<Boolean> getDefenderSecurityCenterDisableVirusUI() {
        return Optional.ofNullable(defenderSecurityCenterDisableVirusUI);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderSecurityCenterDisableVirusUI} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Used to disable the display of the virus and threat protection area.”</i>
     * 
     * @param defenderSecurityCenterDisableVirusUI
     *            new value of {@code defenderSecurityCenterDisableVirusUI} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderSecurityCenterDisableVirusUI} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderSecurityCenterDisableVirusUI(Boolean defenderSecurityCenterDisableVirusUI) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderSecurityCenterDisableVirusUI");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderSecurityCenterDisableVirusUI = defenderSecurityCenterDisableVirusUI;
        return _x;
    }

    /**
     * <i>“Used to disable the display of update TPM Firmware when a vulnerable firmware is
     * detected.”</i>
     * 
     * @return property defenderSecurityCenterDisableVulnerableTpmFirmwareUpdateUI
     */
    @Property(name="defenderSecurityCenterDisableVulnerableTpmFirmwareUpdateUI")
    @JsonIgnore
    public Optional<Boolean> getDefenderSecurityCenterDisableVulnerableTpmFirmwareUpdateUI() {
        return Optional.ofNullable(defenderSecurityCenterDisableVulnerableTpmFirmwareUpdateUI);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderSecurityCenterDisableVulnerableTpmFirmwareUpdateUI} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Used to disable the display of update TPM Firmware when a vulnerable firmware is
     * detected.”</i>
     * 
     * @param defenderSecurityCenterDisableVulnerableTpmFirmwareUpdateUI
     *            new value of {@code defenderSecurityCenterDisableVulnerableTpmFirmwareUpdateUI} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderSecurityCenterDisableVulnerableTpmFirmwareUpdateUI} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderSecurityCenterDisableVulnerableTpmFirmwareUpdateUI(Boolean defenderSecurityCenterDisableVulnerableTpmFirmwareUpdateUI) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderSecurityCenterDisableVulnerableTpmFirmwareUpdateUI");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderSecurityCenterDisableVulnerableTpmFirmwareUpdateUI = defenderSecurityCenterDisableVulnerableTpmFirmwareUpdateUI;
        return _x;
    }

    /**
     * <i>“The email address that is displayed to users.”</i>
     * 
     * @return property defenderSecurityCenterHelpEmail
     */
    @Property(name="defenderSecurityCenterHelpEmail")
    @JsonIgnore
    public Optional<String> getDefenderSecurityCenterHelpEmail() {
        return Optional.ofNullable(defenderSecurityCenterHelpEmail);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderSecurityCenterHelpEmail} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The email address that is displayed to users.”</i>
     * 
     * @param defenderSecurityCenterHelpEmail
     *            new value of {@code defenderSecurityCenterHelpEmail} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderSecurityCenterHelpEmail} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderSecurityCenterHelpEmail(String defenderSecurityCenterHelpEmail) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderSecurityCenterHelpEmail");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderSecurityCenterHelpEmail = defenderSecurityCenterHelpEmail;
        return _x;
    }

    /**
     * <i>“The phone number or Skype ID that is displayed to users.”</i>
     * 
     * @return property defenderSecurityCenterHelpPhone
     */
    @Property(name="defenderSecurityCenterHelpPhone")
    @JsonIgnore
    public Optional<String> getDefenderSecurityCenterHelpPhone() {
        return Optional.ofNullable(defenderSecurityCenterHelpPhone);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderSecurityCenterHelpPhone} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The phone number or Skype ID that is displayed to users.”</i>
     * 
     * @param defenderSecurityCenterHelpPhone
     *            new value of {@code defenderSecurityCenterHelpPhone} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderSecurityCenterHelpPhone} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderSecurityCenterHelpPhone(String defenderSecurityCenterHelpPhone) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderSecurityCenterHelpPhone");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderSecurityCenterHelpPhone = defenderSecurityCenterHelpPhone;
        return _x;
    }

    /**
     * <i>“The help portal URL this is displayed to users.”</i>
     * 
     * @return property defenderSecurityCenterHelpURL
     */
    @Property(name="defenderSecurityCenterHelpURL")
    @JsonIgnore
    public Optional<String> getDefenderSecurityCenterHelpURL() {
        return Optional.ofNullable(defenderSecurityCenterHelpURL);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderSecurityCenterHelpURL} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The help portal URL this is displayed to users.”</i>
     * 
     * @param defenderSecurityCenterHelpURL
     *            new value of {@code defenderSecurityCenterHelpURL} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderSecurityCenterHelpURL} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderSecurityCenterHelpURL(String defenderSecurityCenterHelpURL) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderSecurityCenterHelpURL");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderSecurityCenterHelpURL = defenderSecurityCenterHelpURL;
        return _x;
    }

    /**
     * <i>“Configure where to display IT contact information to end users.”</i>
     * 
     * @return property defenderSecurityCenterITContactDisplay
     */
    @Property(name="defenderSecurityCenterITContactDisplay")
    @JsonIgnore
    public Optional<DefenderSecurityCenterITContactDisplayType> getDefenderSecurityCenterITContactDisplay() {
        return Optional.ofNullable(defenderSecurityCenterITContactDisplay);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderSecurityCenterITContactDisplay} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Configure where to display IT contact information to end users.”</i>
     * 
     * @param defenderSecurityCenterITContactDisplay
     *            new value of {@code defenderSecurityCenterITContactDisplay} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderSecurityCenterITContactDisplay} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderSecurityCenterITContactDisplay(DefenderSecurityCenterITContactDisplayType defenderSecurityCenterITContactDisplay) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderSecurityCenterITContactDisplay");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderSecurityCenterITContactDisplay = defenderSecurityCenterITContactDisplay;
        return _x;
    }

    /**
     * <i>“Notifications to show from the displayed areas of app”</i>
     * 
     * @return property defenderSecurityCenterNotificationsFromApp
     */
    @Property(name="defenderSecurityCenterNotificationsFromApp")
    @JsonIgnore
    public Optional<DefenderSecurityCenterNotificationsFromAppType> getDefenderSecurityCenterNotificationsFromApp() {
        return Optional.ofNullable(defenderSecurityCenterNotificationsFromApp);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderSecurityCenterNotificationsFromApp} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Notifications to show from the displayed areas of app”</i>
     * 
     * @param defenderSecurityCenterNotificationsFromApp
     *            new value of {@code defenderSecurityCenterNotificationsFromApp} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderSecurityCenterNotificationsFromApp} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderSecurityCenterNotificationsFromApp(DefenderSecurityCenterNotificationsFromAppType defenderSecurityCenterNotificationsFromApp) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderSecurityCenterNotificationsFromApp");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderSecurityCenterNotificationsFromApp = defenderSecurityCenterNotificationsFromApp;
        return _x;
    }

    /**
     * <i>“The company name that is displayed to the users.”</i>
     * 
     * @return property defenderSecurityCenterOrganizationDisplayName
     */
    @Property(name="defenderSecurityCenterOrganizationDisplayName")
    @JsonIgnore
    public Optional<String> getDefenderSecurityCenterOrganizationDisplayName() {
        return Optional.ofNullable(defenderSecurityCenterOrganizationDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderSecurityCenterOrganizationDisplayName} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The company name that is displayed to the users.”</i>
     * 
     * @param defenderSecurityCenterOrganizationDisplayName
     *            new value of {@code defenderSecurityCenterOrganizationDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderSecurityCenterOrganizationDisplayName} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderSecurityCenterOrganizationDisplayName(String defenderSecurityCenterOrganizationDisplayName) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderSecurityCenterOrganizationDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderSecurityCenterOrganizationDisplayName = defenderSecurityCenterOrganizationDisplayName;
        return _x;
    }

    /**
     * <i>“Specifies the interval (in hours) that will be used to check for signatures, so
     * instead of using the ScheduleDay and ScheduleTime the check for new signatures
     * will be set according to the interval. Valid values 0 to 24”</i>
     * 
     * @return property defenderSignatureUpdateIntervalInHours
     */
    @Property(name="defenderSignatureUpdateIntervalInHours")
    @JsonIgnore
    public Optional<Integer> getDefenderSignatureUpdateIntervalInHours() {
        return Optional.ofNullable(defenderSignatureUpdateIntervalInHours);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderSignatureUpdateIntervalInHours} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Specifies the interval (in hours) that will be used to check for signatures, so
     * instead of using the ScheduleDay and ScheduleTime the check for new signatures
     * will be set according to the interval. Valid values 0 to 24”</i>
     * 
     * @param defenderSignatureUpdateIntervalInHours
     *            new value of {@code defenderSignatureUpdateIntervalInHours} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderSignatureUpdateIntervalInHours} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderSignatureUpdateIntervalInHours(Integer defenderSignatureUpdateIntervalInHours) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderSignatureUpdateIntervalInHours");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderSignatureUpdateIntervalInHours = defenderSignatureUpdateIntervalInHours;
        return _x;
    }

    /**
     * <i>“Checks for the user consent level in Windows Defender to send data.”</i>
     * 
     * @return property defenderSubmitSamplesConsentType
     */
    @Property(name="defenderSubmitSamplesConsentType")
    @JsonIgnore
    public Optional<DefenderSubmitSamplesConsentType> getDefenderSubmitSamplesConsentType() {
        return Optional.ofNullable(defenderSubmitSamplesConsentType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderSubmitSamplesConsentType} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Checks for the user consent level in Windows Defender to send data.”</i>
     * 
     * @param defenderSubmitSamplesConsentType
     *            new value of {@code defenderSubmitSamplesConsentType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderSubmitSamplesConsentType} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderSubmitSamplesConsentType(DefenderSubmitSamplesConsentType defenderSubmitSamplesConsentType) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderSubmitSamplesConsentType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderSubmitSamplesConsentType = defenderSubmitSamplesConsentType;
        return _x;
    }

    /**
     * <i>“Value indicating response to executables that don't meet a prevalence, age, or
     * trusted list criteria”</i>
     * 
     * @return property defenderUntrustedExecutable
     */
    @Property(name="defenderUntrustedExecutable")
    @JsonIgnore
    public Optional<DefenderProtectionType> getDefenderUntrustedExecutable() {
        return Optional.ofNullable(defenderUntrustedExecutable);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderUntrustedExecutable} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Value indicating response to executables that don't meet a prevalence, age, or
     * trusted list criteria”</i>
     * 
     * @param defenderUntrustedExecutable
     *            new value of {@code defenderUntrustedExecutable} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderUntrustedExecutable} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderUntrustedExecutable(DefenderProtectionType defenderUntrustedExecutable) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderUntrustedExecutable");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderUntrustedExecutable = defenderUntrustedExecutable;
        return _x;
    }

    /**
     * <i>“Value indicating response to executables that don't meet a prevalence, age, or
     * trusted list criteria”</i>
     * 
     * @return property defenderUntrustedExecutableType
     */
    @Property(name="defenderUntrustedExecutableType")
    @JsonIgnore
    public Optional<DefenderAttackSurfaceType> getDefenderUntrustedExecutableType() {
        return Optional.ofNullable(defenderUntrustedExecutableType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderUntrustedExecutableType} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Value indicating response to executables that don't meet a prevalence, age, or
     * trusted list criteria”</i>
     * 
     * @param defenderUntrustedExecutableType
     *            new value of {@code defenderUntrustedExecutableType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderUntrustedExecutableType} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderUntrustedExecutableType(DefenderAttackSurfaceType defenderUntrustedExecutableType) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderUntrustedExecutableType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderUntrustedExecutableType = defenderUntrustedExecutableType;
        return _x;
    }

    /**
     * <i>“Value indicating response to untrusted and unsigned processes that run from USB”</i>
     * 
     * @return property defenderUntrustedUSBProcess
     */
    @Property(name="defenderUntrustedUSBProcess")
    @JsonIgnore
    public Optional<DefenderProtectionType> getDefenderUntrustedUSBProcess() {
        return Optional.ofNullable(defenderUntrustedUSBProcess);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderUntrustedUSBProcess} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Value indicating response to untrusted and unsigned processes that run from USB”</i>
     * 
     * @param defenderUntrustedUSBProcess
     *            new value of {@code defenderUntrustedUSBProcess} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderUntrustedUSBProcess} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderUntrustedUSBProcess(DefenderProtectionType defenderUntrustedUSBProcess) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderUntrustedUSBProcess");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderUntrustedUSBProcess = defenderUntrustedUSBProcess;
        return _x;
    }

    /**
     * <i>“Value indicating response to untrusted and unsigned processes that run from USB”</i>
     * 
     * @return property defenderUntrustedUSBProcessType
     */
    @Property(name="defenderUntrustedUSBProcessType")
    @JsonIgnore
    public Optional<DefenderAttackSurfaceType> getDefenderUntrustedUSBProcessType() {
        return Optional.ofNullable(defenderUntrustedUSBProcessType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defenderUntrustedUSBProcessType} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Value indicating response to untrusted and unsigned processes that run from USB”</i>
     * 
     * @param defenderUntrustedUSBProcessType
     *            new value of {@code defenderUntrustedUSBProcessType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defenderUntrustedUSBProcessType} field changed
     */
    public Windows10EndpointProtectionConfiguration withDefenderUntrustedUSBProcessType(DefenderAttackSurfaceType defenderUntrustedUSBProcessType) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defenderUntrustedUSBProcessType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.defenderUntrustedUSBProcessType = defenderUntrustedUSBProcessType;
        return _x;
    }

    /**
     * <i>“This property will be deprecated in May 2019 and will be replaced with property
     * DeviceGuardSecureBootWithDMA. Specifies whether Platform Security Level is
     * enabled at next reboot.”</i>
     * 
     * @return property deviceGuardEnableSecureBootWithDMA
     */
    @Property(name="deviceGuardEnableSecureBootWithDMA")
    @JsonIgnore
    public Optional<Boolean> getDeviceGuardEnableSecureBootWithDMA() {
        return Optional.ofNullable(deviceGuardEnableSecureBootWithDMA);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceGuardEnableSecureBootWithDMA} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“This property will be deprecated in May 2019 and will be replaced with property
     * DeviceGuardSecureBootWithDMA. Specifies whether Platform Security Level is
     * enabled at next reboot.”</i>
     * 
     * @param deviceGuardEnableSecureBootWithDMA
     *            new value of {@code deviceGuardEnableSecureBootWithDMA} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceGuardEnableSecureBootWithDMA} field changed
     */
    public Windows10EndpointProtectionConfiguration withDeviceGuardEnableSecureBootWithDMA(Boolean deviceGuardEnableSecureBootWithDMA) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("deviceGuardEnableSecureBootWithDMA");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.deviceGuardEnableSecureBootWithDMA = deviceGuardEnableSecureBootWithDMA;
        return _x;
    }

    /**
     * <i>“Turns On Virtualization Based Security(VBS).”</i>
     * 
     * @return property deviceGuardEnableVirtualizationBasedSecurity
     */
    @Property(name="deviceGuardEnableVirtualizationBasedSecurity")
    @JsonIgnore
    public Optional<Boolean> getDeviceGuardEnableVirtualizationBasedSecurity() {
        return Optional.ofNullable(deviceGuardEnableVirtualizationBasedSecurity);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceGuardEnableVirtualizationBasedSecurity} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Turns On Virtualization Based Security(VBS).”</i>
     * 
     * @param deviceGuardEnableVirtualizationBasedSecurity
     *            new value of {@code deviceGuardEnableVirtualizationBasedSecurity} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceGuardEnableVirtualizationBasedSecurity} field changed
     */
    public Windows10EndpointProtectionConfiguration withDeviceGuardEnableVirtualizationBasedSecurity(Boolean deviceGuardEnableVirtualizationBasedSecurity) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("deviceGuardEnableVirtualizationBasedSecurity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.deviceGuardEnableVirtualizationBasedSecurity = deviceGuardEnableVirtualizationBasedSecurity;
        return _x;
    }

    /**
     * <i>“Allows the IT admin to configure the launch of System Guard.”</i>
     * 
     * @return property deviceGuardLaunchSystemGuard
     */
    @Property(name="deviceGuardLaunchSystemGuard")
    @JsonIgnore
    public Optional<Enablement> getDeviceGuardLaunchSystemGuard() {
        return Optional.ofNullable(deviceGuardLaunchSystemGuard);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceGuardLaunchSystemGuard} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Allows the IT admin to configure the launch of System Guard.”</i>
     * 
     * @param deviceGuardLaunchSystemGuard
     *            new value of {@code deviceGuardLaunchSystemGuard} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceGuardLaunchSystemGuard} field changed
     */
    public Windows10EndpointProtectionConfiguration withDeviceGuardLaunchSystemGuard(Enablement deviceGuardLaunchSystemGuard) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("deviceGuardLaunchSystemGuard");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.deviceGuardLaunchSystemGuard = deviceGuardLaunchSystemGuard;
        return _x;
    }

    /**
     * <i>“Turn on Credential Guard when Platform Security Level with Secure Boot and
     * Virtualization Based Security are both enabled.”</i>
     * 
     * @return property deviceGuardLocalSystemAuthorityCredentialGuardSettings
     */
    @Property(name="deviceGuardLocalSystemAuthorityCredentialGuardSettings")
    @JsonIgnore
    public Optional<DeviceGuardLocalSystemAuthorityCredentialGuardType> getDeviceGuardLocalSystemAuthorityCredentialGuardSettings() {
        return Optional.ofNullable(deviceGuardLocalSystemAuthorityCredentialGuardSettings);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceGuardLocalSystemAuthorityCredentialGuardSettings} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Turn on Credential Guard when Platform Security Level with Secure Boot and
     * Virtualization Based Security are both enabled.”</i>
     * 
     * @param deviceGuardLocalSystemAuthorityCredentialGuardSettings
     *            new value of {@code deviceGuardLocalSystemAuthorityCredentialGuardSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceGuardLocalSystemAuthorityCredentialGuardSettings} field changed
     */
    public Windows10EndpointProtectionConfiguration withDeviceGuardLocalSystemAuthorityCredentialGuardSettings(DeviceGuardLocalSystemAuthorityCredentialGuardType deviceGuardLocalSystemAuthorityCredentialGuardSettings) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("deviceGuardLocalSystemAuthorityCredentialGuardSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.deviceGuardLocalSystemAuthorityCredentialGuardSettings = deviceGuardLocalSystemAuthorityCredentialGuardSettings;
        return _x;
    }

    /**
     * <i>“Specifies whether Platform Security Level is enabled at next reboot.”</i>
     * 
     * @return property deviceGuardSecureBootWithDMA
     */
    @Property(name="deviceGuardSecureBootWithDMA")
    @JsonIgnore
    public Optional<SecureBootWithDMAType> getDeviceGuardSecureBootWithDMA() {
        return Optional.ofNullable(deviceGuardSecureBootWithDMA);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceGuardSecureBootWithDMA} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Specifies whether Platform Security Level is enabled at next reboot.”</i>
     * 
     * @param deviceGuardSecureBootWithDMA
     *            new value of {@code deviceGuardSecureBootWithDMA} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceGuardSecureBootWithDMA} field changed
     */
    public Windows10EndpointProtectionConfiguration withDeviceGuardSecureBootWithDMA(SecureBootWithDMAType deviceGuardSecureBootWithDMA) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("deviceGuardSecureBootWithDMA");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.deviceGuardSecureBootWithDMA = deviceGuardSecureBootWithDMA;
        return _x;
    }

    /**
     * <i>“This policy is intended to provide additional security against external DMA
     * capable devices. It allows for more control over the enumeration of external DMA
     * capable devices incompatible with DMA Remapping/device memory isolation and
     * sandboxing. This policy only takes effect when Kernel DMA Protection is
     * supported and enabled by the system firmware. Kernel DMA Protection is a
     * platform feature that cannot be controlled via policy or by end user. It has to
     * be supported by the system at the time of manufacturing. To check if the system
     * supports Kernel DMA Protection, please check the Kernel DMA Protection field in
     * the Summary page of MSINFO32.exe.”</i>
     * 
     * @return property dmaGuardDeviceEnumerationPolicy
     */
    @Property(name="dmaGuardDeviceEnumerationPolicy")
    @JsonIgnore
    public Optional<DmaGuardDeviceEnumerationPolicyType> getDmaGuardDeviceEnumerationPolicy() {
        return Optional.ofNullable(dmaGuardDeviceEnumerationPolicy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * dmaGuardDeviceEnumerationPolicy} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“This policy is intended to provide additional security against external DMA
     * capable devices. It allows for more control over the enumeration of external DMA
     * capable devices incompatible with DMA Remapping/device memory isolation and
     * sandboxing. This policy only takes effect when Kernel DMA Protection is
     * supported and enabled by the system firmware. Kernel DMA Protection is a
     * platform feature that cannot be controlled via policy or by end user. It has to
     * be supported by the system at the time of manufacturing. To check if the system
     * supports Kernel DMA Protection, please check the Kernel DMA Protection field in
     * the Summary page of MSINFO32.exe.”</i>
     * 
     * @param dmaGuardDeviceEnumerationPolicy
     *            new value of {@code dmaGuardDeviceEnumerationPolicy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code dmaGuardDeviceEnumerationPolicy} field changed
     */
    public Windows10EndpointProtectionConfiguration withDmaGuardDeviceEnumerationPolicy(DmaGuardDeviceEnumerationPolicyType dmaGuardDeviceEnumerationPolicy) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("dmaGuardDeviceEnumerationPolicy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.dmaGuardDeviceEnumerationPolicy = dmaGuardDeviceEnumerationPolicy;
        return _x;
    }

    /**
     * <i>“Blocks stateful FTP connections to the device”</i>
     * 
     * @return property firewallBlockStatefulFTP
     */
    @Property(name="firewallBlockStatefulFTP")
    @JsonIgnore
    public Optional<Boolean> getFirewallBlockStatefulFTP() {
        return Optional.ofNullable(firewallBlockStatefulFTP);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * firewallBlockStatefulFTP} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Blocks stateful FTP connections to the device”</i>
     * 
     * @param firewallBlockStatefulFTP
     *            new value of {@code firewallBlockStatefulFTP} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code firewallBlockStatefulFTP} field changed
     */
    public Windows10EndpointProtectionConfiguration withFirewallBlockStatefulFTP(Boolean firewallBlockStatefulFTP) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("firewallBlockStatefulFTP");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.firewallBlockStatefulFTP = firewallBlockStatefulFTP;
        return _x;
    }

    /**
     * <i>“Specify how the certificate revocation list is to be enforced”</i>
     * 
     * @return property firewallCertificateRevocationListCheckMethod
     */
    @Property(name="firewallCertificateRevocationListCheckMethod")
    @JsonIgnore
    public Optional<FirewallCertificateRevocationListCheckMethodType> getFirewallCertificateRevocationListCheckMethod() {
        return Optional.ofNullable(firewallCertificateRevocationListCheckMethod);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * firewallCertificateRevocationListCheckMethod} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Specify how the certificate revocation list is to be enforced”</i>
     * 
     * @param firewallCertificateRevocationListCheckMethod
     *            new value of {@code firewallCertificateRevocationListCheckMethod} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code firewallCertificateRevocationListCheckMethod} field changed
     */
    public Windows10EndpointProtectionConfiguration withFirewallCertificateRevocationListCheckMethod(FirewallCertificateRevocationListCheckMethodType firewallCertificateRevocationListCheckMethod) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("firewallCertificateRevocationListCheckMethod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.firewallCertificateRevocationListCheckMethod = firewallCertificateRevocationListCheckMethod;
        return _x;
    }

    /**
     * <i>“Configures the idle timeout for security associations, in seconds, from 300 to
     * 3600 inclusive. This is the period after which security associations will expire
     * and be deleted. Valid values 300 to 3600”</i>
     * 
     * @return property firewallIdleTimeoutForSecurityAssociationInSeconds
     */
    @Property(name="firewallIdleTimeoutForSecurityAssociationInSeconds")
    @JsonIgnore
    public Optional<Integer> getFirewallIdleTimeoutForSecurityAssociationInSeconds() {
        return Optional.ofNullable(firewallIdleTimeoutForSecurityAssociationInSeconds);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * firewallIdleTimeoutForSecurityAssociationInSeconds} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Configures the idle timeout for security associations, in seconds, from 300 to
     * 3600 inclusive. This is the period after which security associations will expire
     * and be deleted. Valid values 300 to 3600”</i>
     * 
     * @param firewallIdleTimeoutForSecurityAssociationInSeconds
     *            new value of {@code firewallIdleTimeoutForSecurityAssociationInSeconds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code firewallIdleTimeoutForSecurityAssociationInSeconds} field changed
     */
    public Windows10EndpointProtectionConfiguration withFirewallIdleTimeoutForSecurityAssociationInSeconds(Integer firewallIdleTimeoutForSecurityAssociationInSeconds) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("firewallIdleTimeoutForSecurityAssociationInSeconds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.firewallIdleTimeoutForSecurityAssociationInSeconds = firewallIdleTimeoutForSecurityAssociationInSeconds;
        return _x;
    }

    /**
     * <i>“Configures IPSec exemptions to allow both IPv4 and IPv6 DHCP traffic”</i>
     * 
     * @return property firewallIPSecExemptionsAllowDHCP
     */
    @Property(name="firewallIPSecExemptionsAllowDHCP")
    @JsonIgnore
    public Optional<Boolean> getFirewallIPSecExemptionsAllowDHCP() {
        return Optional.ofNullable(firewallIPSecExemptionsAllowDHCP);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * firewallIPSecExemptionsAllowDHCP} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Configures IPSec exemptions to allow both IPv4 and IPv6 DHCP traffic”</i>
     * 
     * @param firewallIPSecExemptionsAllowDHCP
     *            new value of {@code firewallIPSecExemptionsAllowDHCP} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code firewallIPSecExemptionsAllowDHCP} field changed
     */
    public Windows10EndpointProtectionConfiguration withFirewallIPSecExemptionsAllowDHCP(Boolean firewallIPSecExemptionsAllowDHCP) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("firewallIPSecExemptionsAllowDHCP");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.firewallIPSecExemptionsAllowDHCP = firewallIPSecExemptionsAllowDHCP;
        return _x;
    }

    /**
     * <i>“Configures IPSec exemptions to allow ICMP”</i>
     * 
     * @return property firewallIPSecExemptionsAllowICMP
     */
    @Property(name="firewallIPSecExemptionsAllowICMP")
    @JsonIgnore
    public Optional<Boolean> getFirewallIPSecExemptionsAllowICMP() {
        return Optional.ofNullable(firewallIPSecExemptionsAllowICMP);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * firewallIPSecExemptionsAllowICMP} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Configures IPSec exemptions to allow ICMP”</i>
     * 
     * @param firewallIPSecExemptionsAllowICMP
     *            new value of {@code firewallIPSecExemptionsAllowICMP} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code firewallIPSecExemptionsAllowICMP} field changed
     */
    public Windows10EndpointProtectionConfiguration withFirewallIPSecExemptionsAllowICMP(Boolean firewallIPSecExemptionsAllowICMP) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("firewallIPSecExemptionsAllowICMP");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.firewallIPSecExemptionsAllowICMP = firewallIPSecExemptionsAllowICMP;
        return _x;
    }

    /**
     * <i>“Configures IPSec exemptions to allow neighbor discovery IPv6 ICMP type-codes”</i>
     * 
     * @return property firewallIPSecExemptionsAllowNeighborDiscovery
     */
    @Property(name="firewallIPSecExemptionsAllowNeighborDiscovery")
    @JsonIgnore
    public Optional<Boolean> getFirewallIPSecExemptionsAllowNeighborDiscovery() {
        return Optional.ofNullable(firewallIPSecExemptionsAllowNeighborDiscovery);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * firewallIPSecExemptionsAllowNeighborDiscovery} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Configures IPSec exemptions to allow neighbor discovery IPv6 ICMP type-codes”</i>
     * 
     * @param firewallIPSecExemptionsAllowNeighborDiscovery
     *            new value of {@code firewallIPSecExemptionsAllowNeighborDiscovery} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code firewallIPSecExemptionsAllowNeighborDiscovery} field changed
     */
    public Windows10EndpointProtectionConfiguration withFirewallIPSecExemptionsAllowNeighborDiscovery(Boolean firewallIPSecExemptionsAllowNeighborDiscovery) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("firewallIPSecExemptionsAllowNeighborDiscovery");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.firewallIPSecExemptionsAllowNeighborDiscovery = firewallIPSecExemptionsAllowNeighborDiscovery;
        return _x;
    }

    /**
     * <i>“Configures IPSec exemptions to allow router discovery IPv6 ICMP type-codes”</i>
     * 
     * @return property firewallIPSecExemptionsAllowRouterDiscovery
     */
    @Property(name="firewallIPSecExemptionsAllowRouterDiscovery")
    @JsonIgnore
    public Optional<Boolean> getFirewallIPSecExemptionsAllowRouterDiscovery() {
        return Optional.ofNullable(firewallIPSecExemptionsAllowRouterDiscovery);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * firewallIPSecExemptionsAllowRouterDiscovery} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Configures IPSec exemptions to allow router discovery IPv6 ICMP type-codes”</i>
     * 
     * @param firewallIPSecExemptionsAllowRouterDiscovery
     *            new value of {@code firewallIPSecExemptionsAllowRouterDiscovery} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code firewallIPSecExemptionsAllowRouterDiscovery} field changed
     */
    public Windows10EndpointProtectionConfiguration withFirewallIPSecExemptionsAllowRouterDiscovery(Boolean firewallIPSecExemptionsAllowRouterDiscovery) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("firewallIPSecExemptionsAllowRouterDiscovery");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.firewallIPSecExemptionsAllowRouterDiscovery = firewallIPSecExemptionsAllowRouterDiscovery;
        return _x;
    }

    /**
     * <i>“Configures IPSec exemptions to no exemptions”</i>
     * 
     * @return property firewallIPSecExemptionsNone
     */
    @Property(name="firewallIPSecExemptionsNone")
    @JsonIgnore
    public Optional<Boolean> getFirewallIPSecExemptionsNone() {
        return Optional.ofNullable(firewallIPSecExemptionsNone);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * firewallIPSecExemptionsNone} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Configures IPSec exemptions to no exemptions”</i>
     * 
     * @param firewallIPSecExemptionsNone
     *            new value of {@code firewallIPSecExemptionsNone} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code firewallIPSecExemptionsNone} field changed
     */
    public Windows10EndpointProtectionConfiguration withFirewallIPSecExemptionsNone(Boolean firewallIPSecExemptionsNone) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("firewallIPSecExemptionsNone");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.firewallIPSecExemptionsNone = firewallIPSecExemptionsNone;
        return _x;
    }

    /**
     * <i>“If an authentication set is not fully supported by a keying module, direct the
     * module to ignore only unsupported authentication suites rather than the entire
     * set”</i>
     * 
     * @return property firewallMergeKeyingModuleSettings
     */
    @Property(name="firewallMergeKeyingModuleSettings")
    @JsonIgnore
    public Optional<Boolean> getFirewallMergeKeyingModuleSettings() {
        return Optional.ofNullable(firewallMergeKeyingModuleSettings);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * firewallMergeKeyingModuleSettings} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“If an authentication set is not fully supported by a keying module, direct the
     * module to ignore only unsupported authentication suites rather than the entire
     * set”</i>
     * 
     * @param firewallMergeKeyingModuleSettings
     *            new value of {@code firewallMergeKeyingModuleSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code firewallMergeKeyingModuleSettings} field changed
     */
    public Windows10EndpointProtectionConfiguration withFirewallMergeKeyingModuleSettings(Boolean firewallMergeKeyingModuleSettings) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("firewallMergeKeyingModuleSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.firewallMergeKeyingModuleSettings = firewallMergeKeyingModuleSettings;
        return _x;
    }

    /**
     * <i>“Configures how packet queueing should be applied in the tunnel gateway scenario”</i>
     * 
     * @return property firewallPacketQueueingMethod
     */
    @Property(name="firewallPacketQueueingMethod")
    @JsonIgnore
    public Optional<FirewallPacketQueueingMethodType> getFirewallPacketQueueingMethod() {
        return Optional.ofNullable(firewallPacketQueueingMethod);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * firewallPacketQueueingMethod} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Configures how packet queueing should be applied in the tunnel gateway scenario”</i>
     * 
     * @param firewallPacketQueueingMethod
     *            new value of {@code firewallPacketQueueingMethod} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code firewallPacketQueueingMethod} field changed
     */
    public Windows10EndpointProtectionConfiguration withFirewallPacketQueueingMethod(FirewallPacketQueueingMethodType firewallPacketQueueingMethod) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("firewallPacketQueueingMethod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.firewallPacketQueueingMethod = firewallPacketQueueingMethod;
        return _x;
    }

    /**
     * <i>“Select the preshared key encoding to be used”</i>
     * 
     * @return property firewallPreSharedKeyEncodingMethod
     */
    @Property(name="firewallPreSharedKeyEncodingMethod")
    @JsonIgnore
    public Optional<FirewallPreSharedKeyEncodingMethodType> getFirewallPreSharedKeyEncodingMethod() {
        return Optional.ofNullable(firewallPreSharedKeyEncodingMethod);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * firewallPreSharedKeyEncodingMethod} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Select the preshared key encoding to be used”</i>
     * 
     * @param firewallPreSharedKeyEncodingMethod
     *            new value of {@code firewallPreSharedKeyEncodingMethod} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code firewallPreSharedKeyEncodingMethod} field changed
     */
    public Windows10EndpointProtectionConfiguration withFirewallPreSharedKeyEncodingMethod(FirewallPreSharedKeyEncodingMethodType firewallPreSharedKeyEncodingMethod) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("firewallPreSharedKeyEncodingMethod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.firewallPreSharedKeyEncodingMethod = firewallPreSharedKeyEncodingMethod;
        return _x;
    }

    /**
     * <i>“Configures the firewall profile settings for domain networks”</i>
     * 
     * @return property firewallProfileDomain
     */
    @Property(name="firewallProfileDomain")
    @JsonIgnore
    public Optional<WindowsFirewallNetworkProfile> getFirewallProfileDomain() {
        return Optional.ofNullable(firewallProfileDomain);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * firewallProfileDomain} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Configures the firewall profile settings for domain networks”</i>
     * 
     * @param firewallProfileDomain
     *            new value of {@code firewallProfileDomain} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code firewallProfileDomain} field changed
     */
    public Windows10EndpointProtectionConfiguration withFirewallProfileDomain(WindowsFirewallNetworkProfile firewallProfileDomain) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("firewallProfileDomain");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.firewallProfileDomain = firewallProfileDomain;
        return _x;
    }

    /**
     * <i>“Configures the firewall profile settings for private networks”</i>
     * 
     * @return property firewallProfilePrivate
     */
    @Property(name="firewallProfilePrivate")
    @JsonIgnore
    public Optional<WindowsFirewallNetworkProfile> getFirewallProfilePrivate() {
        return Optional.ofNullable(firewallProfilePrivate);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * firewallProfilePrivate} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Configures the firewall profile settings for private networks”</i>
     * 
     * @param firewallProfilePrivate
     *            new value of {@code firewallProfilePrivate} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code firewallProfilePrivate} field changed
     */
    public Windows10EndpointProtectionConfiguration withFirewallProfilePrivate(WindowsFirewallNetworkProfile firewallProfilePrivate) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("firewallProfilePrivate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.firewallProfilePrivate = firewallProfilePrivate;
        return _x;
    }

    /**
     * <i>“Configures the firewall profile settings for public networks”</i>
     * 
     * @return property firewallProfilePublic
     */
    @Property(name="firewallProfilePublic")
    @JsonIgnore
    public Optional<WindowsFirewallNetworkProfile> getFirewallProfilePublic() {
        return Optional.ofNullable(firewallProfilePublic);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * firewallProfilePublic} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Configures the firewall profile settings for public networks”</i>
     * 
     * @param firewallProfilePublic
     *            new value of {@code firewallProfilePublic} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code firewallProfilePublic} field changed
     */
    public Windows10EndpointProtectionConfiguration withFirewallProfilePublic(WindowsFirewallNetworkProfile firewallProfilePublic) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("firewallProfilePublic");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.firewallProfilePublic = firewallProfilePublic;
        return _x;
    }

    /**
     * <i>“Configures the firewall rule settings. This collection can contain a maximum of
     * 150 elements.”</i>
     * 
     * @return property firewallRules
     */
    @Property(name="firewallRules")
    @JsonIgnore
    public CollectionPage<WindowsFirewallRule> getFirewallRules() {
        return new CollectionPage<WindowsFirewallRule>(contextPath, WindowsFirewallRule.class, this.firewallRules, Optional.ofNullable(firewallRulesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code firewallRules}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Configures the firewall rule settings. This collection can contain a maximum of
     * 150 elements.”</i>
     * 
     * @param firewallRules
     *            new value of {@code firewallRules} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code firewallRules} field changed
     */
    public Windows10EndpointProtectionConfiguration withFirewallRules(List<WindowsFirewallRule> firewallRules) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("firewallRules");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.firewallRules = firewallRules;
        return _x;
    }

    /**
     * <i>“Configures the firewall rule settings. This collection can contain a maximum of
     * 150 elements.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property firewallRules
     */
    @Property(name="firewallRules")
    @JsonIgnore
    public CollectionPage<WindowsFirewallRule> getFirewallRules(HttpRequestOptions options) {
        return new CollectionPage<WindowsFirewallRule>(contextPath, WindowsFirewallRule.class, this.firewallRules, Optional.ofNullable(firewallRulesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“This security setting determines which challenge/response authentication
     * protocol is used for network logons.”</i>
     * 
     * @return property lanManagerAuthenticationLevel
     */
    @Property(name="lanManagerAuthenticationLevel")
    @JsonIgnore
    public Optional<LanManagerAuthenticationLevel> getLanManagerAuthenticationLevel() {
        return Optional.ofNullable(lanManagerAuthenticationLevel);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lanManagerAuthenticationLevel} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“This security setting determines which challenge/response authentication
     * protocol is used for network logons.”</i>
     * 
     * @param lanManagerAuthenticationLevel
     *            new value of {@code lanManagerAuthenticationLevel} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lanManagerAuthenticationLevel} field changed
     */
    public Windows10EndpointProtectionConfiguration withLanManagerAuthenticationLevel(LanManagerAuthenticationLevel lanManagerAuthenticationLevel) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("lanManagerAuthenticationLevel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.lanManagerAuthenticationLevel = lanManagerAuthenticationLevel;
        return _x;
    }

    /**
     * <i>“If enabled,the SMB client will allow insecure guest logons. If not configured,
     * the SMB client will reject insecure guest logons.”</i>
     * 
     * @return property lanManagerWorkstationDisableInsecureGuestLogons
     */
    @Property(name="lanManagerWorkstationDisableInsecureGuestLogons")
    @JsonIgnore
    public Optional<Boolean> getLanManagerWorkstationDisableInsecureGuestLogons() {
        return Optional.ofNullable(lanManagerWorkstationDisableInsecureGuestLogons);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lanManagerWorkstationDisableInsecureGuestLogons} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“If enabled,the SMB client will allow insecure guest logons. If not configured,
     * the SMB client will reject insecure guest logons.”</i>
     * 
     * @param lanManagerWorkstationDisableInsecureGuestLogons
     *            new value of {@code lanManagerWorkstationDisableInsecureGuestLogons} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lanManagerWorkstationDisableInsecureGuestLogons} field changed
     */
    public Windows10EndpointProtectionConfiguration withLanManagerWorkstationDisableInsecureGuestLogons(Boolean lanManagerWorkstationDisableInsecureGuestLogons) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("lanManagerWorkstationDisableInsecureGuestLogons");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.lanManagerWorkstationDisableInsecureGuestLogons = lanManagerWorkstationDisableInsecureGuestLogons;
        return _x;
    }

    /**
     * <i>“Define a different account name to be associated with the security identifier (
     * SID) for the account “Administrator”.”</i>
     * 
     * @return property localSecurityOptionsAdministratorAccountName
     */
    @Property(name="localSecurityOptionsAdministratorAccountName")
    @JsonIgnore
    public Optional<String> getLocalSecurityOptionsAdministratorAccountName() {
        return Optional.ofNullable(localSecurityOptionsAdministratorAccountName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsAdministratorAccountName} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Define a different account name to be associated with the security identifier (
     * SID) for the account “Administrator”.”</i>
     * 
     * @param localSecurityOptionsAdministratorAccountName
     *            new value of {@code localSecurityOptionsAdministratorAccountName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsAdministratorAccountName} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsAdministratorAccountName(String localSecurityOptionsAdministratorAccountName) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsAdministratorAccountName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsAdministratorAccountName = localSecurityOptionsAdministratorAccountName;
        return _x;
    }

    /**
     * <i>“Define the behavior of the elevation prompt for admins in Admin Approval Mode.”</i>
     * 
     * @return property localSecurityOptionsAdministratorElevationPromptBehavior
     */
    @Property(name="localSecurityOptionsAdministratorElevationPromptBehavior")
    @JsonIgnore
    public Optional<LocalSecurityOptionsAdministratorElevationPromptBehaviorType> getLocalSecurityOptionsAdministratorElevationPromptBehavior() {
        return Optional.ofNullable(localSecurityOptionsAdministratorElevationPromptBehavior);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsAdministratorElevationPromptBehavior} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Define the behavior of the elevation prompt for admins in Admin Approval Mode.”</i>
     * 
     * @param localSecurityOptionsAdministratorElevationPromptBehavior
     *            new value of {@code localSecurityOptionsAdministratorElevationPromptBehavior} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsAdministratorElevationPromptBehavior} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsAdministratorElevationPromptBehavior(LocalSecurityOptionsAdministratorElevationPromptBehaviorType localSecurityOptionsAdministratorElevationPromptBehavior) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsAdministratorElevationPromptBehavior");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsAdministratorElevationPromptBehavior = localSecurityOptionsAdministratorElevationPromptBehavior;
        return _x;
    }

    /**
     * <i>“This security setting determines whether to allows anonymous users to perform
     * certain activities, such as enumerating the names of domain accounts and network
     * shares.”</i>
     * 
     * @return property localSecurityOptionsAllowAnonymousEnumerationOfSAMAccountsAndShares
     */
    @Property(name="localSecurityOptionsAllowAnonymousEnumerationOfSAMAccountsAndShares")
    @JsonIgnore
    public Optional<Boolean> getLocalSecurityOptionsAllowAnonymousEnumerationOfSAMAccountsAndShares() {
        return Optional.ofNullable(localSecurityOptionsAllowAnonymousEnumerationOfSAMAccountsAndShares);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsAllowAnonymousEnumerationOfSAMAccountsAndShares} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“This security setting determines whether to allows anonymous users to perform
     * certain activities, such as enumerating the names of domain accounts and network
     * shares.”</i>
     * 
     * @param localSecurityOptionsAllowAnonymousEnumerationOfSAMAccountsAndShares
     *            new value of {@code localSecurityOptionsAllowAnonymousEnumerationOfSAMAccountsAndShares} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsAllowAnonymousEnumerationOfSAMAccountsAndShares} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsAllowAnonymousEnumerationOfSAMAccountsAndShares(Boolean localSecurityOptionsAllowAnonymousEnumerationOfSAMAccountsAndShares) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsAllowAnonymousEnumerationOfSAMAccountsAndShares");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsAllowAnonymousEnumerationOfSAMAccountsAndShares = localSecurityOptionsAllowAnonymousEnumerationOfSAMAccountsAndShares;
        return _x;
    }

    /**
     * <i>“Block PKU2U authentication requests to this device to use online identities.”</i>
     * 
     * @return property localSecurityOptionsAllowPKU2UAuthenticationRequests
     */
    @Property(name="localSecurityOptionsAllowPKU2UAuthenticationRequests")
    @JsonIgnore
    public Optional<Boolean> getLocalSecurityOptionsAllowPKU2UAuthenticationRequests() {
        return Optional.ofNullable(localSecurityOptionsAllowPKU2UAuthenticationRequests);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsAllowPKU2UAuthenticationRequests} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Block PKU2U authentication requests to this device to use online identities.”</i>
     * 
     * @param localSecurityOptionsAllowPKU2UAuthenticationRequests
     *            new value of {@code localSecurityOptionsAllowPKU2UAuthenticationRequests} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsAllowPKU2UAuthenticationRequests} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsAllowPKU2UAuthenticationRequests(Boolean localSecurityOptionsAllowPKU2UAuthenticationRequests) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsAllowPKU2UAuthenticationRequests");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsAllowPKU2UAuthenticationRequests = localSecurityOptionsAllowPKU2UAuthenticationRequests;
        return _x;
    }

    /**
     * <i>“Edit the default Security Descriptor Definition Language string to allow or deny
     * users and groups to make remote calls to the SAM.”</i>
     * 
     * @return property localSecurityOptionsAllowRemoteCallsToSecurityAccountsManager
     */
    @Property(name="localSecurityOptionsAllowRemoteCallsToSecurityAccountsManager")
    @JsonIgnore
    public Optional<String> getLocalSecurityOptionsAllowRemoteCallsToSecurityAccountsManager() {
        return Optional.ofNullable(localSecurityOptionsAllowRemoteCallsToSecurityAccountsManager);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsAllowRemoteCallsToSecurityAccountsManager} field changed.
     * Field description below. The field name is also added to an internal map of
     * changed fields in the returned object so that when {@code this.patch()} is
     * called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Edit the default Security Descriptor Definition Language string to allow or deny
     * users and groups to make remote calls to the SAM.”</i>
     * 
     * @param localSecurityOptionsAllowRemoteCallsToSecurityAccountsManager
     *            new value of {@code localSecurityOptionsAllowRemoteCallsToSecurityAccountsManager} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsAllowRemoteCallsToSecurityAccountsManager} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsAllowRemoteCallsToSecurityAccountsManager(String localSecurityOptionsAllowRemoteCallsToSecurityAccountsManager) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsAllowRemoteCallsToSecurityAccountsManager");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsAllowRemoteCallsToSecurityAccountsManager = localSecurityOptionsAllowRemoteCallsToSecurityAccountsManager;
        return _x;
    }

    /**
     * <i>“UI helper boolean for
     * LocalSecurityOptionsAllowRemoteCallsToSecurityAccountsManager entity”</i>
     * 
     * @return property localSecurityOptionsAllowRemoteCallsToSecurityAccountsManagerHelperBool
     */
    @Property(name="localSecurityOptionsAllowRemoteCallsToSecurityAccountsManagerHelperBool")
    @JsonIgnore
    public Optional<Boolean> getLocalSecurityOptionsAllowRemoteCallsToSecurityAccountsManagerHelperBool() {
        return Optional.ofNullable(localSecurityOptionsAllowRemoteCallsToSecurityAccountsManagerHelperBool);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsAllowRemoteCallsToSecurityAccountsManagerHelperBool} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“UI helper boolean for
     * LocalSecurityOptionsAllowRemoteCallsToSecurityAccountsManager entity”</i>
     * 
     * @param localSecurityOptionsAllowRemoteCallsToSecurityAccountsManagerHelperBool
     *            new value of {@code localSecurityOptionsAllowRemoteCallsToSecurityAccountsManagerHelperBool} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsAllowRemoteCallsToSecurityAccountsManagerHelperBool} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsAllowRemoteCallsToSecurityAccountsManagerHelperBool(Boolean localSecurityOptionsAllowRemoteCallsToSecurityAccountsManagerHelperBool) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsAllowRemoteCallsToSecurityAccountsManagerHelperBool");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsAllowRemoteCallsToSecurityAccountsManagerHelperBool = localSecurityOptionsAllowRemoteCallsToSecurityAccountsManagerHelperBool;
        return _x;
    }

    /**
     * <i>“This security setting determines whether a computer can be shut down without
     * having to log on to Windows.”</i>
     * 
     * @return property localSecurityOptionsAllowSystemToBeShutDownWithoutHavingToLogOn
     */
    @Property(name="localSecurityOptionsAllowSystemToBeShutDownWithoutHavingToLogOn")
    @JsonIgnore
    public Optional<Boolean> getLocalSecurityOptionsAllowSystemToBeShutDownWithoutHavingToLogOn() {
        return Optional.ofNullable(localSecurityOptionsAllowSystemToBeShutDownWithoutHavingToLogOn);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsAllowSystemToBeShutDownWithoutHavingToLogOn} field changed.
     * Field description below. The field name is also added to an internal map of
     * changed fields in the returned object so that when {@code this.patch()} is
     * called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“This security setting determines whether a computer can be shut down without
     * having to log on to Windows.”</i>
     * 
     * @param localSecurityOptionsAllowSystemToBeShutDownWithoutHavingToLogOn
     *            new value of {@code localSecurityOptionsAllowSystemToBeShutDownWithoutHavingToLogOn} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsAllowSystemToBeShutDownWithoutHavingToLogOn} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsAllowSystemToBeShutDownWithoutHavingToLogOn(Boolean localSecurityOptionsAllowSystemToBeShutDownWithoutHavingToLogOn) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsAllowSystemToBeShutDownWithoutHavingToLogOn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsAllowSystemToBeShutDownWithoutHavingToLogOn = localSecurityOptionsAllowSystemToBeShutDownWithoutHavingToLogOn;
        return _x;
    }

    /**
     * <i>“Allow UIAccess apps to prompt for elevation without using the secure desktop.”</i>
     * 
     * @return property localSecurityOptionsAllowUIAccessApplicationElevation
     */
    @Property(name="localSecurityOptionsAllowUIAccessApplicationElevation")
    @JsonIgnore
    public Optional<Boolean> getLocalSecurityOptionsAllowUIAccessApplicationElevation() {
        return Optional.ofNullable(localSecurityOptionsAllowUIAccessApplicationElevation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsAllowUIAccessApplicationElevation} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Allow UIAccess apps to prompt for elevation without using the secure desktop.”</i>
     * 
     * @param localSecurityOptionsAllowUIAccessApplicationElevation
     *            new value of {@code localSecurityOptionsAllowUIAccessApplicationElevation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsAllowUIAccessApplicationElevation} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsAllowUIAccessApplicationElevation(Boolean localSecurityOptionsAllowUIAccessApplicationElevation) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsAllowUIAccessApplicationElevation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsAllowUIAccessApplicationElevation = localSecurityOptionsAllowUIAccessApplicationElevation;
        return _x;
    }

    /**
     * <i>“Allow UIAccess apps to prompt for elevation without using the secure desktop.
     * Default is enabled”</i>
     * 
     * @return property localSecurityOptionsAllowUIAccessApplicationsForSecureLocations
     */
    @Property(name="localSecurityOptionsAllowUIAccessApplicationsForSecureLocations")
    @JsonIgnore
    public Optional<Boolean> getLocalSecurityOptionsAllowUIAccessApplicationsForSecureLocations() {
        return Optional.ofNullable(localSecurityOptionsAllowUIAccessApplicationsForSecureLocations);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsAllowUIAccessApplicationsForSecureLocations} field changed.
     * Field description below. The field name is also added to an internal map of
     * changed fields in the returned object so that when {@code this.patch()} is
     * called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Allow UIAccess apps to prompt for elevation without using the secure desktop.
     * Default is enabled”</i>
     * 
     * @param localSecurityOptionsAllowUIAccessApplicationsForSecureLocations
     *            new value of {@code localSecurityOptionsAllowUIAccessApplicationsForSecureLocations} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsAllowUIAccessApplicationsForSecureLocations} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsAllowUIAccessApplicationsForSecureLocations(Boolean localSecurityOptionsAllowUIAccessApplicationsForSecureLocations) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsAllowUIAccessApplicationsForSecureLocations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsAllowUIAccessApplicationsForSecureLocations = localSecurityOptionsAllowUIAccessApplicationsForSecureLocations;
        return _x;
    }

    /**
     * <i>“Prevent a portable computer from being undocked without having to log in.”</i>
     * 
     * @return property localSecurityOptionsAllowUndockWithoutHavingToLogon
     */
    @Property(name="localSecurityOptionsAllowUndockWithoutHavingToLogon")
    @JsonIgnore
    public Optional<Boolean> getLocalSecurityOptionsAllowUndockWithoutHavingToLogon() {
        return Optional.ofNullable(localSecurityOptionsAllowUndockWithoutHavingToLogon);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsAllowUndockWithoutHavingToLogon} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Prevent a portable computer from being undocked without having to log in.”</i>
     * 
     * @param localSecurityOptionsAllowUndockWithoutHavingToLogon
     *            new value of {@code localSecurityOptionsAllowUndockWithoutHavingToLogon} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsAllowUndockWithoutHavingToLogon} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsAllowUndockWithoutHavingToLogon(Boolean localSecurityOptionsAllowUndockWithoutHavingToLogon) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsAllowUndockWithoutHavingToLogon");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsAllowUndockWithoutHavingToLogon = localSecurityOptionsAllowUndockWithoutHavingToLogon;
        return _x;
    }

    /**
     * <i>“Prevent users from adding new Microsoft accounts to this computer.”</i>
     * 
     * @return property localSecurityOptionsBlockMicrosoftAccounts
     */
    @Property(name="localSecurityOptionsBlockMicrosoftAccounts")
    @JsonIgnore
    public Optional<Boolean> getLocalSecurityOptionsBlockMicrosoftAccounts() {
        return Optional.ofNullable(localSecurityOptionsBlockMicrosoftAccounts);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsBlockMicrosoftAccounts} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Prevent users from adding new Microsoft accounts to this computer.”</i>
     * 
     * @param localSecurityOptionsBlockMicrosoftAccounts
     *            new value of {@code localSecurityOptionsBlockMicrosoftAccounts} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsBlockMicrosoftAccounts} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsBlockMicrosoftAccounts(Boolean localSecurityOptionsBlockMicrosoftAccounts) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsBlockMicrosoftAccounts");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsBlockMicrosoftAccounts = localSecurityOptionsBlockMicrosoftAccounts;
        return _x;
    }

    /**
     * <i>“Enable Local accounts that are not password protected to log on from locations
     * other than the physical device.Default is enabled”</i>
     * 
     * @return property localSecurityOptionsBlockRemoteLogonWithBlankPassword
     */
    @Property(name="localSecurityOptionsBlockRemoteLogonWithBlankPassword")
    @JsonIgnore
    public Optional<Boolean> getLocalSecurityOptionsBlockRemoteLogonWithBlankPassword() {
        return Optional.ofNullable(localSecurityOptionsBlockRemoteLogonWithBlankPassword);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsBlockRemoteLogonWithBlankPassword} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Enable Local accounts that are not password protected to log on from locations
     * other than the physical device.Default is enabled”</i>
     * 
     * @param localSecurityOptionsBlockRemoteLogonWithBlankPassword
     *            new value of {@code localSecurityOptionsBlockRemoteLogonWithBlankPassword} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsBlockRemoteLogonWithBlankPassword} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsBlockRemoteLogonWithBlankPassword(Boolean localSecurityOptionsBlockRemoteLogonWithBlankPassword) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsBlockRemoteLogonWithBlankPassword");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsBlockRemoteLogonWithBlankPassword = localSecurityOptionsBlockRemoteLogonWithBlankPassword;
        return _x;
    }

    /**
     * <i>“Enabling this settings allows only interactively logged on user to access CD-ROM
     * media.”</i>
     * 
     * @return property localSecurityOptionsBlockRemoteOpticalDriveAccess
     */
    @Property(name="localSecurityOptionsBlockRemoteOpticalDriveAccess")
    @JsonIgnore
    public Optional<Boolean> getLocalSecurityOptionsBlockRemoteOpticalDriveAccess() {
        return Optional.ofNullable(localSecurityOptionsBlockRemoteOpticalDriveAccess);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsBlockRemoteOpticalDriveAccess} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Enabling this settings allows only interactively logged on user to access CD-ROM
     * media.”</i>
     * 
     * @param localSecurityOptionsBlockRemoteOpticalDriveAccess
     *            new value of {@code localSecurityOptionsBlockRemoteOpticalDriveAccess} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsBlockRemoteOpticalDriveAccess} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsBlockRemoteOpticalDriveAccess(Boolean localSecurityOptionsBlockRemoteOpticalDriveAccess) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsBlockRemoteOpticalDriveAccess");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsBlockRemoteOpticalDriveAccess = localSecurityOptionsBlockRemoteOpticalDriveAccess;
        return _x;
    }

    /**
     * <i>“Restrict installing printer drivers as part of connecting to a shared printer to
     * admins only.”</i>
     * 
     * @return property localSecurityOptionsBlockUsersInstallingPrinterDrivers
     */
    @Property(name="localSecurityOptionsBlockUsersInstallingPrinterDrivers")
    @JsonIgnore
    public Optional<Boolean> getLocalSecurityOptionsBlockUsersInstallingPrinterDrivers() {
        return Optional.ofNullable(localSecurityOptionsBlockUsersInstallingPrinterDrivers);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsBlockUsersInstallingPrinterDrivers} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Restrict installing printer drivers as part of connecting to a shared printer to
     * admins only.”</i>
     * 
     * @param localSecurityOptionsBlockUsersInstallingPrinterDrivers
     *            new value of {@code localSecurityOptionsBlockUsersInstallingPrinterDrivers} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsBlockUsersInstallingPrinterDrivers} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsBlockUsersInstallingPrinterDrivers(Boolean localSecurityOptionsBlockUsersInstallingPrinterDrivers) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsBlockUsersInstallingPrinterDrivers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsBlockUsersInstallingPrinterDrivers = localSecurityOptionsBlockUsersInstallingPrinterDrivers;
        return _x;
    }

    /**
     * <i>“This security setting determines whether the virtual memory pagefile is cleared
     * when the system is shut down.”</i>
     * 
     * @return property localSecurityOptionsClearVirtualMemoryPageFile
     */
    @Property(name="localSecurityOptionsClearVirtualMemoryPageFile")
    @JsonIgnore
    public Optional<Boolean> getLocalSecurityOptionsClearVirtualMemoryPageFile() {
        return Optional.ofNullable(localSecurityOptionsClearVirtualMemoryPageFile);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsClearVirtualMemoryPageFile} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“This security setting determines whether the virtual memory pagefile is cleared
     * when the system is shut down.”</i>
     * 
     * @param localSecurityOptionsClearVirtualMemoryPageFile
     *            new value of {@code localSecurityOptionsClearVirtualMemoryPageFile} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsClearVirtualMemoryPageFile} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsClearVirtualMemoryPageFile(Boolean localSecurityOptionsClearVirtualMemoryPageFile) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsClearVirtualMemoryPageFile");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsClearVirtualMemoryPageFile = localSecurityOptionsClearVirtualMemoryPageFile;
        return _x;
    }

    /**
     * <i>“This security setting determines whether packet signing is required by the SMB
     * client component.”</i>
     * 
     * @return property localSecurityOptionsClientDigitallySignCommunicationsAlways
     */
    @Property(name="localSecurityOptionsClientDigitallySignCommunicationsAlways")
    @JsonIgnore
    public Optional<Boolean> getLocalSecurityOptionsClientDigitallySignCommunicationsAlways() {
        return Optional.ofNullable(localSecurityOptionsClientDigitallySignCommunicationsAlways);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsClientDigitallySignCommunicationsAlways} field changed.
     * Field description below. The field name is also added to an internal map of
     * changed fields in the returned object so that when {@code this.patch()} is
     * called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“This security setting determines whether packet signing is required by the SMB
     * client component.”</i>
     * 
     * @param localSecurityOptionsClientDigitallySignCommunicationsAlways
     *            new value of {@code localSecurityOptionsClientDigitallySignCommunicationsAlways} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsClientDigitallySignCommunicationsAlways} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsClientDigitallySignCommunicationsAlways(Boolean localSecurityOptionsClientDigitallySignCommunicationsAlways) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsClientDigitallySignCommunicationsAlways");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsClientDigitallySignCommunicationsAlways = localSecurityOptionsClientDigitallySignCommunicationsAlways;
        return _x;
    }

    /**
     * <i>“If this security setting is enabled, the Server Message Block (SMB) redirector
     * is allowed to send plaintext passwords to non-Microsoft SMB servers that do not
     * support password encryption during authentication.”</i>
     * 
     * @return property localSecurityOptionsClientSendUnencryptedPasswordToThirdPartySMBServers
     */
    @Property(name="localSecurityOptionsClientSendUnencryptedPasswordToThirdPartySMBServers")
    @JsonIgnore
    public Optional<Boolean> getLocalSecurityOptionsClientSendUnencryptedPasswordToThirdPartySMBServers() {
        return Optional.ofNullable(localSecurityOptionsClientSendUnencryptedPasswordToThirdPartySMBServers);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsClientSendUnencryptedPasswordToThirdPartySMBServers} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“If this security setting is enabled, the Server Message Block (SMB) redirector
     * is allowed to send plaintext passwords to non-Microsoft SMB servers that do not
     * support password encryption during authentication.”</i>
     * 
     * @param localSecurityOptionsClientSendUnencryptedPasswordToThirdPartySMBServers
     *            new value of {@code localSecurityOptionsClientSendUnencryptedPasswordToThirdPartySMBServers} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsClientSendUnencryptedPasswordToThirdPartySMBServers} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsClientSendUnencryptedPasswordToThirdPartySMBServers(Boolean localSecurityOptionsClientSendUnencryptedPasswordToThirdPartySMBServers) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsClientSendUnencryptedPasswordToThirdPartySMBServers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsClientSendUnencryptedPasswordToThirdPartySMBServers = localSecurityOptionsClientSendUnencryptedPasswordToThirdPartySMBServers;
        return _x;
    }

    /**
     * <i>“App installations requiring elevated privileges will prompt for admin
     * credentials.Default is enabled”</i>
     * 
     * @return property localSecurityOptionsDetectApplicationInstallationsAndPromptForElevation
     */
    @Property(name="localSecurityOptionsDetectApplicationInstallationsAndPromptForElevation")
    @JsonIgnore
    public Optional<Boolean> getLocalSecurityOptionsDetectApplicationInstallationsAndPromptForElevation() {
        return Optional.ofNullable(localSecurityOptionsDetectApplicationInstallationsAndPromptForElevation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsDetectApplicationInstallationsAndPromptForElevation} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“App installations requiring elevated privileges will prompt for admin
     * credentials.Default is enabled”</i>
     * 
     * @param localSecurityOptionsDetectApplicationInstallationsAndPromptForElevation
     *            new value of {@code localSecurityOptionsDetectApplicationInstallationsAndPromptForElevation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsDetectApplicationInstallationsAndPromptForElevation} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsDetectApplicationInstallationsAndPromptForElevation(Boolean localSecurityOptionsDetectApplicationInstallationsAndPromptForElevation) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsDetectApplicationInstallationsAndPromptForElevation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsDetectApplicationInstallationsAndPromptForElevation = localSecurityOptionsDetectApplicationInstallationsAndPromptForElevation;
        return _x;
    }

    /**
     * <i>“Determines whether the Local Administrator account is enabled or disabled.”</i>
     * 
     * @return property localSecurityOptionsDisableAdministratorAccount
     */
    @Property(name="localSecurityOptionsDisableAdministratorAccount")
    @JsonIgnore
    public Optional<Boolean> getLocalSecurityOptionsDisableAdministratorAccount() {
        return Optional.ofNullable(localSecurityOptionsDisableAdministratorAccount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsDisableAdministratorAccount} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Determines whether the Local Administrator account is enabled or disabled.”</i>
     * 
     * @param localSecurityOptionsDisableAdministratorAccount
     *            new value of {@code localSecurityOptionsDisableAdministratorAccount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsDisableAdministratorAccount} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsDisableAdministratorAccount(Boolean localSecurityOptionsDisableAdministratorAccount) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsDisableAdministratorAccount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsDisableAdministratorAccount = localSecurityOptionsDisableAdministratorAccount;
        return _x;
    }

    /**
     * <i>“This security setting determines whether the SMB client attempts to negotiate
     * SMB packet signing.”</i>
     * 
     * @return property localSecurityOptionsDisableClientDigitallySignCommunicationsIfServerAgrees
     */
    @Property(name="localSecurityOptionsDisableClientDigitallySignCommunicationsIfServerAgrees")
    @JsonIgnore
    public Optional<Boolean> getLocalSecurityOptionsDisableClientDigitallySignCommunicationsIfServerAgrees() {
        return Optional.ofNullable(localSecurityOptionsDisableClientDigitallySignCommunicationsIfServerAgrees);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsDisableClientDigitallySignCommunicationsIfServerAgrees}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“This security setting determines whether the SMB client attempts to negotiate
     * SMB packet signing.”</i>
     * 
     * @param localSecurityOptionsDisableClientDigitallySignCommunicationsIfServerAgrees
     *            new value of {@code localSecurityOptionsDisableClientDigitallySignCommunicationsIfServerAgrees} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsDisableClientDigitallySignCommunicationsIfServerAgrees} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsDisableClientDigitallySignCommunicationsIfServerAgrees(Boolean localSecurityOptionsDisableClientDigitallySignCommunicationsIfServerAgrees) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsDisableClientDigitallySignCommunicationsIfServerAgrees");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsDisableClientDigitallySignCommunicationsIfServerAgrees = localSecurityOptionsDisableClientDigitallySignCommunicationsIfServerAgrees;
        return _x;
    }

    /**
     * <i>“Determines if the Guest account is enabled or disabled.”</i>
     * 
     * @return property localSecurityOptionsDisableGuestAccount
     */
    @Property(name="localSecurityOptionsDisableGuestAccount")
    @JsonIgnore
    public Optional<Boolean> getLocalSecurityOptionsDisableGuestAccount() {
        return Optional.ofNullable(localSecurityOptionsDisableGuestAccount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsDisableGuestAccount} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Determines if the Guest account is enabled or disabled.”</i>
     * 
     * @param localSecurityOptionsDisableGuestAccount
     *            new value of {@code localSecurityOptionsDisableGuestAccount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsDisableGuestAccount} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsDisableGuestAccount(Boolean localSecurityOptionsDisableGuestAccount) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsDisableGuestAccount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsDisableGuestAccount = localSecurityOptionsDisableGuestAccount;
        return _x;
    }

    /**
     * <i>“This security setting determines whether packet signing is required by the SMB
     * server component.”</i>
     * 
     * @return property localSecurityOptionsDisableServerDigitallySignCommunicationsAlways
     */
    @Property(name="localSecurityOptionsDisableServerDigitallySignCommunicationsAlways")
    @JsonIgnore
    public Optional<Boolean> getLocalSecurityOptionsDisableServerDigitallySignCommunicationsAlways() {
        return Optional.ofNullable(localSecurityOptionsDisableServerDigitallySignCommunicationsAlways);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsDisableServerDigitallySignCommunicationsAlways} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“This security setting determines whether packet signing is required by the SMB
     * server component.”</i>
     * 
     * @param localSecurityOptionsDisableServerDigitallySignCommunicationsAlways
     *            new value of {@code localSecurityOptionsDisableServerDigitallySignCommunicationsAlways} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsDisableServerDigitallySignCommunicationsAlways} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsDisableServerDigitallySignCommunicationsAlways(Boolean localSecurityOptionsDisableServerDigitallySignCommunicationsAlways) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsDisableServerDigitallySignCommunicationsAlways");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsDisableServerDigitallySignCommunicationsAlways = localSecurityOptionsDisableServerDigitallySignCommunicationsAlways;
        return _x;
    }

    /**
     * <i>“This security setting determines whether the SMB server will negotiate SMB
     * packet signing with clients that request it.”</i>
     * 
     * @return property localSecurityOptionsDisableServerDigitallySignCommunicationsIfClientAgrees
     */
    @Property(name="localSecurityOptionsDisableServerDigitallySignCommunicationsIfClientAgrees")
    @JsonIgnore
    public Optional<Boolean> getLocalSecurityOptionsDisableServerDigitallySignCommunicationsIfClientAgrees() {
        return Optional.ofNullable(localSecurityOptionsDisableServerDigitallySignCommunicationsIfClientAgrees);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsDisableServerDigitallySignCommunicationsIfClientAgrees}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“This security setting determines whether the SMB server will negotiate SMB
     * packet signing with clients that request it.”</i>
     * 
     * @param localSecurityOptionsDisableServerDigitallySignCommunicationsIfClientAgrees
     *            new value of {@code localSecurityOptionsDisableServerDigitallySignCommunicationsIfClientAgrees} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsDisableServerDigitallySignCommunicationsIfClientAgrees} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsDisableServerDigitallySignCommunicationsIfClientAgrees(Boolean localSecurityOptionsDisableServerDigitallySignCommunicationsIfClientAgrees) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsDisableServerDigitallySignCommunicationsIfClientAgrees");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsDisableServerDigitallySignCommunicationsIfClientAgrees = localSecurityOptionsDisableServerDigitallySignCommunicationsIfClientAgrees;
        return _x;
    }

    /**
     * <i>“This security setting determines what additional permissions will be granted for
     * anonymous connections to the computer.”</i>
     * 
     * @return property localSecurityOptionsDoNotAllowAnonymousEnumerationOfSAMAccounts
     */
    @Property(name="localSecurityOptionsDoNotAllowAnonymousEnumerationOfSAMAccounts")
    @JsonIgnore
    public Optional<Boolean> getLocalSecurityOptionsDoNotAllowAnonymousEnumerationOfSAMAccounts() {
        return Optional.ofNullable(localSecurityOptionsDoNotAllowAnonymousEnumerationOfSAMAccounts);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsDoNotAllowAnonymousEnumerationOfSAMAccounts} field changed.
     * Field description below. The field name is also added to an internal map of
     * changed fields in the returned object so that when {@code this.patch()} is
     * called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“This security setting determines what additional permissions will be granted for
     * anonymous connections to the computer.”</i>
     * 
     * @param localSecurityOptionsDoNotAllowAnonymousEnumerationOfSAMAccounts
     *            new value of {@code localSecurityOptionsDoNotAllowAnonymousEnumerationOfSAMAccounts} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsDoNotAllowAnonymousEnumerationOfSAMAccounts} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsDoNotAllowAnonymousEnumerationOfSAMAccounts(Boolean localSecurityOptionsDoNotAllowAnonymousEnumerationOfSAMAccounts) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsDoNotAllowAnonymousEnumerationOfSAMAccounts");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsDoNotAllowAnonymousEnumerationOfSAMAccounts = localSecurityOptionsDoNotAllowAnonymousEnumerationOfSAMAccounts;
        return _x;
    }

    /**
     * <i>“Require CTRL+ALT+DEL to be pressed before a user can log on.”</i>
     * 
     * @return property localSecurityOptionsDoNotRequireCtrlAltDel
     */
    @Property(name="localSecurityOptionsDoNotRequireCtrlAltDel")
    @JsonIgnore
    public Optional<Boolean> getLocalSecurityOptionsDoNotRequireCtrlAltDel() {
        return Optional.ofNullable(localSecurityOptionsDoNotRequireCtrlAltDel);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsDoNotRequireCtrlAltDel} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Require CTRL+ALT+DEL to be pressed before a user can log on.”</i>
     * 
     * @param localSecurityOptionsDoNotRequireCtrlAltDel
     *            new value of {@code localSecurityOptionsDoNotRequireCtrlAltDel} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsDoNotRequireCtrlAltDel} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsDoNotRequireCtrlAltDel(Boolean localSecurityOptionsDoNotRequireCtrlAltDel) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsDoNotRequireCtrlAltDel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsDoNotRequireCtrlAltDel = localSecurityOptionsDoNotRequireCtrlAltDel;
        return _x;
    }

    /**
     * <i>“This security setting determines if, at the next password change, the LAN
     * Manager (LM) hash value for the new password is stored. It’s not stored by
     * default.”</i>
     * 
     * @return property localSecurityOptionsDoNotStoreLANManagerHashValueOnNextPasswordChange
     */
    @Property(name="localSecurityOptionsDoNotStoreLANManagerHashValueOnNextPasswordChange")
    @JsonIgnore
    public Optional<Boolean> getLocalSecurityOptionsDoNotStoreLANManagerHashValueOnNextPasswordChange() {
        return Optional.ofNullable(localSecurityOptionsDoNotStoreLANManagerHashValueOnNextPasswordChange);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsDoNotStoreLANManagerHashValueOnNextPasswordChange} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“This security setting determines if, at the next password change, the LAN
     * Manager (LM) hash value for the new password is stored. It’s not stored by
     * default.”</i>
     * 
     * @param localSecurityOptionsDoNotStoreLANManagerHashValueOnNextPasswordChange
     *            new value of {@code localSecurityOptionsDoNotStoreLANManagerHashValueOnNextPasswordChange} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsDoNotStoreLANManagerHashValueOnNextPasswordChange} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsDoNotStoreLANManagerHashValueOnNextPasswordChange(Boolean localSecurityOptionsDoNotStoreLANManagerHashValueOnNextPasswordChange) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsDoNotStoreLANManagerHashValueOnNextPasswordChange");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsDoNotStoreLANManagerHashValueOnNextPasswordChange = localSecurityOptionsDoNotStoreLANManagerHashValueOnNextPasswordChange;
        return _x;
    }

    /**
     * <i>“Define who is allowed to format and eject removable NTFS media.”</i>
     * 
     * @return property localSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUser
     */
    @Property(name="localSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUser")
    @JsonIgnore
    public Optional<LocalSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUserType> getLocalSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUser() {
        return Optional.ofNullable(localSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUser);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUser} field changed.
     * Field description below. The field name is also added to an internal map of
     * changed fields in the returned object so that when {@code this.patch()} is
     * called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Define who is allowed to format and eject removable NTFS media.”</i>
     * 
     * @param localSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUser
     *            new value of {@code localSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUser} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUser} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUser(LocalSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUserType localSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUser) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUser");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUser = localSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUser;
        return _x;
    }

    /**
     * <i>“Define a different account name to be associated with the security identifier (
     * SID) for the account “Guest”.”</i>
     * 
     * @return property localSecurityOptionsGuestAccountName
     */
    @Property(name="localSecurityOptionsGuestAccountName")
    @JsonIgnore
    public Optional<String> getLocalSecurityOptionsGuestAccountName() {
        return Optional.ofNullable(localSecurityOptionsGuestAccountName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsGuestAccountName} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Define a different account name to be associated with the security identifier (
     * SID) for the account “Guest”.”</i>
     * 
     * @param localSecurityOptionsGuestAccountName
     *            new value of {@code localSecurityOptionsGuestAccountName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsGuestAccountName} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsGuestAccountName(String localSecurityOptionsGuestAccountName) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsGuestAccountName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsGuestAccountName = localSecurityOptionsGuestAccountName;
        return _x;
    }

    /**
     * <i>“Do not display the username of the last person who signed in on this device.”</i>
     * 
     * @return property localSecurityOptionsHideLastSignedInUser
     */
    @Property(name="localSecurityOptionsHideLastSignedInUser")
    @JsonIgnore
    public Optional<Boolean> getLocalSecurityOptionsHideLastSignedInUser() {
        return Optional.ofNullable(localSecurityOptionsHideLastSignedInUser);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsHideLastSignedInUser} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Do not display the username of the last person who signed in on this device.”</i>
     * 
     * @param localSecurityOptionsHideLastSignedInUser
     *            new value of {@code localSecurityOptionsHideLastSignedInUser} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsHideLastSignedInUser} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsHideLastSignedInUser(Boolean localSecurityOptionsHideLastSignedInUser) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsHideLastSignedInUser");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsHideLastSignedInUser = localSecurityOptionsHideLastSignedInUser;
        return _x;
    }

    /**
     * <i>“Do not display the username of the person signing in to this device after
     * credentials are entered and before the device’s desktop is shown.”</i>
     * 
     * @return property localSecurityOptionsHideUsernameAtSignIn
     */
    @Property(name="localSecurityOptionsHideUsernameAtSignIn")
    @JsonIgnore
    public Optional<Boolean> getLocalSecurityOptionsHideUsernameAtSignIn() {
        return Optional.ofNullable(localSecurityOptionsHideUsernameAtSignIn);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsHideUsernameAtSignIn} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Do not display the username of the person signing in to this device after
     * credentials are entered and before the device’s desktop is shown.”</i>
     * 
     * @param localSecurityOptionsHideUsernameAtSignIn
     *            new value of {@code localSecurityOptionsHideUsernameAtSignIn} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsHideUsernameAtSignIn} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsHideUsernameAtSignIn(Boolean localSecurityOptionsHideUsernameAtSignIn) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsHideUsernameAtSignIn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsHideUsernameAtSignIn = localSecurityOptionsHideUsernameAtSignIn;
        return _x;
    }

    /**
     * <i>“Configure the user information that is displayed when the session is locked. If
     * not configured, user display name, domain and username are shown”</i>
     * 
     * @return property localSecurityOptionsInformationDisplayedOnLockScreen
     */
    @Property(name="localSecurityOptionsInformationDisplayedOnLockScreen")
    @JsonIgnore
    public Optional<LocalSecurityOptionsInformationDisplayedOnLockScreenType> getLocalSecurityOptionsInformationDisplayedOnLockScreen() {
        return Optional.ofNullable(localSecurityOptionsInformationDisplayedOnLockScreen);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsInformationDisplayedOnLockScreen} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Configure the user information that is displayed when the session is locked. If
     * not configured, user display name, domain and username are shown”</i>
     * 
     * @param localSecurityOptionsInformationDisplayedOnLockScreen
     *            new value of {@code localSecurityOptionsInformationDisplayedOnLockScreen} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsInformationDisplayedOnLockScreen} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsInformationDisplayedOnLockScreen(LocalSecurityOptionsInformationDisplayedOnLockScreenType localSecurityOptionsInformationDisplayedOnLockScreen) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsInformationDisplayedOnLockScreen");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsInformationDisplayedOnLockScreen = localSecurityOptionsInformationDisplayedOnLockScreen;
        return _x;
    }

    /**
     * <i>“Configure the user information that is displayed when the session is locked. If
     * not configured, user display name, domain and username are shown”</i>
     * 
     * @return property localSecurityOptionsInformationShownOnLockScreen
     */
    @Property(name="localSecurityOptionsInformationShownOnLockScreen")
    @JsonIgnore
    public Optional<LocalSecurityOptionsInformationShownOnLockScreenType> getLocalSecurityOptionsInformationShownOnLockScreen() {
        return Optional.ofNullable(localSecurityOptionsInformationShownOnLockScreen);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsInformationShownOnLockScreen} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Configure the user information that is displayed when the session is locked. If
     * not configured, user display name, domain and username are shown”</i>
     * 
     * @param localSecurityOptionsInformationShownOnLockScreen
     *            new value of {@code localSecurityOptionsInformationShownOnLockScreen} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsInformationShownOnLockScreen} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsInformationShownOnLockScreen(LocalSecurityOptionsInformationShownOnLockScreenType localSecurityOptionsInformationShownOnLockScreen) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsInformationShownOnLockScreen");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsInformationShownOnLockScreen = localSecurityOptionsInformationShownOnLockScreen;
        return _x;
    }

    /**
     * <i>“Set message text for users attempting to log in.”</i>
     * 
     * @return property localSecurityOptionsLogOnMessageText
     */
    @Property(name="localSecurityOptionsLogOnMessageText")
    @JsonIgnore
    public Optional<String> getLocalSecurityOptionsLogOnMessageText() {
        return Optional.ofNullable(localSecurityOptionsLogOnMessageText);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsLogOnMessageText} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Set message text for users attempting to log in.”</i>
     * 
     * @param localSecurityOptionsLogOnMessageText
     *            new value of {@code localSecurityOptionsLogOnMessageText} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsLogOnMessageText} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsLogOnMessageText(String localSecurityOptionsLogOnMessageText) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsLogOnMessageText");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsLogOnMessageText = localSecurityOptionsLogOnMessageText;
        return _x;
    }

    /**
     * <i>“Set message title for users attempting to log in.”</i>
     * 
     * @return property localSecurityOptionsLogOnMessageTitle
     */
    @Property(name="localSecurityOptionsLogOnMessageTitle")
    @JsonIgnore
    public Optional<String> getLocalSecurityOptionsLogOnMessageTitle() {
        return Optional.ofNullable(localSecurityOptionsLogOnMessageTitle);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsLogOnMessageTitle} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Set message title for users attempting to log in.”</i>
     * 
     * @param localSecurityOptionsLogOnMessageTitle
     *            new value of {@code localSecurityOptionsLogOnMessageTitle} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsLogOnMessageTitle} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsLogOnMessageTitle(String localSecurityOptionsLogOnMessageTitle) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsLogOnMessageTitle");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsLogOnMessageTitle = localSecurityOptionsLogOnMessageTitle;
        return _x;
    }

    /**
     * <i>“Define maximum minutes of inactivity on the interactive desktop’s login screen
     * until the screen saver runs. Valid values 0 to 9999”</i>
     * 
     * @return property localSecurityOptionsMachineInactivityLimit
     */
    @Property(name="localSecurityOptionsMachineInactivityLimit")
    @JsonIgnore
    public Optional<Integer> getLocalSecurityOptionsMachineInactivityLimit() {
        return Optional.ofNullable(localSecurityOptionsMachineInactivityLimit);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsMachineInactivityLimit} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Define maximum minutes of inactivity on the interactive desktop’s login screen
     * until the screen saver runs. Valid values 0 to 9999”</i>
     * 
     * @param localSecurityOptionsMachineInactivityLimit
     *            new value of {@code localSecurityOptionsMachineInactivityLimit} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsMachineInactivityLimit} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsMachineInactivityLimit(Integer localSecurityOptionsMachineInactivityLimit) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsMachineInactivityLimit");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsMachineInactivityLimit = localSecurityOptionsMachineInactivityLimit;
        return _x;
    }

    /**
     * <i>“Define maximum minutes of inactivity on the interactive desktop’s login screen
     * until the screen saver runs. Valid values 0 to 9999”</i>
     * 
     * @return property localSecurityOptionsMachineInactivityLimitInMinutes
     */
    @Property(name="localSecurityOptionsMachineInactivityLimitInMinutes")
    @JsonIgnore
    public Optional<Integer> getLocalSecurityOptionsMachineInactivityLimitInMinutes() {
        return Optional.ofNullable(localSecurityOptionsMachineInactivityLimitInMinutes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsMachineInactivityLimitInMinutes} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Define maximum minutes of inactivity on the interactive desktop’s login screen
     * until the screen saver runs. Valid values 0 to 9999”</i>
     * 
     * @param localSecurityOptionsMachineInactivityLimitInMinutes
     *            new value of {@code localSecurityOptionsMachineInactivityLimitInMinutes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsMachineInactivityLimitInMinutes} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsMachineInactivityLimitInMinutes(Integer localSecurityOptionsMachineInactivityLimitInMinutes) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsMachineInactivityLimitInMinutes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsMachineInactivityLimitInMinutes = localSecurityOptionsMachineInactivityLimitInMinutes;
        return _x;
    }

    /**
     * <i>“This security setting allows a client to require the negotiation of 128-bit
     * encryption and/or NTLMv2 session security.”</i>
     * 
     * @return property localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedClients
     */
    @Property(name="localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedClients")
    @JsonIgnore
    public Optional<LocalSecurityOptionsMinimumSessionSecurity> getLocalSecurityOptionsMinimumSessionSecurityForNtlmSspBasedClients() {
        return Optional.ofNullable(localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedClients);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedClients} field changed.
     * Field description below. The field name is also added to an internal map of
     * changed fields in the returned object so that when {@code this.patch()} is
     * called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“This security setting allows a client to require the negotiation of 128-bit
     * encryption and/or NTLMv2 session security.”</i>
     * 
     * @param localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedClients
     *            new value of {@code localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedClients} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedClients} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsMinimumSessionSecurityForNtlmSspBasedClients(LocalSecurityOptionsMinimumSessionSecurity localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedClients) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedClients");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedClients = localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedClients;
        return _x;
    }

    /**
     * <i>“This security setting allows a server to require the negotiation of 128-bit
     * encryption and/or NTLMv2 session security.”</i>
     * 
     * @return property localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedServers
     */
    @Property(name="localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedServers")
    @JsonIgnore
    public Optional<LocalSecurityOptionsMinimumSessionSecurity> getLocalSecurityOptionsMinimumSessionSecurityForNtlmSspBasedServers() {
        return Optional.ofNullable(localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedServers);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedServers} field changed.
     * Field description below. The field name is also added to an internal map of
     * changed fields in the returned object so that when {@code this.patch()} is
     * called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“This security setting allows a server to require the negotiation of 128-bit
     * encryption and/or NTLMv2 session security.”</i>
     * 
     * @param localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedServers
     *            new value of {@code localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedServers} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedServers} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsMinimumSessionSecurityForNtlmSspBasedServers(LocalSecurityOptionsMinimumSessionSecurity localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedServers) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedServers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedServers = localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedServers;
        return _x;
    }

    /**
     * <i>“Enforce PKI certification path validation for a given executable file before it
     * is permitted to run.”</i>
     * 
     * @return property localSecurityOptionsOnlyElevateSignedExecutables
     */
    @Property(name="localSecurityOptionsOnlyElevateSignedExecutables")
    @JsonIgnore
    public Optional<Boolean> getLocalSecurityOptionsOnlyElevateSignedExecutables() {
        return Optional.ofNullable(localSecurityOptionsOnlyElevateSignedExecutables);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsOnlyElevateSignedExecutables} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Enforce PKI certification path validation for a given executable file before it
     * is permitted to run.”</i>
     * 
     * @param localSecurityOptionsOnlyElevateSignedExecutables
     *            new value of {@code localSecurityOptionsOnlyElevateSignedExecutables} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsOnlyElevateSignedExecutables} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsOnlyElevateSignedExecutables(Boolean localSecurityOptionsOnlyElevateSignedExecutables) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsOnlyElevateSignedExecutables");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsOnlyElevateSignedExecutables = localSecurityOptionsOnlyElevateSignedExecutables;
        return _x;
    }

    /**
     * <i>“By default, this security setting restricts anonymous access to shares and pipes
     * to the settings for named pipes that can be accessed anonymously and Shares that
     * can be accessed anonymously”</i>
     * 
     * @return property localSecurityOptionsRestrictAnonymousAccessToNamedPipesAndShares
     */
    @Property(name="localSecurityOptionsRestrictAnonymousAccessToNamedPipesAndShares")
    @JsonIgnore
    public Optional<Boolean> getLocalSecurityOptionsRestrictAnonymousAccessToNamedPipesAndShares() {
        return Optional.ofNullable(localSecurityOptionsRestrictAnonymousAccessToNamedPipesAndShares);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsRestrictAnonymousAccessToNamedPipesAndShares} field changed.
     * Field description below. The field name is also added to an internal map of
     * changed fields in the returned object so that when {@code this.patch()} is
     * called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“By default, this security setting restricts anonymous access to shares and pipes
     * to the settings for named pipes that can be accessed anonymously and Shares that
     * can be accessed anonymously”</i>
     * 
     * @param localSecurityOptionsRestrictAnonymousAccessToNamedPipesAndShares
     *            new value of {@code localSecurityOptionsRestrictAnonymousAccessToNamedPipesAndShares} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsRestrictAnonymousAccessToNamedPipesAndShares} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsRestrictAnonymousAccessToNamedPipesAndShares(Boolean localSecurityOptionsRestrictAnonymousAccessToNamedPipesAndShares) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsRestrictAnonymousAccessToNamedPipesAndShares");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsRestrictAnonymousAccessToNamedPipesAndShares = localSecurityOptionsRestrictAnonymousAccessToNamedPipesAndShares;
        return _x;
    }

    /**
     * <i>“This security setting determines what happens when the smart card for a logged-
     * on user is removed from the smart card reader.”</i>
     * 
     * @return property localSecurityOptionsSmartCardRemovalBehavior
     */
    @Property(name="localSecurityOptionsSmartCardRemovalBehavior")
    @JsonIgnore
    public Optional<LocalSecurityOptionsSmartCardRemovalBehaviorType> getLocalSecurityOptionsSmartCardRemovalBehavior() {
        return Optional.ofNullable(localSecurityOptionsSmartCardRemovalBehavior);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsSmartCardRemovalBehavior} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“This security setting determines what happens when the smart card for a logged-
     * on user is removed from the smart card reader.”</i>
     * 
     * @param localSecurityOptionsSmartCardRemovalBehavior
     *            new value of {@code localSecurityOptionsSmartCardRemovalBehavior} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsSmartCardRemovalBehavior} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsSmartCardRemovalBehavior(LocalSecurityOptionsSmartCardRemovalBehaviorType localSecurityOptionsSmartCardRemovalBehavior) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsSmartCardRemovalBehavior");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsSmartCardRemovalBehavior = localSecurityOptionsSmartCardRemovalBehavior;
        return _x;
    }

    /**
     * <i>“Define the behavior of the elevation prompt for standard users.”</i>
     * 
     * @return property localSecurityOptionsStandardUserElevationPromptBehavior
     */
    @Property(name="localSecurityOptionsStandardUserElevationPromptBehavior")
    @JsonIgnore
    public Optional<LocalSecurityOptionsStandardUserElevationPromptBehaviorType> getLocalSecurityOptionsStandardUserElevationPromptBehavior() {
        return Optional.ofNullable(localSecurityOptionsStandardUserElevationPromptBehavior);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsStandardUserElevationPromptBehavior} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Define the behavior of the elevation prompt for standard users.”</i>
     * 
     * @param localSecurityOptionsStandardUserElevationPromptBehavior
     *            new value of {@code localSecurityOptionsStandardUserElevationPromptBehavior} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsStandardUserElevationPromptBehavior} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsStandardUserElevationPromptBehavior(LocalSecurityOptionsStandardUserElevationPromptBehaviorType localSecurityOptionsStandardUserElevationPromptBehavior) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsStandardUserElevationPromptBehavior");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsStandardUserElevationPromptBehavior = localSecurityOptionsStandardUserElevationPromptBehavior;
        return _x;
    }

    /**
     * <i>“Enable all elevation requests to go to the interactive user's desktop rather
     * than the secure desktop. Prompt behavior policy settings for admins and standard
     * users are used.”</i>
     * 
     * @return property localSecurityOptionsSwitchToSecureDesktopWhenPromptingForElevation
     */
    @Property(name="localSecurityOptionsSwitchToSecureDesktopWhenPromptingForElevation")
    @JsonIgnore
    public Optional<Boolean> getLocalSecurityOptionsSwitchToSecureDesktopWhenPromptingForElevation() {
        return Optional.ofNullable(localSecurityOptionsSwitchToSecureDesktopWhenPromptingForElevation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsSwitchToSecureDesktopWhenPromptingForElevation} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Enable all elevation requests to go to the interactive user's desktop rather
     * than the secure desktop. Prompt behavior policy settings for admins and standard
     * users are used.”</i>
     * 
     * @param localSecurityOptionsSwitchToSecureDesktopWhenPromptingForElevation
     *            new value of {@code localSecurityOptionsSwitchToSecureDesktopWhenPromptingForElevation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsSwitchToSecureDesktopWhenPromptingForElevation} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsSwitchToSecureDesktopWhenPromptingForElevation(Boolean localSecurityOptionsSwitchToSecureDesktopWhenPromptingForElevation) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsSwitchToSecureDesktopWhenPromptingForElevation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsSwitchToSecureDesktopWhenPromptingForElevation = localSecurityOptionsSwitchToSecureDesktopWhenPromptingForElevation;
        return _x;
    }

    /**
     * <i>“Defines whether the built-in admin account uses Admin Approval Mode or runs all
     * apps with full admin privileges.Default is enabled”</i>
     * 
     * @return property localSecurityOptionsUseAdminApprovalMode
     */
    @Property(name="localSecurityOptionsUseAdminApprovalMode")
    @JsonIgnore
    public Optional<Boolean> getLocalSecurityOptionsUseAdminApprovalMode() {
        return Optional.ofNullable(localSecurityOptionsUseAdminApprovalMode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsUseAdminApprovalMode} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Defines whether the built-in admin account uses Admin Approval Mode or runs all
     * apps with full admin privileges.Default is enabled”</i>
     * 
     * @param localSecurityOptionsUseAdminApprovalMode
     *            new value of {@code localSecurityOptionsUseAdminApprovalMode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsUseAdminApprovalMode} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsUseAdminApprovalMode(Boolean localSecurityOptionsUseAdminApprovalMode) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsUseAdminApprovalMode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsUseAdminApprovalMode = localSecurityOptionsUseAdminApprovalMode;
        return _x;
    }

    /**
     * <i>“Define whether Admin Approval Mode and all UAC policy settings are enabled,
     * default is enabled”</i>
     * 
     * @return property localSecurityOptionsUseAdminApprovalModeForAdministrators
     */
    @Property(name="localSecurityOptionsUseAdminApprovalModeForAdministrators")
    @JsonIgnore
    public Optional<Boolean> getLocalSecurityOptionsUseAdminApprovalModeForAdministrators() {
        return Optional.ofNullable(localSecurityOptionsUseAdminApprovalModeForAdministrators);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsUseAdminApprovalModeForAdministrators} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Define whether Admin Approval Mode and all UAC policy settings are enabled,
     * default is enabled”</i>
     * 
     * @param localSecurityOptionsUseAdminApprovalModeForAdministrators
     *            new value of {@code localSecurityOptionsUseAdminApprovalModeForAdministrators} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsUseAdminApprovalModeForAdministrators} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsUseAdminApprovalModeForAdministrators(Boolean localSecurityOptionsUseAdminApprovalModeForAdministrators) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsUseAdminApprovalModeForAdministrators");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsUseAdminApprovalModeForAdministrators = localSecurityOptionsUseAdminApprovalModeForAdministrators;
        return _x;
    }

    /**
     * <i>“Virtualize file and registry write failures to per user locations”</i>
     * 
     * @return property localSecurityOptionsVirtualizeFileAndRegistryWriteFailuresToPerUserLocations
     */
    @Property(name="localSecurityOptionsVirtualizeFileAndRegistryWriteFailuresToPerUserLocations")
    @JsonIgnore
    public Optional<Boolean> getLocalSecurityOptionsVirtualizeFileAndRegistryWriteFailuresToPerUserLocations() {
        return Optional.ofNullable(localSecurityOptionsVirtualizeFileAndRegistryWriteFailuresToPerUserLocations);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * localSecurityOptionsVirtualizeFileAndRegistryWriteFailuresToPerUserLocations}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Virtualize file and registry write failures to per user locations”</i>
     * 
     * @param localSecurityOptionsVirtualizeFileAndRegistryWriteFailuresToPerUserLocations
     *            new value of {@code localSecurityOptionsVirtualizeFileAndRegistryWriteFailuresToPerUserLocations} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localSecurityOptionsVirtualizeFileAndRegistryWriteFailuresToPerUserLocations} field changed
     */
    public Windows10EndpointProtectionConfiguration withLocalSecurityOptionsVirtualizeFileAndRegistryWriteFailuresToPerUserLocations(Boolean localSecurityOptionsVirtualizeFileAndRegistryWriteFailuresToPerUserLocations) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localSecurityOptionsVirtualizeFileAndRegistryWriteFailuresToPerUserLocations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.localSecurityOptionsVirtualizeFileAndRegistryWriteFailuresToPerUserLocations = localSecurityOptionsVirtualizeFileAndRegistryWriteFailuresToPerUserLocations;
        return _x;
    }

    /**
     * <i>“Allows IT Admins to control whether users can can ignore SmartScreen warnings
     * and run malicious files.”</i>
     * 
     * @return property smartScreenBlockOverrideForFiles
     */
    @Property(name="smartScreenBlockOverrideForFiles")
    @JsonIgnore
    public Optional<Boolean> getSmartScreenBlockOverrideForFiles() {
        return Optional.ofNullable(smartScreenBlockOverrideForFiles);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * smartScreenBlockOverrideForFiles} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Allows IT Admins to control whether users can can ignore SmartScreen warnings
     * and run malicious files.”</i>
     * 
     * @param smartScreenBlockOverrideForFiles
     *            new value of {@code smartScreenBlockOverrideForFiles} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code smartScreenBlockOverrideForFiles} field changed
     */
    public Windows10EndpointProtectionConfiguration withSmartScreenBlockOverrideForFiles(Boolean smartScreenBlockOverrideForFiles) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("smartScreenBlockOverrideForFiles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.smartScreenBlockOverrideForFiles = smartScreenBlockOverrideForFiles;
        return _x;
    }

    /**
     * <i>“Allows IT Admins to configure SmartScreen for Windows.”</i>
     * 
     * @return property smartScreenEnableInShell
     */
    @Property(name="smartScreenEnableInShell")
    @JsonIgnore
    public Optional<Boolean> getSmartScreenEnableInShell() {
        return Optional.ofNullable(smartScreenEnableInShell);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * smartScreenEnableInShell} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Allows IT Admins to configure SmartScreen for Windows.”</i>
     * 
     * @param smartScreenEnableInShell
     *            new value of {@code smartScreenEnableInShell} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code smartScreenEnableInShell} field changed
     */
    public Windows10EndpointProtectionConfiguration withSmartScreenEnableInShell(Boolean smartScreenEnableInShell) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("smartScreenEnableInShell");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.smartScreenEnableInShell = smartScreenEnableInShell;
        return _x;
    }

    /**
     * <i>“This user right is used by Credential Manager during Backup/Restore. Users'
     * saved credentials might be compromised if this privilege is given to other
     * entities. Only states NotConfigured and Allowed are supported”</i>
     * 
     * @return property userRightsAccessCredentialManagerAsTrustedCaller
     */
    @Property(name="userRightsAccessCredentialManagerAsTrustedCaller")
    @JsonIgnore
    public Optional<DeviceManagementUserRightsSetting> getUserRightsAccessCredentialManagerAsTrustedCaller() {
        return Optional.ofNullable(userRightsAccessCredentialManagerAsTrustedCaller);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userRightsAccessCredentialManagerAsTrustedCaller} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“This user right is used by Credential Manager during Backup/Restore. Users'
     * saved credentials might be compromised if this privilege is given to other
     * entities. Only states NotConfigured and Allowed are supported”</i>
     * 
     * @param userRightsAccessCredentialManagerAsTrustedCaller
     *            new value of {@code userRightsAccessCredentialManagerAsTrustedCaller} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userRightsAccessCredentialManagerAsTrustedCaller} field changed
     */
    public Windows10EndpointProtectionConfiguration withUserRightsAccessCredentialManagerAsTrustedCaller(DeviceManagementUserRightsSetting userRightsAccessCredentialManagerAsTrustedCaller) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userRightsAccessCredentialManagerAsTrustedCaller");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.userRightsAccessCredentialManagerAsTrustedCaller = userRightsAccessCredentialManagerAsTrustedCaller;
        return _x;
    }

    /**
     * <i>“This user right allows a process to impersonate any user without authentication.
     * The process can therefore gain access to the same local resources as that user.
     * Only states NotConfigured and Allowed are supported”</i>
     * 
     * @return property userRightsActAsPartOfTheOperatingSystem
     */
    @Property(name="userRightsActAsPartOfTheOperatingSystem")
    @JsonIgnore
    public Optional<DeviceManagementUserRightsSetting> getUserRightsActAsPartOfTheOperatingSystem() {
        return Optional.ofNullable(userRightsActAsPartOfTheOperatingSystem);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userRightsActAsPartOfTheOperatingSystem} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“This user right allows a process to impersonate any user without authentication.
     * The process can therefore gain access to the same local resources as that user.
     * Only states NotConfigured and Allowed are supported”</i>
     * 
     * @param userRightsActAsPartOfTheOperatingSystem
     *            new value of {@code userRightsActAsPartOfTheOperatingSystem} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userRightsActAsPartOfTheOperatingSystem} field changed
     */
    public Windows10EndpointProtectionConfiguration withUserRightsActAsPartOfTheOperatingSystem(DeviceManagementUserRightsSetting userRightsActAsPartOfTheOperatingSystem) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userRightsActAsPartOfTheOperatingSystem");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.userRightsActAsPartOfTheOperatingSystem = userRightsActAsPartOfTheOperatingSystem;
        return _x;
    }

    /**
     * <i>“This user right determines which users and groups are allowed to connect to the
     * computer over the network. State Allowed is supported.”</i>
     * 
     * @return property userRightsAllowAccessFromNetwork
     */
    @Property(name="userRightsAllowAccessFromNetwork")
    @JsonIgnore
    public Optional<DeviceManagementUserRightsSetting> getUserRightsAllowAccessFromNetwork() {
        return Optional.ofNullable(userRightsAllowAccessFromNetwork);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userRightsAllowAccessFromNetwork} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“This user right determines which users and groups are allowed to connect to the
     * computer over the network. State Allowed is supported.”</i>
     * 
     * @param userRightsAllowAccessFromNetwork
     *            new value of {@code userRightsAllowAccessFromNetwork} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userRightsAllowAccessFromNetwork} field changed
     */
    public Windows10EndpointProtectionConfiguration withUserRightsAllowAccessFromNetwork(DeviceManagementUserRightsSetting userRightsAllowAccessFromNetwork) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userRightsAllowAccessFromNetwork");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.userRightsAllowAccessFromNetwork = userRightsAllowAccessFromNetwork;
        return _x;
    }

    /**
     * <i>“This user right determines which users can bypass file, directory, registry, and
     * other persistent objects permissions when backing up files and directories. Only
     * states NotConfigured and Allowed are supported”</i>
     * 
     * @return property userRightsBackupData
     */
    @Property(name="userRightsBackupData")
    @JsonIgnore
    public Optional<DeviceManagementUserRightsSetting> getUserRightsBackupData() {
        return Optional.ofNullable(userRightsBackupData);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userRightsBackupData} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“This user right determines which users can bypass file, directory, registry, and
     * other persistent objects permissions when backing up files and directories. Only
     * states NotConfigured and Allowed are supported”</i>
     * 
     * @param userRightsBackupData
     *            new value of {@code userRightsBackupData} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userRightsBackupData} field changed
     */
    public Windows10EndpointProtectionConfiguration withUserRightsBackupData(DeviceManagementUserRightsSetting userRightsBackupData) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userRightsBackupData");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.userRightsBackupData = userRightsBackupData;
        return _x;
    }

    /**
     * <i>“This user right determines which users and groups are block from connecting to
     * the computer over the network. State Block is supported.”</i>
     * 
     * @return property userRightsBlockAccessFromNetwork
     */
    @Property(name="userRightsBlockAccessFromNetwork")
    @JsonIgnore
    public Optional<DeviceManagementUserRightsSetting> getUserRightsBlockAccessFromNetwork() {
        return Optional.ofNullable(userRightsBlockAccessFromNetwork);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userRightsBlockAccessFromNetwork} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“This user right determines which users and groups are block from connecting to
     * the computer over the network. State Block is supported.”</i>
     * 
     * @param userRightsBlockAccessFromNetwork
     *            new value of {@code userRightsBlockAccessFromNetwork} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userRightsBlockAccessFromNetwork} field changed
     */
    public Windows10EndpointProtectionConfiguration withUserRightsBlockAccessFromNetwork(DeviceManagementUserRightsSetting userRightsBlockAccessFromNetwork) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userRightsBlockAccessFromNetwork");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.userRightsBlockAccessFromNetwork = userRightsBlockAccessFromNetwork;
        return _x;
    }

    /**
     * <i>“This user right determines which users and groups can change the time and date
     * on the internal clock of the computer. Only states NotConfigured and Allowed are
     * supported”</i>
     * 
     * @return property userRightsChangeSystemTime
     */
    @Property(name="userRightsChangeSystemTime")
    @JsonIgnore
    public Optional<DeviceManagementUserRightsSetting> getUserRightsChangeSystemTime() {
        return Optional.ofNullable(userRightsChangeSystemTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userRightsChangeSystemTime} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“This user right determines which users and groups can change the time and date
     * on the internal clock of the computer. Only states NotConfigured and Allowed are
     * supported”</i>
     * 
     * @param userRightsChangeSystemTime
     *            new value of {@code userRightsChangeSystemTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userRightsChangeSystemTime} field changed
     */
    public Windows10EndpointProtectionConfiguration withUserRightsChangeSystemTime(DeviceManagementUserRightsSetting userRightsChangeSystemTime) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userRightsChangeSystemTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.userRightsChangeSystemTime = userRightsChangeSystemTime;
        return _x;
    }

    /**
     * <i>“This security setting determines whether users can create global objects that
     * are available to all sessions. Users who can create global objects could affect
     * processes that run under other users' sessions, which could lead to application
     * failure or data corruption. Only states NotConfigured and Allowed are supported”</i>
     * 
     * @return property userRightsCreateGlobalObjects
     */
    @Property(name="userRightsCreateGlobalObjects")
    @JsonIgnore
    public Optional<DeviceManagementUserRightsSetting> getUserRightsCreateGlobalObjects() {
        return Optional.ofNullable(userRightsCreateGlobalObjects);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userRightsCreateGlobalObjects} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“This security setting determines whether users can create global objects that
     * are available to all sessions. Users who can create global objects could affect
     * processes that run under other users' sessions, which could lead to application
     * failure or data corruption. Only states NotConfigured and Allowed are supported”</i>
     * 
     * @param userRightsCreateGlobalObjects
     *            new value of {@code userRightsCreateGlobalObjects} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userRightsCreateGlobalObjects} field changed
     */
    public Windows10EndpointProtectionConfiguration withUserRightsCreateGlobalObjects(DeviceManagementUserRightsSetting userRightsCreateGlobalObjects) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userRightsCreateGlobalObjects");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.userRightsCreateGlobalObjects = userRightsCreateGlobalObjects;
        return _x;
    }

    /**
     * <i>“This user right determines which users and groups can call an internal API to
     * create and change the size of a page file. Only states NotConfigured and Allowed
     * are supported”</i>
     * 
     * @return property userRightsCreatePageFile
     */
    @Property(name="userRightsCreatePageFile")
    @JsonIgnore
    public Optional<DeviceManagementUserRightsSetting> getUserRightsCreatePageFile() {
        return Optional.ofNullable(userRightsCreatePageFile);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userRightsCreatePageFile} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“This user right determines which users and groups can call an internal API to
     * create and change the size of a page file. Only states NotConfigured and Allowed
     * are supported”</i>
     * 
     * @param userRightsCreatePageFile
     *            new value of {@code userRightsCreatePageFile} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userRightsCreatePageFile} field changed
     */
    public Windows10EndpointProtectionConfiguration withUserRightsCreatePageFile(DeviceManagementUserRightsSetting userRightsCreatePageFile) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userRightsCreatePageFile");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.userRightsCreatePageFile = userRightsCreatePageFile;
        return _x;
    }

    /**
     * <i>“This user right determines which accounts can be used by processes to create a
     * directory object using the object manager. Only states NotConfigured and Allowed
     * are supported”</i>
     * 
     * @return property userRightsCreatePermanentSharedObjects
     */
    @Property(name="userRightsCreatePermanentSharedObjects")
    @JsonIgnore
    public Optional<DeviceManagementUserRightsSetting> getUserRightsCreatePermanentSharedObjects() {
        return Optional.ofNullable(userRightsCreatePermanentSharedObjects);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userRightsCreatePermanentSharedObjects} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“This user right determines which accounts can be used by processes to create a
     * directory object using the object manager. Only states NotConfigured and Allowed
     * are supported”</i>
     * 
     * @param userRightsCreatePermanentSharedObjects
     *            new value of {@code userRightsCreatePermanentSharedObjects} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userRightsCreatePermanentSharedObjects} field changed
     */
    public Windows10EndpointProtectionConfiguration withUserRightsCreatePermanentSharedObjects(DeviceManagementUserRightsSetting userRightsCreatePermanentSharedObjects) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userRightsCreatePermanentSharedObjects");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.userRightsCreatePermanentSharedObjects = userRightsCreatePermanentSharedObjects;
        return _x;
    }

    /**
     * <i>“This user right determines if the user can create a symbolic link from the
     * computer to which they are logged on. Only states NotConfigured and Allowed are
     * supported”</i>
     * 
     * @return property userRightsCreateSymbolicLinks
     */
    @Property(name="userRightsCreateSymbolicLinks")
    @JsonIgnore
    public Optional<DeviceManagementUserRightsSetting> getUserRightsCreateSymbolicLinks() {
        return Optional.ofNullable(userRightsCreateSymbolicLinks);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userRightsCreateSymbolicLinks} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“This user right determines if the user can create a symbolic link from the
     * computer to which they are logged on. Only states NotConfigured and Allowed are
     * supported”</i>
     * 
     * @param userRightsCreateSymbolicLinks
     *            new value of {@code userRightsCreateSymbolicLinks} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userRightsCreateSymbolicLinks} field changed
     */
    public Windows10EndpointProtectionConfiguration withUserRightsCreateSymbolicLinks(DeviceManagementUserRightsSetting userRightsCreateSymbolicLinks) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userRightsCreateSymbolicLinks");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.userRightsCreateSymbolicLinks = userRightsCreateSymbolicLinks;
        return _x;
    }

    /**
     * <i>“This user right determines which users/groups can be used by processes to create
     * a token that can then be used to get access to any local resources when the
     * process uses an internal API to create an access token. Only states
     * NotConfigured and Allowed are supported”</i>
     * 
     * @return property userRightsCreateToken
     */
    @Property(name="userRightsCreateToken")
    @JsonIgnore
    public Optional<DeviceManagementUserRightsSetting> getUserRightsCreateToken() {
        return Optional.ofNullable(userRightsCreateToken);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userRightsCreateToken} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“This user right determines which users/groups can be used by processes to create
     * a token that can then be used to get access to any local resources when the
     * process uses an internal API to create an access token. Only states
     * NotConfigured and Allowed are supported”</i>
     * 
     * @param userRightsCreateToken
     *            new value of {@code userRightsCreateToken} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userRightsCreateToken} field changed
     */
    public Windows10EndpointProtectionConfiguration withUserRightsCreateToken(DeviceManagementUserRightsSetting userRightsCreateToken) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userRightsCreateToken");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.userRightsCreateToken = userRightsCreateToken;
        return _x;
    }

    /**
     * <i>“This user right determines which users can attach a debugger to any process or
     * to the kernel. Only states NotConfigured and Allowed are supported”</i>
     * 
     * @return property userRightsDebugPrograms
     */
    @Property(name="userRightsDebugPrograms")
    @JsonIgnore
    public Optional<DeviceManagementUserRightsSetting> getUserRightsDebugPrograms() {
        return Optional.ofNullable(userRightsDebugPrograms);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userRightsDebugPrograms} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“This user right determines which users can attach a debugger to any process or
     * to the kernel. Only states NotConfigured and Allowed are supported”</i>
     * 
     * @param userRightsDebugPrograms
     *            new value of {@code userRightsDebugPrograms} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userRightsDebugPrograms} field changed
     */
    public Windows10EndpointProtectionConfiguration withUserRightsDebugPrograms(DeviceManagementUserRightsSetting userRightsDebugPrograms) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userRightsDebugPrograms");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.userRightsDebugPrograms = userRightsDebugPrograms;
        return _x;
    }

    /**
     * <i>“This user right determines which users can set the Trusted for Delegation
     * setting on a user or computer object. Only states NotConfigured and Allowed are
     * supported.”</i>
     * 
     * @return property userRightsDelegation
     */
    @Property(name="userRightsDelegation")
    @JsonIgnore
    public Optional<DeviceManagementUserRightsSetting> getUserRightsDelegation() {
        return Optional.ofNullable(userRightsDelegation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userRightsDelegation} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“This user right determines which users can set the Trusted for Delegation
     * setting on a user or computer object. Only states NotConfigured and Allowed are
     * supported.”</i>
     * 
     * @param userRightsDelegation
     *            new value of {@code userRightsDelegation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userRightsDelegation} field changed
     */
    public Windows10EndpointProtectionConfiguration withUserRightsDelegation(DeviceManagementUserRightsSetting userRightsDelegation) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userRightsDelegation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.userRightsDelegation = userRightsDelegation;
        return _x;
    }

    /**
     * <i>“This user right determines which users cannot log on to the computer. States
     * NotConfigured, Blocked are supported”</i>
     * 
     * @return property userRightsDenyLocalLogOn
     */
    @Property(name="userRightsDenyLocalLogOn")
    @JsonIgnore
    public Optional<DeviceManagementUserRightsSetting> getUserRightsDenyLocalLogOn() {
        return Optional.ofNullable(userRightsDenyLocalLogOn);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userRightsDenyLocalLogOn} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“This user right determines which users cannot log on to the computer. States
     * NotConfigured, Blocked are supported”</i>
     * 
     * @param userRightsDenyLocalLogOn
     *            new value of {@code userRightsDenyLocalLogOn} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userRightsDenyLocalLogOn} field changed
     */
    public Windows10EndpointProtectionConfiguration withUserRightsDenyLocalLogOn(DeviceManagementUserRightsSetting userRightsDenyLocalLogOn) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userRightsDenyLocalLogOn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.userRightsDenyLocalLogOn = userRightsDenyLocalLogOn;
        return _x;
    }

    /**
     * <i>“This user right determines which accounts can be used by a process to add
     * entries to the security log. The security log is used to trace unauthorized
     * system access.  Only states NotConfigured and Allowed are supported.”</i>
     * 
     * @return property userRightsGenerateSecurityAudits
     */
    @Property(name="userRightsGenerateSecurityAudits")
    @JsonIgnore
    public Optional<DeviceManagementUserRightsSetting> getUserRightsGenerateSecurityAudits() {
        return Optional.ofNullable(userRightsGenerateSecurityAudits);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userRightsGenerateSecurityAudits} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“This user right determines which accounts can be used by a process to add
     * entries to the security log. The security log is used to trace unauthorized
     * system access.  Only states NotConfigured and Allowed are supported.”</i>
     * 
     * @param userRightsGenerateSecurityAudits
     *            new value of {@code userRightsGenerateSecurityAudits} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userRightsGenerateSecurityAudits} field changed
     */
    public Windows10EndpointProtectionConfiguration withUserRightsGenerateSecurityAudits(DeviceManagementUserRightsSetting userRightsGenerateSecurityAudits) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userRightsGenerateSecurityAudits");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.userRightsGenerateSecurityAudits = userRightsGenerateSecurityAudits;
        return _x;
    }

    /**
     * <i>“Assigning this user right to a user allows programs running on behalf of that
     * user to impersonate a client. Requiring this user right for this kind of
     * impersonation prevents an unauthorized user from convincing a client to connect
     * to a service that they have created and then impersonating that client, which
     * can elevate the unauthorized user's permissions to administrative or system
     * levels. Only states NotConfigured and Allowed are supported.”</i>
     * 
     * @return property userRightsImpersonateClient
     */
    @Property(name="userRightsImpersonateClient")
    @JsonIgnore
    public Optional<DeviceManagementUserRightsSetting> getUserRightsImpersonateClient() {
        return Optional.ofNullable(userRightsImpersonateClient);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userRightsImpersonateClient} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Assigning this user right to a user allows programs running on behalf of that
     * user to impersonate a client. Requiring this user right for this kind of
     * impersonation prevents an unauthorized user from convincing a client to connect
     * to a service that they have created and then impersonating that client, which
     * can elevate the unauthorized user's permissions to administrative or system
     * levels. Only states NotConfigured and Allowed are supported.”</i>
     * 
     * @param userRightsImpersonateClient
     *            new value of {@code userRightsImpersonateClient} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userRightsImpersonateClient} field changed
     */
    public Windows10EndpointProtectionConfiguration withUserRightsImpersonateClient(DeviceManagementUserRightsSetting userRightsImpersonateClient) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userRightsImpersonateClient");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.userRightsImpersonateClient = userRightsImpersonateClient;
        return _x;
    }

    /**
     * <i>“This user right determines which accounts can use a process with Write Property
     * access to another process to increase the execution priority assigned to the
     * other process. Only states NotConfigured and Allowed are supported.”</i>
     * 
     * @return property userRightsIncreaseSchedulingPriority
     */
    @Property(name="userRightsIncreaseSchedulingPriority")
    @JsonIgnore
    public Optional<DeviceManagementUserRightsSetting> getUserRightsIncreaseSchedulingPriority() {
        return Optional.ofNullable(userRightsIncreaseSchedulingPriority);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userRightsIncreaseSchedulingPriority} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“This user right determines which accounts can use a process with Write Property
     * access to another process to increase the execution priority assigned to the
     * other process. Only states NotConfigured and Allowed are supported.”</i>
     * 
     * @param userRightsIncreaseSchedulingPriority
     *            new value of {@code userRightsIncreaseSchedulingPriority} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userRightsIncreaseSchedulingPriority} field changed
     */
    public Windows10EndpointProtectionConfiguration withUserRightsIncreaseSchedulingPriority(DeviceManagementUserRightsSetting userRightsIncreaseSchedulingPriority) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userRightsIncreaseSchedulingPriority");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.userRightsIncreaseSchedulingPriority = userRightsIncreaseSchedulingPriority;
        return _x;
    }

    /**
     * <i>“This user right determines which users can dynamically load and unload device
     * drivers or other code in to kernel mode. Only states NotConfigured and Allowed
     * are supported.”</i>
     * 
     * @return property userRightsLoadUnloadDrivers
     */
    @Property(name="userRightsLoadUnloadDrivers")
    @JsonIgnore
    public Optional<DeviceManagementUserRightsSetting> getUserRightsLoadUnloadDrivers() {
        return Optional.ofNullable(userRightsLoadUnloadDrivers);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userRightsLoadUnloadDrivers} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“This user right determines which users can dynamically load and unload device
     * drivers or other code in to kernel mode. Only states NotConfigured and Allowed
     * are supported.”</i>
     * 
     * @param userRightsLoadUnloadDrivers
     *            new value of {@code userRightsLoadUnloadDrivers} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userRightsLoadUnloadDrivers} field changed
     */
    public Windows10EndpointProtectionConfiguration withUserRightsLoadUnloadDrivers(DeviceManagementUserRightsSetting userRightsLoadUnloadDrivers) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userRightsLoadUnloadDrivers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.userRightsLoadUnloadDrivers = userRightsLoadUnloadDrivers;
        return _x;
    }

    /**
     * <i>“This user right determines which users can log on to the computer. States
     * NotConfigured, Allowed are supported”</i>
     * 
     * @return property userRightsLocalLogOn
     */
    @Property(name="userRightsLocalLogOn")
    @JsonIgnore
    public Optional<DeviceManagementUserRightsSetting> getUserRightsLocalLogOn() {
        return Optional.ofNullable(userRightsLocalLogOn);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userRightsLocalLogOn} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“This user right determines which users can log on to the computer. States
     * NotConfigured, Allowed are supported”</i>
     * 
     * @param userRightsLocalLogOn
     *            new value of {@code userRightsLocalLogOn} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userRightsLocalLogOn} field changed
     */
    public Windows10EndpointProtectionConfiguration withUserRightsLocalLogOn(DeviceManagementUserRightsSetting userRightsLocalLogOn) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userRightsLocalLogOn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.userRightsLocalLogOn = userRightsLocalLogOn;
        return _x;
    }

    /**
     * <i>“This user right determines which accounts can use a process to keep data in
     * physical memory, which prevents the system from paging the data to virtual
     * memory on disk. Only states NotConfigured and Allowed are supported.”</i>
     * 
     * @return property userRightsLockMemory
     */
    @Property(name="userRightsLockMemory")
    @JsonIgnore
    public Optional<DeviceManagementUserRightsSetting> getUserRightsLockMemory() {
        return Optional.ofNullable(userRightsLockMemory);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userRightsLockMemory} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“This user right determines which accounts can use a process to keep data in
     * physical memory, which prevents the system from paging the data to virtual
     * memory on disk. Only states NotConfigured and Allowed are supported.”</i>
     * 
     * @param userRightsLockMemory
     *            new value of {@code userRightsLockMemory} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userRightsLockMemory} field changed
     */
    public Windows10EndpointProtectionConfiguration withUserRightsLockMemory(DeviceManagementUserRightsSetting userRightsLockMemory) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userRightsLockMemory");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.userRightsLockMemory = userRightsLockMemory;
        return _x;
    }

    /**
     * <i>“This user right determines which users can specify object access auditing
     * options for individual resources, such as files, Active Directory objects, and
     * registry keys. Only states NotConfigured and Allowed are supported.”</i>
     * 
     * @return property userRightsManageAuditingAndSecurityLogs
     */
    @Property(name="userRightsManageAuditingAndSecurityLogs")
    @JsonIgnore
    public Optional<DeviceManagementUserRightsSetting> getUserRightsManageAuditingAndSecurityLogs() {
        return Optional.ofNullable(userRightsManageAuditingAndSecurityLogs);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userRightsManageAuditingAndSecurityLogs} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“This user right determines which users can specify object access auditing
     * options for individual resources, such as files, Active Directory objects, and
     * registry keys. Only states NotConfigured and Allowed are supported.”</i>
     * 
     * @param userRightsManageAuditingAndSecurityLogs
     *            new value of {@code userRightsManageAuditingAndSecurityLogs} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userRightsManageAuditingAndSecurityLogs} field changed
     */
    public Windows10EndpointProtectionConfiguration withUserRightsManageAuditingAndSecurityLogs(DeviceManagementUserRightsSetting userRightsManageAuditingAndSecurityLogs) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userRightsManageAuditingAndSecurityLogs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.userRightsManageAuditingAndSecurityLogs = userRightsManageAuditingAndSecurityLogs;
        return _x;
    }

    /**
     * <i>“This user right determines which users and groups can run maintenance tasks on a
     * volume, such as remote defragmentation. Only states NotConfigured and Allowed
     * are supported.”</i>
     * 
     * @return property userRightsManageVolumes
     */
    @Property(name="userRightsManageVolumes")
    @JsonIgnore
    public Optional<DeviceManagementUserRightsSetting> getUserRightsManageVolumes() {
        return Optional.ofNullable(userRightsManageVolumes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userRightsManageVolumes} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“This user right determines which users and groups can run maintenance tasks on a
     * volume, such as remote defragmentation. Only states NotConfigured and Allowed
     * are supported.”</i>
     * 
     * @param userRightsManageVolumes
     *            new value of {@code userRightsManageVolumes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userRightsManageVolumes} field changed
     */
    public Windows10EndpointProtectionConfiguration withUserRightsManageVolumes(DeviceManagementUserRightsSetting userRightsManageVolumes) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userRightsManageVolumes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.userRightsManageVolumes = userRightsManageVolumes;
        return _x;
    }

    /**
     * <i>“This user right determines who can modify firmware environment values. Only
     * states NotConfigured and Allowed are supported.”</i>
     * 
     * @return property userRightsModifyFirmwareEnvironment
     */
    @Property(name="userRightsModifyFirmwareEnvironment")
    @JsonIgnore
    public Optional<DeviceManagementUserRightsSetting> getUserRightsModifyFirmwareEnvironment() {
        return Optional.ofNullable(userRightsModifyFirmwareEnvironment);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userRightsModifyFirmwareEnvironment} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“This user right determines who can modify firmware environment values. Only
     * states NotConfigured and Allowed are supported.”</i>
     * 
     * @param userRightsModifyFirmwareEnvironment
     *            new value of {@code userRightsModifyFirmwareEnvironment} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userRightsModifyFirmwareEnvironment} field changed
     */
    public Windows10EndpointProtectionConfiguration withUserRightsModifyFirmwareEnvironment(DeviceManagementUserRightsSetting userRightsModifyFirmwareEnvironment) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userRightsModifyFirmwareEnvironment");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.userRightsModifyFirmwareEnvironment = userRightsModifyFirmwareEnvironment;
        return _x;
    }

    /**
     * <i>“This user right determines which user accounts can modify the integrity label of
     * objects, such as files, registry keys, or processes owned by other users. Only
     * states NotConfigured and Allowed are supported.”</i>
     * 
     * @return property userRightsModifyObjectLabels
     */
    @Property(name="userRightsModifyObjectLabels")
    @JsonIgnore
    public Optional<DeviceManagementUserRightsSetting> getUserRightsModifyObjectLabels() {
        return Optional.ofNullable(userRightsModifyObjectLabels);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userRightsModifyObjectLabels} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“This user right determines which user accounts can modify the integrity label of
     * objects, such as files, registry keys, or processes owned by other users. Only
     * states NotConfigured and Allowed are supported.”</i>
     * 
     * @param userRightsModifyObjectLabels
     *            new value of {@code userRightsModifyObjectLabels} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userRightsModifyObjectLabels} field changed
     */
    public Windows10EndpointProtectionConfiguration withUserRightsModifyObjectLabels(DeviceManagementUserRightsSetting userRightsModifyObjectLabels) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userRightsModifyObjectLabels");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.userRightsModifyObjectLabels = userRightsModifyObjectLabels;
        return _x;
    }

    /**
     * <i>“This user right determines which users can use performance monitoring tools to
     * monitor the performance of system processes. Only states NotConfigured and
     * Allowed are supported.”</i>
     * 
     * @return property userRightsProfileSingleProcess
     */
    @Property(name="userRightsProfileSingleProcess")
    @JsonIgnore
    public Optional<DeviceManagementUserRightsSetting> getUserRightsProfileSingleProcess() {
        return Optional.ofNullable(userRightsProfileSingleProcess);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userRightsProfileSingleProcess} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“This user right determines which users can use performance monitoring tools to
     * monitor the performance of system processes. Only states NotConfigured and
     * Allowed are supported.”</i>
     * 
     * @param userRightsProfileSingleProcess
     *            new value of {@code userRightsProfileSingleProcess} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userRightsProfileSingleProcess} field changed
     */
    public Windows10EndpointProtectionConfiguration withUserRightsProfileSingleProcess(DeviceManagementUserRightsSetting userRightsProfileSingleProcess) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userRightsProfileSingleProcess");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.userRightsProfileSingleProcess = userRightsProfileSingleProcess;
        return _x;
    }

    /**
     * <i>“This user right determines which users and groups are prohibited from logging on
     * as a Remote Desktop Services client. Only states NotConfigured and Blocked are
     * supported”</i>
     * 
     * @return property userRightsRemoteDesktopServicesLogOn
     */
    @Property(name="userRightsRemoteDesktopServicesLogOn")
    @JsonIgnore
    public Optional<DeviceManagementUserRightsSetting> getUserRightsRemoteDesktopServicesLogOn() {
        return Optional.ofNullable(userRightsRemoteDesktopServicesLogOn);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userRightsRemoteDesktopServicesLogOn} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“This user right determines which users and groups are prohibited from logging on
     * as a Remote Desktop Services client. Only states NotConfigured and Blocked are
     * supported”</i>
     * 
     * @param userRightsRemoteDesktopServicesLogOn
     *            new value of {@code userRightsRemoteDesktopServicesLogOn} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userRightsRemoteDesktopServicesLogOn} field changed
     */
    public Windows10EndpointProtectionConfiguration withUserRightsRemoteDesktopServicesLogOn(DeviceManagementUserRightsSetting userRightsRemoteDesktopServicesLogOn) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userRightsRemoteDesktopServicesLogOn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.userRightsRemoteDesktopServicesLogOn = userRightsRemoteDesktopServicesLogOn;
        return _x;
    }

    /**
     * <i>“This user right determines which users are allowed to shut down a computer from
     * a remote location on the network. Misuse of this user right can result in a
     * denial of service. Only states NotConfigured and Allowed are supported.”</i>
     * 
     * @return property userRightsRemoteShutdown
     */
    @Property(name="userRightsRemoteShutdown")
    @JsonIgnore
    public Optional<DeviceManagementUserRightsSetting> getUserRightsRemoteShutdown() {
        return Optional.ofNullable(userRightsRemoteShutdown);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userRightsRemoteShutdown} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“This user right determines which users are allowed to shut down a computer from
     * a remote location on the network. Misuse of this user right can result in a
     * denial of service. Only states NotConfigured and Allowed are supported.”</i>
     * 
     * @param userRightsRemoteShutdown
     *            new value of {@code userRightsRemoteShutdown} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userRightsRemoteShutdown} field changed
     */
    public Windows10EndpointProtectionConfiguration withUserRightsRemoteShutdown(DeviceManagementUserRightsSetting userRightsRemoteShutdown) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userRightsRemoteShutdown");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.userRightsRemoteShutdown = userRightsRemoteShutdown;
        return _x;
    }

    /**
     * <i>“This user right determines which users can bypass file, directory, registry, and
     * other persistent objects permissions when restoring backed up files and
     * directories, and determines which users can set any valid security principal as
     * the owner of an object. Only states NotConfigured and Allowed are supported.”</i>
     * 
     * @return property userRightsRestoreData
     */
    @Property(name="userRightsRestoreData")
    @JsonIgnore
    public Optional<DeviceManagementUserRightsSetting> getUserRightsRestoreData() {
        return Optional.ofNullable(userRightsRestoreData);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userRightsRestoreData} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“This user right determines which users can bypass file, directory, registry, and
     * other persistent objects permissions when restoring backed up files and
     * directories, and determines which users can set any valid security principal as
     * the owner of an object. Only states NotConfigured and Allowed are supported.”</i>
     * 
     * @param userRightsRestoreData
     *            new value of {@code userRightsRestoreData} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userRightsRestoreData} field changed
     */
    public Windows10EndpointProtectionConfiguration withUserRightsRestoreData(DeviceManagementUserRightsSetting userRightsRestoreData) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userRightsRestoreData");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.userRightsRestoreData = userRightsRestoreData;
        return _x;
    }

    /**
     * <i>“This user right determines which users can take ownership of any securable
     * object in the system, including Active Directory objects, files and folders,
     * printers, registry keys, processes, and threads. Only states NotConfigured and
     * Allowed are supported.”</i>
     * 
     * @return property userRightsTakeOwnership
     */
    @Property(name="userRightsTakeOwnership")
    @JsonIgnore
    public Optional<DeviceManagementUserRightsSetting> getUserRightsTakeOwnership() {
        return Optional.ofNullable(userRightsTakeOwnership);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userRightsTakeOwnership} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“This user right determines which users can take ownership of any securable
     * object in the system, including Active Directory objects, files and folders,
     * printers, registry keys, processes, and threads. Only states NotConfigured and
     * Allowed are supported.”</i>
     * 
     * @param userRightsTakeOwnership
     *            new value of {@code userRightsTakeOwnership} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userRightsTakeOwnership} field changed
     */
    public Windows10EndpointProtectionConfiguration withUserRightsTakeOwnership(DeviceManagementUserRightsSetting userRightsTakeOwnership) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userRightsTakeOwnership");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.userRightsTakeOwnership = userRightsTakeOwnership;
        return _x;
    }

    /**
     * <i>“Configure windows defender TamperProtection settings”</i>
     * 
     * @return property windowsDefenderTamperProtection
     */
    @Property(name="windowsDefenderTamperProtection")
    @JsonIgnore
    public Optional<WindowsDefenderTamperProtectionOptions> getWindowsDefenderTamperProtection() {
        return Optional.ofNullable(windowsDefenderTamperProtection);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsDefenderTamperProtection} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Configure windows defender TamperProtection settings”</i>
     * 
     * @param windowsDefenderTamperProtection
     *            new value of {@code windowsDefenderTamperProtection} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsDefenderTamperProtection} field changed
     */
    public Windows10EndpointProtectionConfiguration withWindowsDefenderTamperProtection(WindowsDefenderTamperProtectionOptions windowsDefenderTamperProtection) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("windowsDefenderTamperProtection");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.windowsDefenderTamperProtection = windowsDefenderTamperProtection;
        return _x;
    }

    /**
     * <i>“This setting determines whether the Accessory management service's start type is
     * Automatic(2), Manual(3), Disabled(4). Default: Manual.”</i>
     * 
     * @return property xboxServicesAccessoryManagementServiceStartupMode
     */
    @Property(name="xboxServicesAccessoryManagementServiceStartupMode")
    @JsonIgnore
    public Optional<ServiceStartType> getXboxServicesAccessoryManagementServiceStartupMode() {
        return Optional.ofNullable(xboxServicesAccessoryManagementServiceStartupMode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * xboxServicesAccessoryManagementServiceStartupMode} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“This setting determines whether the Accessory management service's start type is
     * Automatic(2), Manual(3), Disabled(4). Default: Manual.”</i>
     * 
     * @param xboxServicesAccessoryManagementServiceStartupMode
     *            new value of {@code xboxServicesAccessoryManagementServiceStartupMode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code xboxServicesAccessoryManagementServiceStartupMode} field changed
     */
    public Windows10EndpointProtectionConfiguration withXboxServicesAccessoryManagementServiceStartupMode(ServiceStartType xboxServicesAccessoryManagementServiceStartupMode) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("xboxServicesAccessoryManagementServiceStartupMode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.xboxServicesAccessoryManagementServiceStartupMode = xboxServicesAccessoryManagementServiceStartupMode;
        return _x;
    }

    /**
     * <i>“This setting determines whether xbox game save is enabled (1) or disabled (0).”</i>
     * 
     * @return property xboxServicesEnableXboxGameSaveTask
     */
    @Property(name="xboxServicesEnableXboxGameSaveTask")
    @JsonIgnore
    public Optional<Boolean> getXboxServicesEnableXboxGameSaveTask() {
        return Optional.ofNullable(xboxServicesEnableXboxGameSaveTask);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * xboxServicesEnableXboxGameSaveTask} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“This setting determines whether xbox game save is enabled (1) or disabled (0).”</i>
     * 
     * @param xboxServicesEnableXboxGameSaveTask
     *            new value of {@code xboxServicesEnableXboxGameSaveTask} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code xboxServicesEnableXboxGameSaveTask} field changed
     */
    public Windows10EndpointProtectionConfiguration withXboxServicesEnableXboxGameSaveTask(Boolean xboxServicesEnableXboxGameSaveTask) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("xboxServicesEnableXboxGameSaveTask");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.xboxServicesEnableXboxGameSaveTask = xboxServicesEnableXboxGameSaveTask;
        return _x;
    }

    /**
     * <i>“This setting determines whether Live Auth Manager service's start type is
     * Automatic(2), Manual(3), Disabled(4). Default: Manual.”</i>
     * 
     * @return property xboxServicesLiveAuthManagerServiceStartupMode
     */
    @Property(name="xboxServicesLiveAuthManagerServiceStartupMode")
    @JsonIgnore
    public Optional<ServiceStartType> getXboxServicesLiveAuthManagerServiceStartupMode() {
        return Optional.ofNullable(xboxServicesLiveAuthManagerServiceStartupMode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * xboxServicesLiveAuthManagerServiceStartupMode} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“This setting determines whether Live Auth Manager service's start type is
     * Automatic(2), Manual(3), Disabled(4). Default: Manual.”</i>
     * 
     * @param xboxServicesLiveAuthManagerServiceStartupMode
     *            new value of {@code xboxServicesLiveAuthManagerServiceStartupMode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code xboxServicesLiveAuthManagerServiceStartupMode} field changed
     */
    public Windows10EndpointProtectionConfiguration withXboxServicesLiveAuthManagerServiceStartupMode(ServiceStartType xboxServicesLiveAuthManagerServiceStartupMode) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("xboxServicesLiveAuthManagerServiceStartupMode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.xboxServicesLiveAuthManagerServiceStartupMode = xboxServicesLiveAuthManagerServiceStartupMode;
        return _x;
    }

    /**
     * <i>“This setting determines whether Live Game save service's start type is Automatic
     * (2), Manual(3), Disabled(4). Default: Manual.”</i>
     * 
     * @return property xboxServicesLiveGameSaveServiceStartupMode
     */
    @Property(name="xboxServicesLiveGameSaveServiceStartupMode")
    @JsonIgnore
    public Optional<ServiceStartType> getXboxServicesLiveGameSaveServiceStartupMode() {
        return Optional.ofNullable(xboxServicesLiveGameSaveServiceStartupMode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * xboxServicesLiveGameSaveServiceStartupMode} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“This setting determines whether Live Game save service's start type is Automatic
     * (2), Manual(3), Disabled(4). Default: Manual.”</i>
     * 
     * @param xboxServicesLiveGameSaveServiceStartupMode
     *            new value of {@code xboxServicesLiveGameSaveServiceStartupMode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code xboxServicesLiveGameSaveServiceStartupMode} field changed
     */
    public Windows10EndpointProtectionConfiguration withXboxServicesLiveGameSaveServiceStartupMode(ServiceStartType xboxServicesLiveGameSaveServiceStartupMode) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("xboxServicesLiveGameSaveServiceStartupMode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.xboxServicesLiveGameSaveServiceStartupMode = xboxServicesLiveGameSaveServiceStartupMode;
        return _x;
    }

    /**
     * <i>“This setting determines whether Networking service's start type is Automatic(2),
     * Manual(3), Disabled(4). Default: Manual.”</i>
     * 
     * @return property xboxServicesLiveNetworkingServiceStartupMode
     */
    @Property(name="xboxServicesLiveNetworkingServiceStartupMode")
    @JsonIgnore
    public Optional<ServiceStartType> getXboxServicesLiveNetworkingServiceStartupMode() {
        return Optional.ofNullable(xboxServicesLiveNetworkingServiceStartupMode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * xboxServicesLiveNetworkingServiceStartupMode} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“This setting determines whether Networking service's start type is Automatic(2),
     * Manual(3), Disabled(4). Default: Manual.”</i>
     * 
     * @param xboxServicesLiveNetworkingServiceStartupMode
     *            new value of {@code xboxServicesLiveNetworkingServiceStartupMode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code xboxServicesLiveNetworkingServiceStartupMode} field changed
     */
    public Windows10EndpointProtectionConfiguration withXboxServicesLiveNetworkingServiceStartupMode(ServiceStartType xboxServicesLiveNetworkingServiceStartupMode) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("xboxServicesLiveNetworkingServiceStartupMode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EndpointProtectionConfiguration");
        _x.xboxServicesLiveNetworkingServiceStartupMode = xboxServicesLiveNetworkingServiceStartupMode;
        return _x;
    }

    public Windows10EndpointProtectionConfiguration withUnmappedField(String name, Object value) {
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows10EndpointProtectionConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows10EndpointProtectionConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Windows10EndpointProtectionConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Windows10EndpointProtectionConfiguration _copy() {
        Windows10EndpointProtectionConfiguration _x = new Windows10EndpointProtectionConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.version = version;
        _x.assignments = assignments;
        _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
        _x.deviceStatuses = deviceStatuses;
        _x.deviceStatusOverview = deviceStatusOverview;
        _x.groupAssignments = groupAssignments;
        _x.userStatuses = userStatuses;
        _x.userStatusOverview = userStatusOverview;
        _x.applicationGuardAllowCameraMicrophoneRedirection = applicationGuardAllowCameraMicrophoneRedirection;
        _x.applicationGuardAllowFileSaveOnHost = applicationGuardAllowFileSaveOnHost;
        _x.applicationGuardAllowPersistence = applicationGuardAllowPersistence;
        _x.applicationGuardAllowPrintToLocalPrinters = applicationGuardAllowPrintToLocalPrinters;
        _x.applicationGuardAllowPrintToNetworkPrinters = applicationGuardAllowPrintToNetworkPrinters;
        _x.applicationGuardAllowPrintToPDF = applicationGuardAllowPrintToPDF;
        _x.applicationGuardAllowPrintToXPS = applicationGuardAllowPrintToXPS;
        _x.applicationGuardAllowVirtualGPU = applicationGuardAllowVirtualGPU;
        _x.applicationGuardBlockClipboardSharing = applicationGuardBlockClipboardSharing;
        _x.applicationGuardBlockFileTransfer = applicationGuardBlockFileTransfer;
        _x.applicationGuardBlockNonEnterpriseContent = applicationGuardBlockNonEnterpriseContent;
        _x.applicationGuardCertificateThumbprints = applicationGuardCertificateThumbprints;
        _x.applicationGuardEnabled = applicationGuardEnabled;
        _x.applicationGuardEnabledOptions = applicationGuardEnabledOptions;
        _x.applicationGuardForceAuditing = applicationGuardForceAuditing;
        _x.appLockerApplicationControl = appLockerApplicationControl;
        _x.bitLockerAllowStandardUserEncryption = bitLockerAllowStandardUserEncryption;
        _x.bitLockerDisableWarningForOtherDiskEncryption = bitLockerDisableWarningForOtherDiskEncryption;
        _x.bitLockerEnableStorageCardEncryptionOnMobile = bitLockerEnableStorageCardEncryptionOnMobile;
        _x.bitLockerEncryptDevice = bitLockerEncryptDevice;
        _x.bitLockerFixedDrivePolicy = bitLockerFixedDrivePolicy;
        _x.bitLockerRecoveryPasswordRotation = bitLockerRecoveryPasswordRotation;
        _x.bitLockerRemovableDrivePolicy = bitLockerRemovableDrivePolicy;
        _x.bitLockerSystemDrivePolicy = bitLockerSystemDrivePolicy;
        _x.defenderAdditionalGuardedFolders = defenderAdditionalGuardedFolders;
        _x.defenderAdobeReaderLaunchChildProcess = defenderAdobeReaderLaunchChildProcess;
        _x.defenderAdvancedRansomewareProtectionType = defenderAdvancedRansomewareProtectionType;
        _x.defenderAllowBehaviorMonitoring = defenderAllowBehaviorMonitoring;
        _x.defenderAllowCloudProtection = defenderAllowCloudProtection;
        _x.defenderAllowEndUserAccess = defenderAllowEndUserAccess;
        _x.defenderAllowIntrusionPreventionSystem = defenderAllowIntrusionPreventionSystem;
        _x.defenderAllowOnAccessProtection = defenderAllowOnAccessProtection;
        _x.defenderAllowRealTimeMonitoring = defenderAllowRealTimeMonitoring;
        _x.defenderAllowScanArchiveFiles = defenderAllowScanArchiveFiles;
        _x.defenderAllowScanDownloads = defenderAllowScanDownloads;
        _x.defenderAllowScanNetworkFiles = defenderAllowScanNetworkFiles;
        _x.defenderAllowScanRemovableDrivesDuringFullScan = defenderAllowScanRemovableDrivesDuringFullScan;
        _x.defenderAllowScanScriptsLoadedInInternetExplorer = defenderAllowScanScriptsLoadedInInternetExplorer;
        _x.defenderAttackSurfaceReductionExcludedPaths = defenderAttackSurfaceReductionExcludedPaths;
        _x.defenderBlockEndUserAccess = defenderBlockEndUserAccess;
        _x.defenderBlockPersistenceThroughWmiType = defenderBlockPersistenceThroughWmiType;
        _x.defenderCheckForSignaturesBeforeRunningScan = defenderCheckForSignaturesBeforeRunningScan;
        _x.defenderCloudBlockLevel = defenderCloudBlockLevel;
        _x.defenderCloudExtendedTimeoutInSeconds = defenderCloudExtendedTimeoutInSeconds;
        _x.defenderDaysBeforeDeletingQuarantinedMalware = defenderDaysBeforeDeletingQuarantinedMalware;
        _x.defenderDetectedMalwareActions = defenderDetectedMalwareActions;
        _x.defenderDisableBehaviorMonitoring = defenderDisableBehaviorMonitoring;
        _x.defenderDisableCatchupFullScan = defenderDisableCatchupFullScan;
        _x.defenderDisableCatchupQuickScan = defenderDisableCatchupQuickScan;
        _x.defenderDisableCloudProtection = defenderDisableCloudProtection;
        _x.defenderDisableIntrusionPreventionSystem = defenderDisableIntrusionPreventionSystem;
        _x.defenderDisableOnAccessProtection = defenderDisableOnAccessProtection;
        _x.defenderDisableRealTimeMonitoring = defenderDisableRealTimeMonitoring;
        _x.defenderDisableScanArchiveFiles = defenderDisableScanArchiveFiles;
        _x.defenderDisableScanDownloads = defenderDisableScanDownloads;
        _x.defenderDisableScanNetworkFiles = defenderDisableScanNetworkFiles;
        _x.defenderDisableScanRemovableDrivesDuringFullScan = defenderDisableScanRemovableDrivesDuringFullScan;
        _x.defenderDisableScanScriptsLoadedInInternetExplorer = defenderDisableScanScriptsLoadedInInternetExplorer;
        _x.defenderEmailContentExecution = defenderEmailContentExecution;
        _x.defenderEmailContentExecutionType = defenderEmailContentExecutionType;
        _x.defenderEnableLowCpuPriority = defenderEnableLowCpuPriority;
        _x.defenderEnableScanIncomingMail = defenderEnableScanIncomingMail;
        _x.defenderEnableScanMappedNetworkDrivesDuringFullScan = defenderEnableScanMappedNetworkDrivesDuringFullScan;
        _x.defenderExploitProtectionXml = defenderExploitProtectionXml;
        _x.defenderExploitProtectionXmlFileName = defenderExploitProtectionXmlFileName;
        _x.defenderFileExtensionsToExclude = defenderFileExtensionsToExclude;
        _x.defenderFilesAndFoldersToExclude = defenderFilesAndFoldersToExclude;
        _x.defenderGuardedFoldersAllowedAppPaths = defenderGuardedFoldersAllowedAppPaths;
        _x.defenderGuardMyFoldersType = defenderGuardMyFoldersType;
        _x.defenderNetworkProtectionType = defenderNetworkProtectionType;
        _x.defenderOfficeAppsExecutableContentCreationOrLaunch = defenderOfficeAppsExecutableContentCreationOrLaunch;
        _x.defenderOfficeAppsExecutableContentCreationOrLaunchType = defenderOfficeAppsExecutableContentCreationOrLaunchType;
        _x.defenderOfficeAppsLaunchChildProcess = defenderOfficeAppsLaunchChildProcess;
        _x.defenderOfficeAppsLaunchChildProcessType = defenderOfficeAppsLaunchChildProcessType;
        _x.defenderOfficeAppsOtherProcessInjection = defenderOfficeAppsOtherProcessInjection;
        _x.defenderOfficeAppsOtherProcessInjectionType = defenderOfficeAppsOtherProcessInjectionType;
        _x.defenderOfficeCommunicationAppsLaunchChildProcess = defenderOfficeCommunicationAppsLaunchChildProcess;
        _x.defenderOfficeMacroCodeAllowWin32Imports = defenderOfficeMacroCodeAllowWin32Imports;
        _x.defenderOfficeMacroCodeAllowWin32ImportsType = defenderOfficeMacroCodeAllowWin32ImportsType;
        _x.defenderPotentiallyUnwantedAppAction = defenderPotentiallyUnwantedAppAction;
        _x.defenderPreventCredentialStealingType = defenderPreventCredentialStealingType;
        _x.defenderProcessCreation = defenderProcessCreation;
        _x.defenderProcessCreationType = defenderProcessCreationType;
        _x.defenderProcessesToExclude = defenderProcessesToExclude;
        _x.defenderScanDirection = defenderScanDirection;
        _x.defenderScanMaxCpuPercentage = defenderScanMaxCpuPercentage;
        _x.defenderScanType = defenderScanType;
        _x.defenderScheduledQuickScanTime = defenderScheduledQuickScanTime;
        _x.defenderScheduledScanDay = defenderScheduledScanDay;
        _x.defenderScheduledScanTime = defenderScheduledScanTime;
        _x.defenderScriptDownloadedPayloadExecution = defenderScriptDownloadedPayloadExecution;
        _x.defenderScriptDownloadedPayloadExecutionType = defenderScriptDownloadedPayloadExecutionType;
        _x.defenderScriptObfuscatedMacroCode = defenderScriptObfuscatedMacroCode;
        _x.defenderScriptObfuscatedMacroCodeType = defenderScriptObfuscatedMacroCodeType;
        _x.defenderSecurityCenterBlockExploitProtectionOverride = defenderSecurityCenterBlockExploitProtectionOverride;
        _x.defenderSecurityCenterDisableAccountUI = defenderSecurityCenterDisableAccountUI;
        _x.defenderSecurityCenterDisableAppBrowserUI = defenderSecurityCenterDisableAppBrowserUI;
        _x.defenderSecurityCenterDisableClearTpmUI = defenderSecurityCenterDisableClearTpmUI;
        _x.defenderSecurityCenterDisableFamilyUI = defenderSecurityCenterDisableFamilyUI;
        _x.defenderSecurityCenterDisableHardwareUI = defenderSecurityCenterDisableHardwareUI;
        _x.defenderSecurityCenterDisableHealthUI = defenderSecurityCenterDisableHealthUI;
        _x.defenderSecurityCenterDisableNetworkUI = defenderSecurityCenterDisableNetworkUI;
        _x.defenderSecurityCenterDisableNotificationAreaUI = defenderSecurityCenterDisableNotificationAreaUI;
        _x.defenderSecurityCenterDisableRansomwareUI = defenderSecurityCenterDisableRansomwareUI;
        _x.defenderSecurityCenterDisableSecureBootUI = defenderSecurityCenterDisableSecureBootUI;
        _x.defenderSecurityCenterDisableTroubleshootingUI = defenderSecurityCenterDisableTroubleshootingUI;
        _x.defenderSecurityCenterDisableVirusUI = defenderSecurityCenterDisableVirusUI;
        _x.defenderSecurityCenterDisableVulnerableTpmFirmwareUpdateUI = defenderSecurityCenterDisableVulnerableTpmFirmwareUpdateUI;
        _x.defenderSecurityCenterHelpEmail = defenderSecurityCenterHelpEmail;
        _x.defenderSecurityCenterHelpPhone = defenderSecurityCenterHelpPhone;
        _x.defenderSecurityCenterHelpURL = defenderSecurityCenterHelpURL;
        _x.defenderSecurityCenterITContactDisplay = defenderSecurityCenterITContactDisplay;
        _x.defenderSecurityCenterNotificationsFromApp = defenderSecurityCenterNotificationsFromApp;
        _x.defenderSecurityCenterOrganizationDisplayName = defenderSecurityCenterOrganizationDisplayName;
        _x.defenderSignatureUpdateIntervalInHours = defenderSignatureUpdateIntervalInHours;
        _x.defenderSubmitSamplesConsentType = defenderSubmitSamplesConsentType;
        _x.defenderUntrustedExecutable = defenderUntrustedExecutable;
        _x.defenderUntrustedExecutableType = defenderUntrustedExecutableType;
        _x.defenderUntrustedUSBProcess = defenderUntrustedUSBProcess;
        _x.defenderUntrustedUSBProcessType = defenderUntrustedUSBProcessType;
        _x.deviceGuardEnableSecureBootWithDMA = deviceGuardEnableSecureBootWithDMA;
        _x.deviceGuardEnableVirtualizationBasedSecurity = deviceGuardEnableVirtualizationBasedSecurity;
        _x.deviceGuardLaunchSystemGuard = deviceGuardLaunchSystemGuard;
        _x.deviceGuardLocalSystemAuthorityCredentialGuardSettings = deviceGuardLocalSystemAuthorityCredentialGuardSettings;
        _x.deviceGuardSecureBootWithDMA = deviceGuardSecureBootWithDMA;
        _x.dmaGuardDeviceEnumerationPolicy = dmaGuardDeviceEnumerationPolicy;
        _x.firewallBlockStatefulFTP = firewallBlockStatefulFTP;
        _x.firewallCertificateRevocationListCheckMethod = firewallCertificateRevocationListCheckMethod;
        _x.firewallIdleTimeoutForSecurityAssociationInSeconds = firewallIdleTimeoutForSecurityAssociationInSeconds;
        _x.firewallIPSecExemptionsAllowDHCP = firewallIPSecExemptionsAllowDHCP;
        _x.firewallIPSecExemptionsAllowICMP = firewallIPSecExemptionsAllowICMP;
        _x.firewallIPSecExemptionsAllowNeighborDiscovery = firewallIPSecExemptionsAllowNeighborDiscovery;
        _x.firewallIPSecExemptionsAllowRouterDiscovery = firewallIPSecExemptionsAllowRouterDiscovery;
        _x.firewallIPSecExemptionsNone = firewallIPSecExemptionsNone;
        _x.firewallMergeKeyingModuleSettings = firewallMergeKeyingModuleSettings;
        _x.firewallPacketQueueingMethod = firewallPacketQueueingMethod;
        _x.firewallPreSharedKeyEncodingMethod = firewallPreSharedKeyEncodingMethod;
        _x.firewallProfileDomain = firewallProfileDomain;
        _x.firewallProfilePrivate = firewallProfilePrivate;
        _x.firewallProfilePublic = firewallProfilePublic;
        _x.firewallRules = firewallRules;
        _x.lanManagerAuthenticationLevel = lanManagerAuthenticationLevel;
        _x.lanManagerWorkstationDisableInsecureGuestLogons = lanManagerWorkstationDisableInsecureGuestLogons;
        _x.localSecurityOptionsAdministratorAccountName = localSecurityOptionsAdministratorAccountName;
        _x.localSecurityOptionsAdministratorElevationPromptBehavior = localSecurityOptionsAdministratorElevationPromptBehavior;
        _x.localSecurityOptionsAllowAnonymousEnumerationOfSAMAccountsAndShares = localSecurityOptionsAllowAnonymousEnumerationOfSAMAccountsAndShares;
        _x.localSecurityOptionsAllowPKU2UAuthenticationRequests = localSecurityOptionsAllowPKU2UAuthenticationRequests;
        _x.localSecurityOptionsAllowRemoteCallsToSecurityAccountsManager = localSecurityOptionsAllowRemoteCallsToSecurityAccountsManager;
        _x.localSecurityOptionsAllowRemoteCallsToSecurityAccountsManagerHelperBool = localSecurityOptionsAllowRemoteCallsToSecurityAccountsManagerHelperBool;
        _x.localSecurityOptionsAllowSystemToBeShutDownWithoutHavingToLogOn = localSecurityOptionsAllowSystemToBeShutDownWithoutHavingToLogOn;
        _x.localSecurityOptionsAllowUIAccessApplicationElevation = localSecurityOptionsAllowUIAccessApplicationElevation;
        _x.localSecurityOptionsAllowUIAccessApplicationsForSecureLocations = localSecurityOptionsAllowUIAccessApplicationsForSecureLocations;
        _x.localSecurityOptionsAllowUndockWithoutHavingToLogon = localSecurityOptionsAllowUndockWithoutHavingToLogon;
        _x.localSecurityOptionsBlockMicrosoftAccounts = localSecurityOptionsBlockMicrosoftAccounts;
        _x.localSecurityOptionsBlockRemoteLogonWithBlankPassword = localSecurityOptionsBlockRemoteLogonWithBlankPassword;
        _x.localSecurityOptionsBlockRemoteOpticalDriveAccess = localSecurityOptionsBlockRemoteOpticalDriveAccess;
        _x.localSecurityOptionsBlockUsersInstallingPrinterDrivers = localSecurityOptionsBlockUsersInstallingPrinterDrivers;
        _x.localSecurityOptionsClearVirtualMemoryPageFile = localSecurityOptionsClearVirtualMemoryPageFile;
        _x.localSecurityOptionsClientDigitallySignCommunicationsAlways = localSecurityOptionsClientDigitallySignCommunicationsAlways;
        _x.localSecurityOptionsClientSendUnencryptedPasswordToThirdPartySMBServers = localSecurityOptionsClientSendUnencryptedPasswordToThirdPartySMBServers;
        _x.localSecurityOptionsDetectApplicationInstallationsAndPromptForElevation = localSecurityOptionsDetectApplicationInstallationsAndPromptForElevation;
        _x.localSecurityOptionsDisableAdministratorAccount = localSecurityOptionsDisableAdministratorAccount;
        _x.localSecurityOptionsDisableClientDigitallySignCommunicationsIfServerAgrees = localSecurityOptionsDisableClientDigitallySignCommunicationsIfServerAgrees;
        _x.localSecurityOptionsDisableGuestAccount = localSecurityOptionsDisableGuestAccount;
        _x.localSecurityOptionsDisableServerDigitallySignCommunicationsAlways = localSecurityOptionsDisableServerDigitallySignCommunicationsAlways;
        _x.localSecurityOptionsDisableServerDigitallySignCommunicationsIfClientAgrees = localSecurityOptionsDisableServerDigitallySignCommunicationsIfClientAgrees;
        _x.localSecurityOptionsDoNotAllowAnonymousEnumerationOfSAMAccounts = localSecurityOptionsDoNotAllowAnonymousEnumerationOfSAMAccounts;
        _x.localSecurityOptionsDoNotRequireCtrlAltDel = localSecurityOptionsDoNotRequireCtrlAltDel;
        _x.localSecurityOptionsDoNotStoreLANManagerHashValueOnNextPasswordChange = localSecurityOptionsDoNotStoreLANManagerHashValueOnNextPasswordChange;
        _x.localSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUser = localSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUser;
        _x.localSecurityOptionsGuestAccountName = localSecurityOptionsGuestAccountName;
        _x.localSecurityOptionsHideLastSignedInUser = localSecurityOptionsHideLastSignedInUser;
        _x.localSecurityOptionsHideUsernameAtSignIn = localSecurityOptionsHideUsernameAtSignIn;
        _x.localSecurityOptionsInformationDisplayedOnLockScreen = localSecurityOptionsInformationDisplayedOnLockScreen;
        _x.localSecurityOptionsInformationShownOnLockScreen = localSecurityOptionsInformationShownOnLockScreen;
        _x.localSecurityOptionsLogOnMessageText = localSecurityOptionsLogOnMessageText;
        _x.localSecurityOptionsLogOnMessageTitle = localSecurityOptionsLogOnMessageTitle;
        _x.localSecurityOptionsMachineInactivityLimit = localSecurityOptionsMachineInactivityLimit;
        _x.localSecurityOptionsMachineInactivityLimitInMinutes = localSecurityOptionsMachineInactivityLimitInMinutes;
        _x.localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedClients = localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedClients;
        _x.localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedServers = localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedServers;
        _x.localSecurityOptionsOnlyElevateSignedExecutables = localSecurityOptionsOnlyElevateSignedExecutables;
        _x.localSecurityOptionsRestrictAnonymousAccessToNamedPipesAndShares = localSecurityOptionsRestrictAnonymousAccessToNamedPipesAndShares;
        _x.localSecurityOptionsSmartCardRemovalBehavior = localSecurityOptionsSmartCardRemovalBehavior;
        _x.localSecurityOptionsStandardUserElevationPromptBehavior = localSecurityOptionsStandardUserElevationPromptBehavior;
        _x.localSecurityOptionsSwitchToSecureDesktopWhenPromptingForElevation = localSecurityOptionsSwitchToSecureDesktopWhenPromptingForElevation;
        _x.localSecurityOptionsUseAdminApprovalMode = localSecurityOptionsUseAdminApprovalMode;
        _x.localSecurityOptionsUseAdminApprovalModeForAdministrators = localSecurityOptionsUseAdminApprovalModeForAdministrators;
        _x.localSecurityOptionsVirtualizeFileAndRegistryWriteFailuresToPerUserLocations = localSecurityOptionsVirtualizeFileAndRegistryWriteFailuresToPerUserLocations;
        _x.smartScreenBlockOverrideForFiles = smartScreenBlockOverrideForFiles;
        _x.smartScreenEnableInShell = smartScreenEnableInShell;
        _x.userRightsAccessCredentialManagerAsTrustedCaller = userRightsAccessCredentialManagerAsTrustedCaller;
        _x.userRightsActAsPartOfTheOperatingSystem = userRightsActAsPartOfTheOperatingSystem;
        _x.userRightsAllowAccessFromNetwork = userRightsAllowAccessFromNetwork;
        _x.userRightsBackupData = userRightsBackupData;
        _x.userRightsBlockAccessFromNetwork = userRightsBlockAccessFromNetwork;
        _x.userRightsChangeSystemTime = userRightsChangeSystemTime;
        _x.userRightsCreateGlobalObjects = userRightsCreateGlobalObjects;
        _x.userRightsCreatePageFile = userRightsCreatePageFile;
        _x.userRightsCreatePermanentSharedObjects = userRightsCreatePermanentSharedObjects;
        _x.userRightsCreateSymbolicLinks = userRightsCreateSymbolicLinks;
        _x.userRightsCreateToken = userRightsCreateToken;
        _x.userRightsDebugPrograms = userRightsDebugPrograms;
        _x.userRightsDelegation = userRightsDelegation;
        _x.userRightsDenyLocalLogOn = userRightsDenyLocalLogOn;
        _x.userRightsGenerateSecurityAudits = userRightsGenerateSecurityAudits;
        _x.userRightsImpersonateClient = userRightsImpersonateClient;
        _x.userRightsIncreaseSchedulingPriority = userRightsIncreaseSchedulingPriority;
        _x.userRightsLoadUnloadDrivers = userRightsLoadUnloadDrivers;
        _x.userRightsLocalLogOn = userRightsLocalLogOn;
        _x.userRightsLockMemory = userRightsLockMemory;
        _x.userRightsManageAuditingAndSecurityLogs = userRightsManageAuditingAndSecurityLogs;
        _x.userRightsManageVolumes = userRightsManageVolumes;
        _x.userRightsModifyFirmwareEnvironment = userRightsModifyFirmwareEnvironment;
        _x.userRightsModifyObjectLabels = userRightsModifyObjectLabels;
        _x.userRightsProfileSingleProcess = userRightsProfileSingleProcess;
        _x.userRightsRemoteDesktopServicesLogOn = userRightsRemoteDesktopServicesLogOn;
        _x.userRightsRemoteShutdown = userRightsRemoteShutdown;
        _x.userRightsRestoreData = userRightsRestoreData;
        _x.userRightsTakeOwnership = userRightsTakeOwnership;
        _x.windowsDefenderTamperProtection = windowsDefenderTamperProtection;
        _x.xboxServicesAccessoryManagementServiceStartupMode = xboxServicesAccessoryManagementServiceStartupMode;
        _x.xboxServicesEnableXboxGameSaveTask = xboxServicesEnableXboxGameSaveTask;
        _x.xboxServicesLiveAuthManagerServiceStartupMode = xboxServicesLiveAuthManagerServiceStartupMode;
        _x.xboxServicesLiveGameSaveServiceStartupMode = xboxServicesLiveGameSaveServiceStartupMode;
        _x.xboxServicesLiveNetworkingServiceStartupMode = xboxServicesLiveNetworkingServiceStartupMode;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Windows10EndpointProtectionConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceSettingStateSummaries=");
        b.append(this.deviceSettingStateSummaries);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("deviceStatusOverview=");
        b.append(this.deviceStatusOverview);
        b.append(", ");
        b.append("groupAssignments=");
        b.append(this.groupAssignments);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("userStatusOverview=");
        b.append(this.userStatusOverview);
        b.append(", ");
        b.append("applicationGuardAllowCameraMicrophoneRedirection=");
        b.append(this.applicationGuardAllowCameraMicrophoneRedirection);
        b.append(", ");
        b.append("applicationGuardAllowFileSaveOnHost=");
        b.append(this.applicationGuardAllowFileSaveOnHost);
        b.append(", ");
        b.append("applicationGuardAllowPersistence=");
        b.append(this.applicationGuardAllowPersistence);
        b.append(", ");
        b.append("applicationGuardAllowPrintToLocalPrinters=");
        b.append(this.applicationGuardAllowPrintToLocalPrinters);
        b.append(", ");
        b.append("applicationGuardAllowPrintToNetworkPrinters=");
        b.append(this.applicationGuardAllowPrintToNetworkPrinters);
        b.append(", ");
        b.append("applicationGuardAllowPrintToPDF=");
        b.append(this.applicationGuardAllowPrintToPDF);
        b.append(", ");
        b.append("applicationGuardAllowPrintToXPS=");
        b.append(this.applicationGuardAllowPrintToXPS);
        b.append(", ");
        b.append("applicationGuardAllowVirtualGPU=");
        b.append(this.applicationGuardAllowVirtualGPU);
        b.append(", ");
        b.append("applicationGuardBlockClipboardSharing=");
        b.append(this.applicationGuardBlockClipboardSharing);
        b.append(", ");
        b.append("applicationGuardBlockFileTransfer=");
        b.append(this.applicationGuardBlockFileTransfer);
        b.append(", ");
        b.append("applicationGuardBlockNonEnterpriseContent=");
        b.append(this.applicationGuardBlockNonEnterpriseContent);
        b.append(", ");
        b.append("applicationGuardCertificateThumbprints=");
        b.append(this.applicationGuardCertificateThumbprints);
        b.append(", ");
        b.append("applicationGuardEnabled=");
        b.append(this.applicationGuardEnabled);
        b.append(", ");
        b.append("applicationGuardEnabledOptions=");
        b.append(this.applicationGuardEnabledOptions);
        b.append(", ");
        b.append("applicationGuardForceAuditing=");
        b.append(this.applicationGuardForceAuditing);
        b.append(", ");
        b.append("appLockerApplicationControl=");
        b.append(this.appLockerApplicationControl);
        b.append(", ");
        b.append("bitLockerAllowStandardUserEncryption=");
        b.append(this.bitLockerAllowStandardUserEncryption);
        b.append(", ");
        b.append("bitLockerDisableWarningForOtherDiskEncryption=");
        b.append(this.bitLockerDisableWarningForOtherDiskEncryption);
        b.append(", ");
        b.append("bitLockerEnableStorageCardEncryptionOnMobile=");
        b.append(this.bitLockerEnableStorageCardEncryptionOnMobile);
        b.append(", ");
        b.append("bitLockerEncryptDevice=");
        b.append(this.bitLockerEncryptDevice);
        b.append(", ");
        b.append("bitLockerFixedDrivePolicy=");
        b.append(this.bitLockerFixedDrivePolicy);
        b.append(", ");
        b.append("bitLockerRecoveryPasswordRotation=");
        b.append(this.bitLockerRecoveryPasswordRotation);
        b.append(", ");
        b.append("bitLockerRemovableDrivePolicy=");
        b.append(this.bitLockerRemovableDrivePolicy);
        b.append(", ");
        b.append("bitLockerSystemDrivePolicy=");
        b.append(this.bitLockerSystemDrivePolicy);
        b.append(", ");
        b.append("defenderAdditionalGuardedFolders=");
        b.append(this.defenderAdditionalGuardedFolders);
        b.append(", ");
        b.append("defenderAdobeReaderLaunchChildProcess=");
        b.append(this.defenderAdobeReaderLaunchChildProcess);
        b.append(", ");
        b.append("defenderAdvancedRansomewareProtectionType=");
        b.append(this.defenderAdvancedRansomewareProtectionType);
        b.append(", ");
        b.append("defenderAllowBehaviorMonitoring=");
        b.append(this.defenderAllowBehaviorMonitoring);
        b.append(", ");
        b.append("defenderAllowCloudProtection=");
        b.append(this.defenderAllowCloudProtection);
        b.append(", ");
        b.append("defenderAllowEndUserAccess=");
        b.append(this.defenderAllowEndUserAccess);
        b.append(", ");
        b.append("defenderAllowIntrusionPreventionSystem=");
        b.append(this.defenderAllowIntrusionPreventionSystem);
        b.append(", ");
        b.append("defenderAllowOnAccessProtection=");
        b.append(this.defenderAllowOnAccessProtection);
        b.append(", ");
        b.append("defenderAllowRealTimeMonitoring=");
        b.append(this.defenderAllowRealTimeMonitoring);
        b.append(", ");
        b.append("defenderAllowScanArchiveFiles=");
        b.append(this.defenderAllowScanArchiveFiles);
        b.append(", ");
        b.append("defenderAllowScanDownloads=");
        b.append(this.defenderAllowScanDownloads);
        b.append(", ");
        b.append("defenderAllowScanNetworkFiles=");
        b.append(this.defenderAllowScanNetworkFiles);
        b.append(", ");
        b.append("defenderAllowScanRemovableDrivesDuringFullScan=");
        b.append(this.defenderAllowScanRemovableDrivesDuringFullScan);
        b.append(", ");
        b.append("defenderAllowScanScriptsLoadedInInternetExplorer=");
        b.append(this.defenderAllowScanScriptsLoadedInInternetExplorer);
        b.append(", ");
        b.append("defenderAttackSurfaceReductionExcludedPaths=");
        b.append(this.defenderAttackSurfaceReductionExcludedPaths);
        b.append(", ");
        b.append("defenderBlockEndUserAccess=");
        b.append(this.defenderBlockEndUserAccess);
        b.append(", ");
        b.append("defenderBlockPersistenceThroughWmiType=");
        b.append(this.defenderBlockPersistenceThroughWmiType);
        b.append(", ");
        b.append("defenderCheckForSignaturesBeforeRunningScan=");
        b.append(this.defenderCheckForSignaturesBeforeRunningScan);
        b.append(", ");
        b.append("defenderCloudBlockLevel=");
        b.append(this.defenderCloudBlockLevel);
        b.append(", ");
        b.append("defenderCloudExtendedTimeoutInSeconds=");
        b.append(this.defenderCloudExtendedTimeoutInSeconds);
        b.append(", ");
        b.append("defenderDaysBeforeDeletingQuarantinedMalware=");
        b.append(this.defenderDaysBeforeDeletingQuarantinedMalware);
        b.append(", ");
        b.append("defenderDetectedMalwareActions=");
        b.append(this.defenderDetectedMalwareActions);
        b.append(", ");
        b.append("defenderDisableBehaviorMonitoring=");
        b.append(this.defenderDisableBehaviorMonitoring);
        b.append(", ");
        b.append("defenderDisableCatchupFullScan=");
        b.append(this.defenderDisableCatchupFullScan);
        b.append(", ");
        b.append("defenderDisableCatchupQuickScan=");
        b.append(this.defenderDisableCatchupQuickScan);
        b.append(", ");
        b.append("defenderDisableCloudProtection=");
        b.append(this.defenderDisableCloudProtection);
        b.append(", ");
        b.append("defenderDisableIntrusionPreventionSystem=");
        b.append(this.defenderDisableIntrusionPreventionSystem);
        b.append(", ");
        b.append("defenderDisableOnAccessProtection=");
        b.append(this.defenderDisableOnAccessProtection);
        b.append(", ");
        b.append("defenderDisableRealTimeMonitoring=");
        b.append(this.defenderDisableRealTimeMonitoring);
        b.append(", ");
        b.append("defenderDisableScanArchiveFiles=");
        b.append(this.defenderDisableScanArchiveFiles);
        b.append(", ");
        b.append("defenderDisableScanDownloads=");
        b.append(this.defenderDisableScanDownloads);
        b.append(", ");
        b.append("defenderDisableScanNetworkFiles=");
        b.append(this.defenderDisableScanNetworkFiles);
        b.append(", ");
        b.append("defenderDisableScanRemovableDrivesDuringFullScan=");
        b.append(this.defenderDisableScanRemovableDrivesDuringFullScan);
        b.append(", ");
        b.append("defenderDisableScanScriptsLoadedInInternetExplorer=");
        b.append(this.defenderDisableScanScriptsLoadedInInternetExplorer);
        b.append(", ");
        b.append("defenderEmailContentExecution=");
        b.append(this.defenderEmailContentExecution);
        b.append(", ");
        b.append("defenderEmailContentExecutionType=");
        b.append(this.defenderEmailContentExecutionType);
        b.append(", ");
        b.append("defenderEnableLowCpuPriority=");
        b.append(this.defenderEnableLowCpuPriority);
        b.append(", ");
        b.append("defenderEnableScanIncomingMail=");
        b.append(this.defenderEnableScanIncomingMail);
        b.append(", ");
        b.append("defenderEnableScanMappedNetworkDrivesDuringFullScan=");
        b.append(this.defenderEnableScanMappedNetworkDrivesDuringFullScan);
        b.append(", ");
        b.append("defenderExploitProtectionXml=");
        b.append(this.defenderExploitProtectionXml);
        b.append(", ");
        b.append("defenderExploitProtectionXmlFileName=");
        b.append(this.defenderExploitProtectionXmlFileName);
        b.append(", ");
        b.append("defenderFileExtensionsToExclude=");
        b.append(this.defenderFileExtensionsToExclude);
        b.append(", ");
        b.append("defenderFilesAndFoldersToExclude=");
        b.append(this.defenderFilesAndFoldersToExclude);
        b.append(", ");
        b.append("defenderGuardedFoldersAllowedAppPaths=");
        b.append(this.defenderGuardedFoldersAllowedAppPaths);
        b.append(", ");
        b.append("defenderGuardMyFoldersType=");
        b.append(this.defenderGuardMyFoldersType);
        b.append(", ");
        b.append("defenderNetworkProtectionType=");
        b.append(this.defenderNetworkProtectionType);
        b.append(", ");
        b.append("defenderOfficeAppsExecutableContentCreationOrLaunch=");
        b.append(this.defenderOfficeAppsExecutableContentCreationOrLaunch);
        b.append(", ");
        b.append("defenderOfficeAppsExecutableContentCreationOrLaunchType=");
        b.append(this.defenderOfficeAppsExecutableContentCreationOrLaunchType);
        b.append(", ");
        b.append("defenderOfficeAppsLaunchChildProcess=");
        b.append(this.defenderOfficeAppsLaunchChildProcess);
        b.append(", ");
        b.append("defenderOfficeAppsLaunchChildProcessType=");
        b.append(this.defenderOfficeAppsLaunchChildProcessType);
        b.append(", ");
        b.append("defenderOfficeAppsOtherProcessInjection=");
        b.append(this.defenderOfficeAppsOtherProcessInjection);
        b.append(", ");
        b.append("defenderOfficeAppsOtherProcessInjectionType=");
        b.append(this.defenderOfficeAppsOtherProcessInjectionType);
        b.append(", ");
        b.append("defenderOfficeCommunicationAppsLaunchChildProcess=");
        b.append(this.defenderOfficeCommunicationAppsLaunchChildProcess);
        b.append(", ");
        b.append("defenderOfficeMacroCodeAllowWin32Imports=");
        b.append(this.defenderOfficeMacroCodeAllowWin32Imports);
        b.append(", ");
        b.append("defenderOfficeMacroCodeAllowWin32ImportsType=");
        b.append(this.defenderOfficeMacroCodeAllowWin32ImportsType);
        b.append(", ");
        b.append("defenderPotentiallyUnwantedAppAction=");
        b.append(this.defenderPotentiallyUnwantedAppAction);
        b.append(", ");
        b.append("defenderPreventCredentialStealingType=");
        b.append(this.defenderPreventCredentialStealingType);
        b.append(", ");
        b.append("defenderProcessCreation=");
        b.append(this.defenderProcessCreation);
        b.append(", ");
        b.append("defenderProcessCreationType=");
        b.append(this.defenderProcessCreationType);
        b.append(", ");
        b.append("defenderProcessesToExclude=");
        b.append(this.defenderProcessesToExclude);
        b.append(", ");
        b.append("defenderScanDirection=");
        b.append(this.defenderScanDirection);
        b.append(", ");
        b.append("defenderScanMaxCpuPercentage=");
        b.append(this.defenderScanMaxCpuPercentage);
        b.append(", ");
        b.append("defenderScanType=");
        b.append(this.defenderScanType);
        b.append(", ");
        b.append("defenderScheduledQuickScanTime=");
        b.append(this.defenderScheduledQuickScanTime);
        b.append(", ");
        b.append("defenderScheduledScanDay=");
        b.append(this.defenderScheduledScanDay);
        b.append(", ");
        b.append("defenderScheduledScanTime=");
        b.append(this.defenderScheduledScanTime);
        b.append(", ");
        b.append("defenderScriptDownloadedPayloadExecution=");
        b.append(this.defenderScriptDownloadedPayloadExecution);
        b.append(", ");
        b.append("defenderScriptDownloadedPayloadExecutionType=");
        b.append(this.defenderScriptDownloadedPayloadExecutionType);
        b.append(", ");
        b.append("defenderScriptObfuscatedMacroCode=");
        b.append(this.defenderScriptObfuscatedMacroCode);
        b.append(", ");
        b.append("defenderScriptObfuscatedMacroCodeType=");
        b.append(this.defenderScriptObfuscatedMacroCodeType);
        b.append(", ");
        b.append("defenderSecurityCenterBlockExploitProtectionOverride=");
        b.append(this.defenderSecurityCenterBlockExploitProtectionOverride);
        b.append(", ");
        b.append("defenderSecurityCenterDisableAccountUI=");
        b.append(this.defenderSecurityCenterDisableAccountUI);
        b.append(", ");
        b.append("defenderSecurityCenterDisableAppBrowserUI=");
        b.append(this.defenderSecurityCenterDisableAppBrowserUI);
        b.append(", ");
        b.append("defenderSecurityCenterDisableClearTpmUI=");
        b.append(this.defenderSecurityCenterDisableClearTpmUI);
        b.append(", ");
        b.append("defenderSecurityCenterDisableFamilyUI=");
        b.append(this.defenderSecurityCenterDisableFamilyUI);
        b.append(", ");
        b.append("defenderSecurityCenterDisableHardwareUI=");
        b.append(this.defenderSecurityCenterDisableHardwareUI);
        b.append(", ");
        b.append("defenderSecurityCenterDisableHealthUI=");
        b.append(this.defenderSecurityCenterDisableHealthUI);
        b.append(", ");
        b.append("defenderSecurityCenterDisableNetworkUI=");
        b.append(this.defenderSecurityCenterDisableNetworkUI);
        b.append(", ");
        b.append("defenderSecurityCenterDisableNotificationAreaUI=");
        b.append(this.defenderSecurityCenterDisableNotificationAreaUI);
        b.append(", ");
        b.append("defenderSecurityCenterDisableRansomwareUI=");
        b.append(this.defenderSecurityCenterDisableRansomwareUI);
        b.append(", ");
        b.append("defenderSecurityCenterDisableSecureBootUI=");
        b.append(this.defenderSecurityCenterDisableSecureBootUI);
        b.append(", ");
        b.append("defenderSecurityCenterDisableTroubleshootingUI=");
        b.append(this.defenderSecurityCenterDisableTroubleshootingUI);
        b.append(", ");
        b.append("defenderSecurityCenterDisableVirusUI=");
        b.append(this.defenderSecurityCenterDisableVirusUI);
        b.append(", ");
        b.append("defenderSecurityCenterDisableVulnerableTpmFirmwareUpdateUI=");
        b.append(this.defenderSecurityCenterDisableVulnerableTpmFirmwareUpdateUI);
        b.append(", ");
        b.append("defenderSecurityCenterHelpEmail=");
        b.append(this.defenderSecurityCenterHelpEmail);
        b.append(", ");
        b.append("defenderSecurityCenterHelpPhone=");
        b.append(this.defenderSecurityCenterHelpPhone);
        b.append(", ");
        b.append("defenderSecurityCenterHelpURL=");
        b.append(this.defenderSecurityCenterHelpURL);
        b.append(", ");
        b.append("defenderSecurityCenterITContactDisplay=");
        b.append(this.defenderSecurityCenterITContactDisplay);
        b.append(", ");
        b.append("defenderSecurityCenterNotificationsFromApp=");
        b.append(this.defenderSecurityCenterNotificationsFromApp);
        b.append(", ");
        b.append("defenderSecurityCenterOrganizationDisplayName=");
        b.append(this.defenderSecurityCenterOrganizationDisplayName);
        b.append(", ");
        b.append("defenderSignatureUpdateIntervalInHours=");
        b.append(this.defenderSignatureUpdateIntervalInHours);
        b.append(", ");
        b.append("defenderSubmitSamplesConsentType=");
        b.append(this.defenderSubmitSamplesConsentType);
        b.append(", ");
        b.append("defenderUntrustedExecutable=");
        b.append(this.defenderUntrustedExecutable);
        b.append(", ");
        b.append("defenderUntrustedExecutableType=");
        b.append(this.defenderUntrustedExecutableType);
        b.append(", ");
        b.append("defenderUntrustedUSBProcess=");
        b.append(this.defenderUntrustedUSBProcess);
        b.append(", ");
        b.append("defenderUntrustedUSBProcessType=");
        b.append(this.defenderUntrustedUSBProcessType);
        b.append(", ");
        b.append("deviceGuardEnableSecureBootWithDMA=");
        b.append(this.deviceGuardEnableSecureBootWithDMA);
        b.append(", ");
        b.append("deviceGuardEnableVirtualizationBasedSecurity=");
        b.append(this.deviceGuardEnableVirtualizationBasedSecurity);
        b.append(", ");
        b.append("deviceGuardLaunchSystemGuard=");
        b.append(this.deviceGuardLaunchSystemGuard);
        b.append(", ");
        b.append("deviceGuardLocalSystemAuthorityCredentialGuardSettings=");
        b.append(this.deviceGuardLocalSystemAuthorityCredentialGuardSettings);
        b.append(", ");
        b.append("deviceGuardSecureBootWithDMA=");
        b.append(this.deviceGuardSecureBootWithDMA);
        b.append(", ");
        b.append("dmaGuardDeviceEnumerationPolicy=");
        b.append(this.dmaGuardDeviceEnumerationPolicy);
        b.append(", ");
        b.append("firewallBlockStatefulFTP=");
        b.append(this.firewallBlockStatefulFTP);
        b.append(", ");
        b.append("firewallCertificateRevocationListCheckMethod=");
        b.append(this.firewallCertificateRevocationListCheckMethod);
        b.append(", ");
        b.append("firewallIdleTimeoutForSecurityAssociationInSeconds=");
        b.append(this.firewallIdleTimeoutForSecurityAssociationInSeconds);
        b.append(", ");
        b.append("firewallIPSecExemptionsAllowDHCP=");
        b.append(this.firewallIPSecExemptionsAllowDHCP);
        b.append(", ");
        b.append("firewallIPSecExemptionsAllowICMP=");
        b.append(this.firewallIPSecExemptionsAllowICMP);
        b.append(", ");
        b.append("firewallIPSecExemptionsAllowNeighborDiscovery=");
        b.append(this.firewallIPSecExemptionsAllowNeighborDiscovery);
        b.append(", ");
        b.append("firewallIPSecExemptionsAllowRouterDiscovery=");
        b.append(this.firewallIPSecExemptionsAllowRouterDiscovery);
        b.append(", ");
        b.append("firewallIPSecExemptionsNone=");
        b.append(this.firewallIPSecExemptionsNone);
        b.append(", ");
        b.append("firewallMergeKeyingModuleSettings=");
        b.append(this.firewallMergeKeyingModuleSettings);
        b.append(", ");
        b.append("firewallPacketQueueingMethod=");
        b.append(this.firewallPacketQueueingMethod);
        b.append(", ");
        b.append("firewallPreSharedKeyEncodingMethod=");
        b.append(this.firewallPreSharedKeyEncodingMethod);
        b.append(", ");
        b.append("firewallProfileDomain=");
        b.append(this.firewallProfileDomain);
        b.append(", ");
        b.append("firewallProfilePrivate=");
        b.append(this.firewallProfilePrivate);
        b.append(", ");
        b.append("firewallProfilePublic=");
        b.append(this.firewallProfilePublic);
        b.append(", ");
        b.append("firewallRules=");
        b.append(this.firewallRules);
        b.append(", ");
        b.append("lanManagerAuthenticationLevel=");
        b.append(this.lanManagerAuthenticationLevel);
        b.append(", ");
        b.append("lanManagerWorkstationDisableInsecureGuestLogons=");
        b.append(this.lanManagerWorkstationDisableInsecureGuestLogons);
        b.append(", ");
        b.append("localSecurityOptionsAdministratorAccountName=");
        b.append(this.localSecurityOptionsAdministratorAccountName);
        b.append(", ");
        b.append("localSecurityOptionsAdministratorElevationPromptBehavior=");
        b.append(this.localSecurityOptionsAdministratorElevationPromptBehavior);
        b.append(", ");
        b.append("localSecurityOptionsAllowAnonymousEnumerationOfSAMAccountsAndShares=");
        b.append(this.localSecurityOptionsAllowAnonymousEnumerationOfSAMAccountsAndShares);
        b.append(", ");
        b.append("localSecurityOptionsAllowPKU2UAuthenticationRequests=");
        b.append(this.localSecurityOptionsAllowPKU2UAuthenticationRequests);
        b.append(", ");
        b.append("localSecurityOptionsAllowRemoteCallsToSecurityAccountsManager=");
        b.append(this.localSecurityOptionsAllowRemoteCallsToSecurityAccountsManager);
        b.append(", ");
        b.append("localSecurityOptionsAllowRemoteCallsToSecurityAccountsManagerHelperBool=");
        b.append(this.localSecurityOptionsAllowRemoteCallsToSecurityAccountsManagerHelperBool);
        b.append(", ");
        b.append("localSecurityOptionsAllowSystemToBeShutDownWithoutHavingToLogOn=");
        b.append(this.localSecurityOptionsAllowSystemToBeShutDownWithoutHavingToLogOn);
        b.append(", ");
        b.append("localSecurityOptionsAllowUIAccessApplicationElevation=");
        b.append(this.localSecurityOptionsAllowUIAccessApplicationElevation);
        b.append(", ");
        b.append("localSecurityOptionsAllowUIAccessApplicationsForSecureLocations=");
        b.append(this.localSecurityOptionsAllowUIAccessApplicationsForSecureLocations);
        b.append(", ");
        b.append("localSecurityOptionsAllowUndockWithoutHavingToLogon=");
        b.append(this.localSecurityOptionsAllowUndockWithoutHavingToLogon);
        b.append(", ");
        b.append("localSecurityOptionsBlockMicrosoftAccounts=");
        b.append(this.localSecurityOptionsBlockMicrosoftAccounts);
        b.append(", ");
        b.append("localSecurityOptionsBlockRemoteLogonWithBlankPassword=");
        b.append(this.localSecurityOptionsBlockRemoteLogonWithBlankPassword);
        b.append(", ");
        b.append("localSecurityOptionsBlockRemoteOpticalDriveAccess=");
        b.append(this.localSecurityOptionsBlockRemoteOpticalDriveAccess);
        b.append(", ");
        b.append("localSecurityOptionsBlockUsersInstallingPrinterDrivers=");
        b.append(this.localSecurityOptionsBlockUsersInstallingPrinterDrivers);
        b.append(", ");
        b.append("localSecurityOptionsClearVirtualMemoryPageFile=");
        b.append(this.localSecurityOptionsClearVirtualMemoryPageFile);
        b.append(", ");
        b.append("localSecurityOptionsClientDigitallySignCommunicationsAlways=");
        b.append(this.localSecurityOptionsClientDigitallySignCommunicationsAlways);
        b.append(", ");
        b.append("localSecurityOptionsClientSendUnencryptedPasswordToThirdPartySMBServers=");
        b.append(this.localSecurityOptionsClientSendUnencryptedPasswordToThirdPartySMBServers);
        b.append(", ");
        b.append("localSecurityOptionsDetectApplicationInstallationsAndPromptForElevation=");
        b.append(this.localSecurityOptionsDetectApplicationInstallationsAndPromptForElevation);
        b.append(", ");
        b.append("localSecurityOptionsDisableAdministratorAccount=");
        b.append(this.localSecurityOptionsDisableAdministratorAccount);
        b.append(", ");
        b.append("localSecurityOptionsDisableClientDigitallySignCommunicationsIfServerAgrees=");
        b.append(this.localSecurityOptionsDisableClientDigitallySignCommunicationsIfServerAgrees);
        b.append(", ");
        b.append("localSecurityOptionsDisableGuestAccount=");
        b.append(this.localSecurityOptionsDisableGuestAccount);
        b.append(", ");
        b.append("localSecurityOptionsDisableServerDigitallySignCommunicationsAlways=");
        b.append(this.localSecurityOptionsDisableServerDigitallySignCommunicationsAlways);
        b.append(", ");
        b.append("localSecurityOptionsDisableServerDigitallySignCommunicationsIfClientAgrees=");
        b.append(this.localSecurityOptionsDisableServerDigitallySignCommunicationsIfClientAgrees);
        b.append(", ");
        b.append("localSecurityOptionsDoNotAllowAnonymousEnumerationOfSAMAccounts=");
        b.append(this.localSecurityOptionsDoNotAllowAnonymousEnumerationOfSAMAccounts);
        b.append(", ");
        b.append("localSecurityOptionsDoNotRequireCtrlAltDel=");
        b.append(this.localSecurityOptionsDoNotRequireCtrlAltDel);
        b.append(", ");
        b.append("localSecurityOptionsDoNotStoreLANManagerHashValueOnNextPasswordChange=");
        b.append(this.localSecurityOptionsDoNotStoreLANManagerHashValueOnNextPasswordChange);
        b.append(", ");
        b.append("localSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUser=");
        b.append(this.localSecurityOptionsFormatAndEjectOfRemovableMediaAllowedUser);
        b.append(", ");
        b.append("localSecurityOptionsGuestAccountName=");
        b.append(this.localSecurityOptionsGuestAccountName);
        b.append(", ");
        b.append("localSecurityOptionsHideLastSignedInUser=");
        b.append(this.localSecurityOptionsHideLastSignedInUser);
        b.append(", ");
        b.append("localSecurityOptionsHideUsernameAtSignIn=");
        b.append(this.localSecurityOptionsHideUsernameAtSignIn);
        b.append(", ");
        b.append("localSecurityOptionsInformationDisplayedOnLockScreen=");
        b.append(this.localSecurityOptionsInformationDisplayedOnLockScreen);
        b.append(", ");
        b.append("localSecurityOptionsInformationShownOnLockScreen=");
        b.append(this.localSecurityOptionsInformationShownOnLockScreen);
        b.append(", ");
        b.append("localSecurityOptionsLogOnMessageText=");
        b.append(this.localSecurityOptionsLogOnMessageText);
        b.append(", ");
        b.append("localSecurityOptionsLogOnMessageTitle=");
        b.append(this.localSecurityOptionsLogOnMessageTitle);
        b.append(", ");
        b.append("localSecurityOptionsMachineInactivityLimit=");
        b.append(this.localSecurityOptionsMachineInactivityLimit);
        b.append(", ");
        b.append("localSecurityOptionsMachineInactivityLimitInMinutes=");
        b.append(this.localSecurityOptionsMachineInactivityLimitInMinutes);
        b.append(", ");
        b.append("localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedClients=");
        b.append(this.localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedClients);
        b.append(", ");
        b.append("localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedServers=");
        b.append(this.localSecurityOptionsMinimumSessionSecurityForNtlmSspBasedServers);
        b.append(", ");
        b.append("localSecurityOptionsOnlyElevateSignedExecutables=");
        b.append(this.localSecurityOptionsOnlyElevateSignedExecutables);
        b.append(", ");
        b.append("localSecurityOptionsRestrictAnonymousAccessToNamedPipesAndShares=");
        b.append(this.localSecurityOptionsRestrictAnonymousAccessToNamedPipesAndShares);
        b.append(", ");
        b.append("localSecurityOptionsSmartCardRemovalBehavior=");
        b.append(this.localSecurityOptionsSmartCardRemovalBehavior);
        b.append(", ");
        b.append("localSecurityOptionsStandardUserElevationPromptBehavior=");
        b.append(this.localSecurityOptionsStandardUserElevationPromptBehavior);
        b.append(", ");
        b.append("localSecurityOptionsSwitchToSecureDesktopWhenPromptingForElevation=");
        b.append(this.localSecurityOptionsSwitchToSecureDesktopWhenPromptingForElevation);
        b.append(", ");
        b.append("localSecurityOptionsUseAdminApprovalMode=");
        b.append(this.localSecurityOptionsUseAdminApprovalMode);
        b.append(", ");
        b.append("localSecurityOptionsUseAdminApprovalModeForAdministrators=");
        b.append(this.localSecurityOptionsUseAdminApprovalModeForAdministrators);
        b.append(", ");
        b.append("localSecurityOptionsVirtualizeFileAndRegistryWriteFailuresToPerUserLocations=");
        b.append(this.localSecurityOptionsVirtualizeFileAndRegistryWriteFailuresToPerUserLocations);
        b.append(", ");
        b.append("smartScreenBlockOverrideForFiles=");
        b.append(this.smartScreenBlockOverrideForFiles);
        b.append(", ");
        b.append("smartScreenEnableInShell=");
        b.append(this.smartScreenEnableInShell);
        b.append(", ");
        b.append("userRightsAccessCredentialManagerAsTrustedCaller=");
        b.append(this.userRightsAccessCredentialManagerAsTrustedCaller);
        b.append(", ");
        b.append("userRightsActAsPartOfTheOperatingSystem=");
        b.append(this.userRightsActAsPartOfTheOperatingSystem);
        b.append(", ");
        b.append("userRightsAllowAccessFromNetwork=");
        b.append(this.userRightsAllowAccessFromNetwork);
        b.append(", ");
        b.append("userRightsBackupData=");
        b.append(this.userRightsBackupData);
        b.append(", ");
        b.append("userRightsBlockAccessFromNetwork=");
        b.append(this.userRightsBlockAccessFromNetwork);
        b.append(", ");
        b.append("userRightsChangeSystemTime=");
        b.append(this.userRightsChangeSystemTime);
        b.append(", ");
        b.append("userRightsCreateGlobalObjects=");
        b.append(this.userRightsCreateGlobalObjects);
        b.append(", ");
        b.append("userRightsCreatePageFile=");
        b.append(this.userRightsCreatePageFile);
        b.append(", ");
        b.append("userRightsCreatePermanentSharedObjects=");
        b.append(this.userRightsCreatePermanentSharedObjects);
        b.append(", ");
        b.append("userRightsCreateSymbolicLinks=");
        b.append(this.userRightsCreateSymbolicLinks);
        b.append(", ");
        b.append("userRightsCreateToken=");
        b.append(this.userRightsCreateToken);
        b.append(", ");
        b.append("userRightsDebugPrograms=");
        b.append(this.userRightsDebugPrograms);
        b.append(", ");
        b.append("userRightsDelegation=");
        b.append(this.userRightsDelegation);
        b.append(", ");
        b.append("userRightsDenyLocalLogOn=");
        b.append(this.userRightsDenyLocalLogOn);
        b.append(", ");
        b.append("userRightsGenerateSecurityAudits=");
        b.append(this.userRightsGenerateSecurityAudits);
        b.append(", ");
        b.append("userRightsImpersonateClient=");
        b.append(this.userRightsImpersonateClient);
        b.append(", ");
        b.append("userRightsIncreaseSchedulingPriority=");
        b.append(this.userRightsIncreaseSchedulingPriority);
        b.append(", ");
        b.append("userRightsLoadUnloadDrivers=");
        b.append(this.userRightsLoadUnloadDrivers);
        b.append(", ");
        b.append("userRightsLocalLogOn=");
        b.append(this.userRightsLocalLogOn);
        b.append(", ");
        b.append("userRightsLockMemory=");
        b.append(this.userRightsLockMemory);
        b.append(", ");
        b.append("userRightsManageAuditingAndSecurityLogs=");
        b.append(this.userRightsManageAuditingAndSecurityLogs);
        b.append(", ");
        b.append("userRightsManageVolumes=");
        b.append(this.userRightsManageVolumes);
        b.append(", ");
        b.append("userRightsModifyFirmwareEnvironment=");
        b.append(this.userRightsModifyFirmwareEnvironment);
        b.append(", ");
        b.append("userRightsModifyObjectLabels=");
        b.append(this.userRightsModifyObjectLabels);
        b.append(", ");
        b.append("userRightsProfileSingleProcess=");
        b.append(this.userRightsProfileSingleProcess);
        b.append(", ");
        b.append("userRightsRemoteDesktopServicesLogOn=");
        b.append(this.userRightsRemoteDesktopServicesLogOn);
        b.append(", ");
        b.append("userRightsRemoteShutdown=");
        b.append(this.userRightsRemoteShutdown);
        b.append(", ");
        b.append("userRightsRestoreData=");
        b.append(this.userRightsRestoreData);
        b.append(", ");
        b.append("userRightsTakeOwnership=");
        b.append(this.userRightsTakeOwnership);
        b.append(", ");
        b.append("windowsDefenderTamperProtection=");
        b.append(this.windowsDefenderTamperProtection);
        b.append(", ");
        b.append("xboxServicesAccessoryManagementServiceStartupMode=");
        b.append(this.xboxServicesAccessoryManagementServiceStartupMode);
        b.append(", ");
        b.append("xboxServicesEnableXboxGameSaveTask=");
        b.append(this.xboxServicesEnableXboxGameSaveTask);
        b.append(", ");
        b.append("xboxServicesLiveAuthManagerServiceStartupMode=");
        b.append(this.xboxServicesLiveAuthManagerServiceStartupMode);
        b.append(", ");
        b.append("xboxServicesLiveGameSaveServiceStartupMode=");
        b.append(this.xboxServicesLiveGameSaveServiceStartupMode);
        b.append(", ");
        b.append("xboxServicesLiveNetworkingServiceStartupMode=");
        b.append(this.xboxServicesLiveNetworkingServiceStartupMode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
