package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.enums.DomainNameSource;
import odata.msgraph.client.beta.enums.EmailSyncDuration;
import odata.msgraph.client.beta.enums.EmailSyncSchedule;
import odata.msgraph.client.beta.enums.UserEmailSource;
import odata.msgraph.client.beta.enums.UsernameSource;


/**
 * <i>“By providing configurations in this profile you can instruct the native email
 * client (Outlook) on Windows 10 devices to communicate with an Exchange server
 * and get email, contacts, calendar, and tasks. Furthermore, you can also specify
 * how much email to sync and how often the device should sync.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "accountName", 
    "durationOfEmailToSync", 
    "emailAddressSource", 
    "emailSyncSchedule", 
    "hostName", 
    "requireSsl", 
    "syncCalendar", 
    "syncContacts", 
    "syncTasks"})
@JsonInclude(Include.NON_NULL)
public class Windows10EasEmailProfileConfiguration extends EasEmailProfileConfigurationBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windows10EasEmailProfileConfiguration";
    }

    @JsonProperty("accountName")
    protected String accountName;

    @JsonProperty("durationOfEmailToSync")
    protected EmailSyncDuration durationOfEmailToSync;

    @JsonProperty("emailAddressSource")
    protected UserEmailSource emailAddressSource;

    @JsonProperty("emailSyncSchedule")
    protected EmailSyncSchedule emailSyncSchedule;

    @JsonProperty("hostName")
    protected String hostName;

    @JsonProperty("requireSsl")
    protected Boolean requireSsl;

    @JsonProperty("syncCalendar")
    protected Boolean syncCalendar;

    @JsonProperty("syncContacts")
    protected Boolean syncContacts;

    @JsonProperty("syncTasks")
    protected Boolean syncTasks;

    protected Windows10EasEmailProfileConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindows10EasEmailProfileConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private Integer version;
        private List<DeviceConfigurationAssignment> assignments;
        private List<SettingStateDeviceSummary> deviceSettingStateSummaries;
        private List<DeviceConfigurationDeviceStatus> deviceStatuses;
        private DeviceConfigurationDeviceOverview deviceStatusOverview;
        private List<DeviceConfigurationGroupAssignment> groupAssignments;
        private List<DeviceConfigurationUserStatus> userStatuses;
        private DeviceConfigurationUserOverview userStatusOverview;
        private String customDomainName;
        private DomainNameSource userDomainNameSource;
        private UsernameSource usernameAADSource;
        private UserEmailSource usernameSource;
        private String accountName;
        private EmailSyncDuration durationOfEmailToSync;
        private UserEmailSource emailAddressSource;
        private EmailSyncSchedule emailSyncSchedule;
        private String hostName;
        private Boolean requireSsl;
        private Boolean syncCalendar;
        private Boolean syncContacts;
        private Boolean syncTasks;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder assignments(List<DeviceConfigurationAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(DeviceConfigurationAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder deviceSettingStateSummaries(List<SettingStateDeviceSummary> deviceSettingStateSummaries) {
            this.deviceSettingStateSummaries = deviceSettingStateSummaries;
            this.changedFields = changedFields.add("deviceSettingStateSummaries");
            return this;
        }

        public Builder deviceSettingStateSummaries(SettingStateDeviceSummary... deviceSettingStateSummaries) {
            return deviceSettingStateSummaries(Arrays.asList(deviceSettingStateSummaries));
        }

        public Builder deviceStatuses(List<DeviceConfigurationDeviceStatus> deviceStatuses) {
            this.deviceStatuses = deviceStatuses;
            this.changedFields = changedFields.add("deviceStatuses");
            return this;
        }

        public Builder deviceStatuses(DeviceConfigurationDeviceStatus... deviceStatuses) {
            return deviceStatuses(Arrays.asList(deviceStatuses));
        }

        public Builder deviceStatusOverview(DeviceConfigurationDeviceOverview deviceStatusOverview) {
            this.deviceStatusOverview = deviceStatusOverview;
            this.changedFields = changedFields.add("deviceStatusOverview");
            return this;
        }

        public Builder groupAssignments(List<DeviceConfigurationGroupAssignment> groupAssignments) {
            this.groupAssignments = groupAssignments;
            this.changedFields = changedFields.add("groupAssignments");
            return this;
        }

        public Builder groupAssignments(DeviceConfigurationGroupAssignment... groupAssignments) {
            return groupAssignments(Arrays.asList(groupAssignments));
        }

        public Builder userStatuses(List<DeviceConfigurationUserStatus> userStatuses) {
            this.userStatuses = userStatuses;
            this.changedFields = changedFields.add("userStatuses");
            return this;
        }

        public Builder userStatuses(DeviceConfigurationUserStatus... userStatuses) {
            return userStatuses(Arrays.asList(userStatuses));
        }

        public Builder userStatusOverview(DeviceConfigurationUserOverview userStatusOverview) {
            this.userStatusOverview = userStatusOverview;
            this.changedFields = changedFields.add("userStatusOverview");
            return this;
        }

        public Builder customDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
            this.changedFields = changedFields.add("customDomainName");
            return this;
        }

        public Builder userDomainNameSource(DomainNameSource userDomainNameSource) {
            this.userDomainNameSource = userDomainNameSource;
            this.changedFields = changedFields.add("userDomainNameSource");
            return this;
        }

        public Builder usernameAADSource(UsernameSource usernameAADSource) {
            this.usernameAADSource = usernameAADSource;
            this.changedFields = changedFields.add("usernameAADSource");
            return this;
        }

        public Builder usernameSource(UserEmailSource usernameSource) {
            this.usernameSource = usernameSource;
            this.changedFields = changedFields.add("usernameSource");
            return this;
        }

        /**
         * <i>“Account name.”</i>
         * 
         * @param accountName
         *            value of {@code accountName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder accountName(String accountName) {
            this.accountName = accountName;
            this.changedFields = changedFields.add("accountName");
            return this;
        }

        /**
         * <i>“Duration of email to sync.”</i>
         * 
         * @param durationOfEmailToSync
         *            value of {@code durationOfEmailToSync} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder durationOfEmailToSync(EmailSyncDuration durationOfEmailToSync) {
            this.durationOfEmailToSync = durationOfEmailToSync;
            this.changedFields = changedFields.add("durationOfEmailToSync");
            return this;
        }

        /**
         * <i>“Email attribute that is picked from AAD and injected into this profile before
         * installing on the device.”</i>
         * 
         * @param emailAddressSource
         *            value of {@code emailAddressSource} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder emailAddressSource(UserEmailSource emailAddressSource) {
            this.emailAddressSource = emailAddressSource;
            this.changedFields = changedFields.add("emailAddressSource");
            return this;
        }

        /**
         * <i>“Email sync schedule.”</i>
         * 
         * @param emailSyncSchedule
         *            value of {@code emailSyncSchedule} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder emailSyncSchedule(EmailSyncSchedule emailSyncSchedule) {
            this.emailSyncSchedule = emailSyncSchedule;
            this.changedFields = changedFields.add("emailSyncSchedule");
            return this;
        }

        /**
         * <i>“Exchange location that (URL) that the native mail app connects to.”</i>
         * 
         * @param hostName
         *            value of {@code hostName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder hostName(String hostName) {
            this.hostName = hostName;
            this.changedFields = changedFields.add("hostName");
            return this;
        }

        /**
         * <i>“Indicates whether or not to use SSL.”</i>
         * 
         * @param requireSsl
         *            value of {@code requireSsl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requireSsl(Boolean requireSsl) {
            this.requireSsl = requireSsl;
            this.changedFields = changedFields.add("requireSsl");
            return this;
        }

        /**
         * <i>“Whether or not to sync the calendar.”</i>
         * 
         * @param syncCalendar
         *            value of {@code syncCalendar} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder syncCalendar(Boolean syncCalendar) {
            this.syncCalendar = syncCalendar;
            this.changedFields = changedFields.add("syncCalendar");
            return this;
        }

        /**
         * <i>“Whether or not to sync contacts.”</i>
         * 
         * @param syncContacts
         *            value of {@code syncContacts} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder syncContacts(Boolean syncContacts) {
            this.syncContacts = syncContacts;
            this.changedFields = changedFields.add("syncContacts");
            return this;
        }

        /**
         * <i>“Whether or not to sync tasks.”</i>
         * 
         * @param syncTasks
         *            value of {@code syncTasks} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder syncTasks(Boolean syncTasks) {
            this.syncTasks = syncTasks;
            this.changedFields = changedFields.add("syncTasks");
            return this;
        }

        public Windows10EasEmailProfileConfiguration build() {
            Windows10EasEmailProfileConfiguration _x = new Windows10EasEmailProfileConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windows10EasEmailProfileConfiguration";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.version = version;
            _x.assignments = assignments;
            _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
            _x.deviceStatuses = deviceStatuses;
            _x.deviceStatusOverview = deviceStatusOverview;
            _x.groupAssignments = groupAssignments;
            _x.userStatuses = userStatuses;
            _x.userStatusOverview = userStatusOverview;
            _x.customDomainName = customDomainName;
            _x.userDomainNameSource = userDomainNameSource;
            _x.usernameAADSource = usernameAADSource;
            _x.usernameSource = usernameSource;
            _x.accountName = accountName;
            _x.durationOfEmailToSync = durationOfEmailToSync;
            _x.emailAddressSource = emailAddressSource;
            _x.emailSyncSchedule = emailSyncSchedule;
            _x.hostName = hostName;
            _x.requireSsl = requireSsl;
            _x.syncCalendar = syncCalendar;
            _x.syncContacts = syncContacts;
            _x.syncTasks = syncTasks;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Account name.”</i>
     * 
     * @return property accountName
     */
    @Property(name="accountName")
    @JsonIgnore
    public Optional<String> getAccountName() {
        return Optional.ofNullable(accountName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code accountName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Account name.”</i>
     * 
     * @param accountName
     *            new value of {@code accountName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code accountName} field changed
     */
    public Windows10EasEmailProfileConfiguration withAccountName(String accountName) {
        Windows10EasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("accountName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EasEmailProfileConfiguration");
        _x.accountName = accountName;
        return _x;
    }

    /**
     * <i>“Duration of email to sync.”</i>
     * 
     * @return property durationOfEmailToSync
     */
    @Property(name="durationOfEmailToSync")
    @JsonIgnore
    public Optional<EmailSyncDuration> getDurationOfEmailToSync() {
        return Optional.ofNullable(durationOfEmailToSync);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * durationOfEmailToSync} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Duration of email to sync.”</i>
     * 
     * @param durationOfEmailToSync
     *            new value of {@code durationOfEmailToSync} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code durationOfEmailToSync} field changed
     */
    public Windows10EasEmailProfileConfiguration withDurationOfEmailToSync(EmailSyncDuration durationOfEmailToSync) {
        Windows10EasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("durationOfEmailToSync");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EasEmailProfileConfiguration");
        _x.durationOfEmailToSync = durationOfEmailToSync;
        return _x;
    }

    /**
     * <i>“Email attribute that is picked from AAD and injected into this profile before
     * installing on the device.”</i>
     * 
     * @return property emailAddressSource
     */
    @Property(name="emailAddressSource")
    @JsonIgnore
    public Optional<UserEmailSource> getEmailAddressSource() {
        return Optional.ofNullable(emailAddressSource);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * emailAddressSource} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Email attribute that is picked from AAD and injected into this profile before
     * installing on the device.”</i>
     * 
     * @param emailAddressSource
     *            new value of {@code emailAddressSource} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code emailAddressSource} field changed
     */
    public Windows10EasEmailProfileConfiguration withEmailAddressSource(UserEmailSource emailAddressSource) {
        Windows10EasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("emailAddressSource");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EasEmailProfileConfiguration");
        _x.emailAddressSource = emailAddressSource;
        return _x;
    }

    /**
     * <i>“Email sync schedule.”</i>
     * 
     * @return property emailSyncSchedule
     */
    @Property(name="emailSyncSchedule")
    @JsonIgnore
    public Optional<EmailSyncSchedule> getEmailSyncSchedule() {
        return Optional.ofNullable(emailSyncSchedule);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code emailSyncSchedule
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Email sync schedule.”</i>
     * 
     * @param emailSyncSchedule
     *            new value of {@code emailSyncSchedule} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code emailSyncSchedule} field changed
     */
    public Windows10EasEmailProfileConfiguration withEmailSyncSchedule(EmailSyncSchedule emailSyncSchedule) {
        Windows10EasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("emailSyncSchedule");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EasEmailProfileConfiguration");
        _x.emailSyncSchedule = emailSyncSchedule;
        return _x;
    }

    /**
     * <i>“Exchange location that (URL) that the native mail app connects to.”</i>
     * 
     * @return property hostName
     */
    @Property(name="hostName")
    @JsonIgnore
    public Optional<String> getHostName() {
        return Optional.ofNullable(hostName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code hostName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Exchange location that (URL) that the native mail app connects to.”</i>
     * 
     * @param hostName
     *            new value of {@code hostName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code hostName} field changed
     */
    public Windows10EasEmailProfileConfiguration withHostName(String hostName) {
        Windows10EasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("hostName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EasEmailProfileConfiguration");
        _x.hostName = hostName;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to use SSL.”</i>
     * 
     * @return property requireSsl
     */
    @Property(name="requireSsl")
    @JsonIgnore
    public Optional<Boolean> getRequireSsl() {
        return Optional.ofNullable(requireSsl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code requireSsl} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Indicates whether or not to use SSL.”</i>
     * 
     * @param requireSsl
     *            new value of {@code requireSsl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requireSsl} field changed
     */
    public Windows10EasEmailProfileConfiguration withRequireSsl(Boolean requireSsl) {
        Windows10EasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("requireSsl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EasEmailProfileConfiguration");
        _x.requireSsl = requireSsl;
        return _x;
    }

    /**
     * <i>“Whether or not to sync the calendar.”</i>
     * 
     * @return property syncCalendar
     */
    @Property(name="syncCalendar")
    @JsonIgnore
    public Optional<Boolean> getSyncCalendar() {
        return Optional.ofNullable(syncCalendar);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code syncCalendar}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Whether or not to sync the calendar.”</i>
     * 
     * @param syncCalendar
     *            new value of {@code syncCalendar} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code syncCalendar} field changed
     */
    public Windows10EasEmailProfileConfiguration withSyncCalendar(Boolean syncCalendar) {
        Windows10EasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("syncCalendar");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EasEmailProfileConfiguration");
        _x.syncCalendar = syncCalendar;
        return _x;
    }

    /**
     * <i>“Whether or not to sync contacts.”</i>
     * 
     * @return property syncContacts
     */
    @Property(name="syncContacts")
    @JsonIgnore
    public Optional<Boolean> getSyncContacts() {
        return Optional.ofNullable(syncContacts);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code syncContacts}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Whether or not to sync contacts.”</i>
     * 
     * @param syncContacts
     *            new value of {@code syncContacts} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code syncContacts} field changed
     */
    public Windows10EasEmailProfileConfiguration withSyncContacts(Boolean syncContacts) {
        Windows10EasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("syncContacts");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EasEmailProfileConfiguration");
        _x.syncContacts = syncContacts;
        return _x;
    }

    /**
     * <i>“Whether or not to sync tasks.”</i>
     * 
     * @return property syncTasks
     */
    @Property(name="syncTasks")
    @JsonIgnore
    public Optional<Boolean> getSyncTasks() {
        return Optional.ofNullable(syncTasks);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code syncTasks} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Whether or not to sync tasks.”</i>
     * 
     * @param syncTasks
     *            new value of {@code syncTasks} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code syncTasks} field changed
     */
    public Windows10EasEmailProfileConfiguration withSyncTasks(Boolean syncTasks) {
        Windows10EasEmailProfileConfiguration _x = _copy();
        _x.changedFields = changedFields.add("syncTasks");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10EasEmailProfileConfiguration");
        _x.syncTasks = syncTasks;
        return _x;
    }

    public Windows10EasEmailProfileConfiguration withUnmappedField(String name, Object value) {
        Windows10EasEmailProfileConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows10EasEmailProfileConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Windows10EasEmailProfileConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows10EasEmailProfileConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Windows10EasEmailProfileConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Windows10EasEmailProfileConfiguration _copy() {
        Windows10EasEmailProfileConfiguration _x = new Windows10EasEmailProfileConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.version = version;
        _x.assignments = assignments;
        _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
        _x.deviceStatuses = deviceStatuses;
        _x.deviceStatusOverview = deviceStatusOverview;
        _x.groupAssignments = groupAssignments;
        _x.userStatuses = userStatuses;
        _x.userStatusOverview = userStatusOverview;
        _x.customDomainName = customDomainName;
        _x.userDomainNameSource = userDomainNameSource;
        _x.usernameAADSource = usernameAADSource;
        _x.usernameSource = usernameSource;
        _x.accountName = accountName;
        _x.durationOfEmailToSync = durationOfEmailToSync;
        _x.emailAddressSource = emailAddressSource;
        _x.emailSyncSchedule = emailSyncSchedule;
        _x.hostName = hostName;
        _x.requireSsl = requireSsl;
        _x.syncCalendar = syncCalendar;
        _x.syncContacts = syncContacts;
        _x.syncTasks = syncTasks;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Windows10EasEmailProfileConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceSettingStateSummaries=");
        b.append(this.deviceSettingStateSummaries);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("deviceStatusOverview=");
        b.append(this.deviceStatusOverview);
        b.append(", ");
        b.append("groupAssignments=");
        b.append(this.groupAssignments);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("userStatusOverview=");
        b.append(this.userStatusOverview);
        b.append(", ");
        b.append("customDomainName=");
        b.append(this.customDomainName);
        b.append(", ");
        b.append("userDomainNameSource=");
        b.append(this.userDomainNameSource);
        b.append(", ");
        b.append("usernameAADSource=");
        b.append(this.usernameAADSource);
        b.append(", ");
        b.append("usernameSource=");
        b.append(this.usernameSource);
        b.append(", ");
        b.append("accountName=");
        b.append(this.accountName);
        b.append(", ");
        b.append("durationOfEmailToSync=");
        b.append(this.durationOfEmailToSync);
        b.append(", ");
        b.append("emailAddressSource=");
        b.append(this.emailAddressSource);
        b.append(", ");
        b.append("emailSyncSchedule=");
        b.append(this.emailSyncSchedule);
        b.append(", ");
        b.append("hostName=");
        b.append(this.hostName);
        b.append(", ");
        b.append("requireSsl=");
        b.append(this.requireSsl);
        b.append(", ");
        b.append("syncCalendar=");
        b.append(this.syncCalendar);
        b.append(", ");
        b.append("syncContacts=");
        b.append(this.syncContacts);
        b.append(", ");
        b.append("syncTasks=");
        b.append(this.syncTasks);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
