package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.enums.ChangeUefiSettingsPermission;
import odata.msgraph.client.beta.enums.Enablement;


/**
 * <i>“Graph properties for Device Firmware Configuration Interface”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "bootFromBuiltInNetworkAdapters", 
    "bootFromExternalMedia", 
    "cameras", 
    "changeUefiSettingsPermission", 
    "microphonesAndSpeakers", 
    "radios", 
    "simultaneousMultiThreading", 
    "virtualizationOfCpuAndIO", 
    "windowsPlatformBinaryTable"})
@JsonInclude(Include.NON_NULL)
public class Windows10DeviceFirmwareConfigurationInterface extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windows10DeviceFirmwareConfigurationInterface";
    }

    @JsonProperty("bootFromBuiltInNetworkAdapters")
    protected Enablement bootFromBuiltInNetworkAdapters;

    @JsonProperty("bootFromExternalMedia")
    protected Enablement bootFromExternalMedia;

    @JsonProperty("cameras")
    protected Enablement cameras;

    @JsonProperty("changeUefiSettingsPermission")
    protected ChangeUefiSettingsPermission changeUefiSettingsPermission;

    @JsonProperty("microphonesAndSpeakers")
    protected Enablement microphonesAndSpeakers;

    @JsonProperty("radios")
    protected Enablement radios;

    @JsonProperty("simultaneousMultiThreading")
    protected Enablement simultaneousMultiThreading;

    @JsonProperty("virtualizationOfCpuAndIO")
    protected Enablement virtualizationOfCpuAndIO;

    @JsonProperty("windowsPlatformBinaryTable")
    protected Enablement windowsPlatformBinaryTable;

    protected Windows10DeviceFirmwareConfigurationInterface() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWindows10DeviceFirmwareConfigurationInterface() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private Integer version;
        private List<DeviceConfigurationAssignment> assignments;
        private List<SettingStateDeviceSummary> deviceSettingStateSummaries;
        private List<DeviceConfigurationDeviceStatus> deviceStatuses;
        private DeviceConfigurationDeviceOverview deviceStatusOverview;
        private List<DeviceConfigurationGroupAssignment> groupAssignments;
        private List<DeviceConfigurationUserStatus> userStatuses;
        private DeviceConfigurationUserOverview userStatusOverview;
        private Enablement bootFromBuiltInNetworkAdapters;
        private Enablement bootFromExternalMedia;
        private Enablement cameras;
        private ChangeUefiSettingsPermission changeUefiSettingsPermission;
        private Enablement microphonesAndSpeakers;
        private Enablement radios;
        private Enablement simultaneousMultiThreading;
        private Enablement virtualizationOfCpuAndIO;
        private Enablement windowsPlatformBinaryTable;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder assignments(List<DeviceConfigurationAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(DeviceConfigurationAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder deviceSettingStateSummaries(List<SettingStateDeviceSummary> deviceSettingStateSummaries) {
            this.deviceSettingStateSummaries = deviceSettingStateSummaries;
            this.changedFields = changedFields.add("deviceSettingStateSummaries");
            return this;
        }

        public Builder deviceSettingStateSummaries(SettingStateDeviceSummary... deviceSettingStateSummaries) {
            return deviceSettingStateSummaries(Arrays.asList(deviceSettingStateSummaries));
        }

        public Builder deviceStatuses(List<DeviceConfigurationDeviceStatus> deviceStatuses) {
            this.deviceStatuses = deviceStatuses;
            this.changedFields = changedFields.add("deviceStatuses");
            return this;
        }

        public Builder deviceStatuses(DeviceConfigurationDeviceStatus... deviceStatuses) {
            return deviceStatuses(Arrays.asList(deviceStatuses));
        }

        public Builder deviceStatusOverview(DeviceConfigurationDeviceOverview deviceStatusOverview) {
            this.deviceStatusOverview = deviceStatusOverview;
            this.changedFields = changedFields.add("deviceStatusOverview");
            return this;
        }

        public Builder groupAssignments(List<DeviceConfigurationGroupAssignment> groupAssignments) {
            this.groupAssignments = groupAssignments;
            this.changedFields = changedFields.add("groupAssignments");
            return this;
        }

        public Builder groupAssignments(DeviceConfigurationGroupAssignment... groupAssignments) {
            return groupAssignments(Arrays.asList(groupAssignments));
        }

        public Builder userStatuses(List<DeviceConfigurationUserStatus> userStatuses) {
            this.userStatuses = userStatuses;
            this.changedFields = changedFields.add("userStatuses");
            return this;
        }

        public Builder userStatuses(DeviceConfigurationUserStatus... userStatuses) {
            return userStatuses(Arrays.asList(userStatuses));
        }

        public Builder userStatusOverview(DeviceConfigurationUserOverview userStatusOverview) {
            this.userStatusOverview = userStatusOverview;
            this.changedFields = changedFields.add("userStatusOverview");
            return this;
        }

        /**
         * <i>“Defines whether a user is allowed to boot from built-in network adapters.”</i>
         * 
         * @param bootFromBuiltInNetworkAdapters
         *            value of {@code bootFromBuiltInNetworkAdapters} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bootFromBuiltInNetworkAdapters(Enablement bootFromBuiltInNetworkAdapters) {
            this.bootFromBuiltInNetworkAdapters = bootFromBuiltInNetworkAdapters;
            this.changedFields = changedFields.add("bootFromBuiltInNetworkAdapters");
            return this;
        }

        /**
         * <i>“Defines whether a user is allowed to boot from external media.”</i>
         * 
         * @param bootFromExternalMedia
         *            value of {@code bootFromExternalMedia} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bootFromExternalMedia(Enablement bootFromExternalMedia) {
            this.bootFromExternalMedia = bootFromExternalMedia;
            this.changedFields = changedFields.add("bootFromExternalMedia");
            return this;
        }

        /**
         * <i>“Defines whether built-in cameras are enabled.”</i>
         * 
         * @param cameras
         *            value of {@code cameras} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cameras(Enablement cameras) {
            this.cameras = cameras;
            this.changedFields = changedFields.add("cameras");
            return this;
        }

        /**
         * <i>“Defines the permission level granted to users to change UEFI settings.”</i>
         * 
         * @param changeUefiSettingsPermission
         *            value of {@code changeUefiSettingsPermission} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder changeUefiSettingsPermission(ChangeUefiSettingsPermission changeUefiSettingsPermission) {
            this.changeUefiSettingsPermission = changeUefiSettingsPermission;
            this.changedFields = changedFields.add("changeUefiSettingsPermission");
            return this;
        }

        /**
         * <i>“Defines whether built-in microphones or speakers are enabled.”</i>
         * 
         * @param microphonesAndSpeakers
         *            value of {@code microphonesAndSpeakers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microphonesAndSpeakers(Enablement microphonesAndSpeakers) {
            this.microphonesAndSpeakers = microphonesAndSpeakers;
            this.changedFields = changedFields.add("microphonesAndSpeakers");
            return this;
        }

        /**
         * <i>“Defines whether built-in radios e.g. WIFI, NFC, Bluetooth, are enabled.”</i>
         * 
         * @param radios
         *            value of {@code radios} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder radios(Enablement radios) {
            this.radios = radios;
            this.changedFields = changedFields.add("radios");
            return this;
        }

        /**
         * <i>“Defines whether a user is allowed to enable Simultaneous MultiThreading.”</i>
         * 
         * @param simultaneousMultiThreading
         *            value of {@code simultaneousMultiThreading} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder simultaneousMultiThreading(Enablement simultaneousMultiThreading) {
            this.simultaneousMultiThreading = simultaneousMultiThreading;
            this.changedFields = changedFields.add("simultaneousMultiThreading");
            return this;
        }

        /**
         * <i>“Defines whether CPU and IO virtualization is enabled.”</i>
         * 
         * @param virtualizationOfCpuAndIO
         *            value of {@code virtualizationOfCpuAndIO} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder virtualizationOfCpuAndIO(Enablement virtualizationOfCpuAndIO) {
            this.virtualizationOfCpuAndIO = virtualizationOfCpuAndIO;
            this.changedFields = changedFields.add("virtualizationOfCpuAndIO");
            return this;
        }

        /**
         * <i>“Defines whether a user is allowed to enable Windows Platform Binary Table.”</i>
         * 
         * @param windowsPlatformBinaryTable
         *            value of {@code windowsPlatformBinaryTable} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsPlatformBinaryTable(Enablement windowsPlatformBinaryTable) {
            this.windowsPlatformBinaryTable = windowsPlatformBinaryTable;
            this.changedFields = changedFields.add("windowsPlatformBinaryTable");
            return this;
        }

        public Windows10DeviceFirmwareConfigurationInterface build() {
            Windows10DeviceFirmwareConfigurationInterface _x = new Windows10DeviceFirmwareConfigurationInterface();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windows10DeviceFirmwareConfigurationInterface";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.version = version;
            _x.assignments = assignments;
            _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
            _x.deviceStatuses = deviceStatuses;
            _x.deviceStatusOverview = deviceStatusOverview;
            _x.groupAssignments = groupAssignments;
            _x.userStatuses = userStatuses;
            _x.userStatusOverview = userStatusOverview;
            _x.bootFromBuiltInNetworkAdapters = bootFromBuiltInNetworkAdapters;
            _x.bootFromExternalMedia = bootFromExternalMedia;
            _x.cameras = cameras;
            _x.changeUefiSettingsPermission = changeUefiSettingsPermission;
            _x.microphonesAndSpeakers = microphonesAndSpeakers;
            _x.radios = radios;
            _x.simultaneousMultiThreading = simultaneousMultiThreading;
            _x.virtualizationOfCpuAndIO = virtualizationOfCpuAndIO;
            _x.windowsPlatformBinaryTable = windowsPlatformBinaryTable;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Defines whether a user is allowed to boot from built-in network adapters.”</i>
     * 
     * @return property bootFromBuiltInNetworkAdapters
     */
    @Property(name="bootFromBuiltInNetworkAdapters")
    @JsonIgnore
    public Optional<Enablement> getBootFromBuiltInNetworkAdapters() {
        return Optional.ofNullable(bootFromBuiltInNetworkAdapters);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bootFromBuiltInNetworkAdapters} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Defines whether a user is allowed to boot from built-in network adapters.”</i>
     * 
     * @param bootFromBuiltInNetworkAdapters
     *            new value of {@code bootFromBuiltInNetworkAdapters} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bootFromBuiltInNetworkAdapters} field changed
     */
    public Windows10DeviceFirmwareConfigurationInterface withBootFromBuiltInNetworkAdapters(Enablement bootFromBuiltInNetworkAdapters) {
        Windows10DeviceFirmwareConfigurationInterface _x = _copy();
        _x.changedFields = changedFields.add("bootFromBuiltInNetworkAdapters");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10DeviceFirmwareConfigurationInterface");
        _x.bootFromBuiltInNetworkAdapters = bootFromBuiltInNetworkAdapters;
        return _x;
    }

    /**
     * <i>“Defines whether a user is allowed to boot from external media.”</i>
     * 
     * @return property bootFromExternalMedia
     */
    @Property(name="bootFromExternalMedia")
    @JsonIgnore
    public Optional<Enablement> getBootFromExternalMedia() {
        return Optional.ofNullable(bootFromExternalMedia);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bootFromExternalMedia} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Defines whether a user is allowed to boot from external media.”</i>
     * 
     * @param bootFromExternalMedia
     *            new value of {@code bootFromExternalMedia} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bootFromExternalMedia} field changed
     */
    public Windows10DeviceFirmwareConfigurationInterface withBootFromExternalMedia(Enablement bootFromExternalMedia) {
        Windows10DeviceFirmwareConfigurationInterface _x = _copy();
        _x.changedFields = changedFields.add("bootFromExternalMedia");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10DeviceFirmwareConfigurationInterface");
        _x.bootFromExternalMedia = bootFromExternalMedia;
        return _x;
    }

    /**
     * <i>“Defines whether built-in cameras are enabled.”</i>
     * 
     * @return property cameras
     */
    @Property(name="cameras")
    @JsonIgnore
    public Optional<Enablement> getCameras() {
        return Optional.ofNullable(cameras);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code cameras} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Defines whether built-in cameras are enabled.”</i>
     * 
     * @param cameras
     *            new value of {@code cameras} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cameras} field changed
     */
    public Windows10DeviceFirmwareConfigurationInterface withCameras(Enablement cameras) {
        Windows10DeviceFirmwareConfigurationInterface _x = _copy();
        _x.changedFields = changedFields.add("cameras");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10DeviceFirmwareConfigurationInterface");
        _x.cameras = cameras;
        return _x;
    }

    /**
     * <i>“Defines the permission level granted to users to change UEFI settings.”</i>
     * 
     * @return property changeUefiSettingsPermission
     */
    @Property(name="changeUefiSettingsPermission")
    @JsonIgnore
    public Optional<ChangeUefiSettingsPermission> getChangeUefiSettingsPermission() {
        return Optional.ofNullable(changeUefiSettingsPermission);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * changeUefiSettingsPermission} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Defines the permission level granted to users to change UEFI settings.”</i>
     * 
     * @param changeUefiSettingsPermission
     *            new value of {@code changeUefiSettingsPermission} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code changeUefiSettingsPermission} field changed
     */
    public Windows10DeviceFirmwareConfigurationInterface withChangeUefiSettingsPermission(ChangeUefiSettingsPermission changeUefiSettingsPermission) {
        Windows10DeviceFirmwareConfigurationInterface _x = _copy();
        _x.changedFields = changedFields.add("changeUefiSettingsPermission");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10DeviceFirmwareConfigurationInterface");
        _x.changeUefiSettingsPermission = changeUefiSettingsPermission;
        return _x;
    }

    /**
     * <i>“Defines whether built-in microphones or speakers are enabled.”</i>
     * 
     * @return property microphonesAndSpeakers
     */
    @Property(name="microphonesAndSpeakers")
    @JsonIgnore
    public Optional<Enablement> getMicrophonesAndSpeakers() {
        return Optional.ofNullable(microphonesAndSpeakers);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * microphonesAndSpeakers} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Defines whether built-in microphones or speakers are enabled.”</i>
     * 
     * @param microphonesAndSpeakers
     *            new value of {@code microphonesAndSpeakers} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code microphonesAndSpeakers} field changed
     */
    public Windows10DeviceFirmwareConfigurationInterface withMicrophonesAndSpeakers(Enablement microphonesAndSpeakers) {
        Windows10DeviceFirmwareConfigurationInterface _x = _copy();
        _x.changedFields = changedFields.add("microphonesAndSpeakers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10DeviceFirmwareConfigurationInterface");
        _x.microphonesAndSpeakers = microphonesAndSpeakers;
        return _x;
    }

    /**
     * <i>“Defines whether built-in radios e.g. WIFI, NFC, Bluetooth, are enabled.”</i>
     * 
     * @return property radios
     */
    @Property(name="radios")
    @JsonIgnore
    public Optional<Enablement> getRadios() {
        return Optional.ofNullable(radios);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code radios} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Defines whether built-in radios e.g. WIFI, NFC, Bluetooth, are enabled.”</i>
     * 
     * @param radios
     *            new value of {@code radios} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code radios} field changed
     */
    public Windows10DeviceFirmwareConfigurationInterface withRadios(Enablement radios) {
        Windows10DeviceFirmwareConfigurationInterface _x = _copy();
        _x.changedFields = changedFields.add("radios");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10DeviceFirmwareConfigurationInterface");
        _x.radios = radios;
        return _x;
    }

    /**
     * <i>“Defines whether a user is allowed to enable Simultaneous MultiThreading.”</i>
     * 
     * @return property simultaneousMultiThreading
     */
    @Property(name="simultaneousMultiThreading")
    @JsonIgnore
    public Optional<Enablement> getSimultaneousMultiThreading() {
        return Optional.ofNullable(simultaneousMultiThreading);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * simultaneousMultiThreading} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Defines whether a user is allowed to enable Simultaneous MultiThreading.”</i>
     * 
     * @param simultaneousMultiThreading
     *            new value of {@code simultaneousMultiThreading} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code simultaneousMultiThreading} field changed
     */
    public Windows10DeviceFirmwareConfigurationInterface withSimultaneousMultiThreading(Enablement simultaneousMultiThreading) {
        Windows10DeviceFirmwareConfigurationInterface _x = _copy();
        _x.changedFields = changedFields.add("simultaneousMultiThreading");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10DeviceFirmwareConfigurationInterface");
        _x.simultaneousMultiThreading = simultaneousMultiThreading;
        return _x;
    }

    /**
     * <i>“Defines whether CPU and IO virtualization is enabled.”</i>
     * 
     * @return property virtualizationOfCpuAndIO
     */
    @Property(name="virtualizationOfCpuAndIO")
    @JsonIgnore
    public Optional<Enablement> getVirtualizationOfCpuAndIO() {
        return Optional.ofNullable(virtualizationOfCpuAndIO);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * virtualizationOfCpuAndIO} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Defines whether CPU and IO virtualization is enabled.”</i>
     * 
     * @param virtualizationOfCpuAndIO
     *            new value of {@code virtualizationOfCpuAndIO} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code virtualizationOfCpuAndIO} field changed
     */
    public Windows10DeviceFirmwareConfigurationInterface withVirtualizationOfCpuAndIO(Enablement virtualizationOfCpuAndIO) {
        Windows10DeviceFirmwareConfigurationInterface _x = _copy();
        _x.changedFields = changedFields.add("virtualizationOfCpuAndIO");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10DeviceFirmwareConfigurationInterface");
        _x.virtualizationOfCpuAndIO = virtualizationOfCpuAndIO;
        return _x;
    }

    /**
     * <i>“Defines whether a user is allowed to enable Windows Platform Binary Table.”</i>
     * 
     * @return property windowsPlatformBinaryTable
     */
    @Property(name="windowsPlatformBinaryTable")
    @JsonIgnore
    public Optional<Enablement> getWindowsPlatformBinaryTable() {
        return Optional.ofNullable(windowsPlatformBinaryTable);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsPlatformBinaryTable} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Defines whether a user is allowed to enable Windows Platform Binary Table.”</i>
     * 
     * @param windowsPlatformBinaryTable
     *            new value of {@code windowsPlatformBinaryTable} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsPlatformBinaryTable} field changed
     */
    public Windows10DeviceFirmwareConfigurationInterface withWindowsPlatformBinaryTable(Enablement windowsPlatformBinaryTable) {
        Windows10DeviceFirmwareConfigurationInterface _x = _copy();
        _x.changedFields = changedFields.add("windowsPlatformBinaryTable");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windows10DeviceFirmwareConfigurationInterface");
        _x.windowsPlatformBinaryTable = windowsPlatformBinaryTable;
        return _x;
    }

    public Windows10DeviceFirmwareConfigurationInterface withUnmappedField(String name, Object value) {
        Windows10DeviceFirmwareConfigurationInterface _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows10DeviceFirmwareConfigurationInterface patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Windows10DeviceFirmwareConfigurationInterface _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Windows10DeviceFirmwareConfigurationInterface put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Windows10DeviceFirmwareConfigurationInterface _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Windows10DeviceFirmwareConfigurationInterface _copy() {
        Windows10DeviceFirmwareConfigurationInterface _x = new Windows10DeviceFirmwareConfigurationInterface();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.version = version;
        _x.assignments = assignments;
        _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
        _x.deviceStatuses = deviceStatuses;
        _x.deviceStatusOverview = deviceStatusOverview;
        _x.groupAssignments = groupAssignments;
        _x.userStatuses = userStatuses;
        _x.userStatusOverview = userStatusOverview;
        _x.bootFromBuiltInNetworkAdapters = bootFromBuiltInNetworkAdapters;
        _x.bootFromExternalMedia = bootFromExternalMedia;
        _x.cameras = cameras;
        _x.changeUefiSettingsPermission = changeUefiSettingsPermission;
        _x.microphonesAndSpeakers = microphonesAndSpeakers;
        _x.radios = radios;
        _x.simultaneousMultiThreading = simultaneousMultiThreading;
        _x.virtualizationOfCpuAndIO = virtualizationOfCpuAndIO;
        _x.windowsPlatformBinaryTable = windowsPlatformBinaryTable;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Windows10DeviceFirmwareConfigurationInterface[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceSettingStateSummaries=");
        b.append(this.deviceSettingStateSummaries);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("deviceStatusOverview=");
        b.append(this.deviceStatusOverview);
        b.append(", ");
        b.append("groupAssignments=");
        b.append(this.groupAssignments);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("userStatusOverview=");
        b.append(this.userStatusOverview);
        b.append(", ");
        b.append("bootFromBuiltInNetworkAdapters=");
        b.append(this.bootFromBuiltInNetworkAdapters);
        b.append(", ");
        b.append("bootFromExternalMedia=");
        b.append(this.bootFromExternalMedia);
        b.append(", ");
        b.append("cameras=");
        b.append(this.cameras);
        b.append(", ");
        b.append("changeUefiSettingsPermission=");
        b.append(this.changeUefiSettingsPermission);
        b.append(", ");
        b.append("microphonesAndSpeakers=");
        b.append(this.microphonesAndSpeakers);
        b.append(", ");
        b.append("radios=");
        b.append(this.radios);
        b.append(", ");
        b.append("simultaneousMultiThreading=");
        b.append(this.simultaneousMultiThreading);
        b.append(", ");
        b.append("virtualizationOfCpuAndIO=");
        b.append(this.virtualizationOfCpuAndIO);
        b.append(", ");
        b.append("windowsPlatformBinaryTable=");
        b.append(this.windowsPlatformBinaryTable);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
