package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.WellKnownListName_v2;

@JsonPropertyOrder({
    "@odata.type", 
    "wellKnownListName"})
@JsonInclude(Include.NON_NULL)
public class WellKnownTaskList extends BaseTaskList implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.wellKnownTaskList";
    }

    @JsonProperty("wellKnownListName")
    protected WellKnownListName_v2 wellKnownListName;

    protected WellKnownTaskList() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWellKnownTaskList() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private List<Extension> extensions;
        private List<BaseTask> tasks;
        private WellKnownListName_v2 wellKnownListName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder extensions(List<Extension> extensions) {
            this.extensions = extensions;
            this.changedFields = changedFields.add("extensions");
            return this;
        }

        public Builder extensions(Extension... extensions) {
            return extensions(Arrays.asList(extensions));
        }

        public Builder tasks(List<BaseTask> tasks) {
            this.tasks = tasks;
            this.changedFields = changedFields.add("tasks");
            return this;
        }

        public Builder tasks(BaseTask... tasks) {
            return tasks(Arrays.asList(tasks));
        }

        public Builder wellKnownListName(WellKnownListName_v2 wellKnownListName) {
            this.wellKnownListName = wellKnownListName;
            this.changedFields = changedFields.add("wellKnownListName");
            return this;
        }

        public WellKnownTaskList build() {
            WellKnownTaskList _x = new WellKnownTaskList();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.wellKnownTaskList";
            _x.id = id;
            _x.displayName = displayName;
            _x.extensions = extensions;
            _x.tasks = tasks;
            _x.wellKnownListName = wellKnownListName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="wellKnownListName")
    @JsonIgnore
    public Optional<WellKnownListName_v2> getWellKnownListName() {
        return Optional.ofNullable(wellKnownListName);
    }

    public WellKnownTaskList withWellKnownListName(WellKnownListName_v2 wellKnownListName) {
        WellKnownTaskList _x = _copy();
        _x.changedFields = changedFields.add("wellKnownListName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.wellKnownTaskList");
        _x.wellKnownListName = wellKnownListName;
        return _x;
    }

    public WellKnownTaskList withUnmappedField(String name, Object value) {
        WellKnownTaskList _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WellKnownTaskList patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WellKnownTaskList _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WellKnownTaskList put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WellKnownTaskList _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WellKnownTaskList _copy() {
        WellKnownTaskList _x = new WellKnownTaskList();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.extensions = extensions;
        _x.tasks = tasks;
        _x.wellKnownListName = wellKnownListName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WellKnownTaskList[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("extensions=");
        b.append(this.extensions);
        b.append(", ");
        b.append("tasks=");
        b.append(this.tasks);
        b.append(", ");
        b.append("wellKnownListName=");
        b.append(this.wellKnownListName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
