package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.CloudPCCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CloudPcAuditEventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CloudPcDeviceImageCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CloudPcGalleryImageCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CloudPcOnPremisesConnectionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CloudPcProvisioningPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CloudPcServicePlanCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CloudPcSnapshotCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CloudPcSupportedRegionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CloudPcUserSettingCollectionRequest;
import odata.msgraph.client.beta.entity.request.CloudPcOrganizationSettingsRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "auditEvents", 
    "cloudPCs", 
    "deviceImages", 
    "galleryImages", 
    "onPremisesConnections", 
    "organizationSettings", 
    "provisioningPolicies", 
    "servicePlans", 
    "snapshots", 
    "supportedRegions", 
    "userSettings"})
@JsonInclude(Include.NON_NULL)
public class VirtualEndpoint extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.virtualEndpoint";
    }

    @JsonProperty("auditEvents")
    protected List<CloudPcAuditEvent> auditEvents;

    @JsonProperty("cloudPCs")
    protected List<CloudPC> cloudPCs;

    @JsonProperty("deviceImages")
    protected List<CloudPcDeviceImage> deviceImages;

    @JsonProperty("galleryImages")
    protected List<CloudPcGalleryImage> galleryImages;

    @JsonProperty("onPremisesConnections")
    protected List<CloudPcOnPremisesConnection> onPremisesConnections;

    @JsonProperty("organizationSettings")
    protected CloudPcOrganizationSettings organizationSettings;

    @JsonProperty("provisioningPolicies")
    protected List<CloudPcProvisioningPolicy> provisioningPolicies;

    @JsonProperty("servicePlans")
    protected List<CloudPcServicePlan> servicePlans;

    @JsonProperty("snapshots")
    protected List<CloudPcSnapshot> snapshots;

    @JsonProperty("supportedRegions")
    protected List<CloudPcSupportedRegion> supportedRegions;

    @JsonProperty("userSettings")
    protected List<CloudPcUserSetting> userSettings;

    protected VirtualEndpoint() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderVirtualEndpoint() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<CloudPcAuditEvent> auditEvents;
        private List<CloudPC> cloudPCs;
        private List<CloudPcDeviceImage> deviceImages;
        private List<CloudPcGalleryImage> galleryImages;
        private List<CloudPcOnPremisesConnection> onPremisesConnections;
        private CloudPcOrganizationSettings organizationSettings;
        private List<CloudPcProvisioningPolicy> provisioningPolicies;
        private List<CloudPcServicePlan> servicePlans;
        private List<CloudPcSnapshot> snapshots;
        private List<CloudPcSupportedRegion> supportedRegions;
        private List<CloudPcUserSetting> userSettings;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder auditEvents(List<CloudPcAuditEvent> auditEvents) {
            this.auditEvents = auditEvents;
            this.changedFields = changedFields.add("auditEvents");
            return this;
        }

        public Builder auditEvents(CloudPcAuditEvent... auditEvents) {
            return auditEvents(Arrays.asList(auditEvents));
        }

        public Builder cloudPCs(List<CloudPC> cloudPCs) {
            this.cloudPCs = cloudPCs;
            this.changedFields = changedFields.add("cloudPCs");
            return this;
        }

        public Builder cloudPCs(CloudPC... cloudPCs) {
            return cloudPCs(Arrays.asList(cloudPCs));
        }

        public Builder deviceImages(List<CloudPcDeviceImage> deviceImages) {
            this.deviceImages = deviceImages;
            this.changedFields = changedFields.add("deviceImages");
            return this;
        }

        public Builder deviceImages(CloudPcDeviceImage... deviceImages) {
            return deviceImages(Arrays.asList(deviceImages));
        }

        public Builder galleryImages(List<CloudPcGalleryImage> galleryImages) {
            this.galleryImages = galleryImages;
            this.changedFields = changedFields.add("galleryImages");
            return this;
        }

        public Builder galleryImages(CloudPcGalleryImage... galleryImages) {
            return galleryImages(Arrays.asList(galleryImages));
        }

        public Builder onPremisesConnections(List<CloudPcOnPremisesConnection> onPremisesConnections) {
            this.onPremisesConnections = onPremisesConnections;
            this.changedFields = changedFields.add("onPremisesConnections");
            return this;
        }

        public Builder onPremisesConnections(CloudPcOnPremisesConnection... onPremisesConnections) {
            return onPremisesConnections(Arrays.asList(onPremisesConnections));
        }

        public Builder organizationSettings(CloudPcOrganizationSettings organizationSettings) {
            this.organizationSettings = organizationSettings;
            this.changedFields = changedFields.add("organizationSettings");
            return this;
        }

        public Builder provisioningPolicies(List<CloudPcProvisioningPolicy> provisioningPolicies) {
            this.provisioningPolicies = provisioningPolicies;
            this.changedFields = changedFields.add("provisioningPolicies");
            return this;
        }

        public Builder provisioningPolicies(CloudPcProvisioningPolicy... provisioningPolicies) {
            return provisioningPolicies(Arrays.asList(provisioningPolicies));
        }

        public Builder servicePlans(List<CloudPcServicePlan> servicePlans) {
            this.servicePlans = servicePlans;
            this.changedFields = changedFields.add("servicePlans");
            return this;
        }

        public Builder servicePlans(CloudPcServicePlan... servicePlans) {
            return servicePlans(Arrays.asList(servicePlans));
        }

        public Builder snapshots(List<CloudPcSnapshot> snapshots) {
            this.snapshots = snapshots;
            this.changedFields = changedFields.add("snapshots");
            return this;
        }

        public Builder snapshots(CloudPcSnapshot... snapshots) {
            return snapshots(Arrays.asList(snapshots));
        }

        public Builder supportedRegions(List<CloudPcSupportedRegion> supportedRegions) {
            this.supportedRegions = supportedRegions;
            this.changedFields = changedFields.add("supportedRegions");
            return this;
        }

        public Builder supportedRegions(CloudPcSupportedRegion... supportedRegions) {
            return supportedRegions(Arrays.asList(supportedRegions));
        }

        public Builder userSettings(List<CloudPcUserSetting> userSettings) {
            this.userSettings = userSettings;
            this.changedFields = changedFields.add("userSettings");
            return this;
        }

        public Builder userSettings(CloudPcUserSetting... userSettings) {
            return userSettings(Arrays.asList(userSettings));
        }

        public VirtualEndpoint build() {
            VirtualEndpoint _x = new VirtualEndpoint();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.virtualEndpoint";
            _x.id = id;
            _x.auditEvents = auditEvents;
            _x.cloudPCs = cloudPCs;
            _x.deviceImages = deviceImages;
            _x.galleryImages = galleryImages;
            _x.onPremisesConnections = onPremisesConnections;
            _x.organizationSettings = organizationSettings;
            _x.provisioningPolicies = provisioningPolicies;
            _x.servicePlans = servicePlans;
            _x.snapshots = snapshots;
            _x.supportedRegions = supportedRegions;
            _x.userSettings = userSettings;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public VirtualEndpoint withUnmappedField(String name, Object value) {
        VirtualEndpoint _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="auditEvents")
    @JsonIgnore
    public CloudPcAuditEventCollectionRequest getAuditEvents() {
        return new CloudPcAuditEventCollectionRequest(
                        contextPath.addSegment("auditEvents"), Optional.ofNullable(auditEvents));
    }

    @NavigationProperty(name="cloudPCs")
    @JsonIgnore
    public CloudPCCollectionRequest getCloudPCs() {
        return new CloudPCCollectionRequest(
                        contextPath.addSegment("cloudPCs"), Optional.ofNullable(cloudPCs));
    }

    @NavigationProperty(name="deviceImages")
    @JsonIgnore
    public CloudPcDeviceImageCollectionRequest getDeviceImages() {
        return new CloudPcDeviceImageCollectionRequest(
                        contextPath.addSegment("deviceImages"), Optional.ofNullable(deviceImages));
    }

    @NavigationProperty(name="galleryImages")
    @JsonIgnore
    public CloudPcGalleryImageCollectionRequest getGalleryImages() {
        return new CloudPcGalleryImageCollectionRequest(
                        contextPath.addSegment("galleryImages"), Optional.ofNullable(galleryImages));
    }

    @NavigationProperty(name="onPremisesConnections")
    @JsonIgnore
    public CloudPcOnPremisesConnectionCollectionRequest getOnPremisesConnections() {
        return new CloudPcOnPremisesConnectionCollectionRequest(
                        contextPath.addSegment("onPremisesConnections"), Optional.ofNullable(onPremisesConnections));
    }

    @NavigationProperty(name="organizationSettings")
    @JsonIgnore
    public CloudPcOrganizationSettingsRequest getOrganizationSettings() {
        return new CloudPcOrganizationSettingsRequest(contextPath.addSegment("organizationSettings"), Optional.ofNullable(organizationSettings));
    }

    @NavigationProperty(name="provisioningPolicies")
    @JsonIgnore
    public CloudPcProvisioningPolicyCollectionRequest getProvisioningPolicies() {
        return new CloudPcProvisioningPolicyCollectionRequest(
                        contextPath.addSegment("provisioningPolicies"), Optional.ofNullable(provisioningPolicies));
    }

    @NavigationProperty(name="servicePlans")
    @JsonIgnore
    public CloudPcServicePlanCollectionRequest getServicePlans() {
        return new CloudPcServicePlanCollectionRequest(
                        contextPath.addSegment("servicePlans"), Optional.ofNullable(servicePlans));
    }

    @NavigationProperty(name="snapshots")
    @JsonIgnore
    public CloudPcSnapshotCollectionRequest getSnapshots() {
        return new CloudPcSnapshotCollectionRequest(
                        contextPath.addSegment("snapshots"), Optional.ofNullable(snapshots));
    }

    @NavigationProperty(name="supportedRegions")
    @JsonIgnore
    public CloudPcSupportedRegionCollectionRequest getSupportedRegions() {
        return new CloudPcSupportedRegionCollectionRequest(
                        contextPath.addSegment("supportedRegions"), Optional.ofNullable(supportedRegions));
    }

    @NavigationProperty(name="userSettings")
    @JsonIgnore
    public CloudPcUserSettingCollectionRequest getUserSettings() {
        return new CloudPcUserSettingCollectionRequest(
                        contextPath.addSegment("userSettings"), Optional.ofNullable(userSettings));
    }

    public VirtualEndpoint withAuditEvents(List<CloudPcAuditEvent> auditEvents) {
        VirtualEndpoint _x = _copy();
        _x.changedFields = changedFields.add("auditEvents");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.virtualEndpoint");
        _x.auditEvents = auditEvents;
        return _x;
    }

    public VirtualEndpoint withCloudPCs(List<CloudPC> cloudPCs) {
        VirtualEndpoint _x = _copy();
        _x.changedFields = changedFields.add("cloudPCs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.virtualEndpoint");
        _x.cloudPCs = cloudPCs;
        return _x;
    }

    public VirtualEndpoint withDeviceImages(List<CloudPcDeviceImage> deviceImages) {
        VirtualEndpoint _x = _copy();
        _x.changedFields = changedFields.add("deviceImages");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.virtualEndpoint");
        _x.deviceImages = deviceImages;
        return _x;
    }

    public VirtualEndpoint withGalleryImages(List<CloudPcGalleryImage> galleryImages) {
        VirtualEndpoint _x = _copy();
        _x.changedFields = changedFields.add("galleryImages");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.virtualEndpoint");
        _x.galleryImages = galleryImages;
        return _x;
    }

    public VirtualEndpoint withOnPremisesConnections(List<CloudPcOnPremisesConnection> onPremisesConnections) {
        VirtualEndpoint _x = _copy();
        _x.changedFields = changedFields.add("onPremisesConnections");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.virtualEndpoint");
        _x.onPremisesConnections = onPremisesConnections;
        return _x;
    }

    public VirtualEndpoint withOrganizationSettings(CloudPcOrganizationSettings organizationSettings) {
        VirtualEndpoint _x = _copy();
        _x.changedFields = changedFields.add("organizationSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.virtualEndpoint");
        _x.organizationSettings = organizationSettings;
        return _x;
    }

    public VirtualEndpoint withProvisioningPolicies(List<CloudPcProvisioningPolicy> provisioningPolicies) {
        VirtualEndpoint _x = _copy();
        _x.changedFields = changedFields.add("provisioningPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.virtualEndpoint");
        _x.provisioningPolicies = provisioningPolicies;
        return _x;
    }

    public VirtualEndpoint withServicePlans(List<CloudPcServicePlan> servicePlans) {
        VirtualEndpoint _x = _copy();
        _x.changedFields = changedFields.add("servicePlans");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.virtualEndpoint");
        _x.servicePlans = servicePlans;
        return _x;
    }

    public VirtualEndpoint withSnapshots(List<CloudPcSnapshot> snapshots) {
        VirtualEndpoint _x = _copy();
        _x.changedFields = changedFields.add("snapshots");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.virtualEndpoint");
        _x.snapshots = snapshots;
        return _x;
    }

    public VirtualEndpoint withSupportedRegions(List<CloudPcSupportedRegion> supportedRegions) {
        VirtualEndpoint _x = _copy();
        _x.changedFields = changedFields.add("supportedRegions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.virtualEndpoint");
        _x.supportedRegions = supportedRegions;
        return _x;
    }

    public VirtualEndpoint withUserSettings(List<CloudPcUserSetting> userSettings) {
        VirtualEndpoint _x = _copy();
        _x.changedFields = changedFields.add("userSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.virtualEndpoint");
        _x.userSettings = userSettings;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public VirtualEndpoint patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        VirtualEndpoint _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public VirtualEndpoint put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        VirtualEndpoint _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private VirtualEndpoint _copy() {
        VirtualEndpoint _x = new VirtualEndpoint();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.auditEvents = auditEvents;
        _x.cloudPCs = cloudPCs;
        _x.deviceImages = deviceImages;
        _x.galleryImages = galleryImages;
        _x.onPremisesConnections = onPremisesConnections;
        _x.organizationSettings = organizationSettings;
        _x.provisioningPolicies = provisioningPolicies;
        _x.servicePlans = servicePlans;
        _x.snapshots = snapshots;
        _x.supportedRegions = supportedRegions;
        _x.userSettings = userSettings;
        return _x;
    }

    @Function(name = "getEffectivePermissions")
    @JsonIgnore
    public CollectionPageNonEntityRequest<String> getEffectivePermissions() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEffectivePermissions"), String.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("VirtualEndpoint[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("auditEvents=");
        b.append(this.auditEvents);
        b.append(", ");
        b.append("cloudPCs=");
        b.append(this.cloudPCs);
        b.append(", ");
        b.append("deviceImages=");
        b.append(this.deviceImages);
        b.append(", ");
        b.append("galleryImages=");
        b.append(this.galleryImages);
        b.append(", ");
        b.append("onPremisesConnections=");
        b.append(this.onPremisesConnections);
        b.append(", ");
        b.append("organizationSettings=");
        b.append(this.organizationSettings);
        b.append(", ");
        b.append("provisioningPolicies=");
        b.append(this.provisioningPolicies);
        b.append(", ");
        b.append("servicePlans=");
        b.append(this.servicePlans);
        b.append(", ");
        b.append("snapshots=");
        b.append(this.snapshots);
        b.append(", ");
        b.append("supportedRegions=");
        b.append(this.supportedRegions);
        b.append(", ");
        b.append("userSettings=");
        b.append(this.userSettings);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
