package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

import odata.msgraph.client.beta.complex.PostalAddressType;
import odata.msgraph.client.beta.entity.collection.request.PictureCollectionRequest;
import odata.msgraph.client.beta.entity.request.CurrencyRequest;
import odata.msgraph.client.beta.entity.request.PaymentMethodRequest;
import odata.msgraph.client.beta.entity.request.PaymentTermRequest;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
 * <p>
 * Deletable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
 * <p>
 * Insertable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
 * <p>
 * Updatable = true
 */@JsonPropertyOrder({
    "@odata.type", 
    "address", 
    "balance", 
    "blocked", 
    "currencyCode", 
    "currencyId", 
    "displayName", 
    "email", 
    "lastModifiedDateTime", 
    "number", 
    "paymentMethodId", 
    "paymentTermsId", 
    "phoneNumber", 
    "taxLiable", 
    "taxRegistrationNumber", 
    "website", 
    "currency", 
    "paymentMethod", 
    "paymentTerm", 
    "picture"})
@JsonInclude(Include.NON_NULL)
public class Vendor extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.vendor";
    }

    @JsonProperty("address")
    protected PostalAddressType address;

    @JsonProperty("balance")
    protected BigDecimal balance;

    @JsonProperty("blocked")
    protected String blocked;

    @JsonProperty("currencyCode")
    protected String currencyCode;

    @JsonProperty("currencyId")
    protected UUID currencyId;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("email")
    protected String email;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("number")
    protected String number;

    @JsonProperty("paymentMethodId")
    protected UUID paymentMethodId;

    @JsonProperty("paymentTermsId")
    protected UUID paymentTermsId;

    @JsonProperty("phoneNumber")
    protected String phoneNumber;

    @JsonProperty("taxLiable")
    protected Boolean taxLiable;

    @JsonProperty("taxRegistrationNumber")
    protected String taxRegistrationNumber;

    @JsonProperty("website")
    protected String website;

    @JsonProperty("currency")
    protected Currency currency;

    @JsonProperty("paymentMethod")
    protected PaymentMethod paymentMethod;

    @JsonProperty("paymentTerm")
    protected PaymentTerm paymentTerm;

    @JsonProperty("picture")
    protected List<Picture> picture;

    protected Vendor() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderVendor() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private PostalAddressType address;
        private BigDecimal balance;
        private String blocked;
        private String currencyCode;
        private UUID currencyId;
        private String displayName;
        private String email;
        private OffsetDateTime lastModifiedDateTime;
        private String number;
        private UUID paymentMethodId;
        private UUID paymentTermsId;
        private String phoneNumber;
        private Boolean taxLiable;
        private String taxRegistrationNumber;
        private String website;
        private Currency currency;
        private PaymentMethod paymentMethod;
        private PaymentTerm paymentTerm;
        private List<Picture> picture;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder address(PostalAddressType address) {
            this.address = address;
            this.changedFields = changedFields.add("address");
            return this;
        }

        public Builder balance(BigDecimal balance) {
            this.balance = balance;
            this.changedFields = changedFields.add("balance");
            return this;
        }

        public Builder blocked(String blocked) {
            this.blocked = blocked;
            this.changedFields = changedFields.add("blocked");
            return this;
        }

        public Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            this.changedFields = changedFields.add("currencyCode");
            return this;
        }

        public Builder currencyId(UUID currencyId) {
            this.currencyId = currencyId;
            this.changedFields = changedFields.add("currencyId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            this.changedFields = changedFields.add("email");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder number(String number) {
            this.number = number;
            this.changedFields = changedFields.add("number");
            return this;
        }

        public Builder paymentMethodId(UUID paymentMethodId) {
            this.paymentMethodId = paymentMethodId;
            this.changedFields = changedFields.add("paymentMethodId");
            return this;
        }

        public Builder paymentTermsId(UUID paymentTermsId) {
            this.paymentTermsId = paymentTermsId;
            this.changedFields = changedFields.add("paymentTermsId");
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            this.changedFields = changedFields.add("phoneNumber");
            return this;
        }

        public Builder taxLiable(Boolean taxLiable) {
            this.taxLiable = taxLiable;
            this.changedFields = changedFields.add("taxLiable");
            return this;
        }

        public Builder taxRegistrationNumber(String taxRegistrationNumber) {
            this.taxRegistrationNumber = taxRegistrationNumber;
            this.changedFields = changedFields.add("taxRegistrationNumber");
            return this;
        }

        public Builder website(String website) {
            this.website = website;
            this.changedFields = changedFields.add("website");
            return this;
        }

        public Builder currency(Currency currency) {
            this.currency = currency;
            this.changedFields = changedFields.add("currency");
            return this;
        }

        public Builder paymentMethod(PaymentMethod paymentMethod) {
            this.paymentMethod = paymentMethod;
            this.changedFields = changedFields.add("paymentMethod");
            return this;
        }

        public Builder paymentTerm(PaymentTerm paymentTerm) {
            this.paymentTerm = paymentTerm;
            this.changedFields = changedFields.add("paymentTerm");
            return this;
        }

        public Builder picture(List<Picture> picture) {
            this.picture = picture;
            this.changedFields = changedFields.add("picture");
            return this;
        }

        public Builder picture(Picture... picture) {
            return picture(Arrays.asList(picture));
        }

        public Vendor build() {
            Vendor _x = new Vendor();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.vendor";
            _x.id = id;
            _x.address = address;
            _x.balance = balance;
            _x.blocked = blocked;
            _x.currencyCode = currencyCode;
            _x.currencyId = currencyId;
            _x.displayName = displayName;
            _x.email = email;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.number = number;
            _x.paymentMethodId = paymentMethodId;
            _x.paymentTermsId = paymentTermsId;
            _x.phoneNumber = phoneNumber;
            _x.taxLiable = taxLiable;
            _x.taxRegistrationNumber = taxRegistrationNumber;
            _x.website = website;
            _x.currency = currency;
            _x.paymentMethod = paymentMethod;
            _x.paymentTerm = paymentTerm;
            _x.picture = picture;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="address")
    @JsonIgnore
    public Optional<PostalAddressType> getAddress() {
        return Optional.ofNullable(address);
    }

    public Vendor withAddress(PostalAddressType address) {
        Vendor _x = _copy();
        _x.changedFields = changedFields.add("address");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vendor");
        _x.address = address;
        return _x;
    }

    @Property(name="balance")
    @JsonIgnore
    public Optional<BigDecimal> getBalance() {
        return Optional.ofNullable(balance);
    }

    public Vendor withBalance(BigDecimal balance) {
        Vendor _x = _copy();
        _x.changedFields = changedFields.add("balance");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vendor");
        _x.balance = balance;
        return _x;
    }

    @Property(name="blocked")
    @JsonIgnore
    public Optional<String> getBlocked() {
        return Optional.ofNullable(blocked);
    }

    public Vendor withBlocked(String blocked) {
        Vendor _x = _copy();
        _x.changedFields = changedFields.add("blocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vendor");
        _x.blocked = blocked;
        return _x;
    }

    @Property(name="currencyCode")
    @JsonIgnore
    public Optional<String> getCurrencyCode() {
        return Optional.ofNullable(currencyCode);
    }

    public Vendor withCurrencyCode(String currencyCode) {
        Vendor _x = _copy();
        _x.changedFields = changedFields.add("currencyCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vendor");
        _x.currencyCode = currencyCode;
        return _x;
    }

    @Property(name="currencyId")
    @JsonIgnore
    public Optional<UUID> getCurrencyId() {
        return Optional.ofNullable(currencyId);
    }

    public Vendor withCurrencyId(UUID currencyId) {
        Vendor _x = _copy();
        _x.changedFields = changedFields.add("currencyId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vendor");
        _x.currencyId = currencyId;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Vendor withDisplayName(String displayName) {
        Vendor _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vendor");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="email")
    @JsonIgnore
    public Optional<String> getEmail() {
        return Optional.ofNullable(email);
    }

    public Vendor withEmail(String email) {
        Vendor _x = _copy();
        _x.changedFields = changedFields.add("email");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vendor");
        _x.email = email;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public Vendor withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        Vendor _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vendor");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="number")
    @JsonIgnore
    public Optional<String> getNumber() {
        return Optional.ofNullable(number);
    }

    public Vendor withNumber(String number) {
        Vendor _x = _copy();
        _x.changedFields = changedFields.add("number");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vendor");
        _x.number = number;
        return _x;
    }

    @Property(name="paymentMethodId")
    @JsonIgnore
    public Optional<UUID> getPaymentMethodId() {
        return Optional.ofNullable(paymentMethodId);
    }

    public Vendor withPaymentMethodId(UUID paymentMethodId) {
        Vendor _x = _copy();
        _x.changedFields = changedFields.add("paymentMethodId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vendor");
        _x.paymentMethodId = paymentMethodId;
        return _x;
    }

    @Property(name="paymentTermsId")
    @JsonIgnore
    public Optional<UUID> getPaymentTermsId() {
        return Optional.ofNullable(paymentTermsId);
    }

    public Vendor withPaymentTermsId(UUID paymentTermsId) {
        Vendor _x = _copy();
        _x.changedFields = changedFields.add("paymentTermsId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vendor");
        _x.paymentTermsId = paymentTermsId;
        return _x;
    }

    @Property(name="phoneNumber")
    @JsonIgnore
    public Optional<String> getPhoneNumber() {
        return Optional.ofNullable(phoneNumber);
    }

    public Vendor withPhoneNumber(String phoneNumber) {
        Vendor _x = _copy();
        _x.changedFields = changedFields.add("phoneNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vendor");
        _x.phoneNumber = phoneNumber;
        return _x;
    }

    @Property(name="taxLiable")
    @JsonIgnore
    public Optional<Boolean> getTaxLiable() {
        return Optional.ofNullable(taxLiable);
    }

    public Vendor withTaxLiable(Boolean taxLiable) {
        Vendor _x = _copy();
        _x.changedFields = changedFields.add("taxLiable");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vendor");
        _x.taxLiable = taxLiable;
        return _x;
    }

    @Property(name="taxRegistrationNumber")
    @JsonIgnore
    public Optional<String> getTaxRegistrationNumber() {
        return Optional.ofNullable(taxRegistrationNumber);
    }

    public Vendor withTaxRegistrationNumber(String taxRegistrationNumber) {
        Vendor _x = _copy();
        _x.changedFields = changedFields.add("taxRegistrationNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vendor");
        _x.taxRegistrationNumber = taxRegistrationNumber;
        return _x;
    }

    @Property(name="website")
    @JsonIgnore
    public Optional<String> getWebsite() {
        return Optional.ofNullable(website);
    }

    public Vendor withWebsite(String website) {
        Vendor _x = _copy();
        _x.changedFields = changedFields.add("website");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vendor");
        _x.website = website;
        return _x;
    }

    public Vendor withUnmappedField(String name, Object value) {
        Vendor _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="currency")
    @JsonIgnore
    public CurrencyRequest getCurrency() {
        return new CurrencyRequest(contextPath.addSegment("currency"), Optional.ofNullable(currency));
    }

    @NavigationProperty(name="paymentMethod")
    @JsonIgnore
    public PaymentMethodRequest getPaymentMethod() {
        return new PaymentMethodRequest(contextPath.addSegment("paymentMethod"), Optional.ofNullable(paymentMethod));
    }

    @NavigationProperty(name="paymentTerm")
    @JsonIgnore
    public PaymentTermRequest getPaymentTerm() {
        return new PaymentTermRequest(contextPath.addSegment("paymentTerm"), Optional.ofNullable(paymentTerm));
    }

    @NavigationProperty(name="picture")
    @JsonIgnore
    public PictureCollectionRequest getPicture() {
        return new PictureCollectionRequest(
                        contextPath.addSegment("picture"), Optional.ofNullable(picture));
    }

    public Vendor withCurrency(Currency currency) {
        Vendor _x = _copy();
        _x.changedFields = changedFields.add("currency");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vendor");
        _x.currency = currency;
        return _x;
    }

    public Vendor withPaymentMethod(PaymentMethod paymentMethod) {
        Vendor _x = _copy();
        _x.changedFields = changedFields.add("paymentMethod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vendor");
        _x.paymentMethod = paymentMethod;
        return _x;
    }

    public Vendor withPaymentTerm(PaymentTerm paymentTerm) {
        Vendor _x = _copy();
        _x.changedFields = changedFields.add("paymentTerm");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vendor");
        _x.paymentTerm = paymentTerm;
        return _x;
    }

    public Vendor withPicture(List<Picture> picture) {
        Vendor _x = _copy();
        _x.changedFields = changedFields.add("picture");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.vendor");
        _x.picture = picture;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Vendor patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Vendor _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Vendor put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Vendor _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Vendor _copy() {
        Vendor _x = new Vendor();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.address = address;
        _x.balance = balance;
        _x.blocked = blocked;
        _x.currencyCode = currencyCode;
        _x.currencyId = currencyId;
        _x.displayName = displayName;
        _x.email = email;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.number = number;
        _x.paymentMethodId = paymentMethodId;
        _x.paymentTermsId = paymentTermsId;
        _x.phoneNumber = phoneNumber;
        _x.taxLiable = taxLiable;
        _x.taxRegistrationNumber = taxRegistrationNumber;
        _x.website = website;
        _x.currency = currency;
        _x.paymentMethod = paymentMethod;
        _x.paymentTerm = paymentTerm;
        _x.picture = picture;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Vendor[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("address=");
        b.append(this.address);
        b.append(", ");
        b.append("balance=");
        b.append(this.balance);
        b.append(", ");
        b.append("blocked=");
        b.append(this.blocked);
        b.append(", ");
        b.append("currencyCode=");
        b.append(this.currencyCode);
        b.append(", ");
        b.append("currencyId=");
        b.append(this.currencyId);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("email=");
        b.append(this.email);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("number=");
        b.append(this.number);
        b.append(", ");
        b.append("paymentMethodId=");
        b.append(this.paymentMethodId);
        b.append(", ");
        b.append("paymentTermsId=");
        b.append(this.paymentTermsId);
        b.append(", ");
        b.append("phoneNumber=");
        b.append(this.phoneNumber);
        b.append(", ");
        b.append("taxLiable=");
        b.append(this.taxLiable);
        b.append(", ");
        b.append("taxRegistrationNumber=");
        b.append(this.taxRegistrationNumber);
        b.append(", ");
        b.append("website=");
        b.append(this.website);
        b.append(", ");
        b.append("currency=");
        b.append(this.currency);
        b.append(", ");
        b.append("paymentMethod=");
        b.append(this.paymentMethod);
        b.append(", ");
        b.append("paymentTerm=");
        b.append(this.paymentTerm);
        b.append(", ");
        b.append("picture=");
        b.append(this.picture);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
