package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.UserFlowLanguagePageCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "isEnabled", 
    "defaultPages", 
    "overridesPages"})
@JsonInclude(Include.NON_NULL)
public class UserFlowLanguageConfiguration extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userFlowLanguageConfiguration";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("isEnabled")
    protected Boolean isEnabled;

    @JsonProperty("defaultPages")
    protected List<UserFlowLanguagePage> defaultPages;

    @JsonProperty("overridesPages")
    protected List<UserFlowLanguagePage> overridesPages;

    protected UserFlowLanguageConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserFlowLanguageConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private Boolean isEnabled;
        private List<UserFlowLanguagePage> defaultPages;
        private List<UserFlowLanguagePage> overridesPages;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.changedFields = changedFields.add("isEnabled");
            return this;
        }

        public Builder defaultPages(List<UserFlowLanguagePage> defaultPages) {
            this.defaultPages = defaultPages;
            this.changedFields = changedFields.add("defaultPages");
            return this;
        }

        public Builder defaultPages(UserFlowLanguagePage... defaultPages) {
            return defaultPages(Arrays.asList(defaultPages));
        }

        public Builder overridesPages(List<UserFlowLanguagePage> overridesPages) {
            this.overridesPages = overridesPages;
            this.changedFields = changedFields.add("overridesPages");
            return this;
        }

        public Builder overridesPages(UserFlowLanguagePage... overridesPages) {
            return overridesPages(Arrays.asList(overridesPages));
        }

        public UserFlowLanguageConfiguration build() {
            UserFlowLanguageConfiguration _x = new UserFlowLanguageConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userFlowLanguageConfiguration";
            _x.id = id;
            _x.displayName = displayName;
            _x.isEnabled = isEnabled;
            _x.defaultPages = defaultPages;
            _x.overridesPages = overridesPages;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public UserFlowLanguageConfiguration withDisplayName(String displayName) {
        UserFlowLanguageConfiguration _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userFlowLanguageConfiguration");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="isEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsEnabled() {
        return Optional.ofNullable(isEnabled);
    }

    public UserFlowLanguageConfiguration withIsEnabled(Boolean isEnabled) {
        UserFlowLanguageConfiguration _x = _copy();
        _x.changedFields = changedFields.add("isEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userFlowLanguageConfiguration");
        _x.isEnabled = isEnabled;
        return _x;
    }

    public UserFlowLanguageConfiguration withUnmappedField(String name, Object value) {
        UserFlowLanguageConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="defaultPages")
    @JsonIgnore
    public UserFlowLanguagePageCollectionRequest getDefaultPages() {
        return new UserFlowLanguagePageCollectionRequest(
                        contextPath.addSegment("defaultPages"), Optional.ofNullable(defaultPages));
    }

    @NavigationProperty(name="overridesPages")
    @JsonIgnore
    public UserFlowLanguagePageCollectionRequest getOverridesPages() {
        return new UserFlowLanguagePageCollectionRequest(
                        contextPath.addSegment("overridesPages"), Optional.ofNullable(overridesPages));
    }

    public UserFlowLanguageConfiguration withDefaultPages(List<UserFlowLanguagePage> defaultPages) {
        UserFlowLanguageConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defaultPages");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userFlowLanguageConfiguration");
        _x.defaultPages = defaultPages;
        return _x;
    }

    public UserFlowLanguageConfiguration withOverridesPages(List<UserFlowLanguagePage> overridesPages) {
        UserFlowLanguageConfiguration _x = _copy();
        _x.changedFields = changedFields.add("overridesPages");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userFlowLanguageConfiguration");
        _x.overridesPages = overridesPages;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserFlowLanguageConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserFlowLanguageConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserFlowLanguageConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserFlowLanguageConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserFlowLanguageConfiguration _copy() {
        UserFlowLanguageConfiguration _x = new UserFlowLanguageConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.isEnabled = isEnabled;
        _x.defaultPages = defaultPages;
        _x.overridesPages = overridesPages;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserFlowLanguageConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isEnabled=");
        b.append(this.isEnabled);
        b.append(", ");
        b.append("defaultPages=");
        b.append(this.defaultPages);
        b.append(", ");
        b.append("overridesPages=");
        b.append(this.overridesPages);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
