package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsWorkFromAnywhereDeviceCollectionRequest;


/**
 * <i>“The user experience analytics metric for work from anywhere report”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "metricDevices"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsWorkFromAnywhereMetric extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereMetric";
    }

    @JsonProperty("metricDevices")
    protected List<UserExperienceAnalyticsWorkFromAnywhereDevice> metricDevices;

    protected UserExperienceAnalyticsWorkFromAnywhereMetric() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserExperienceAnalyticsWorkFromAnywhereMetric() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<UserExperienceAnalyticsWorkFromAnywhereDevice> metricDevices;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The work from anywhere metric devices.”</i>
         * 
         * @param metricDevices
         *            value of {@code metricDevices} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder metricDevices(List<UserExperienceAnalyticsWorkFromAnywhereDevice> metricDevices) {
            this.metricDevices = metricDevices;
            this.changedFields = changedFields.add("metricDevices");
            return this;
        }

        /**
         * <i>“The work from anywhere metric devices.”</i>
         * 
         * @param metricDevices
         *            value of {@code metricDevices} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder metricDevices(UserExperienceAnalyticsWorkFromAnywhereDevice... metricDevices) {
            return metricDevices(Arrays.asList(metricDevices));
        }

        public UserExperienceAnalyticsWorkFromAnywhereMetric build() {
            UserExperienceAnalyticsWorkFromAnywhereMetric _x = new UserExperienceAnalyticsWorkFromAnywhereMetric();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereMetric";
            _x.id = id;
            _x.metricDevices = metricDevices;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public UserExperienceAnalyticsWorkFromAnywhereMetric withUnmappedField(String name, Object value) {
        UserExperienceAnalyticsWorkFromAnywhereMetric _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The work from anywhere metric devices.”</i>
     * 
     * @return navigational property metricDevices
     */
    @NavigationProperty(name="metricDevices")
    @JsonIgnore
    public UserExperienceAnalyticsWorkFromAnywhereDeviceCollectionRequest getMetricDevices() {
        return new UserExperienceAnalyticsWorkFromAnywhereDeviceCollectionRequest(
                        contextPath.addSegment("metricDevices"), Optional.ofNullable(metricDevices));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code metricDevices}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The work from anywhere metric devices.”</i>
     * 
     * @param metricDevices
     *            new value of {@code metricDevices} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code metricDevices} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereMetric withMetricDevices(List<UserExperienceAnalyticsWorkFromAnywhereDevice> metricDevices) {
        UserExperienceAnalyticsWorkFromAnywhereMetric _x = _copy();
        _x.changedFields = changedFields.add("metricDevices");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereMetric");
        _x.metricDevices = metricDevices;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsWorkFromAnywhereMetric patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsWorkFromAnywhereMetric _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsWorkFromAnywhereMetric put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsWorkFromAnywhereMetric _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserExperienceAnalyticsWorkFromAnywhereMetric _copy() {
        UserExperienceAnalyticsWorkFromAnywhereMetric _x = new UserExperienceAnalyticsWorkFromAnywhereMetric();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.metricDevices = metricDevices;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsWorkFromAnywhereMetric[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("metricDevices=");
        b.append(this.metricDevices);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
