package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Double;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“The user experience analytics hardware readiness entity contains account level
 * information about hardware blockers for windows upgrade.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "osCheckFailedPercentage", 
    "processor64BitCheckFailedPercentage", 
    "processorCoreCountCheckFailedPercentage", 
    "processorFamilyCheckFailedPercentage", 
    "processorSpeedCheckFailedPercentage", 
    "ramCheckFailedPercentage", 
    "secureBootCheckFailedPercentage", 
    "storageCheckFailedPercentage", 
    "totalDeviceCount", 
    "tpmCheckFailedPercentage", 
    "upgradeEligibleDeviceCount"})
@JsonInclude(Include.NON_NULL)
public class UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric";
    }

    @JsonProperty("osCheckFailedPercentage")
    protected Double osCheckFailedPercentage;

    @JsonProperty("processor64BitCheckFailedPercentage")
    protected Double processor64BitCheckFailedPercentage;

    @JsonProperty("processorCoreCountCheckFailedPercentage")
    protected Double processorCoreCountCheckFailedPercentage;

    @JsonProperty("processorFamilyCheckFailedPercentage")
    protected Double processorFamilyCheckFailedPercentage;

    @JsonProperty("processorSpeedCheckFailedPercentage")
    protected Double processorSpeedCheckFailedPercentage;

    @JsonProperty("ramCheckFailedPercentage")
    protected Double ramCheckFailedPercentage;

    @JsonProperty("secureBootCheckFailedPercentage")
    protected Double secureBootCheckFailedPercentage;

    @JsonProperty("storageCheckFailedPercentage")
    protected Double storageCheckFailedPercentage;

    @JsonProperty("totalDeviceCount")
    protected Integer totalDeviceCount;

    @JsonProperty("tpmCheckFailedPercentage")
    protected Double tpmCheckFailedPercentage;

    @JsonProperty("upgradeEligibleDeviceCount")
    protected Integer upgradeEligibleDeviceCount;

    protected UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Double osCheckFailedPercentage;
        private Double processor64BitCheckFailedPercentage;
        private Double processorCoreCountCheckFailedPercentage;
        private Double processorFamilyCheckFailedPercentage;
        private Double processorSpeedCheckFailedPercentage;
        private Double ramCheckFailedPercentage;
        private Double secureBootCheckFailedPercentage;
        private Double storageCheckFailedPercentage;
        private Integer totalDeviceCount;
        private Double tpmCheckFailedPercentage;
        private Integer upgradeEligibleDeviceCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The percentage of devices for which OS check has failed. Valid values -1.
         * 79769313486232E+308 to 1.79769313486232E+308”</i>
         * 
         * @param osCheckFailedPercentage
         *            value of {@code osCheckFailedPercentage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osCheckFailedPercentage(Double osCheckFailedPercentage) {
            this.osCheckFailedPercentage = osCheckFailedPercentage;
            this.changedFields = changedFields.add("osCheckFailedPercentage");
            return this;
        }

        /**
         * <i>“The percentage of devices for which processor hardware 64-bit architecture check
         * has failed. Valid values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
         * 
         * @param processor64BitCheckFailedPercentage
         *            value of {@code processor64BitCheckFailedPercentage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder processor64BitCheckFailedPercentage(Double processor64BitCheckFailedPercentage) {
            this.processor64BitCheckFailedPercentage = processor64BitCheckFailedPercentage;
            this.changedFields = changedFields.add("processor64BitCheckFailedPercentage");
            return this;
        }

        /**
         * <i>“The percentage of devices for which processor hardware core count check has
         * failed. Valid values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
         * 
         * @param processorCoreCountCheckFailedPercentage
         *            value of {@code processorCoreCountCheckFailedPercentage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder processorCoreCountCheckFailedPercentage(Double processorCoreCountCheckFailedPercentage) {
            this.processorCoreCountCheckFailedPercentage = processorCoreCountCheckFailedPercentage;
            this.changedFields = changedFields.add("processorCoreCountCheckFailedPercentage");
            return this;
        }

        /**
         * <i>“The percentage of devices for which processor hardware family check has failed.
         * Valid values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
         * 
         * @param processorFamilyCheckFailedPercentage
         *            value of {@code processorFamilyCheckFailedPercentage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder processorFamilyCheckFailedPercentage(Double processorFamilyCheckFailedPercentage) {
            this.processorFamilyCheckFailedPercentage = processorFamilyCheckFailedPercentage;
            this.changedFields = changedFields.add("processorFamilyCheckFailedPercentage");
            return this;
        }

        /**
         * <i>“The percentage of devices for which processor hardware speed check has failed.
         * Valid values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
         * 
         * @param processorSpeedCheckFailedPercentage
         *            value of {@code processorSpeedCheckFailedPercentage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder processorSpeedCheckFailedPercentage(Double processorSpeedCheckFailedPercentage) {
            this.processorSpeedCheckFailedPercentage = processorSpeedCheckFailedPercentage;
            this.changedFields = changedFields.add("processorSpeedCheckFailedPercentage");
            return this;
        }

        /**
         * <i>“The percentage of devices for which RAM hardware check has failed. Valid values
         * -1.79769313486232E+308 to 1.79769313486232E+308”</i>
         * 
         * @param ramCheckFailedPercentage
         *            value of {@code ramCheckFailedPercentage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ramCheckFailedPercentage(Double ramCheckFailedPercentage) {
            this.ramCheckFailedPercentage = ramCheckFailedPercentage;
            this.changedFields = changedFields.add("ramCheckFailedPercentage");
            return this;
        }

        /**
         * <i>“The percentage of devices for which secure boot hardware check has failed. Valid
         * values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
         * 
         * @param secureBootCheckFailedPercentage
         *            value of {@code secureBootCheckFailedPercentage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder secureBootCheckFailedPercentage(Double secureBootCheckFailedPercentage) {
            this.secureBootCheckFailedPercentage = secureBootCheckFailedPercentage;
            this.changedFields = changedFields.add("secureBootCheckFailedPercentage");
            return this;
        }

        /**
         * <i>“The percentage of devices for which storage hardware check has failed. Valid
         * values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
         * 
         * @param storageCheckFailedPercentage
         *            value of {@code storageCheckFailedPercentage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder storageCheckFailedPercentage(Double storageCheckFailedPercentage) {
            this.storageCheckFailedPercentage = storageCheckFailedPercentage;
            this.changedFields = changedFields.add("storageCheckFailedPercentage");
            return this;
        }

        /**
         * <i>“The count of total devices in an organization. Valid values -2147483648 to
         * 2147483647”</i>
         * 
         * @param totalDeviceCount
         *            value of {@code totalDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder totalDeviceCount(Integer totalDeviceCount) {
            this.totalDeviceCount = totalDeviceCount;
            this.changedFields = changedFields.add("totalDeviceCount");
            return this;
        }

        /**
         * <i>“The percentage of devices for which Trusted Platform Module (TPM) hardware check
         * has failed. Valid values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
         * 
         * @param tpmCheckFailedPercentage
         *            value of {@code tpmCheckFailedPercentage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tpmCheckFailedPercentage(Double tpmCheckFailedPercentage) {
            this.tpmCheckFailedPercentage = tpmCheckFailedPercentage;
            this.changedFields = changedFields.add("tpmCheckFailedPercentage");
            return this;
        }

        /**
         * <i>“The count of devices in an organization eligible for windows upgrade. Valid
         * values -2147483648 to 2147483647”</i>
         * 
         * @param upgradeEligibleDeviceCount
         *            value of {@code upgradeEligibleDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder upgradeEligibleDeviceCount(Integer upgradeEligibleDeviceCount) {
            this.upgradeEligibleDeviceCount = upgradeEligibleDeviceCount;
            this.changedFields = changedFields.add("upgradeEligibleDeviceCount");
            return this;
        }

        public UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric build() {
            UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric _x = new UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric";
            _x.id = id;
            _x.osCheckFailedPercentage = osCheckFailedPercentage;
            _x.processor64BitCheckFailedPercentage = processor64BitCheckFailedPercentage;
            _x.processorCoreCountCheckFailedPercentage = processorCoreCountCheckFailedPercentage;
            _x.processorFamilyCheckFailedPercentage = processorFamilyCheckFailedPercentage;
            _x.processorSpeedCheckFailedPercentage = processorSpeedCheckFailedPercentage;
            _x.ramCheckFailedPercentage = ramCheckFailedPercentage;
            _x.secureBootCheckFailedPercentage = secureBootCheckFailedPercentage;
            _x.storageCheckFailedPercentage = storageCheckFailedPercentage;
            _x.totalDeviceCount = totalDeviceCount;
            _x.tpmCheckFailedPercentage = tpmCheckFailedPercentage;
            _x.upgradeEligibleDeviceCount = upgradeEligibleDeviceCount;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The percentage of devices for which OS check has failed. Valid values -1.
     * 79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @return property osCheckFailedPercentage
     */
    @Property(name="osCheckFailedPercentage")
    @JsonIgnore
    public Optional<Double> getOsCheckFailedPercentage() {
        return Optional.ofNullable(osCheckFailedPercentage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * osCheckFailedPercentage} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The percentage of devices for which OS check has failed. Valid values -1.
     * 79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @param osCheckFailedPercentage
     *            new value of {@code osCheckFailedPercentage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osCheckFailedPercentage} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric withOsCheckFailedPercentage(Double osCheckFailedPercentage) {
        UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric _x = _copy();
        _x.changedFields = changedFields.add("osCheckFailedPercentage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric");
        _x.osCheckFailedPercentage = osCheckFailedPercentage;
        return _x;
    }

    /**
     * <i>“The percentage of devices for which processor hardware 64-bit architecture check
     * has failed. Valid values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @return property processor64BitCheckFailedPercentage
     */
    @Property(name="processor64BitCheckFailedPercentage")
    @JsonIgnore
    public Optional<Double> getProcessor64BitCheckFailedPercentage() {
        return Optional.ofNullable(processor64BitCheckFailedPercentage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * processor64BitCheckFailedPercentage} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The percentage of devices for which processor hardware 64-bit architecture check
     * has failed. Valid values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @param processor64BitCheckFailedPercentage
     *            new value of {@code processor64BitCheckFailedPercentage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code processor64BitCheckFailedPercentage} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric withProcessor64BitCheckFailedPercentage(Double processor64BitCheckFailedPercentage) {
        UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric _x = _copy();
        _x.changedFields = changedFields.add("processor64BitCheckFailedPercentage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric");
        _x.processor64BitCheckFailedPercentage = processor64BitCheckFailedPercentage;
        return _x;
    }

    /**
     * <i>“The percentage of devices for which processor hardware core count check has
     * failed. Valid values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @return property processorCoreCountCheckFailedPercentage
     */
    @Property(name="processorCoreCountCheckFailedPercentage")
    @JsonIgnore
    public Optional<Double> getProcessorCoreCountCheckFailedPercentage() {
        return Optional.ofNullable(processorCoreCountCheckFailedPercentage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * processorCoreCountCheckFailedPercentage} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The percentage of devices for which processor hardware core count check has
     * failed. Valid values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @param processorCoreCountCheckFailedPercentage
     *            new value of {@code processorCoreCountCheckFailedPercentage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code processorCoreCountCheckFailedPercentage} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric withProcessorCoreCountCheckFailedPercentage(Double processorCoreCountCheckFailedPercentage) {
        UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric _x = _copy();
        _x.changedFields = changedFields.add("processorCoreCountCheckFailedPercentage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric");
        _x.processorCoreCountCheckFailedPercentage = processorCoreCountCheckFailedPercentage;
        return _x;
    }

    /**
     * <i>“The percentage of devices for which processor hardware family check has failed.
     * Valid values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @return property processorFamilyCheckFailedPercentage
     */
    @Property(name="processorFamilyCheckFailedPercentage")
    @JsonIgnore
    public Optional<Double> getProcessorFamilyCheckFailedPercentage() {
        return Optional.ofNullable(processorFamilyCheckFailedPercentage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * processorFamilyCheckFailedPercentage} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The percentage of devices for which processor hardware family check has failed.
     * Valid values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @param processorFamilyCheckFailedPercentage
     *            new value of {@code processorFamilyCheckFailedPercentage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code processorFamilyCheckFailedPercentage} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric withProcessorFamilyCheckFailedPercentage(Double processorFamilyCheckFailedPercentage) {
        UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric _x = _copy();
        _x.changedFields = changedFields.add("processorFamilyCheckFailedPercentage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric");
        _x.processorFamilyCheckFailedPercentage = processorFamilyCheckFailedPercentage;
        return _x;
    }

    /**
     * <i>“The percentage of devices for which processor hardware speed check has failed.
     * Valid values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @return property processorSpeedCheckFailedPercentage
     */
    @Property(name="processorSpeedCheckFailedPercentage")
    @JsonIgnore
    public Optional<Double> getProcessorSpeedCheckFailedPercentage() {
        return Optional.ofNullable(processorSpeedCheckFailedPercentage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * processorSpeedCheckFailedPercentage} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The percentage of devices for which processor hardware speed check has failed.
     * Valid values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @param processorSpeedCheckFailedPercentage
     *            new value of {@code processorSpeedCheckFailedPercentage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code processorSpeedCheckFailedPercentage} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric withProcessorSpeedCheckFailedPercentage(Double processorSpeedCheckFailedPercentage) {
        UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric _x = _copy();
        _x.changedFields = changedFields.add("processorSpeedCheckFailedPercentage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric");
        _x.processorSpeedCheckFailedPercentage = processorSpeedCheckFailedPercentage;
        return _x;
    }

    /**
     * <i>“The percentage of devices for which RAM hardware check has failed. Valid values
     * -1.79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @return property ramCheckFailedPercentage
     */
    @Property(name="ramCheckFailedPercentage")
    @JsonIgnore
    public Optional<Double> getRamCheckFailedPercentage() {
        return Optional.ofNullable(ramCheckFailedPercentage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * ramCheckFailedPercentage} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The percentage of devices for which RAM hardware check has failed. Valid values
     * -1.79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @param ramCheckFailedPercentage
     *            new value of {@code ramCheckFailedPercentage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ramCheckFailedPercentage} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric withRamCheckFailedPercentage(Double ramCheckFailedPercentage) {
        UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric _x = _copy();
        _x.changedFields = changedFields.add("ramCheckFailedPercentage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric");
        _x.ramCheckFailedPercentage = ramCheckFailedPercentage;
        return _x;
    }

    /**
     * <i>“The percentage of devices for which secure boot hardware check has failed. Valid
     * values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @return property secureBootCheckFailedPercentage
     */
    @Property(name="secureBootCheckFailedPercentage")
    @JsonIgnore
    public Optional<Double> getSecureBootCheckFailedPercentage() {
        return Optional.ofNullable(secureBootCheckFailedPercentage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * secureBootCheckFailedPercentage} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The percentage of devices for which secure boot hardware check has failed. Valid
     * values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @param secureBootCheckFailedPercentage
     *            new value of {@code secureBootCheckFailedPercentage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code secureBootCheckFailedPercentage} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric withSecureBootCheckFailedPercentage(Double secureBootCheckFailedPercentage) {
        UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric _x = _copy();
        _x.changedFields = changedFields.add("secureBootCheckFailedPercentage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric");
        _x.secureBootCheckFailedPercentage = secureBootCheckFailedPercentage;
        return _x;
    }

    /**
     * <i>“The percentage of devices for which storage hardware check has failed. Valid
     * values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @return property storageCheckFailedPercentage
     */
    @Property(name="storageCheckFailedPercentage")
    @JsonIgnore
    public Optional<Double> getStorageCheckFailedPercentage() {
        return Optional.ofNullable(storageCheckFailedPercentage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * storageCheckFailedPercentage} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The percentage of devices for which storage hardware check has failed. Valid
     * values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @param storageCheckFailedPercentage
     *            new value of {@code storageCheckFailedPercentage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code storageCheckFailedPercentage} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric withStorageCheckFailedPercentage(Double storageCheckFailedPercentage) {
        UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric _x = _copy();
        _x.changedFields = changedFields.add("storageCheckFailedPercentage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric");
        _x.storageCheckFailedPercentage = storageCheckFailedPercentage;
        return _x;
    }

    /**
     * <i>“The count of total devices in an organization. Valid values -2147483648 to
     * 2147483647”</i>
     * 
     * @return property totalDeviceCount
     */
    @Property(name="totalDeviceCount")
    @JsonIgnore
    public Optional<Integer> getTotalDeviceCount() {
        return Optional.ofNullable(totalDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code totalDeviceCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The count of total devices in an organization. Valid values -2147483648 to
     * 2147483647”</i>
     * 
     * @param totalDeviceCount
     *            new value of {@code totalDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code totalDeviceCount} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric withTotalDeviceCount(Integer totalDeviceCount) {
        UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric _x = _copy();
        _x.changedFields = changedFields.add("totalDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric");
        _x.totalDeviceCount = totalDeviceCount;
        return _x;
    }

    /**
     * <i>“The percentage of devices for which Trusted Platform Module (TPM) hardware check
     * has failed. Valid values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @return property tpmCheckFailedPercentage
     */
    @Property(name="tpmCheckFailedPercentage")
    @JsonIgnore
    public Optional<Double> getTpmCheckFailedPercentage() {
        return Optional.ofNullable(tpmCheckFailedPercentage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * tpmCheckFailedPercentage} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The percentage of devices for which Trusted Platform Module (TPM) hardware check
     * has failed. Valid values -1.79769313486232E+308 to 1.79769313486232E+308”</i>
     * 
     * @param tpmCheckFailedPercentage
     *            new value of {@code tpmCheckFailedPercentage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code tpmCheckFailedPercentage} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric withTpmCheckFailedPercentage(Double tpmCheckFailedPercentage) {
        UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric _x = _copy();
        _x.changedFields = changedFields.add("tpmCheckFailedPercentage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric");
        _x.tpmCheckFailedPercentage = tpmCheckFailedPercentage;
        return _x;
    }

    /**
     * <i>“The count of devices in an organization eligible for windows upgrade. Valid
     * values -2147483648 to 2147483647”</i>
     * 
     * @return property upgradeEligibleDeviceCount
     */
    @Property(name="upgradeEligibleDeviceCount")
    @JsonIgnore
    public Optional<Integer> getUpgradeEligibleDeviceCount() {
        return Optional.ofNullable(upgradeEligibleDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * upgradeEligibleDeviceCount} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The count of devices in an organization eligible for windows upgrade. Valid
     * values -2147483648 to 2147483647”</i>
     * 
     * @param upgradeEligibleDeviceCount
     *            new value of {@code upgradeEligibleDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code upgradeEligibleDeviceCount} field changed
     */
    public UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric withUpgradeEligibleDeviceCount(Integer upgradeEligibleDeviceCount) {
        UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric _x = _copy();
        _x.changedFields = changedFields.add("upgradeEligibleDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric");
        _x.upgradeEligibleDeviceCount = upgradeEligibleDeviceCount;
        return _x;
    }

    public UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric withUnmappedField(String name, Object value) {
        UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric _copy() {
        UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric _x = new UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.osCheckFailedPercentage = osCheckFailedPercentage;
        _x.processor64BitCheckFailedPercentage = processor64BitCheckFailedPercentage;
        _x.processorCoreCountCheckFailedPercentage = processorCoreCountCheckFailedPercentage;
        _x.processorFamilyCheckFailedPercentage = processorFamilyCheckFailedPercentage;
        _x.processorSpeedCheckFailedPercentage = processorSpeedCheckFailedPercentage;
        _x.ramCheckFailedPercentage = ramCheckFailedPercentage;
        _x.secureBootCheckFailedPercentage = secureBootCheckFailedPercentage;
        _x.storageCheckFailedPercentage = storageCheckFailedPercentage;
        _x.totalDeviceCount = totalDeviceCount;
        _x.tpmCheckFailedPercentage = tpmCheckFailedPercentage;
        _x.upgradeEligibleDeviceCount = upgradeEligibleDeviceCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("osCheckFailedPercentage=");
        b.append(this.osCheckFailedPercentage);
        b.append(", ");
        b.append("processor64BitCheckFailedPercentage=");
        b.append(this.processor64BitCheckFailedPercentage);
        b.append(", ");
        b.append("processorCoreCountCheckFailedPercentage=");
        b.append(this.processorCoreCountCheckFailedPercentage);
        b.append(", ");
        b.append("processorFamilyCheckFailedPercentage=");
        b.append(this.processorFamilyCheckFailedPercentage);
        b.append(", ");
        b.append("processorSpeedCheckFailedPercentage=");
        b.append(this.processorSpeedCheckFailedPercentage);
        b.append(", ");
        b.append("ramCheckFailedPercentage=");
        b.append(this.ramCheckFailedPercentage);
        b.append(", ");
        b.append("secureBootCheckFailedPercentage=");
        b.append(this.secureBootCheckFailedPercentage);
        b.append(", ");
        b.append("storageCheckFailedPercentage=");
        b.append(this.storageCheckFailedPercentage);
        b.append(", ");
        b.append("totalDeviceCount=");
        b.append(this.totalDeviceCount);
        b.append(", ");
        b.append("tpmCheckFailedPercentage=");
        b.append(this.tpmCheckFailedPercentage);
        b.append(", ");
        b.append("upgradeEligibleDeviceCount=");
        b.append(this.upgradeEligibleDeviceCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
